import { Collection, Document as MongoDBDocument } from "mongodb";
import { BaseListChatMessageHistory } from "@langchain/core/chat_history";
import { BaseMessage } from "@langchain/core/messages";
export interface MongoDBChatMessageHistoryInput {
    collection: Collection<MongoDBDocument>;
    sessionId: string;
}
/**
 * @example
 * ```typescript
 * const chatHistory = new MongoDBChatMessageHistory({
 *   collection: myCollection,
 *   sessionId: 'unique-session-id',
 * });
 * const messages = await chatHistory.getMessages();
 * await chatHistory.clear();
 * ```
 */
export declare class MongoDBChatMessageHistory extends BaseListChatMessageHistory {
    lc_namespace: string[];
    private collection;
    private sessionId;
    private idKey;
    constructor({ collection, sessionId }: MongoDBChatMessageHistoryInput);
    getMessages(): Promise<BaseMessage[]>;
    addMessage(message: BaseMessage): Promise<void>;
    clear(): Promise<void>;
}
