"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports._mistralContentChunkToMessageContentComplex = exports._convertToolCallIdToMistralCompatible = exports._isValidMistralToolCallId = void 0;
// Mistral enforces a specific pattern for tool call IDs
const TOOL_CALL_ID_PATTERN = /^[a-zA-Z0-9]{9}$/;
function _isValidMistralToolCallId(toolCallId) {
    return TOOL_CALL_ID_PATTERN.test(toolCallId);
}
exports._isValidMistralToolCallId = _isValidMistralToolCallId;
function _base62Encode(num) {
    let numCopy = num;
    const base62 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    if (numCopy === 0)
        return base62[0];
    const arr = [];
    const base = base62.length;
    while (numCopy) {
        arr.push(base62[numCopy % base]);
        numCopy = Math.floor(numCopy / base);
    }
    return arr.reverse().join("");
}
function _simpleHash(str) {
    let hash = 0;
    for (let i = 0; i < str.length; i += 1) {
        const char = str.charCodeAt(i);
        hash = (hash << 5) - hash + char;
        hash &= hash; // Convert to 32-bit integer
    }
    return Math.abs(hash);
}
function _convertToolCallIdToMistralCompatible(toolCallId) {
    if (_isValidMistralToolCallId(toolCallId)) {
        return toolCallId;
    }
    else {
        const hash = _simpleHash(toolCallId);
        const base62Str = _base62Encode(hash);
        if (base62Str.length >= 9) {
            return base62Str.slice(0, 9);
        }
        else {
            return base62Str.padStart(9, "0");
        }
    }
}
exports._convertToolCallIdToMistralCompatible = _convertToolCallIdToMistralCompatible;
function _mistralContentChunkToMessageContentComplex(content) {
    if (!content) {
        return "";
    }
    if (typeof content === "string") {
        return content;
    }
    return content.map((contentChunk) => {
        // Only Mistral ImageURLChunks need conversion to MessageContentComplex
        if (contentChunk.type === "image_url") {
            if (typeof contentChunk.imageUrl !== "string" &&
                contentChunk.imageUrl?.detail) {
                const { detail } = contentChunk.imageUrl;
                // Mistral detail can be any string, but MessageContentComplex only supports
                // detail to be "high", "auto", or "low"
                if (detail !== "high" && detail !== "auto" && detail !== "low") {
                    return {
                        type: contentChunk.type,
                        image_url: {
                            url: contentChunk.imageUrl.url,
                        },
                    };
                }
            }
            return {
                type: contentChunk.type,
                image_url: contentChunk.imageUrl,
            };
        }
        return contentChunk;
    });
}
exports._mistralContentChunkToMessageContentComplex = _mistralContentChunkToMessageContentComplex;
