import { Command, Interrupt } from "./constants.js";
export type BaseLangGraphErrorFields = {
    lc_error_code?: "GRAPH_RECURSION_LIMIT" | "INVALID_CONCURRENT_GRAPH_UPDATE" | "INVALID_GRAPH_NODE_RETURN_VALUE" | "MULTIPLE_SUBGRAPHS" | "UNREACHABLE_NODE";
};
export declare class BaseLangGraphError extends Error {
    lc_error_code?: string;
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
}
export declare class GraphBubbleUp extends BaseLangGraphError {
    get is_bubble_up(): boolean;
}
export declare class GraphRecursionError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
export declare class GraphValueError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
export declare class GraphInterrupt extends GraphBubbleUp {
    interrupts: Interrupt[];
    constructor(interrupts?: Interrupt[], fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
/** Raised by a node to interrupt execution. */
export declare class NodeInterrupt extends GraphInterrupt {
    constructor(message: any, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
export declare class ParentCommand extends GraphBubbleUp {
    command: Command;
    constructor(command: Command);
    static get unminifiable_name(): string;
}
export declare function isParentCommand(e?: unknown): e is ParentCommand;
export declare function isGraphBubbleUp(e?: unknown): e is GraphBubbleUp;
export declare function isGraphInterrupt(e?: unknown): e is GraphInterrupt;
export declare class EmptyInputError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
export declare class EmptyChannelError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
export declare class InvalidUpdateError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
/**
 * @deprecated This exception type is no longer thrown.
 */
export declare class MultipleSubgraphsError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
export declare class UnreachableNodeError extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
/**
 * Exception raised when an error occurs in the remote graph.
 */
export declare class RemoteException extends BaseLangGraphError {
    constructor(message?: string, fields?: BaseLangGraphErrorFields);
    static get unminifiable_name(): string;
}
/**
 * Used for subgraph detection.
 */
export declare const getSubgraphsSeenSet: () => any;
