import { GoogleAbstractedClient, GoogleBaseLLM, GoogleBaseLLMInput } from "@langchain/google-common";
import { GoogleAuthOptions } from "google-auth-library";
/**
 * Input to LLM class.
 */
export interface GoogleLLMInput extends GoogleBaseLLMInput<GoogleAuthOptions> {
}
/**
 * Integration with a Google LLM.
 */
export declare class GoogleLLM extends GoogleBaseLLM<GoogleAuthOptions> implements GoogleLLMInput {
    static lc_name(): string;
    lc_serializable: boolean;
    constructor(fields?: GoogleLLMInput);
    buildAbstractedClient(fields: GoogleBaseLLMInput<GoogleAuthOptions> | undefined): GoogleAbstractedClient;
}
