import { ChatGoogleBase, ChatGoogleBaseInput, GoogleAbstractedClient, GoogleBaseLLMInput } from "@langchain/google-common";
import { GoogleAuthOptions } from "google-auth-library";
/**
 * Input to chat model class.
 */
export interface ChatGoogleInput extends ChatGoogleBaseInput<GoogleAuthOptions> {
}
/**
 * Integration with a Google chat model.
 */
export declare class ChatGoogle extends ChatGoogleBase<GoogleAuthOptions> implements ChatGoogleInput {
    static lc_name(): string;
    constructor(fields?: ChatGoogleInput);
    buildAbstractedClient(fields: GoogleBaseLLMInput<GoogleAuthOptions> | undefined): GoogleAbstractedClient;
}
