import { GooglePlatformType } from "./types.js";
export type GoogleAbstractedClientOpsMethod = "GET" | "POST" | "DELETE";
export type GoogleAbstractedClientOpsResponseType = "json" | "stream" | "blob";
export type GoogleAbstractedClientOps = {
    url?: string;
    method?: GoogleAbstractedClientOpsMethod;
    headers?: Record<string, string>;
    data?: unknown;
    responseType?: GoogleAbstractedClientOpsResponseType;
};
export interface GoogleAbstractedClient {
    request: (opts: GoogleAbstractedClientOps) => unknown;
    getProjectId: () => Promise<string>;
    get clientType(): string;
}
export declare abstract class GoogleAbstractedFetchClient implements GoogleAbstractedClient {
    abstract get clientType(): string;
    abstract getProjectId(): Promise<string>;
    abstract request(opts: GoogleAbstractedClientOps): unknown;
    _fetch: typeof fetch;
    _buildData(res: Response, opts: GoogleAbstractedClientOps): Promise<any>;
    _request(url: string | undefined, opts: GoogleAbstractedClientOps, additionalHeaders: Record<string, string>): Promise<{
        data: any;
        config: {};
        status: number;
        statusText: string;
        headers: Headers;
        request: {
            responseURL: string;
        };
    }>;
}
export declare class ApiKeyGoogleAuth extends GoogleAbstractedFetchClient {
    apiKey: string;
    constructor(apiKey: string);
    get clientType(): string;
    getProjectId(): Promise<string>;
    request(opts: GoogleAbstractedClientOps): unknown;
}
export declare function aiPlatformScope(platform: GooglePlatformType): string[];
export declare function ensureAuthOptionScopes<AuthOptions>(authOption: AuthOptions | undefined, scopeProperty: string, scopesOrPlatform: string[] | GooglePlatformType | undefined): AuthOptions;
