import { CohereClient, Cohere as CohereTypes } from "cohere-ai";
import { LLM, type BaseLLMParams } from "@langchain/core/language_models/llms";
import { CallbackManagerForLLMRun } from "@langchain/core/callbacks/manager";
import type { BaseLanguageModelCallOptions } from "@langchain/core/language_models/base";
import { CohereClientOptions } from "./client.js";
/**
 * Interface for the input parameters specific to the Cohere model.
 */
export interface BaseCohereInput extends BaseLLMParams {
    /** Sampling temperature to use */
    temperature?: number;
    /**
     * Maximum number of tokens to generate in the completion.
     */
    maxTokens?: number;
    /** Model to use */
    model?: string;
}
export type CohereInput = BaseCohereInput & CohereClientOptions;
interface CohereCallOptions extends BaseLanguageModelCallOptions, Partial<Omit<CohereTypes.GenerateRequest, "message">> {
}
/**
 * Class representing a Cohere Large Language Model (LLM). It interacts
 * with the Cohere API to generate text completions.
 * @example
 * ```typescript
 * const model = new Cohere({
 *   temperature: 0.7,
 *   maxTokens: 20,
 *   maxRetries: 5,
 * });
 *
 * const res = await model.invoke(
 *   "Question: What would be a good company name for a company that makes colorful socks?\nAnswer:"
 * );
 * console.log({ res });
 * ```
 */
export declare class Cohere extends LLM<CohereCallOptions> implements CohereInput {
    static lc_name(): string;
    get lc_secrets(): {
        [key: string]: string;
    } | undefined;
    get lc_aliases(): {
        [key: string]: string;
    } | undefined;
    lc_serializable: boolean;
    temperature: number;
    maxTokens: number;
    model: string;
    apiKey: string;
    client: CohereClient;
    constructor(fields?: CohereInput);
    _llmType(): string;
    invocationParams(options: this["ParsedCallOptions"]): {
        [k: string]: string | number | string[] | undefined;
    };
    /** @ignore */
    _call(prompt: string, options: this["ParsedCallOptions"], runManager?: CallbackManagerForLLMRun): Promise<string>;
}
export {};
