import type { MessageContentComplex, BaseMessage } from "@langchain/core/messages";
import type { Message as BedrockMessage, SystemContentBlock as BedrockSystemContentBlock, Tool as BedrockTool, ContentBlock, ConverseResponse, ContentBlockDeltaEvent, ConverseStreamMetadataEvent, ContentBlockStartEvent, ReasoningContentBlock, ReasoningContentBlockDelta } from "@aws-sdk/client-bedrock-runtime";
import { ChatGenerationChunk } from "@langchain/core/outputs";
import { ChatBedrockConverseToolType, BedrockToolChoice, MessageContentReasoningBlock, MessageContentReasoningBlockReasoningTextPartial, MessageContentReasoningBlockRedacted } from "./types.js";
export declare function extractImageInfo(base64: string): ContentBlock.ImageMember;
export declare function convertToConverseMessages(messages: BaseMessage[]): {
    converseMessages: BedrockMessage[];
    converseSystem: BedrockSystemContentBlock[];
};
export declare function isBedrockTool(tool: unknown): tool is BedrockTool;
export declare function convertToConverseTools(tools: ChatBedrockConverseToolType[]): BedrockTool[];
export type BedrockConverseToolChoice = "any" | "auto" | string | BedrockToolChoice;
export declare function convertToBedrockToolChoice(toolChoice: BedrockConverseToolChoice, tools: BedrockTool[], fields: {
    model: string;
    supportsToolChoiceValues?: Array<"auto" | "any" | "tool">;
}): BedrockToolChoice;
export declare function convertConverseMessageToLangChainMessage(message: BedrockMessage, responseMetadata: Omit<ConverseResponse, "output">): BaseMessage;
export declare function handleConverseStreamContentBlockDelta(contentBlockDelta: ContentBlockDeltaEvent): ChatGenerationChunk;
export declare function handleConverseStreamContentBlockStart(contentBlockStart: ContentBlockStartEvent): ChatGenerationChunk;
export declare function handleConverseStreamMetadata(metadata: ConverseStreamMetadataEvent, extra: {
    streamUsage: boolean;
}): ChatGenerationChunk;
export declare function bedrockReasoningDeltaToLangchainPartialReasoningBlock(reasoningContent: ReasoningContentBlockDelta): MessageContentReasoningBlockReasoningTextPartial | MessageContentReasoningBlockRedacted;
export declare function bedrockReasoningBlockToLangchainReasoningBlock(reasoningContent: ReasoningContentBlock): MessageContentReasoningBlock;
export declare function langchainReasoningBlockToBedrockReasoningBlock(content: MessageContentReasoningBlock): ReasoningContentBlock;
export declare function concatenateLangchainReasoningBlocks(content: Array<MessageContentComplex | MessageContentReasoningBlock>): MessageContentComplex[];
