"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAnthropicImageBlockParam = isAnthropicImageBlockParam;
function isAnthropicImageBlockParam(block) {
    if (block == null) {
        return false;
    }
    if (typeof block !== "object") {
        return false;
    }
    if (!("type" in block) || block.type !== "image") {
        return false;
    }
    if (!("source" in block) || typeof block.source !== "object") {
        return false;
    }
    if (block.source == null) {
        return false;
    }
    if (!("type" in block.source)) {
        return false;
    }
    if (block.source.type === "base64") {
        if (!("media_type" in block.source)) {
            return false;
        }
        if (typeof block.source.media_type !== "string") {
            return false;
        }
        if (!("data" in block.source)) {
            return false;
        }
        if (typeof block.source.data !== "string") {
            return false;
        }
        return true;
    }
    if (block.source.type === "url") {
        if (!("url" in block.source)) {
            return false;
        }
        if (typeof block.source.url !== "string") {
            return false;
        }
        return true;
    }
    return false;
}
