import { BaseLLMOutputParser } from "@langchain/core/output_parsers";
import { JsonOutputKeyToolsParserParamsInterop } from "@langchain/core/output_parsers/openai_tools";
import { ChatGeneration } from "@langchain/core/outputs";
import { ToolCall } from "@langchain/core/messages/tool";
import { InteropZodType } from "@langchain/core/utils/types";
interface AnthropicToolsOutputParserParams<T extends Record<string, any>> extends JsonOutputKeyToolsParserParamsInterop<T> {
}
export declare class AnthropicToolsOutputParser<T extends Record<string, any> = Record<string, any>> extends BaseLLMOutputParser<T> {
    static lc_name(): string;
    lc_namespace: string[];
    returnId: boolean;
    /** The type of tool calls to return. */
    keyName: string;
    /** Whether to return only the first tool call. */
    returnSingle: boolean;
    zodSchema?: InteropZodType<T>;
    constructor(params: AnthropicToolsOutputParserParams<T>);
    protected _validateResult(result: unknown): Promise<T>;
    parseResult(generations: ChatGeneration[]): Promise<T>;
}
export declare function extractToolCalls(content: Record<string, any>[]): ToolCall[];
export {};
