import { type JsonSchema7ObjectType } from "@langchain/core/utils/json_schema";
import { PromptTemplate } from "@langchain/core/prompts";
import { ToolDefinition } from "@langchain/core/language_models/base";
export declare const DEFAULT_TOOL_SYSTEM_PROMPT: PromptTemplate<import("@langchain/core/prompts").ParamsFromFString<"In this environment you have access to a set of tools you can use to answer the user's question.\n\nYou may call them like this:\n<function_calls>\n<invoke>\n<tool_name>$TOOL_NAME</tool_name>\n<parameters>\n<$PARAMETER_NAME>$PARAMETER_VALUE</$PARAMETER_NAME>\n...\n</parameters>\n</invoke>\n</function_calls>\n\nHere are the tools available:\n{tools}\n\nIf the schema above contains a property typed as an enum, you must only return values matching an allowed value for that enum.">, any>;
export type ToolInvocation = {
    tool_name: string;
    parameters: Record<string, unknown>;
};
export declare function formatAsXMLRepresentation(tool: ToolDefinition): string;
export declare function fixArrayXMLParameters(schema: JsonSchema7ObjectType, xmlParameters: Record<string, any>): Record<string, any>;
