import { BaseMessage, BaseMessageLike } from "@langchain/core/messages";
import type { ChatGenerationChunk, ChatResult, LLMResult } from "@langchain/core/outputs";
import { BaseChatModel, BaseChatModelParams } from "@langchain/core/language_models/chat_models";
import { CallbackManagerForLLMRun, Callbacks } from "@langchain/core/callbacks/manager";
import { BasePromptTemplate } from "@langchain/core/prompts";
import type { BaseLanguageModelCallOptions, BaseLanguageModelInput, StructuredOutputMethodParams, StructuredOutputMethodOptions, ToolDefinition } from "@langchain/core/language_models/base";
import { Runnable } from "@langchain/core/runnables";
import { InteropZodType } from "@langchain/core/utils/types";
import { type AnthropicInput } from "../chat_models.js";
export interface ChatAnthropicToolsCallOptions extends BaseLanguageModelCallOptions {
    tools?: ToolDefinition[];
    tool_choice?: "auto" | {
        function: {
            name: string;
        };
        type: "function";
    };
}
export type ChatAnthropicToolsInput = Partial<AnthropicInput> & BaseChatModelParams & {
    llm?: BaseChatModel;
    systemPromptTemplate?: BasePromptTemplate;
};
/**
 * Experimental wrapper over Anthropic chat models that adds support for
 * a function calling interface.
 * @deprecated Prefer traditional tool use through ChatAnthropic.
 */
export declare class ChatAnthropicTools extends BaseChatModel<ChatAnthropicToolsCallOptions> {
    llm: BaseChatModel;
    stopSequences?: string[];
    systemPromptTemplate: BasePromptTemplate;
    lc_namespace: string[];
    static lc_name(): string;
    constructor(fields?: ChatAnthropicToolsInput);
    invocationParams(): any;
    /** @ignore */
    _identifyingParams(): Record<string, any>;
    _streamResponseChunks(messages: BaseMessage[], options: this["ParsedCallOptions"], runManager?: CallbackManagerForLLMRun): AsyncGenerator<ChatGenerationChunk>;
    _prepareAndParseToolCall({ messages, options, systemPromptTemplate, stopSequences, }: {
        messages: BaseMessage[];
        options: ChatAnthropicToolsCallOptions;
        systemPromptTemplate?: BasePromptTemplate;
        stopSequences: string[];
    }): Promise<ChatResult>;
    generate(messages: BaseMessageLike[][], parsedOptions?: ChatAnthropicToolsCallOptions, callbacks?: Callbacks): Promise<LLMResult>;
    _generate(_messages: BaseMessage[], _options: this["ParsedCallOptions"], _runManager?: CallbackManagerForLLMRun | undefined): Promise<ChatResult>;
    _llmType(): string;
    withStructuredOutput<RunOutput extends Record<string, any> = Record<string, any>>(outputSchema: StructuredOutputMethodParams<RunOutput, false> | InteropZodType<RunOutput> | Record<string, any>, config?: StructuredOutputMethodOptions<false> & {
        force?: boolean;
    }): Runnable<BaseLanguageModelInput, RunOutput>;
    withStructuredOutput<RunOutput extends Record<string, any> = Record<string, any>>(outputSchema: StructuredOutputMethodParams<RunOutput, true> | InteropZodType<RunOutput> | Record<string, any>, config?: StructuredOutputMethodOptions<true> & {
        force?: boolean;
    }): Runnable<BaseLanguageModelInput, {
        raw: BaseMessage;
        parsed: RunOutput;
    }>;
}
