/**
 * Biden AI Executive Order
 * https://www.whitehouse.gov/briefing-room/presidential-actions/2023/10/30/executive-order-on-the-safe-secure-and-trustworthy-development-and-use-of-artificial-intelligence/
 */
export declare const TFLOPS_THRESHOLD_WHITE_HOUSE_MODEL_TRAINING_TOTAL: number;
export declare const TFLOPS_THRESHOLD_WHITE_HOUSE_MODEL_TRAINING_TOTAL_BIOLOGY: number;
export declare const TFLOPS_THRESHOLD_WHITE_HOUSE_CLUSTER: number;
/**
 * EU AI Act
 * https://ec.europa.eu/commission/presscorner/detail/en/qanda_21_1683
 */
export declare const TFLOPS_THRESHOLD_EU_AI_ACT_MODEL_TRAINING_TOTAL: number;
export interface HardwareSpec {
    /**
     * Approximate value, in FP16 whenever possible.
     * This is only approximate/theoretical and shouldn't be taken too seriously.
     * Currently the CPU values are from cpu-monkey.com
     * while the GPU values are from techpowerup.com
     *
     * Note to reviewers: I got fed up with data entry,
     * and HuggingChat running Llama3 with Web search was failing a bit,
     * so some of those values might be slightly inaccurate. Forgive me and please feel free to improve.
     */
    tflops: number;
    /**
     * If an array is specified, options of memory size (can be VRAM, unified RAM)
     * e.g. an A100 exists in 40 or 80 GB.
     */
    memory?: number[];
}
export declare const DEFAULT_MEMORY_OPTIONS: number[];
export declare const SKUS: {
    GPU: {
        NVIDIA: {
            H100: {
                tflops: number;
                memory: number[];
            };
            L40: {
                tflops: number;
                memory: number[];
            };
            "RTX 6000 Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX 5880 Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX 5000 Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX 4500 Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX 4000 Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX 4000 SFF Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX 2000 Ada": {
                tflops: number;
                memory: number[];
            };
            "RTX A4000": {
                tflops: number;
                memory: number[];
            };
            A100: {
                tflops: number;
                memory: number[];
            };
            A40: {
                tflops: number;
                memory: number[];
            };
            A10: {
                tflops: number;
                memory: number[];
            };
            "RTX 4090": {
                tflops: number;
                memory: number[];
            };
            "RTX 4090D": {
                tflops: number;
                memory: number[];
            };
            "RTX 4080 SUPER": {
                tflops: number;
                memory: number[];
            };
            "RTX 4080": {
                tflops: number;
                memory: number[];
            };
            "RTX 4070": {
                tflops: number;
                memory: number[];
            };
            "RTX 4070 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 4070 Super": {
                tflops: number;
                memory: number[];
            };
            "RTX 4070 Ti Super": {
                tflops: number;
                memory: number[];
            };
            "RTX 4060": {
                tflops: number;
                memory: number[];
            };
            "RTX 4060 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 3090": {
                tflops: number;
                memory: number[];
            };
            "RTX 3090 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 3080": {
                tflops: number;
                memory: number[];
            };
            "RTX 3080 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 3070": {
                tflops: number;
                memory: number[];
            };
            "RTX 3070 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 3070 Ti Laptop": {
                tflops: number;
                memory: number[];
            };
            "RTX 3060 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 3060": {
                tflops: number;
                memory: number[];
            };
            "RTX 2080 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX 2080": {
                tflops: number;
                memory: number[];
            };
            "RTX 2070": {
                tflops: number;
                memory: number[];
            };
            "RTX 3050 Mobile": {
                tflops: number;
                memory: number[];
            };
            "RTX 2060 Mobile": {
                tflops: number;
                memory: number[];
            };
            "GTX 1080 Ti": {
                tflops: number;
                memory: number[];
            };
            "GTX 1070 Ti": {
                tflops: number;
                memory: number[];
            };
            "RTX Titan": {
                tflops: number;
                memory: number[];
            };
            "GTX 1660": {
                tflops: number;
                memory: number[];
            };
            "GTX 1650 Mobile": {
                tflops: number;
                memory: number[];
            };
            T4: {
                tflops: number;
                memory: number[];
            };
            V100: {
                tflops: number;
                memory: number[];
            };
            "Quadro P6000": {
                tflops: number;
                memory: number[];
            };
            P40: {
                tflops: number;
                memory: number[];
            };
        };
        AMD: {
            MI300: {
                tflops: number;
                memory: number[];
            };
            MI250: {
                tflops: number;
                memory: number[];
            };
            MI210: {
                tflops: number;
                memory: number[];
            };
            MI100: {
                tflops: number;
                memory: number[];
            };
            "RX 7900 XTX": {
                tflops: number;
                memory: number[];
            };
            "RX 7900 XT": {
                tflops: number;
                memory: number[];
            };
            "RX 7900 GRE": {
                tflops: number;
                memory: number[];
            };
            "RX 7800 XT": {
                tflops: number;
                memory: number[];
            };
            "RX 7700 XT": {
                tflops: number;
                memory: number[];
            };
            "RX 7600 XT": {
                tflops: number;
                memory: number[];
            };
            "RX 6950 XT": {
                tflops: number;
                memory: number[];
            };
            "RX 6800": {
                tflops: number;
                memory: number[];
            };
            "Radeon Pro VII": {
                tflops: number;
                memory: number[];
            };
        };
    };
    CPU: {
        Intel: {
            "Xeon 4th Generation (Sapphire Rapids)": {
                tflops: number;
            };
            "Xeon 3th Generation (Ice Lake)": {
                tflops: number;
            };
            "Xeon 2th Generation (Cascade Lake)": {
                tflops: number;
            };
            "Intel Core 13th Generation (i9)": {
                tflops: number;
            };
            "Intel Core 13th Generation (i7)": {
                tflops: number;
            };
            "Intel Core 13th Generation (i5)": {
                tflops: number;
            };
            "Intel Core 13th Generation (i3)": {
                tflops: number;
            };
            "Intel Core 12th Generation (i9)": {
                tflops: number;
            };
            "Intel Core 12th Generation (i7)": {
                tflops: number;
            };
            "Intel Core 12th Generation (i5)": {
                tflops: number;
            };
            "Intel Core 12th Generation (i3)": {
                tflops: number;
            };
            "Intel Core 11th Generation (i9)": {
                tflops: number;
            };
            "Intel Core 11th Generation (i7)": {
                tflops: number;
            };
            "Intel Core 11th Generation (i5)": {
                tflops: number;
            };
            "Intel Core 11th Generation (i3)": {
                tflops: number;
            };
            "Intel Core 10th Generation (i9)": {
                tflops: number;
            };
            "Intel Core 10th Generation (i7)": {
                tflops: number;
            };
            "Intel Core 10th Generation (i5)": {
                tflops: number;
            };
            "Intel Core 10th Generation (i3)": {
                tflops: number;
            };
        };
        AMD: {
            "EPYC 4th Generation (Genoa)": {
                tflops: number;
            };
            "EPYC 3th Generation (Milan)": {
                tflops: number;
            };
            "EPYC 2th Generation (Rome)": {
                tflops: number;
            };
            "EPYC 1st Generation (Naples)": {
                tflops: number;
            };
            "Ryzen Zen4 7000 (Ryzen 9)": {
                tflops: number;
            };
            "Ryzen Zen4 7000 (Ryzen 7)": {
                tflops: number;
            };
            "Ryzen Zen4 7000 (Ryzen 5)": {
                tflops: number;
            };
            "Ryzen Zen3 5000 (Ryzen 9)": {
                tflops: number;
            };
            "Ryzen Zen3 5000 (Ryzen 7)": {
                tflops: number;
            };
            "Ryzen Zen3 5000 (Ryzen 5)": {
                tflops: number;
            };
            "Ryzen Zen 2  3000 (Threadripper)": {
                tflops: number;
            };
            "Ryzen Zen 2  3000 (Ryzen 9)": {
                tflops: number;
            };
            "Ryzen Zen 2  3000 (Ryzen 7)": {
                tflops: number;
            };
            "Ryzen Zen 2  3000 (Ryzen 5)": {
                tflops: number;
            };
            "Ryzen Zen 2  3000 (Ryzen 3)": {
                tflops: number;
            };
        };
    };
    "Apple Silicon": {
        "-": {
            "Apple M1": {
                tflops: number;
                memory: number[];
            };
            "Apple M1 Pro": {
                tflops: number;
                memory: number[];
            };
            "Apple M1 Max": {
                tflops: number;
                memory: number[];
            };
            "Apple M1 Ultra": {
                tflops: number;
                memory: number[];
            };
            "Apple M2": {
                tflops: number;
                memory: number[];
            };
            "Apple M2 Pro": {
                tflops: number;
                memory: number[];
            };
            "Apple M2 Max": {
                tflops: number;
                memory: number[];
            };
            "Apple M2 Ultra": {
                tflops: number;
                memory: number[];
            };
            "Apple M3": {
                tflops: number;
                memory: number[];
            };
            "Apple M3 Pro": {
                tflops: number;
                memory: number[];
            };
            "Apple M3 Max": {
                tflops: number;
                memory: number[];
            };
        };
    };
};
export type SkuType = keyof typeof SKUS;
//# sourceMappingURL=hardware.d.ts.map