import type { BaseArgs, Options } from "../../types";
export type AutomaticSpeechRecognitionArgs = BaseArgs & {
    /**
     * Binary audio data
     */
    data: Blob | ArrayBuffer;
};
export interface AutomaticSpeechRecognitionOutput {
    /**
     * The text that was recognized from the audio
     */
    text: string;
}
/**
 * This task reads some audio input and outputs the said words within the audio files.
 * Recommended model (english language): facebook/wav2vec2-large-960h-lv60-self
 */
export declare function automaticSpeechRecognition(args: AutomaticSpeechRecognitionArgs, options?: Options): Promise<AutomaticSpeechRecognitionOutput>;
//# sourceMappingURL=automaticSpeechRecognition.d.ts.map