"use strict";
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretManagerServiceClient = void 0;
/* global window */
const gax = require("google-gax");
const path = require("path");
/**
 * Client JSON configuration object, loaded from
 * `src/v1beta1/secret_manager_service_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
const gapicConfig = require("./secret_manager_service_client_config.json");
const version = require('../../../package.json').version;
/**
 *  Secret Manager Service
 *
 *  Manages secrets and operations using those secrets. Implements a REST
 *  model with the following objects:
 *
 *  * {@link google.cloud.secrets.v1beta1.Secret|Secret}
 *  * {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}
 * @class
 * @memberof v1beta1
 */
class SecretManagerServiceClient {
    /**
     * Construct an instance of SecretManagerServiceClient.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP fallback mode.
     *     In fallback mode, a special browser-compatible transport implementation is used
     *     instead of gRPC transport. In browser context (if the `window` object is defined)
     *     the fallback mode is enabled automatically; set `options.fallback` to `false`
     *     if you need to override this behavior.
     */
    constructor(opts) {
        var _a, _b;
        this._terminated = false;
        this.descriptors = {
            page: {},
            stream: {},
            longrunning: {},
            batching: {},
        };
        // Ensure that options include all the required fields.
        const staticMembers = this.constructor;
        const servicePath = (opts === null || opts === void 0 ? void 0 : opts.servicePath) || (opts === null || opts === void 0 ? void 0 : opts.apiEndpoint) || staticMembers.servicePath;
        const port = (opts === null || opts === void 0 ? void 0 : opts.port) || staticMembers.port;
        const clientConfig = (_a = opts === null || opts === void 0 ? void 0 : opts.clientConfig) !== null && _a !== void 0 ? _a : {};
        const fallback = (_b = opts === null || opts === void 0 ? void 0 : opts.fallback) !== null && _b !== void 0 ? _b : (typeof window !== 'undefined' && typeof (window === null || window === void 0 ? void 0 : window.fetch) === 'function');
        opts = Object.assign({ servicePath, port, clientConfig, fallback }, opts);
        // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
        if (servicePath !== staticMembers.servicePath && !('scopes' in opts)) {
            opts['scopes'] = staticMembers.scopes;
        }
        // Choose either gRPC or proto-over-HTTP implementation of google-gax.
        this._gaxModule = opts.fallback ? gax.fallback : gax;
        // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
        this._gaxGrpc = new this._gaxModule.GrpcClient(opts);
        // Save options to use in initialize() method.
        this._opts = opts;
        // Save the auth object to the client, for use by other methods.
        this.auth = this._gaxGrpc.auth;
        // Set the default scopes in auth client if needed.
        if (servicePath === staticMembers.servicePath) {
            this.auth.defaultScopes = staticMembers.scopes;
        }
        // Determine the client header string.
        const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
        if (typeof process !== 'undefined' && 'versions' in process) {
            clientHeader.push(`gl-node/${process.versions.node}`);
        }
        else {
            clientHeader.push(`gl-web/${this._gaxModule.version}`);
        }
        if (!opts.fallback) {
            clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
        }
        if (opts.libName && opts.libVersion) {
            clientHeader.push(`${opts.libName}/${opts.libVersion}`);
        }
        // Load the applicable protos.
        // For Node.js, pass the path to JSON proto file.
        // For browsers, pass the JSON content.
        const nodejsProtoPath = path.join(__dirname, '..', '..', 'protos', 'protos.json');
        this._protos = this._gaxGrpc.loadProto(opts.fallback
            ? // eslint-disable-next-line @typescript-eslint/no-var-requires
                require('../../protos/protos.json')
            : nodejsProtoPath);
        // This API contains "path templates"; forward-slash-separated
        // identifiers to uniquely identify resources within the API.
        // Create useful helper objects for these.
        this.pathTemplates = {
            projectPathTemplate: new this._gaxModule.PathTemplate('projects/{project}'),
            secretPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/secrets/{secret}'),
            secretVersionPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/secrets/{secret}/versions/{secret_version}'),
        };
        // Some of the methods on this service return "paged" results,
        // (e.g. 50 results at a time, with tokens to get subsequent
        // pages). Denote the keys used for pagination and results.
        this.descriptors.page = {
            listSecrets: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'secrets'),
            listSecretVersions: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'versions'),
        };
        // Put together the default options sent with requests.
        this._defaults = this._gaxGrpc.constructSettings('google.cloud.secrets.v1beta1.SecretManagerService', gapicConfig, opts.clientConfig || {}, { 'x-goog-api-client': clientHeader.join(' ') });
        // Set up a dictionary of "inner API calls"; the core implementation
        // of calling the API is handled in `google-gax`, with this code
        // merely providing the destination and request information.
        this.innerApiCalls = {};
    }
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize() {
        // If the client stub promise is already initialized, return immediately.
        if (this.secretManagerServiceStub) {
            return this.secretManagerServiceStub;
        }
        // Put together the "service stub" for
        // google.cloud.secrets.v1beta1.SecretManagerService.
        this.secretManagerServiceStub = this._gaxGrpc.createStub(this._opts.fallback
            ? this._protos.lookupService('google.cloud.secrets.v1beta1.SecretManagerService')
            : // eslint-disable-next-line @typescript-eslint/no-explicit-any
                this._protos.google.cloud.secrets.v1beta1
                    .SecretManagerService, this._opts);
        // Iterate over each of the methods that the service provides
        // and create an API call method for each.
        const secretManagerServiceStubMethods = [
            'listSecrets',
            'createSecret',
            'addSecretVersion',
            'getSecret',
            'updateSecret',
            'deleteSecret',
            'listSecretVersions',
            'getSecretVersion',
            'accessSecretVersion',
            'disableSecretVersion',
            'enableSecretVersion',
            'destroySecretVersion',
            'setIamPolicy',
            'getIamPolicy',
            'testIamPermissions',
        ];
        for (const methodName of secretManagerServiceStubMethods) {
            const callPromise = this.secretManagerServiceStub.then(stub => (...args) => {
                if (this._terminated) {
                    return Promise.reject('The client has already been closed.');
                }
                const func = stub[methodName];
                return func.apply(stub, args);
            }, (err) => () => {
                throw err;
            });
            const descriptor = this.descriptors.page[methodName] || undefined;
            const apiCall = this._gaxModule.createApiCall(callPromise, this._defaults[methodName], descriptor);
            this.innerApiCalls[methodName] = apiCall;
        }
        return this.secretManagerServiceStub;
    }
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath() {
        return 'secretmanager.googleapis.com';
    }
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint() {
        return 'secretmanager.googleapis.com';
    }
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port() {
        return 443;
    }
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes() {
        return ['https://www.googleapis.com/auth/cloud-platform'];
    }
    /**
     * Return the project ID used by this class.
     * @returns {Promise} A promise that resolves to string containing the project ID.
     */
    getProjectId(callback) {
        if (callback) {
            this.auth.getProjectId(callback);
            return;
        }
        return this.auth.getProjectId();
    }
    /**
     * Creates a new {@link google.cloud.secrets.v1beta1.Secret|Secret} containing no {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersions}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the project to associate with the
     *   {@link google.cloud.secrets.v1beta1.Secret|Secret}, in the format `projects/*`.
     * @param {string} request.secretId
     *   Required. This must be unique within the project.
     *
     *   A secret ID is a string with a maximum length of 255 characters and can
     *   contain uppercase and lowercase letters, numerals, and the hyphen (`-`) and
     *   underscore (`_`) characters.
     * @param {google.cloud.secrets.v1beta1.Secret} request.secret
     *   Required. A {@link google.cloud.secrets.v1beta1.Secret|Secret} with initial field values.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Secret]{@link google.cloud.secrets.v1beta1.Secret}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.createSecret(request);
     */
    createSecret(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.createSecret(request, options, callback);
    }
    /**
     * Creates a new {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} containing secret data and attaches
     * it to an existing {@link google.cloud.secrets.v1beta1.Secret|Secret}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.Secret|Secret} to associate with the
     *   {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} in the format `projects/* /secrets/*`.
     * @param {google.cloud.secrets.v1beta1.SecretPayload} request.payload
     *   Required. The secret payload of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.addSecretVersion(request);
     */
    addSecretVersion(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.addSecretVersion(request, options, callback);
    }
    /**
     * Gets metadata for a given {@link google.cloud.secrets.v1beta1.Secret|Secret}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.Secret|Secret}, in the format `projects/* /secrets/*`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Secret]{@link google.cloud.secrets.v1beta1.Secret}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.getSecret(request);
     */
    getSecret(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.getSecret(request, options, callback);
    }
    /**
     * Updates metadata of an existing {@link google.cloud.secrets.v1beta1.Secret|Secret}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {google.cloud.secrets.v1beta1.Secret} request.secret
     *   Required. {@link google.cloud.secrets.v1beta1.Secret|Secret} with updated field values.
     * @param {google.protobuf.FieldMask} request.updateMask
     *   Required. Specifies the fields to be updated.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Secret]{@link google.cloud.secrets.v1beta1.Secret}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.updateSecret(request);
     */
    updateSecret(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                'secret.name': request.secret.name || '',
            });
        this.initialize();
        return this.innerApiCalls.updateSecret(request, options, callback);
    }
    /**
     * Deletes a {@link google.cloud.secrets.v1beta1.Secret|Secret}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.Secret|Secret} to delete in the format
     *   `projects/* /secrets/*`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.deleteSecret(request);
     */
    deleteSecret(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.deleteSecret(request, options, callback);
    }
    /**
     * Gets metadata for a {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     *
     * `projects/* /secrets/* /versions/latest` is an alias to the `latest`
     * {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} in the format
     *   `projects/* /secrets/* /versions/*`.
     *   `projects/* /secrets/* /versions/latest` is an alias to the `latest`
     *   {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.getSecretVersion(request);
     */
    getSecretVersion(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.getSecretVersion(request, options, callback);
    }
    /**
     * Accesses a {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}. This call returns the secret data.
     *
     * `projects/* /secrets/* /versions/latest` is an alias to the `latest`
     * {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} in the format
     *   `projects/* /secrets/* /versions/*`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [AccessSecretVersionResponse]{@link google.cloud.secrets.v1beta1.AccessSecretVersionResponse}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.accessSecretVersion(request);
     */
    accessSecretVersion(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.accessSecretVersion(request, options, callback);
    }
    /**
     * Disables a {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     *
     * Sets the {@link google.cloud.secrets.v1beta1.SecretVersion.state|state} of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} to
     * {@link google.cloud.secrets.v1beta1.SecretVersion.State.DISABLED|DISABLED}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} to disable in the format
     *   `projects/* /secrets/* /versions/*`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.disableSecretVersion(request);
     */
    disableSecretVersion(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.disableSecretVersion(request, options, callback);
    }
    /**
     * Enables a {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     *
     * Sets the {@link google.cloud.secrets.v1beta1.SecretVersion.state|state} of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} to
     * {@link google.cloud.secrets.v1beta1.SecretVersion.State.ENABLED|ENABLED}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} to enable in the format
     *   `projects/* /secrets/* /versions/*`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.enableSecretVersion(request);
     */
    enableSecretVersion(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.enableSecretVersion(request, options, callback);
    }
    /**
     * Destroys a {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion}.
     *
     * Sets the {@link google.cloud.secrets.v1beta1.SecretVersion.state|state} of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} to
     * {@link google.cloud.secrets.v1beta1.SecretVersion.State.DESTROYED|DESTROYED} and irrevocably destroys the
     * secret data.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersion} to destroy in the format
     *   `projects/* /secrets/* /versions/*`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.destroySecretVersion(request);
     */
    destroySecretVersion(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                name: request.name || '',
            });
        this.initialize();
        return this.innerApiCalls.destroySecretVersion(request, options, callback);
    }
    /**
     * Sets the access control policy on the specified secret. Replaces any
     * existing policy.
     *
     * Permissions on {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersions} are enforced according
     * to the policy set on the associated {@link google.cloud.secrets.v1beta1.Secret|Secret}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.resource
     *   REQUIRED: The resource for which the policy is being specified.
     *   See the operation documentation for the appropriate value for this field.
     * @param {google.iam.v1.Policy} request.policy
     *   REQUIRED: The complete policy to be applied to the `resource`. The size of
     *   the policy is limited to a few 10s of KB. An empty policy is a
     *   valid policy but certain Cloud Platform services (such as Projects)
     *   might reject them.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Policy]{@link google.iam.v1.Policy}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.setIamPolicy(request);
     */
    setIamPolicy(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                resource: request.resource || '',
            });
        this.initialize();
        return this.innerApiCalls.setIamPolicy(request, options, callback);
    }
    /**
     * Gets the access control policy for a secret.
     * Returns empty policy if the secret exists and does not have a policy set.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.resource
     *   REQUIRED: The resource for which the policy is being requested.
     *   See the operation documentation for the appropriate value for this field.
     * @param {google.iam.v1.GetPolicyOptions} request.options
     *   OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *   `GetIamPolicy`. This field is only used by Cloud IAM.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Policy]{@link google.iam.v1.Policy}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.getIamPolicy(request);
     */
    getIamPolicy(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                resource: request.resource || '',
            });
        this.initialize();
        return this.innerApiCalls.getIamPolicy(request, options, callback);
    }
    /**
     * Returns permissions that a caller has for the specified secret.
     * If the secret does not exist, this call returns an empty set of
     * permissions, not a NOT_FOUND error.
     *
     * Note: This operation is designed to be used for building permission-aware
     * UIs and command-line tools, not for authorization checking. This operation
     * may "fail open" without warning.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.resource
     *   REQUIRED: The resource for which the policy detail is being requested.
     *   See the operation documentation for the appropriate value for this field.
     * @param {string[]} request.permissions
     *   The set of permissions to check for the `resource`. Permissions with
     *   wildcards (such as '*' or 'storage.*') are not allowed. For more
     *   information see
     *   [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [TestIamPermissionsResponse]{@link google.iam.v1.TestIamPermissionsResponse}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example
     * const [response] = await client.testIamPermissions(request);
     */
    testIamPermissions(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                resource: request.resource || '',
            });
        this.initialize();
        return this.innerApiCalls.testIamPermissions(request, options, callback);
    }
    /**
     * Lists {@link google.cloud.secrets.v1beta1.Secret|Secrets}.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the project associated with the
     *   {@link google.cloud.secrets.v1beta1.Secret|Secrets}, in the format `projects/*`.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to be returned in a single page. If
     *   set to 0, the server decides the number of results to return. If the
     *   number is greater than 25000, it is capped at 25000.
     * @param {string} [request.pageToken]
     *   Optional. Pagination token, returned earlier via
     *   {@link google.cloud.secrets.v1beta1.ListSecretsResponse.next_page_token|ListSecretsResponse.next_page_token}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [Secret]{@link google.cloud.secrets.v1beta1.Secret}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listSecretsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listSecrets(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.listSecrets(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the project associated with the
     *   {@link google.cloud.secrets.v1beta1.Secret|Secrets}, in the format `projects/*`.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to be returned in a single page. If
     *   set to 0, the server decides the number of results to return. If the
     *   number is greater than 25000, it is capped at 25000.
     * @param {string} [request.pageToken]
     *   Optional. Pagination token, returned earlier via
     *   {@link google.cloud.secrets.v1beta1.ListSecretsResponse.next_page_token|ListSecretsResponse.next_page_token}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [Secret]{@link google.cloud.secrets.v1beta1.Secret} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listSecretsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listSecretsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listSecrets.createStream(this.innerApiCalls.listSecrets, request, callSettings);
    }
    /**
     * Equivalent to `listSecrets`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the project associated with the
     *   {@link google.cloud.secrets.v1beta1.Secret|Secrets}, in the format `projects/*`.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to be returned in a single page. If
     *   set to 0, the server decides the number of results to return. If the
     *   number is greater than 25000, it is capped at 25000.
     * @param {string} [request.pageToken]
     *   Optional. Pagination token, returned earlier via
     *   {@link google.cloud.secrets.v1beta1.ListSecretsResponse.next_page_token|ListSecretsResponse.next_page_token}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [Secret]{@link google.cloud.secrets.v1beta1.Secret}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example
     * const iterable = client.listSecretsAsync(request);
     * for await (const response of iterable) {
     *   // process response
     * }
     */
    listSecretsAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        options = options || {};
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listSecrets.asyncIterate(this.innerApiCalls['listSecrets'], request, callSettings);
    }
    /**
     * Lists {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersions}. This call does not return secret
     * data.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.Secret|Secret} associated with the
     *   {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersions} to list, in the format
     *   `projects/* /secrets/*`.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to be returned in a single page. If
     *   set to 0, the server decides the number of results to return. If the
     *   number is greater than 25000, it is capped at 25000.
     * @param {string} [request.pageToken]
     *   Optional. Pagination token, returned earlier via
     *   ListSecretVersionsResponse.next_page_token][].
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listSecretVersionsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listSecretVersions(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.listSecretVersions(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.Secret|Secret} associated with the
     *   {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersions} to list, in the format
     *   `projects/* /secrets/*`.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to be returned in a single page. If
     *   set to 0, the server decides the number of results to return. If the
     *   number is greater than 25000, it is capped at 25000.
     * @param {string} [request.pageToken]
     *   Optional. Pagination token, returned earlier via
     *   ListSecretVersionsResponse.next_page_token][].
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listSecretVersionsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listSecretVersionsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listSecretVersions.createStream(this.innerApiCalls.listSecretVersions, request, callSettings);
    }
    /**
     * Equivalent to `listSecretVersions`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the {@link google.cloud.secrets.v1beta1.Secret|Secret} associated with the
     *   {@link google.cloud.secrets.v1beta1.SecretVersion|SecretVersions} to list, in the format
     *   `projects/* /secrets/*`.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to be returned in a single page. If
     *   set to 0, the server decides the number of results to return. If the
     *   number is greater than 25000, it is capped at 25000.
     * @param {string} [request.pageToken]
     *   Optional. Pagination token, returned earlier via
     *   ListSecretVersionsResponse.next_page_token][].
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [SecretVersion]{@link google.cloud.secrets.v1beta1.SecretVersion}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example
     * const iterable = client.listSecretVersionsAsync(request);
     * for await (const response of iterable) {
     *   // process response
     * }
     */
    listSecretVersionsAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        options = options || {};
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this.descriptors.page.listSecretVersions.asyncIterate(this.innerApiCalls['listSecretVersions'], request, callSettings);
    }
    // --------------------
    // -- Path templates --
    // --------------------
    /**
     * Return a fully-qualified project resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectPath(project) {
        return this.pathTemplates.projectPathTemplate.render({
            project: project,
        });
    }
    /**
     * Parse the project from Project resource.
     *
     * @param {string} projectName
     *   A fully-qualified path representing Project resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectName(projectName) {
        return this.pathTemplates.projectPathTemplate.match(projectName).project;
    }
    /**
     * Return a fully-qualified secret resource name string.
     *
     * @param {string} project
     * @param {string} secret
     * @returns {string} Resource name string.
     */
    secretPath(project, secret) {
        return this.pathTemplates.secretPathTemplate.render({
            project: project,
            secret: secret,
        });
    }
    /**
     * Parse the project from Secret resource.
     *
     * @param {string} secretName
     *   A fully-qualified path representing Secret resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromSecretName(secretName) {
        return this.pathTemplates.secretPathTemplate.match(secretName).project;
    }
    /**
     * Parse the secret from Secret resource.
     *
     * @param {string} secretName
     *   A fully-qualified path representing Secret resource.
     * @returns {string} A string representing the secret.
     */
    matchSecretFromSecretName(secretName) {
        return this.pathTemplates.secretPathTemplate.match(secretName).secret;
    }
    /**
     * Return a fully-qualified secretVersion resource name string.
     *
     * @param {string} project
     * @param {string} secret
     * @param {string} secret_version
     * @returns {string} Resource name string.
     */
    secretVersionPath(project, secret, secretVersion) {
        return this.pathTemplates.secretVersionPathTemplate.render({
            project: project,
            secret: secret,
            secret_version: secretVersion,
        });
    }
    /**
     * Parse the project from SecretVersion resource.
     *
     * @param {string} secretVersionName
     *   A fully-qualified path representing SecretVersion resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromSecretVersionName(secretVersionName) {
        return this.pathTemplates.secretVersionPathTemplate.match(secretVersionName)
            .project;
    }
    /**
     * Parse the secret from SecretVersion resource.
     *
     * @param {string} secretVersionName
     *   A fully-qualified path representing SecretVersion resource.
     * @returns {string} A string representing the secret.
     */
    matchSecretFromSecretVersionName(secretVersionName) {
        return this.pathTemplates.secretVersionPathTemplate.match(secretVersionName)
            .secret;
    }
    /**
     * Parse the secret_version from SecretVersion resource.
     *
     * @param {string} secretVersionName
     *   A fully-qualified path representing SecretVersion resource.
     * @returns {string} A string representing the secret_version.
     */
    matchSecretVersionFromSecretVersionName(secretVersionName) {
        return this.pathTemplates.secretVersionPathTemplate.match(secretVersionName)
            .secret_version;
    }
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close() {
        this.initialize();
        if (!this._terminated) {
            return this.secretManagerServiceStub.then(stub => {
                this._terminated = true;
                stub.close();
            });
        }
        return Promise.resolve();
    }
}
exports.SecretManagerServiceClient = SecretManagerServiceClient;
//# sourceMappingURL=secret_manager_service_client.js.map