// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_secret_manager_protos || ($protobuf.roots._google_cloud_secret_manager_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.cloud = (function() {
    
            /**
             * Namespace cloud.
             * @memberof google
             * @namespace
             */
            var cloud = {};
    
            cloud.secretmanager = (function() {
    
                /**
                 * Namespace secretmanager.
                 * @memberof google.cloud
                 * @namespace
                 */
                var secretmanager = {};
    
                secretmanager.v1 = (function() {
    
                    /**
                     * Namespace v1.
                     * @memberof google.cloud.secretmanager
                     * @namespace
                     */
                    var v1 = {};
    
                    v1.Secret = (function() {
    
                        /**
                         * Properties of a Secret.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ISecret
                         * @property {string|null} [name] Secret name
                         * @property {google.cloud.secretmanager.v1.IReplication|null} [replication] Secret replication
                         * @property {google.protobuf.ITimestamp|null} [createTime] Secret createTime
                         * @property {Object.<string,string>|null} [labels] Secret labels
                         * @property {Array.<google.cloud.secretmanager.v1.ITopic>|null} [topics] Secret topics
                         * @property {google.protobuf.ITimestamp|null} [expireTime] Secret expireTime
                         * @property {google.protobuf.IDuration|null} [ttl] Secret ttl
                         * @property {string|null} [etag] Secret etag
                         * @property {google.cloud.secretmanager.v1.IRotation|null} [rotation] Secret rotation
                         * @property {Object.<string,number|Long>|null} [versionAliases] Secret versionAliases
                         * @property {Object.<string,string>|null} [annotations] Secret annotations
                         * @property {google.protobuf.IDuration|null} [versionDestroyTtl] Secret versionDestroyTtl
                         * @property {google.cloud.secretmanager.v1.ICustomerManagedEncryption|null} [customerManagedEncryption] Secret customerManagedEncryption
                         */
    
                        /**
                         * Constructs a new Secret.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a Secret.
                         * @implements ISecret
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ISecret=} [properties] Properties to set
                         */
                        function Secret(properties) {
                            this.labels = {};
                            this.topics = [];
                            this.versionAliases = {};
                            this.annotations = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Secret name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.name = "";
    
                        /**
                         * Secret replication.
                         * @member {google.cloud.secretmanager.v1.IReplication|null|undefined} replication
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.replication = null;
    
                        /**
                         * Secret createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.createTime = null;
    
                        /**
                         * Secret labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.labels = $util.emptyObject;
    
                        /**
                         * Secret topics.
                         * @member {Array.<google.cloud.secretmanager.v1.ITopic>} topics
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.topics = $util.emptyArray;
    
                        /**
                         * Secret expireTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} expireTime
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.expireTime = null;
    
                        /**
                         * Secret ttl.
                         * @member {google.protobuf.IDuration|null|undefined} ttl
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.ttl = null;
    
                        /**
                         * Secret etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.etag = "";
    
                        /**
                         * Secret rotation.
                         * @member {google.cloud.secretmanager.v1.IRotation|null|undefined} rotation
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.rotation = null;
    
                        /**
                         * Secret versionAliases.
                         * @member {Object.<string,number|Long>} versionAliases
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.versionAliases = $util.emptyObject;
    
                        /**
                         * Secret annotations.
                         * @member {Object.<string,string>} annotations
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.annotations = $util.emptyObject;
    
                        /**
                         * Secret versionDestroyTtl.
                         * @member {google.protobuf.IDuration|null|undefined} versionDestroyTtl
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.versionDestroyTtl = null;
    
                        /**
                         * Secret customerManagedEncryption.
                         * @member {google.cloud.secretmanager.v1.ICustomerManagedEncryption|null|undefined} customerManagedEncryption
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Secret.prototype.customerManagedEncryption = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Secret expiration.
                         * @member {"expireTime"|"ttl"|undefined} expiration
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         */
                        Object.defineProperty(Secret.prototype, "expiration", {
                            get: $util.oneOfGetter($oneOfFields = ["expireTime", "ttl"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Secret instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecret=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.Secret} Secret instance
                         */
                        Secret.create = function create(properties) {
                            return new Secret(properties);
                        };
    
                        /**
                         * Encodes the specified Secret message. Does not implicitly {@link google.cloud.secretmanager.v1.Secret.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecret} message Secret message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Secret.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.replication != null && Object.hasOwnProperty.call(message, "replication"))
                                $root.google.cloud.secretmanager.v1.Replication.encode(message.replication, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            if (message.topics != null && message.topics.length)
                                for (var i = 0; i < message.topics.length; ++i)
                                    $root.google.cloud.secretmanager.v1.Topic.encode(message.topics[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.expireTime != null && Object.hasOwnProperty.call(message, "expireTime"))
                                $root.google.protobuf.Timestamp.encode(message.expireTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.ttl != null && Object.hasOwnProperty.call(message, "ttl"))
                                $root.google.protobuf.Duration.encode(message.ttl, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.etag);
                            if (message.rotation != null && Object.hasOwnProperty.call(message, "rotation"))
                                $root.google.cloud.secretmanager.v1.Rotation.encode(message.rotation, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.versionAliases != null && Object.hasOwnProperty.call(message, "versionAliases"))
                                for (var keys = Object.keys(message.versionAliases), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 11, wireType 2 =*/90).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 0 =*/16).int64(message.versionAliases[keys[i]]).ldelim();
                            if (message.annotations != null && Object.hasOwnProperty.call(message, "annotations"))
                                for (var keys = Object.keys(message.annotations), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 13, wireType 2 =*/106).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.annotations[keys[i]]).ldelim();
                            if (message.versionDestroyTtl != null && Object.hasOwnProperty.call(message, "versionDestroyTtl"))
                                $root.google.protobuf.Duration.encode(message.versionDestroyTtl, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                            if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.encode(message.customerManagedEncryption, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Secret message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Secret.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecret} message Secret message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Secret.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Secret message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.Secret} Secret
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Secret.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Secret(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.replication = $root.google.cloud.secretmanager.v1.Replication.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                case 5: {
                                        if (!(message.topics && message.topics.length))
                                            message.topics = [];
                                        message.topics.push($root.google.cloud.secretmanager.v1.Topic.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 6: {
                                        message.expireTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.ttl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 9: {
                                        message.rotation = $root.google.cloud.secretmanager.v1.Rotation.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 11: {
                                        if (message.versionAliases === $util.emptyObject)
                                            message.versionAliases = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = 0;
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.int64();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.versionAliases[key] = value;
                                        break;
                                    }
                                case 13: {
                                        if (message.annotations === $util.emptyObject)
                                            message.annotations = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.annotations[key] = value;
                                        break;
                                    }
                                case 14: {
                                        message.versionDestroyTtl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 15: {
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Secret message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.Secret} Secret
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Secret.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Secret message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Secret.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.replication != null && message.hasOwnProperty("replication")) {
                                var error = $root.google.cloud.secretmanager.v1.Replication.verify(message.replication);
                                if (error)
                                    return "replication." + error;
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            if (message.topics != null && message.hasOwnProperty("topics")) {
                                if (!Array.isArray(message.topics))
                                    return "topics: array expected";
                                for (var i = 0; i < message.topics.length; ++i) {
                                    var error = $root.google.cloud.secretmanager.v1.Topic.verify(message.topics[i]);
                                    if (error)
                                        return "topics." + error;
                                }
                            }
                            if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                                properties.expiration = 1;
                                {
                                    var error = $root.google.protobuf.Timestamp.verify(message.expireTime);
                                    if (error)
                                        return "expireTime." + error;
                                }
                            }
                            if (message.ttl != null && message.hasOwnProperty("ttl")) {
                                if (properties.expiration === 1)
                                    return "expiration: multiple values";
                                properties.expiration = 1;
                                {
                                    var error = $root.google.protobuf.Duration.verify(message.ttl);
                                    if (error)
                                        return "ttl." + error;
                                }
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.rotation != null && message.hasOwnProperty("rotation")) {
                                var error = $root.google.cloud.secretmanager.v1.Rotation.verify(message.rotation);
                                if (error)
                                    return "rotation." + error;
                            }
                            if (message.versionAliases != null && message.hasOwnProperty("versionAliases")) {
                                if (!$util.isObject(message.versionAliases))
                                    return "versionAliases: object expected";
                                var key = Object.keys(message.versionAliases);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isInteger(message.versionAliases[key[i]]) && !(message.versionAliases[key[i]] && $util.isInteger(message.versionAliases[key[i]].low) && $util.isInteger(message.versionAliases[key[i]].high)))
                                        return "versionAliases: integer|Long{k:string} expected";
                            }
                            if (message.annotations != null && message.hasOwnProperty("annotations")) {
                                if (!$util.isObject(message.annotations))
                                    return "annotations: object expected";
                                var key = Object.keys(message.annotations);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.annotations[key[i]]))
                                        return "annotations: string{k:string} expected";
                            }
                            if (message.versionDestroyTtl != null && message.hasOwnProperty("versionDestroyTtl")) {
                                var error = $root.google.protobuf.Duration.verify(message.versionDestroyTtl);
                                if (error)
                                    return "versionDestroyTtl." + error;
                            }
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                var error = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.verify(message.customerManagedEncryption);
                                if (error)
                                    return "customerManagedEncryption." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Secret message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.Secret} Secret
                         */
                        Secret.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.Secret)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.Secret();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.replication != null) {
                                if (typeof object.replication !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.replication: object expected");
                                message.replication = $root.google.cloud.secretmanager.v1.Replication.fromObject(object.replication);
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            if (object.topics) {
                                if (!Array.isArray(object.topics))
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.topics: array expected");
                                message.topics = [];
                                for (var i = 0; i < object.topics.length; ++i) {
                                    if (typeof object.topics[i] !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1.Secret.topics: object expected");
                                    message.topics[i] = $root.google.cloud.secretmanager.v1.Topic.fromObject(object.topics[i]);
                                }
                            }
                            if (object.expireTime != null) {
                                if (typeof object.expireTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.expireTime: object expected");
                                message.expireTime = $root.google.protobuf.Timestamp.fromObject(object.expireTime);
                            }
                            if (object.ttl != null) {
                                if (typeof object.ttl !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.ttl: object expected");
                                message.ttl = $root.google.protobuf.Duration.fromObject(object.ttl);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            if (object.rotation != null) {
                                if (typeof object.rotation !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.rotation: object expected");
                                message.rotation = $root.google.cloud.secretmanager.v1.Rotation.fromObject(object.rotation);
                            }
                            if (object.versionAliases) {
                                if (typeof object.versionAliases !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.versionAliases: object expected");
                                message.versionAliases = {};
                                for (var keys = Object.keys(object.versionAliases), i = 0; i < keys.length; ++i)
                                    if ($util.Long)
                                        (message.versionAliases[keys[i]] = $util.Long.fromValue(object.versionAliases[keys[i]])).unsigned = false;
                                    else if (typeof object.versionAliases[keys[i]] === "string")
                                        message.versionAliases[keys[i]] = parseInt(object.versionAliases[keys[i]], 10);
                                    else if (typeof object.versionAliases[keys[i]] === "number")
                                        message.versionAliases[keys[i]] = object.versionAliases[keys[i]];
                                    else if (typeof object.versionAliases[keys[i]] === "object")
                                        message.versionAliases[keys[i]] = new $util.LongBits(object.versionAliases[keys[i]].low >>> 0, object.versionAliases[keys[i]].high >>> 0).toNumber();
                            }
                            if (object.annotations) {
                                if (typeof object.annotations !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.annotations: object expected");
                                message.annotations = {};
                                for (var keys = Object.keys(object.annotations), i = 0; i < keys.length; ++i)
                                    message.annotations[keys[i]] = String(object.annotations[keys[i]]);
                            }
                            if (object.versionDestroyTtl != null) {
                                if (typeof object.versionDestroyTtl !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.versionDestroyTtl: object expected");
                                message.versionDestroyTtl = $root.google.protobuf.Duration.fromObject(object.versionDestroyTtl);
                            }
                            if (object.customerManagedEncryption != null) {
                                if (typeof object.customerManagedEncryption !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Secret.customerManagedEncryption: object expected");
                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.fromObject(object.customerManagedEncryption);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Secret message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1.Secret} message Secret
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Secret.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.topics = [];
                            if (options.objects || options.defaults) {
                                object.labels = {};
                                object.versionAliases = {};
                                object.annotations = {};
                            }
                            if (options.defaults) {
                                object.name = "";
                                object.replication = null;
                                object.createTime = null;
                                object.etag = "";
                                object.rotation = null;
                                object.versionDestroyTtl = null;
                                object.customerManagedEncryption = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.replication != null && message.hasOwnProperty("replication"))
                                object.replication = $root.google.cloud.secretmanager.v1.Replication.toObject(message.replication, options);
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            if (message.topics && message.topics.length) {
                                object.topics = [];
                                for (var j = 0; j < message.topics.length; ++j)
                                    object.topics[j] = $root.google.cloud.secretmanager.v1.Topic.toObject(message.topics[j], options);
                            }
                            if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                                object.expireTime = $root.google.protobuf.Timestamp.toObject(message.expireTime, options);
                                if (options.oneofs)
                                    object.expiration = "expireTime";
                            }
                            if (message.ttl != null && message.hasOwnProperty("ttl")) {
                                object.ttl = $root.google.protobuf.Duration.toObject(message.ttl, options);
                                if (options.oneofs)
                                    object.expiration = "ttl";
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            if (message.rotation != null && message.hasOwnProperty("rotation"))
                                object.rotation = $root.google.cloud.secretmanager.v1.Rotation.toObject(message.rotation, options);
                            if (message.versionAliases && (keys2 = Object.keys(message.versionAliases)).length) {
                                object.versionAliases = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    if (typeof message.versionAliases[keys2[j]] === "number")
                                        object.versionAliases[keys2[j]] = options.longs === String ? String(message.versionAliases[keys2[j]]) : message.versionAliases[keys2[j]];
                                    else
                                        object.versionAliases[keys2[j]] = options.longs === String ? $util.Long.prototype.toString.call(message.versionAliases[keys2[j]]) : options.longs === Number ? new $util.LongBits(message.versionAliases[keys2[j]].low >>> 0, message.versionAliases[keys2[j]].high >>> 0).toNumber() : message.versionAliases[keys2[j]];
                            }
                            if (message.annotations && (keys2 = Object.keys(message.annotations)).length) {
                                object.annotations = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.annotations[keys2[j]] = message.annotations[keys2[j]];
                            }
                            if (message.versionDestroyTtl != null && message.hasOwnProperty("versionDestroyTtl"))
                                object.versionDestroyTtl = $root.google.protobuf.Duration.toObject(message.versionDestroyTtl, options);
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                object.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.toObject(message.customerManagedEncryption, options);
                            return object;
                        };
    
                        /**
                         * Converts this Secret to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Secret.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Secret
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.Secret
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Secret.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.Secret";
                        };
    
                        return Secret;
                    })();
    
                    v1.SecretVersion = (function() {
    
                        /**
                         * Properties of a SecretVersion.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ISecretVersion
                         * @property {string|null} [name] SecretVersion name
                         * @property {google.protobuf.ITimestamp|null} [createTime] SecretVersion createTime
                         * @property {google.protobuf.ITimestamp|null} [destroyTime] SecretVersion destroyTime
                         * @property {google.cloud.secretmanager.v1.SecretVersion.State|null} [state] SecretVersion state
                         * @property {google.cloud.secretmanager.v1.IReplicationStatus|null} [replicationStatus] SecretVersion replicationStatus
                         * @property {string|null} [etag] SecretVersion etag
                         * @property {boolean|null} [clientSpecifiedPayloadChecksum] SecretVersion clientSpecifiedPayloadChecksum
                         * @property {google.protobuf.ITimestamp|null} [scheduledDestroyTime] SecretVersion scheduledDestroyTime
                         * @property {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus|null} [customerManagedEncryption] SecretVersion customerManagedEncryption
                         */
    
                        /**
                         * Constructs a new SecretVersion.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a SecretVersion.
                         * @implements ISecretVersion
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ISecretVersion=} [properties] Properties to set
                         */
                        function SecretVersion(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SecretVersion name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.name = "";
    
                        /**
                         * SecretVersion createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.createTime = null;
    
                        /**
                         * SecretVersion destroyTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} destroyTime
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.destroyTime = null;
    
                        /**
                         * SecretVersion state.
                         * @member {google.cloud.secretmanager.v1.SecretVersion.State} state
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.state = 0;
    
                        /**
                         * SecretVersion replicationStatus.
                         * @member {google.cloud.secretmanager.v1.IReplicationStatus|null|undefined} replicationStatus
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.replicationStatus = null;
    
                        /**
                         * SecretVersion etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.etag = "";
    
                        /**
                         * SecretVersion clientSpecifiedPayloadChecksum.
                         * @member {boolean} clientSpecifiedPayloadChecksum
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.clientSpecifiedPayloadChecksum = false;
    
                        /**
                         * SecretVersion scheduledDestroyTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} scheduledDestroyTime
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.scheduledDestroyTime = null;
    
                        /**
                         * SecretVersion customerManagedEncryption.
                         * @member {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus|null|undefined} customerManagedEncryption
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.customerManagedEncryption = null;
    
                        /**
                         * Creates a new SecretVersion instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecretVersion=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.SecretVersion} SecretVersion instance
                         */
                        SecretVersion.create = function create(properties) {
                            return new SecretVersion(properties);
                        };
    
                        /**
                         * Encodes the specified SecretVersion message. Does not implicitly {@link google.cloud.secretmanager.v1.SecretVersion.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecretVersion} message SecretVersion message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretVersion.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.destroyTime != null && Object.hasOwnProperty.call(message, "destroyTime"))
                                $root.google.protobuf.Timestamp.encode(message.destroyTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.state);
                            if (message.replicationStatus != null && Object.hasOwnProperty.call(message, "replicationStatus"))
                                $root.google.cloud.secretmanager.v1.ReplicationStatus.encode(message.replicationStatus, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.etag);
                            if (message.clientSpecifiedPayloadChecksum != null && Object.hasOwnProperty.call(message, "clientSpecifiedPayloadChecksum"))
                                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.clientSpecifiedPayloadChecksum);
                            if (message.scheduledDestroyTime != null && Object.hasOwnProperty.call(message, "scheduledDestroyTime"))
                                $root.google.protobuf.Timestamp.encode(message.scheduledDestroyTime, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.encode(message.customerManagedEncryption, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SecretVersion message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.SecretVersion.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecretVersion} message SecretVersion message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretVersion.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SecretVersion message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.SecretVersion} SecretVersion
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretVersion.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.SecretVersion();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.destroyTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.replicationStatus = $root.google.cloud.secretmanager.v1.ReplicationStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 7: {
                                        message.clientSpecifiedPayloadChecksum = reader.bool();
                                        break;
                                    }
                                case 8: {
                                        message.scheduledDestroyTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SecretVersion message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.SecretVersion} SecretVersion
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretVersion.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SecretVersion message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SecretVersion.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.destroyTime != null && message.hasOwnProperty("destroyTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.destroyTime);
                                if (error)
                                    return "destroyTime." + error;
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.replicationStatus != null && message.hasOwnProperty("replicationStatus")) {
                                var error = $root.google.cloud.secretmanager.v1.ReplicationStatus.verify(message.replicationStatus);
                                if (error)
                                    return "replicationStatus." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.clientSpecifiedPayloadChecksum != null && message.hasOwnProperty("clientSpecifiedPayloadChecksum"))
                                if (typeof message.clientSpecifiedPayloadChecksum !== "boolean")
                                    return "clientSpecifiedPayloadChecksum: boolean expected";
                            if (message.scheduledDestroyTime != null && message.hasOwnProperty("scheduledDestroyTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.scheduledDestroyTime);
                                if (error)
                                    return "scheduledDestroyTime." + error;
                            }
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                var error = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.verify(message.customerManagedEncryption);
                                if (error)
                                    return "customerManagedEncryption." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SecretVersion message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.SecretVersion} SecretVersion
                         */
                        SecretVersion.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.SecretVersion)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.SecretVersion();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.SecretVersion.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.destroyTime != null) {
                                if (typeof object.destroyTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.SecretVersion.destroyTime: object expected");
                                message.destroyTime = $root.google.protobuf.Timestamp.fromObject(object.destroyTime);
                            }
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ENABLED":
                            case 1:
                                message.state = 1;
                                break;
                            case "DISABLED":
                            case 2:
                                message.state = 2;
                                break;
                            case "DESTROYED":
                            case 3:
                                message.state = 3;
                                break;
                            }
                            if (object.replicationStatus != null) {
                                if (typeof object.replicationStatus !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.SecretVersion.replicationStatus: object expected");
                                message.replicationStatus = $root.google.cloud.secretmanager.v1.ReplicationStatus.fromObject(object.replicationStatus);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            if (object.clientSpecifiedPayloadChecksum != null)
                                message.clientSpecifiedPayloadChecksum = Boolean(object.clientSpecifiedPayloadChecksum);
                            if (object.scheduledDestroyTime != null) {
                                if (typeof object.scheduledDestroyTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.SecretVersion.scheduledDestroyTime: object expected");
                                message.scheduledDestroyTime = $root.google.protobuf.Timestamp.fromObject(object.scheduledDestroyTime);
                            }
                            if (object.customerManagedEncryption != null) {
                                if (typeof object.customerManagedEncryption !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.SecretVersion.customerManagedEncryption: object expected");
                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.fromObject(object.customerManagedEncryption);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SecretVersion message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1.SecretVersion} message SecretVersion
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SecretVersion.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.createTime = null;
                                object.destroyTime = null;
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.replicationStatus = null;
                                object.etag = "";
                                object.clientSpecifiedPayloadChecksum = false;
                                object.scheduledDestroyTime = null;
                                object.customerManagedEncryption = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.destroyTime != null && message.hasOwnProperty("destroyTime"))
                                object.destroyTime = $root.google.protobuf.Timestamp.toObject(message.destroyTime, options);
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.cloud.secretmanager.v1.SecretVersion.State[message.state] === undefined ? message.state : $root.google.cloud.secretmanager.v1.SecretVersion.State[message.state] : message.state;
                            if (message.replicationStatus != null && message.hasOwnProperty("replicationStatus"))
                                object.replicationStatus = $root.google.cloud.secretmanager.v1.ReplicationStatus.toObject(message.replicationStatus, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            if (message.clientSpecifiedPayloadChecksum != null && message.hasOwnProperty("clientSpecifiedPayloadChecksum"))
                                object.clientSpecifiedPayloadChecksum = message.clientSpecifiedPayloadChecksum;
                            if (message.scheduledDestroyTime != null && message.hasOwnProperty("scheduledDestroyTime"))
                                object.scheduledDestroyTime = $root.google.protobuf.Timestamp.toObject(message.scheduledDestroyTime, options);
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                object.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.toObject(message.customerManagedEncryption, options);
                            return object;
                        };
    
                        /**
                         * Converts this SecretVersion to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SecretVersion.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SecretVersion
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.SecretVersion
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SecretVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.SecretVersion";
                        };
    
                        /**
                         * State enum.
                         * @name google.cloud.secretmanager.v1.SecretVersion.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ENABLED=1 ENABLED value
                         * @property {number} DISABLED=2 DISABLED value
                         * @property {number} DESTROYED=3 DESTROYED value
                         */
                        SecretVersion.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ENABLED"] = 1;
                            values[valuesById[2] = "DISABLED"] = 2;
                            values[valuesById[3] = "DESTROYED"] = 3;
                            return values;
                        })();
    
                        return SecretVersion;
                    })();
    
                    v1.Replication = (function() {
    
                        /**
                         * Properties of a Replication.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IReplication
                         * @property {google.cloud.secretmanager.v1.Replication.IAutomatic|null} [automatic] Replication automatic
                         * @property {google.cloud.secretmanager.v1.Replication.IUserManaged|null} [userManaged] Replication userManaged
                         */
    
                        /**
                         * Constructs a new Replication.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a Replication.
                         * @implements IReplication
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IReplication=} [properties] Properties to set
                         */
                        function Replication(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Replication automatic.
                         * @member {google.cloud.secretmanager.v1.Replication.IAutomatic|null|undefined} automatic
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @instance
                         */
                        Replication.prototype.automatic = null;
    
                        /**
                         * Replication userManaged.
                         * @member {google.cloud.secretmanager.v1.Replication.IUserManaged|null|undefined} userManaged
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @instance
                         */
                        Replication.prototype.userManaged = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Replication replication.
                         * @member {"automatic"|"userManaged"|undefined} replication
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @instance
                         */
                        Object.defineProperty(Replication.prototype, "replication", {
                            get: $util.oneOfGetter($oneOfFields = ["automatic", "userManaged"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Replication instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1.IReplication=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.Replication} Replication instance
                         */
                        Replication.create = function create(properties) {
                            return new Replication(properties);
                        };
    
                        /**
                         * Encodes the specified Replication message. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1.IReplication} message Replication message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Replication.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.automatic != null && Object.hasOwnProperty.call(message, "automatic"))
                                $root.google.cloud.secretmanager.v1.Replication.Automatic.encode(message.automatic, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.userManaged != null && Object.hasOwnProperty.call(message, "userManaged"))
                                $root.google.cloud.secretmanager.v1.Replication.UserManaged.encode(message.userManaged, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Replication message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1.IReplication} message Replication message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Replication.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Replication message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.Replication} Replication
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Replication.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Replication();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.automatic = $root.google.cloud.secretmanager.v1.Replication.Automatic.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.userManaged = $root.google.cloud.secretmanager.v1.Replication.UserManaged.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Replication message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.Replication} Replication
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Replication.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Replication message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Replication.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                properties.replication = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1.Replication.Automatic.verify(message.automatic);
                                    if (error)
                                        return "automatic." + error;
                                }
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                if (properties.replication === 1)
                                    return "replication: multiple values";
                                properties.replication = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1.Replication.UserManaged.verify(message.userManaged);
                                    if (error)
                                        return "userManaged." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Replication message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.Replication} Replication
                         */
                        Replication.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.Replication)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.Replication();
                            if (object.automatic != null) {
                                if (typeof object.automatic !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Replication.automatic: object expected");
                                message.automatic = $root.google.cloud.secretmanager.v1.Replication.Automatic.fromObject(object.automatic);
                            }
                            if (object.userManaged != null) {
                                if (typeof object.userManaged !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Replication.userManaged: object expected");
                                message.userManaged = $root.google.cloud.secretmanager.v1.Replication.UserManaged.fromObject(object.userManaged);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Replication message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1.Replication} message Replication
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Replication.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                object.automatic = $root.google.cloud.secretmanager.v1.Replication.Automatic.toObject(message.automatic, options);
                                if (options.oneofs)
                                    object.replication = "automatic";
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                object.userManaged = $root.google.cloud.secretmanager.v1.Replication.UserManaged.toObject(message.userManaged, options);
                                if (options.oneofs)
                                    object.replication = "userManaged";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Replication to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Replication.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Replication
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.Replication
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Replication.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.Replication";
                        };
    
                        Replication.Automatic = (function() {
    
                            /**
                             * Properties of an Automatic.
                             * @memberof google.cloud.secretmanager.v1.Replication
                             * @interface IAutomatic
                             * @property {google.cloud.secretmanager.v1.ICustomerManagedEncryption|null} [customerManagedEncryption] Automatic customerManagedEncryption
                             */
    
                            /**
                             * Constructs a new Automatic.
                             * @memberof google.cloud.secretmanager.v1.Replication
                             * @classdesc Represents an Automatic.
                             * @implements IAutomatic
                             * @constructor
                             * @param {google.cloud.secretmanager.v1.Replication.IAutomatic=} [properties] Properties to set
                             */
                            function Automatic(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Automatic customerManagedEncryption.
                             * @member {google.cloud.secretmanager.v1.ICustomerManagedEncryption|null|undefined} customerManagedEncryption
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @instance
                             */
                            Automatic.prototype.customerManagedEncryption = null;
    
                            /**
                             * Creates a new Automatic instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.IAutomatic=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1.Replication.Automatic} Automatic instance
                             */
                            Automatic.create = function create(properties) {
                                return new Automatic(properties);
                            };
    
                            /**
                             * Encodes the specified Automatic message. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.Automatic.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.IAutomatic} message Automatic message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Automatic.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                    $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.encode(message.customerManagedEncryption, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified Automatic message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.Automatic.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.IAutomatic} message Automatic message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Automatic.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an Automatic message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1.Replication.Automatic} Automatic
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Automatic.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Replication.Automatic();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an Automatic message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1.Replication.Automatic} Automatic
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Automatic.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an Automatic message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            Automatic.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                    var error = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.verify(message.customerManagedEncryption);
                                    if (error)
                                        return "customerManagedEncryption." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates an Automatic message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1.Replication.Automatic} Automatic
                             */
                            Automatic.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1.Replication.Automatic)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1.Replication.Automatic();
                                if (object.customerManagedEncryption != null) {
                                    if (typeof object.customerManagedEncryption !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1.Replication.Automatic.customerManagedEncryption: object expected");
                                    message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.fromObject(object.customerManagedEncryption);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an Automatic message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.Automatic} message Automatic
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            Automatic.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.customerManagedEncryption = null;
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                    object.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.toObject(message.customerManagedEncryption, options);
                                return object;
                            };
    
                            /**
                             * Converts this Automatic to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            Automatic.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for Automatic
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1.Replication.Automatic
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            Automatic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1.Replication.Automatic";
                            };
    
                            return Automatic;
                        })();
    
                        Replication.UserManaged = (function() {
    
                            /**
                             * Properties of a UserManaged.
                             * @memberof google.cloud.secretmanager.v1.Replication
                             * @interface IUserManaged
                             * @property {Array.<google.cloud.secretmanager.v1.Replication.UserManaged.IReplica>|null} [replicas] UserManaged replicas
                             */
    
                            /**
                             * Constructs a new UserManaged.
                             * @memberof google.cloud.secretmanager.v1.Replication
                             * @classdesc Represents a UserManaged.
                             * @implements IUserManaged
                             * @constructor
                             * @param {google.cloud.secretmanager.v1.Replication.IUserManaged=} [properties] Properties to set
                             */
                            function UserManaged(properties) {
                                this.replicas = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * UserManaged replicas.
                             * @member {Array.<google.cloud.secretmanager.v1.Replication.UserManaged.IReplica>} replicas
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @instance
                             */
                            UserManaged.prototype.replicas = $util.emptyArray;
    
                            /**
                             * Creates a new UserManaged instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.IUserManaged=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1.Replication.UserManaged} UserManaged instance
                             */
                            UserManaged.create = function create(properties) {
                                return new UserManaged(properties);
                            };
    
                            /**
                             * Encodes the specified UserManaged message. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.UserManaged.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.IUserManaged} message UserManaged message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManaged.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.replicas != null && message.replicas.length)
                                    for (var i = 0; i < message.replicas.length; ++i)
                                        $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.encode(message.replicas[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified UserManaged message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.UserManaged.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.IUserManaged} message UserManaged message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManaged.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a UserManaged message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1.Replication.UserManaged} UserManaged
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManaged.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Replication.UserManaged();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.replicas && message.replicas.length))
                                                message.replicas = [];
                                            message.replicas.push($root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a UserManaged message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1.Replication.UserManaged} UserManaged
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManaged.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a UserManaged message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            UserManaged.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.replicas != null && message.hasOwnProperty("replicas")) {
                                    if (!Array.isArray(message.replicas))
                                        return "replicas: array expected";
                                    for (var i = 0; i < message.replicas.length; ++i) {
                                        var error = $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.verify(message.replicas[i]);
                                        if (error)
                                            return "replicas." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a UserManaged message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1.Replication.UserManaged} UserManaged
                             */
                            UserManaged.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1.Replication.UserManaged)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1.Replication.UserManaged();
                                if (object.replicas) {
                                    if (!Array.isArray(object.replicas))
                                        throw TypeError(".google.cloud.secretmanager.v1.Replication.UserManaged.replicas: array expected");
                                    message.replicas = [];
                                    for (var i = 0; i < object.replicas.length; ++i) {
                                        if (typeof object.replicas[i] !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1.Replication.UserManaged.replicas: object expected");
                                        message.replicas[i] = $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.fromObject(object.replicas[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a UserManaged message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1.Replication.UserManaged} message UserManaged
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            UserManaged.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.replicas = [];
                                if (message.replicas && message.replicas.length) {
                                    object.replicas = [];
                                    for (var j = 0; j < message.replicas.length; ++j)
                                        object.replicas[j] = $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.toObject(message.replicas[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this UserManaged to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            UserManaged.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for UserManaged
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            UserManaged.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1.Replication.UserManaged";
                            };
    
                            UserManaged.Replica = (function() {
    
                                /**
                                 * Properties of a Replica.
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                                 * @interface IReplica
                                 * @property {string|null} [location] Replica location
                                 * @property {google.cloud.secretmanager.v1.ICustomerManagedEncryption|null} [customerManagedEncryption] Replica customerManagedEncryption
                                 */
    
                                /**
                                 * Constructs a new Replica.
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged
                                 * @classdesc Represents a Replica.
                                 * @implements IReplica
                                 * @constructor
                                 * @param {google.cloud.secretmanager.v1.Replication.UserManaged.IReplica=} [properties] Properties to set
                                 */
                                function Replica(properties) {
                                    if (properties)
                                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                            if (properties[keys[i]] != null)
                                                this[keys[i]] = properties[keys[i]];
                                }
    
                                /**
                                 * Replica location.
                                 * @member {string} location
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @instance
                                 */
                                Replica.prototype.location = "";
    
                                /**
                                 * Replica customerManagedEncryption.
                                 * @member {google.cloud.secretmanager.v1.ICustomerManagedEncryption|null|undefined} customerManagedEncryption
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @instance
                                 */
                                Replica.prototype.customerManagedEncryption = null;
    
                                /**
                                 * Creates a new Replica instance using the specified properties.
                                 * @function create
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.Replication.UserManaged.IReplica=} [properties] Properties to set
                                 * @returns {google.cloud.secretmanager.v1.Replication.UserManaged.Replica} Replica instance
                                 */
                                Replica.create = function create(properties) {
                                    return new Replica(properties);
                                };
    
                                /**
                                 * Encodes the specified Replica message. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.UserManaged.Replica.verify|verify} messages.
                                 * @function encode
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.Replication.UserManaged.IReplica} message Replica message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                Replica.encode = function encode(message, writer) {
                                    if (!writer)
                                        writer = $Writer.create();
                                    if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.location);
                                    if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                        $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.encode(message.customerManagedEncryption, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                    return writer;
                                };
    
                                /**
                                 * Encodes the specified Replica message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Replication.UserManaged.Replica.verify|verify} messages.
                                 * @function encodeDelimited
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.Replication.UserManaged.IReplica} message Replica message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                Replica.encodeDelimited = function encodeDelimited(message, writer) {
                                    return this.encode(message, writer).ldelim();
                                };
    
                                /**
                                 * Decodes a Replica message from the specified reader or buffer.
                                 * @function decode
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @param {number} [length] Message length if known beforehand
                                 * @returns {google.cloud.secretmanager.v1.Replication.UserManaged.Replica} Replica
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                Replica.decode = function decode(reader, length) {
                                    if (!(reader instanceof $Reader))
                                        reader = $Reader.create(reader);
                                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica();
                                    while (reader.pos < end) {
                                        var tag = reader.uint32();
                                        switch (tag >>> 3) {
                                        case 1: {
                                                message.location = reader.string();
                                                break;
                                            }
                                        case 2: {
                                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.decode(reader, reader.uint32());
                                                break;
                                            }
                                        default:
                                            reader.skipType(tag & 7);
                                            break;
                                        }
                                    }
                                    return message;
                                };
    
                                /**
                                 * Decodes a Replica message from the specified reader or buffer, length delimited.
                                 * @function decodeDelimited
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @returns {google.cloud.secretmanager.v1.Replication.UserManaged.Replica} Replica
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                Replica.decodeDelimited = function decodeDelimited(reader) {
                                    if (!(reader instanceof $Reader))
                                        reader = new $Reader(reader);
                                    return this.decode(reader, reader.uint32());
                                };
    
                                /**
                                 * Verifies a Replica message.
                                 * @function verify
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {Object.<string,*>} message Plain object to verify
                                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                                 */
                                Replica.verify = function verify(message) {
                                    if (typeof message !== "object" || message === null)
                                        return "object expected";
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        if (!$util.isString(message.location))
                                            return "location: string expected";
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                        var error = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.verify(message.customerManagedEncryption);
                                        if (error)
                                            return "customerManagedEncryption." + error;
                                    }
                                    return null;
                                };
    
                                /**
                                 * Creates a Replica message from a plain object. Also converts values to their respective internal types.
                                 * @function fromObject
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {Object.<string,*>} object Plain object
                                 * @returns {google.cloud.secretmanager.v1.Replication.UserManaged.Replica} Replica
                                 */
                                Replica.fromObject = function fromObject(object) {
                                    if (object instanceof $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica)
                                        return object;
                                    var message = new $root.google.cloud.secretmanager.v1.Replication.UserManaged.Replica();
                                    if (object.location != null)
                                        message.location = String(object.location);
                                    if (object.customerManagedEncryption != null) {
                                        if (typeof object.customerManagedEncryption !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1.Replication.UserManaged.Replica.customerManagedEncryption: object expected");
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.fromObject(object.customerManagedEncryption);
                                    }
                                    return message;
                                };
    
                                /**
                                 * Creates a plain object from a Replica message. Also converts values to other types if specified.
                                 * @function toObject
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.Replication.UserManaged.Replica} message Replica
                                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                                 * @returns {Object.<string,*>} Plain object
                                 */
                                Replica.toObject = function toObject(message, options) {
                                    if (!options)
                                        options = {};
                                    var object = {};
                                    if (options.defaults) {
                                        object.location = "";
                                        object.customerManagedEncryption = null;
                                    }
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        object.location = message.location;
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                        object.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryption.toObject(message.customerManagedEncryption, options);
                                    return object;
                                };
    
                                /**
                                 * Converts this Replica to JSON.
                                 * @function toJSON
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @instance
                                 * @returns {Object.<string,*>} JSON object
                                 */
                                Replica.prototype.toJSON = function toJSON() {
                                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                                };
    
                                /**
                                 * Gets the default type url for Replica
                                 * @function getTypeUrl
                                 * @memberof google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                                 * @static
                                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                                 * @returns {string} The default type url
                                 */
                                Replica.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                    if (typeUrlPrefix === undefined) {
                                        typeUrlPrefix = "type.googleapis.com";
                                    }
                                    return typeUrlPrefix + "/google.cloud.secretmanager.v1.Replication.UserManaged.Replica";
                                };
    
                                return Replica;
                            })();
    
                            return UserManaged;
                        })();
    
                        return Replication;
                    })();
    
                    v1.CustomerManagedEncryption = (function() {
    
                        /**
                         * Properties of a CustomerManagedEncryption.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ICustomerManagedEncryption
                         * @property {string|null} [kmsKeyName] CustomerManagedEncryption kmsKeyName
                         */
    
                        /**
                         * Constructs a new CustomerManagedEncryption.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a CustomerManagedEncryption.
                         * @implements ICustomerManagedEncryption
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryption=} [properties] Properties to set
                         */
                        function CustomerManagedEncryption(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CustomerManagedEncryption kmsKeyName.
                         * @member {string} kmsKeyName
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @instance
                         */
                        CustomerManagedEncryption.prototype.kmsKeyName = "";
    
                        /**
                         * Creates a new CustomerManagedEncryption instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryption=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryption} CustomerManagedEncryption instance
                         */
                        CustomerManagedEncryption.create = function create(properties) {
                            return new CustomerManagedEncryption(properties);
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryption message. Does not implicitly {@link google.cloud.secretmanager.v1.CustomerManagedEncryption.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryption} message CustomerManagedEncryption message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryption.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.kmsKeyName != null && Object.hasOwnProperty.call(message, "kmsKeyName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.kmsKeyName);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryption message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.CustomerManagedEncryption.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryption} message CustomerManagedEncryption message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryption.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryption message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryption} CustomerManagedEncryption
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryption.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.CustomerManagedEncryption();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.kmsKeyName = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryption message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryption} CustomerManagedEncryption
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryption.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CustomerManagedEncryption message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CustomerManagedEncryption.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                                if (!$util.isString(message.kmsKeyName))
                                    return "kmsKeyName: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CustomerManagedEncryption message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryption} CustomerManagedEncryption
                         */
                        CustomerManagedEncryption.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.CustomerManagedEncryption)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.CustomerManagedEncryption();
                            if (object.kmsKeyName != null)
                                message.kmsKeyName = String(object.kmsKeyName);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CustomerManagedEncryption message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1.CustomerManagedEncryption} message CustomerManagedEncryption
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CustomerManagedEncryption.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.kmsKeyName = "";
                            if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                                object.kmsKeyName = message.kmsKeyName;
                            return object;
                        };
    
                        /**
                         * Converts this CustomerManagedEncryption to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CustomerManagedEncryption.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CustomerManagedEncryption
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryption
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CustomerManagedEncryption.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.CustomerManagedEncryption";
                        };
    
                        return CustomerManagedEncryption;
                    })();
    
                    v1.ReplicationStatus = (function() {
    
                        /**
                         * Properties of a ReplicationStatus.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IReplicationStatus
                         * @property {google.cloud.secretmanager.v1.ReplicationStatus.IAutomaticStatus|null} [automatic] ReplicationStatus automatic
                         * @property {google.cloud.secretmanager.v1.ReplicationStatus.IUserManagedStatus|null} [userManaged] ReplicationStatus userManaged
                         */
    
                        /**
                         * Constructs a new ReplicationStatus.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a ReplicationStatus.
                         * @implements IReplicationStatus
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IReplicationStatus=} [properties] Properties to set
                         */
                        function ReplicationStatus(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReplicationStatus automatic.
                         * @member {google.cloud.secretmanager.v1.ReplicationStatus.IAutomaticStatus|null|undefined} automatic
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @instance
                         */
                        ReplicationStatus.prototype.automatic = null;
    
                        /**
                         * ReplicationStatus userManaged.
                         * @member {google.cloud.secretmanager.v1.ReplicationStatus.IUserManagedStatus|null|undefined} userManaged
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @instance
                         */
                        ReplicationStatus.prototype.userManaged = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ReplicationStatus replicationStatus.
                         * @member {"automatic"|"userManaged"|undefined} replicationStatus
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @instance
                         */
                        Object.defineProperty(ReplicationStatus.prototype, "replicationStatus", {
                            get: $util.oneOfGetter($oneOfFields = ["automatic", "userManaged"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ReplicationStatus instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.IReplicationStatus=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.ReplicationStatus} ReplicationStatus instance
                         */
                        ReplicationStatus.create = function create(properties) {
                            return new ReplicationStatus(properties);
                        };
    
                        /**
                         * Encodes the specified ReplicationStatus message. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.IReplicationStatus} message ReplicationStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplicationStatus.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.automatic != null && Object.hasOwnProperty.call(message, "automatic"))
                                $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.encode(message.automatic, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.userManaged != null && Object.hasOwnProperty.call(message, "userManaged"))
                                $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.encode(message.userManaged, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReplicationStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.IReplicationStatus} message ReplicationStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplicationStatus.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReplicationStatus message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.ReplicationStatus} ReplicationStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplicationStatus.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ReplicationStatus();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.automatic = $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.userManaged = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReplicationStatus message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.ReplicationStatus} ReplicationStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplicationStatus.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReplicationStatus message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReplicationStatus.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                properties.replicationStatus = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.verify(message.automatic);
                                    if (error)
                                        return "automatic." + error;
                                }
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                if (properties.replicationStatus === 1)
                                    return "replicationStatus: multiple values";
                                properties.replicationStatus = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.verify(message.userManaged);
                                    if (error)
                                        return "userManaged." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ReplicationStatus message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.ReplicationStatus} ReplicationStatus
                         */
                        ReplicationStatus.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.ReplicationStatus)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.ReplicationStatus();
                            if (object.automatic != null) {
                                if (typeof object.automatic !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.ReplicationStatus.automatic: object expected");
                                message.automatic = $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.fromObject(object.automatic);
                            }
                            if (object.userManaged != null) {
                                if (typeof object.userManaged !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.ReplicationStatus.userManaged: object expected");
                                message.userManaged = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.fromObject(object.userManaged);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReplicationStatus message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.ReplicationStatus} message ReplicationStatus
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReplicationStatus.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                object.automatic = $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.toObject(message.automatic, options);
                                if (options.oneofs)
                                    object.replicationStatus = "automatic";
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                object.userManaged = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.toObject(message.userManaged, options);
                                if (options.oneofs)
                                    object.replicationStatus = "userManaged";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ReplicationStatus to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReplicationStatus.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ReplicationStatus
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ReplicationStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.ReplicationStatus";
                        };
    
                        ReplicationStatus.AutomaticStatus = (function() {
    
                            /**
                             * Properties of an AutomaticStatus.
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                             * @interface IAutomaticStatus
                             * @property {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus|null} [customerManagedEncryption] AutomaticStatus customerManagedEncryption
                             */
    
                            /**
                             * Constructs a new AutomaticStatus.
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                             * @classdesc Represents an AutomaticStatus.
                             * @implements IAutomaticStatus
                             * @constructor
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IAutomaticStatus=} [properties] Properties to set
                             */
                            function AutomaticStatus(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * AutomaticStatus customerManagedEncryption.
                             * @member {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus|null|undefined} customerManagedEncryption
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @instance
                             */
                            AutomaticStatus.prototype.customerManagedEncryption = null;
    
                            /**
                             * Creates a new AutomaticStatus instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IAutomaticStatus=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus} AutomaticStatus instance
                             */
                            AutomaticStatus.create = function create(properties) {
                                return new AutomaticStatus(properties);
                            };
    
                            /**
                             * Encodes the specified AutomaticStatus message. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IAutomaticStatus} message AutomaticStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AutomaticStatus.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                    $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.encode(message.customerManagedEncryption, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified AutomaticStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IAutomaticStatus} message AutomaticStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AutomaticStatus.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an AutomaticStatus message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus} AutomaticStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AutomaticStatus.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an AutomaticStatus message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus} AutomaticStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AutomaticStatus.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an AutomaticStatus message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            AutomaticStatus.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                    var error = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.verify(message.customerManagedEncryption);
                                    if (error)
                                        return "customerManagedEncryption." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates an AutomaticStatus message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus} AutomaticStatus
                             */
                            AutomaticStatus.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus();
                                if (object.customerManagedEncryption != null) {
                                    if (typeof object.customerManagedEncryption !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.customerManagedEncryption: object expected");
                                    message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.fromObject(object.customerManagedEncryption);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an AutomaticStatus message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus} message AutomaticStatus
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            AutomaticStatus.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.customerManagedEncryption = null;
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                    object.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.toObject(message.customerManagedEncryption, options);
                                return object;
                            };
    
                            /**
                             * Converts this AutomaticStatus to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            AutomaticStatus.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for AutomaticStatus
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            AutomaticStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus";
                            };
    
                            return AutomaticStatus;
                        })();
    
                        ReplicationStatus.UserManagedStatus = (function() {
    
                            /**
                             * Properties of a UserManagedStatus.
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                             * @interface IUserManagedStatus
                             * @property {Array.<google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.IReplicaStatus>|null} [replicas] UserManagedStatus replicas
                             */
    
                            /**
                             * Constructs a new UserManagedStatus.
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus
                             * @classdesc Represents a UserManagedStatus.
                             * @implements IUserManagedStatus
                             * @constructor
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IUserManagedStatus=} [properties] Properties to set
                             */
                            function UserManagedStatus(properties) {
                                this.replicas = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * UserManagedStatus replicas.
                             * @member {Array.<google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.IReplicaStatus>} replicas
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @instance
                             */
                            UserManagedStatus.prototype.replicas = $util.emptyArray;
    
                            /**
                             * Creates a new UserManagedStatus instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IUserManagedStatus=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus} UserManagedStatus instance
                             */
                            UserManagedStatus.create = function create(properties) {
                                return new UserManagedStatus(properties);
                            };
    
                            /**
                             * Encodes the specified UserManagedStatus message. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IUserManagedStatus} message UserManagedStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManagedStatus.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.replicas != null && message.replicas.length)
                                    for (var i = 0; i < message.replicas.length; ++i)
                                        $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.encode(message.replicas[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified UserManagedStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.IUserManagedStatus} message UserManagedStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManagedStatus.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a UserManagedStatus message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus} UserManagedStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManagedStatus.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.replicas && message.replicas.length))
                                                message.replicas = [];
                                            message.replicas.push($root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a UserManagedStatus message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus} UserManagedStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManagedStatus.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a UserManagedStatus message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            UserManagedStatus.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.replicas != null && message.hasOwnProperty("replicas")) {
                                    if (!Array.isArray(message.replicas))
                                        return "replicas: array expected";
                                    for (var i = 0; i < message.replicas.length; ++i) {
                                        var error = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.verify(message.replicas[i]);
                                        if (error)
                                            return "replicas." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a UserManagedStatus message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus} UserManagedStatus
                             */
                            UserManagedStatus.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus();
                                if (object.replicas) {
                                    if (!Array.isArray(object.replicas))
                                        throw TypeError(".google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.replicas: array expected");
                                    message.replicas = [];
                                    for (var i = 0; i < object.replicas.length; ++i) {
                                        if (typeof object.replicas[i] !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.replicas: object expected");
                                        message.replicas[i] = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.fromObject(object.replicas[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a UserManagedStatus message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus} message UserManagedStatus
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            UserManagedStatus.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.replicas = [];
                                if (message.replicas && message.replicas.length) {
                                    object.replicas = [];
                                    for (var j = 0; j < message.replicas.length; ++j)
                                        object.replicas[j] = $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.toObject(message.replicas[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this UserManagedStatus to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            UserManagedStatus.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for UserManagedStatus
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            UserManagedStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus";
                            };
    
                            UserManagedStatus.ReplicaStatus = (function() {
    
                                /**
                                 * Properties of a ReplicaStatus.
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                                 * @interface IReplicaStatus
                                 * @property {string|null} [location] ReplicaStatus location
                                 * @property {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus|null} [customerManagedEncryption] ReplicaStatus customerManagedEncryption
                                 */
    
                                /**
                                 * Constructs a new ReplicaStatus.
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                                 * @classdesc Represents a ReplicaStatus.
                                 * @implements IReplicaStatus
                                 * @constructor
                                 * @param {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.IReplicaStatus=} [properties] Properties to set
                                 */
                                function ReplicaStatus(properties) {
                                    if (properties)
                                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                            if (properties[keys[i]] != null)
                                                this[keys[i]] = properties[keys[i]];
                                }
    
                                /**
                                 * ReplicaStatus location.
                                 * @member {string} location
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @instance
                                 */
                                ReplicaStatus.prototype.location = "";
    
                                /**
                                 * ReplicaStatus customerManagedEncryption.
                                 * @member {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus|null|undefined} customerManagedEncryption
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @instance
                                 */
                                ReplicaStatus.prototype.customerManagedEncryption = null;
    
                                /**
                                 * Creates a new ReplicaStatus instance using the specified properties.
                                 * @function create
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.IReplicaStatus=} [properties] Properties to set
                                 * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus instance
                                 */
                                ReplicaStatus.create = function create(properties) {
                                    return new ReplicaStatus(properties);
                                };
    
                                /**
                                 * Encodes the specified ReplicaStatus message. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.verify|verify} messages.
                                 * @function encode
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.IReplicaStatus} message ReplicaStatus message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                ReplicaStatus.encode = function encode(message, writer) {
                                    if (!writer)
                                        writer = $Writer.create();
                                    if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.location);
                                    if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                        $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.encode(message.customerManagedEncryption, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                    return writer;
                                };
    
                                /**
                                 * Encodes the specified ReplicaStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.verify|verify} messages.
                                 * @function encodeDelimited
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.IReplicaStatus} message ReplicaStatus message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                ReplicaStatus.encodeDelimited = function encodeDelimited(message, writer) {
                                    return this.encode(message, writer).ldelim();
                                };
    
                                /**
                                 * Decodes a ReplicaStatus message from the specified reader or buffer.
                                 * @function decode
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @param {number} [length] Message length if known beforehand
                                 * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                ReplicaStatus.decode = function decode(reader, length) {
                                    if (!(reader instanceof $Reader))
                                        reader = $Reader.create(reader);
                                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus();
                                    while (reader.pos < end) {
                                        var tag = reader.uint32();
                                        switch (tag >>> 3) {
                                        case 1: {
                                                message.location = reader.string();
                                                break;
                                            }
                                        case 2: {
                                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.decode(reader, reader.uint32());
                                                break;
                                            }
                                        default:
                                            reader.skipType(tag & 7);
                                            break;
                                        }
                                    }
                                    return message;
                                };
    
                                /**
                                 * Decodes a ReplicaStatus message from the specified reader or buffer, length delimited.
                                 * @function decodeDelimited
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                ReplicaStatus.decodeDelimited = function decodeDelimited(reader) {
                                    if (!(reader instanceof $Reader))
                                        reader = new $Reader(reader);
                                    return this.decode(reader, reader.uint32());
                                };
    
                                /**
                                 * Verifies a ReplicaStatus message.
                                 * @function verify
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {Object.<string,*>} message Plain object to verify
                                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                                 */
                                ReplicaStatus.verify = function verify(message) {
                                    if (typeof message !== "object" || message === null)
                                        return "object expected";
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        if (!$util.isString(message.location))
                                            return "location: string expected";
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                        var error = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.verify(message.customerManagedEncryption);
                                        if (error)
                                            return "customerManagedEncryption." + error;
                                    }
                                    return null;
                                };
    
                                /**
                                 * Creates a ReplicaStatus message from a plain object. Also converts values to their respective internal types.
                                 * @function fromObject
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {Object.<string,*>} object Plain object
                                 * @returns {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus
                                 */
                                ReplicaStatus.fromObject = function fromObject(object) {
                                    if (object instanceof $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
                                        return object;
                                    var message = new $root.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus();
                                    if (object.location != null)
                                        message.location = String(object.location);
                                    if (object.customerManagedEncryption != null) {
                                        if (typeof object.customerManagedEncryption !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.customerManagedEncryption: object expected");
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.fromObject(object.customerManagedEncryption);
                                    }
                                    return message;
                                };
    
                                /**
                                 * Creates a plain object from a ReplicaStatus message. Also converts values to other types if specified.
                                 * @function toObject
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus} message ReplicaStatus
                                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                                 * @returns {Object.<string,*>} Plain object
                                 */
                                ReplicaStatus.toObject = function toObject(message, options) {
                                    if (!options)
                                        options = {};
                                    var object = {};
                                    if (options.defaults) {
                                        object.location = "";
                                        object.customerManagedEncryption = null;
                                    }
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        object.location = message.location;
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                        object.customerManagedEncryption = $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.toObject(message.customerManagedEncryption, options);
                                    return object;
                                };
    
                                /**
                                 * Converts this ReplicaStatus to JSON.
                                 * @function toJSON
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @instance
                                 * @returns {Object.<string,*>} JSON object
                                 */
                                ReplicaStatus.prototype.toJSON = function toJSON() {
                                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                                };
    
                                /**
                                 * Gets the default type url for ReplicaStatus
                                 * @function getTypeUrl
                                 * @memberof google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                                 * @returns {string} The default type url
                                 */
                                ReplicaStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                    if (typeUrlPrefix === undefined) {
                                        typeUrlPrefix = "type.googleapis.com";
                                    }
                                    return typeUrlPrefix + "/google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus";
                                };
    
                                return ReplicaStatus;
                            })();
    
                            return UserManagedStatus;
                        })();
    
                        return ReplicationStatus;
                    })();
    
                    v1.CustomerManagedEncryptionStatus = (function() {
    
                        /**
                         * Properties of a CustomerManagedEncryptionStatus.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ICustomerManagedEncryptionStatus
                         * @property {string|null} [kmsKeyVersionName] CustomerManagedEncryptionStatus kmsKeyVersionName
                         */
    
                        /**
                         * Constructs a new CustomerManagedEncryptionStatus.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a CustomerManagedEncryptionStatus.
                         * @implements ICustomerManagedEncryptionStatus
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus=} [properties] Properties to set
                         */
                        function CustomerManagedEncryptionStatus(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CustomerManagedEncryptionStatus kmsKeyVersionName.
                         * @member {string} kmsKeyVersionName
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @instance
                         */
                        CustomerManagedEncryptionStatus.prototype.kmsKeyVersionName = "";
    
                        /**
                         * Creates a new CustomerManagedEncryptionStatus instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus instance
                         */
                        CustomerManagedEncryptionStatus.create = function create(properties) {
                            return new CustomerManagedEncryptionStatus(properties);
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryptionStatus message. Does not implicitly {@link google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus} message CustomerManagedEncryptionStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryptionStatus.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.kmsKeyVersionName != null && Object.hasOwnProperty.call(message, "kmsKeyVersionName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.kmsKeyVersionName);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryptionStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICustomerManagedEncryptionStatus} message CustomerManagedEncryptionStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryptionStatus.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryptionStatus message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryptionStatus.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.kmsKeyVersionName = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryptionStatus message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryptionStatus.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CustomerManagedEncryptionStatus message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CustomerManagedEncryptionStatus.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.kmsKeyVersionName != null && message.hasOwnProperty("kmsKeyVersionName"))
                                if (!$util.isString(message.kmsKeyVersionName))
                                    return "kmsKeyVersionName: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CustomerManagedEncryptionStatus message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus
                         */
                        CustomerManagedEncryptionStatus.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus();
                            if (object.kmsKeyVersionName != null)
                                message.kmsKeyVersionName = String(object.kmsKeyVersionName);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CustomerManagedEncryptionStatus message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus} message CustomerManagedEncryptionStatus
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CustomerManagedEncryptionStatus.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.kmsKeyVersionName = "";
                            if (message.kmsKeyVersionName != null && message.hasOwnProperty("kmsKeyVersionName"))
                                object.kmsKeyVersionName = message.kmsKeyVersionName;
                            return object;
                        };
    
                        /**
                         * Converts this CustomerManagedEncryptionStatus to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CustomerManagedEncryptionStatus.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CustomerManagedEncryptionStatus
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CustomerManagedEncryptionStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus";
                        };
    
                        return CustomerManagedEncryptionStatus;
                    })();
    
                    v1.Topic = (function() {
    
                        /**
                         * Properties of a Topic.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ITopic
                         * @property {string|null} [name] Topic name
                         */
    
                        /**
                         * Constructs a new Topic.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a Topic.
                         * @implements ITopic
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ITopic=} [properties] Properties to set
                         */
                        function Topic(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Topic name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @instance
                         */
                        Topic.prototype.name = "";
    
                        /**
                         * Creates a new Topic instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1.ITopic=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.Topic} Topic instance
                         */
                        Topic.create = function create(properties) {
                            return new Topic(properties);
                        };
    
                        /**
                         * Encodes the specified Topic message. Does not implicitly {@link google.cloud.secretmanager.v1.Topic.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1.ITopic} message Topic message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Topic.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Topic message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Topic.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1.ITopic} message Topic message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Topic.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Topic message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.Topic} Topic
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Topic.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Topic();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Topic message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.Topic} Topic
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Topic.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Topic message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Topic.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a Topic message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.Topic} Topic
                         */
                        Topic.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.Topic)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.Topic();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Topic message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1.Topic} message Topic
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Topic.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this Topic to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Topic.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Topic
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.Topic
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Topic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.Topic";
                        };
    
                        return Topic;
                    })();
    
                    v1.Rotation = (function() {
    
                        /**
                         * Properties of a Rotation.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IRotation
                         * @property {google.protobuf.ITimestamp|null} [nextRotationTime] Rotation nextRotationTime
                         * @property {google.protobuf.IDuration|null} [rotationPeriod] Rotation rotationPeriod
                         */
    
                        /**
                         * Constructs a new Rotation.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a Rotation.
                         * @implements IRotation
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IRotation=} [properties] Properties to set
                         */
                        function Rotation(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Rotation nextRotationTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} nextRotationTime
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @instance
                         */
                        Rotation.prototype.nextRotationTime = null;
    
                        /**
                         * Rotation rotationPeriod.
                         * @member {google.protobuf.IDuration|null|undefined} rotationPeriod
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @instance
                         */
                        Rotation.prototype.rotationPeriod = null;
    
                        /**
                         * Creates a new Rotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1.IRotation=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.Rotation} Rotation instance
                         */
                        Rotation.create = function create(properties) {
                            return new Rotation(properties);
                        };
    
                        /**
                         * Encodes the specified Rotation message. Does not implicitly {@link google.cloud.secretmanager.v1.Rotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1.IRotation} message Rotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Rotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.nextRotationTime != null && Object.hasOwnProperty.call(message, "nextRotationTime"))
                                $root.google.protobuf.Timestamp.encode(message.nextRotationTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.rotationPeriod != null && Object.hasOwnProperty.call(message, "rotationPeriod"))
                                $root.google.protobuf.Duration.encode(message.rotationPeriod, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Rotation message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.Rotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1.IRotation} message Rotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Rotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Rotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.Rotation} Rotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Rotation.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.Rotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.nextRotationTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.rotationPeriod = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Rotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.Rotation} Rotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Rotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Rotation message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Rotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.nextRotationTime != null && message.hasOwnProperty("nextRotationTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.nextRotationTime);
                                if (error)
                                    return "nextRotationTime." + error;
                            }
                            if (message.rotationPeriod != null && message.hasOwnProperty("rotationPeriod")) {
                                var error = $root.google.protobuf.Duration.verify(message.rotationPeriod);
                                if (error)
                                    return "rotationPeriod." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Rotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.Rotation} Rotation
                         */
                        Rotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.Rotation)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.Rotation();
                            if (object.nextRotationTime != null) {
                                if (typeof object.nextRotationTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Rotation.nextRotationTime: object expected");
                                message.nextRotationTime = $root.google.protobuf.Timestamp.fromObject(object.nextRotationTime);
                            }
                            if (object.rotationPeriod != null) {
                                if (typeof object.rotationPeriod !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.Rotation.rotationPeriod: object expected");
                                message.rotationPeriod = $root.google.protobuf.Duration.fromObject(object.rotationPeriod);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Rotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1.Rotation} message Rotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Rotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.nextRotationTime = null;
                                object.rotationPeriod = null;
                            }
                            if (message.nextRotationTime != null && message.hasOwnProperty("nextRotationTime"))
                                object.nextRotationTime = $root.google.protobuf.Timestamp.toObject(message.nextRotationTime, options);
                            if (message.rotationPeriod != null && message.hasOwnProperty("rotationPeriod"))
                                object.rotationPeriod = $root.google.protobuf.Duration.toObject(message.rotationPeriod, options);
                            return object;
                        };
    
                        /**
                         * Converts this Rotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Rotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Rotation
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.Rotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Rotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.Rotation";
                        };
    
                        return Rotation;
                    })();
    
                    v1.SecretPayload = (function() {
    
                        /**
                         * Properties of a SecretPayload.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ISecretPayload
                         * @property {Uint8Array|null} [data] SecretPayload data
                         * @property {number|Long|null} [dataCrc32c] SecretPayload dataCrc32c
                         */
    
                        /**
                         * Constructs a new SecretPayload.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a SecretPayload.
                         * @implements ISecretPayload
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ISecretPayload=} [properties] Properties to set
                         */
                        function SecretPayload(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SecretPayload data.
                         * @member {Uint8Array} data
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @instance
                         */
                        SecretPayload.prototype.data = $util.newBuffer([]);
    
                        /**
                         * SecretPayload dataCrc32c.
                         * @member {number|Long|null|undefined} dataCrc32c
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @instance
                         */
                        SecretPayload.prototype.dataCrc32c = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * SecretPayload _dataCrc32c.
                         * @member {"dataCrc32c"|undefined} _dataCrc32c
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @instance
                         */
                        Object.defineProperty(SecretPayload.prototype, "_dataCrc32c", {
                            get: $util.oneOfGetter($oneOfFields = ["dataCrc32c"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new SecretPayload instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecretPayload=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.SecretPayload} SecretPayload instance
                         */
                        SecretPayload.create = function create(properties) {
                            return new SecretPayload(properties);
                        };
    
                        /**
                         * Encodes the specified SecretPayload message. Does not implicitly {@link google.cloud.secretmanager.v1.SecretPayload.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecretPayload} message SecretPayload message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretPayload.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.data);
                            if (message.dataCrc32c != null && Object.hasOwnProperty.call(message, "dataCrc32c"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.dataCrc32c);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SecretPayload message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.SecretPayload.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1.ISecretPayload} message SecretPayload message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretPayload.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SecretPayload message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.SecretPayload} SecretPayload
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretPayload.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.SecretPayload();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.data = reader.bytes();
                                        break;
                                    }
                                case 2: {
                                        message.dataCrc32c = reader.int64();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SecretPayload message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.SecretPayload} SecretPayload
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretPayload.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SecretPayload message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SecretPayload.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.data != null && message.hasOwnProperty("data"))
                                if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                                    return "data: buffer expected";
                            if (message.dataCrc32c != null && message.hasOwnProperty("dataCrc32c")) {
                                properties._dataCrc32c = 1;
                                if (!$util.isInteger(message.dataCrc32c) && !(message.dataCrc32c && $util.isInteger(message.dataCrc32c.low) && $util.isInteger(message.dataCrc32c.high)))
                                    return "dataCrc32c: integer|Long expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SecretPayload message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.SecretPayload} SecretPayload
                         */
                        SecretPayload.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.SecretPayload)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.SecretPayload();
                            if (object.data != null)
                                if (typeof object.data === "string")
                                    $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                                else if (object.data.length >= 0)
                                    message.data = object.data;
                            if (object.dataCrc32c != null)
                                if ($util.Long)
                                    (message.dataCrc32c = $util.Long.fromValue(object.dataCrc32c)).unsigned = false;
                                else if (typeof object.dataCrc32c === "string")
                                    message.dataCrc32c = parseInt(object.dataCrc32c, 10);
                                else if (typeof object.dataCrc32c === "number")
                                    message.dataCrc32c = object.dataCrc32c;
                                else if (typeof object.dataCrc32c === "object")
                                    message.dataCrc32c = new $util.LongBits(object.dataCrc32c.low >>> 0, object.dataCrc32c.high >>> 0).toNumber();
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SecretPayload message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1.SecretPayload} message SecretPayload
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SecretPayload.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                if (options.bytes === String)
                                    object.data = "";
                                else {
                                    object.data = [];
                                    if (options.bytes !== Array)
                                        object.data = $util.newBuffer(object.data);
                                }
                            if (message.data != null && message.hasOwnProperty("data"))
                                object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                            if (message.dataCrc32c != null && message.hasOwnProperty("dataCrc32c")) {
                                if (typeof message.dataCrc32c === "number")
                                    object.dataCrc32c = options.longs === String ? String(message.dataCrc32c) : message.dataCrc32c;
                                else
                                    object.dataCrc32c = options.longs === String ? $util.Long.prototype.toString.call(message.dataCrc32c) : options.longs === Number ? new $util.LongBits(message.dataCrc32c.low >>> 0, message.dataCrc32c.high >>> 0).toNumber() : message.dataCrc32c;
                                if (options.oneofs)
                                    object._dataCrc32c = "dataCrc32c";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this SecretPayload to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SecretPayload.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SecretPayload
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.SecretPayload
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SecretPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.SecretPayload";
                        };
    
                        return SecretPayload;
                    })();
    
                    v1.SecretManagerService = (function() {
    
                        /**
                         * Constructs a new SecretManagerService service.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a SecretManagerService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function SecretManagerService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (SecretManagerService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = SecretManagerService;
    
                        /**
                         * Creates new SecretManagerService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {SecretManagerService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        SecretManagerService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|listSecrets}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef ListSecretsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.ListSecretsResponse} [response] ListSecretsResponse
                         */
    
                        /**
                         * Calls ListSecrets.
                         * @function listSecrets
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IListSecretsRequest} request ListSecretsRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.ListSecretsCallback} callback Node-style callback called with the error, if any, and ListSecretsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.listSecrets = function listSecrets(request, callback) {
                            return this.rpcCall(listSecrets, $root.google.cloud.secretmanager.v1.ListSecretsRequest, $root.google.cloud.secretmanager.v1.ListSecretsResponse, request, callback);
                        }, "name", { value: "ListSecrets" });
    
                        /**
                         * Calls ListSecrets.
                         * @function listSecrets
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IListSecretsRequest} request ListSecretsRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.ListSecretsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|createSecret}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef CreateSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.Secret} [response] Secret
                         */
    
                        /**
                         * Calls CreateSecret.
                         * @function createSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.ICreateSecretRequest} request CreateSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.CreateSecretCallback} callback Node-style callback called with the error, if any, and Secret
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.createSecret = function createSecret(request, callback) {
                            return this.rpcCall(createSecret, $root.google.cloud.secretmanager.v1.CreateSecretRequest, $root.google.cloud.secretmanager.v1.Secret, request, callback);
                        }, "name", { value: "CreateSecret" });
    
                        /**
                         * Calls CreateSecret.
                         * @function createSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.ICreateSecretRequest} request CreateSecretRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.Secret>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|addSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef AddSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls AddSecretVersion.
                         * @function addSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IAddSecretVersionRequest} request AddSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.AddSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.addSecretVersion = function addSecretVersion(request, callback) {
                            return this.rpcCall(addSecretVersion, $root.google.cloud.secretmanager.v1.AddSecretVersionRequest, $root.google.cloud.secretmanager.v1.SecretVersion, request, callback);
                        }, "name", { value: "AddSecretVersion" });
    
                        /**
                         * Calls AddSecretVersion.
                         * @function addSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IAddSecretVersionRequest} request AddSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|getSecret}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef GetSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.Secret} [response] Secret
                         */
    
                        /**
                         * Calls GetSecret.
                         * @function getSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IGetSecretRequest} request GetSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.GetSecretCallback} callback Node-style callback called with the error, if any, and Secret
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.getSecret = function getSecret(request, callback) {
                            return this.rpcCall(getSecret, $root.google.cloud.secretmanager.v1.GetSecretRequest, $root.google.cloud.secretmanager.v1.Secret, request, callback);
                        }, "name", { value: "GetSecret" });
    
                        /**
                         * Calls GetSecret.
                         * @function getSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IGetSecretRequest} request GetSecretRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.Secret>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|updateSecret}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef UpdateSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.Secret} [response] Secret
                         */
    
                        /**
                         * Calls UpdateSecret.
                         * @function updateSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IUpdateSecretRequest} request UpdateSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.UpdateSecretCallback} callback Node-style callback called with the error, if any, and Secret
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.updateSecret = function updateSecret(request, callback) {
                            return this.rpcCall(updateSecret, $root.google.cloud.secretmanager.v1.UpdateSecretRequest, $root.google.cloud.secretmanager.v1.Secret, request, callback);
                        }, "name", { value: "UpdateSecret" });
    
                        /**
                         * Calls UpdateSecret.
                         * @function updateSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IUpdateSecretRequest} request UpdateSecretRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.Secret>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|deleteSecret}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef DeleteSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteSecret.
                         * @function deleteSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IDeleteSecretRequest} request DeleteSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.DeleteSecretCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.deleteSecret = function deleteSecret(request, callback) {
                            return this.rpcCall(deleteSecret, $root.google.cloud.secretmanager.v1.DeleteSecretRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteSecret" });
    
                        /**
                         * Calls DeleteSecret.
                         * @function deleteSecret
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IDeleteSecretRequest} request DeleteSecretRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|listSecretVersions}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef ListSecretVersionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.ListSecretVersionsResponse} [response] ListSecretVersionsResponse
                         */
    
                        /**
                         * Calls ListSecretVersions.
                         * @function listSecretVersions
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsRequest} request ListSecretVersionsRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.ListSecretVersionsCallback} callback Node-style callback called with the error, if any, and ListSecretVersionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.listSecretVersions = function listSecretVersions(request, callback) {
                            return this.rpcCall(listSecretVersions, $root.google.cloud.secretmanager.v1.ListSecretVersionsRequest, $root.google.cloud.secretmanager.v1.ListSecretVersionsResponse, request, callback);
                        }, "name", { value: "ListSecretVersions" });
    
                        /**
                         * Calls ListSecretVersions.
                         * @function listSecretVersions
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsRequest} request ListSecretVersionsRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.ListSecretVersionsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|getSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef GetSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls GetSecretVersion.
                         * @function getSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IGetSecretVersionRequest} request GetSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.GetSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.getSecretVersion = function getSecretVersion(request, callback) {
                            return this.rpcCall(getSecretVersion, $root.google.cloud.secretmanager.v1.GetSecretVersionRequest, $root.google.cloud.secretmanager.v1.SecretVersion, request, callback);
                        }, "name", { value: "GetSecretVersion" });
    
                        /**
                         * Calls GetSecretVersion.
                         * @function getSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IGetSecretVersionRequest} request GetSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|accessSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef AccessSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.AccessSecretVersionResponse} [response] AccessSecretVersionResponse
                         */
    
                        /**
                         * Calls AccessSecretVersion.
                         * @function accessSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionRequest} request AccessSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.AccessSecretVersionCallback} callback Node-style callback called with the error, if any, and AccessSecretVersionResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.accessSecretVersion = function accessSecretVersion(request, callback) {
                            return this.rpcCall(accessSecretVersion, $root.google.cloud.secretmanager.v1.AccessSecretVersionRequest, $root.google.cloud.secretmanager.v1.AccessSecretVersionResponse, request, callback);
                        }, "name", { value: "AccessSecretVersion" });
    
                        /**
                         * Calls AccessSecretVersion.
                         * @function accessSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionRequest} request AccessSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.AccessSecretVersionResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|disableSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef DisableSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls DisableSecretVersion.
                         * @function disableSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IDisableSecretVersionRequest} request DisableSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.DisableSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.disableSecretVersion = function disableSecretVersion(request, callback) {
                            return this.rpcCall(disableSecretVersion, $root.google.cloud.secretmanager.v1.DisableSecretVersionRequest, $root.google.cloud.secretmanager.v1.SecretVersion, request, callback);
                        }, "name", { value: "DisableSecretVersion" });
    
                        /**
                         * Calls DisableSecretVersion.
                         * @function disableSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IDisableSecretVersionRequest} request DisableSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|enableSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef EnableSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls EnableSecretVersion.
                         * @function enableSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IEnableSecretVersionRequest} request EnableSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.EnableSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.enableSecretVersion = function enableSecretVersion(request, callback) {
                            return this.rpcCall(enableSecretVersion, $root.google.cloud.secretmanager.v1.EnableSecretVersionRequest, $root.google.cloud.secretmanager.v1.SecretVersion, request, callback);
                        }, "name", { value: "EnableSecretVersion" });
    
                        /**
                         * Calls EnableSecretVersion.
                         * @function enableSecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IEnableSecretVersionRequest} request EnableSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|destroySecretVersion}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef DestroySecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls DestroySecretVersion.
                         * @function destroySecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IDestroySecretVersionRequest} request DestroySecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.DestroySecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.destroySecretVersion = function destroySecretVersion(request, callback) {
                            return this.rpcCall(destroySecretVersion, $root.google.cloud.secretmanager.v1.DestroySecretVersionRequest, $root.google.cloud.secretmanager.v1.SecretVersion, request, callback);
                        }, "name", { value: "DestroySecretVersion" });
    
                        /**
                         * Calls DestroySecretVersion.
                         * @function destroySecretVersion
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1.IDestroySecretVersionRequest} request DestroySecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|setIamPolicy}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef SetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.SetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.setIamPolicy = function setIamPolicy(request, callback) {
                            return this.rpcCall(setIamPolicy, $root.google.iam.v1.SetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "SetIamPolicy" });
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|getIamPolicy}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef GetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.GetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.getIamPolicy = function getIamPolicy(request, callback) {
                            return this.rpcCall(getIamPolicy, $root.google.iam.v1.GetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "GetIamPolicy" });
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1.SecretManagerService|testIamPermissions}.
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @typedef TestIamPermissionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.TestIamPermissionsResponse} [response] TestIamPermissionsResponse
                         */
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @param {google.cloud.secretmanager.v1.SecretManagerService.TestIamPermissionsCallback} callback Node-style callback called with the error, if any, and TestIamPermissionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.testIamPermissions = function testIamPermissions(request, callback) {
                            return this.rpcCall(testIamPermissions, $root.google.iam.v1.TestIamPermissionsRequest, $root.google.iam.v1.TestIamPermissionsResponse, request, callback);
                        }, "name", { value: "TestIamPermissions" });
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.secretmanager.v1.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @returns {Promise<google.iam.v1.TestIamPermissionsResponse>} Promise
                         * @variation 2
                         */
    
                        return SecretManagerService;
                    })();
    
                    v1.ListSecretsRequest = (function() {
    
                        /**
                         * Properties of a ListSecretsRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IListSecretsRequest
                         * @property {string|null} [parent] ListSecretsRequest parent
                         * @property {number|null} [pageSize] ListSecretsRequest pageSize
                         * @property {string|null} [pageToken] ListSecretsRequest pageToken
                         * @property {string|null} [filter] ListSecretsRequest filter
                         */
    
                        /**
                         * Constructs a new ListSecretsRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a ListSecretsRequest.
                         * @implements IListSecretsRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IListSecretsRequest=} [properties] Properties to set
                         */
                        function ListSecretsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.parent = "";
    
                        /**
                         * ListSecretsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListSecretsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.pageToken = "";
    
                        /**
                         * ListSecretsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.filter = "";
    
                        /**
                         * Creates a new ListSecretsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretsRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.ListSecretsRequest} ListSecretsRequest instance
                         */
                        ListSecretsRequest.create = function create(properties) {
                            return new ListSecretsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretsRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretsRequest} message ListSecretsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretsRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretsRequest} message ListSecretsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.ListSecretsRequest} ListSecretsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ListSecretsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.ListSecretsRequest} ListSecretsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretsRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.ListSecretsRequest} ListSecretsRequest
                         */
                        ListSecretsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.ListSecretsRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.ListSecretsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.ListSecretsRequest} message ListSecretsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.ListSecretsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.ListSecretsRequest";
                        };
    
                        return ListSecretsRequest;
                    })();
    
                    v1.ListSecretsResponse = (function() {
    
                        /**
                         * Properties of a ListSecretsResponse.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IListSecretsResponse
                         * @property {Array.<google.cloud.secretmanager.v1.ISecret>|null} [secrets] ListSecretsResponse secrets
                         * @property {string|null} [nextPageToken] ListSecretsResponse nextPageToken
                         * @property {number|null} [totalSize] ListSecretsResponse totalSize
                         */
    
                        /**
                         * Constructs a new ListSecretsResponse.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a ListSecretsResponse.
                         * @implements IListSecretsResponse
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IListSecretsResponse=} [properties] Properties to set
                         */
                        function ListSecretsResponse(properties) {
                            this.secrets = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretsResponse secrets.
                         * @member {Array.<google.cloud.secretmanager.v1.ISecret>} secrets
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @instance
                         */
                        ListSecretsResponse.prototype.secrets = $util.emptyArray;
    
                        /**
                         * ListSecretsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @instance
                         */
                        ListSecretsResponse.prototype.nextPageToken = "";
    
                        /**
                         * ListSecretsResponse totalSize.
                         * @member {number} totalSize
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @instance
                         */
                        ListSecretsResponse.prototype.totalSize = 0;
    
                        /**
                         * Creates a new ListSecretsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretsResponse=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.ListSecretsResponse} ListSecretsResponse instance
                         */
                        ListSecretsResponse.create = function create(properties) {
                            return new ListSecretsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretsResponse message. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretsResponse} message ListSecretsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.secrets != null && message.secrets.length)
                                for (var i = 0; i < message.secrets.length; ++i)
                                    $root.google.cloud.secretmanager.v1.Secret.encode(message.secrets[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            if (message.totalSize != null && Object.hasOwnProperty.call(message, "totalSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.totalSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretsResponse message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretsResponse} message ListSecretsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.ListSecretsResponse} ListSecretsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ListSecretsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.secrets && message.secrets.length))
                                            message.secrets = [];
                                        message.secrets.push($root.google.cloud.secretmanager.v1.Secret.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.totalSize = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.ListSecretsResponse} ListSecretsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretsResponse message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.secrets != null && message.hasOwnProperty("secrets")) {
                                if (!Array.isArray(message.secrets))
                                    return "secrets: array expected";
                                for (var i = 0; i < message.secrets.length; ++i) {
                                    var error = $root.google.cloud.secretmanager.v1.Secret.verify(message.secrets[i]);
                                    if (error)
                                        return "secrets." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                if (!$util.isInteger(message.totalSize))
                                    return "totalSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.ListSecretsResponse} ListSecretsResponse
                         */
                        ListSecretsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.ListSecretsResponse)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.ListSecretsResponse();
                            if (object.secrets) {
                                if (!Array.isArray(object.secrets))
                                    throw TypeError(".google.cloud.secretmanager.v1.ListSecretsResponse.secrets: array expected");
                                message.secrets = [];
                                for (var i = 0; i < object.secrets.length; ++i) {
                                    if (typeof object.secrets[i] !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1.ListSecretsResponse.secrets: object expected");
                                    message.secrets[i] = $root.google.cloud.secretmanager.v1.Secret.fromObject(object.secrets[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.totalSize != null)
                                message.totalSize = object.totalSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.ListSecretsResponse} message ListSecretsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.secrets = [];
                            if (options.defaults) {
                                object.nextPageToken = "";
                                object.totalSize = 0;
                            }
                            if (message.secrets && message.secrets.length) {
                                object.secrets = [];
                                for (var j = 0; j < message.secrets.length; ++j)
                                    object.secrets[j] = $root.google.cloud.secretmanager.v1.Secret.toObject(message.secrets[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                object.totalSize = message.totalSize;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.ListSecretsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.ListSecretsResponse";
                        };
    
                        return ListSecretsResponse;
                    })();
    
                    v1.CreateSecretRequest = (function() {
    
                        /**
                         * Properties of a CreateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface ICreateSecretRequest
                         * @property {string|null} [parent] CreateSecretRequest parent
                         * @property {string|null} [secretId] CreateSecretRequest secretId
                         * @property {google.cloud.secretmanager.v1.ISecret|null} [secret] CreateSecretRequest secret
                         */
    
                        /**
                         * Constructs a new CreateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a CreateSecretRequest.
                         * @implements ICreateSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.ICreateSecretRequest=} [properties] Properties to set
                         */
                        function CreateSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateSecretRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @instance
                         */
                        CreateSecretRequest.prototype.parent = "";
    
                        /**
                         * CreateSecretRequest secretId.
                         * @member {string} secretId
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @instance
                         */
                        CreateSecretRequest.prototype.secretId = "";
    
                        /**
                         * CreateSecretRequest secret.
                         * @member {google.cloud.secretmanager.v1.ISecret|null|undefined} secret
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @instance
                         */
                        CreateSecretRequest.prototype.secret = null;
    
                        /**
                         * Creates a new CreateSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICreateSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.CreateSecretRequest} CreateSecretRequest instance
                         */
                        CreateSecretRequest.create = function create(properties) {
                            return new CreateSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.CreateSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICreateSecretRequest} message CreateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.secretId != null && Object.hasOwnProperty.call(message, "secretId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.secretId);
                            if (message.secret != null && Object.hasOwnProperty.call(message, "secret"))
                                $root.google.cloud.secretmanager.v1.Secret.encode(message.secret, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.CreateSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.ICreateSecretRequest} message CreateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.CreateSecretRequest} CreateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.CreateSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.secretId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.secret = $root.google.cloud.secretmanager.v1.Secret.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.CreateSecretRequest} CreateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.secretId != null && message.hasOwnProperty("secretId"))
                                if (!$util.isString(message.secretId))
                                    return "secretId: string expected";
                            if (message.secret != null && message.hasOwnProperty("secret")) {
                                var error = $root.google.cloud.secretmanager.v1.Secret.verify(message.secret);
                                if (error)
                                    return "secret." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.CreateSecretRequest} CreateSecretRequest
                         */
                        CreateSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.CreateSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.CreateSecretRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.secretId != null)
                                message.secretId = String(object.secretId);
                            if (object.secret != null) {
                                if (typeof object.secret !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.CreateSecretRequest.secret: object expected");
                                message.secret = $root.google.cloud.secretmanager.v1.Secret.fromObject(object.secret);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.CreateSecretRequest} message CreateSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.secretId = "";
                                object.secret = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.secretId != null && message.hasOwnProperty("secretId"))
                                object.secretId = message.secretId;
                            if (message.secret != null && message.hasOwnProperty("secret"))
                                object.secret = $root.google.cloud.secretmanager.v1.Secret.toObject(message.secret, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.CreateSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.CreateSecretRequest";
                        };
    
                        return CreateSecretRequest;
                    })();
    
                    v1.AddSecretVersionRequest = (function() {
    
                        /**
                         * Properties of an AddSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IAddSecretVersionRequest
                         * @property {string|null} [parent] AddSecretVersionRequest parent
                         * @property {google.cloud.secretmanager.v1.ISecretPayload|null} [payload] AddSecretVersionRequest payload
                         */
    
                        /**
                         * Constructs a new AddSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents an AddSecretVersionRequest.
                         * @implements IAddSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IAddSecretVersionRequest=} [properties] Properties to set
                         */
                        function AddSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AddSecretVersionRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @instance
                         */
                        AddSecretVersionRequest.prototype.parent = "";
    
                        /**
                         * AddSecretVersionRequest payload.
                         * @member {google.cloud.secretmanager.v1.ISecretPayload|null|undefined} payload
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @instance
                         */
                        AddSecretVersionRequest.prototype.payload = null;
    
                        /**
                         * Creates a new AddSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAddSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.AddSecretVersionRequest} AddSecretVersionRequest instance
                         */
                        AddSecretVersionRequest.create = function create(properties) {
                            return new AddSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AddSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.AddSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAddSecretVersionRequest} message AddSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AddSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                                $root.google.cloud.secretmanager.v1.SecretPayload.encode(message.payload, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AddSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.AddSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAddSecretVersionRequest} message AddSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AddSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AddSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.AddSecretVersionRequest} AddSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AddSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.AddSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.payload = $root.google.cloud.secretmanager.v1.SecretPayload.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AddSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.AddSecretVersionRequest} AddSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AddSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AddSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AddSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.payload != null && message.hasOwnProperty("payload")) {
                                var error = $root.google.cloud.secretmanager.v1.SecretPayload.verify(message.payload);
                                if (error)
                                    return "payload." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AddSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.AddSecretVersionRequest} AddSecretVersionRequest
                         */
                        AddSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.AddSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.AddSecretVersionRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.payload != null) {
                                if (typeof object.payload !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.AddSecretVersionRequest.payload: object expected");
                                message.payload = $root.google.cloud.secretmanager.v1.SecretPayload.fromObject(object.payload);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AddSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.AddSecretVersionRequest} message AddSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AddSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.payload = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.payload != null && message.hasOwnProperty("payload"))
                                object.payload = $root.google.cloud.secretmanager.v1.SecretPayload.toObject(message.payload, options);
                            return object;
                        };
    
                        /**
                         * Converts this AddSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AddSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AddSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.AddSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AddSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.AddSecretVersionRequest";
                        };
    
                        return AddSecretVersionRequest;
                    })();
    
                    v1.GetSecretRequest = (function() {
    
                        /**
                         * Properties of a GetSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IGetSecretRequest
                         * @property {string|null} [name] GetSecretRequest name
                         */
    
                        /**
                         * Constructs a new GetSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a GetSecretRequest.
                         * @implements IGetSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IGetSecretRequest=} [properties] Properties to set
                         */
                        function GetSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetSecretRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @instance
                         */
                        GetSecretRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IGetSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.GetSecretRequest} GetSecretRequest instance
                         */
                        GetSecretRequest.create = function create(properties) {
                            return new GetSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.GetSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IGetSecretRequest} message GetSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.GetSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IGetSecretRequest} message GetSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.GetSecretRequest} GetSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.GetSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.GetSecretRequest} GetSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.GetSecretRequest} GetSecretRequest
                         */
                        GetSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.GetSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.GetSecretRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.GetSecretRequest} message GetSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.GetSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.GetSecretRequest";
                        };
    
                        return GetSecretRequest;
                    })();
    
                    v1.ListSecretVersionsRequest = (function() {
    
                        /**
                         * Properties of a ListSecretVersionsRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IListSecretVersionsRequest
                         * @property {string|null} [parent] ListSecretVersionsRequest parent
                         * @property {number|null} [pageSize] ListSecretVersionsRequest pageSize
                         * @property {string|null} [pageToken] ListSecretVersionsRequest pageToken
                         * @property {string|null} [filter] ListSecretVersionsRequest filter
                         */
    
                        /**
                         * Constructs a new ListSecretVersionsRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a ListSecretVersionsRequest.
                         * @implements IListSecretVersionsRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsRequest=} [properties] Properties to set
                         */
                        function ListSecretVersionsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretVersionsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.parent = "";
    
                        /**
                         * ListSecretVersionsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListSecretVersionsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.pageToken = "";
    
                        /**
                         * ListSecretVersionsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.filter = "";
    
                        /**
                         * Creates a new ListSecretVersionsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsRequest} ListSecretVersionsRequest instance
                         */
                        ListSecretVersionsRequest.create = function create(properties) {
                            return new ListSecretVersionsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretVersionsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsRequest} message ListSecretVersionsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretVersionsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsRequest} message ListSecretVersionsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretVersionsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsRequest} ListSecretVersionsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ListSecretVersionsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretVersionsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsRequest} ListSecretVersionsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretVersionsRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretVersionsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretVersionsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsRequest} ListSecretVersionsRequest
                         */
                        ListSecretVersionsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.ListSecretVersionsRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.ListSecretVersionsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretVersionsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.ListSecretVersionsRequest} message ListSecretVersionsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretVersionsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretVersionsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretVersionsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretVersionsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretVersionsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.ListSecretVersionsRequest";
                        };
    
                        return ListSecretVersionsRequest;
                    })();
    
                    v1.ListSecretVersionsResponse = (function() {
    
                        /**
                         * Properties of a ListSecretVersionsResponse.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IListSecretVersionsResponse
                         * @property {Array.<google.cloud.secretmanager.v1.ISecretVersion>|null} [versions] ListSecretVersionsResponse versions
                         * @property {string|null} [nextPageToken] ListSecretVersionsResponse nextPageToken
                         * @property {number|null} [totalSize] ListSecretVersionsResponse totalSize
                         */
    
                        /**
                         * Constructs a new ListSecretVersionsResponse.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a ListSecretVersionsResponse.
                         * @implements IListSecretVersionsResponse
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsResponse=} [properties] Properties to set
                         */
                        function ListSecretVersionsResponse(properties) {
                            this.versions = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretVersionsResponse versions.
                         * @member {Array.<google.cloud.secretmanager.v1.ISecretVersion>} versions
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @instance
                         */
                        ListSecretVersionsResponse.prototype.versions = $util.emptyArray;
    
                        /**
                         * ListSecretVersionsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @instance
                         */
                        ListSecretVersionsResponse.prototype.nextPageToken = "";
    
                        /**
                         * ListSecretVersionsResponse totalSize.
                         * @member {number} totalSize
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @instance
                         */
                        ListSecretVersionsResponse.prototype.totalSize = 0;
    
                        /**
                         * Creates a new ListSecretVersionsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsResponse=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsResponse} ListSecretVersionsResponse instance
                         */
                        ListSecretVersionsResponse.create = function create(properties) {
                            return new ListSecretVersionsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsResponse message. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretVersionsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsResponse} message ListSecretVersionsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.versions != null && message.versions.length)
                                for (var i = 0; i < message.versions.length; ++i)
                                    $root.google.cloud.secretmanager.v1.SecretVersion.encode(message.versions[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            if (message.totalSize != null && Object.hasOwnProperty.call(message, "totalSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.totalSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsResponse message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.ListSecretVersionsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IListSecretVersionsResponse} message ListSecretVersionsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretVersionsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsResponse} ListSecretVersionsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.ListSecretVersionsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.versions && message.versions.length))
                                            message.versions = [];
                                        message.versions.push($root.google.cloud.secretmanager.v1.SecretVersion.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.totalSize = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretVersionsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsResponse} ListSecretVersionsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretVersionsResponse message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretVersionsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.versions != null && message.hasOwnProperty("versions")) {
                                if (!Array.isArray(message.versions))
                                    return "versions: array expected";
                                for (var i = 0; i < message.versions.length; ++i) {
                                    var error = $root.google.cloud.secretmanager.v1.SecretVersion.verify(message.versions[i]);
                                    if (error)
                                        return "versions." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                if (!$util.isInteger(message.totalSize))
                                    return "totalSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretVersionsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.ListSecretVersionsResponse} ListSecretVersionsResponse
                         */
                        ListSecretVersionsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.ListSecretVersionsResponse)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.ListSecretVersionsResponse();
                            if (object.versions) {
                                if (!Array.isArray(object.versions))
                                    throw TypeError(".google.cloud.secretmanager.v1.ListSecretVersionsResponse.versions: array expected");
                                message.versions = [];
                                for (var i = 0; i < object.versions.length; ++i) {
                                    if (typeof object.versions[i] !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1.ListSecretVersionsResponse.versions: object expected");
                                    message.versions[i] = $root.google.cloud.secretmanager.v1.SecretVersion.fromObject(object.versions[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.totalSize != null)
                                message.totalSize = object.totalSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretVersionsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.ListSecretVersionsResponse} message ListSecretVersionsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretVersionsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.versions = [];
                            if (options.defaults) {
                                object.nextPageToken = "";
                                object.totalSize = 0;
                            }
                            if (message.versions && message.versions.length) {
                                object.versions = [];
                                for (var j = 0; j < message.versions.length; ++j)
                                    object.versions[j] = $root.google.cloud.secretmanager.v1.SecretVersion.toObject(message.versions[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                object.totalSize = message.totalSize;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretVersionsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretVersionsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretVersionsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.ListSecretVersionsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretVersionsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.ListSecretVersionsResponse";
                        };
    
                        return ListSecretVersionsResponse;
                    })();
    
                    v1.GetSecretVersionRequest = (function() {
    
                        /**
                         * Properties of a GetSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IGetSecretVersionRequest
                         * @property {string|null} [name] GetSecretVersionRequest name
                         */
    
                        /**
                         * Constructs a new GetSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a GetSecretVersionRequest.
                         * @implements IGetSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IGetSecretVersionRequest=} [properties] Properties to set
                         */
                        function GetSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetSecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @instance
                         */
                        GetSecretVersionRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IGetSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.GetSecretVersionRequest} GetSecretVersionRequest instance
                         */
                        GetSecretVersionRequest.create = function create(properties) {
                            return new GetSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.GetSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IGetSecretVersionRequest} message GetSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.GetSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IGetSecretVersionRequest} message GetSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.GetSecretVersionRequest} GetSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.GetSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.GetSecretVersionRequest} GetSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.GetSecretVersionRequest} GetSecretVersionRequest
                         */
                        GetSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.GetSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.GetSecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.GetSecretVersionRequest} message GetSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.GetSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.GetSecretVersionRequest";
                        };
    
                        return GetSecretVersionRequest;
                    })();
    
                    v1.UpdateSecretRequest = (function() {
    
                        /**
                         * Properties of an UpdateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IUpdateSecretRequest
                         * @property {google.cloud.secretmanager.v1.ISecret|null} [secret] UpdateSecretRequest secret
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateSecretRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents an UpdateSecretRequest.
                         * @implements IUpdateSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IUpdateSecretRequest=} [properties] Properties to set
                         */
                        function UpdateSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateSecretRequest secret.
                         * @member {google.cloud.secretmanager.v1.ISecret|null|undefined} secret
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @instance
                         */
                        UpdateSecretRequest.prototype.secret = null;
    
                        /**
                         * UpdateSecretRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @instance
                         */
                        UpdateSecretRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IUpdateSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.UpdateSecretRequest} UpdateSecretRequest instance
                         */
                        UpdateSecretRequest.create = function create(properties) {
                            return new UpdateSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.UpdateSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IUpdateSecretRequest} message UpdateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.secret != null && Object.hasOwnProperty.call(message, "secret"))
                                $root.google.cloud.secretmanager.v1.Secret.encode(message.secret, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.UpdateSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IUpdateSecretRequest} message UpdateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.UpdateSecretRequest} UpdateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.UpdateSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.secret = $root.google.cloud.secretmanager.v1.Secret.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.UpdateSecretRequest} UpdateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.secret != null && message.hasOwnProperty("secret")) {
                                var error = $root.google.cloud.secretmanager.v1.Secret.verify(message.secret);
                                if (error)
                                    return "secret." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.UpdateSecretRequest} UpdateSecretRequest
                         */
                        UpdateSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.UpdateSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.UpdateSecretRequest();
                            if (object.secret != null) {
                                if (typeof object.secret !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.UpdateSecretRequest.secret: object expected");
                                message.secret = $root.google.cloud.secretmanager.v1.Secret.fromObject(object.secret);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.UpdateSecretRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.UpdateSecretRequest} message UpdateSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.secret = null;
                                object.updateMask = null;
                            }
                            if (message.secret != null && message.hasOwnProperty("secret"))
                                object.secret = $root.google.cloud.secretmanager.v1.Secret.toObject(message.secret, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.UpdateSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.UpdateSecretRequest";
                        };
    
                        return UpdateSecretRequest;
                    })();
    
                    v1.AccessSecretVersionRequest = (function() {
    
                        /**
                         * Properties of an AccessSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IAccessSecretVersionRequest
                         * @property {string|null} [name] AccessSecretVersionRequest name
                         */
    
                        /**
                         * Constructs a new AccessSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents an AccessSecretVersionRequest.
                         * @implements IAccessSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionRequest=} [properties] Properties to set
                         */
                        function AccessSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AccessSecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @instance
                         */
                        AccessSecretVersionRequest.prototype.name = "";
    
                        /**
                         * Creates a new AccessSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionRequest} AccessSecretVersionRequest instance
                         */
                        AccessSecretVersionRequest.create = function create(properties) {
                            return new AccessSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.AccessSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionRequest} message AccessSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.AccessSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionRequest} message AccessSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionRequest} AccessSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.AccessSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionRequest} AccessSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AccessSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AccessSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionRequest} AccessSecretVersionRequest
                         */
                        AccessSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.AccessSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.AccessSecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AccessSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.AccessSecretVersionRequest} message AccessSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AccessSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this AccessSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AccessSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AccessSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AccessSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.AccessSecretVersionRequest";
                        };
    
                        return AccessSecretVersionRequest;
                    })();
    
                    v1.AccessSecretVersionResponse = (function() {
    
                        /**
                         * Properties of an AccessSecretVersionResponse.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IAccessSecretVersionResponse
                         * @property {string|null} [name] AccessSecretVersionResponse name
                         * @property {google.cloud.secretmanager.v1.ISecretPayload|null} [payload] AccessSecretVersionResponse payload
                         */
    
                        /**
                         * Constructs a new AccessSecretVersionResponse.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents an AccessSecretVersionResponse.
                         * @implements IAccessSecretVersionResponse
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionResponse=} [properties] Properties to set
                         */
                        function AccessSecretVersionResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AccessSecretVersionResponse name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @instance
                         */
                        AccessSecretVersionResponse.prototype.name = "";
    
                        /**
                         * AccessSecretVersionResponse payload.
                         * @member {google.cloud.secretmanager.v1.ISecretPayload|null|undefined} payload
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @instance
                         */
                        AccessSecretVersionResponse.prototype.payload = null;
    
                        /**
                         * Creates a new AccessSecretVersionResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionResponse=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionResponse} AccessSecretVersionResponse instance
                         */
                        AccessSecretVersionResponse.create = function create(properties) {
                            return new AccessSecretVersionResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionResponse message. Does not implicitly {@link google.cloud.secretmanager.v1.AccessSecretVersionResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionResponse} message AccessSecretVersionResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                                $root.google.cloud.secretmanager.v1.SecretPayload.encode(message.payload, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionResponse message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.AccessSecretVersionResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.IAccessSecretVersionResponse} message AccessSecretVersionResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessSecretVersionResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionResponse} AccessSecretVersionResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.AccessSecretVersionResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.payload = $root.google.cloud.secretmanager.v1.SecretPayload.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessSecretVersionResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionResponse} AccessSecretVersionResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessSecretVersionResponse message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AccessSecretVersionResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.payload != null && message.hasOwnProperty("payload")) {
                                var error = $root.google.cloud.secretmanager.v1.SecretPayload.verify(message.payload);
                                if (error)
                                    return "payload." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AccessSecretVersionResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.AccessSecretVersionResponse} AccessSecretVersionResponse
                         */
                        AccessSecretVersionResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.AccessSecretVersionResponse)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.AccessSecretVersionResponse();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.payload != null) {
                                if (typeof object.payload !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1.AccessSecretVersionResponse.payload: object expected");
                                message.payload = $root.google.cloud.secretmanager.v1.SecretPayload.fromObject(object.payload);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AccessSecretVersionResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1.AccessSecretVersionResponse} message AccessSecretVersionResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AccessSecretVersionResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.payload = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.payload != null && message.hasOwnProperty("payload"))
                                object.payload = $root.google.cloud.secretmanager.v1.SecretPayload.toObject(message.payload, options);
                            return object;
                        };
    
                        /**
                         * Converts this AccessSecretVersionResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AccessSecretVersionResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AccessSecretVersionResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.AccessSecretVersionResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AccessSecretVersionResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.AccessSecretVersionResponse";
                        };
    
                        return AccessSecretVersionResponse;
                    })();
    
                    v1.DeleteSecretRequest = (function() {
    
                        /**
                         * Properties of a DeleteSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IDeleteSecretRequest
                         * @property {string|null} [name] DeleteSecretRequest name
                         * @property {string|null} [etag] DeleteSecretRequest etag
                         */
    
                        /**
                         * Constructs a new DeleteSecretRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a DeleteSecretRequest.
                         * @implements IDeleteSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IDeleteSecretRequest=} [properties] Properties to set
                         */
                        function DeleteSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteSecretRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @instance
                         */
                        DeleteSecretRequest.prototype.name = "";
    
                        /**
                         * DeleteSecretRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @instance
                         */
                        DeleteSecretRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DeleteSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDeleteSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.DeleteSecretRequest} DeleteSecretRequest instance
                         */
                        DeleteSecretRequest.create = function create(properties) {
                            return new DeleteSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.DeleteSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDeleteSecretRequest} message DeleteSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.DeleteSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDeleteSecretRequest} message DeleteSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.DeleteSecretRequest} DeleteSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.DeleteSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.DeleteSecretRequest} DeleteSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.DeleteSecretRequest} DeleteSecretRequest
                         */
                        DeleteSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.DeleteSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.DeleteSecretRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.DeleteSecretRequest} message DeleteSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.DeleteSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.DeleteSecretRequest";
                        };
    
                        return DeleteSecretRequest;
                    })();
    
                    v1.DisableSecretVersionRequest = (function() {
    
                        /**
                         * Properties of a DisableSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IDisableSecretVersionRequest
                         * @property {string|null} [name] DisableSecretVersionRequest name
                         * @property {string|null} [etag] DisableSecretVersionRequest etag
                         */
    
                        /**
                         * Constructs a new DisableSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a DisableSecretVersionRequest.
                         * @implements IDisableSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IDisableSecretVersionRequest=} [properties] Properties to set
                         */
                        function DisableSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DisableSecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @instance
                         */
                        DisableSecretVersionRequest.prototype.name = "";
    
                        /**
                         * DisableSecretVersionRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @instance
                         */
                        DisableSecretVersionRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DisableSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDisableSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.DisableSecretVersionRequest} DisableSecretVersionRequest instance
                         */
                        DisableSecretVersionRequest.create = function create(properties) {
                            return new DisableSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DisableSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.DisableSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDisableSecretVersionRequest} message DisableSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DisableSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DisableSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.DisableSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDisableSecretVersionRequest} message DisableSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DisableSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DisableSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.DisableSecretVersionRequest} DisableSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DisableSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.DisableSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DisableSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.DisableSecretVersionRequest} DisableSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DisableSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DisableSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DisableSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DisableSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.DisableSecretVersionRequest} DisableSecretVersionRequest
                         */
                        DisableSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.DisableSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.DisableSecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DisableSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.DisableSecretVersionRequest} message DisableSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DisableSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DisableSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DisableSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DisableSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.DisableSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DisableSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.DisableSecretVersionRequest";
                        };
    
                        return DisableSecretVersionRequest;
                    })();
    
                    v1.EnableSecretVersionRequest = (function() {
    
                        /**
                         * Properties of an EnableSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IEnableSecretVersionRequest
                         * @property {string|null} [name] EnableSecretVersionRequest name
                         * @property {string|null} [etag] EnableSecretVersionRequest etag
                         */
    
                        /**
                         * Constructs a new EnableSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents an EnableSecretVersionRequest.
                         * @implements IEnableSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IEnableSecretVersionRequest=} [properties] Properties to set
                         */
                        function EnableSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * EnableSecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @instance
                         */
                        EnableSecretVersionRequest.prototype.name = "";
    
                        /**
                         * EnableSecretVersionRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @instance
                         */
                        EnableSecretVersionRequest.prototype.etag = "";
    
                        /**
                         * Creates a new EnableSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IEnableSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.EnableSecretVersionRequest} EnableSecretVersionRequest instance
                         */
                        EnableSecretVersionRequest.create = function create(properties) {
                            return new EnableSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified EnableSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.EnableSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IEnableSecretVersionRequest} message EnableSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EnableSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified EnableSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.EnableSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IEnableSecretVersionRequest} message EnableSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EnableSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an EnableSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.EnableSecretVersionRequest} EnableSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EnableSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.EnableSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an EnableSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.EnableSecretVersionRequest} EnableSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EnableSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an EnableSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EnableSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an EnableSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.EnableSecretVersionRequest} EnableSecretVersionRequest
                         */
                        EnableSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.EnableSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.EnableSecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an EnableSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.EnableSecretVersionRequest} message EnableSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EnableSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this EnableSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EnableSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for EnableSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.EnableSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        EnableSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.EnableSecretVersionRequest";
                        };
    
                        return EnableSecretVersionRequest;
                    })();
    
                    v1.DestroySecretVersionRequest = (function() {
    
                        /**
                         * Properties of a DestroySecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @interface IDestroySecretVersionRequest
                         * @property {string|null} [name] DestroySecretVersionRequest name
                         * @property {string|null} [etag] DestroySecretVersionRequest etag
                         */
    
                        /**
                         * Constructs a new DestroySecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1
                         * @classdesc Represents a DestroySecretVersionRequest.
                         * @implements IDestroySecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1.IDestroySecretVersionRequest=} [properties] Properties to set
                         */
                        function DestroySecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DestroySecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @instance
                         */
                        DestroySecretVersionRequest.prototype.name = "";
    
                        /**
                         * DestroySecretVersionRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @instance
                         */
                        DestroySecretVersionRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DestroySecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDestroySecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1.DestroySecretVersionRequest} DestroySecretVersionRequest instance
                         */
                        DestroySecretVersionRequest.create = function create(properties) {
                            return new DestroySecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DestroySecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1.DestroySecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDestroySecretVersionRequest} message DestroySecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DestroySecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DestroySecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1.DestroySecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.IDestroySecretVersionRequest} message DestroySecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DestroySecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DestroySecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1.DestroySecretVersionRequest} DestroySecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DestroySecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1.DestroySecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DestroySecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1.DestroySecretVersionRequest} DestroySecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DestroySecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DestroySecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DestroySecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DestroySecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1.DestroySecretVersionRequest} DestroySecretVersionRequest
                         */
                        DestroySecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1.DestroySecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1.DestroySecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DestroySecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1.DestroySecretVersionRequest} message DestroySecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DestroySecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DestroySecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DestroySecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DestroySecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1.DestroySecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DestroySecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1.DestroySecretVersionRequest";
                        };
    
                        return DestroySecretVersionRequest;
                    })();
    
                    return v1;
                })();
    
                secretmanager.v1beta2 = (function() {
    
                    /**
                     * Namespace v1beta2.
                     * @memberof google.cloud.secretmanager
                     * @namespace
                     */
                    var v1beta2 = {};
    
                    v1beta2.Secret = (function() {
    
                        /**
                         * Properties of a Secret.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ISecret
                         * @property {string|null} [name] Secret name
                         * @property {google.cloud.secretmanager.v1beta2.IReplication|null} [replication] Secret replication
                         * @property {google.protobuf.ITimestamp|null} [createTime] Secret createTime
                         * @property {Object.<string,string>|null} [labels] Secret labels
                         * @property {Array.<google.cloud.secretmanager.v1beta2.ITopic>|null} [topics] Secret topics
                         * @property {google.protobuf.ITimestamp|null} [expireTime] Secret expireTime
                         * @property {google.protobuf.IDuration|null} [ttl] Secret ttl
                         * @property {string|null} [etag] Secret etag
                         * @property {google.cloud.secretmanager.v1beta2.IRotation|null} [rotation] Secret rotation
                         * @property {Object.<string,number|Long>|null} [versionAliases] Secret versionAliases
                         * @property {Object.<string,string>|null} [annotations] Secret annotations
                         * @property {google.protobuf.IDuration|null} [versionDestroyTtl] Secret versionDestroyTtl
                         * @property {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption|null} [customerManagedEncryption] Secret customerManagedEncryption
                         */
    
                        /**
                         * Constructs a new Secret.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a Secret.
                         * @implements ISecret
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ISecret=} [properties] Properties to set
                         */
                        function Secret(properties) {
                            this.labels = {};
                            this.topics = [];
                            this.versionAliases = {};
                            this.annotations = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Secret name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.name = "";
    
                        /**
                         * Secret replication.
                         * @member {google.cloud.secretmanager.v1beta2.IReplication|null|undefined} replication
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.replication = null;
    
                        /**
                         * Secret createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.createTime = null;
    
                        /**
                         * Secret labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.labels = $util.emptyObject;
    
                        /**
                         * Secret topics.
                         * @member {Array.<google.cloud.secretmanager.v1beta2.ITopic>} topics
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.topics = $util.emptyArray;
    
                        /**
                         * Secret expireTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} expireTime
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.expireTime = null;
    
                        /**
                         * Secret ttl.
                         * @member {google.protobuf.IDuration|null|undefined} ttl
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.ttl = null;
    
                        /**
                         * Secret etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.etag = "";
    
                        /**
                         * Secret rotation.
                         * @member {google.cloud.secretmanager.v1beta2.IRotation|null|undefined} rotation
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.rotation = null;
    
                        /**
                         * Secret versionAliases.
                         * @member {Object.<string,number|Long>} versionAliases
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.versionAliases = $util.emptyObject;
    
                        /**
                         * Secret annotations.
                         * @member {Object.<string,string>} annotations
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.annotations = $util.emptyObject;
    
                        /**
                         * Secret versionDestroyTtl.
                         * @member {google.protobuf.IDuration|null|undefined} versionDestroyTtl
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.versionDestroyTtl = null;
    
                        /**
                         * Secret customerManagedEncryption.
                         * @member {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption|null|undefined} customerManagedEncryption
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Secret.prototype.customerManagedEncryption = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Secret expiration.
                         * @member {"expireTime"|"ttl"|undefined} expiration
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         */
                        Object.defineProperty(Secret.prototype, "expiration", {
                            get: $util.oneOfGetter($oneOfFields = ["expireTime", "ttl"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Secret instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecret=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.Secret} Secret instance
                         */
                        Secret.create = function create(properties) {
                            return new Secret(properties);
                        };
    
                        /**
                         * Encodes the specified Secret message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Secret.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecret} message Secret message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Secret.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.replication != null && Object.hasOwnProperty.call(message, "replication"))
                                $root.google.cloud.secretmanager.v1beta2.Replication.encode(message.replication, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            if (message.topics != null && message.topics.length)
                                for (var i = 0; i < message.topics.length; ++i)
                                    $root.google.cloud.secretmanager.v1beta2.Topic.encode(message.topics[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.expireTime != null && Object.hasOwnProperty.call(message, "expireTime"))
                                $root.google.protobuf.Timestamp.encode(message.expireTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.ttl != null && Object.hasOwnProperty.call(message, "ttl"))
                                $root.google.protobuf.Duration.encode(message.ttl, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.etag);
                            if (message.rotation != null && Object.hasOwnProperty.call(message, "rotation"))
                                $root.google.cloud.secretmanager.v1beta2.Rotation.encode(message.rotation, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.versionAliases != null && Object.hasOwnProperty.call(message, "versionAliases"))
                                for (var keys = Object.keys(message.versionAliases), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 11, wireType 2 =*/90).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 0 =*/16).int64(message.versionAliases[keys[i]]).ldelim();
                            if (message.annotations != null && Object.hasOwnProperty.call(message, "annotations"))
                                for (var keys = Object.keys(message.annotations), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 13, wireType 2 =*/106).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.annotations[keys[i]]).ldelim();
                            if (message.versionDestroyTtl != null && Object.hasOwnProperty.call(message, "versionDestroyTtl"))
                                $root.google.protobuf.Duration.encode(message.versionDestroyTtl, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                            if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.encode(message.customerManagedEncryption, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Secret message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Secret.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecret} message Secret message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Secret.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Secret message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.Secret} Secret
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Secret.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Secret(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.replication = $root.google.cloud.secretmanager.v1beta2.Replication.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                case 5: {
                                        if (!(message.topics && message.topics.length))
                                            message.topics = [];
                                        message.topics.push($root.google.cloud.secretmanager.v1beta2.Topic.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 6: {
                                        message.expireTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.ttl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 9: {
                                        message.rotation = $root.google.cloud.secretmanager.v1beta2.Rotation.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 11: {
                                        if (message.versionAliases === $util.emptyObject)
                                            message.versionAliases = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = 0;
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.int64();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.versionAliases[key] = value;
                                        break;
                                    }
                                case 13: {
                                        if (message.annotations === $util.emptyObject)
                                            message.annotations = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.annotations[key] = value;
                                        break;
                                    }
                                case 14: {
                                        message.versionDestroyTtl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 15: {
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Secret message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.Secret} Secret
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Secret.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Secret message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Secret.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.replication != null && message.hasOwnProperty("replication")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.Replication.verify(message.replication);
                                if (error)
                                    return "replication." + error;
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            if (message.topics != null && message.hasOwnProperty("topics")) {
                                if (!Array.isArray(message.topics))
                                    return "topics: array expected";
                                for (var i = 0; i < message.topics.length; ++i) {
                                    var error = $root.google.cloud.secretmanager.v1beta2.Topic.verify(message.topics[i]);
                                    if (error)
                                        return "topics." + error;
                                }
                            }
                            if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                                properties.expiration = 1;
                                {
                                    var error = $root.google.protobuf.Timestamp.verify(message.expireTime);
                                    if (error)
                                        return "expireTime." + error;
                                }
                            }
                            if (message.ttl != null && message.hasOwnProperty("ttl")) {
                                if (properties.expiration === 1)
                                    return "expiration: multiple values";
                                properties.expiration = 1;
                                {
                                    var error = $root.google.protobuf.Duration.verify(message.ttl);
                                    if (error)
                                        return "ttl." + error;
                                }
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.rotation != null && message.hasOwnProperty("rotation")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.Rotation.verify(message.rotation);
                                if (error)
                                    return "rotation." + error;
                            }
                            if (message.versionAliases != null && message.hasOwnProperty("versionAliases")) {
                                if (!$util.isObject(message.versionAliases))
                                    return "versionAliases: object expected";
                                var key = Object.keys(message.versionAliases);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isInteger(message.versionAliases[key[i]]) && !(message.versionAliases[key[i]] && $util.isInteger(message.versionAliases[key[i]].low) && $util.isInteger(message.versionAliases[key[i]].high)))
                                        return "versionAliases: integer|Long{k:string} expected";
                            }
                            if (message.annotations != null && message.hasOwnProperty("annotations")) {
                                if (!$util.isObject(message.annotations))
                                    return "annotations: object expected";
                                var key = Object.keys(message.annotations);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.annotations[key[i]]))
                                        return "annotations: string{k:string} expected";
                            }
                            if (message.versionDestroyTtl != null && message.hasOwnProperty("versionDestroyTtl")) {
                                var error = $root.google.protobuf.Duration.verify(message.versionDestroyTtl);
                                if (error)
                                    return "versionDestroyTtl." + error;
                            }
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.verify(message.customerManagedEncryption);
                                if (error)
                                    return "customerManagedEncryption." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Secret message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.Secret} Secret
                         */
                        Secret.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.Secret)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.Secret();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.replication != null) {
                                if (typeof object.replication !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.replication: object expected");
                                message.replication = $root.google.cloud.secretmanager.v1beta2.Replication.fromObject(object.replication);
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            if (object.topics) {
                                if (!Array.isArray(object.topics))
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.topics: array expected");
                                message.topics = [];
                                for (var i = 0; i < object.topics.length; ++i) {
                                    if (typeof object.topics[i] !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.topics: object expected");
                                    message.topics[i] = $root.google.cloud.secretmanager.v1beta2.Topic.fromObject(object.topics[i]);
                                }
                            }
                            if (object.expireTime != null) {
                                if (typeof object.expireTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.expireTime: object expected");
                                message.expireTime = $root.google.protobuf.Timestamp.fromObject(object.expireTime);
                            }
                            if (object.ttl != null) {
                                if (typeof object.ttl !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.ttl: object expected");
                                message.ttl = $root.google.protobuf.Duration.fromObject(object.ttl);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            if (object.rotation != null) {
                                if (typeof object.rotation !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.rotation: object expected");
                                message.rotation = $root.google.cloud.secretmanager.v1beta2.Rotation.fromObject(object.rotation);
                            }
                            if (object.versionAliases) {
                                if (typeof object.versionAliases !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.versionAliases: object expected");
                                message.versionAliases = {};
                                for (var keys = Object.keys(object.versionAliases), i = 0; i < keys.length; ++i)
                                    if ($util.Long)
                                        (message.versionAliases[keys[i]] = $util.Long.fromValue(object.versionAliases[keys[i]])).unsigned = false;
                                    else if (typeof object.versionAliases[keys[i]] === "string")
                                        message.versionAliases[keys[i]] = parseInt(object.versionAliases[keys[i]], 10);
                                    else if (typeof object.versionAliases[keys[i]] === "number")
                                        message.versionAliases[keys[i]] = object.versionAliases[keys[i]];
                                    else if (typeof object.versionAliases[keys[i]] === "object")
                                        message.versionAliases[keys[i]] = new $util.LongBits(object.versionAliases[keys[i]].low >>> 0, object.versionAliases[keys[i]].high >>> 0).toNumber();
                            }
                            if (object.annotations) {
                                if (typeof object.annotations !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.annotations: object expected");
                                message.annotations = {};
                                for (var keys = Object.keys(object.annotations), i = 0; i < keys.length; ++i)
                                    message.annotations[keys[i]] = String(object.annotations[keys[i]]);
                            }
                            if (object.versionDestroyTtl != null) {
                                if (typeof object.versionDestroyTtl !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.versionDestroyTtl: object expected");
                                message.versionDestroyTtl = $root.google.protobuf.Duration.fromObject(object.versionDestroyTtl);
                            }
                            if (object.customerManagedEncryption != null) {
                                if (typeof object.customerManagedEncryption !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Secret.customerManagedEncryption: object expected");
                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.fromObject(object.customerManagedEncryption);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Secret message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.Secret} message Secret
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Secret.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.topics = [];
                            if (options.objects || options.defaults) {
                                object.labels = {};
                                object.versionAliases = {};
                                object.annotations = {};
                            }
                            if (options.defaults) {
                                object.name = "";
                                object.replication = null;
                                object.createTime = null;
                                object.etag = "";
                                object.rotation = null;
                                object.versionDestroyTtl = null;
                                object.customerManagedEncryption = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.replication != null && message.hasOwnProperty("replication"))
                                object.replication = $root.google.cloud.secretmanager.v1beta2.Replication.toObject(message.replication, options);
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            if (message.topics && message.topics.length) {
                                object.topics = [];
                                for (var j = 0; j < message.topics.length; ++j)
                                    object.topics[j] = $root.google.cloud.secretmanager.v1beta2.Topic.toObject(message.topics[j], options);
                            }
                            if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                                object.expireTime = $root.google.protobuf.Timestamp.toObject(message.expireTime, options);
                                if (options.oneofs)
                                    object.expiration = "expireTime";
                            }
                            if (message.ttl != null && message.hasOwnProperty("ttl")) {
                                object.ttl = $root.google.protobuf.Duration.toObject(message.ttl, options);
                                if (options.oneofs)
                                    object.expiration = "ttl";
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            if (message.rotation != null && message.hasOwnProperty("rotation"))
                                object.rotation = $root.google.cloud.secretmanager.v1beta2.Rotation.toObject(message.rotation, options);
                            if (message.versionAliases && (keys2 = Object.keys(message.versionAliases)).length) {
                                object.versionAliases = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    if (typeof message.versionAliases[keys2[j]] === "number")
                                        object.versionAliases[keys2[j]] = options.longs === String ? String(message.versionAliases[keys2[j]]) : message.versionAliases[keys2[j]];
                                    else
                                        object.versionAliases[keys2[j]] = options.longs === String ? $util.Long.prototype.toString.call(message.versionAliases[keys2[j]]) : options.longs === Number ? new $util.LongBits(message.versionAliases[keys2[j]].low >>> 0, message.versionAliases[keys2[j]].high >>> 0).toNumber() : message.versionAliases[keys2[j]];
                            }
                            if (message.annotations && (keys2 = Object.keys(message.annotations)).length) {
                                object.annotations = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.annotations[keys2[j]] = message.annotations[keys2[j]];
                            }
                            if (message.versionDestroyTtl != null && message.hasOwnProperty("versionDestroyTtl"))
                                object.versionDestroyTtl = $root.google.protobuf.Duration.toObject(message.versionDestroyTtl, options);
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                object.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.toObject(message.customerManagedEncryption, options);
                            return object;
                        };
    
                        /**
                         * Converts this Secret to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Secret.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Secret
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.Secret
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Secret.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Secret";
                        };
    
                        return Secret;
                    })();
    
                    v1beta2.SecretVersion = (function() {
    
                        /**
                         * Properties of a SecretVersion.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ISecretVersion
                         * @property {string|null} [name] SecretVersion name
                         * @property {google.protobuf.ITimestamp|null} [createTime] SecretVersion createTime
                         * @property {google.protobuf.ITimestamp|null} [destroyTime] SecretVersion destroyTime
                         * @property {google.cloud.secretmanager.v1beta2.SecretVersion.State|null} [state] SecretVersion state
                         * @property {google.cloud.secretmanager.v1beta2.IReplicationStatus|null} [replicationStatus] SecretVersion replicationStatus
                         * @property {string|null} [etag] SecretVersion etag
                         * @property {boolean|null} [clientSpecifiedPayloadChecksum] SecretVersion clientSpecifiedPayloadChecksum
                         * @property {google.protobuf.ITimestamp|null} [scheduledDestroyTime] SecretVersion scheduledDestroyTime
                         * @property {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus|null} [customerManagedEncryption] SecretVersion customerManagedEncryption
                         */
    
                        /**
                         * Constructs a new SecretVersion.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a SecretVersion.
                         * @implements ISecretVersion
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ISecretVersion=} [properties] Properties to set
                         */
                        function SecretVersion(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SecretVersion name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.name = "";
    
                        /**
                         * SecretVersion createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.createTime = null;
    
                        /**
                         * SecretVersion destroyTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} destroyTime
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.destroyTime = null;
    
                        /**
                         * SecretVersion state.
                         * @member {google.cloud.secretmanager.v1beta2.SecretVersion.State} state
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.state = 0;
    
                        /**
                         * SecretVersion replicationStatus.
                         * @member {google.cloud.secretmanager.v1beta2.IReplicationStatus|null|undefined} replicationStatus
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.replicationStatus = null;
    
                        /**
                         * SecretVersion etag.
                         * @member {string} etag
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.etag = "";
    
                        /**
                         * SecretVersion clientSpecifiedPayloadChecksum.
                         * @member {boolean} clientSpecifiedPayloadChecksum
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.clientSpecifiedPayloadChecksum = false;
    
                        /**
                         * SecretVersion scheduledDestroyTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} scheduledDestroyTime
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.scheduledDestroyTime = null;
    
                        /**
                         * SecretVersion customerManagedEncryption.
                         * @member {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus|null|undefined} customerManagedEncryption
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         */
                        SecretVersion.prototype.customerManagedEncryption = null;
    
                        /**
                         * Creates a new SecretVersion instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecretVersion=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.SecretVersion} SecretVersion instance
                         */
                        SecretVersion.create = function create(properties) {
                            return new SecretVersion(properties);
                        };
    
                        /**
                         * Encodes the specified SecretVersion message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.SecretVersion.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecretVersion} message SecretVersion message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretVersion.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.destroyTime != null && Object.hasOwnProperty.call(message, "destroyTime"))
                                $root.google.protobuf.Timestamp.encode(message.destroyTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.state);
                            if (message.replicationStatus != null && Object.hasOwnProperty.call(message, "replicationStatus"))
                                $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.encode(message.replicationStatus, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.etag);
                            if (message.clientSpecifiedPayloadChecksum != null && Object.hasOwnProperty.call(message, "clientSpecifiedPayloadChecksum"))
                                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.clientSpecifiedPayloadChecksum);
                            if (message.scheduledDestroyTime != null && Object.hasOwnProperty.call(message, "scheduledDestroyTime"))
                                $root.google.protobuf.Timestamp.encode(message.scheduledDestroyTime, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.encode(message.customerManagedEncryption, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SecretVersion message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.SecretVersion.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecretVersion} message SecretVersion message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretVersion.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SecretVersion message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.SecretVersion} SecretVersion
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretVersion.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.SecretVersion();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.destroyTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.replicationStatus = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 7: {
                                        message.clientSpecifiedPayloadChecksum = reader.bool();
                                        break;
                                    }
                                case 8: {
                                        message.scheduledDestroyTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SecretVersion message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.SecretVersion} SecretVersion
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretVersion.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SecretVersion message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SecretVersion.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.destroyTime != null && message.hasOwnProperty("destroyTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.destroyTime);
                                if (error)
                                    return "destroyTime." + error;
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.replicationStatus != null && message.hasOwnProperty("replicationStatus")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.verify(message.replicationStatus);
                                if (error)
                                    return "replicationStatus." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.clientSpecifiedPayloadChecksum != null && message.hasOwnProperty("clientSpecifiedPayloadChecksum"))
                                if (typeof message.clientSpecifiedPayloadChecksum !== "boolean")
                                    return "clientSpecifiedPayloadChecksum: boolean expected";
                            if (message.scheduledDestroyTime != null && message.hasOwnProperty("scheduledDestroyTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.scheduledDestroyTime);
                                if (error)
                                    return "scheduledDestroyTime." + error;
                            }
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.verify(message.customerManagedEncryption);
                                if (error)
                                    return "customerManagedEncryption." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SecretVersion message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.SecretVersion} SecretVersion
                         */
                        SecretVersion.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.SecretVersion)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.SecretVersion();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.SecretVersion.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.destroyTime != null) {
                                if (typeof object.destroyTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.SecretVersion.destroyTime: object expected");
                                message.destroyTime = $root.google.protobuf.Timestamp.fromObject(object.destroyTime);
                            }
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ENABLED":
                            case 1:
                                message.state = 1;
                                break;
                            case "DISABLED":
                            case 2:
                                message.state = 2;
                                break;
                            case "DESTROYED":
                            case 3:
                                message.state = 3;
                                break;
                            }
                            if (object.replicationStatus != null) {
                                if (typeof object.replicationStatus !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.SecretVersion.replicationStatus: object expected");
                                message.replicationStatus = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.fromObject(object.replicationStatus);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            if (object.clientSpecifiedPayloadChecksum != null)
                                message.clientSpecifiedPayloadChecksum = Boolean(object.clientSpecifiedPayloadChecksum);
                            if (object.scheduledDestroyTime != null) {
                                if (typeof object.scheduledDestroyTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.SecretVersion.scheduledDestroyTime: object expected");
                                message.scheduledDestroyTime = $root.google.protobuf.Timestamp.fromObject(object.scheduledDestroyTime);
                            }
                            if (object.customerManagedEncryption != null) {
                                if (typeof object.customerManagedEncryption !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.SecretVersion.customerManagedEncryption: object expected");
                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.fromObject(object.customerManagedEncryption);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SecretVersion message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.SecretVersion} message SecretVersion
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SecretVersion.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.createTime = null;
                                object.destroyTime = null;
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.replicationStatus = null;
                                object.etag = "";
                                object.clientSpecifiedPayloadChecksum = false;
                                object.scheduledDestroyTime = null;
                                object.customerManagedEncryption = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.destroyTime != null && message.hasOwnProperty("destroyTime"))
                                object.destroyTime = $root.google.protobuf.Timestamp.toObject(message.destroyTime, options);
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.cloud.secretmanager.v1beta2.SecretVersion.State[message.state] === undefined ? message.state : $root.google.cloud.secretmanager.v1beta2.SecretVersion.State[message.state] : message.state;
                            if (message.replicationStatus != null && message.hasOwnProperty("replicationStatus"))
                                object.replicationStatus = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.toObject(message.replicationStatus, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            if (message.clientSpecifiedPayloadChecksum != null && message.hasOwnProperty("clientSpecifiedPayloadChecksum"))
                                object.clientSpecifiedPayloadChecksum = message.clientSpecifiedPayloadChecksum;
                            if (message.scheduledDestroyTime != null && message.hasOwnProperty("scheduledDestroyTime"))
                                object.scheduledDestroyTime = $root.google.protobuf.Timestamp.toObject(message.scheduledDestroyTime, options);
                            if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                object.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.toObject(message.customerManagedEncryption, options);
                            return object;
                        };
    
                        /**
                         * Converts this SecretVersion to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SecretVersion.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SecretVersion
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.SecretVersion
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SecretVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.SecretVersion";
                        };
    
                        /**
                         * State enum.
                         * @name google.cloud.secretmanager.v1beta2.SecretVersion.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ENABLED=1 ENABLED value
                         * @property {number} DISABLED=2 DISABLED value
                         * @property {number} DESTROYED=3 DESTROYED value
                         */
                        SecretVersion.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ENABLED"] = 1;
                            values[valuesById[2] = "DISABLED"] = 2;
                            values[valuesById[3] = "DESTROYED"] = 3;
                            return values;
                        })();
    
                        return SecretVersion;
                    })();
    
                    v1beta2.Replication = (function() {
    
                        /**
                         * Properties of a Replication.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IReplication
                         * @property {google.cloud.secretmanager.v1beta2.Replication.IAutomatic|null} [automatic] Replication automatic
                         * @property {google.cloud.secretmanager.v1beta2.Replication.IUserManaged|null} [userManaged] Replication userManaged
                         */
    
                        /**
                         * Constructs a new Replication.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a Replication.
                         * @implements IReplication
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IReplication=} [properties] Properties to set
                         */
                        function Replication(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Replication automatic.
                         * @member {google.cloud.secretmanager.v1beta2.Replication.IAutomatic|null|undefined} automatic
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @instance
                         */
                        Replication.prototype.automatic = null;
    
                        /**
                         * Replication userManaged.
                         * @member {google.cloud.secretmanager.v1beta2.Replication.IUserManaged|null|undefined} userManaged
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @instance
                         */
                        Replication.prototype.userManaged = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Replication replication.
                         * @member {"automatic"|"userManaged"|undefined} replication
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @instance
                         */
                        Object.defineProperty(Replication.prototype, "replication", {
                            get: $util.oneOfGetter($oneOfFields = ["automatic", "userManaged"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Replication instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IReplication=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.Replication} Replication instance
                         */
                        Replication.create = function create(properties) {
                            return new Replication(properties);
                        };
    
                        /**
                         * Encodes the specified Replication message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IReplication} message Replication message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Replication.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.automatic != null && Object.hasOwnProperty.call(message, "automatic"))
                                $root.google.cloud.secretmanager.v1beta2.Replication.Automatic.encode(message.automatic, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.userManaged != null && Object.hasOwnProperty.call(message, "userManaged"))
                                $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.encode(message.userManaged, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Replication message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IReplication} message Replication message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Replication.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Replication message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.Replication} Replication
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Replication.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Replication();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.automatic = $root.google.cloud.secretmanager.v1beta2.Replication.Automatic.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.userManaged = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Replication message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.Replication} Replication
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Replication.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Replication message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Replication.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                properties.replication = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1beta2.Replication.Automatic.verify(message.automatic);
                                    if (error)
                                        return "automatic." + error;
                                }
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                if (properties.replication === 1)
                                    return "replication: multiple values";
                                properties.replication = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.verify(message.userManaged);
                                    if (error)
                                        return "userManaged." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Replication message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.Replication} Replication
                         */
                        Replication.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.Replication)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.Replication();
                            if (object.automatic != null) {
                                if (typeof object.automatic !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Replication.automatic: object expected");
                                message.automatic = $root.google.cloud.secretmanager.v1beta2.Replication.Automatic.fromObject(object.automatic);
                            }
                            if (object.userManaged != null) {
                                if (typeof object.userManaged !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Replication.userManaged: object expected");
                                message.userManaged = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.fromObject(object.userManaged);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Replication message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.Replication} message Replication
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Replication.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                object.automatic = $root.google.cloud.secretmanager.v1beta2.Replication.Automatic.toObject(message.automatic, options);
                                if (options.oneofs)
                                    object.replication = "automatic";
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                object.userManaged = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.toObject(message.userManaged, options);
                                if (options.oneofs)
                                    object.replication = "userManaged";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Replication to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Replication.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Replication
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.Replication
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Replication.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Replication";
                        };
    
                        Replication.Automatic = (function() {
    
                            /**
                             * Properties of an Automatic.
                             * @memberof google.cloud.secretmanager.v1beta2.Replication
                             * @interface IAutomatic
                             * @property {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption|null} [customerManagedEncryption] Automatic customerManagedEncryption
                             */
    
                            /**
                             * Constructs a new Automatic.
                             * @memberof google.cloud.secretmanager.v1beta2.Replication
                             * @classdesc Represents an Automatic.
                             * @implements IAutomatic
                             * @constructor
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IAutomatic=} [properties] Properties to set
                             */
                            function Automatic(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Automatic customerManagedEncryption.
                             * @member {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption|null|undefined} customerManagedEncryption
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @instance
                             */
                            Automatic.prototype.customerManagedEncryption = null;
    
                            /**
                             * Creates a new Automatic instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IAutomatic=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.Automatic} Automatic instance
                             */
                            Automatic.create = function create(properties) {
                                return new Automatic(properties);
                            };
    
                            /**
                             * Encodes the specified Automatic message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.Automatic.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IAutomatic} message Automatic message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Automatic.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                    $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.encode(message.customerManagedEncryption, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified Automatic message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.Automatic.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IAutomatic} message Automatic message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Automatic.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an Automatic message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.Automatic} Automatic
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Automatic.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Replication.Automatic();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an Automatic message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.Automatic} Automatic
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Automatic.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an Automatic message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            Automatic.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                    var error = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.verify(message.customerManagedEncryption);
                                    if (error)
                                        return "customerManagedEncryption." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates an Automatic message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.Automatic} Automatic
                             */
                            Automatic.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1beta2.Replication.Automatic)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1beta2.Replication.Automatic();
                                if (object.customerManagedEncryption != null) {
                                    if (typeof object.customerManagedEncryption !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.Replication.Automatic.customerManagedEncryption: object expected");
                                    message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.fromObject(object.customerManagedEncryption);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an Automatic message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.Automatic} message Automatic
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            Automatic.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.customerManagedEncryption = null;
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                    object.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.toObject(message.customerManagedEncryption, options);
                                return object;
                            };
    
                            /**
                             * Converts this Automatic to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            Automatic.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for Automatic
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.Automatic
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            Automatic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Replication.Automatic";
                            };
    
                            return Automatic;
                        })();
    
                        Replication.UserManaged = (function() {
    
                            /**
                             * Properties of a UserManaged.
                             * @memberof google.cloud.secretmanager.v1beta2.Replication
                             * @interface IUserManaged
                             * @property {Array.<google.cloud.secretmanager.v1beta2.Replication.UserManaged.IReplica>|null} [replicas] UserManaged replicas
                             */
    
                            /**
                             * Constructs a new UserManaged.
                             * @memberof google.cloud.secretmanager.v1beta2.Replication
                             * @classdesc Represents a UserManaged.
                             * @implements IUserManaged
                             * @constructor
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IUserManaged=} [properties] Properties to set
                             */
                            function UserManaged(properties) {
                                this.replicas = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * UserManaged replicas.
                             * @member {Array.<google.cloud.secretmanager.v1beta2.Replication.UserManaged.IReplica>} replicas
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @instance
                             */
                            UserManaged.prototype.replicas = $util.emptyArray;
    
                            /**
                             * Creates a new UserManaged instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IUserManaged=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged} UserManaged instance
                             */
                            UserManaged.create = function create(properties) {
                                return new UserManaged(properties);
                            };
    
                            /**
                             * Encodes the specified UserManaged message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.UserManaged.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IUserManaged} message UserManaged message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManaged.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.replicas != null && message.replicas.length)
                                    for (var i = 0; i < message.replicas.length; ++i)
                                        $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.encode(message.replicas[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified UserManaged message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.UserManaged.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.IUserManaged} message UserManaged message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManaged.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a UserManaged message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged} UserManaged
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManaged.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.replicas && message.replicas.length))
                                                message.replicas = [];
                                            message.replicas.push($root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a UserManaged message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged} UserManaged
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManaged.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a UserManaged message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            UserManaged.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.replicas != null && message.hasOwnProperty("replicas")) {
                                    if (!Array.isArray(message.replicas))
                                        return "replicas: array expected";
                                    for (var i = 0; i < message.replicas.length; ++i) {
                                        var error = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.verify(message.replicas[i]);
                                        if (error)
                                            return "replicas." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a UserManaged message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged} UserManaged
                             */
                            UserManaged.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged();
                                if (object.replicas) {
                                    if (!Array.isArray(object.replicas))
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.Replication.UserManaged.replicas: array expected");
                                    message.replicas = [];
                                    for (var i = 0; i < object.replicas.length; ++i) {
                                        if (typeof object.replicas[i] !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1beta2.Replication.UserManaged.replicas: object expected");
                                        message.replicas[i] = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.fromObject(object.replicas[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a UserManaged message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.Replication.UserManaged} message UserManaged
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            UserManaged.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.replicas = [];
                                if (message.replicas && message.replicas.length) {
                                    object.replicas = [];
                                    for (var j = 0; j < message.replicas.length; ++j)
                                        object.replicas[j] = $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.toObject(message.replicas[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this UserManaged to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            UserManaged.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for UserManaged
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            UserManaged.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Replication.UserManaged";
                            };
    
                            UserManaged.Replica = (function() {
    
                                /**
                                 * Properties of a Replica.
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                                 * @interface IReplica
                                 * @property {string|null} [location] Replica location
                                 * @property {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption|null} [customerManagedEncryption] Replica customerManagedEncryption
                                 */
    
                                /**
                                 * Constructs a new Replica.
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged
                                 * @classdesc Represents a Replica.
                                 * @implements IReplica
                                 * @constructor
                                 * @param {google.cloud.secretmanager.v1beta2.Replication.UserManaged.IReplica=} [properties] Properties to set
                                 */
                                function Replica(properties) {
                                    if (properties)
                                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                            if (properties[keys[i]] != null)
                                                this[keys[i]] = properties[keys[i]];
                                }
    
                                /**
                                 * Replica location.
                                 * @member {string} location
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @instance
                                 */
                                Replica.prototype.location = "";
    
                                /**
                                 * Replica customerManagedEncryption.
                                 * @member {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption|null|undefined} customerManagedEncryption
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @instance
                                 */
                                Replica.prototype.customerManagedEncryption = null;
    
                                /**
                                 * Creates a new Replica instance using the specified properties.
                                 * @function create
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.Replication.UserManaged.IReplica=} [properties] Properties to set
                                 * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica} Replica instance
                                 */
                                Replica.create = function create(properties) {
                                    return new Replica(properties);
                                };
    
                                /**
                                 * Encodes the specified Replica message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.verify|verify} messages.
                                 * @function encode
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.Replication.UserManaged.IReplica} message Replica message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                Replica.encode = function encode(message, writer) {
                                    if (!writer)
                                        writer = $Writer.create();
                                    if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.location);
                                    if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                        $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.encode(message.customerManagedEncryption, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                    return writer;
                                };
    
                                /**
                                 * Encodes the specified Replica message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.verify|verify} messages.
                                 * @function encodeDelimited
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.Replication.UserManaged.IReplica} message Replica message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                Replica.encodeDelimited = function encodeDelimited(message, writer) {
                                    return this.encode(message, writer).ldelim();
                                };
    
                                /**
                                 * Decodes a Replica message from the specified reader or buffer.
                                 * @function decode
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @param {number} [length] Message length if known beforehand
                                 * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica} Replica
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                Replica.decode = function decode(reader, length) {
                                    if (!(reader instanceof $Reader))
                                        reader = $Reader.create(reader);
                                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica();
                                    while (reader.pos < end) {
                                        var tag = reader.uint32();
                                        switch (tag >>> 3) {
                                        case 1: {
                                                message.location = reader.string();
                                                break;
                                            }
                                        case 2: {
                                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.decode(reader, reader.uint32());
                                                break;
                                            }
                                        default:
                                            reader.skipType(tag & 7);
                                            break;
                                        }
                                    }
                                    return message;
                                };
    
                                /**
                                 * Decodes a Replica message from the specified reader or buffer, length delimited.
                                 * @function decodeDelimited
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica} Replica
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                Replica.decodeDelimited = function decodeDelimited(reader) {
                                    if (!(reader instanceof $Reader))
                                        reader = new $Reader(reader);
                                    return this.decode(reader, reader.uint32());
                                };
    
                                /**
                                 * Verifies a Replica message.
                                 * @function verify
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {Object.<string,*>} message Plain object to verify
                                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                                 */
                                Replica.verify = function verify(message) {
                                    if (typeof message !== "object" || message === null)
                                        return "object expected";
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        if (!$util.isString(message.location))
                                            return "location: string expected";
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                        var error = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.verify(message.customerManagedEncryption);
                                        if (error)
                                            return "customerManagedEncryption." + error;
                                    }
                                    return null;
                                };
    
                                /**
                                 * Creates a Replica message from a plain object. Also converts values to their respective internal types.
                                 * @function fromObject
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {Object.<string,*>} object Plain object
                                 * @returns {google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica} Replica
                                 */
                                Replica.fromObject = function fromObject(object) {
                                    if (object instanceof $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica)
                                        return object;
                                    var message = new $root.google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica();
                                    if (object.location != null)
                                        message.location = String(object.location);
                                    if (object.customerManagedEncryption != null) {
                                        if (typeof object.customerManagedEncryption !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica.customerManagedEncryption: object expected");
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.fromObject(object.customerManagedEncryption);
                                    }
                                    return message;
                                };
    
                                /**
                                 * Creates a plain object from a Replica message. Also converts values to other types if specified.
                                 * @function toObject
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica} message Replica
                                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                                 * @returns {Object.<string,*>} Plain object
                                 */
                                Replica.toObject = function toObject(message, options) {
                                    if (!options)
                                        options = {};
                                    var object = {};
                                    if (options.defaults) {
                                        object.location = "";
                                        object.customerManagedEncryption = null;
                                    }
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        object.location = message.location;
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                        object.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.toObject(message.customerManagedEncryption, options);
                                    return object;
                                };
    
                                /**
                                 * Converts this Replica to JSON.
                                 * @function toJSON
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @instance
                                 * @returns {Object.<string,*>} JSON object
                                 */
                                Replica.prototype.toJSON = function toJSON() {
                                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                                };
    
                                /**
                                 * Gets the default type url for Replica
                                 * @function getTypeUrl
                                 * @memberof google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica
                                 * @static
                                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                                 * @returns {string} The default type url
                                 */
                                Replica.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                    if (typeUrlPrefix === undefined) {
                                        typeUrlPrefix = "type.googleapis.com";
                                    }
                                    return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Replication.UserManaged.Replica";
                                };
    
                                return Replica;
                            })();
    
                            return UserManaged;
                        })();
    
                        return Replication;
                    })();
    
                    v1beta2.CustomerManagedEncryption = (function() {
    
                        /**
                         * Properties of a CustomerManagedEncryption.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ICustomerManagedEncryption
                         * @property {string|null} [kmsKeyName] CustomerManagedEncryption kmsKeyName
                         */
    
                        /**
                         * Constructs a new CustomerManagedEncryption.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a CustomerManagedEncryption.
                         * @implements ICustomerManagedEncryption
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption=} [properties] Properties to set
                         */
                        function CustomerManagedEncryption(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CustomerManagedEncryption kmsKeyName.
                         * @member {string} kmsKeyName
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @instance
                         */
                        CustomerManagedEncryption.prototype.kmsKeyName = "";
    
                        /**
                         * Creates a new CustomerManagedEncryption instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryption} CustomerManagedEncryption instance
                         */
                        CustomerManagedEncryption.create = function create(properties) {
                            return new CustomerManagedEncryption(properties);
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryption message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption} message CustomerManagedEncryption message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryption.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.kmsKeyName != null && Object.hasOwnProperty.call(message, "kmsKeyName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.kmsKeyName);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryption message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.CustomerManagedEncryption.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryption} message CustomerManagedEncryption message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryption.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryption message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryption} CustomerManagedEncryption
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryption.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.kmsKeyName = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryption message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryption} CustomerManagedEncryption
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryption.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CustomerManagedEncryption message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CustomerManagedEncryption.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                                if (!$util.isString(message.kmsKeyName))
                                    return "kmsKeyName: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CustomerManagedEncryption message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryption} CustomerManagedEncryption
                         */
                        CustomerManagedEncryption.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption();
                            if (object.kmsKeyName != null)
                                message.kmsKeyName = String(object.kmsKeyName);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CustomerManagedEncryption message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.CustomerManagedEncryption} message CustomerManagedEncryption
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CustomerManagedEncryption.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.kmsKeyName = "";
                            if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                                object.kmsKeyName = message.kmsKeyName;
                            return object;
                        };
    
                        /**
                         * Converts this CustomerManagedEncryption to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CustomerManagedEncryption.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CustomerManagedEncryption
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryption
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CustomerManagedEncryption.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.CustomerManagedEncryption";
                        };
    
                        return CustomerManagedEncryption;
                    })();
    
                    v1beta2.ReplicationStatus = (function() {
    
                        /**
                         * Properties of a ReplicationStatus.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IReplicationStatus
                         * @property {google.cloud.secretmanager.v1beta2.ReplicationStatus.IAutomaticStatus|null} [automatic] ReplicationStatus automatic
                         * @property {google.cloud.secretmanager.v1beta2.ReplicationStatus.IUserManagedStatus|null} [userManaged] ReplicationStatus userManaged
                         */
    
                        /**
                         * Constructs a new ReplicationStatus.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a ReplicationStatus.
                         * @implements IReplicationStatus
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IReplicationStatus=} [properties] Properties to set
                         */
                        function ReplicationStatus(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReplicationStatus automatic.
                         * @member {google.cloud.secretmanager.v1beta2.ReplicationStatus.IAutomaticStatus|null|undefined} automatic
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @instance
                         */
                        ReplicationStatus.prototype.automatic = null;
    
                        /**
                         * ReplicationStatus userManaged.
                         * @member {google.cloud.secretmanager.v1beta2.ReplicationStatus.IUserManagedStatus|null|undefined} userManaged
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @instance
                         */
                        ReplicationStatus.prototype.userManaged = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ReplicationStatus replicationStatus.
                         * @member {"automatic"|"userManaged"|undefined} replicationStatus
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @instance
                         */
                        Object.defineProperty(ReplicationStatus.prototype, "replicationStatus", {
                            get: $util.oneOfGetter($oneOfFields = ["automatic", "userManaged"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ReplicationStatus instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IReplicationStatus=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus} ReplicationStatus instance
                         */
                        ReplicationStatus.create = function create(properties) {
                            return new ReplicationStatus(properties);
                        };
    
                        /**
                         * Encodes the specified ReplicationStatus message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IReplicationStatus} message ReplicationStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplicationStatus.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.automatic != null && Object.hasOwnProperty.call(message, "automatic"))
                                $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.encode(message.automatic, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.userManaged != null && Object.hasOwnProperty.call(message, "userManaged"))
                                $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.encode(message.userManaged, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReplicationStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IReplicationStatus} message ReplicationStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplicationStatus.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReplicationStatus message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus} ReplicationStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplicationStatus.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.automatic = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.userManaged = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReplicationStatus message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus} ReplicationStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplicationStatus.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReplicationStatus message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReplicationStatus.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                properties.replicationStatus = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.verify(message.automatic);
                                    if (error)
                                        return "automatic." + error;
                                }
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                if (properties.replicationStatus === 1)
                                    return "replicationStatus: multiple values";
                                properties.replicationStatus = 1;
                                {
                                    var error = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.verify(message.userManaged);
                                    if (error)
                                        return "userManaged." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ReplicationStatus message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus} ReplicationStatus
                         */
                        ReplicationStatus.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.ReplicationStatus)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus();
                            if (object.automatic != null) {
                                if (typeof object.automatic !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.ReplicationStatus.automatic: object expected");
                                message.automatic = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.fromObject(object.automatic);
                            }
                            if (object.userManaged != null) {
                                if (typeof object.userManaged !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.ReplicationStatus.userManaged: object expected");
                                message.userManaged = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.fromObject(object.userManaged);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReplicationStatus message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus} message ReplicationStatus
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReplicationStatus.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.automatic != null && message.hasOwnProperty("automatic")) {
                                object.automatic = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.toObject(message.automatic, options);
                                if (options.oneofs)
                                    object.replicationStatus = "automatic";
                            }
                            if (message.userManaged != null && message.hasOwnProperty("userManaged")) {
                                object.userManaged = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.toObject(message.userManaged, options);
                                if (options.oneofs)
                                    object.replicationStatus = "userManaged";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ReplicationStatus to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReplicationStatus.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ReplicationStatus
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ReplicationStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ReplicationStatus";
                        };
    
                        ReplicationStatus.AutomaticStatus = (function() {
    
                            /**
                             * Properties of an AutomaticStatus.
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                             * @interface IAutomaticStatus
                             * @property {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus|null} [customerManagedEncryption] AutomaticStatus customerManagedEncryption
                             */
    
                            /**
                             * Constructs a new AutomaticStatus.
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                             * @classdesc Represents an AutomaticStatus.
                             * @implements IAutomaticStatus
                             * @constructor
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IAutomaticStatus=} [properties] Properties to set
                             */
                            function AutomaticStatus(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * AutomaticStatus customerManagedEncryption.
                             * @member {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus|null|undefined} customerManagedEncryption
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @instance
                             */
                            AutomaticStatus.prototype.customerManagedEncryption = null;
    
                            /**
                             * Creates a new AutomaticStatus instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IAutomaticStatus=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus} AutomaticStatus instance
                             */
                            AutomaticStatus.create = function create(properties) {
                                return new AutomaticStatus(properties);
                            };
    
                            /**
                             * Encodes the specified AutomaticStatus message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IAutomaticStatus} message AutomaticStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AutomaticStatus.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                    $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.encode(message.customerManagedEncryption, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified AutomaticStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IAutomaticStatus} message AutomaticStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AutomaticStatus.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an AutomaticStatus message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus} AutomaticStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AutomaticStatus.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an AutomaticStatus message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus} AutomaticStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AutomaticStatus.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an AutomaticStatus message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            AutomaticStatus.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                    var error = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.verify(message.customerManagedEncryption);
                                    if (error)
                                        return "customerManagedEncryption." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates an AutomaticStatus message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus} AutomaticStatus
                             */
                            AutomaticStatus.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus();
                                if (object.customerManagedEncryption != null) {
                                    if (typeof object.customerManagedEncryption !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus.customerManagedEncryption: object expected");
                                    message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.fromObject(object.customerManagedEncryption);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an AutomaticStatus message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus} message AutomaticStatus
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            AutomaticStatus.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.customerManagedEncryption = null;
                                if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                    object.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.toObject(message.customerManagedEncryption, options);
                                return object;
                            };
    
                            /**
                             * Converts this AutomaticStatus to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            AutomaticStatus.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for AutomaticStatus
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            AutomaticStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ReplicationStatus.AutomaticStatus";
                            };
    
                            return AutomaticStatus;
                        })();
    
                        ReplicationStatus.UserManagedStatus = (function() {
    
                            /**
                             * Properties of a UserManagedStatus.
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                             * @interface IUserManagedStatus
                             * @property {Array.<google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.IReplicaStatus>|null} [replicas] UserManagedStatus replicas
                             */
    
                            /**
                             * Constructs a new UserManagedStatus.
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus
                             * @classdesc Represents a UserManagedStatus.
                             * @implements IUserManagedStatus
                             * @constructor
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IUserManagedStatus=} [properties] Properties to set
                             */
                            function UserManagedStatus(properties) {
                                this.replicas = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * UserManagedStatus replicas.
                             * @member {Array.<google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.IReplicaStatus>} replicas
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @instance
                             */
                            UserManagedStatus.prototype.replicas = $util.emptyArray;
    
                            /**
                             * Creates a new UserManagedStatus instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IUserManagedStatus=} [properties] Properties to set
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus} UserManagedStatus instance
                             */
                            UserManagedStatus.create = function create(properties) {
                                return new UserManagedStatus(properties);
                            };
    
                            /**
                             * Encodes the specified UserManagedStatus message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IUserManagedStatus} message UserManagedStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManagedStatus.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.replicas != null && message.replicas.length)
                                    for (var i = 0; i < message.replicas.length; ++i)
                                        $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.encode(message.replicas[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified UserManagedStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.IUserManagedStatus} message UserManagedStatus message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UserManagedStatus.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a UserManagedStatus message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus} UserManagedStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManagedStatus.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.replicas && message.replicas.length))
                                                message.replicas = [];
                                            message.replicas.push($root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a UserManagedStatus message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus} UserManagedStatus
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UserManagedStatus.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a UserManagedStatus message.
                             * @function verify
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            UserManagedStatus.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.replicas != null && message.hasOwnProperty("replicas")) {
                                    if (!Array.isArray(message.replicas))
                                        return "replicas: array expected";
                                    for (var i = 0; i < message.replicas.length; ++i) {
                                        var error = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.verify(message.replicas[i]);
                                        if (error)
                                            return "replicas." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a UserManagedStatus message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus} UserManagedStatus
                             */
                            UserManagedStatus.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus)
                                    return object;
                                var message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus();
                                if (object.replicas) {
                                    if (!Array.isArray(object.replicas))
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.replicas: array expected");
                                    message.replicas = [];
                                    for (var i = 0; i < object.replicas.length; ++i) {
                                        if (typeof object.replicas[i] !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.replicas: object expected");
                                        message.replicas[i] = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.fromObject(object.replicas[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a UserManagedStatus message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus} message UserManagedStatus
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            UserManagedStatus.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.replicas = [];
                                if (message.replicas && message.replicas.length) {
                                    object.replicas = [];
                                    for (var j = 0; j < message.replicas.length; ++j)
                                        object.replicas[j] = $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.toObject(message.replicas[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this UserManagedStatus to JSON.
                             * @function toJSON
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            UserManagedStatus.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for UserManagedStatus
                             * @function getTypeUrl
                             * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            UserManagedStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus";
                            };
    
                            UserManagedStatus.ReplicaStatus = (function() {
    
                                /**
                                 * Properties of a ReplicaStatus.
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                                 * @interface IReplicaStatus
                                 * @property {string|null} [location] ReplicaStatus location
                                 * @property {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus|null} [customerManagedEncryption] ReplicaStatus customerManagedEncryption
                                 */
    
                                /**
                                 * Constructs a new ReplicaStatus.
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus
                                 * @classdesc Represents a ReplicaStatus.
                                 * @implements IReplicaStatus
                                 * @constructor
                                 * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.IReplicaStatus=} [properties] Properties to set
                                 */
                                function ReplicaStatus(properties) {
                                    if (properties)
                                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                            if (properties[keys[i]] != null)
                                                this[keys[i]] = properties[keys[i]];
                                }
    
                                /**
                                 * ReplicaStatus location.
                                 * @member {string} location
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @instance
                                 */
                                ReplicaStatus.prototype.location = "";
    
                                /**
                                 * ReplicaStatus customerManagedEncryption.
                                 * @member {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus|null|undefined} customerManagedEncryption
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @instance
                                 */
                                ReplicaStatus.prototype.customerManagedEncryption = null;
    
                                /**
                                 * Creates a new ReplicaStatus instance using the specified properties.
                                 * @function create
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.IReplicaStatus=} [properties] Properties to set
                                 * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus instance
                                 */
                                ReplicaStatus.create = function create(properties) {
                                    return new ReplicaStatus(properties);
                                };
    
                                /**
                                 * Encodes the specified ReplicaStatus message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.verify|verify} messages.
                                 * @function encode
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.IReplicaStatus} message ReplicaStatus message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                ReplicaStatus.encode = function encode(message, writer) {
                                    if (!writer)
                                        writer = $Writer.create();
                                    if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.location);
                                    if (message.customerManagedEncryption != null && Object.hasOwnProperty.call(message, "customerManagedEncryption"))
                                        $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.encode(message.customerManagedEncryption, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                    return writer;
                                };
    
                                /**
                                 * Encodes the specified ReplicaStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.verify|verify} messages.
                                 * @function encodeDelimited
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.IReplicaStatus} message ReplicaStatus message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                ReplicaStatus.encodeDelimited = function encodeDelimited(message, writer) {
                                    return this.encode(message, writer).ldelim();
                                };
    
                                /**
                                 * Decodes a ReplicaStatus message from the specified reader or buffer.
                                 * @function decode
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @param {number} [length] Message length if known beforehand
                                 * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                ReplicaStatus.decode = function decode(reader, length) {
                                    if (!(reader instanceof $Reader))
                                        reader = $Reader.create(reader);
                                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus();
                                    while (reader.pos < end) {
                                        var tag = reader.uint32();
                                        switch (tag >>> 3) {
                                        case 1: {
                                                message.location = reader.string();
                                                break;
                                            }
                                        case 2: {
                                                message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.decode(reader, reader.uint32());
                                                break;
                                            }
                                        default:
                                            reader.skipType(tag & 7);
                                            break;
                                        }
                                    }
                                    return message;
                                };
    
                                /**
                                 * Decodes a ReplicaStatus message from the specified reader or buffer, length delimited.
                                 * @function decodeDelimited
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                ReplicaStatus.decodeDelimited = function decodeDelimited(reader) {
                                    if (!(reader instanceof $Reader))
                                        reader = new $Reader(reader);
                                    return this.decode(reader, reader.uint32());
                                };
    
                                /**
                                 * Verifies a ReplicaStatus message.
                                 * @function verify
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {Object.<string,*>} message Plain object to verify
                                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                                 */
                                ReplicaStatus.verify = function verify(message) {
                                    if (typeof message !== "object" || message === null)
                                        return "object expected";
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        if (!$util.isString(message.location))
                                            return "location: string expected";
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption")) {
                                        var error = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.verify(message.customerManagedEncryption);
                                        if (error)
                                            return "customerManagedEncryption." + error;
                                    }
                                    return null;
                                };
    
                                /**
                                 * Creates a ReplicaStatus message from a plain object. Also converts values to their respective internal types.
                                 * @function fromObject
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {Object.<string,*>} object Plain object
                                 * @returns {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus} ReplicaStatus
                                 */
                                ReplicaStatus.fromObject = function fromObject(object) {
                                    if (object instanceof $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus)
                                        return object;
                                    var message = new $root.google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus();
                                    if (object.location != null)
                                        message.location = String(object.location);
                                    if (object.customerManagedEncryption != null) {
                                        if (typeof object.customerManagedEncryption !== "object")
                                            throw TypeError(".google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus.customerManagedEncryption: object expected");
                                        message.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.fromObject(object.customerManagedEncryption);
                                    }
                                    return message;
                                };
    
                                /**
                                 * Creates a plain object from a ReplicaStatus message. Also converts values to other types if specified.
                                 * @function toObject
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus} message ReplicaStatus
                                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                                 * @returns {Object.<string,*>} Plain object
                                 */
                                ReplicaStatus.toObject = function toObject(message, options) {
                                    if (!options)
                                        options = {};
                                    var object = {};
                                    if (options.defaults) {
                                        object.location = "";
                                        object.customerManagedEncryption = null;
                                    }
                                    if (message.location != null && message.hasOwnProperty("location"))
                                        object.location = message.location;
                                    if (message.customerManagedEncryption != null && message.hasOwnProperty("customerManagedEncryption"))
                                        object.customerManagedEncryption = $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.toObject(message.customerManagedEncryption, options);
                                    return object;
                                };
    
                                /**
                                 * Converts this ReplicaStatus to JSON.
                                 * @function toJSON
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @instance
                                 * @returns {Object.<string,*>} JSON object
                                 */
                                ReplicaStatus.prototype.toJSON = function toJSON() {
                                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                                };
    
                                /**
                                 * Gets the default type url for ReplicaStatus
                                 * @function getTypeUrl
                                 * @memberof google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus
                                 * @static
                                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                                 * @returns {string} The default type url
                                 */
                                ReplicaStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                    if (typeUrlPrefix === undefined) {
                                        typeUrlPrefix = "type.googleapis.com";
                                    }
                                    return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ReplicationStatus.UserManagedStatus.ReplicaStatus";
                                };
    
                                return ReplicaStatus;
                            })();
    
                            return UserManagedStatus;
                        })();
    
                        return ReplicationStatus;
                    })();
    
                    v1beta2.CustomerManagedEncryptionStatus = (function() {
    
                        /**
                         * Properties of a CustomerManagedEncryptionStatus.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ICustomerManagedEncryptionStatus
                         * @property {string|null} [kmsKeyVersionName] CustomerManagedEncryptionStatus kmsKeyVersionName
                         */
    
                        /**
                         * Constructs a new CustomerManagedEncryptionStatus.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a CustomerManagedEncryptionStatus.
                         * @implements ICustomerManagedEncryptionStatus
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus=} [properties] Properties to set
                         */
                        function CustomerManagedEncryptionStatus(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CustomerManagedEncryptionStatus kmsKeyVersionName.
                         * @member {string} kmsKeyVersionName
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @instance
                         */
                        CustomerManagedEncryptionStatus.prototype.kmsKeyVersionName = "";
    
                        /**
                         * Creates a new CustomerManagedEncryptionStatus instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus instance
                         */
                        CustomerManagedEncryptionStatus.create = function create(properties) {
                            return new CustomerManagedEncryptionStatus(properties);
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryptionStatus message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus} message CustomerManagedEncryptionStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryptionStatus.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.kmsKeyVersionName != null && Object.hasOwnProperty.call(message, "kmsKeyVersionName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.kmsKeyVersionName);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CustomerManagedEncryptionStatus message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICustomerManagedEncryptionStatus} message CustomerManagedEncryptionStatus message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomerManagedEncryptionStatus.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryptionStatus message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryptionStatus.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.kmsKeyVersionName = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CustomerManagedEncryptionStatus message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomerManagedEncryptionStatus.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CustomerManagedEncryptionStatus message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CustomerManagedEncryptionStatus.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.kmsKeyVersionName != null && message.hasOwnProperty("kmsKeyVersionName"))
                                if (!$util.isString(message.kmsKeyVersionName))
                                    return "kmsKeyVersionName: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CustomerManagedEncryptionStatus message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus} CustomerManagedEncryptionStatus
                         */
                        CustomerManagedEncryptionStatus.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus();
                            if (object.kmsKeyVersionName != null)
                                message.kmsKeyVersionName = String(object.kmsKeyVersionName);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CustomerManagedEncryptionStatus message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus} message CustomerManagedEncryptionStatus
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CustomerManagedEncryptionStatus.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.kmsKeyVersionName = "";
                            if (message.kmsKeyVersionName != null && message.hasOwnProperty("kmsKeyVersionName"))
                                object.kmsKeyVersionName = message.kmsKeyVersionName;
                            return object;
                        };
    
                        /**
                         * Converts this CustomerManagedEncryptionStatus to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CustomerManagedEncryptionStatus.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CustomerManagedEncryptionStatus
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CustomerManagedEncryptionStatus.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus";
                        };
    
                        return CustomerManagedEncryptionStatus;
                    })();
    
                    v1beta2.Topic = (function() {
    
                        /**
                         * Properties of a Topic.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ITopic
                         * @property {string|null} [name] Topic name
                         */
    
                        /**
                         * Constructs a new Topic.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a Topic.
                         * @implements ITopic
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ITopic=} [properties] Properties to set
                         */
                        function Topic(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Topic name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @instance
                         */
                        Topic.prototype.name = "";
    
                        /**
                         * Creates a new Topic instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ITopic=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.Topic} Topic instance
                         */
                        Topic.create = function create(properties) {
                            return new Topic(properties);
                        };
    
                        /**
                         * Encodes the specified Topic message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Topic.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ITopic} message Topic message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Topic.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Topic message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Topic.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ITopic} message Topic message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Topic.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Topic message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.Topic} Topic
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Topic.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Topic();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Topic message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.Topic} Topic
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Topic.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Topic message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Topic.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a Topic message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.Topic} Topic
                         */
                        Topic.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.Topic)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.Topic();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Topic message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.Topic} message Topic
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Topic.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this Topic to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Topic.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Topic
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.Topic
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Topic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Topic";
                        };
    
                        return Topic;
                    })();
    
                    v1beta2.Rotation = (function() {
    
                        /**
                         * Properties of a Rotation.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IRotation
                         * @property {google.protobuf.ITimestamp|null} [nextRotationTime] Rotation nextRotationTime
                         * @property {google.protobuf.IDuration|null} [rotationPeriod] Rotation rotationPeriod
                         */
    
                        /**
                         * Constructs a new Rotation.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a Rotation.
                         * @implements IRotation
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IRotation=} [properties] Properties to set
                         */
                        function Rotation(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Rotation nextRotationTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} nextRotationTime
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @instance
                         */
                        Rotation.prototype.nextRotationTime = null;
    
                        /**
                         * Rotation rotationPeriod.
                         * @member {google.protobuf.IDuration|null|undefined} rotationPeriod
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @instance
                         */
                        Rotation.prototype.rotationPeriod = null;
    
                        /**
                         * Creates a new Rotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IRotation=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.Rotation} Rotation instance
                         */
                        Rotation.create = function create(properties) {
                            return new Rotation(properties);
                        };
    
                        /**
                         * Encodes the specified Rotation message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Rotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IRotation} message Rotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Rotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.nextRotationTime != null && Object.hasOwnProperty.call(message, "nextRotationTime"))
                                $root.google.protobuf.Timestamp.encode(message.nextRotationTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.rotationPeriod != null && Object.hasOwnProperty.call(message, "rotationPeriod"))
                                $root.google.protobuf.Duration.encode(message.rotationPeriod, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Rotation message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.Rotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IRotation} message Rotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Rotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Rotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.Rotation} Rotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Rotation.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.Rotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.nextRotationTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.rotationPeriod = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Rotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.Rotation} Rotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Rotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Rotation message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Rotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.nextRotationTime != null && message.hasOwnProperty("nextRotationTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.nextRotationTime);
                                if (error)
                                    return "nextRotationTime." + error;
                            }
                            if (message.rotationPeriod != null && message.hasOwnProperty("rotationPeriod")) {
                                var error = $root.google.protobuf.Duration.verify(message.rotationPeriod);
                                if (error)
                                    return "rotationPeriod." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Rotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.Rotation} Rotation
                         */
                        Rotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.Rotation)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.Rotation();
                            if (object.nextRotationTime != null) {
                                if (typeof object.nextRotationTime !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Rotation.nextRotationTime: object expected");
                                message.nextRotationTime = $root.google.protobuf.Timestamp.fromObject(object.nextRotationTime);
                            }
                            if (object.rotationPeriod != null) {
                                if (typeof object.rotationPeriod !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.Rotation.rotationPeriod: object expected");
                                message.rotationPeriod = $root.google.protobuf.Duration.fromObject(object.rotationPeriod);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Rotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.Rotation} message Rotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Rotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.nextRotationTime = null;
                                object.rotationPeriod = null;
                            }
                            if (message.nextRotationTime != null && message.hasOwnProperty("nextRotationTime"))
                                object.nextRotationTime = $root.google.protobuf.Timestamp.toObject(message.nextRotationTime, options);
                            if (message.rotationPeriod != null && message.hasOwnProperty("rotationPeriod"))
                                object.rotationPeriod = $root.google.protobuf.Duration.toObject(message.rotationPeriod, options);
                            return object;
                        };
    
                        /**
                         * Converts this Rotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Rotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Rotation
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.Rotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Rotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.Rotation";
                        };
    
                        return Rotation;
                    })();
    
                    v1beta2.SecretPayload = (function() {
    
                        /**
                         * Properties of a SecretPayload.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ISecretPayload
                         * @property {Uint8Array|null} [data] SecretPayload data
                         * @property {number|Long|null} [dataCrc32c] SecretPayload dataCrc32c
                         */
    
                        /**
                         * Constructs a new SecretPayload.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a SecretPayload.
                         * @implements ISecretPayload
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ISecretPayload=} [properties] Properties to set
                         */
                        function SecretPayload(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SecretPayload data.
                         * @member {Uint8Array} data
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @instance
                         */
                        SecretPayload.prototype.data = $util.newBuffer([]);
    
                        /**
                         * SecretPayload dataCrc32c.
                         * @member {number|Long|null|undefined} dataCrc32c
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @instance
                         */
                        SecretPayload.prototype.dataCrc32c = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * SecretPayload _dataCrc32c.
                         * @member {"dataCrc32c"|undefined} _dataCrc32c
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @instance
                         */
                        Object.defineProperty(SecretPayload.prototype, "_dataCrc32c", {
                            get: $util.oneOfGetter($oneOfFields = ["dataCrc32c"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new SecretPayload instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecretPayload=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.SecretPayload} SecretPayload instance
                         */
                        SecretPayload.create = function create(properties) {
                            return new SecretPayload(properties);
                        };
    
                        /**
                         * Encodes the specified SecretPayload message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.SecretPayload.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecretPayload} message SecretPayload message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretPayload.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.data);
                            if (message.dataCrc32c != null && Object.hasOwnProperty.call(message, "dataCrc32c"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.dataCrc32c);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SecretPayload message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.SecretPayload.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ISecretPayload} message SecretPayload message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SecretPayload.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SecretPayload message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.SecretPayload} SecretPayload
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretPayload.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.SecretPayload();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.data = reader.bytes();
                                        break;
                                    }
                                case 2: {
                                        message.dataCrc32c = reader.int64();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SecretPayload message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.SecretPayload} SecretPayload
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SecretPayload.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SecretPayload message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SecretPayload.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.data != null && message.hasOwnProperty("data"))
                                if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                                    return "data: buffer expected";
                            if (message.dataCrc32c != null && message.hasOwnProperty("dataCrc32c")) {
                                properties._dataCrc32c = 1;
                                if (!$util.isInteger(message.dataCrc32c) && !(message.dataCrc32c && $util.isInteger(message.dataCrc32c.low) && $util.isInteger(message.dataCrc32c.high)))
                                    return "dataCrc32c: integer|Long expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SecretPayload message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.SecretPayload} SecretPayload
                         */
                        SecretPayload.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.SecretPayload)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.SecretPayload();
                            if (object.data != null)
                                if (typeof object.data === "string")
                                    $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                                else if (object.data.length >= 0)
                                    message.data = object.data;
                            if (object.dataCrc32c != null)
                                if ($util.Long)
                                    (message.dataCrc32c = $util.Long.fromValue(object.dataCrc32c)).unsigned = false;
                                else if (typeof object.dataCrc32c === "string")
                                    message.dataCrc32c = parseInt(object.dataCrc32c, 10);
                                else if (typeof object.dataCrc32c === "number")
                                    message.dataCrc32c = object.dataCrc32c;
                                else if (typeof object.dataCrc32c === "object")
                                    message.dataCrc32c = new $util.LongBits(object.dataCrc32c.low >>> 0, object.dataCrc32c.high >>> 0).toNumber();
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SecretPayload message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.SecretPayload} message SecretPayload
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SecretPayload.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                if (options.bytes === String)
                                    object.data = "";
                                else {
                                    object.data = [];
                                    if (options.bytes !== Array)
                                        object.data = $util.newBuffer(object.data);
                                }
                            if (message.data != null && message.hasOwnProperty("data"))
                                object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                            if (message.dataCrc32c != null && message.hasOwnProperty("dataCrc32c")) {
                                if (typeof message.dataCrc32c === "number")
                                    object.dataCrc32c = options.longs === String ? String(message.dataCrc32c) : message.dataCrc32c;
                                else
                                    object.dataCrc32c = options.longs === String ? $util.Long.prototype.toString.call(message.dataCrc32c) : options.longs === Number ? new $util.LongBits(message.dataCrc32c.low >>> 0, message.dataCrc32c.high >>> 0).toNumber() : message.dataCrc32c;
                                if (options.oneofs)
                                    object._dataCrc32c = "dataCrc32c";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this SecretPayload to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SecretPayload.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SecretPayload
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.SecretPayload
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SecretPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.SecretPayload";
                        };
    
                        return SecretPayload;
                    })();
    
                    v1beta2.SecretManagerService = (function() {
    
                        /**
                         * Constructs a new SecretManagerService service.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a SecretManagerService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function SecretManagerService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (SecretManagerService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = SecretManagerService;
    
                        /**
                         * Creates new SecretManagerService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {SecretManagerService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        SecretManagerService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|listSecrets}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef ListSecretsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.ListSecretsResponse} [response] ListSecretsResponse
                         */
    
                        /**
                         * Calls ListSecrets.
                         * @function listSecrets
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsRequest} request ListSecretsRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.ListSecretsCallback} callback Node-style callback called with the error, if any, and ListSecretsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.listSecrets = function listSecrets(request, callback) {
                            return this.rpcCall(listSecrets, $root.google.cloud.secretmanager.v1beta2.ListSecretsRequest, $root.google.cloud.secretmanager.v1beta2.ListSecretsResponse, request, callback);
                        }, "name", { value: "ListSecrets" });
    
                        /**
                         * Calls ListSecrets.
                         * @function listSecrets
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsRequest} request ListSecretsRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.ListSecretsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|createSecret}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef CreateSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.Secret} [response] Secret
                         */
    
                        /**
                         * Calls CreateSecret.
                         * @function createSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.ICreateSecretRequest} request CreateSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.CreateSecretCallback} callback Node-style callback called with the error, if any, and Secret
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.createSecret = function createSecret(request, callback) {
                            return this.rpcCall(createSecret, $root.google.cloud.secretmanager.v1beta2.CreateSecretRequest, $root.google.cloud.secretmanager.v1beta2.Secret, request, callback);
                        }, "name", { value: "CreateSecret" });
    
                        /**
                         * Calls CreateSecret.
                         * @function createSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.ICreateSecretRequest} request CreateSecretRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.Secret>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|addSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef AddSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls AddSecretVersion.
                         * @function addSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IAddSecretVersionRequest} request AddSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.AddSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.addSecretVersion = function addSecretVersion(request, callback) {
                            return this.rpcCall(addSecretVersion, $root.google.cloud.secretmanager.v1beta2.AddSecretVersionRequest, $root.google.cloud.secretmanager.v1beta2.SecretVersion, request, callback);
                        }, "name", { value: "AddSecretVersion" });
    
                        /**
                         * Calls AddSecretVersion.
                         * @function addSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IAddSecretVersionRequest} request AddSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|getSecret}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef GetSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.Secret} [response] Secret
                         */
    
                        /**
                         * Calls GetSecret.
                         * @function getSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretRequest} request GetSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.GetSecretCallback} callback Node-style callback called with the error, if any, and Secret
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.getSecret = function getSecret(request, callback) {
                            return this.rpcCall(getSecret, $root.google.cloud.secretmanager.v1beta2.GetSecretRequest, $root.google.cloud.secretmanager.v1beta2.Secret, request, callback);
                        }, "name", { value: "GetSecret" });
    
                        /**
                         * Calls GetSecret.
                         * @function getSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretRequest} request GetSecretRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.Secret>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|updateSecret}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef UpdateSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.Secret} [response] Secret
                         */
    
                        /**
                         * Calls UpdateSecret.
                         * @function updateSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IUpdateSecretRequest} request UpdateSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.UpdateSecretCallback} callback Node-style callback called with the error, if any, and Secret
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.updateSecret = function updateSecret(request, callback) {
                            return this.rpcCall(updateSecret, $root.google.cloud.secretmanager.v1beta2.UpdateSecretRequest, $root.google.cloud.secretmanager.v1beta2.Secret, request, callback);
                        }, "name", { value: "UpdateSecret" });
    
                        /**
                         * Calls UpdateSecret.
                         * @function updateSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IUpdateSecretRequest} request UpdateSecretRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.Secret>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|deleteSecret}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef DeleteSecretCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteSecret.
                         * @function deleteSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IDeleteSecretRequest} request DeleteSecretRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.DeleteSecretCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.deleteSecret = function deleteSecret(request, callback) {
                            return this.rpcCall(deleteSecret, $root.google.cloud.secretmanager.v1beta2.DeleteSecretRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteSecret" });
    
                        /**
                         * Calls DeleteSecret.
                         * @function deleteSecret
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IDeleteSecretRequest} request DeleteSecretRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|listSecretVersions}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef ListSecretVersionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse} [response] ListSecretVersionsResponse
                         */
    
                        /**
                         * Calls ListSecretVersions.
                         * @function listSecretVersions
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsRequest} request ListSecretVersionsRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.ListSecretVersionsCallback} callback Node-style callback called with the error, if any, and ListSecretVersionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.listSecretVersions = function listSecretVersions(request, callback) {
                            return this.rpcCall(listSecretVersions, $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest, $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse, request, callback);
                        }, "name", { value: "ListSecretVersions" });
    
                        /**
                         * Calls ListSecretVersions.
                         * @function listSecretVersions
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsRequest} request ListSecretVersionsRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|getSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef GetSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls GetSecretVersion.
                         * @function getSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretVersionRequest} request GetSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.GetSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.getSecretVersion = function getSecretVersion(request, callback) {
                            return this.rpcCall(getSecretVersion, $root.google.cloud.secretmanager.v1beta2.GetSecretVersionRequest, $root.google.cloud.secretmanager.v1beta2.SecretVersion, request, callback);
                        }, "name", { value: "GetSecretVersion" });
    
                        /**
                         * Calls GetSecretVersion.
                         * @function getSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretVersionRequest} request GetSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|accessSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef AccessSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse} [response] AccessSecretVersionResponse
                         */
    
                        /**
                         * Calls AccessSecretVersion.
                         * @function accessSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionRequest} request AccessSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.AccessSecretVersionCallback} callback Node-style callback called with the error, if any, and AccessSecretVersionResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.accessSecretVersion = function accessSecretVersion(request, callback) {
                            return this.rpcCall(accessSecretVersion, $root.google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest, $root.google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse, request, callback);
                        }, "name", { value: "AccessSecretVersion" });
    
                        /**
                         * Calls AccessSecretVersion.
                         * @function accessSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionRequest} request AccessSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|disableSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef DisableSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls DisableSecretVersion.
                         * @function disableSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IDisableSecretVersionRequest} request DisableSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.DisableSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.disableSecretVersion = function disableSecretVersion(request, callback) {
                            return this.rpcCall(disableSecretVersion, $root.google.cloud.secretmanager.v1beta2.DisableSecretVersionRequest, $root.google.cloud.secretmanager.v1beta2.SecretVersion, request, callback);
                        }, "name", { value: "DisableSecretVersion" });
    
                        /**
                         * Calls DisableSecretVersion.
                         * @function disableSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IDisableSecretVersionRequest} request DisableSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|enableSecretVersion}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef EnableSecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls EnableSecretVersion.
                         * @function enableSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IEnableSecretVersionRequest} request EnableSecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.EnableSecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.enableSecretVersion = function enableSecretVersion(request, callback) {
                            return this.rpcCall(enableSecretVersion, $root.google.cloud.secretmanager.v1beta2.EnableSecretVersionRequest, $root.google.cloud.secretmanager.v1beta2.SecretVersion, request, callback);
                        }, "name", { value: "EnableSecretVersion" });
    
                        /**
                         * Calls EnableSecretVersion.
                         * @function enableSecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IEnableSecretVersionRequest} request EnableSecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|destroySecretVersion}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef DestroySecretVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.secretmanager.v1beta2.SecretVersion} [response] SecretVersion
                         */
    
                        /**
                         * Calls DestroySecretVersion.
                         * @function destroySecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IDestroySecretVersionRequest} request DestroySecretVersionRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.DestroySecretVersionCallback} callback Node-style callback called with the error, if any, and SecretVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.destroySecretVersion = function destroySecretVersion(request, callback) {
                            return this.rpcCall(destroySecretVersion, $root.google.cloud.secretmanager.v1beta2.DestroySecretVersionRequest, $root.google.cloud.secretmanager.v1beta2.SecretVersion, request, callback);
                        }, "name", { value: "DestroySecretVersion" });
    
                        /**
                         * Calls DestroySecretVersion.
                         * @function destroySecretVersion
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.cloud.secretmanager.v1beta2.IDestroySecretVersionRequest} request DestroySecretVersionRequest message or plain object
                         * @returns {Promise<google.cloud.secretmanager.v1beta2.SecretVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|setIamPolicy}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef SetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.SetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.setIamPolicy = function setIamPolicy(request, callback) {
                            return this.rpcCall(setIamPolicy, $root.google.iam.v1.SetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "SetIamPolicy" });
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|getIamPolicy}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef GetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.GetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.getIamPolicy = function getIamPolicy(request, callback) {
                            return this.rpcCall(getIamPolicy, $root.google.iam.v1.GetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "GetIamPolicy" });
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.secretmanager.v1beta2.SecretManagerService|testIamPermissions}.
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @typedef TestIamPermissionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.TestIamPermissionsResponse} [response] TestIamPermissionsResponse
                         */
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @param {google.cloud.secretmanager.v1beta2.SecretManagerService.TestIamPermissionsCallback} callback Node-style callback called with the error, if any, and TestIamPermissionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(SecretManagerService.prototype.testIamPermissions = function testIamPermissions(request, callback) {
                            return this.rpcCall(testIamPermissions, $root.google.iam.v1.TestIamPermissionsRequest, $root.google.iam.v1.TestIamPermissionsResponse, request, callback);
                        }, "name", { value: "TestIamPermissions" });
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.secretmanager.v1beta2.SecretManagerService
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @returns {Promise<google.iam.v1.TestIamPermissionsResponse>} Promise
                         * @variation 2
                         */
    
                        return SecretManagerService;
                    })();
    
                    v1beta2.ListSecretsRequest = (function() {
    
                        /**
                         * Properties of a ListSecretsRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IListSecretsRequest
                         * @property {string|null} [parent] ListSecretsRequest parent
                         * @property {number|null} [pageSize] ListSecretsRequest pageSize
                         * @property {string|null} [pageToken] ListSecretsRequest pageToken
                         * @property {string|null} [filter] ListSecretsRequest filter
                         */
    
                        /**
                         * Constructs a new ListSecretsRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a ListSecretsRequest.
                         * @implements IListSecretsRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsRequest=} [properties] Properties to set
                         */
                        function ListSecretsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.parent = "";
    
                        /**
                         * ListSecretsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListSecretsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.pageToken = "";
    
                        /**
                         * ListSecretsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @instance
                         */
                        ListSecretsRequest.prototype.filter = "";
    
                        /**
                         * Creates a new ListSecretsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsRequest} ListSecretsRequest instance
                         */
                        ListSecretsRequest.create = function create(properties) {
                            return new ListSecretsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretsRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsRequest} message ListSecretsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretsRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsRequest} message ListSecretsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsRequest} ListSecretsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ListSecretsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsRequest} ListSecretsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretsRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsRequest} ListSecretsRequest
                         */
                        ListSecretsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.ListSecretsRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.ListSecretsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ListSecretsRequest} message ListSecretsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ListSecretsRequest";
                        };
    
                        return ListSecretsRequest;
                    })();
    
                    v1beta2.ListSecretsResponse = (function() {
    
                        /**
                         * Properties of a ListSecretsResponse.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IListSecretsResponse
                         * @property {Array.<google.cloud.secretmanager.v1beta2.ISecret>|null} [secrets] ListSecretsResponse secrets
                         * @property {string|null} [nextPageToken] ListSecretsResponse nextPageToken
                         * @property {number|null} [totalSize] ListSecretsResponse totalSize
                         */
    
                        /**
                         * Constructs a new ListSecretsResponse.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a ListSecretsResponse.
                         * @implements IListSecretsResponse
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsResponse=} [properties] Properties to set
                         */
                        function ListSecretsResponse(properties) {
                            this.secrets = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretsResponse secrets.
                         * @member {Array.<google.cloud.secretmanager.v1beta2.ISecret>} secrets
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @instance
                         */
                        ListSecretsResponse.prototype.secrets = $util.emptyArray;
    
                        /**
                         * ListSecretsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @instance
                         */
                        ListSecretsResponse.prototype.nextPageToken = "";
    
                        /**
                         * ListSecretsResponse totalSize.
                         * @member {number} totalSize
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @instance
                         */
                        ListSecretsResponse.prototype.totalSize = 0;
    
                        /**
                         * Creates a new ListSecretsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsResponse=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsResponse} ListSecretsResponse instance
                         */
                        ListSecretsResponse.create = function create(properties) {
                            return new ListSecretsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretsResponse message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsResponse} message ListSecretsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.secrets != null && message.secrets.length)
                                for (var i = 0; i < message.secrets.length; ++i)
                                    $root.google.cloud.secretmanager.v1beta2.Secret.encode(message.secrets[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            if (message.totalSize != null && Object.hasOwnProperty.call(message, "totalSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.totalSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretsResponse message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretsResponse} message ListSecretsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsResponse} ListSecretsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ListSecretsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.secrets && message.secrets.length))
                                            message.secrets = [];
                                        message.secrets.push($root.google.cloud.secretmanager.v1beta2.Secret.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.totalSize = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsResponse} ListSecretsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretsResponse message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.secrets != null && message.hasOwnProperty("secrets")) {
                                if (!Array.isArray(message.secrets))
                                    return "secrets: array expected";
                                for (var i = 0; i < message.secrets.length; ++i) {
                                    var error = $root.google.cloud.secretmanager.v1beta2.Secret.verify(message.secrets[i]);
                                    if (error)
                                        return "secrets." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                if (!$util.isInteger(message.totalSize))
                                    return "totalSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretsResponse} ListSecretsResponse
                         */
                        ListSecretsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.ListSecretsResponse)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.ListSecretsResponse();
                            if (object.secrets) {
                                if (!Array.isArray(object.secrets))
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.ListSecretsResponse.secrets: array expected");
                                message.secrets = [];
                                for (var i = 0; i < object.secrets.length; ++i) {
                                    if (typeof object.secrets[i] !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.ListSecretsResponse.secrets: object expected");
                                    message.secrets[i] = $root.google.cloud.secretmanager.v1beta2.Secret.fromObject(object.secrets[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.totalSize != null)
                                message.totalSize = object.totalSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ListSecretsResponse} message ListSecretsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.secrets = [];
                            if (options.defaults) {
                                object.nextPageToken = "";
                                object.totalSize = 0;
                            }
                            if (message.secrets && message.secrets.length) {
                                object.secrets = [];
                                for (var j = 0; j < message.secrets.length; ++j)
                                    object.secrets[j] = $root.google.cloud.secretmanager.v1beta2.Secret.toObject(message.secrets[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                object.totalSize = message.totalSize;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ListSecretsResponse";
                        };
    
                        return ListSecretsResponse;
                    })();
    
                    v1beta2.CreateSecretRequest = (function() {
    
                        /**
                         * Properties of a CreateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface ICreateSecretRequest
                         * @property {string|null} [parent] CreateSecretRequest parent
                         * @property {string|null} [secretId] CreateSecretRequest secretId
                         * @property {google.cloud.secretmanager.v1beta2.ISecret|null} [secret] CreateSecretRequest secret
                         */
    
                        /**
                         * Constructs a new CreateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a CreateSecretRequest.
                         * @implements ICreateSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.ICreateSecretRequest=} [properties] Properties to set
                         */
                        function CreateSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateSecretRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @instance
                         */
                        CreateSecretRequest.prototype.parent = "";
    
                        /**
                         * CreateSecretRequest secretId.
                         * @member {string} secretId
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @instance
                         */
                        CreateSecretRequest.prototype.secretId = "";
    
                        /**
                         * CreateSecretRequest secret.
                         * @member {google.cloud.secretmanager.v1beta2.ISecret|null|undefined} secret
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @instance
                         */
                        CreateSecretRequest.prototype.secret = null;
    
                        /**
                         * Creates a new CreateSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICreateSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.CreateSecretRequest} CreateSecretRequest instance
                         */
                        CreateSecretRequest.create = function create(properties) {
                            return new CreateSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.CreateSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICreateSecretRequest} message CreateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.secretId != null && Object.hasOwnProperty.call(message, "secretId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.secretId);
                            if (message.secret != null && Object.hasOwnProperty.call(message, "secret"))
                                $root.google.cloud.secretmanager.v1beta2.Secret.encode(message.secret, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.CreateSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ICreateSecretRequest} message CreateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.CreateSecretRequest} CreateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.CreateSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.secretId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.secret = $root.google.cloud.secretmanager.v1beta2.Secret.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.CreateSecretRequest} CreateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.secretId != null && message.hasOwnProperty("secretId"))
                                if (!$util.isString(message.secretId))
                                    return "secretId: string expected";
                            if (message.secret != null && message.hasOwnProperty("secret")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.Secret.verify(message.secret);
                                if (error)
                                    return "secret." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.CreateSecretRequest} CreateSecretRequest
                         */
                        CreateSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.CreateSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.CreateSecretRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.secretId != null)
                                message.secretId = String(object.secretId);
                            if (object.secret != null) {
                                if (typeof object.secret !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.CreateSecretRequest.secret: object expected");
                                message.secret = $root.google.cloud.secretmanager.v1beta2.Secret.fromObject(object.secret);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.CreateSecretRequest} message CreateSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.secretId = "";
                                object.secret = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.secretId != null && message.hasOwnProperty("secretId"))
                                object.secretId = message.secretId;
                            if (message.secret != null && message.hasOwnProperty("secret"))
                                object.secret = $root.google.cloud.secretmanager.v1beta2.Secret.toObject(message.secret, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.CreateSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.CreateSecretRequest";
                        };
    
                        return CreateSecretRequest;
                    })();
    
                    v1beta2.AddSecretVersionRequest = (function() {
    
                        /**
                         * Properties of an AddSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IAddSecretVersionRequest
                         * @property {string|null} [parent] AddSecretVersionRequest parent
                         * @property {google.cloud.secretmanager.v1beta2.ISecretPayload|null} [payload] AddSecretVersionRequest payload
                         */
    
                        /**
                         * Constructs a new AddSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents an AddSecretVersionRequest.
                         * @implements IAddSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IAddSecretVersionRequest=} [properties] Properties to set
                         */
                        function AddSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AddSecretVersionRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @instance
                         */
                        AddSecretVersionRequest.prototype.parent = "";
    
                        /**
                         * AddSecretVersionRequest payload.
                         * @member {google.cloud.secretmanager.v1beta2.ISecretPayload|null|undefined} payload
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @instance
                         */
                        AddSecretVersionRequest.prototype.payload = null;
    
                        /**
                         * Creates a new AddSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAddSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.AddSecretVersionRequest} AddSecretVersionRequest instance
                         */
                        AddSecretVersionRequest.create = function create(properties) {
                            return new AddSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AddSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.AddSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAddSecretVersionRequest} message AddSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AddSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                                $root.google.cloud.secretmanager.v1beta2.SecretPayload.encode(message.payload, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AddSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.AddSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAddSecretVersionRequest} message AddSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AddSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AddSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.AddSecretVersionRequest} AddSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AddSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.AddSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.payload = $root.google.cloud.secretmanager.v1beta2.SecretPayload.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AddSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.AddSecretVersionRequest} AddSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AddSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AddSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AddSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.payload != null && message.hasOwnProperty("payload")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.SecretPayload.verify(message.payload);
                                if (error)
                                    return "payload." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AddSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.AddSecretVersionRequest} AddSecretVersionRequest
                         */
                        AddSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.AddSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.AddSecretVersionRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.payload != null) {
                                if (typeof object.payload !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.AddSecretVersionRequest.payload: object expected");
                                message.payload = $root.google.cloud.secretmanager.v1beta2.SecretPayload.fromObject(object.payload);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AddSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.AddSecretVersionRequest} message AddSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AddSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.payload = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.payload != null && message.hasOwnProperty("payload"))
                                object.payload = $root.google.cloud.secretmanager.v1beta2.SecretPayload.toObject(message.payload, options);
                            return object;
                        };
    
                        /**
                         * Converts this AddSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AddSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AddSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.AddSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AddSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.AddSecretVersionRequest";
                        };
    
                        return AddSecretVersionRequest;
                    })();
    
                    v1beta2.GetSecretRequest = (function() {
    
                        /**
                         * Properties of a GetSecretRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IGetSecretRequest
                         * @property {string|null} [name] GetSecretRequest name
                         */
    
                        /**
                         * Constructs a new GetSecretRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a GetSecretRequest.
                         * @implements IGetSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretRequest=} [properties] Properties to set
                         */
                        function GetSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetSecretRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @instance
                         */
                        GetSecretRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretRequest} GetSecretRequest instance
                         */
                        GetSecretRequest.create = function create(properties) {
                            return new GetSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.GetSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretRequest} message GetSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.GetSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretRequest} message GetSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretRequest} GetSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.GetSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretRequest} GetSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretRequest} GetSecretRequest
                         */
                        GetSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.GetSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.GetSecretRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.GetSecretRequest} message GetSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.GetSecretRequest";
                        };
    
                        return GetSecretRequest;
                    })();
    
                    v1beta2.ListSecretVersionsRequest = (function() {
    
                        /**
                         * Properties of a ListSecretVersionsRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IListSecretVersionsRequest
                         * @property {string|null} [parent] ListSecretVersionsRequest parent
                         * @property {number|null} [pageSize] ListSecretVersionsRequest pageSize
                         * @property {string|null} [pageToken] ListSecretVersionsRequest pageToken
                         * @property {string|null} [filter] ListSecretVersionsRequest filter
                         */
    
                        /**
                         * Constructs a new ListSecretVersionsRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a ListSecretVersionsRequest.
                         * @implements IListSecretVersionsRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsRequest=} [properties] Properties to set
                         */
                        function ListSecretVersionsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretVersionsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.parent = "";
    
                        /**
                         * ListSecretVersionsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListSecretVersionsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.pageToken = "";
    
                        /**
                         * ListSecretVersionsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @instance
                         */
                        ListSecretVersionsRequest.prototype.filter = "";
    
                        /**
                         * Creates a new ListSecretVersionsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest} ListSecretVersionsRequest instance
                         */
                        ListSecretVersionsRequest.create = function create(properties) {
                            return new ListSecretVersionsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsRequest} message ListSecretVersionsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsRequest} message ListSecretVersionsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretVersionsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest} ListSecretVersionsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretVersionsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest} ListSecretVersionsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretVersionsRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretVersionsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretVersionsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest} ListSecretVersionsRequest
                         */
                        ListSecretVersionsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretVersionsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest} message ListSecretVersionsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretVersionsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretVersionsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretVersionsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretVersionsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretVersionsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest";
                        };
    
                        return ListSecretVersionsRequest;
                    })();
    
                    v1beta2.ListSecretVersionsResponse = (function() {
    
                        /**
                         * Properties of a ListSecretVersionsResponse.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IListSecretVersionsResponse
                         * @property {Array.<google.cloud.secretmanager.v1beta2.ISecretVersion>|null} [versions] ListSecretVersionsResponse versions
                         * @property {string|null} [nextPageToken] ListSecretVersionsResponse nextPageToken
                         * @property {number|null} [totalSize] ListSecretVersionsResponse totalSize
                         */
    
                        /**
                         * Constructs a new ListSecretVersionsResponse.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a ListSecretVersionsResponse.
                         * @implements IListSecretVersionsResponse
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsResponse=} [properties] Properties to set
                         */
                        function ListSecretVersionsResponse(properties) {
                            this.versions = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListSecretVersionsResponse versions.
                         * @member {Array.<google.cloud.secretmanager.v1beta2.ISecretVersion>} versions
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @instance
                         */
                        ListSecretVersionsResponse.prototype.versions = $util.emptyArray;
    
                        /**
                         * ListSecretVersionsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @instance
                         */
                        ListSecretVersionsResponse.prototype.nextPageToken = "";
    
                        /**
                         * ListSecretVersionsResponse totalSize.
                         * @member {number} totalSize
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @instance
                         */
                        ListSecretVersionsResponse.prototype.totalSize = 0;
    
                        /**
                         * Creates a new ListSecretVersionsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsResponse=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse} ListSecretVersionsResponse instance
                         */
                        ListSecretVersionsResponse.create = function create(properties) {
                            return new ListSecretVersionsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsResponse message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsResponse} message ListSecretVersionsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.versions != null && message.versions.length)
                                for (var i = 0; i < message.versions.length; ++i)
                                    $root.google.cloud.secretmanager.v1beta2.SecretVersion.encode(message.versions[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            if (message.totalSize != null && Object.hasOwnProperty.call(message, "totalSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.totalSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListSecretVersionsResponse message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IListSecretVersionsResponse} message ListSecretVersionsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListSecretVersionsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListSecretVersionsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse} ListSecretVersionsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.versions && message.versions.length))
                                            message.versions = [];
                                        message.versions.push($root.google.cloud.secretmanager.v1beta2.SecretVersion.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.totalSize = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListSecretVersionsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse} ListSecretVersionsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListSecretVersionsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListSecretVersionsResponse message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListSecretVersionsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.versions != null && message.hasOwnProperty("versions")) {
                                if (!Array.isArray(message.versions))
                                    return "versions: array expected";
                                for (var i = 0; i < message.versions.length; ++i) {
                                    var error = $root.google.cloud.secretmanager.v1beta2.SecretVersion.verify(message.versions[i]);
                                    if (error)
                                        return "versions." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                if (!$util.isInteger(message.totalSize))
                                    return "totalSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListSecretVersionsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse} ListSecretVersionsResponse
                         */
                        ListSecretVersionsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse();
                            if (object.versions) {
                                if (!Array.isArray(object.versions))
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse.versions: array expected");
                                message.versions = [];
                                for (var i = 0; i < object.versions.length; ++i) {
                                    if (typeof object.versions[i] !== "object")
                                        throw TypeError(".google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse.versions: object expected");
                                    message.versions[i] = $root.google.cloud.secretmanager.v1beta2.SecretVersion.fromObject(object.versions[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.totalSize != null)
                                message.totalSize = object.totalSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListSecretVersionsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse} message ListSecretVersionsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListSecretVersionsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.versions = [];
                            if (options.defaults) {
                                object.nextPageToken = "";
                                object.totalSize = 0;
                            }
                            if (message.versions && message.versions.length) {
                                object.versions = [];
                                for (var j = 0; j < message.versions.length; ++j)
                                    object.versions[j] = $root.google.cloud.secretmanager.v1beta2.SecretVersion.toObject(message.versions[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            if (message.totalSize != null && message.hasOwnProperty("totalSize"))
                                object.totalSize = message.totalSize;
                            return object;
                        };
    
                        /**
                         * Converts this ListSecretVersionsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListSecretVersionsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListSecretVersionsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListSecretVersionsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse";
                        };
    
                        return ListSecretVersionsResponse;
                    })();
    
                    v1beta2.GetSecretVersionRequest = (function() {
    
                        /**
                         * Properties of a GetSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IGetSecretVersionRequest
                         * @property {string|null} [name] GetSecretVersionRequest name
                         */
    
                        /**
                         * Constructs a new GetSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents a GetSecretVersionRequest.
                         * @implements IGetSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretVersionRequest=} [properties] Properties to set
                         */
                        function GetSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetSecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @instance
                         */
                        GetSecretVersionRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretVersionRequest} GetSecretVersionRequest instance
                         */
                        GetSecretVersionRequest.create = function create(properties) {
                            return new GetSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.GetSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretVersionRequest} message GetSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.GetSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IGetSecretVersionRequest} message GetSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretVersionRequest} GetSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.GetSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretVersionRequest} GetSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.GetSecretVersionRequest} GetSecretVersionRequest
                         */
                        GetSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.GetSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.GetSecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.GetSecretVersionRequest} message GetSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.GetSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.GetSecretVersionRequest";
                        };
    
                        return GetSecretVersionRequest;
                    })();
    
                    v1beta2.UpdateSecretRequest = (function() {
    
                        /**
                         * Properties of an UpdateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IUpdateSecretRequest
                         * @property {google.cloud.secretmanager.v1beta2.ISecret|null} [secret] UpdateSecretRequest secret
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateSecretRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateSecretRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents an UpdateSecretRequest.
                         * @implements IUpdateSecretRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IUpdateSecretRequest=} [properties] Properties to set
                         */
                        function UpdateSecretRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateSecretRequest secret.
                         * @member {google.cloud.secretmanager.v1beta2.ISecret|null|undefined} secret
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @instance
                         */
                        UpdateSecretRequest.prototype.secret = null;
    
                        /**
                         * UpdateSecretRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @instance
                         */
                        UpdateSecretRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateSecretRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IUpdateSecretRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.UpdateSecretRequest} UpdateSecretRequest instance
                         */
                        UpdateSecretRequest.create = function create(properties) {
                            return new UpdateSecretRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateSecretRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.UpdateSecretRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IUpdateSecretRequest} message UpdateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateSecretRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.secret != null && Object.hasOwnProperty.call(message, "secret"))
                                $root.google.cloud.secretmanager.v1beta2.Secret.encode(message.secret, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateSecretRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.UpdateSecretRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IUpdateSecretRequest} message UpdateSecretRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateSecretRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateSecretRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.UpdateSecretRequest} UpdateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateSecretRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.UpdateSecretRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.secret = $root.google.cloud.secretmanager.v1beta2.Secret.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateSecretRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.UpdateSecretRequest} UpdateSecretRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateSecretRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateSecretRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateSecretRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.secret != null && message.hasOwnProperty("secret")) {
                                var error = $root.google.cloud.secretmanager.v1beta2.Secret.verify(message.secret);
                                if (error)
                                    return "secret." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateSecretRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.UpdateSecretRequest} UpdateSecretRequest
                         */
                        UpdateSecretRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.UpdateSecretRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.UpdateSecretRequest();
                            if (object.secret != null) {
                                if (typeof object.secret !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.UpdateSecretRequest.secret: object expected");
                                message.secret = $root.google.cloud.secretmanager.v1beta2.Secret.fromObject(object.secret);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.secretmanager.v1beta2.UpdateSecretRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateSecretRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.UpdateSecretRequest} message UpdateSecretRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateSecretRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.secret = null;
                                object.updateMask = null;
                            }
                            if (message.secret != null && message.hasOwnProperty("secret"))
                                object.secret = $root.google.cloud.secretmanager.v1beta2.Secret.toObject(message.secret, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateSecretRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateSecretRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateSecretRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.UpdateSecretRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateSecretRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.UpdateSecretRequest";
                        };
    
                        return UpdateSecretRequest;
                    })();
    
                    v1beta2.AccessSecretVersionRequest = (function() {
    
                        /**
                         * Properties of an AccessSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IAccessSecretVersionRequest
                         * @property {string|null} [name] AccessSecretVersionRequest name
                         */
    
                        /**
                         * Constructs a new AccessSecretVersionRequest.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents an AccessSecretVersionRequest.
                         * @implements IAccessSecretVersionRequest
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionRequest=} [properties] Properties to set
                         */
                        function AccessSecretVersionRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AccessSecretVersionRequest name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @instance
                         */
                        AccessSecretVersionRequest.prototype.name = "";
    
                        /**
                         * Creates a new AccessSecretVersionRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionRequest=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest} AccessSecretVersionRequest instance
                         */
                        AccessSecretVersionRequest.create = function create(properties) {
                            return new AccessSecretVersionRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionRequest message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionRequest} message AccessSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionRequest message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionRequest} message AccessSecretVersionRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessSecretVersionRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest} AccessSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessSecretVersionRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest} AccessSecretVersionRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessSecretVersionRequest message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AccessSecretVersionRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AccessSecretVersionRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest} AccessSecretVersionRequest
                         */
                        AccessSecretVersionRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest)
                                return object;
                            var message = new $root.google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AccessSecretVersionRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest} message AccessSecretVersionRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AccessSecretVersionRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this AccessSecretVersionRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AccessSecretVersionRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AccessSecretVersionRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AccessSecretVersionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest";
                        };
    
                        return AccessSecretVersionRequest;
                    })();
    
                    v1beta2.AccessSecretVersionResponse = (function() {
    
                        /**
                         * Properties of an AccessSecretVersionResponse.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @interface IAccessSecretVersionResponse
                         * @property {string|null} [name] AccessSecretVersionResponse name
                         * @property {google.cloud.secretmanager.v1beta2.ISecretPayload|null} [payload] AccessSecretVersionResponse payload
                         */
    
                        /**
                         * Constructs a new AccessSecretVersionResponse.
                         * @memberof google.cloud.secretmanager.v1beta2
                         * @classdesc Represents an AccessSecretVersionResponse.
                         * @implements IAccessSecretVersionResponse
                         * @constructor
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionResponse=} [properties] Properties to set
                         */
                        function AccessSecretVersionResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AccessSecretVersionResponse name.
                         * @member {string} name
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @instance
                         */
                        AccessSecretVersionResponse.prototype.name = "";
    
                        /**
                         * AccessSecretVersionResponse payload.
                         * @member {google.cloud.secretmanager.v1beta2.ISecretPayload|null|undefined} payload
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @instance
                         */
                        AccessSecretVersionResponse.prototype.payload = null;
    
                        /**
                         * Creates a new AccessSecretVersionResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionResponse=} [properties] Properties to set
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse} AccessSecretVersionResponse instance
                         */
                        AccessSecretVersionResponse.create = function create(properties) {
                            return new AccessSecretVersionResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionResponse message. Does not implicitly {@link google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionResponse} message AccessSecretVersionResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                                $root.google.cloud.secretmanager.v1beta2.SecretPayload.encode(message.payload, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessSecretVersionResponse message, length delimited. Does not implicitly {@link google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @static
                         * @param {google.cloud.secretmanager.v1beta2.IAccessSecretVersionResponse} message AccessSecretVersionResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessSecretVersionResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessSecretVersionResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse} AccessSecretVersionResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.payload = $root.google.cloud.secretmanager.v1beta2.SecretPayload.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessSecretVersionResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse} AccessSecretVersionResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessSecretVersionResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessSecretVersionResponse message.
                         * @function verify
                         * @memberof google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse
     