// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_resource_manager_protos || ($protobuf.roots._google_cloud_resource_manager_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.cloud = (function() {
    
            /**
             * Namespace cloud.
             * @memberof google
             * @namespace
             */
            var cloud = {};
    
            cloud.resourcemanager = (function() {
    
                /**
                 * Namespace resourcemanager.
                 * @memberof google.cloud
                 * @namespace
                 */
                var resourcemanager = {};
    
                resourcemanager.v3 = (function() {
    
                    /**
                     * Namespace v3.
                     * @memberof google.cloud.resourcemanager
                     * @namespace
                     */
                    var v3 = {};
    
                    v3.Folders = (function() {
    
                        /**
                         * Constructs a new Folders service.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a Folders
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Folders(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (Folders.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Folders;
    
                        /**
                         * Creates new Folders service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Folders} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Folders.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|getFolder}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef GetFolderCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.Folder} [response] Folder
                         */
    
                        /**
                         * Calls GetFolder.
                         * @function getFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetFolderRequest} request GetFolderRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.GetFolderCallback} callback Node-style callback called with the error, if any, and Folder
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.getFolder = function getFolder(request, callback) {
                            return this.rpcCall(getFolder, $root.google.cloud.resourcemanager.v3.GetFolderRequest, $root.google.cloud.resourcemanager.v3.Folder, request, callback);
                        }, "name", { value: "GetFolder" });
    
                        /**
                         * Calls GetFolder.
                         * @function getFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetFolderRequest} request GetFolderRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.Folder>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|listFolders}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef ListFoldersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.ListFoldersResponse} [response] ListFoldersResponse
                         */
    
                        /**
                         * Calls ListFolders.
                         * @function listFolders
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListFoldersRequest} request ListFoldersRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.ListFoldersCallback} callback Node-style callback called with the error, if any, and ListFoldersResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.listFolders = function listFolders(request, callback) {
                            return this.rpcCall(listFolders, $root.google.cloud.resourcemanager.v3.ListFoldersRequest, $root.google.cloud.resourcemanager.v3.ListFoldersResponse, request, callback);
                        }, "name", { value: "ListFolders" });
    
                        /**
                         * Calls ListFolders.
                         * @function listFolders
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListFoldersRequest} request ListFoldersRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.ListFoldersResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|searchFolders}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef SearchFoldersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.SearchFoldersResponse} [response] SearchFoldersResponse
                         */
    
                        /**
                         * Calls SearchFolders.
                         * @function searchFolders
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersRequest} request SearchFoldersRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.SearchFoldersCallback} callback Node-style callback called with the error, if any, and SearchFoldersResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.searchFolders = function searchFolders(request, callback) {
                            return this.rpcCall(searchFolders, $root.google.cloud.resourcemanager.v3.SearchFoldersRequest, $root.google.cloud.resourcemanager.v3.SearchFoldersResponse, request, callback);
                        }, "name", { value: "SearchFolders" });
    
                        /**
                         * Calls SearchFolders.
                         * @function searchFolders
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersRequest} request SearchFoldersRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.SearchFoldersResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|createFolder}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef CreateFolderCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateFolder.
                         * @function createFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderRequest} request CreateFolderRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.CreateFolderCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.createFolder = function createFolder(request, callback) {
                            return this.rpcCall(createFolder, $root.google.cloud.resourcemanager.v3.CreateFolderRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateFolder" });
    
                        /**
                         * Calls CreateFolder.
                         * @function createFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderRequest} request CreateFolderRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|updateFolder}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef UpdateFolderCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateFolder.
                         * @function updateFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderRequest} request UpdateFolderRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.UpdateFolderCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.updateFolder = function updateFolder(request, callback) {
                            return this.rpcCall(updateFolder, $root.google.cloud.resourcemanager.v3.UpdateFolderRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateFolder" });
    
                        /**
                         * Calls UpdateFolder.
                         * @function updateFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderRequest} request UpdateFolderRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|moveFolder}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef MoveFolderCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls MoveFolder.
                         * @function moveFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderRequest} request MoveFolderRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.MoveFolderCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.moveFolder = function moveFolder(request, callback) {
                            return this.rpcCall(moveFolder, $root.google.cloud.resourcemanager.v3.MoveFolderRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "MoveFolder" });
    
                        /**
                         * Calls MoveFolder.
                         * @function moveFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderRequest} request MoveFolderRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|deleteFolder}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef DeleteFolderCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteFolder.
                         * @function deleteFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderRequest} request DeleteFolderRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.DeleteFolderCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.deleteFolder = function deleteFolder(request, callback) {
                            return this.rpcCall(deleteFolder, $root.google.cloud.resourcemanager.v3.DeleteFolderRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteFolder" });
    
                        /**
                         * Calls DeleteFolder.
                         * @function deleteFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderRequest} request DeleteFolderRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|undeleteFolder}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef UndeleteFolderCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UndeleteFolder.
                         * @function undeleteFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderRequest} request UndeleteFolderRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.UndeleteFolderCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.undeleteFolder = function undeleteFolder(request, callback) {
                            return this.rpcCall(undeleteFolder, $root.google.cloud.resourcemanager.v3.UndeleteFolderRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UndeleteFolder" });
    
                        /**
                         * Calls UndeleteFolder.
                         * @function undeleteFolder
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderRequest} request UndeleteFolderRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|getIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef GetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.GetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.getIamPolicy = function getIamPolicy(request, callback) {
                            return this.rpcCall(getIamPolicy, $root.google.iam.v1.GetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "GetIamPolicy" });
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|setIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef SetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.SetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.setIamPolicy = function setIamPolicy(request, callback) {
                            return this.rpcCall(setIamPolicy, $root.google.iam.v1.SetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "SetIamPolicy" });
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Folders|testIamPermissions}.
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @typedef TestIamPermissionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.TestIamPermissionsResponse} [response] TestIamPermissionsResponse
                         */
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Folders.TestIamPermissionsCallback} callback Node-style callback called with the error, if any, and TestIamPermissionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Folders.prototype.testIamPermissions = function testIamPermissions(request, callback) {
                            return this.rpcCall(testIamPermissions, $root.google.iam.v1.TestIamPermissionsRequest, $root.google.iam.v1.TestIamPermissionsResponse, request, callback);
                        }, "name", { value: "TestIamPermissions" });
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.Folders
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @returns {Promise<google.iam.v1.TestIamPermissionsResponse>} Promise
                         * @variation 2
                         */
    
                        return Folders;
                    })();
    
                    v3.Folder = (function() {
    
                        /**
                         * Properties of a Folder.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IFolder
                         * @property {string|null} [name] Folder name
                         * @property {string|null} [parent] Folder parent
                         * @property {string|null} [displayName] Folder displayName
                         * @property {google.cloud.resourcemanager.v3.Folder.State|null} [state] Folder state
                         * @property {google.protobuf.ITimestamp|null} [createTime] Folder createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] Folder updateTime
                         * @property {google.protobuf.ITimestamp|null} [deleteTime] Folder deleteTime
                         * @property {string|null} [etag] Folder etag
                         */
    
                        /**
                         * Constructs a new Folder.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a Folder.
                         * @implements IFolder
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IFolder=} [properties] Properties to set
                         */
                        function Folder(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Folder name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.name = "";
    
                        /**
                         * Folder parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.parent = "";
    
                        /**
                         * Folder displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.displayName = "";
    
                        /**
                         * Folder state.
                         * @member {google.cloud.resourcemanager.v3.Folder.State} state
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.state = 0;
    
                        /**
                         * Folder createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.createTime = null;
    
                        /**
                         * Folder updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.updateTime = null;
    
                        /**
                         * Folder deleteTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} deleteTime
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.deleteTime = null;
    
                        /**
                         * Folder etag.
                         * @member {string} etag
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         */
                        Folder.prototype.etag = "";
    
                        /**
                         * Creates a new Folder instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IFolder=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.Folder} Folder instance
                         */
                        Folder.create = function create(properties) {
                            return new Folder(properties);
                        };
    
                        /**
                         * Encodes the specified Folder message. Does not implicitly {@link google.cloud.resourcemanager.v3.Folder.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IFolder} message Folder message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Folder.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parent);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.displayName);
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.state);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.deleteTime != null && Object.hasOwnProperty.call(message, "deleteTime"))
                                $root.google.protobuf.Timestamp.encode(message.deleteTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Folder message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.Folder.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IFolder} message Folder message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Folder.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Folder message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.Folder} Folder
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Folder.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.Folder();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.deleteTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Folder message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.Folder} Folder
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Folder.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Folder message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Folder.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.deleteTime != null && message.hasOwnProperty("deleteTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.deleteTime);
                                if (error)
                                    return "deleteTime." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a Folder message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.Folder} Folder
                         */
                        Folder.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.Folder)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.Folder();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "DELETE_REQUESTED":
                            case 2:
                                message.state = 2;
                                break;
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Folder.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Folder.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.deleteTime != null) {
                                if (typeof object.deleteTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Folder.deleteTime: object expected");
                                message.deleteTime = $root.google.protobuf.Timestamp.fromObject(object.deleteTime);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Folder message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {google.cloud.resourcemanager.v3.Folder} message Folder
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Folder.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.parent = "";
                                object.displayName = "";
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.createTime = null;
                                object.updateTime = null;
                                object.deleteTime = null;
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.cloud.resourcemanager.v3.Folder.State[message.state] === undefined ? message.state : $root.google.cloud.resourcemanager.v3.Folder.State[message.state] : message.state;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.deleteTime != null && message.hasOwnProperty("deleteTime"))
                                object.deleteTime = $root.google.protobuf.Timestamp.toObject(message.deleteTime, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this Folder to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Folder.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Folder
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.Folder
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Folder.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.Folder";
                        };
    
                        /**
                         * State enum.
                         * @name google.cloud.resourcemanager.v3.Folder.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} DELETE_REQUESTED=2 DELETE_REQUESTED value
                         */
                        Folder.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "DELETE_REQUESTED"] = 2;
                            return values;
                        })();
    
                        return Folder;
                    })();
    
                    v3.GetFolderRequest = (function() {
    
                        /**
                         * Properties of a GetFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IGetFolderRequest
                         * @property {string|null} [name] GetFolderRequest name
                         */
    
                        /**
                         * Constructs a new GetFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a GetFolderRequest.
                         * @implements IGetFolderRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IGetFolderRequest=} [properties] Properties to set
                         */
                        function GetFolderRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetFolderRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @instance
                         */
                        GetFolderRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetFolderRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetFolderRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.GetFolderRequest} GetFolderRequest instance
                         */
                        GetFolderRequest.create = function create(properties) {
                            return new GetFolderRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetFolderRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.GetFolderRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetFolderRequest} message GetFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetFolderRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetFolderRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.GetFolderRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetFolderRequest} message GetFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetFolderRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetFolderRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.GetFolderRequest} GetFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetFolderRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.GetFolderRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetFolderRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.GetFolderRequest} GetFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetFolderRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetFolderRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetFolderRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetFolderRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.GetFolderRequest} GetFolderRequest
                         */
                        GetFolderRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.GetFolderRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.GetFolderRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetFolderRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.GetFolderRequest} message GetFolderRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetFolderRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetFolderRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetFolderRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetFolderRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.GetFolderRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetFolderRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.GetFolderRequest";
                        };
    
                        return GetFolderRequest;
                    })();
    
                    v3.ListFoldersRequest = (function() {
    
                        /**
                         * Properties of a ListFoldersRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListFoldersRequest
                         * @property {string|null} [parent] ListFoldersRequest parent
                         * @property {number|null} [pageSize] ListFoldersRequest pageSize
                         * @property {string|null} [pageToken] ListFoldersRequest pageToken
                         * @property {boolean|null} [showDeleted] ListFoldersRequest showDeleted
                         */
    
                        /**
                         * Constructs a new ListFoldersRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListFoldersRequest.
                         * @implements IListFoldersRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListFoldersRequest=} [properties] Properties to set
                         */
                        function ListFoldersRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListFoldersRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @instance
                         */
                        ListFoldersRequest.prototype.parent = "";
    
                        /**
                         * ListFoldersRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @instance
                         */
                        ListFoldersRequest.prototype.pageSize = 0;
    
                        /**
                         * ListFoldersRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @instance
                         */
                        ListFoldersRequest.prototype.pageToken = "";
    
                        /**
                         * ListFoldersRequest showDeleted.
                         * @member {boolean} showDeleted
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @instance
                         */
                        ListFoldersRequest.prototype.showDeleted = false;
    
                        /**
                         * Creates a new ListFoldersRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListFoldersRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersRequest} ListFoldersRequest instance
                         */
                        ListFoldersRequest.create = function create(properties) {
                            return new ListFoldersRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListFoldersRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListFoldersRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListFoldersRequest} message ListFoldersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFoldersRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.showDeleted != null && Object.hasOwnProperty.call(message, "showDeleted"))
                                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.showDeleted);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListFoldersRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListFoldersRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListFoldersRequest} message ListFoldersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFoldersRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListFoldersRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersRequest} ListFoldersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFoldersRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListFoldersRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.showDeleted = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListFoldersRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersRequest} ListFoldersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFoldersRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListFoldersRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListFoldersRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.showDeleted != null && message.hasOwnProperty("showDeleted"))
                                if (typeof message.showDeleted !== "boolean")
                                    return "showDeleted: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListFoldersRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersRequest} ListFoldersRequest
                         */
                        ListFoldersRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListFoldersRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListFoldersRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.showDeleted != null)
                                message.showDeleted = Boolean(object.showDeleted);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListFoldersRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListFoldersRequest} message ListFoldersRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListFoldersRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.showDeleted = false;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.showDeleted != null && message.hasOwnProperty("showDeleted"))
                                object.showDeleted = message.showDeleted;
                            return object;
                        };
    
                        /**
                         * Converts this ListFoldersRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListFoldersRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListFoldersRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListFoldersRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListFoldersRequest";
                        };
    
                        return ListFoldersRequest;
                    })();
    
                    v3.ListFoldersResponse = (function() {
    
                        /**
                         * Properties of a ListFoldersResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListFoldersResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.IFolder>|null} [folders] ListFoldersResponse folders
                         * @property {string|null} [nextPageToken] ListFoldersResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListFoldersResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListFoldersResponse.
                         * @implements IListFoldersResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListFoldersResponse=} [properties] Properties to set
                         */
                        function ListFoldersResponse(properties) {
                            this.folders = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListFoldersResponse folders.
                         * @member {Array.<google.cloud.resourcemanager.v3.IFolder>} folders
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @instance
                         */
                        ListFoldersResponse.prototype.folders = $util.emptyArray;
    
                        /**
                         * ListFoldersResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @instance
                         */
                        ListFoldersResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListFoldersResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListFoldersResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersResponse} ListFoldersResponse instance
                         */
                        ListFoldersResponse.create = function create(properties) {
                            return new ListFoldersResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListFoldersResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListFoldersResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListFoldersResponse} message ListFoldersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFoldersResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.folders != null && message.folders.length)
                                for (var i = 0; i < message.folders.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.Folder.encode(message.folders[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListFoldersResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListFoldersResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListFoldersResponse} message ListFoldersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFoldersResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListFoldersResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersResponse} ListFoldersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFoldersResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListFoldersResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.folders && message.folders.length))
                                            message.folders = [];
                                        message.folders.push($root.google.cloud.resourcemanager.v3.Folder.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListFoldersResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersResponse} ListFoldersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFoldersResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListFoldersResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListFoldersResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.folders != null && message.hasOwnProperty("folders")) {
                                if (!Array.isArray(message.folders))
                                    return "folders: array expected";
                                for (var i = 0; i < message.folders.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.Folder.verify(message.folders[i]);
                                    if (error)
                                        return "folders." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListFoldersResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListFoldersResponse} ListFoldersResponse
                         */
                        ListFoldersResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListFoldersResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListFoldersResponse();
                            if (object.folders) {
                                if (!Array.isArray(object.folders))
                                    throw TypeError(".google.cloud.resourcemanager.v3.ListFoldersResponse.folders: array expected");
                                message.folders = [];
                                for (var i = 0; i < object.folders.length; ++i) {
                                    if (typeof object.folders[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.ListFoldersResponse.folders: object expected");
                                    message.folders[i] = $root.google.cloud.resourcemanager.v3.Folder.fromObject(object.folders[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListFoldersResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListFoldersResponse} message ListFoldersResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListFoldersResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.folders = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.folders && message.folders.length) {
                                object.folders = [];
                                for (var j = 0; j < message.folders.length; ++j)
                                    object.folders[j] = $root.google.cloud.resourcemanager.v3.Folder.toObject(message.folders[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListFoldersResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListFoldersResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListFoldersResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListFoldersResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListFoldersResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListFoldersResponse";
                        };
    
                        return ListFoldersResponse;
                    })();
    
                    v3.SearchFoldersRequest = (function() {
    
                        /**
                         * Properties of a SearchFoldersRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ISearchFoldersRequest
                         * @property {number|null} [pageSize] SearchFoldersRequest pageSize
                         * @property {string|null} [pageToken] SearchFoldersRequest pageToken
                         * @property {string|null} [query] SearchFoldersRequest query
                         */
    
                        /**
                         * Constructs a new SearchFoldersRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a SearchFoldersRequest.
                         * @implements ISearchFoldersRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersRequest=} [properties] Properties to set
                         */
                        function SearchFoldersRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchFoldersRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @instance
                         */
                        SearchFoldersRequest.prototype.pageSize = 0;
    
                        /**
                         * SearchFoldersRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @instance
                         */
                        SearchFoldersRequest.prototype.pageToken = "";
    
                        /**
                         * SearchFoldersRequest query.
                         * @member {string} query
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @instance
                         */
                        SearchFoldersRequest.prototype.query = "";
    
                        /**
                         * Creates a new SearchFoldersRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersRequest} SearchFoldersRequest instance
                         */
                        SearchFoldersRequest.create = function create(properties) {
                            return new SearchFoldersRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SearchFoldersRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchFoldersRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersRequest} message SearchFoldersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchFoldersRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.pageToken);
                            if (message.query != null && Object.hasOwnProperty.call(message, "query"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.query);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchFoldersRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchFoldersRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersRequest} message SearchFoldersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchFoldersRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchFoldersRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersRequest} SearchFoldersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchFoldersRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.SearchFoldersRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.query = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchFoldersRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersRequest} SearchFoldersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchFoldersRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchFoldersRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchFoldersRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.query != null && message.hasOwnProperty("query"))
                                if (!$util.isString(message.query))
                                    return "query: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchFoldersRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersRequest} SearchFoldersRequest
                         */
                        SearchFoldersRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.SearchFoldersRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.SearchFoldersRequest();
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.query != null)
                                message.query = String(object.query);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchFoldersRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.SearchFoldersRequest} message SearchFoldersRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchFoldersRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.query = "";
                            }
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.query != null && message.hasOwnProperty("query"))
                                object.query = message.query;
                            return object;
                        };
    
                        /**
                         * Converts this SearchFoldersRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchFoldersRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SearchFoldersRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SearchFoldersRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.SearchFoldersRequest";
                        };
    
                        return SearchFoldersRequest;
                    })();
    
                    v3.SearchFoldersResponse = (function() {
    
                        /**
                         * Properties of a SearchFoldersResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ISearchFoldersResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.IFolder>|null} [folders] SearchFoldersResponse folders
                         * @property {string|null} [nextPageToken] SearchFoldersResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new SearchFoldersResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a SearchFoldersResponse.
                         * @implements ISearchFoldersResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersResponse=} [properties] Properties to set
                         */
                        function SearchFoldersResponse(properties) {
                            this.folders = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchFoldersResponse folders.
                         * @member {Array.<google.cloud.resourcemanager.v3.IFolder>} folders
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @instance
                         */
                        SearchFoldersResponse.prototype.folders = $util.emptyArray;
    
                        /**
                         * SearchFoldersResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @instance
                         */
                        SearchFoldersResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new SearchFoldersResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersResponse} SearchFoldersResponse instance
                         */
                        SearchFoldersResponse.create = function create(properties) {
                            return new SearchFoldersResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SearchFoldersResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchFoldersResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersResponse} message SearchFoldersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchFoldersResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.folders != null && message.folders.length)
                                for (var i = 0; i < message.folders.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.Folder.encode(message.folders[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchFoldersResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchFoldersResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchFoldersResponse} message SearchFoldersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchFoldersResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchFoldersResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersResponse} SearchFoldersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchFoldersResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.SearchFoldersResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.folders && message.folders.length))
                                            message.folders = [];
                                        message.folders.push($root.google.cloud.resourcemanager.v3.Folder.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchFoldersResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersResponse} SearchFoldersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchFoldersResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchFoldersResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchFoldersResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.folders != null && message.hasOwnProperty("folders")) {
                                if (!Array.isArray(message.folders))
                                    return "folders: array expected";
                                for (var i = 0; i < message.folders.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.Folder.verify(message.folders[i]);
                                    if (error)
                                        return "folders." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchFoldersResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.SearchFoldersResponse} SearchFoldersResponse
                         */
                        SearchFoldersResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.SearchFoldersResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.SearchFoldersResponse();
                            if (object.folders) {
                                if (!Array.isArray(object.folders))
                                    throw TypeError(".google.cloud.resourcemanager.v3.SearchFoldersResponse.folders: array expected");
                                message.folders = [];
                                for (var i = 0; i < object.folders.length; ++i) {
                                    if (typeof object.folders[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.SearchFoldersResponse.folders: object expected");
                                    message.folders[i] = $root.google.cloud.resourcemanager.v3.Folder.fromObject(object.folders[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchFoldersResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.SearchFoldersResponse} message SearchFoldersResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchFoldersResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.folders = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.folders && message.folders.length) {
                                object.folders = [];
                                for (var j = 0; j < message.folders.length; ++j)
                                    object.folders[j] = $root.google.cloud.resourcemanager.v3.Folder.toObject(message.folders[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this SearchFoldersResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchFoldersResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SearchFoldersResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.SearchFoldersResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SearchFoldersResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.SearchFoldersResponse";
                        };
    
                        return SearchFoldersResponse;
                    })();
    
                    v3.CreateFolderRequest = (function() {
    
                        /**
                         * Properties of a CreateFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateFolderRequest
                         * @property {google.cloud.resourcemanager.v3.IFolder|null} [folder] CreateFolderRequest folder
                         */
    
                        /**
                         * Constructs a new CreateFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateFolderRequest.
                         * @implements ICreateFolderRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderRequest=} [properties] Properties to set
                         */
                        function CreateFolderRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateFolderRequest folder.
                         * @member {google.cloud.resourcemanager.v3.IFolder|null|undefined} folder
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @instance
                         */
                        CreateFolderRequest.prototype.folder = null;
    
                        /**
                         * Creates a new CreateFolderRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderRequest} CreateFolderRequest instance
                         */
                        CreateFolderRequest.create = function create(properties) {
                            return new CreateFolderRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateFolderRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateFolderRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderRequest} message CreateFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFolderRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.folder != null && Object.hasOwnProperty.call(message, "folder"))
                                $root.google.cloud.resourcemanager.v3.Folder.encode(message.folder, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateFolderRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateFolderRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderRequest} message CreateFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFolderRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateFolderRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderRequest} CreateFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFolderRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateFolderRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 2: {
                                        message.folder = $root.google.cloud.resourcemanager.v3.Folder.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateFolderRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderRequest} CreateFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFolderRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateFolderRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateFolderRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.folder != null && message.hasOwnProperty("folder")) {
                                var error = $root.google.cloud.resourcemanager.v3.Folder.verify(message.folder);
                                if (error)
                                    return "folder." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateFolderRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderRequest} CreateFolderRequest
                         */
                        CreateFolderRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateFolderRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.CreateFolderRequest();
                            if (object.folder != null) {
                                if (typeof object.folder !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.CreateFolderRequest.folder: object expected");
                                message.folder = $root.google.cloud.resourcemanager.v3.Folder.fromObject(object.folder);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateFolderRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateFolderRequest} message CreateFolderRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateFolderRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.folder = null;
                            if (message.folder != null && message.hasOwnProperty("folder"))
                                object.folder = $root.google.cloud.resourcemanager.v3.Folder.toObject(message.folder, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateFolderRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateFolderRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateFolderRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateFolderRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateFolderRequest";
                        };
    
                        return CreateFolderRequest;
                    })();
    
                    v3.CreateFolderMetadata = (function() {
    
                        /**
                         * Properties of a CreateFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateFolderMetadata
                         * @property {string|null} [displayName] CreateFolderMetadata displayName
                         * @property {string|null} [parent] CreateFolderMetadata parent
                         */
    
                        /**
                         * Constructs a new CreateFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateFolderMetadata.
                         * @implements ICreateFolderMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderMetadata=} [properties] Properties to set
                         */
                        function CreateFolderMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateFolderMetadata displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @instance
                         */
                        CreateFolderMetadata.prototype.displayName = "";
    
                        /**
                         * CreateFolderMetadata parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @instance
                         */
                        CreateFolderMetadata.prototype.parent = "";
    
                        /**
                         * Creates a new CreateFolderMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderMetadata} CreateFolderMetadata instance
                         */
                        CreateFolderMetadata.create = function create(properties) {
                            return new CreateFolderMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CreateFolderMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateFolderMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderMetadata} message CreateFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFolderMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateFolderMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateFolderMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateFolderMetadata} message CreateFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFolderMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateFolderMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderMetadata} CreateFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFolderMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateFolderMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateFolderMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderMetadata} CreateFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFolderMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateFolderMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateFolderMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CreateFolderMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateFolderMetadata} CreateFolderMetadata
                         */
                        CreateFolderMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateFolderMetadata)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.CreateFolderMetadata();
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateFolderMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateFolderMetadata} message CreateFolderMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateFolderMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.displayName = "";
                                object.parent = "";
                            }
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            return object;
                        };
    
                        /**
                         * Converts this CreateFolderMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateFolderMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateFolderMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateFolderMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateFolderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateFolderMetadata";
                        };
    
                        return CreateFolderMetadata;
                    })();
    
                    v3.UpdateFolderRequest = (function() {
    
                        /**
                         * Properties of an UpdateFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUpdateFolderRequest
                         * @property {google.cloud.resourcemanager.v3.IFolder|null} [folder] UpdateFolderRequest folder
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateFolderRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UpdateFolderRequest.
                         * @implements IUpdateFolderRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderRequest=} [properties] Properties to set
                         */
                        function UpdateFolderRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateFolderRequest folder.
                         * @member {google.cloud.resourcemanager.v3.IFolder|null|undefined} folder
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @instance
                         */
                        UpdateFolderRequest.prototype.folder = null;
    
                        /**
                         * UpdateFolderRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @instance
                         */
                        UpdateFolderRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateFolderRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderRequest} UpdateFolderRequest instance
                         */
                        UpdateFolderRequest.create = function create(properties) {
                            return new UpdateFolderRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateFolderRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateFolderRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderRequest} message UpdateFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateFolderRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.folder != null && Object.hasOwnProperty.call(message, "folder"))
                                $root.google.cloud.resourcemanager.v3.Folder.encode(message.folder, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateFolderRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateFolderRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderRequest} message UpdateFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateFolderRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateFolderRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderRequest} UpdateFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateFolderRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UpdateFolderRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.folder = $root.google.cloud.resourcemanager.v3.Folder.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateFolderRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderRequest} UpdateFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateFolderRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateFolderRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateFolderRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.folder != null && message.hasOwnProperty("folder")) {
                                var error = $root.google.cloud.resourcemanager.v3.Folder.verify(message.folder);
                                if (error)
                                    return "folder." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateFolderRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderRequest} UpdateFolderRequest
                         */
                        UpdateFolderRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UpdateFolderRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.UpdateFolderRequest();
                            if (object.folder != null) {
                                if (typeof object.folder !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.UpdateFolderRequest.folder: object expected");
                                message.folder = $root.google.cloud.resourcemanager.v3.Folder.fromObject(object.folder);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.UpdateFolderRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateFolderRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UpdateFolderRequest} message UpdateFolderRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateFolderRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.folder = null;
                                object.updateMask = null;
                            }
                            if (message.folder != null && message.hasOwnProperty("folder"))
                                object.folder = $root.google.cloud.resourcemanager.v3.Folder.toObject(message.folder, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateFolderRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateFolderRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateFolderRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateFolderRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UpdateFolderRequest";
                        };
    
                        return UpdateFolderRequest;
                    })();
    
                    v3.UpdateFolderMetadata = (function() {
    
                        /**
                         * Properties of an UpdateFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUpdateFolderMetadata
                         */
    
                        /**
                         * Constructs a new UpdateFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UpdateFolderMetadata.
                         * @implements IUpdateFolderMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderMetadata=} [properties] Properties to set
                         */
                        function UpdateFolderMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new UpdateFolderMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderMetadata} UpdateFolderMetadata instance
                         */
                        UpdateFolderMetadata.create = function create(properties) {
                            return new UpdateFolderMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateFolderMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateFolderMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderMetadata} message UpdateFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateFolderMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateFolderMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateFolderMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateFolderMetadata} message UpdateFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateFolderMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateFolderMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderMetadata} UpdateFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateFolderMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UpdateFolderMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateFolderMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderMetadata} UpdateFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateFolderMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateFolderMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateFolderMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an UpdateFolderMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UpdateFolderMetadata} UpdateFolderMetadata
                         */
                        UpdateFolderMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UpdateFolderMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.UpdateFolderMetadata();
                        };
    
                        /**
                         * Creates a plain object from an UpdateFolderMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UpdateFolderMetadata} message UpdateFolderMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateFolderMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this UpdateFolderMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateFolderMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateFolderMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UpdateFolderMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateFolderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UpdateFolderMetadata";
                        };
    
                        return UpdateFolderMetadata;
                    })();
    
                    v3.MoveFolderRequest = (function() {
    
                        /**
                         * Properties of a MoveFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IMoveFolderRequest
                         * @property {string|null} [name] MoveFolderRequest name
                         * @property {string|null} [destinationParent] MoveFolderRequest destinationParent
                         */
    
                        /**
                         * Constructs a new MoveFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a MoveFolderRequest.
                         * @implements IMoveFolderRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderRequest=} [properties] Properties to set
                         */
                        function MoveFolderRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * MoveFolderRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @instance
                         */
                        MoveFolderRequest.prototype.name = "";
    
                        /**
                         * MoveFolderRequest destinationParent.
                         * @member {string} destinationParent
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @instance
                         */
                        MoveFolderRequest.prototype.destinationParent = "";
    
                        /**
                         * Creates a new MoveFolderRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderRequest} MoveFolderRequest instance
                         */
                        MoveFolderRequest.create = function create(properties) {
                            return new MoveFolderRequest(properties);
                        };
    
                        /**
                         * Encodes the specified MoveFolderRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveFolderRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderRequest} message MoveFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveFolderRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.destinationParent != null && Object.hasOwnProperty.call(message, "destinationParent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.destinationParent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified MoveFolderRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveFolderRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderRequest} message MoveFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveFolderRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a MoveFolderRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderRequest} MoveFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveFolderRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.MoveFolderRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.destinationParent = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a MoveFolderRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderRequest} MoveFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveFolderRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a MoveFolderRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        MoveFolderRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.destinationParent != null && message.hasOwnProperty("destinationParent"))
                                if (!$util.isString(message.destinationParent))
                                    return "destinationParent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a MoveFolderRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderRequest} MoveFolderRequest
                         */
                        MoveFolderRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.MoveFolderRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.MoveFolderRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.destinationParent != null)
                                message.destinationParent = String(object.destinationParent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a MoveFolderRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.MoveFolderRequest} message MoveFolderRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        MoveFolderRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.destinationParent = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.destinationParent != null && message.hasOwnProperty("destinationParent"))
                                object.destinationParent = message.destinationParent;
                            return object;
                        };
    
                        /**
                         * Converts this MoveFolderRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        MoveFolderRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for MoveFolderRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        MoveFolderRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.MoveFolderRequest";
                        };
    
                        return MoveFolderRequest;
                    })();
    
                    v3.MoveFolderMetadata = (function() {
    
                        /**
                         * Properties of a MoveFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IMoveFolderMetadata
                         * @property {string|null} [displayName] MoveFolderMetadata displayName
                         * @property {string|null} [sourceParent] MoveFolderMetadata sourceParent
                         * @property {string|null} [destinationParent] MoveFolderMetadata destinationParent
                         */
    
                        /**
                         * Constructs a new MoveFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a MoveFolderMetadata.
                         * @implements IMoveFolderMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderMetadata=} [properties] Properties to set
                         */
                        function MoveFolderMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * MoveFolderMetadata displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @instance
                         */
                        MoveFolderMetadata.prototype.displayName = "";
    
                        /**
                         * MoveFolderMetadata sourceParent.
                         * @member {string} sourceParent
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @instance
                         */
                        MoveFolderMetadata.prototype.sourceParent = "";
    
                        /**
                         * MoveFolderMetadata destinationParent.
                         * @member {string} destinationParent
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @instance
                         */
                        MoveFolderMetadata.prototype.destinationParent = "";
    
                        /**
                         * Creates a new MoveFolderMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderMetadata} MoveFolderMetadata instance
                         */
                        MoveFolderMetadata.create = function create(properties) {
                            return new MoveFolderMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified MoveFolderMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveFolderMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderMetadata} message MoveFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveFolderMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
                            if (message.sourceParent != null && Object.hasOwnProperty.call(message, "sourceParent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.sourceParent);
                            if (message.destinationParent != null && Object.hasOwnProperty.call(message, "destinationParent"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.destinationParent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified MoveFolderMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveFolderMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveFolderMetadata} message MoveFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveFolderMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a MoveFolderMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderMetadata} MoveFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveFolderMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.MoveFolderMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.sourceParent = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.destinationParent = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a MoveFolderMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderMetadata} MoveFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveFolderMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a MoveFolderMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        MoveFolderMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.sourceParent != null && message.hasOwnProperty("sourceParent"))
                                if (!$util.isString(message.sourceParent))
                                    return "sourceParent: string expected";
                            if (message.destinationParent != null && message.hasOwnProperty("destinationParent"))
                                if (!$util.isString(message.destinationParent))
                                    return "destinationParent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a MoveFolderMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.MoveFolderMetadata} MoveFolderMetadata
                         */
                        MoveFolderMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.MoveFolderMetadata)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.MoveFolderMetadata();
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.sourceParent != null)
                                message.sourceParent = String(object.sourceParent);
                            if (object.destinationParent != null)
                                message.destinationParent = String(object.destinationParent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a MoveFolderMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.MoveFolderMetadata} message MoveFolderMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        MoveFolderMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.displayName = "";
                                object.sourceParent = "";
                                object.destinationParent = "";
                            }
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.sourceParent != null && message.hasOwnProperty("sourceParent"))
                                object.sourceParent = message.sourceParent;
                            if (message.destinationParent != null && message.hasOwnProperty("destinationParent"))
                                object.destinationParent = message.destinationParent;
                            return object;
                        };
    
                        /**
                         * Converts this MoveFolderMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        MoveFolderMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for MoveFolderMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.MoveFolderMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        MoveFolderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.MoveFolderMetadata";
                        };
    
                        return MoveFolderMetadata;
                    })();
    
                    v3.DeleteFolderRequest = (function() {
    
                        /**
                         * Properties of a DeleteFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteFolderRequest
                         * @property {string|null} [name] DeleteFolderRequest name
                         */
    
                        /**
                         * Constructs a new DeleteFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteFolderRequest.
                         * @implements IDeleteFolderRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderRequest=} [properties] Properties to set
                         */
                        function DeleteFolderRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteFolderRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @instance
                         */
                        DeleteFolderRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteFolderRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderRequest} DeleteFolderRequest instance
                         */
                        DeleteFolderRequest.create = function create(properties) {
                            return new DeleteFolderRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteFolderRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteFolderRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderRequest} message DeleteFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFolderRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteFolderRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteFolderRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderRequest} message DeleteFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFolderRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteFolderRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderRequest} DeleteFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFolderRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteFolderRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteFolderRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderRequest} DeleteFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFolderRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteFolderRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteFolderRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteFolderRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderRequest} DeleteFolderRequest
                         */
                        DeleteFolderRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteFolderRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.DeleteFolderRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteFolderRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteFolderRequest} message DeleteFolderRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteFolderRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteFolderRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteFolderRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteFolderRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteFolderRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteFolderRequest";
                        };
    
                        return DeleteFolderRequest;
                    })();
    
                    v3.DeleteFolderMetadata = (function() {
    
                        /**
                         * Properties of a DeleteFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteFolderMetadata
                         */
    
                        /**
                         * Constructs a new DeleteFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteFolderMetadata.
                         * @implements IDeleteFolderMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderMetadata=} [properties] Properties to set
                         */
                        function DeleteFolderMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new DeleteFolderMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderMetadata} DeleteFolderMetadata instance
                         */
                        DeleteFolderMetadata.create = function create(properties) {
                            return new DeleteFolderMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteFolderMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteFolderMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderMetadata} message DeleteFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFolderMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteFolderMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteFolderMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteFolderMetadata} message DeleteFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFolderMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteFolderMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderMetadata} DeleteFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFolderMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteFolderMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteFolderMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderMetadata} DeleteFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFolderMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteFolderMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteFolderMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteFolderMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteFolderMetadata} DeleteFolderMetadata
                         */
                        DeleteFolderMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteFolderMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.DeleteFolderMetadata();
                        };
    
                        /**
                         * Creates a plain object from a DeleteFolderMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteFolderMetadata} message DeleteFolderMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteFolderMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this DeleteFolderMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteFolderMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteFolderMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteFolderMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteFolderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteFolderMetadata";
                        };
    
                        return DeleteFolderMetadata;
                    })();
    
                    v3.UndeleteFolderRequest = (function() {
    
                        /**
                         * Properties of an UndeleteFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUndeleteFolderRequest
                         * @property {string|null} [name] UndeleteFolderRequest name
                         */
    
                        /**
                         * Constructs a new UndeleteFolderRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UndeleteFolderRequest.
                         * @implements IUndeleteFolderRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderRequest=} [properties] Properties to set
                         */
                        function UndeleteFolderRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UndeleteFolderRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @instance
                         */
                        UndeleteFolderRequest.prototype.name = "";
    
                        /**
                         * Creates a new UndeleteFolderRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderRequest} UndeleteFolderRequest instance
                         */
                        UndeleteFolderRequest.create = function create(properties) {
                            return new UndeleteFolderRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UndeleteFolderRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteFolderRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderRequest} message UndeleteFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteFolderRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UndeleteFolderRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteFolderRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderRequest} message UndeleteFolderRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteFolderRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UndeleteFolderRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderRequest} UndeleteFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteFolderRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UndeleteFolderRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UndeleteFolderRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderRequest} UndeleteFolderRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteFolderRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UndeleteFolderRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UndeleteFolderRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an UndeleteFolderRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderRequest} UndeleteFolderRequest
                         */
                        UndeleteFolderRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UndeleteFolderRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.UndeleteFolderRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UndeleteFolderRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UndeleteFolderRequest} message UndeleteFolderRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UndeleteFolderRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this UndeleteFolderRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UndeleteFolderRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UndeleteFolderRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UndeleteFolderRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UndeleteFolderRequest";
                        };
    
                        return UndeleteFolderRequest;
                    })();
    
                    v3.UndeleteFolderMetadata = (function() {
    
                        /**
                         * Properties of an UndeleteFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUndeleteFolderMetadata
                         */
    
                        /**
                         * Constructs a new UndeleteFolderMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UndeleteFolderMetadata.
                         * @implements IUndeleteFolderMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderMetadata=} [properties] Properties to set
                         */
                        function UndeleteFolderMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new UndeleteFolderMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderMetadata} UndeleteFolderMetadata instance
                         */
                        UndeleteFolderMetadata.create = function create(properties) {
                            return new UndeleteFolderMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified UndeleteFolderMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteFolderMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderMetadata} message UndeleteFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteFolderMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UndeleteFolderMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteFolderMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteFolderMetadata} message UndeleteFolderMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteFolderMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UndeleteFolderMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderMetadata} UndeleteFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteFolderMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UndeleteFolderMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UndeleteFolderMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderMetadata} UndeleteFolderMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteFolderMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UndeleteFolderMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UndeleteFolderMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an UndeleteFolderMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UndeleteFolderMetadata} UndeleteFolderMetadata
                         */
                        UndeleteFolderMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UndeleteFolderMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.UndeleteFolderMetadata();
                        };
    
                        /**
                         * Creates a plain object from an UndeleteFolderMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UndeleteFolderMetadata} message UndeleteFolderMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UndeleteFolderMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this UndeleteFolderMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UndeleteFolderMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UndeleteFolderMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UndeleteFolderMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UndeleteFolderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UndeleteFolderMetadata";
                        };
    
                        return UndeleteFolderMetadata;
                    })();
    
                    v3.Organizations = (function() {
    
                        /**
                         * Constructs a new Organizations service.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an Organizations
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Organizations(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (Organizations.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Organizations;
    
                        /**
                         * Creates new Organizations service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Organizations} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Organizations.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Organizations|getOrganization}.
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @typedef GetOrganizationCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.Organization} [response] Organization
                         */
    
                        /**
                         * Calls GetOrganization.
                         * @function getOrganization
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetOrganizationRequest} request GetOrganizationRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Organizations.GetOrganizationCallback} callback Node-style callback called with the error, if any, and Organization
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Organizations.prototype.getOrganization = function getOrganization(request, callback) {
                            return this.rpcCall(getOrganization, $root.google.cloud.resourcemanager.v3.GetOrganizationRequest, $root.google.cloud.resourcemanager.v3.Organization, request, callback);
                        }, "name", { value: "GetOrganization" });
    
                        /**
                         * Calls GetOrganization.
                         * @function getOrganization
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetOrganizationRequest} request GetOrganizationRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.Organization>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Organizations|searchOrganizations}.
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @typedef SearchOrganizationsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.SearchOrganizationsResponse} [response] SearchOrganizationsResponse
                         */
    
                        /**
                         * Calls SearchOrganizations.
                         * @function searchOrganizations
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsRequest} request SearchOrganizationsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Organizations.SearchOrganizationsCallback} callback Node-style callback called with the error, if any, and SearchOrganizationsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Organizations.prototype.searchOrganizations = function searchOrganizations(request, callback) {
                            return this.rpcCall(searchOrganizations, $root.google.cloud.resourcemanager.v3.SearchOrganizationsRequest, $root.google.cloud.resourcemanager.v3.SearchOrganizationsResponse, request, callback);
                        }, "name", { value: "SearchOrganizations" });
    
                        /**
                         * Calls SearchOrganizations.
                         * @function searchOrganizations
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsRequest} request SearchOrganizationsRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.SearchOrganizationsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Organizations|getIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @typedef GetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Organizations.GetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Organizations.prototype.getIamPolicy = function getIamPolicy(request, callback) {
                            return this.rpcCall(getIamPolicy, $root.google.iam.v1.GetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "GetIamPolicy" });
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Organizations|setIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @typedef SetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Organizations.SetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Organizations.prototype.setIamPolicy = function setIamPolicy(request, callback) {
                            return this.rpcCall(setIamPolicy, $root.google.iam.v1.SetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "SetIamPolicy" });
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Organizations|testIamPermissions}.
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @typedef TestIamPermissionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.TestIamPermissionsResponse} [response] TestIamPermissionsResponse
                         */
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Organizations.TestIamPermissionsCallback} callback Node-style callback called with the error, if any, and TestIamPermissionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Organizations.prototype.testIamPermissions = function testIamPermissions(request, callback) {
                            return this.rpcCall(testIamPermissions, $root.google.iam.v1.TestIamPermissionsRequest, $root.google.iam.v1.TestIamPermissionsResponse, request, callback);
                        }, "name", { value: "TestIamPermissions" });
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.Organizations
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @returns {Promise<google.iam.v1.TestIamPermissionsResponse>} Promise
                         * @variation 2
                         */
    
                        return Organizations;
                    })();
    
                    v3.Organization = (function() {
    
                        /**
                         * Properties of an Organization.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IOrganization
                         * @property {string|null} [name] Organization name
                         * @property {string|null} [displayName] Organization displayName
                         * @property {string|null} [directoryCustomerId] Organization directoryCustomerId
                         * @property {google.cloud.resourcemanager.v3.Organization.State|null} [state] Organization state
                         * @property {google.protobuf.ITimestamp|null} [createTime] Organization createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] Organization updateTime
                         * @property {google.protobuf.ITimestamp|null} [deleteTime] Organization deleteTime
                         * @property {string|null} [etag] Organization etag
                         */
    
                        /**
                         * Constructs a new Organization.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an Organization.
                         * @implements IOrganization
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IOrganization=} [properties] Properties to set
                         */
                        function Organization(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Organization name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.name = "";
    
                        /**
                         * Organization displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.displayName = "";
    
                        /**
                         * Organization directoryCustomerId.
                         * @member {string|null|undefined} directoryCustomerId
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.directoryCustomerId = null;
    
                        /**
                         * Organization state.
                         * @member {google.cloud.resourcemanager.v3.Organization.State} state
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.state = 0;
    
                        /**
                         * Organization createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.createTime = null;
    
                        /**
                         * Organization updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.updateTime = null;
    
                        /**
                         * Organization deleteTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} deleteTime
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.deleteTime = null;
    
                        /**
                         * Organization etag.
                         * @member {string} etag
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Organization.prototype.etag = "";
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Organization owner.
                         * @member {"directoryCustomerId"|undefined} owner
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         */
                        Object.defineProperty(Organization.prototype, "owner", {
                            get: $util.oneOfGetter($oneOfFields = ["directoryCustomerId"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Organization instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IOrganization=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.Organization} Organization instance
                         */
                        Organization.create = function create(properties) {
                            return new Organization(properties);
                        };
    
                        /**
                         * Encodes the specified Organization message. Does not implicitly {@link google.cloud.resourcemanager.v3.Organization.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IOrganization} message Organization message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Organization.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.displayName);
                            if (message.directoryCustomerId != null && Object.hasOwnProperty.call(message, "directoryCustomerId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.directoryCustomerId);
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.state);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.deleteTime != null && Object.hasOwnProperty.call(message, "deleteTime"))
                                $root.google.protobuf.Timestamp.encode(message.deleteTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Organization message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.Organization.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IOrganization} message Organization message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Organization.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an Organization message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.Organization} Organization
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Organization.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.Organization();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.directoryCustomerId = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.deleteTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an Organization message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.Organization} Organization
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Organization.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an Organization message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Organization.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.directoryCustomerId != null && message.hasOwnProperty("directoryCustomerId")) {
                                properties.owner = 1;
                                if (!$util.isString(message.directoryCustomerId))
                                    return "directoryCustomerId: string expected";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.deleteTime != null && message.hasOwnProperty("deleteTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.deleteTime);
                                if (error)
                                    return "deleteTime." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an Organization message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.Organization} Organization
                         */
                        Organization.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.Organization)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.Organization();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.directoryCustomerId != null)
                                message.directoryCustomerId = String(object.directoryCustomerId);
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "DELETE_REQUESTED":
                            case 2:
                                message.state = 2;
                                break;
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Organization.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Organization.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.deleteTime != null) {
                                if (typeof object.deleteTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Organization.deleteTime: object expected");
                                message.deleteTime = $root.google.protobuf.Timestamp.fromObject(object.deleteTime);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an Organization message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {google.cloud.resourcemanager.v3.Organization} message Organization
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Organization.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.displayName = "";
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.createTime = null;
                                object.updateTime = null;
                                object.deleteTime = null;
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.directoryCustomerId != null && message.hasOwnProperty("directoryCustomerId")) {
                                object.directoryCustomerId = message.directoryCustomerId;
                                if (options.oneofs)
                                    object.owner = "directoryCustomerId";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.cloud.resourcemanager.v3.Organization.State[message.state] === undefined ? message.state : $root.google.cloud.resourcemanager.v3.Organization.State[message.state] : message.state;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.deleteTime != null && message.hasOwnProperty("deleteTime"))
                                object.deleteTime = $root.google.protobuf.Timestamp.toObject(message.deleteTime, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this Organization to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Organization.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Organization
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.Organization
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Organization.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.Organization";
                        };
    
                        /**
                         * State enum.
                         * @name google.cloud.resourcemanager.v3.Organization.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} DELETE_REQUESTED=2 DELETE_REQUESTED value
                         */
                        Organization.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "DELETE_REQUESTED"] = 2;
                            return values;
                        })();
    
                        return Organization;
                    })();
    
                    v3.GetOrganizationRequest = (function() {
    
                        /**
                         * Properties of a GetOrganizationRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IGetOrganizationRequest
                         * @property {string|null} [name] GetOrganizationRequest name
                         */
    
                        /**
                         * Constructs a new GetOrganizationRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a GetOrganizationRequest.
                         * @implements IGetOrganizationRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IGetOrganizationRequest=} [properties] Properties to set
                         */
                        function GetOrganizationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetOrganizationRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @instance
                         */
                        GetOrganizationRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetOrganizationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetOrganizationRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.GetOrganizationRequest} GetOrganizationRequest instance
                         */
                        GetOrganizationRequest.create = function create(properties) {
                            return new GetOrganizationRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetOrganizationRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.GetOrganizationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetOrganizationRequest} message GetOrganizationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetOrganizationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetOrganizationRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.GetOrganizationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetOrganizationRequest} message GetOrganizationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetOrganizationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetOrganizationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.GetOrganizationRequest} GetOrganizationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetOrganizationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.GetOrganizationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetOrganizationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.GetOrganizationRequest} GetOrganizationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetOrganizationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetOrganizationRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetOrganizationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetOrganizationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.GetOrganizationRequest} GetOrganizationRequest
                         */
                        GetOrganizationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.GetOrganizationRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.GetOrganizationRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetOrganizationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.GetOrganizationRequest} message GetOrganizationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetOrganizationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetOrganizationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetOrganizationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetOrganizationRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.GetOrganizationRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetOrganizationRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.GetOrganizationRequest";
                        };
    
                        return GetOrganizationRequest;
                    })();
    
                    v3.SearchOrganizationsRequest = (function() {
    
                        /**
                         * Properties of a SearchOrganizationsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ISearchOrganizationsRequest
                         * @property {number|null} [pageSize] SearchOrganizationsRequest pageSize
                         * @property {string|null} [pageToken] SearchOrganizationsRequest pageToken
                         * @property {string|null} [query] SearchOrganizationsRequest query
                         */
    
                        /**
                         * Constructs a new SearchOrganizationsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a SearchOrganizationsRequest.
                         * @implements ISearchOrganizationsRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsRequest=} [properties] Properties to set
                         */
                        function SearchOrganizationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchOrganizationsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @instance
                         */
                        SearchOrganizationsRequest.prototype.pageSize = 0;
    
                        /**
                         * SearchOrganizationsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @instance
                         */
                        SearchOrganizationsRequest.prototype.pageToken = "";
    
                        /**
                         * SearchOrganizationsRequest query.
                         * @member {string} query
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @instance
                         */
                        SearchOrganizationsRequest.prototype.query = "";
    
                        /**
                         * Creates a new SearchOrganizationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsRequest} SearchOrganizationsRequest instance
                         */
                        SearchOrganizationsRequest.create = function create(properties) {
                            return new SearchOrganizationsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SearchOrganizationsRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchOrganizationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsRequest} message SearchOrganizationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchOrganizationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.pageToken);
                            if (message.query != null && Object.hasOwnProperty.call(message, "query"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.query);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchOrganizationsRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchOrganizationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsRequest} message SearchOrganizationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchOrganizationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchOrganizationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsRequest} SearchOrganizationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchOrganizationsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.SearchOrganizationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.query = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchOrganizationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsRequest} SearchOrganizationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchOrganizationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchOrganizationsRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchOrganizationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.query != null && message.hasOwnProperty("query"))
                                if (!$util.isString(message.query))
                                    return "query: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchOrganizationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsRequest} SearchOrganizationsRequest
                         */
                        SearchOrganizationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.SearchOrganizationsRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.SearchOrganizationsRequest();
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.query != null)
                                message.query = String(object.query);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchOrganizationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.SearchOrganizationsRequest} message SearchOrganizationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchOrganizationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.query = "";
                            }
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.query != null && message.hasOwnProperty("query"))
                                object.query = message.query;
                            return object;
                        };
    
                        /**
                         * Converts this SearchOrganizationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchOrganizationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SearchOrganizationsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SearchOrganizationsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.SearchOrganizationsRequest";
                        };
    
                        return SearchOrganizationsRequest;
                    })();
    
                    v3.SearchOrganizationsResponse = (function() {
    
                        /**
                         * Properties of a SearchOrganizationsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ISearchOrganizationsResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.IOrganization>|null} [organizations] SearchOrganizationsResponse organizations
                         * @property {string|null} [nextPageToken] SearchOrganizationsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new SearchOrganizationsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a SearchOrganizationsResponse.
                         * @implements ISearchOrganizationsResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsResponse=} [properties] Properties to set
                         */
                        function SearchOrganizationsResponse(properties) {
                            this.organizations = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchOrganizationsResponse organizations.
                         * @member {Array.<google.cloud.resourcemanager.v3.IOrganization>} organizations
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @instance
                         */
                        SearchOrganizationsResponse.prototype.organizations = $util.emptyArray;
    
                        /**
                         * SearchOrganizationsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @instance
                         */
                        SearchOrganizationsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new SearchOrganizationsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsResponse} SearchOrganizationsResponse instance
                         */
                        SearchOrganizationsResponse.create = function create(properties) {
                            return new SearchOrganizationsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SearchOrganizationsResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchOrganizationsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsResponse} message SearchOrganizationsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchOrganizationsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.organizations != null && message.organizations.length)
                                for (var i = 0; i < message.organizations.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.Organization.encode(message.organizations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchOrganizationsResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchOrganizationsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchOrganizationsResponse} message SearchOrganizationsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchOrganizationsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchOrganizationsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsResponse} SearchOrganizationsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchOrganizationsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.SearchOrganizationsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.organizations && message.organizations.length))
                                            message.organizations = [];
                                        message.organizations.push($root.google.cloud.resourcemanager.v3.Organization.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchOrganizationsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsResponse} SearchOrganizationsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchOrganizationsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchOrganizationsResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchOrganizationsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.organizations != null && message.hasOwnProperty("organizations")) {
                                if (!Array.isArray(message.organizations))
                                    return "organizations: array expected";
                                for (var i = 0; i < message.organizations.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.Organization.verify(message.organizations[i]);
                                    if (error)
                                        return "organizations." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchOrganizationsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.SearchOrganizationsResponse} SearchOrganizationsResponse
                         */
                        SearchOrganizationsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.SearchOrganizationsResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.SearchOrganizationsResponse();
                            if (object.organizations) {
                                if (!Array.isArray(object.organizations))
                                    throw TypeError(".google.cloud.resourcemanager.v3.SearchOrganizationsResponse.organizations: array expected");
                                message.organizations = [];
                                for (var i = 0; i < object.organizations.length; ++i) {
                                    if (typeof object.organizations[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.SearchOrganizationsResponse.organizations: object expected");
                                    message.organizations[i] = $root.google.cloud.resourcemanager.v3.Organization.fromObject(object.organizations[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchOrganizationsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.SearchOrganizationsResponse} message SearchOrganizationsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchOrganizationsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.organizations = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.organizations && message.organizations.length) {
                                object.organizations = [];
                                for (var j = 0; j < message.organizations.length; ++j)
                                    object.organizations[j] = $root.google.cloud.resourcemanager.v3.Organization.toObject(message.organizations[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this SearchOrganizationsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchOrganizationsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SearchOrganizationsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.SearchOrganizationsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SearchOrganizationsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.SearchOrganizationsResponse";
                        };
    
                        return SearchOrganizationsResponse;
                    })();
    
                    v3.DeleteOrganizationMetadata = (function() {
    
                        /**
                         * Properties of a DeleteOrganizationMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteOrganizationMetadata
                         */
    
                        /**
                         * Constructs a new DeleteOrganizationMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteOrganizationMetadata.
                         * @implements IDeleteOrganizationMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteOrganizationMetadata=} [properties] Properties to set
                         */
                        function DeleteOrganizationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new DeleteOrganizationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteOrganizationMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteOrganizationMetadata} DeleteOrganizationMetadata instance
                         */
                        DeleteOrganizationMetadata.create = function create(properties) {
                            return new DeleteOrganizationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteOrganizationMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteOrganizationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteOrganizationMetadata} message DeleteOrganizationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteOrganizationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteOrganizationMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteOrganizationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteOrganizationMetadata} message DeleteOrganizationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteOrganizationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteOrganizationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteOrganizationMetadata} DeleteOrganizationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteOrganizationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteOrganizationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteOrganizationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteOrganizationMetadata} DeleteOrganizationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteOrganizationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteOrganizationMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteOrganizationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteOrganizationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteOrganizationMetadata} DeleteOrganizationMetadata
                         */
                        DeleteOrganizationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteOrganizationMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.DeleteOrganizationMetadata();
                        };
    
                        /**
                         * Creates a plain object from a DeleteOrganizationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteOrganizationMetadata} message DeleteOrganizationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteOrganizationMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this DeleteOrganizationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteOrganizationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteOrganizationMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteOrganizationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteOrganizationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteOrganizationMetadata";
                        };
    
                        return DeleteOrganizationMetadata;
                    })();
    
                    v3.UndeleteOrganizationMetadata = (function() {
    
                        /**
                         * Properties of an UndeleteOrganizationMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUndeleteOrganizationMetadata
                         */
    
                        /**
                         * Constructs a new UndeleteOrganizationMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UndeleteOrganizationMetadata.
                         * @implements IUndeleteOrganizationMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUndeleteOrganizationMetadata=} [properties] Properties to set
                         */
                        function UndeleteOrganizationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new UndeleteOrganizationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteOrganizationMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata} UndeleteOrganizationMetadata instance
                         */
                        UndeleteOrganizationMetadata.create = function create(properties) {
                            return new UndeleteOrganizationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified UndeleteOrganizationMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteOrganizationMetadata} message UndeleteOrganizationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteOrganizationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UndeleteOrganizationMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteOrganizationMetadata} message UndeleteOrganizationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteOrganizationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UndeleteOrganizationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata} UndeleteOrganizationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteOrganizationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UndeleteOrganizationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata} UndeleteOrganizationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteOrganizationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UndeleteOrganizationMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UndeleteOrganizationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an UndeleteOrganizationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata} UndeleteOrganizationMetadata
                         */
                        UndeleteOrganizationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata();
                        };
    
                        /**
                         * Creates a plain object from an UndeleteOrganizationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata} message UndeleteOrganizationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UndeleteOrganizationMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this UndeleteOrganizationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UndeleteOrganizationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UndeleteOrganizationMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UndeleteOrganizationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UndeleteOrganizationMetadata";
                        };
    
                        return UndeleteOrganizationMetadata;
                    })();
    
                    v3.Projects = (function() {
    
                        /**
                         * Constructs a new Projects service.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a Projects
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Projects(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (Projects.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Projects;
    
                        /**
                         * Creates new Projects service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Projects} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Projects.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|getProject}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef GetProjectCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.Project} [response] Project
                         */
    
                        /**
                         * Calls GetProject.
                         * @function getProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetProjectRequest} request GetProjectRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.GetProjectCallback} callback Node-style callback called with the error, if any, and Project
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.getProject = function getProject(request, callback) {
                            return this.rpcCall(getProject, $root.google.cloud.resourcemanager.v3.GetProjectRequest, $root.google.cloud.resourcemanager.v3.Project, request, callback);
                        }, "name", { value: "GetProject" });
    
                        /**
                         * Calls GetProject.
                         * @function getProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetProjectRequest} request GetProjectRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.Project>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|listProjects}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef ListProjectsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.ListProjectsResponse} [response] ListProjectsResponse
                         */
    
                        /**
                         * Calls ListProjects.
                         * @function listProjects
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListProjectsRequest} request ListProjectsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.ListProjectsCallback} callback Node-style callback called with the error, if any, and ListProjectsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.listProjects = function listProjects(request, callback) {
                            return this.rpcCall(listProjects, $root.google.cloud.resourcemanager.v3.ListProjectsRequest, $root.google.cloud.resourcemanager.v3.ListProjectsResponse, request, callback);
                        }, "name", { value: "ListProjects" });
    
                        /**
                         * Calls ListProjects.
                         * @function listProjects
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListProjectsRequest} request ListProjectsRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.ListProjectsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|searchProjects}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef SearchProjectsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.SearchProjectsResponse} [response] SearchProjectsResponse
                         */
    
                        /**
                         * Calls SearchProjects.
                         * @function searchProjects
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsRequest} request SearchProjectsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.SearchProjectsCallback} callback Node-style callback called with the error, if any, and SearchProjectsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.searchProjects = function searchProjects(request, callback) {
                            return this.rpcCall(searchProjects, $root.google.cloud.resourcemanager.v3.SearchProjectsRequest, $root.google.cloud.resourcemanager.v3.SearchProjectsResponse, request, callback);
                        }, "name", { value: "SearchProjects" });
    
                        /**
                         * Calls SearchProjects.
                         * @function searchProjects
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsRequest} request SearchProjectsRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.SearchProjectsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|createProject}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef CreateProjectCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateProject.
                         * @function createProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectRequest} request CreateProjectRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.CreateProjectCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.createProject = function createProject(request, callback) {
                            return this.rpcCall(createProject, $root.google.cloud.resourcemanager.v3.CreateProjectRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateProject" });
    
                        /**
                         * Calls CreateProject.
                         * @function createProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectRequest} request CreateProjectRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|updateProject}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef UpdateProjectCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateProject.
                         * @function updateProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectRequest} request UpdateProjectRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.UpdateProjectCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.updateProject = function updateProject(request, callback) {
                            return this.rpcCall(updateProject, $root.google.cloud.resourcemanager.v3.UpdateProjectRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateProject" });
    
                        /**
                         * Calls UpdateProject.
                         * @function updateProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectRequest} request UpdateProjectRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|moveProject}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef MoveProjectCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls MoveProject.
                         * @function moveProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectRequest} request MoveProjectRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.MoveProjectCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.moveProject = function moveProject(request, callback) {
                            return this.rpcCall(moveProject, $root.google.cloud.resourcemanager.v3.MoveProjectRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "MoveProject" });
    
                        /**
                         * Calls MoveProject.
                         * @function moveProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectRequest} request MoveProjectRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|deleteProject}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef DeleteProjectCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteProject.
                         * @function deleteProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectRequest} request DeleteProjectRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.DeleteProjectCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.deleteProject = function deleteProject(request, callback) {
                            return this.rpcCall(deleteProject, $root.google.cloud.resourcemanager.v3.DeleteProjectRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteProject" });
    
                        /**
                         * Calls DeleteProject.
                         * @function deleteProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectRequest} request DeleteProjectRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|undeleteProject}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef UndeleteProjectCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UndeleteProject.
                         * @function undeleteProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectRequest} request UndeleteProjectRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.UndeleteProjectCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.undeleteProject = function undeleteProject(request, callback) {
                            return this.rpcCall(undeleteProject, $root.google.cloud.resourcemanager.v3.UndeleteProjectRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UndeleteProject" });
    
                        /**
                         * Calls UndeleteProject.
                         * @function undeleteProject
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectRequest} request UndeleteProjectRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|getIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef GetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.GetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.getIamPolicy = function getIamPolicy(request, callback) {
                            return this.rpcCall(getIamPolicy, $root.google.iam.v1.GetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "GetIamPolicy" });
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|setIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef SetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.SetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.setIamPolicy = function setIamPolicy(request, callback) {
                            return this.rpcCall(setIamPolicy, $root.google.iam.v1.SetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "SetIamPolicy" });
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.Projects|testIamPermissions}.
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @typedef TestIamPermissionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.TestIamPermissionsResponse} [response] TestIamPermissionsResponse
                         */
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.Projects.TestIamPermissionsCallback} callback Node-style callback called with the error, if any, and TestIamPermissionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Projects.prototype.testIamPermissions = function testIamPermissions(request, callback) {
                            return this.rpcCall(testIamPermissions, $root.google.iam.v1.TestIamPermissionsRequest, $root.google.iam.v1.TestIamPermissionsResponse, request, callback);
                        }, "name", { value: "TestIamPermissions" });
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.Projects
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @returns {Promise<google.iam.v1.TestIamPermissionsResponse>} Promise
                         * @variation 2
                         */
    
                        return Projects;
                    })();
    
                    v3.Project = (function() {
    
                        /**
                         * Properties of a Project.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IProject
                         * @property {string|null} [name] Project name
                         * @property {string|null} [parent] Project parent
                         * @property {string|null} [projectId] Project projectId
                         * @property {google.cloud.resourcemanager.v3.Project.State|null} [state] Project state
                         * @property {string|null} [displayName] Project displayName
                         * @property {google.protobuf.ITimestamp|null} [createTime] Project createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] Project updateTime
                         * @property {google.protobuf.ITimestamp|null} [deleteTime] Project deleteTime
                         * @property {string|null} [etag] Project etag
                         * @property {Object.<string,string>|null} [labels] Project labels
                         */
    
                        /**
                         * Constructs a new Project.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a Project.
                         * @implements IProject
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IProject=} [properties] Properties to set
                         */
                        function Project(properties) {
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Project name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.name = "";
    
                        /**
                         * Project parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.parent = "";
    
                        /**
                         * Project projectId.
                         * @member {string} projectId
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.projectId = "";
    
                        /**
                         * Project state.
                         * @member {google.cloud.resourcemanager.v3.Project.State} state
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.state = 0;
    
                        /**
                         * Project displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.displayName = "";
    
                        /**
                         * Project createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.createTime = null;
    
                        /**
                         * Project updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.updateTime = null;
    
                        /**
                         * Project deleteTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} deleteTime
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.deleteTime = null;
    
                        /**
                         * Project etag.
                         * @member {string} etag
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.etag = "";
    
                        /**
                         * Project labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         */
                        Project.prototype.labels = $util.emptyObject;
    
                        /**
                         * Creates a new Project instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IProject=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.Project} Project instance
                         */
                        Project.create = function create(properties) {
                            return new Project(properties);
                        };
    
                        /**
                         * Encodes the specified Project message. Does not implicitly {@link google.cloud.resourcemanager.v3.Project.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IProject} message Project message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Project.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parent);
                            if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.projectId);
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.state);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.displayName);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.deleteTime != null && Object.hasOwnProperty.call(message, "deleteTime"))
                                $root.google.protobuf.Timestamp.encode(message.deleteTime, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 9, wireType 2 =*/74).string(message.etag);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 10, wireType 2 =*/82).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Project message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.Project.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IProject} message Project message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Project.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Project message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.Project} Project
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Project.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.Project(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.projectId = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.deleteTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 10: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Project message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.Project} Project
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Project.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Project message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Project.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                if (!$util.isString(message.projectId))
                                    return "projectId: string expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.deleteTime != null && message.hasOwnProperty("deleteTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.deleteTime);
                                if (error)
                                    return "deleteTime." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Project message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.Project} Project
                         */
                        Project.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.Project)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.Project();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.projectId != null)
                                message.projectId = String(object.projectId);
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "DELETE_REQUESTED":
                            case 2:
                                message.state = 2;
                                break;
                            }
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Project.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Project.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.deleteTime != null) {
                                if (typeof object.deleteTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Project.deleteTime: object expected");
                                message.deleteTime = $root.google.protobuf.Timestamp.fromObject(object.deleteTime);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.Project.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Project message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {google.cloud.resourcemanager.v3.Project} message Project
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Project.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults) {
                                object.name = "";
                                object.parent = "";
                                object.projectId = "";
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.displayName = "";
                                object.createTime = null;
                                object.updateTime = null;
                                object.deleteTime = null;
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                object.projectId = message.projectId;
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.cloud.resourcemanager.v3.Project.State[message.state] === undefined ? message.state : $root.google.cloud.resourcemanager.v3.Project.State[message.state] : message.state;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.deleteTime != null && message.hasOwnProperty("deleteTime"))
                                object.deleteTime = $root.google.protobuf.Timestamp.toObject(message.deleteTime, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Project to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Project.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Project
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.Project
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Project.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.Project";
                        };
    
                        /**
                         * State enum.
                         * @name google.cloud.resourcemanager.v3.Project.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} DELETE_REQUESTED=2 DELETE_REQUESTED value
                         */
                        Project.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "DELETE_REQUESTED"] = 2;
                            return values;
                        })();
    
                        return Project;
                    })();
    
                    v3.GetProjectRequest = (function() {
    
                        /**
                         * Properties of a GetProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IGetProjectRequest
                         * @property {string|null} [name] GetProjectRequest name
                         */
    
                        /**
                         * Constructs a new GetProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a GetProjectRequest.
                         * @implements IGetProjectRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IGetProjectRequest=} [properties] Properties to set
                         */
                        function GetProjectRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetProjectRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @instance
                         */
                        GetProjectRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetProjectRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetProjectRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.GetProjectRequest} GetProjectRequest instance
                         */
                        GetProjectRequest.create = function create(properties) {
                            return new GetProjectRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetProjectRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.GetProjectRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetProjectRequest} message GetProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetProjectRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetProjectRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.GetProjectRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetProjectRequest} message GetProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetProjectRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetProjectRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.GetProjectRequest} GetProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetProjectRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.GetProjectRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetProjectRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.GetProjectRequest} GetProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetProjectRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetProjectRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetProjectRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetProjectRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.GetProjectRequest} GetProjectRequest
                         */
                        GetProjectRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.GetProjectRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.GetProjectRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetProjectRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.GetProjectRequest} message GetProjectRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetProjectRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetProjectRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetProjectRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetProjectRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.GetProjectRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetProjectRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.GetProjectRequest";
                        };
    
                        return GetProjectRequest;
                    })();
    
                    v3.ListProjectsRequest = (function() {
    
                        /**
                         * Properties of a ListProjectsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListProjectsRequest
                         * @property {string|null} [parent] ListProjectsRequest parent
                         * @property {string|null} [pageToken] ListProjectsRequest pageToken
                         * @property {number|null} [pageSize] ListProjectsRequest pageSize
                         * @property {boolean|null} [showDeleted] ListProjectsRequest showDeleted
                         */
    
                        /**
                         * Constructs a new ListProjectsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListProjectsRequest.
                         * @implements IListProjectsRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListProjectsRequest=} [properties] Properties to set
                         */
                        function ListProjectsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListProjectsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @instance
                         */
                        ListProjectsRequest.prototype.parent = "";
    
                        /**
                         * ListProjectsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @instance
                         */
                        ListProjectsRequest.prototype.pageToken = "";
    
                        /**
                         * ListProjectsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @instance
                         */
                        ListProjectsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListProjectsRequest showDeleted.
                         * @member {boolean} showDeleted
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @instance
                         */
                        ListProjectsRequest.prototype.showDeleted = false;
    
                        /**
                         * Creates a new ListProjectsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListProjectsRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsRequest} ListProjectsRequest instance
                         */
                        ListProjectsRequest.create = function create(properties) {
                            return new ListProjectsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListProjectsRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListProjectsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListProjectsRequest} message ListProjectsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListProjectsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.pageToken);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.pageSize);
                            if (message.showDeleted != null && Object.hasOwnProperty.call(message, "showDeleted"))
                                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.showDeleted);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListProjectsRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListProjectsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListProjectsRequest} message ListProjectsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListProjectsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListProjectsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsRequest} ListProjectsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListProjectsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListProjectsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 4: {
                                        message.showDeleted = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListProjectsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsRequest} ListProjectsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListProjectsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListProjectsRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListProjectsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.showDeleted != null && message.hasOwnProperty("showDeleted"))
                                if (typeof message.showDeleted !== "boolean")
                                    return "showDeleted: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListProjectsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsRequest} ListProjectsRequest
                         */
                        ListProjectsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListProjectsRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListProjectsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.showDeleted != null)
                                message.showDeleted = Boolean(object.showDeleted);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListProjectsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListProjectsRequest} message ListProjectsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListProjectsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageToken = "";
                                object.pageSize = 0;
                                object.showDeleted = false;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.showDeleted != null && message.hasOwnProperty("showDeleted"))
                                object.showDeleted = message.showDeleted;
                            return object;
                        };
    
                        /**
                         * Converts this ListProjectsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListProjectsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListProjectsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListProjectsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListProjectsRequest";
                        };
    
                        return ListProjectsRequest;
                    })();
    
                    v3.ListProjectsResponse = (function() {
    
                        /**
                         * Properties of a ListProjectsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListProjectsResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.IProject>|null} [projects] ListProjectsResponse projects
                         * @property {string|null} [nextPageToken] ListProjectsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListProjectsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListProjectsResponse.
                         * @implements IListProjectsResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListProjectsResponse=} [properties] Properties to set
                         */
                        function ListProjectsResponse(properties) {
                            this.projects = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListProjectsResponse projects.
                         * @member {Array.<google.cloud.resourcemanager.v3.IProject>} projects
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @instance
                         */
                        ListProjectsResponse.prototype.projects = $util.emptyArray;
    
                        /**
                         * ListProjectsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @instance
                         */
                        ListProjectsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListProjectsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListProjectsResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsResponse} ListProjectsResponse instance
                         */
                        ListProjectsResponse.create = function create(properties) {
                            return new ListProjectsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListProjectsResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListProjectsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListProjectsResponse} message ListProjectsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListProjectsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projects != null && message.projects.length)
                                for (var i = 0; i < message.projects.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.Project.encode(message.projects[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListProjectsResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListProjectsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListProjectsResponse} message ListProjectsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListProjectsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListProjectsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsResponse} ListProjectsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListProjectsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListProjectsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.projects && message.projects.length))
                                            message.projects = [];
                                        message.projects.push($root.google.cloud.resourcemanager.v3.Project.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListProjectsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsResponse} ListProjectsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListProjectsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListProjectsResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListProjectsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projects != null && message.hasOwnProperty("projects")) {
                                if (!Array.isArray(message.projects))
                                    return "projects: array expected";
                                for (var i = 0; i < message.projects.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.Project.verify(message.projects[i]);
                                    if (error)
                                        return "projects." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListProjectsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListProjectsResponse} ListProjectsResponse
                         */
                        ListProjectsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListProjectsResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListProjectsResponse();
                            if (object.projects) {
                                if (!Array.isArray(object.projects))
                                    throw TypeError(".google.cloud.resourcemanager.v3.ListProjectsResponse.projects: array expected");
                                message.projects = [];
                                for (var i = 0; i < object.projects.length; ++i) {
                                    if (typeof object.projects[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.ListProjectsResponse.projects: object expected");
                                    message.projects[i] = $root.google.cloud.resourcemanager.v3.Project.fromObject(object.projects[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListProjectsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListProjectsResponse} message ListProjectsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListProjectsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.projects = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.projects && message.projects.length) {
                                object.projects = [];
                                for (var j = 0; j < message.projects.length; ++j)
                                    object.projects[j] = $root.google.cloud.resourcemanager.v3.Project.toObject(message.projects[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListProjectsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListProjectsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListProjectsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListProjectsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListProjectsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListProjectsResponse";
                        };
    
                        return ListProjectsResponse;
                    })();
    
                    v3.SearchProjectsRequest = (function() {
    
                        /**
                         * Properties of a SearchProjectsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ISearchProjectsRequest
                         * @property {string|null} [query] SearchProjectsRequest query
                         * @property {string|null} [pageToken] SearchProjectsRequest pageToken
                         * @property {number|null} [pageSize] SearchProjectsRequest pageSize
                         */
    
                        /**
                         * Constructs a new SearchProjectsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a SearchProjectsRequest.
                         * @implements ISearchProjectsRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsRequest=} [properties] Properties to set
                         */
                        function SearchProjectsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchProjectsRequest query.
                         * @member {string} query
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @instance
                         */
                        SearchProjectsRequest.prototype.query = "";
    
                        /**
                         * SearchProjectsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @instance
                         */
                        SearchProjectsRequest.prototype.pageToken = "";
    
                        /**
                         * SearchProjectsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @instance
                         */
                        SearchProjectsRequest.prototype.pageSize = 0;
    
                        /**
                         * Creates a new SearchProjectsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsRequest} SearchProjectsRequest instance
                         */
                        SearchProjectsRequest.create = function create(properties) {
                            return new SearchProjectsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SearchProjectsRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchProjectsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsRequest} message SearchProjectsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchProjectsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.query != null && Object.hasOwnProperty.call(message, "query"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.query);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.pageToken);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.pageSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchProjectsRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchProjectsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsRequest} message SearchProjectsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchProjectsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchProjectsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsRequest} SearchProjectsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchProjectsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.SearchProjectsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.query = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchProjectsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsRequest} SearchProjectsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchProjectsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchProjectsRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchProjectsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.query != null && message.hasOwnProperty("query"))
                                if (!$util.isString(message.query))
                                    return "query: string expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchProjectsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsRequest} SearchProjectsRequest
                         */
                        SearchProjectsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.SearchProjectsRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.SearchProjectsRequest();
                            if (object.query != null)
                                message.query = String(object.query);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchProjectsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.SearchProjectsRequest} message SearchProjectsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchProjectsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.query = "";
                                object.pageToken = "";
                                object.pageSize = 0;
                            }
                            if (message.query != null && message.hasOwnProperty("query"))
                                object.query = message.query;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            return object;
                        };
    
                        /**
                         * Converts this SearchProjectsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchProjectsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SearchProjectsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SearchProjectsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.SearchProjectsRequest";
                        };
    
                        return SearchProjectsRequest;
                    })();
    
                    v3.SearchProjectsResponse = (function() {
    
                        /**
                         * Properties of a SearchProjectsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ISearchProjectsResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.IProject>|null} [projects] SearchProjectsResponse projects
                         * @property {string|null} [nextPageToken] SearchProjectsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new SearchProjectsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a SearchProjectsResponse.
                         * @implements ISearchProjectsResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsResponse=} [properties] Properties to set
                         */
                        function SearchProjectsResponse(properties) {
                            this.projects = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchProjectsResponse projects.
                         * @member {Array.<google.cloud.resourcemanager.v3.IProject>} projects
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @instance
                         */
                        SearchProjectsResponse.prototype.projects = $util.emptyArray;
    
                        /**
                         * SearchProjectsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @instance
                         */
                        SearchProjectsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new SearchProjectsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsResponse} SearchProjectsResponse instance
                         */
                        SearchProjectsResponse.create = function create(properties) {
                            return new SearchProjectsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SearchProjectsResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchProjectsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsResponse} message SearchProjectsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchProjectsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projects != null && message.projects.length)
                                for (var i = 0; i < message.projects.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.Project.encode(message.projects[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchProjectsResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.SearchProjectsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ISearchProjectsResponse} message SearchProjectsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchProjectsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchProjectsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsResponse} SearchProjectsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchProjectsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.SearchProjectsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.projects && message.projects.length))
                                            message.projects = [];
                                        message.projects.push($root.google.cloud.resourcemanager.v3.Project.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchProjectsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsResponse} SearchProjectsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchProjectsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchProjectsResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchProjectsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projects != null && message.hasOwnProperty("projects")) {
                                if (!Array.isArray(message.projects))
                                    return "projects: array expected";
                                for (var i = 0; i < message.projects.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.Project.verify(message.projects[i]);
                                    if (error)
                                        return "projects." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchProjectsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.SearchProjectsResponse} SearchProjectsResponse
                         */
                        SearchProjectsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.SearchProjectsResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.SearchProjectsResponse();
                            if (object.projects) {
                                if (!Array.isArray(object.projects))
                                    throw TypeError(".google.cloud.resourcemanager.v3.SearchProjectsResponse.projects: array expected");
                                message.projects = [];
                                for (var i = 0; i < object.projects.length; ++i) {
                                    if (typeof object.projects[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.SearchProjectsResponse.projects: object expected");
                                    message.projects[i] = $root.google.cloud.resourcemanager.v3.Project.fromObject(object.projects[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchProjectsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.SearchProjectsResponse} message SearchProjectsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchProjectsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.projects = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.projects && message.projects.length) {
                                object.projects = [];
                                for (var j = 0; j < message.projects.length; ++j)
                                    object.projects[j] = $root.google.cloud.resourcemanager.v3.Project.toObject(message.projects[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this SearchProjectsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchProjectsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SearchProjectsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.SearchProjectsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SearchProjectsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.SearchProjectsResponse";
                        };
    
                        return SearchProjectsResponse;
                    })();
    
                    v3.CreateProjectRequest = (function() {
    
                        /**
                         * Properties of a CreateProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateProjectRequest
                         * @property {google.cloud.resourcemanager.v3.IProject|null} [project] CreateProjectRequest project
                         */
    
                        /**
                         * Constructs a new CreateProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateProjectRequest.
                         * @implements ICreateProjectRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectRequest=} [properties] Properties to set
                         */
                        function CreateProjectRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateProjectRequest project.
                         * @member {google.cloud.resourcemanager.v3.IProject|null|undefined} project
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @instance
                         */
                        CreateProjectRequest.prototype.project = null;
    
                        /**
                         * Creates a new CreateProjectRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectRequest} CreateProjectRequest instance
                         */
                        CreateProjectRequest.create = function create(properties) {
                            return new CreateProjectRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateProjectRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateProjectRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectRequest} message CreateProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateProjectRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                $root.google.cloud.resourcemanager.v3.Project.encode(message.project, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateProjectRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateProjectRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectRequest} message CreateProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateProjectRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateProjectRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectRequest} CreateProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateProjectRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateProjectRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.project = $root.google.cloud.resourcemanager.v3.Project.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateProjectRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectRequest} CreateProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateProjectRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateProjectRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateProjectRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.project != null && message.hasOwnProperty("project")) {
                                var error = $root.google.cloud.resourcemanager.v3.Project.verify(message.project);
                                if (error)
                                    return "project." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateProjectRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectRequest} CreateProjectRequest
                         */
                        CreateProjectRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateProjectRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.CreateProjectRequest();
                            if (object.project != null) {
                                if (typeof object.project !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.CreateProjectRequest.project: object expected");
                                message.project = $root.google.cloud.resourcemanager.v3.Project.fromObject(object.project);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateProjectRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateProjectRequest} message CreateProjectRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateProjectRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.project = null;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = $root.google.cloud.resourcemanager.v3.Project.toObject(message.project, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateProjectRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateProjectRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateProjectRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateProjectRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateProjectRequest";
                        };
    
                        return CreateProjectRequest;
                    })();
    
                    v3.CreateProjectMetadata = (function() {
    
                        /**
                         * Properties of a CreateProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateProjectMetadata
                         * @property {google.protobuf.ITimestamp|null} [createTime] CreateProjectMetadata createTime
                         * @property {boolean|null} [gettable] CreateProjectMetadata gettable
                         * @property {boolean|null} [ready] CreateProjectMetadata ready
                         */
    
                        /**
                         * Constructs a new CreateProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateProjectMetadata.
                         * @implements ICreateProjectMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectMetadata=} [properties] Properties to set
                         */
                        function CreateProjectMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateProjectMetadata createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @instance
                         */
                        CreateProjectMetadata.prototype.createTime = null;
    
                        /**
                         * CreateProjectMetadata gettable.
                         * @member {boolean} gettable
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @instance
                         */
                        CreateProjectMetadata.prototype.gettable = false;
    
                        /**
                         * CreateProjectMetadata ready.
                         * @member {boolean} ready
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @instance
                         */
                        CreateProjectMetadata.prototype.ready = false;
    
                        /**
                         * Creates a new CreateProjectMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectMetadata} CreateProjectMetadata instance
                         */
                        CreateProjectMetadata.create = function create(properties) {
                            return new CreateProjectMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CreateProjectMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateProjectMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectMetadata} message CreateProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateProjectMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.gettable != null && Object.hasOwnProperty.call(message, "gettable"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.gettable);
                            if (message.ready != null && Object.hasOwnProperty.call(message, "ready"))
                                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.ready);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateProjectMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateProjectMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateProjectMetadata} message CreateProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateProjectMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateProjectMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectMetadata} CreateProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateProjectMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateProjectMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.gettable = reader.bool();
                                        break;
                                    }
                                case 3: {
                                        message.ready = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateProjectMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectMetadata} CreateProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateProjectMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateProjectMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateProjectMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.gettable != null && message.hasOwnProperty("gettable"))
                                if (typeof message.gettable !== "boolean")
                                    return "gettable: boolean expected";
                            if (message.ready != null && message.hasOwnProperty("ready"))
                                if (typeof message.ready !== "boolean")
                                    return "ready: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a CreateProjectMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateProjectMetadata} CreateProjectMetadata
                         */
                        CreateProjectMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateProjectMetadata)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.CreateProjectMetadata();
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.CreateProjectMetadata.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.gettable != null)
                                message.gettable = Boolean(object.gettable);
                            if (object.ready != null)
                                message.ready = Boolean(object.ready);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateProjectMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateProjectMetadata} message CreateProjectMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateProjectMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.createTime = null;
                                object.gettable = false;
                                object.ready = false;
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.gettable != null && message.hasOwnProperty("gettable"))
                                object.gettable = message.gettable;
                            if (message.ready != null && message.hasOwnProperty("ready"))
                                object.ready = message.ready;
                            return object;
                        };
    
                        /**
                         * Converts this CreateProjectMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateProjectMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateProjectMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateProjectMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateProjectMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateProjectMetadata";
                        };
    
                        return CreateProjectMetadata;
                    })();
    
                    v3.UpdateProjectRequest = (function() {
    
                        /**
                         * Properties of an UpdateProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUpdateProjectRequest
                         * @property {google.cloud.resourcemanager.v3.IProject|null} [project] UpdateProjectRequest project
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateProjectRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UpdateProjectRequest.
                         * @implements IUpdateProjectRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectRequest=} [properties] Properties to set
                         */
                        function UpdateProjectRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateProjectRequest project.
                         * @member {google.cloud.resourcemanager.v3.IProject|null|undefined} project
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @instance
                         */
                        UpdateProjectRequest.prototype.project = null;
    
                        /**
                         * UpdateProjectRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @instance
                         */
                        UpdateProjectRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateProjectRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectRequest} UpdateProjectRequest instance
                         */
                        UpdateProjectRequest.create = function create(properties) {
                            return new UpdateProjectRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateProjectRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateProjectRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectRequest} message UpdateProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateProjectRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                $root.google.cloud.resourcemanager.v3.Project.encode(message.project, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateProjectRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateProjectRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectRequest} message UpdateProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateProjectRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateProjectRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectRequest} UpdateProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateProjectRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UpdateProjectRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.project = $root.google.cloud.resourcemanager.v3.Project.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateProjectRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectRequest} UpdateProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateProjectRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateProjectRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateProjectRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.project != null && message.hasOwnProperty("project")) {
                                var error = $root.google.cloud.resourcemanager.v3.Project.verify(message.project);
                                if (error)
                                    return "project." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateProjectRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectRequest} UpdateProjectRequest
                         */
                        UpdateProjectRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UpdateProjectRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.UpdateProjectRequest();
                            if (object.project != null) {
                                if (typeof object.project !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.UpdateProjectRequest.project: object expected");
                                message.project = $root.google.cloud.resourcemanager.v3.Project.fromObject(object.project);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.UpdateProjectRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateProjectRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UpdateProjectRequest} message UpdateProjectRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateProjectRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.project = null;
                                object.updateMask = null;
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = $root.google.cloud.resourcemanager.v3.Project.toObject(message.project, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateProjectRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateProjectRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateProjectRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateProjectRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UpdateProjectRequest";
                        };
    
                        return UpdateProjectRequest;
                    })();
    
                    v3.UpdateProjectMetadata = (function() {
    
                        /**
                         * Properties of an UpdateProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUpdateProjectMetadata
                         */
    
                        /**
                         * Constructs a new UpdateProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UpdateProjectMetadata.
                         * @implements IUpdateProjectMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectMetadata=} [properties] Properties to set
                         */
                        function UpdateProjectMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new UpdateProjectMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectMetadata} UpdateProjectMetadata instance
                         */
                        UpdateProjectMetadata.create = function create(properties) {
                            return new UpdateProjectMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateProjectMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateProjectMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectMetadata} message UpdateProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateProjectMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateProjectMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UpdateProjectMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUpdateProjectMetadata} message UpdateProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateProjectMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateProjectMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectMetadata} UpdateProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateProjectMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UpdateProjectMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateProjectMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectMetadata} UpdateProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateProjectMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateProjectMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateProjectMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an UpdateProjectMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UpdateProjectMetadata} UpdateProjectMetadata
                         */
                        UpdateProjectMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UpdateProjectMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.UpdateProjectMetadata();
                        };
    
                        /**
                         * Creates a plain object from an UpdateProjectMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UpdateProjectMetadata} message UpdateProjectMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateProjectMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this UpdateProjectMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateProjectMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateProjectMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UpdateProjectMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateProjectMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UpdateProjectMetadata";
                        };
    
                        return UpdateProjectMetadata;
                    })();
    
                    v3.MoveProjectRequest = (function() {
    
                        /**
                         * Properties of a MoveProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IMoveProjectRequest
                         * @property {string|null} [name] MoveProjectRequest name
                         * @property {string|null} [destinationParent] MoveProjectRequest destinationParent
                         */
    
                        /**
                         * Constructs a new MoveProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a MoveProjectRequest.
                         * @implements IMoveProjectRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectRequest=} [properties] Properties to set
                         */
                        function MoveProjectRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * MoveProjectRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @instance
                         */
                        MoveProjectRequest.prototype.name = "";
    
                        /**
                         * MoveProjectRequest destinationParent.
                         * @member {string} destinationParent
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @instance
                         */
                        MoveProjectRequest.prototype.destinationParent = "";
    
                        /**
                         * Creates a new MoveProjectRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectRequest} MoveProjectRequest instance
                         */
                        MoveProjectRequest.create = function create(properties) {
                            return new MoveProjectRequest(properties);
                        };
    
                        /**
                         * Encodes the specified MoveProjectRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveProjectRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectRequest} message MoveProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveProjectRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.destinationParent != null && Object.hasOwnProperty.call(message, "destinationParent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.destinationParent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified MoveProjectRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveProjectRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectRequest} message MoveProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveProjectRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a MoveProjectRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectRequest} MoveProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveProjectRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.MoveProjectRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.destinationParent = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a MoveProjectRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectRequest} MoveProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveProjectRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a MoveProjectRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        MoveProjectRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.destinationParent != null && message.hasOwnProperty("destinationParent"))
                                if (!$util.isString(message.destinationParent))
                                    return "destinationParent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a MoveProjectRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectRequest} MoveProjectRequest
                         */
                        MoveProjectRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.MoveProjectRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.MoveProjectRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.destinationParent != null)
                                message.destinationParent = String(object.destinationParent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a MoveProjectRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.MoveProjectRequest} message MoveProjectRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        MoveProjectRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.destinationParent = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.destinationParent != null && message.hasOwnProperty("destinationParent"))
                                object.destinationParent = message.destinationParent;
                            return object;
                        };
    
                        /**
                         * Converts this MoveProjectRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        MoveProjectRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for MoveProjectRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        MoveProjectRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.MoveProjectRequest";
                        };
    
                        return MoveProjectRequest;
                    })();
    
                    v3.MoveProjectMetadata = (function() {
    
                        /**
                         * Properties of a MoveProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IMoveProjectMetadata
                         */
    
                        /**
                         * Constructs a new MoveProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a MoveProjectMetadata.
                         * @implements IMoveProjectMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectMetadata=} [properties] Properties to set
                         */
                        function MoveProjectMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new MoveProjectMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectMetadata} MoveProjectMetadata instance
                         */
                        MoveProjectMetadata.create = function create(properties) {
                            return new MoveProjectMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified MoveProjectMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveProjectMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectMetadata} message MoveProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveProjectMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified MoveProjectMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.MoveProjectMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IMoveProjectMetadata} message MoveProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MoveProjectMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a MoveProjectMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectMetadata} MoveProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveProjectMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.MoveProjectMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a MoveProjectMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectMetadata} MoveProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MoveProjectMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a MoveProjectMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        MoveProjectMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a MoveProjectMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.MoveProjectMetadata} MoveProjectMetadata
                         */
                        MoveProjectMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.MoveProjectMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.MoveProjectMetadata();
                        };
    
                        /**
                         * Creates a plain object from a MoveProjectMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.MoveProjectMetadata} message MoveProjectMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        MoveProjectMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this MoveProjectMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        MoveProjectMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for MoveProjectMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.MoveProjectMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        MoveProjectMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.MoveProjectMetadata";
                        };
    
                        return MoveProjectMetadata;
                    })();
    
                    v3.DeleteProjectRequest = (function() {
    
                        /**
                         * Properties of a DeleteProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteProjectRequest
                         * @property {string|null} [name] DeleteProjectRequest name
                         */
    
                        /**
                         * Constructs a new DeleteProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteProjectRequest.
                         * @implements IDeleteProjectRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectRequest=} [properties] Properties to set
                         */
                        function DeleteProjectRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteProjectRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @instance
                         */
                        DeleteProjectRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteProjectRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectRequest} DeleteProjectRequest instance
                         */
                        DeleteProjectRequest.create = function create(properties) {
                            return new DeleteProjectRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteProjectRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteProjectRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectRequest} message DeleteProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteProjectRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteProjectRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteProjectRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectRequest} message DeleteProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteProjectRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteProjectRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectRequest} DeleteProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteProjectRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteProjectRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteProjectRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectRequest} DeleteProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteProjectRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteProjectRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteProjectRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteProjectRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectRequest} DeleteProjectRequest
                         */
                        DeleteProjectRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteProjectRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.DeleteProjectRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteProjectRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteProjectRequest} message DeleteProjectRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteProjectRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteProjectRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteProjectRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteProjectRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteProjectRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteProjectRequest";
                        };
    
                        return DeleteProjectRequest;
                    })();
    
                    v3.DeleteProjectMetadata = (function() {
    
                        /**
                         * Properties of a DeleteProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteProjectMetadata
                         */
    
                        /**
                         * Constructs a new DeleteProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteProjectMetadata.
                         * @implements IDeleteProjectMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectMetadata=} [properties] Properties to set
                         */
                        function DeleteProjectMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new DeleteProjectMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectMetadata} DeleteProjectMetadata instance
                         */
                        DeleteProjectMetadata.create = function create(properties) {
                            return new DeleteProjectMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteProjectMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteProjectMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectMetadata} message DeleteProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteProjectMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteProjectMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteProjectMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteProjectMetadata} message DeleteProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteProjectMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteProjectMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectMetadata} DeleteProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteProjectMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteProjectMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteProjectMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectMetadata} DeleteProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteProjectMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteProjectMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteProjectMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteProjectMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteProjectMetadata} DeleteProjectMetadata
                         */
                        DeleteProjectMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteProjectMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.DeleteProjectMetadata();
                        };
    
                        /**
                         * Creates a plain object from a DeleteProjectMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteProjectMetadata} message DeleteProjectMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteProjectMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this DeleteProjectMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteProjectMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteProjectMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteProjectMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteProjectMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteProjectMetadata";
                        };
    
                        return DeleteProjectMetadata;
                    })();
    
                    v3.UndeleteProjectRequest = (function() {
    
                        /**
                         * Properties of an UndeleteProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUndeleteProjectRequest
                         * @property {string|null} [name] UndeleteProjectRequest name
                         */
    
                        /**
                         * Constructs a new UndeleteProjectRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UndeleteProjectRequest.
                         * @implements IUndeleteProjectRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectRequest=} [properties] Properties to set
                         */
                        function UndeleteProjectRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UndeleteProjectRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @instance
                         */
                        UndeleteProjectRequest.prototype.name = "";
    
                        /**
                         * Creates a new UndeleteProjectRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectRequest} UndeleteProjectRequest instance
                         */
                        UndeleteProjectRequest.create = function create(properties) {
                            return new UndeleteProjectRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UndeleteProjectRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteProjectRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectRequest} message UndeleteProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteProjectRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UndeleteProjectRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteProjectRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectRequest} message UndeleteProjectRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteProjectRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UndeleteProjectRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectRequest} UndeleteProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteProjectRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UndeleteProjectRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UndeleteProjectRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectRequest} UndeleteProjectRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteProjectRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UndeleteProjectRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UndeleteProjectRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an UndeleteProjectRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectRequest} UndeleteProjectRequest
                         */
                        UndeleteProjectRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UndeleteProjectRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.UndeleteProjectRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UndeleteProjectRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UndeleteProjectRequest} message UndeleteProjectRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UndeleteProjectRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this UndeleteProjectRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UndeleteProjectRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UndeleteProjectRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UndeleteProjectRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UndeleteProjectRequest";
                        };
    
                        return UndeleteProjectRequest;
                    })();
    
                    v3.UndeleteProjectMetadata = (function() {
    
                        /**
                         * Properties of an UndeleteProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IUndeleteProjectMetadata
                         */
    
                        /**
                         * Constructs a new UndeleteProjectMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an UndeleteProjectMetadata.
                         * @implements IUndeleteProjectMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectMetadata=} [properties] Properties to set
                         */
                        function UndeleteProjectMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new UndeleteProjectMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectMetadata} UndeleteProjectMetadata instance
                         */
                        UndeleteProjectMetadata.create = function create(properties) {
                            return new UndeleteProjectMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified UndeleteProjectMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteProjectMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectMetadata} message UndeleteProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteProjectMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UndeleteProjectMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.UndeleteProjectMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IUndeleteProjectMetadata} message UndeleteProjectMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UndeleteProjectMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UndeleteProjectMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectMetadata} UndeleteProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteProjectMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.UndeleteProjectMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UndeleteProjectMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectMetadata} UndeleteProjectMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UndeleteProjectMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UndeleteProjectMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UndeleteProjectMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an UndeleteProjectMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.UndeleteProjectMetadata} UndeleteProjectMetadata
                         */
                        UndeleteProjectMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.UndeleteProjectMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.UndeleteProjectMetadata();
                        };
    
                        /**
                         * Creates a plain object from an UndeleteProjectMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.UndeleteProjectMetadata} message UndeleteProjectMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UndeleteProjectMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this UndeleteProjectMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UndeleteProjectMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UndeleteProjectMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.UndeleteProjectMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UndeleteProjectMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.UndeleteProjectMetadata";
                        };
    
                        return UndeleteProjectMetadata;
                    })();
    
                    v3.TagBindings = (function() {
    
                        /**
                         * Constructs a new TagBindings service.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a TagBindings
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function TagBindings(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (TagBindings.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = TagBindings;
    
                        /**
                         * Creates new TagBindings service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {TagBindings} RPC service. Useful where requests and/or responses are streamed.
                         */
                        TagBindings.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagBindings|listTagBindings}.
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @typedef ListTagBindingsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.ListTagBindingsResponse} [response] ListTagBindingsResponse
                         */
    
                        /**
                         * Calls ListTagBindings.
                         * @function listTagBindings
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsRequest} request ListTagBindingsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagBindings.ListTagBindingsCallback} callback Node-style callback called with the error, if any, and ListTagBindingsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagBindings.prototype.listTagBindings = function listTagBindings(request, callback) {
                            return this.rpcCall(listTagBindings, $root.google.cloud.resourcemanager.v3.ListTagBindingsRequest, $root.google.cloud.resourcemanager.v3.ListTagBindingsResponse, request, callback);
                        }, "name", { value: "ListTagBindings" });
    
                        /**
                         * Calls ListTagBindings.
                         * @function listTagBindings
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsRequest} request ListTagBindingsRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.ListTagBindingsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagBindings|createTagBinding}.
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @typedef CreateTagBindingCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateTagBinding.
                         * @function createTagBinding
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingRequest} request CreateTagBindingRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagBindings.CreateTagBindingCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagBindings.prototype.createTagBinding = function createTagBinding(request, callback) {
                            return this.rpcCall(createTagBinding, $root.google.cloud.resourcemanager.v3.CreateTagBindingRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateTagBinding" });
    
                        /**
                         * Calls CreateTagBinding.
                         * @function createTagBinding
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingRequest} request CreateTagBindingRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagBindings|deleteTagBinding}.
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @typedef DeleteTagBindingCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteTagBinding.
                         * @function deleteTagBinding
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingRequest} request DeleteTagBindingRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagBindings.DeleteTagBindingCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagBindings.prototype.deleteTagBinding = function deleteTagBinding(request, callback) {
                            return this.rpcCall(deleteTagBinding, $root.google.cloud.resourcemanager.v3.DeleteTagBindingRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteTagBinding" });
    
                        /**
                         * Calls DeleteTagBinding.
                         * @function deleteTagBinding
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingRequest} request DeleteTagBindingRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagBindings|listEffectiveTags}.
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @typedef ListEffectiveTagsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.ListEffectiveTagsResponse} [response] ListEffectiveTagsResponse
                         */
    
                        /**
                         * Calls ListEffectiveTags.
                         * @function listEffectiveTags
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsRequest} request ListEffectiveTagsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagBindings.ListEffectiveTagsCallback} callback Node-style callback called with the error, if any, and ListEffectiveTagsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagBindings.prototype.listEffectiveTags = function listEffectiveTags(request, callback) {
                            return this.rpcCall(listEffectiveTags, $root.google.cloud.resourcemanager.v3.ListEffectiveTagsRequest, $root.google.cloud.resourcemanager.v3.ListEffectiveTagsResponse, request, callback);
                        }, "name", { value: "ListEffectiveTags" });
    
                        /**
                         * Calls ListEffectiveTags.
                         * @function listEffectiveTags
                         * @memberof google.cloud.resourcemanager.v3.TagBindings
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsRequest} request ListEffectiveTagsRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.ListEffectiveTagsResponse>} Promise
                         * @variation 2
                         */
    
                        return TagBindings;
                    })();
    
                    v3.TagBinding = (function() {
    
                        /**
                         * Properties of a TagBinding.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ITagBinding
                         * @property {string|null} [name] TagBinding name
                         * @property {string|null} [parent] TagBinding parent
                         * @property {string|null} [tagValue] TagBinding tagValue
                         * @property {string|null} [tagValueNamespacedName] TagBinding tagValueNamespacedName
                         */
    
                        /**
                         * Constructs a new TagBinding.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a TagBinding.
                         * @implements ITagBinding
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ITagBinding=} [properties] Properties to set
                         */
                        function TagBinding(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TagBinding name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @instance
                         */
                        TagBinding.prototype.name = "";
    
                        /**
                         * TagBinding parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @instance
                         */
                        TagBinding.prototype.parent = "";
    
                        /**
                         * TagBinding tagValue.
                         * @member {string} tagValue
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @instance
                         */
                        TagBinding.prototype.tagValue = "";
    
                        /**
                         * TagBinding tagValueNamespacedName.
                         * @member {string} tagValueNamespacedName
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @instance
                         */
                        TagBinding.prototype.tagValueNamespacedName = "";
    
                        /**
                         * Creates a new TagBinding instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagBinding=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.TagBinding} TagBinding instance
                         */
                        TagBinding.create = function create(properties) {
                            return new TagBinding(properties);
                        };
    
                        /**
                         * Encodes the specified TagBinding message. Does not implicitly {@link google.cloud.resourcemanager.v3.TagBinding.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagBinding} message TagBinding message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TagBinding.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parent);
                            if (message.tagValue != null && Object.hasOwnProperty.call(message, "tagValue"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.tagValue);
                            if (message.tagValueNamespacedName != null && Object.hasOwnProperty.call(message, "tagValueNamespacedName"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.tagValueNamespacedName);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TagBinding message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.TagBinding.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagBinding} message TagBinding message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TagBinding.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TagBinding message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.TagBinding} TagBinding
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TagBinding.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.TagBinding();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.tagValue = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.tagValueNamespacedName = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TagBinding message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.TagBinding} TagBinding
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TagBinding.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TagBinding message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TagBinding.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.tagValue != null && message.hasOwnProperty("tagValue"))
                                if (!$util.isString(message.tagValue))
                                    return "tagValue: string expected";
                            if (message.tagValueNamespacedName != null && message.hasOwnProperty("tagValueNamespacedName"))
                                if (!$util.isString(message.tagValueNamespacedName))
                                    return "tagValueNamespacedName: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a TagBinding message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.TagBinding} TagBinding
                         */
                        TagBinding.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.TagBinding)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.TagBinding();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.tagValue != null)
                                message.tagValue = String(object.tagValue);
                            if (object.tagValueNamespacedName != null)
                                message.tagValueNamespacedName = String(object.tagValueNamespacedName);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TagBinding message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {google.cloud.resourcemanager.v3.TagBinding} message TagBinding
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TagBinding.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.parent = "";
                                object.tagValue = "";
                                object.tagValueNamespacedName = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.tagValue != null && message.hasOwnProperty("tagValue"))
                                object.tagValue = message.tagValue;
                            if (message.tagValueNamespacedName != null && message.hasOwnProperty("tagValueNamespacedName"))
                                object.tagValueNamespacedName = message.tagValueNamespacedName;
                            return object;
                        };
    
                        /**
                         * Converts this TagBinding to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TagBinding.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TagBinding
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.TagBinding
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TagBinding.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.TagBinding";
                        };
    
                        return TagBinding;
                    })();
    
                    v3.CreateTagBindingMetadata = (function() {
    
                        /**
                         * Properties of a CreateTagBindingMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateTagBindingMetadata
                         */
    
                        /**
                         * Constructs a new CreateTagBindingMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateTagBindingMetadata.
                         * @implements ICreateTagBindingMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingMetadata=} [properties] Properties to set
                         */
                        function CreateTagBindingMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new CreateTagBindingMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingMetadata} CreateTagBindingMetadata instance
                         */
                        CreateTagBindingMetadata.create = function create(properties) {
                            return new CreateTagBindingMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CreateTagBindingMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagBindingMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingMetadata} message CreateTagBindingMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagBindingMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateTagBindingMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagBindingMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingMetadata} message CreateTagBindingMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagBindingMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateTagBindingMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingMetadata} CreateTagBindingMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagBindingMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateTagBindingMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateTagBindingMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingMetadata} CreateTagBindingMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagBindingMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateTagBindingMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateTagBindingMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a CreateTagBindingMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingMetadata} CreateTagBindingMetadata
                         */
                        CreateTagBindingMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateTagBindingMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.CreateTagBindingMetadata();
                        };
    
                        /**
                         * Creates a plain object from a CreateTagBindingMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateTagBindingMetadata} message CreateTagBindingMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateTagBindingMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this CreateTagBindingMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateTagBindingMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateTagBindingMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateTagBindingMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateTagBindingMetadata";
                        };
    
                        return CreateTagBindingMetadata;
                    })();
    
                    v3.CreateTagBindingRequest = (function() {
    
                        /**
                         * Properties of a CreateTagBindingRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateTagBindingRequest
                         * @property {google.cloud.resourcemanager.v3.ITagBinding|null} [tagBinding] CreateTagBindingRequest tagBinding
                         * @property {boolean|null} [validateOnly] CreateTagBindingRequest validateOnly
                         */
    
                        /**
                         * Constructs a new CreateTagBindingRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateTagBindingRequest.
                         * @implements ICreateTagBindingRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingRequest=} [properties] Properties to set
                         */
                        function CreateTagBindingRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateTagBindingRequest tagBinding.
                         * @member {google.cloud.resourcemanager.v3.ITagBinding|null|undefined} tagBinding
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @instance
                         */
                        CreateTagBindingRequest.prototype.tagBinding = null;
    
                        /**
                         * CreateTagBindingRequest validateOnly.
                         * @member {boolean} validateOnly
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @instance
                         */
                        CreateTagBindingRequest.prototype.validateOnly = false;
    
                        /**
                         * Creates a new CreateTagBindingRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingRequest} CreateTagBindingRequest instance
                         */
                        CreateTagBindingRequest.create = function create(properties) {
                            return new CreateTagBindingRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateTagBindingRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagBindingRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingRequest} message CreateTagBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagBindingRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tagBinding != null && Object.hasOwnProperty.call(message, "tagBinding"))
                                $root.google.cloud.resourcemanager.v3.TagBinding.encode(message.tagBinding, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.validateOnly != null && Object.hasOwnProperty.call(message, "validateOnly"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.validateOnly);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateTagBindingRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagBindingRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagBindingRequest} message CreateTagBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagBindingRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateTagBindingRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingRequest} CreateTagBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagBindingRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateTagBindingRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.tagBinding = $root.google.cloud.resourcemanager.v3.TagBinding.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.validateOnly = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateTagBindingRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingRequest} CreateTagBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagBindingRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateTagBindingRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateTagBindingRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tagBinding != null && message.hasOwnProperty("tagBinding")) {
                                var error = $root.google.cloud.resourcemanager.v3.TagBinding.verify(message.tagBinding);
                                if (error)
                                    return "tagBinding." + error;
                            }
                            if (message.validateOnly != null && message.hasOwnProperty("validateOnly"))
                                if (typeof message.validateOnly !== "boolean")
                                    return "validateOnly: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a CreateTagBindingRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateTagBindingRequest} CreateTagBindingRequest
                         */
                        CreateTagBindingRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateTagBindingRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.CreateTagBindingRequest();
                            if (object.tagBinding != null) {
                                if (typeof object.tagBinding !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.CreateTagBindingRequest.tagBinding: object expected");
                                message.tagBinding = $root.google.cloud.resourcemanager.v3.TagBinding.fromObject(object.tagBinding);
                            }
                            if (object.validateOnly != null)
                                message.validateOnly = Boolean(object.validateOnly);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateTagBindingRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateTagBindingRequest} message CreateTagBindingRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateTagBindingRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.tagBinding = null;
                                object.validateOnly = false;
                            }
                            if (message.tagBinding != null && message.hasOwnProperty("tagBinding"))
                                object.tagBinding = $root.google.cloud.resourcemanager.v3.TagBinding.toObject(message.tagBinding, options);
                            if (message.validateOnly != null && message.hasOwnProperty("validateOnly"))
                                object.validateOnly = message.validateOnly;
                            return object;
                        };
    
                        /**
                         * Converts this CreateTagBindingRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateTagBindingRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateTagBindingRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateTagBindingRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateTagBindingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateTagBindingRequest";
                        };
    
                        return CreateTagBindingRequest;
                    })();
    
                    v3.DeleteTagBindingMetadata = (function() {
    
                        /**
                         * Properties of a DeleteTagBindingMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteTagBindingMetadata
                         */
    
                        /**
                         * Constructs a new DeleteTagBindingMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteTagBindingMetadata.
                         * @implements IDeleteTagBindingMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingMetadata=} [properties] Properties to set
                         */
                        function DeleteTagBindingMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new DeleteTagBindingMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingMetadata} DeleteTagBindingMetadata instance
                         */
                        DeleteTagBindingMetadata.create = function create(properties) {
                            return new DeleteTagBindingMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteTagBindingMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagBindingMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingMetadata} message DeleteTagBindingMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagBindingMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteTagBindingMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagBindingMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingMetadata} message DeleteTagBindingMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagBindingMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteTagBindingMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingMetadata} DeleteTagBindingMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagBindingMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteTagBindingMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteTagBindingMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingMetadata} DeleteTagBindingMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagBindingMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteTagBindingMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteTagBindingMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteTagBindingMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingMetadata} DeleteTagBindingMetadata
                         */
                        DeleteTagBindingMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteTagBindingMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.DeleteTagBindingMetadata();
                        };
    
                        /**
                         * Creates a plain object from a DeleteTagBindingMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteTagBindingMetadata} message DeleteTagBindingMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteTagBindingMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this DeleteTagBindingMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteTagBindingMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteTagBindingMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteTagBindingMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteTagBindingMetadata";
                        };
    
                        return DeleteTagBindingMetadata;
                    })();
    
                    v3.DeleteTagBindingRequest = (function() {
    
                        /**
                         * Properties of a DeleteTagBindingRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteTagBindingRequest
                         * @property {string|null} [name] DeleteTagBindingRequest name
                         */
    
                        /**
                         * Constructs a new DeleteTagBindingRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteTagBindingRequest.
                         * @implements IDeleteTagBindingRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingRequest=} [properties] Properties to set
                         */
                        function DeleteTagBindingRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteTagBindingRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @instance
                         */
                        DeleteTagBindingRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteTagBindingRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingRequest} DeleteTagBindingRequest instance
                         */
                        DeleteTagBindingRequest.create = function create(properties) {
                            return new DeleteTagBindingRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteTagBindingRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagBindingRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingRequest} message DeleteTagBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagBindingRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteTagBindingRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagBindingRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagBindingRequest} message DeleteTagBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagBindingRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteTagBindingRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingRequest} DeleteTagBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagBindingRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteTagBindingRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteTagBindingRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingRequest} DeleteTagBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagBindingRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteTagBindingRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteTagBindingRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteTagBindingRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagBindingRequest} DeleteTagBindingRequest
                         */
                        DeleteTagBindingRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteTagBindingRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.DeleteTagBindingRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteTagBindingRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteTagBindingRequest} message DeleteTagBindingRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteTagBindingRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteTagBindingRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteTagBindingRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteTagBindingRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagBindingRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteTagBindingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteTagBindingRequest";
                        };
    
                        return DeleteTagBindingRequest;
                    })();
    
                    v3.ListTagBindingsRequest = (function() {
    
                        /**
                         * Properties of a ListTagBindingsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListTagBindingsRequest
                         * @property {string|null} [parent] ListTagBindingsRequest parent
                         * @property {number|null} [pageSize] ListTagBindingsRequest pageSize
                         * @property {string|null} [pageToken] ListTagBindingsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListTagBindingsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListTagBindingsRequest.
                         * @implements IListTagBindingsRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsRequest=} [properties] Properties to set
                         */
                        function ListTagBindingsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListTagBindingsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @instance
                         */
                        ListTagBindingsRequest.prototype.parent = "";
    
                        /**
                         * ListTagBindingsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @instance
                         */
                        ListTagBindingsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListTagBindingsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @instance
                         */
                        ListTagBindingsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListTagBindingsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsRequest} ListTagBindingsRequest instance
                         */
                        ListTagBindingsRequest.create = function create(properties) {
                            return new ListTagBindingsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListTagBindingsRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagBindingsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsRequest} message ListTagBindingsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagBindingsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListTagBindingsRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagBindingsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsRequest} message ListTagBindingsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagBindingsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListTagBindingsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsRequest} ListTagBindingsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagBindingsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListTagBindingsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListTagBindingsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsRequest} ListTagBindingsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagBindingsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListTagBindingsRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListTagBindingsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListTagBindingsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsRequest} ListTagBindingsRequest
                         */
                        ListTagBindingsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListTagBindingsRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListTagBindingsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListTagBindingsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListTagBindingsRequest} message ListTagBindingsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListTagBindingsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListTagBindingsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListTagBindingsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListTagBindingsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListTagBindingsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListTagBindingsRequest";
                        };
    
                        return ListTagBindingsRequest;
                    })();
    
                    v3.ListTagBindingsResponse = (function() {
    
                        /**
                         * Properties of a ListTagBindingsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListTagBindingsResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.ITagBinding>|null} [tagBindings] ListTagBindingsResponse tagBindings
                         * @property {string|null} [nextPageToken] ListTagBindingsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListTagBindingsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListTagBindingsResponse.
                         * @implements IListTagBindingsResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsResponse=} [properties] Properties to set
                         */
                        function ListTagBindingsResponse(properties) {
                            this.tagBindings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListTagBindingsResponse tagBindings.
                         * @member {Array.<google.cloud.resourcemanager.v3.ITagBinding>} tagBindings
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @instance
                         */
                        ListTagBindingsResponse.prototype.tagBindings = $util.emptyArray;
    
                        /**
                         * ListTagBindingsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @instance
                         */
                        ListTagBindingsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListTagBindingsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsResponse} ListTagBindingsResponse instance
                         */
                        ListTagBindingsResponse.create = function create(properties) {
                            return new ListTagBindingsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListTagBindingsResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagBindingsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsResponse} message ListTagBindingsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagBindingsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tagBindings != null && message.tagBindings.length)
                                for (var i = 0; i < message.tagBindings.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.TagBinding.encode(message.tagBindings[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListTagBindingsResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagBindingsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagBindingsResponse} message ListTagBindingsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagBindingsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListTagBindingsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsResponse} ListTagBindingsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagBindingsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListTagBindingsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.tagBindings && message.tagBindings.length))
                                            message.tagBindings = [];
                                        message.tagBindings.push($root.google.cloud.resourcemanager.v3.TagBinding.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListTagBindingsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsResponse} ListTagBindingsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagBindingsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListTagBindingsResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListTagBindingsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tagBindings != null && message.hasOwnProperty("tagBindings")) {
                                if (!Array.isArray(message.tagBindings))
                                    return "tagBindings: array expected";
                                for (var i = 0; i < message.tagBindings.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.TagBinding.verify(message.tagBindings[i]);
                                    if (error)
                                        return "tagBindings." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListTagBindingsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListTagBindingsResponse} ListTagBindingsResponse
                         */
                        ListTagBindingsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListTagBindingsResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListTagBindingsResponse();
                            if (object.tagBindings) {
                                if (!Array.isArray(object.tagBindings))
                                    throw TypeError(".google.cloud.resourcemanager.v3.ListTagBindingsResponse.tagBindings: array expected");
                                message.tagBindings = [];
                                for (var i = 0; i < object.tagBindings.length; ++i) {
                                    if (typeof object.tagBindings[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.ListTagBindingsResponse.tagBindings: object expected");
                                    message.tagBindings[i] = $root.google.cloud.resourcemanager.v3.TagBinding.fromObject(object.tagBindings[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListTagBindingsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListTagBindingsResponse} message ListTagBindingsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListTagBindingsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.tagBindings = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.tagBindings && message.tagBindings.length) {
                                object.tagBindings = [];
                                for (var j = 0; j < message.tagBindings.length; ++j)
                                    object.tagBindings[j] = $root.google.cloud.resourcemanager.v3.TagBinding.toObject(message.tagBindings[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListTagBindingsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListTagBindingsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListTagBindingsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListTagBindingsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListTagBindingsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListTagBindingsResponse";
                        };
    
                        return ListTagBindingsResponse;
                    })();
    
                    v3.ListEffectiveTagsRequest = (function() {
    
                        /**
                         * Properties of a ListEffectiveTagsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListEffectiveTagsRequest
                         * @property {string|null} [parent] ListEffectiveTagsRequest parent
                         * @property {number|null} [pageSize] ListEffectiveTagsRequest pageSize
                         * @property {string|null} [pageToken] ListEffectiveTagsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListEffectiveTagsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListEffectiveTagsRequest.
                         * @implements IListEffectiveTagsRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsRequest=} [properties] Properties to set
                         */
                        function ListEffectiveTagsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListEffectiveTagsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @instance
                         */
                        ListEffectiveTagsRequest.prototype.parent = "";
    
                        /**
                         * ListEffectiveTagsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @instance
                         */
                        ListEffectiveTagsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListEffectiveTagsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @instance
                         */
                        ListEffectiveTagsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListEffectiveTagsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsRequest} ListEffectiveTagsRequest instance
                         */
                        ListEffectiveTagsRequest.create = function create(properties) {
                            return new ListEffectiveTagsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListEffectiveTagsRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListEffectiveTagsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsRequest} message ListEffectiveTagsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEffectiveTagsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListEffectiveTagsRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListEffectiveTagsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsRequest} message ListEffectiveTagsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEffectiveTagsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListEffectiveTagsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsRequest} ListEffectiveTagsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEffectiveTagsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListEffectiveTagsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListEffectiveTagsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsRequest} ListEffectiveTagsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEffectiveTagsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListEffectiveTagsRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListEffectiveTagsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListEffectiveTagsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsRequest} ListEffectiveTagsRequest
                         */
                        ListEffectiveTagsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListEffectiveTagsRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListEffectiveTagsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListEffectiveTagsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListEffectiveTagsRequest} message ListEffectiveTagsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListEffectiveTagsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListEffectiveTagsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListEffectiveTagsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListEffectiveTagsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListEffectiveTagsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListEffectiveTagsRequest";
                        };
    
                        return ListEffectiveTagsRequest;
                    })();
    
                    v3.ListEffectiveTagsResponse = (function() {
    
                        /**
                         * Properties of a ListEffectiveTagsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListEffectiveTagsResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.IEffectiveTag>|null} [effectiveTags] ListEffectiveTagsResponse effectiveTags
                         * @property {string|null} [nextPageToken] ListEffectiveTagsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListEffectiveTagsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListEffectiveTagsResponse.
                         * @implements IListEffectiveTagsResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsResponse=} [properties] Properties to set
                         */
                        function ListEffectiveTagsResponse(properties) {
                            this.effectiveTags = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListEffectiveTagsResponse effectiveTags.
                         * @member {Array.<google.cloud.resourcemanager.v3.IEffectiveTag>} effectiveTags
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @instance
                         */
                        ListEffectiveTagsResponse.prototype.effectiveTags = $util.emptyArray;
    
                        /**
                         * ListEffectiveTagsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @instance
                         */
                        ListEffectiveTagsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListEffectiveTagsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsResponse} ListEffectiveTagsResponse instance
                         */
                        ListEffectiveTagsResponse.create = function create(properties) {
                            return new ListEffectiveTagsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListEffectiveTagsResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListEffectiveTagsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsResponse} message ListEffectiveTagsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEffectiveTagsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.effectiveTags != null && message.effectiveTags.length)
                                for (var i = 0; i < message.effectiveTags.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.EffectiveTag.encode(message.effectiveTags[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListEffectiveTagsResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListEffectiveTagsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListEffectiveTagsResponse} message ListEffectiveTagsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEffectiveTagsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListEffectiveTagsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsResponse} ListEffectiveTagsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEffectiveTagsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListEffectiveTagsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.effectiveTags && message.effectiveTags.length))
                                            message.effectiveTags = [];
                                        message.effectiveTags.push($root.google.cloud.resourcemanager.v3.EffectiveTag.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListEffectiveTagsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsResponse} ListEffectiveTagsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEffectiveTagsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListEffectiveTagsResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListEffectiveTagsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.effectiveTags != null && message.hasOwnProperty("effectiveTags")) {
                                if (!Array.isArray(message.effectiveTags))
                                    return "effectiveTags: array expected";
                                for (var i = 0; i < message.effectiveTags.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.EffectiveTag.verify(message.effectiveTags[i]);
                                    if (error)
                                        return "effectiveTags." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListEffectiveTagsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListEffectiveTagsResponse} ListEffectiveTagsResponse
                         */
                        ListEffectiveTagsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListEffectiveTagsResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListEffectiveTagsResponse();
                            if (object.effectiveTags) {
                                if (!Array.isArray(object.effectiveTags))
                                    throw TypeError(".google.cloud.resourcemanager.v3.ListEffectiveTagsResponse.effectiveTags: array expected");
                                message.effectiveTags = [];
                                for (var i = 0; i < object.effectiveTags.length; ++i) {
                                    if (typeof object.effectiveTags[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.ListEffectiveTagsResponse.effectiveTags: object expected");
                                    message.effectiveTags[i] = $root.google.cloud.resourcemanager.v3.EffectiveTag.fromObject(object.effectiveTags[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListEffectiveTagsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListEffectiveTagsResponse} message ListEffectiveTagsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListEffectiveTagsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.effectiveTags = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.effectiveTags && message.effectiveTags.length) {
                                object.effectiveTags = [];
                                for (var j = 0; j < message.effectiveTags.length; ++j)
                                    object.effectiveTags[j] = $root.google.cloud.resourcemanager.v3.EffectiveTag.toObject(message.effectiveTags[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListEffectiveTagsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListEffectiveTagsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListEffectiveTagsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListEffectiveTagsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListEffectiveTagsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListEffectiveTagsResponse";
                        };
    
                        return ListEffectiveTagsResponse;
                    })();
    
                    v3.EffectiveTag = (function() {
    
                        /**
                         * Properties of an EffectiveTag.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IEffectiveTag
                         * @property {string|null} [tagValue] EffectiveTag tagValue
                         * @property {string|null} [namespacedTagValue] EffectiveTag namespacedTagValue
                         * @property {string|null} [tagKey] EffectiveTag tagKey
                         * @property {string|null} [namespacedTagKey] EffectiveTag namespacedTagKey
                         * @property {string|null} [tagKeyParentName] EffectiveTag tagKeyParentName
                         * @property {boolean|null} [inherited] EffectiveTag inherited
                         */
    
                        /**
                         * Constructs a new EffectiveTag.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents an EffectiveTag.
                         * @implements IEffectiveTag
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IEffectiveTag=} [properties] Properties to set
                         */
                        function EffectiveTag(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * EffectiveTag tagValue.
                         * @member {string} tagValue
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         */
                        EffectiveTag.prototype.tagValue = "";
    
                        /**
                         * EffectiveTag namespacedTagValue.
                         * @member {string} namespacedTagValue
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         */
                        EffectiveTag.prototype.namespacedTagValue = "";
    
                        /**
                         * EffectiveTag tagKey.
                         * @member {string} tagKey
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         */
                        EffectiveTag.prototype.tagKey = "";
    
                        /**
                         * EffectiveTag namespacedTagKey.
                         * @member {string} namespacedTagKey
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         */
                        EffectiveTag.prototype.namespacedTagKey = "";
    
                        /**
                         * EffectiveTag tagKeyParentName.
                         * @member {string} tagKeyParentName
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         */
                        EffectiveTag.prototype.tagKeyParentName = "";
    
                        /**
                         * EffectiveTag inherited.
                         * @member {boolean} inherited
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         */
                        EffectiveTag.prototype.inherited = false;
    
                        /**
                         * Creates a new EffectiveTag instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IEffectiveTag=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.EffectiveTag} EffectiveTag instance
                         */
                        EffectiveTag.create = function create(properties) {
                            return new EffectiveTag(properties);
                        };
    
                        /**
                         * Encodes the specified EffectiveTag message. Does not implicitly {@link google.cloud.resourcemanager.v3.EffectiveTag.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IEffectiveTag} message EffectiveTag message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EffectiveTag.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tagValue != null && Object.hasOwnProperty.call(message, "tagValue"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.tagValue);
                            if (message.namespacedTagValue != null && Object.hasOwnProperty.call(message, "namespacedTagValue"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.namespacedTagValue);
                            if (message.tagKey != null && Object.hasOwnProperty.call(message, "tagKey"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.tagKey);
                            if (message.namespacedTagKey != null && Object.hasOwnProperty.call(message, "namespacedTagKey"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.namespacedTagKey);
                            if (message.inherited != null && Object.hasOwnProperty.call(message, "inherited"))
                                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.inherited);
                            if (message.tagKeyParentName != null && Object.hasOwnProperty.call(message, "tagKeyParentName"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.tagKeyParentName);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified EffectiveTag message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.EffectiveTag.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IEffectiveTag} message EffectiveTag message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EffectiveTag.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an EffectiveTag message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.EffectiveTag} EffectiveTag
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EffectiveTag.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.EffectiveTag();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.tagValue = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.namespacedTagValue = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.tagKey = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.namespacedTagKey = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.tagKeyParentName = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.inherited = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an EffectiveTag message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.EffectiveTag} EffectiveTag
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EffectiveTag.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an EffectiveTag message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EffectiveTag.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tagValue != null && message.hasOwnProperty("tagValue"))
                                if (!$util.isString(message.tagValue))
                                    return "tagValue: string expected";
                            if (message.namespacedTagValue != null && message.hasOwnProperty("namespacedTagValue"))
                                if (!$util.isString(message.namespacedTagValue))
                                    return "namespacedTagValue: string expected";
                            if (message.tagKey != null && message.hasOwnProperty("tagKey"))
                                if (!$util.isString(message.tagKey))
                                    return "tagKey: string expected";
                            if (message.namespacedTagKey != null && message.hasOwnProperty("namespacedTagKey"))
                                if (!$util.isString(message.namespacedTagKey))
                                    return "namespacedTagKey: string expected";
                            if (message.tagKeyParentName != null && message.hasOwnProperty("tagKeyParentName"))
                                if (!$util.isString(message.tagKeyParentName))
                                    return "tagKeyParentName: string expected";
                            if (message.inherited != null && message.hasOwnProperty("inherited"))
                                if (typeof message.inherited !== "boolean")
                                    return "inherited: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an EffectiveTag message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.EffectiveTag} EffectiveTag
                         */
                        EffectiveTag.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.EffectiveTag)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.EffectiveTag();
                            if (object.tagValue != null)
                                message.tagValue = String(object.tagValue);
                            if (object.namespacedTagValue != null)
                                message.namespacedTagValue = String(object.namespacedTagValue);
                            if (object.tagKey != null)
                                message.tagKey = String(object.tagKey);
                            if (object.namespacedTagKey != null)
                                message.namespacedTagKey = String(object.namespacedTagKey);
                            if (object.tagKeyParentName != null)
                                message.tagKeyParentName = String(object.tagKeyParentName);
                            if (object.inherited != null)
                                message.inherited = Boolean(object.inherited);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an EffectiveTag message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {google.cloud.resourcemanager.v3.EffectiveTag} message EffectiveTag
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EffectiveTag.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.tagValue = "";
                                object.namespacedTagValue = "";
                                object.tagKey = "";
                                object.namespacedTagKey = "";
                                object.inherited = false;
                                object.tagKeyParentName = "";
                            }
                            if (message.tagValue != null && message.hasOwnProperty("tagValue"))
                                object.tagValue = message.tagValue;
                            if (message.namespacedTagValue != null && message.hasOwnProperty("namespacedTagValue"))
                                object.namespacedTagValue = message.namespacedTagValue;
                            if (message.tagKey != null && message.hasOwnProperty("tagKey"))
                                object.tagKey = message.tagKey;
                            if (message.namespacedTagKey != null && message.hasOwnProperty("namespacedTagKey"))
                                object.namespacedTagKey = message.namespacedTagKey;
                            if (message.inherited != null && message.hasOwnProperty("inherited"))
                                object.inherited = message.inherited;
                            if (message.tagKeyParentName != null && message.hasOwnProperty("tagKeyParentName"))
                                object.tagKeyParentName = message.tagKeyParentName;
                            return object;
                        };
    
                        /**
                         * Converts this EffectiveTag to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EffectiveTag.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for EffectiveTag
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.EffectiveTag
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        EffectiveTag.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.EffectiveTag";
                        };
    
                        return EffectiveTag;
                    })();
    
                    v3.TagHolds = (function() {
    
                        /**
                         * Constructs a new TagHolds service.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a TagHolds
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function TagHolds(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (TagHolds.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = TagHolds;
    
                        /**
                         * Creates new TagHolds service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {TagHolds} RPC service. Useful where requests and/or responses are streamed.
                         */
                        TagHolds.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagHolds|createTagHold}.
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @typedef CreateTagHoldCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateTagHold.
                         * @function createTagHold
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldRequest} request CreateTagHoldRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagHolds.CreateTagHoldCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagHolds.prototype.createTagHold = function createTagHold(request, callback) {
                            return this.rpcCall(createTagHold, $root.google.cloud.resourcemanager.v3.CreateTagHoldRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateTagHold" });
    
                        /**
                         * Calls CreateTagHold.
                         * @function createTagHold
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldRequest} request CreateTagHoldRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagHolds|deleteTagHold}.
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @typedef DeleteTagHoldCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteTagHold.
                         * @function deleteTagHold
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldRequest} request DeleteTagHoldRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagHolds.DeleteTagHoldCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagHolds.prototype.deleteTagHold = function deleteTagHold(request, callback) {
                            return this.rpcCall(deleteTagHold, $root.google.cloud.resourcemanager.v3.DeleteTagHoldRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteTagHold" });
    
                        /**
                         * Calls DeleteTagHold.
                         * @function deleteTagHold
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldRequest} request DeleteTagHoldRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagHolds|listTagHolds}.
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @typedef ListTagHoldsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.ListTagHoldsResponse} [response] ListTagHoldsResponse
                         */
    
                        /**
                         * Calls ListTagHolds.
                         * @function listTagHolds
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsRequest} request ListTagHoldsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagHolds.ListTagHoldsCallback} callback Node-style callback called with the error, if any, and ListTagHoldsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagHolds.prototype.listTagHolds = function listTagHolds(request, callback) {
                            return this.rpcCall(listTagHolds, $root.google.cloud.resourcemanager.v3.ListTagHoldsRequest, $root.google.cloud.resourcemanager.v3.ListTagHoldsResponse, request, callback);
                        }, "name", { value: "ListTagHolds" });
    
                        /**
                         * Calls ListTagHolds.
                         * @function listTagHolds
                         * @memberof google.cloud.resourcemanager.v3.TagHolds
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsRequest} request ListTagHoldsRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.ListTagHoldsResponse>} Promise
                         * @variation 2
                         */
    
                        return TagHolds;
                    })();
    
                    v3.TagHold = (function() {
    
                        /**
                         * Properties of a TagHold.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ITagHold
                         * @property {string|null} [name] TagHold name
                         * @property {string|null} [holder] TagHold holder
                         * @property {string|null} [origin] TagHold origin
                         * @property {string|null} [helpLink] TagHold helpLink
                         * @property {google.protobuf.ITimestamp|null} [createTime] TagHold createTime
                         */
    
                        /**
                         * Constructs a new TagHold.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a TagHold.
                         * @implements ITagHold
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ITagHold=} [properties] Properties to set
                         */
                        function TagHold(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TagHold name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @instance
                         */
                        TagHold.prototype.name = "";
    
                        /**
                         * TagHold holder.
                         * @member {string} holder
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @instance
                         */
                        TagHold.prototype.holder = "";
    
                        /**
                         * TagHold origin.
                         * @member {string} origin
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @instance
                         */
                        TagHold.prototype.origin = "";
    
                        /**
                         * TagHold helpLink.
                         * @member {string} helpLink
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @instance
                         */
                        TagHold.prototype.helpLink = "";
    
                        /**
                         * TagHold createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @instance
                         */
                        TagHold.prototype.createTime = null;
    
                        /**
                         * Creates a new TagHold instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagHold=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.TagHold} TagHold instance
                         */
                        TagHold.create = function create(properties) {
                            return new TagHold(properties);
                        };
    
                        /**
                         * Encodes the specified TagHold message. Does not implicitly {@link google.cloud.resourcemanager.v3.TagHold.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagHold} message TagHold message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TagHold.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.holder != null && Object.hasOwnProperty.call(message, "holder"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.holder);
                            if (message.origin != null && Object.hasOwnProperty.call(message, "origin"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.origin);
                            if (message.helpLink != null && Object.hasOwnProperty.call(message, "helpLink"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.helpLink);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TagHold message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.TagHold.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagHold} message TagHold message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TagHold.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TagHold message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.TagHold} TagHold
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TagHold.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.TagHold();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.holder = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.origin = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.helpLink = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TagHold message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.TagHold} TagHold
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TagHold.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TagHold message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TagHold.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.holder != null && message.hasOwnProperty("holder"))
                                if (!$util.isString(message.holder))
                                    return "holder: string expected";
                            if (message.origin != null && message.hasOwnProperty("origin"))
                                if (!$util.isString(message.origin))
                                    return "origin: string expected";
                            if (message.helpLink != null && message.hasOwnProperty("helpLink"))
                                if (!$util.isString(message.helpLink))
                                    return "helpLink: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a TagHold message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.TagHold} TagHold
                         */
                        TagHold.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.TagHold)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.TagHold();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.holder != null)
                                message.holder = String(object.holder);
                            if (object.origin != null)
                                message.origin = String(object.origin);
                            if (object.helpLink != null)
                                message.helpLink = String(object.helpLink);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.TagHold.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TagHold message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {google.cloud.resourcemanager.v3.TagHold} message TagHold
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TagHold.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.holder = "";
                                object.origin = "";
                                object.helpLink = "";
                                object.createTime = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.holder != null && message.hasOwnProperty("holder"))
                                object.holder = message.holder;
                            if (message.origin != null && message.hasOwnProperty("origin"))
                                object.origin = message.origin;
                            if (message.helpLink != null && message.hasOwnProperty("helpLink"))
                                object.helpLink = message.helpLink;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            return object;
                        };
    
                        /**
                         * Converts this TagHold to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TagHold.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TagHold
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.TagHold
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TagHold.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.TagHold";
                        };
    
                        return TagHold;
                    })();
    
                    v3.CreateTagHoldRequest = (function() {
    
                        /**
                         * Properties of a CreateTagHoldRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateTagHoldRequest
                         * @property {string|null} [parent] CreateTagHoldRequest parent
                         * @property {google.cloud.resourcemanager.v3.ITagHold|null} [tagHold] CreateTagHoldRequest tagHold
                         * @property {boolean|null} [validateOnly] CreateTagHoldRequest validateOnly
                         */
    
                        /**
                         * Constructs a new CreateTagHoldRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateTagHoldRequest.
                         * @implements ICreateTagHoldRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldRequest=} [properties] Properties to set
                         */
                        function CreateTagHoldRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateTagHoldRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @instance
                         */
                        CreateTagHoldRequest.prototype.parent = "";
    
                        /**
                         * CreateTagHoldRequest tagHold.
                         * @member {google.cloud.resourcemanager.v3.ITagHold|null|undefined} tagHold
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @instance
                         */
                        CreateTagHoldRequest.prototype.tagHold = null;
    
                        /**
                         * CreateTagHoldRequest validateOnly.
                         * @member {boolean} validateOnly
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @instance
                         */
                        CreateTagHoldRequest.prototype.validateOnly = false;
    
                        /**
                         * Creates a new CreateTagHoldRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldRequest} CreateTagHoldRequest instance
                         */
                        CreateTagHoldRequest.create = function create(properties) {
                            return new CreateTagHoldRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateTagHoldRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagHoldRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldRequest} message CreateTagHoldRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagHoldRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.tagHold != null && Object.hasOwnProperty.call(message, "tagHold"))
                                $root.google.cloud.resourcemanager.v3.TagHold.encode(message.tagHold, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.validateOnly != null && Object.hasOwnProperty.call(message, "validateOnly"))
                                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.validateOnly);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateTagHoldRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagHoldRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldRequest} message CreateTagHoldRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagHoldRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateTagHoldRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldRequest} CreateTagHoldRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagHoldRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateTagHoldRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.tagHold = $root.google.cloud.resourcemanager.v3.TagHold.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.validateOnly = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateTagHoldRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldRequest} CreateTagHoldRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagHoldRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateTagHoldRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateTagHoldRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.tagHold != null && message.hasOwnProperty("tagHold")) {
                                var error = $root.google.cloud.resourcemanager.v3.TagHold.verify(message.tagHold);
                                if (error)
                                    return "tagHold." + error;
                            }
                            if (message.validateOnly != null && message.hasOwnProperty("validateOnly"))
                                if (typeof message.validateOnly !== "boolean")
                                    return "validateOnly: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a CreateTagHoldRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldRequest} CreateTagHoldRequest
                         */
                        CreateTagHoldRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateTagHoldRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.CreateTagHoldRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.tagHold != null) {
                                if (typeof object.tagHold !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.CreateTagHoldRequest.tagHold: object expected");
                                message.tagHold = $root.google.cloud.resourcemanager.v3.TagHold.fromObject(object.tagHold);
                            }
                            if (object.validateOnly != null)
                                message.validateOnly = Boolean(object.validateOnly);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateTagHoldRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateTagHoldRequest} message CreateTagHoldRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateTagHoldRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.tagHold = null;
                                object.validateOnly = false;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.tagHold != null && message.hasOwnProperty("tagHold"))
                                object.tagHold = $root.google.cloud.resourcemanager.v3.TagHold.toObject(message.tagHold, options);
                            if (message.validateOnly != null && message.hasOwnProperty("validateOnly"))
                                object.validateOnly = message.validateOnly;
                            return object;
                        };
    
                        /**
                         * Converts this CreateTagHoldRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateTagHoldRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateTagHoldRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateTagHoldRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateTagHoldRequest";
                        };
    
                        return CreateTagHoldRequest;
                    })();
    
                    v3.CreateTagHoldMetadata = (function() {
    
                        /**
                         * Properties of a CreateTagHoldMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateTagHoldMetadata
                         */
    
                        /**
                         * Constructs a new CreateTagHoldMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateTagHoldMetadata.
                         * @implements ICreateTagHoldMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldMetadata=} [properties] Properties to set
                         */
                        function CreateTagHoldMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new CreateTagHoldMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldMetadata} CreateTagHoldMetadata instance
                         */
                        CreateTagHoldMetadata.create = function create(properties) {
                            return new CreateTagHoldMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CreateTagHoldMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagHoldMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldMetadata} message CreateTagHoldMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagHoldMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateTagHoldMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagHoldMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagHoldMetadata} message CreateTagHoldMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagHoldMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateTagHoldMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldMetadata} CreateTagHoldMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagHoldMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.CreateTagHoldMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateTagHoldMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldMetadata} CreateTagHoldMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateTagHoldMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateTagHoldMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateTagHoldMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a CreateTagHoldMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.CreateTagHoldMetadata} CreateTagHoldMetadata
                         */
                        CreateTagHoldMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.CreateTagHoldMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.CreateTagHoldMetadata();
                        };
    
                        /**
                         * Creates a plain object from a CreateTagHoldMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.CreateTagHoldMetadata} message CreateTagHoldMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateTagHoldMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this CreateTagHoldMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateTagHoldMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateTagHoldMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.CreateTagHoldMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateTagHoldMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.CreateTagHoldMetadata";
                        };
    
                        return CreateTagHoldMetadata;
                    })();
    
                    v3.DeleteTagHoldRequest = (function() {
    
                        /**
                         * Properties of a DeleteTagHoldRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteTagHoldRequest
                         * @property {string|null} [name] DeleteTagHoldRequest name
                         * @property {boolean|null} [validateOnly] DeleteTagHoldRequest validateOnly
                         */
    
                        /**
                         * Constructs a new DeleteTagHoldRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteTagHoldRequest.
                         * @implements IDeleteTagHoldRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldRequest=} [properties] Properties to set
                         */
                        function DeleteTagHoldRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteTagHoldRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @instance
                         */
                        DeleteTagHoldRequest.prototype.name = "";
    
                        /**
                         * DeleteTagHoldRequest validateOnly.
                         * @member {boolean} validateOnly
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @instance
                         */
                        DeleteTagHoldRequest.prototype.validateOnly = false;
    
                        /**
                         * Creates a new DeleteTagHoldRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldRequest} DeleteTagHoldRequest instance
                         */
                        DeleteTagHoldRequest.create = function create(properties) {
                            return new DeleteTagHoldRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteTagHoldRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagHoldRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldRequest} message DeleteTagHoldRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagHoldRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.validateOnly != null && Object.hasOwnProperty.call(message, "validateOnly"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.validateOnly);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteTagHoldRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagHoldRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldRequest} message DeleteTagHoldRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagHoldRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteTagHoldRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldRequest} DeleteTagHoldRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagHoldRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteTagHoldRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.validateOnly = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteTagHoldRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldRequest} DeleteTagHoldRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagHoldRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteTagHoldRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteTagHoldRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.validateOnly != null && message.hasOwnProperty("validateOnly"))
                                if (typeof message.validateOnly !== "boolean")
                                    return "validateOnly: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteTagHoldRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldRequest} DeleteTagHoldRequest
                         */
                        DeleteTagHoldRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteTagHoldRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.DeleteTagHoldRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.validateOnly != null)
                                message.validateOnly = Boolean(object.validateOnly);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteTagHoldRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteTagHoldRequest} message DeleteTagHoldRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteTagHoldRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.validateOnly = false;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.validateOnly != null && message.hasOwnProperty("validateOnly"))
                                object.validateOnly = message.validateOnly;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteTagHoldRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteTagHoldRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteTagHoldRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteTagHoldRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteTagHoldRequest";
                        };
    
                        return DeleteTagHoldRequest;
                    })();
    
                    v3.DeleteTagHoldMetadata = (function() {
    
                        /**
                         * Properties of a DeleteTagHoldMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IDeleteTagHoldMetadata
                         */
    
                        /**
                         * Constructs a new DeleteTagHoldMetadata.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a DeleteTagHoldMetadata.
                         * @implements IDeleteTagHoldMetadata
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldMetadata=} [properties] Properties to set
                         */
                        function DeleteTagHoldMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new DeleteTagHoldMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldMetadata=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldMetadata} DeleteTagHoldMetadata instance
                         */
                        DeleteTagHoldMetadata.create = function create(properties) {
                            return new DeleteTagHoldMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteTagHoldMetadata message. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagHoldMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldMetadata} message DeleteTagHoldMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagHoldMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteTagHoldMetadata message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.DeleteTagHoldMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagHoldMetadata} message DeleteTagHoldMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteTagHoldMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteTagHoldMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldMetadata} DeleteTagHoldMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagHoldMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.DeleteTagHoldMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteTagHoldMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldMetadata} DeleteTagHoldMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteTagHoldMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteTagHoldMetadata message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteTagHoldMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteTagHoldMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.DeleteTagHoldMetadata} DeleteTagHoldMetadata
                         */
                        DeleteTagHoldMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.DeleteTagHoldMetadata)
                                return object;
                            return new $root.google.cloud.resourcemanager.v3.DeleteTagHoldMetadata();
                        };
    
                        /**
                         * Creates a plain object from a DeleteTagHoldMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {google.cloud.resourcemanager.v3.DeleteTagHoldMetadata} message DeleteTagHoldMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteTagHoldMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this DeleteTagHoldMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteTagHoldMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteTagHoldMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.DeleteTagHoldMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteTagHoldMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.DeleteTagHoldMetadata";
                        };
    
                        return DeleteTagHoldMetadata;
                    })();
    
                    v3.ListTagHoldsRequest = (function() {
    
                        /**
                         * Properties of a ListTagHoldsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListTagHoldsRequest
                         * @property {string|null} [parent] ListTagHoldsRequest parent
                         * @property {number|null} [pageSize] ListTagHoldsRequest pageSize
                         * @property {string|null} [pageToken] ListTagHoldsRequest pageToken
                         * @property {string|null} [filter] ListTagHoldsRequest filter
                         */
    
                        /**
                         * Constructs a new ListTagHoldsRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListTagHoldsRequest.
                         * @implements IListTagHoldsRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsRequest=} [properties] Properties to set
                         */
                        function ListTagHoldsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListTagHoldsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @instance
                         */
                        ListTagHoldsRequest.prototype.parent = "";
    
                        /**
                         * ListTagHoldsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @instance
                         */
                        ListTagHoldsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListTagHoldsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @instance
                         */
                        ListTagHoldsRequest.prototype.pageToken = "";
    
                        /**
                         * ListTagHoldsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @instance
                         */
                        ListTagHoldsRequest.prototype.filter = "";
    
                        /**
                         * Creates a new ListTagHoldsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsRequest} ListTagHoldsRequest instance
                         */
                        ListTagHoldsRequest.create = function create(properties) {
                            return new ListTagHoldsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListTagHoldsRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagHoldsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsRequest} message ListTagHoldsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagHoldsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListTagHoldsRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagHoldsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsRequest} message ListTagHoldsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagHoldsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListTagHoldsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsRequest} ListTagHoldsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagHoldsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListTagHoldsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListTagHoldsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsRequest} ListTagHoldsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagHoldsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListTagHoldsRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListTagHoldsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListTagHoldsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsRequest} ListTagHoldsRequest
                         */
                        ListTagHoldsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListTagHoldsRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListTagHoldsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListTagHoldsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListTagHoldsRequest} message ListTagHoldsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListTagHoldsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            return object;
                        };
    
                        /**
                         * Converts this ListTagHoldsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListTagHoldsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListTagHoldsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListTagHoldsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListTagHoldsRequest";
                        };
    
                        return ListTagHoldsRequest;
                    })();
    
                    v3.ListTagHoldsResponse = (function() {
    
                        /**
                         * Properties of a ListTagHoldsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListTagHoldsResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.ITagHold>|null} [tagHolds] ListTagHoldsResponse tagHolds
                         * @property {string|null} [nextPageToken] ListTagHoldsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListTagHoldsResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListTagHoldsResponse.
                         * @implements IListTagHoldsResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsResponse=} [properties] Properties to set
                         */
                        function ListTagHoldsResponse(properties) {
                            this.tagHolds = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListTagHoldsResponse tagHolds.
                         * @member {Array.<google.cloud.resourcemanager.v3.ITagHold>} tagHolds
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @instance
                         */
                        ListTagHoldsResponse.prototype.tagHolds = $util.emptyArray;
    
                        /**
                         * ListTagHoldsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @instance
                         */
                        ListTagHoldsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListTagHoldsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsResponse} ListTagHoldsResponse instance
                         */
                        ListTagHoldsResponse.create = function create(properties) {
                            return new ListTagHoldsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListTagHoldsResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagHoldsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsResponse} message ListTagHoldsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagHoldsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tagHolds != null && message.tagHolds.length)
                                for (var i = 0; i < message.tagHolds.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.TagHold.encode(message.tagHolds[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListTagHoldsResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagHoldsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagHoldsResponse} message ListTagHoldsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagHoldsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListTagHoldsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsResponse} ListTagHoldsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagHoldsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListTagHoldsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.tagHolds && message.tagHolds.length))
                                            message.tagHolds = [];
                                        message.tagHolds.push($root.google.cloud.resourcemanager.v3.TagHold.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListTagHoldsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsResponse} ListTagHoldsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagHoldsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListTagHoldsResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListTagHoldsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tagHolds != null && message.hasOwnProperty("tagHolds")) {
                                if (!Array.isArray(message.tagHolds))
                                    return "tagHolds: array expected";
                                for (var i = 0; i < message.tagHolds.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.TagHold.verify(message.tagHolds[i]);
                                    if (error)
                                        return "tagHolds." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListTagHoldsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListTagHoldsResponse} ListTagHoldsResponse
                         */
                        ListTagHoldsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListTagHoldsResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListTagHoldsResponse();
                            if (object.tagHolds) {
                                if (!Array.isArray(object.tagHolds))
                                    throw TypeError(".google.cloud.resourcemanager.v3.ListTagHoldsResponse.tagHolds: array expected");
                                message.tagHolds = [];
                                for (var i = 0; i < object.tagHolds.length; ++i) {
                                    if (typeof object.tagHolds[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.ListTagHoldsResponse.tagHolds: object expected");
                                    message.tagHolds[i] = $root.google.cloud.resourcemanager.v3.TagHold.fromObject(object.tagHolds[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListTagHoldsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListTagHoldsResponse} message ListTagHoldsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListTagHoldsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.tagHolds = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.tagHolds && message.tagHolds.length) {
                                object.tagHolds = [];
                                for (var j = 0; j < message.tagHolds.length; ++j)
                                    object.tagHolds[j] = $root.google.cloud.resourcemanager.v3.TagHold.toObject(message.tagHolds[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListTagHoldsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListTagHoldsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListTagHoldsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListTagHoldsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListTagHoldsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListTagHoldsResponse";
                        };
    
                        return ListTagHoldsResponse;
                    })();
    
                    v3.TagKeys = (function() {
    
                        /**
                         * Constructs a new TagKeys service.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a TagKeys
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function TagKeys(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (TagKeys.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = TagKeys;
    
                        /**
                         * Creates new TagKeys service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {TagKeys} RPC service. Useful where requests and/or responses are streamed.
                         */
                        TagKeys.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|listTagKeys}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef ListTagKeysCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.ListTagKeysResponse} [response] ListTagKeysResponse
                         */
    
                        /**
                         * Calls ListTagKeys.
                         * @function listTagKeys
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysRequest} request ListTagKeysRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.ListTagKeysCallback} callback Node-style callback called with the error, if any, and ListTagKeysResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.listTagKeys = function listTagKeys(request, callback) {
                            return this.rpcCall(listTagKeys, $root.google.cloud.resourcemanager.v3.ListTagKeysRequest, $root.google.cloud.resourcemanager.v3.ListTagKeysResponse, request, callback);
                        }, "name", { value: "ListTagKeys" });
    
                        /**
                         * Calls ListTagKeys.
                         * @function listTagKeys
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysRequest} request ListTagKeysRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.ListTagKeysResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|getTagKey}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef GetTagKeyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.TagKey} [response] TagKey
                         */
    
                        /**
                         * Calls GetTagKey.
                         * @function getTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetTagKeyRequest} request GetTagKeyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.GetTagKeyCallback} callback Node-style callback called with the error, if any, and TagKey
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.getTagKey = function getTagKey(request, callback) {
                            return this.rpcCall(getTagKey, $root.google.cloud.resourcemanager.v3.GetTagKeyRequest, $root.google.cloud.resourcemanager.v3.TagKey, request, callback);
                        }, "name", { value: "GetTagKey" });
    
                        /**
                         * Calls GetTagKey.
                         * @function getTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetTagKeyRequest} request GetTagKeyRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.TagKey>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|getNamespacedTagKey}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef GetNamespacedTagKeyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.resourcemanager.v3.TagKey} [response] TagKey
                         */
    
                        /**
                         * Calls GetNamespacedTagKey.
                         * @function getNamespacedTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetNamespacedTagKeyRequest} request GetNamespacedTagKeyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.GetNamespacedTagKeyCallback} callback Node-style callback called with the error, if any, and TagKey
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.getNamespacedTagKey = function getNamespacedTagKey(request, callback) {
                            return this.rpcCall(getNamespacedTagKey, $root.google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest, $root.google.cloud.resourcemanager.v3.TagKey, request, callback);
                        }, "name", { value: "GetNamespacedTagKey" });
    
                        /**
                         * Calls GetNamespacedTagKey.
                         * @function getNamespacedTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IGetNamespacedTagKeyRequest} request GetNamespacedTagKeyRequest message or plain object
                         * @returns {Promise<google.cloud.resourcemanager.v3.TagKey>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|createTagKey}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef CreateTagKeyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateTagKey.
                         * @function createTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateTagKeyRequest} request CreateTagKeyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.CreateTagKeyCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.createTagKey = function createTagKey(request, callback) {
                            return this.rpcCall(createTagKey, $root.google.cloud.resourcemanager.v3.CreateTagKeyRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateTagKey" });
    
                        /**
                         * Calls CreateTagKey.
                         * @function createTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.ICreateTagKeyRequest} request CreateTagKeyRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|updateTagKey}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef UpdateTagKeyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateTagKey.
                         * @function updateTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUpdateTagKeyRequest} request UpdateTagKeyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.UpdateTagKeyCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.updateTagKey = function updateTagKey(request, callback) {
                            return this.rpcCall(updateTagKey, $root.google.cloud.resourcemanager.v3.UpdateTagKeyRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateTagKey" });
    
                        /**
                         * Calls UpdateTagKey.
                         * @function updateTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IUpdateTagKeyRequest} request UpdateTagKeyRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|deleteTagKey}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef DeleteTagKeyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteTagKey.
                         * @function deleteTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagKeyRequest} request DeleteTagKeyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.DeleteTagKeyCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.deleteTagKey = function deleteTagKey(request, callback) {
                            return this.rpcCall(deleteTagKey, $root.google.cloud.resourcemanager.v3.DeleteTagKeyRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteTagKey" });
    
                        /**
                         * Calls DeleteTagKey.
                         * @function deleteTagKey
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.cloud.resourcemanager.v3.IDeleteTagKeyRequest} request DeleteTagKeyRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|getIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef GetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.GetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.getIamPolicy = function getIamPolicy(request, callback) {
                            return this.rpcCall(getIamPolicy, $root.google.iam.v1.GetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "GetIamPolicy" });
    
                        /**
                         * Calls GetIamPolicy.
                         * @function getIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.iam.v1.IGetIamPolicyRequest} request GetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|setIamPolicy}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef SetIamPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.Policy} [response] Policy
                         */
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.SetIamPolicyCallback} callback Node-style callback called with the error, if any, and Policy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.setIamPolicy = function setIamPolicy(request, callback) {
                            return this.rpcCall(setIamPolicy, $root.google.iam.v1.SetIamPolicyRequest, $root.google.iam.v1.Policy, request, callback);
                        }, "name", { value: "SetIamPolicy" });
    
                        /**
                         * Calls SetIamPolicy.
                         * @function setIamPolicy
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.iam.v1.ISetIamPolicyRequest} request SetIamPolicyRequest message or plain object
                         * @returns {Promise<google.iam.v1.Policy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.resourcemanager.v3.TagKeys|testIamPermissions}.
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @typedef TestIamPermissionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.iam.v1.TestIamPermissionsResponse} [response] TestIamPermissionsResponse
                         */
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @param {google.cloud.resourcemanager.v3.TagKeys.TestIamPermissionsCallback} callback Node-style callback called with the error, if any, and TestIamPermissionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(TagKeys.prototype.testIamPermissions = function testIamPermissions(request, callback) {
                            return this.rpcCall(testIamPermissions, $root.google.iam.v1.TestIamPermissionsRequest, $root.google.iam.v1.TestIamPermissionsResponse, request, callback);
                        }, "name", { value: "TestIamPermissions" });
    
                        /**
                         * Calls TestIamPermissions.
                         * @function testIamPermissions
                         * @memberof google.cloud.resourcemanager.v3.TagKeys
                         * @instance
                         * @param {google.iam.v1.ITestIamPermissionsRequest} request TestIamPermissionsRequest message or plain object
                         * @returns {Promise<google.iam.v1.TestIamPermissionsResponse>} Promise
                         * @variation 2
                         */
    
                        return TagKeys;
                    })();
    
                    v3.TagKey = (function() {
    
                        /**
                         * Properties of a TagKey.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ITagKey
                         * @property {string|null} [name] TagKey name
                         * @property {string|null} [parent] TagKey parent
                         * @property {string|null} [shortName] TagKey shortName
                         * @property {string|null} [namespacedName] TagKey namespacedName
                         * @property {string|null} [description] TagKey description
                         * @property {google.protobuf.ITimestamp|null} [createTime] TagKey createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] TagKey updateTime
                         * @property {string|null} [etag] TagKey etag
                         * @property {google.cloud.resourcemanager.v3.Purpose|null} [purpose] TagKey purpose
                         * @property {Object.<string,string>|null} [purposeData] TagKey purposeData
                         */
    
                        /**
                         * Constructs a new TagKey.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a TagKey.
                         * @implements ITagKey
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ITagKey=} [properties] Properties to set
                         */
                        function TagKey(properties) {
                            this.purposeData = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TagKey name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.name = "";
    
                        /**
                         * TagKey parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.parent = "";
    
                        /**
                         * TagKey shortName.
                         * @member {string} shortName
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.shortName = "";
    
                        /**
                         * TagKey namespacedName.
                         * @member {string} namespacedName
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.namespacedName = "";
    
                        /**
                         * TagKey description.
                         * @member {string} description
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.description = "";
    
                        /**
                         * TagKey createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.createTime = null;
    
                        /**
                         * TagKey updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.updateTime = null;
    
                        /**
                         * TagKey etag.
                         * @member {string} etag
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.etag = "";
    
                        /**
                         * TagKey purpose.
                         * @member {google.cloud.resourcemanager.v3.Purpose} purpose
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.purpose = 0;
    
                        /**
                         * TagKey purposeData.
                         * @member {Object.<string,string>} purposeData
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         */
                        TagKey.prototype.purposeData = $util.emptyObject;
    
                        /**
                         * Creates a new TagKey instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagKey=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.TagKey} TagKey instance
                         */
                        TagKey.create = function create(properties) {
                            return new TagKey(properties);
                        };
    
                        /**
                         * Encodes the specified TagKey message. Does not implicitly {@link google.cloud.resourcemanager.v3.TagKey.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagKey} message TagKey message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TagKey.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parent);
                            if (message.shortName != null && Object.hasOwnProperty.call(message, "shortName"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.shortName);
                            if (message.namespacedName != null && Object.hasOwnProperty.call(message, "namespacedName"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.namespacedName);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.description);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.etag);
                            if (message.purpose != null && Object.hasOwnProperty.call(message, "purpose"))
                                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.purpose);
                            if (message.purposeData != null && Object.hasOwnProperty.call(message, "purposeData"))
                                for (var keys = Object.keys(message.purposeData), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 12, wireType 2 =*/98).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.purposeData[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TagKey message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.TagKey.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ITagKey} message TagKey message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TagKey.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TagKey message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.TagKey} TagKey
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TagKey.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.TagKey(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.shortName = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.namespacedName = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 11: {
                                        message.purpose = reader.int32();
                                        break;
                                    }
                                case 12: {
                                        if (message.purposeData === $util.emptyObject)
                                            message.purposeData = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.purposeData[key] = value;
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TagKey message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.TagKey} TagKey
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TagKey.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TagKey message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TagKey.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.shortName != null && message.hasOwnProperty("shortName"))
                                if (!$util.isString(message.shortName))
                                    return "shortName: string expected";
                            if (message.namespacedName != null && message.hasOwnProperty("namespacedName"))
                                if (!$util.isString(message.namespacedName))
                                    return "namespacedName: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.purpose != null && message.hasOwnProperty("purpose"))
                                switch (message.purpose) {
                                default:
                                    return "purpose: enum value expected";
                                case 0:
                                case 1:
                                    break;
                                }
                            if (message.purposeData != null && message.hasOwnProperty("purposeData")) {
                                if (!$util.isObject(message.purposeData))
                                    return "purposeData: object expected";
                                var key = Object.keys(message.purposeData);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.purposeData[key[i]]))
                                        return "purposeData: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a TagKey message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.TagKey} TagKey
                         */
                        TagKey.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.TagKey)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.TagKey();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.shortName != null)
                                message.shortName = String(object.shortName);
                            if (object.namespacedName != null)
                                message.namespacedName = String(object.namespacedName);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.TagKey.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.TagKey.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            switch (object.purpose) {
                            default:
                                if (typeof object.purpose === "number") {
                                    message.purpose = object.purpose;
                                    break;
                                }
                                break;
                            case "PURPOSE_UNSPECIFIED":
                            case 0:
                                message.purpose = 0;
                                break;
                            case "GCE_FIREWALL":
                            case 1:
                                message.purpose = 1;
                                break;
                            }
                            if (object.purposeData) {
                                if (typeof object.purposeData !== "object")
                                    throw TypeError(".google.cloud.resourcemanager.v3.TagKey.purposeData: object expected");
                                message.purposeData = {};
                                for (var keys = Object.keys(object.purposeData), i = 0; i < keys.length; ++i)
                                    message.purposeData[keys[i]] = String(object.purposeData[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TagKey message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {google.cloud.resourcemanager.v3.TagKey} message TagKey
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TagKey.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.purposeData = {};
                            if (options.defaults) {
                                object.name = "";
                                object.parent = "";
                                object.shortName = "";
                                object.namespacedName = "";
                                object.description = "";
                                object.createTime = null;
                                object.updateTime = null;
                                object.etag = "";
                                object.purpose = options.enums === String ? "PURPOSE_UNSPECIFIED" : 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.shortName != null && message.hasOwnProperty("shortName"))
                                object.shortName = message.shortName;
                            if (message.namespacedName != null && message.hasOwnProperty("namespacedName"))
                                object.namespacedName = message.namespacedName;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            if (message.purpose != null && message.hasOwnProperty("purpose"))
                                object.purpose = options.enums === String ? $root.google.cloud.resourcemanager.v3.Purpose[message.purpose] === undefined ? message.purpose : $root.google.cloud.resourcemanager.v3.Purpose[message.purpose] : message.purpose;
                            var keys2;
                            if (message.purposeData && (keys2 = Object.keys(message.purposeData)).length) {
                                object.purposeData = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.purposeData[keys2[j]] = message.purposeData[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this TagKey to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TagKey.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TagKey
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.TagKey
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TagKey.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.TagKey";
                        };
    
                        return TagKey;
                    })();
    
                    v3.ListTagKeysRequest = (function() {
    
                        /**
                         * Properties of a ListTagKeysRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListTagKeysRequest
                         * @property {string|null} [parent] ListTagKeysRequest parent
                         * @property {number|null} [pageSize] ListTagKeysRequest pageSize
                         * @property {string|null} [pageToken] ListTagKeysRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListTagKeysRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListTagKeysRequest.
                         * @implements IListTagKeysRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysRequest=} [properties] Properties to set
                         */
                        function ListTagKeysRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListTagKeysRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @instance
                         */
                        ListTagKeysRequest.prototype.parent = "";
    
                        /**
                         * ListTagKeysRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @instance
                         */
                        ListTagKeysRequest.prototype.pageSize = 0;
    
                        /**
                         * ListTagKeysRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @instance
                         */
                        ListTagKeysRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListTagKeysRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysRequest} ListTagKeysRequest instance
                         */
                        ListTagKeysRequest.create = function create(properties) {
                            return new ListTagKeysRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListTagKeysRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagKeysRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysRequest} message ListTagKeysRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagKeysRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListTagKeysRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagKeysRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysRequest} message ListTagKeysRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagKeysRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListTagKeysRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysRequest} ListTagKeysRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagKeysRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListTagKeysRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListTagKeysRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysRequest} ListTagKeysRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagKeysRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListTagKeysRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListTagKeysRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListTagKeysRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysRequest} ListTagKeysRequest
                         */
                        ListTagKeysRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListTagKeysRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListTagKeysRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListTagKeysRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListTagKeysRequest} message ListTagKeysRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListTagKeysRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListTagKeysRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListTagKeysRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListTagKeysRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListTagKeysRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListTagKeysRequest";
                        };
    
                        return ListTagKeysRequest;
                    })();
    
                    v3.ListTagKeysResponse = (function() {
    
                        /**
                         * Properties of a ListTagKeysResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IListTagKeysResponse
                         * @property {Array.<google.cloud.resourcemanager.v3.ITagKey>|null} [tagKeys] ListTagKeysResponse tagKeys
                         * @property {string|null} [nextPageToken] ListTagKeysResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListTagKeysResponse.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a ListTagKeysResponse.
                         * @implements IListTagKeysResponse
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysResponse=} [properties] Properties to set
                         */
                        function ListTagKeysResponse(properties) {
                            this.tagKeys = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListTagKeysResponse tagKeys.
                         * @member {Array.<google.cloud.resourcemanager.v3.ITagKey>} tagKeys
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @instance
                         */
                        ListTagKeysResponse.prototype.tagKeys = $util.emptyArray;
    
                        /**
                         * ListTagKeysResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @instance
                         */
                        ListTagKeysResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListTagKeysResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysResponse=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysResponse} ListTagKeysResponse instance
                         */
                        ListTagKeysResponse.create = function create(properties) {
                            return new ListTagKeysResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListTagKeysResponse message. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagKeysResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysResponse} message ListTagKeysResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagKeysResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tagKeys != null && message.tagKeys.length)
                                for (var i = 0; i < message.tagKeys.length; ++i)
                                    $root.google.cloud.resourcemanager.v3.TagKey.encode(message.tagKeys[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListTagKeysResponse message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.ListTagKeysResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IListTagKeysResponse} message ListTagKeysResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListTagKeysResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListTagKeysResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysResponse} ListTagKeysResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagKeysResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.ListTagKeysResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.tagKeys && message.tagKeys.length))
                                            message.tagKeys = [];
                                        message.tagKeys.push($root.google.cloud.resourcemanager.v3.TagKey.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListTagKeysResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysResponse} ListTagKeysResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListTagKeysResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListTagKeysResponse message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListTagKeysResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tagKeys != null && message.hasOwnProperty("tagKeys")) {
                                if (!Array.isArray(message.tagKeys))
                                    return "tagKeys: array expected";
                                for (var i = 0; i < message.tagKeys.length; ++i) {
                                    var error = $root.google.cloud.resourcemanager.v3.TagKey.verify(message.tagKeys[i]);
                                    if (error)
                                        return "tagKeys." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListTagKeysResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.ListTagKeysResponse} ListTagKeysResponse
                         */
                        ListTagKeysResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.ListTagKeysResponse)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.ListTagKeysResponse();
                            if (object.tagKeys) {
                                if (!Array.isArray(object.tagKeys))
                                    throw TypeError(".google.cloud.resourcemanager.v3.ListTagKeysResponse.tagKeys: array expected");
                                message.tagKeys = [];
                                for (var i = 0; i < object.tagKeys.length; ++i) {
                                    if (typeof object.tagKeys[i] !== "object")
                                        throw TypeError(".google.cloud.resourcemanager.v3.ListTagKeysResponse.tagKeys: object expected");
                                    message.tagKeys[i] = $root.google.cloud.resourcemanager.v3.TagKey.fromObject(object.tagKeys[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListTagKeysResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ListTagKeysResponse} message ListTagKeysResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListTagKeysResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.tagKeys = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.tagKeys && message.tagKeys.length) {
                                object.tagKeys = [];
                                for (var j = 0; j < message.tagKeys.length; ++j)
                                    object.tagKeys[j] = $root.google.cloud.resourcemanager.v3.TagKey.toObject(message.tagKeys[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListTagKeysResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListTagKeysResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListTagKeysResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.ListTagKeysResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListTagKeysResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.ListTagKeysResponse";
                        };
    
                        return ListTagKeysResponse;
                    })();
    
                    v3.GetTagKeyRequest = (function() {
    
                        /**
                         * Properties of a GetTagKeyRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IGetTagKeyRequest
                         * @property {string|null} [name] GetTagKeyRequest name
                         */
    
                        /**
                         * Constructs a new GetTagKeyRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a GetTagKeyRequest.
                         * @implements IGetTagKeyRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IGetTagKeyRequest=} [properties] Properties to set
                         */
                        function GetTagKeyRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetTagKeyRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @instance
                         */
                        GetTagKeyRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetTagKeyRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetTagKeyRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.GetTagKeyRequest} GetTagKeyRequest instance
                         */
                        GetTagKeyRequest.create = function create(properties) {
                            return new GetTagKeyRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetTagKeyRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.GetTagKeyRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetTagKeyRequest} message GetTagKeyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetTagKeyRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetTagKeyRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.GetTagKeyRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetTagKeyRequest} message GetTagKeyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetTagKeyRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetTagKeyRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.GetTagKeyRequest} GetTagKeyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetTagKeyRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.GetTagKeyRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetTagKeyRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.GetTagKeyRequest} GetTagKeyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetTagKeyRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetTagKeyRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetTagKeyRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetTagKeyRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.GetTagKeyRequest} GetTagKeyRequest
                         */
                        GetTagKeyRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.GetTagKeyRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.GetTagKeyRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetTagKeyRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.GetTagKeyRequest} message GetTagKeyRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetTagKeyRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetTagKeyRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetTagKeyRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetTagKeyRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.GetTagKeyRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetTagKeyRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.GetTagKeyRequest";
                        };
    
                        return GetTagKeyRequest;
                    })();
    
                    v3.GetNamespacedTagKeyRequest = (function() {
    
                        /**
                         * Properties of a GetNamespacedTagKeyRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface IGetNamespacedTagKeyRequest
                         * @property {string|null} [name] GetNamespacedTagKeyRequest name
                         */
    
                        /**
                         * Constructs a new GetNamespacedTagKeyRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a GetNamespacedTagKeyRequest.
                         * @implements IGetNamespacedTagKeyRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.IGetNamespacedTagKeyRequest=} [properties] Properties to set
                         */
                        function GetNamespacedTagKeyRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetNamespacedTagKeyRequest name.
                         * @member {string} name
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @instance
                         */
                        GetNamespacedTagKeyRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetNamespacedTagKeyRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetNamespacedTagKeyRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest} GetNamespacedTagKeyRequest instance
                         */
                        GetNamespacedTagKeyRequest.create = function create(properties) {
                            return new GetNamespacedTagKeyRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetNamespacedTagKeyRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetNamespacedTagKeyRequest} message GetNamespacedTagKeyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetNamespacedTagKeyRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetNamespacedTagKeyRequest message, length delimited. Does not implicitly {@link google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.IGetNamespacedTagKeyRequest} message GetNamespacedTagKeyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetNamespacedTagKeyRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetNamespacedTagKeyRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest} GetNamespacedTagKeyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetNamespacedTagKeyRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetNamespacedTagKeyRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest} GetNamespacedTagKeyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetNamespacedTagKeyRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetNamespacedTagKeyRequest message.
                         * @function verify
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetNamespacedTagKeyRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetNamespacedTagKeyRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest} GetNamespacedTagKeyRequest
                         */
                        GetNamespacedTagKeyRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest)
                                return object;
                            var message = new $root.google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetNamespacedTagKeyRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest} message GetNamespacedTagKeyRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetNamespacedTagKeyRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetNamespacedTagKeyRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetNamespacedTagKeyRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetNamespacedTagKeyRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetNamespacedTagKeyRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest";
                        };
    
                        return GetNamespacedTagKeyRequest;
                    })();
    
                    v3.CreateTagKeyRequest = (function() {
    
                        /**
                         * Properties of a CreateTagKeyRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @interface ICreateTagKeyRequest
                         * @property {google.cloud.resourcemanager.v3.ITagKey|null} [tagKey] CreateTagKeyRequest tagKey
                         * @property {boolean|null} [validateOnly] CreateTagKeyRequest validateOnly
                         */
    
                        /**
                         * Constructs a new CreateTagKeyRequest.
                         * @memberof google.cloud.resourcemanager.v3
                         * @classdesc Represents a CreateTagKeyRequest.
                         * @implements ICreateTagKeyRequest
                         * @constructor
                         * @param {google.cloud.resourcemanager.v3.ICreateTagKeyRequest=} [properties] Properties to set
                         */
                        function CreateTagKeyRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateTagKeyRequest tagKey.
                         * @member {google.cloud.resourcemanager.v3.ITagKey|null|undefined} tagKey
                         * @memberof google.cloud.resourcemanager.v3.CreateTagKeyRequest
                         * @instance
                         */
                        CreateTagKeyRequest.prototype.tagKey = null;
    
                        /**
                         * CreateTagKeyRequest validateOnly.
                         * @member {boolean} validateOnly
                         * @memberof google.cloud.resourcemanager.v3.CreateTagKeyRequest
                         * @instance
                         */
                        CreateTagKeyRequest.prototype.validateOnly = false;
    
                        /**
                         * Creates a new CreateTagKeyRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.resourcemanager.v3.CreateTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagKeyRequest=} [properties] Properties to set
                         * @returns {google.cloud.resourcemanager.v3.CreateTagKeyRequest} CreateTagKeyRequest instance
                         */
                        CreateTagKeyRequest.create = function create(properties) {
                            return new CreateTagKeyRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateTagKeyRequest message. Does not implicitly {@link google.cloud.resourcemanager.v3.CreateTagKeyRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.resourcemanager.v3.CreateTagKeyRequest
                         * @static
                         * @param {google.cloud.resourcemanager.v3.ICreateTagKeyRequest} message CreateTagKeyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateTagKeyRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tagKey != null && Object.hasOwnProperty.call(message, "tagKey"))
                                $root.google.cloud.resourcemanager.v3.TagKey.encode(message.tagKey, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.validateOnly != null && Object.hasOwnProperty.call(message, "validateOnly"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.validateOnly);
                            return writer;
                        };
