import type * as gax from 'google-gax';
import type { Callback, CallOptions, Descriptors, ClientOptions } from 'google-gax';
import * as protos from '../../protos/protos';
/**
 *  API for using Large Models that generate multimodal content and have
 *  additional capabilities beyond text generation.
 * @class
 * @memberof v1
 */
export declare class GenerativeServiceClient {
    private _terminated;
    private _opts;
    private _providedCustomServicePath;
    private _gaxModule;
    private _gaxGrpc;
    private _protos;
    private _defaults;
    private _universeDomain;
    private _servicePath;
    auth: gax.GoogleAuth;
    descriptors: Descriptors;
    warn: (code: string, message: string, warnType?: string) => void;
    innerApiCalls: {
        [name: string]: Function;
    };
    pathTemplates: {
        [name: string]: gax.PathTemplate;
    };
    generativeServiceStub?: Promise<{
        [name: string]: Function;
    }>;
    /**
     * Construct an instance of GenerativeServiceClient.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP/1.1 REST mode.
     *     For more information, please check the
     *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
     * @param {gax} [gaxInstance]: loaded instance of `google-gax`. Useful if you
     *     need to avoid loading the default gRPC version and want to use the fallback
     *     HTTP implementation. Load only fallback version and pass it to the constructor:
     *     ```
     *     const gax = require('google-gax/build/src/fallback'); // avoids loading google-gax with gRPC
     *     const client = new GenerativeServiceClient({fallback: true}, gax);
     *     ```
     */
    constructor(opts?: ClientOptions, gaxInstance?: typeof gax | typeof gax.fallback);
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize(): Promise<{
        [name: string]: Function;
    }>;
    /**
     * The DNS address for this API service.
     * @deprecated Use the apiEndpoint method of the client instance.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath(): string;
    /**
     * The DNS address for this API service - same as servicePath.
     * @deprecated Use the apiEndpoint method of the client instance.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint(): string;
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    get apiEndpoint(): string;
    get universeDomain(): string;
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port(): number;
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes(): never[];
    getProjectId(): Promise<string>;
    getProjectId(callback: Callback<string, undefined, undefined>): void;
    /**
     * Generates a response from the model given an input
     * `GenerateContentRequest`.
     *
     * Input capabilities differ between models, including tuned models. See the
     * [model guide](https://ai.google.dev/models/gemini) and
     * [tuning guide](https://ai.google.dev/docs/model_tuning_guidance) for
     * details.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.model
     *   Required. The name of the `Model` to use for generating the completion.
     *
     *   Format: `name=models/{model}`.
     * @param {number[]} request.contents
     *   Required. The content of the current conversation with the model.
     *
     *   For single-turn queries, this is a single instance. For multi-turn queries,
     *   this is a repeated field that contains conversation history + latest
     *   request.
     * @param {number[]} [request.safetySettings]
     *   Optional. A list of unique `SafetySetting` instances for blocking unsafe
     *   content.
     *
     *   This will be enforced on the `GenerateContentRequest.contents` and
     *   `GenerateContentResponse.candidates`. There should not be more than one
     *   setting for each `SafetyCategory` type. The API will block any contents and
     *   responses that fail to meet the thresholds set by these settings. This list
     *   overrides the default settings for each `SafetyCategory` specified in the
     *   safety_settings. If there is no `SafetySetting` for a given
     *   `SafetyCategory` provided in the list, the API will use the default safety
     *   setting for that category. Harm categories HARM_CATEGORY_HATE_SPEECH,
     *   HARM_CATEGORY_SEXUALLY_EXPLICIT, HARM_CATEGORY_DANGEROUS_CONTENT,
     *   HARM_CATEGORY_HARASSMENT are supported.
     * @param {google.ai.generativelanguage.v1.GenerationConfig} [request.generationConfig]
     *   Optional. Configuration options for model generation and outputs.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing {@link protos.google.ai.generativelanguage.v1.GenerateContentResponse|GenerateContentResponse}.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v1/generative_service.generate_content.js</caption>
     * region_tag:generativelanguage_v1_generated_GenerativeService_GenerateContent_async
     */
    generateContent(request?: protos.google.ai.generativelanguage.v1.IGenerateContentRequest, options?: CallOptions): Promise<[
        protos.google.ai.generativelanguage.v1.IGenerateContentResponse,
        (protos.google.ai.generativelanguage.v1.IGenerateContentRequest | undefined),
        {} | undefined
    ]>;
    generateContent(request: protos.google.ai.generativelanguage.v1.IGenerateContentRequest, options: CallOptions, callback: Callback<protos.google.ai.generativelanguage.v1.IGenerateContentResponse, protos.google.ai.generativelanguage.v1.IGenerateContentRequest | null | undefined, {} | null | undefined>): void;
    generateContent(request: protos.google.ai.generativelanguage.v1.IGenerateContentRequest, callback: Callback<protos.google.ai.generativelanguage.v1.IGenerateContentResponse, protos.google.ai.generativelanguage.v1.IGenerateContentRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Generates an embedding from the model given an input `Content`.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.model
     *   Required. The model's resource name. This serves as an ID for the Model to
     *   use.
     *
     *   This name should match a model name returned by the `ListModels` method.
     *
     *   Format: `models/{model}`
     * @param {google.ai.generativelanguage.v1.Content} request.content
     *   Required. The content to embed. Only the `parts.text` fields will be
     *   counted.
     * @param {google.ai.generativelanguage.v1.TaskType} [request.taskType]
     *   Optional. Optional task type for which the embeddings will be used. Can
     *   only be set for `models/embedding-001`.
     * @param {string} [request.title]
     *   Optional. An optional title for the text. Only applicable when TaskType is
     *   `RETRIEVAL_DOCUMENT`.
     *
     *   Note: Specifying a `title` for `RETRIEVAL_DOCUMENT` provides better quality
     *   embeddings for retrieval.
     * @param {number} [request.outputDimensionality]
     *   Optional. Optional reduced dimension for the output embedding. If set,
     *   excessive values in the output embedding are truncated from the end.
     *   Supported by newer models since 2024, and the earlier model
     *   (`models/embedding-001`) cannot specify this value.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing {@link protos.google.ai.generativelanguage.v1.EmbedContentResponse|EmbedContentResponse}.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v1/generative_service.embed_content.js</caption>
     * region_tag:generativelanguage_v1_generated_GenerativeService_EmbedContent_async
     */
    embedContent(request?: protos.google.ai.generativelanguage.v1.IEmbedContentRequest, options?: CallOptions): Promise<[
        protos.google.ai.generativelanguage.v1.IEmbedContentResponse,
        protos.google.ai.generativelanguage.v1.IEmbedContentRequest | undefined,
        {} | undefined
    ]>;
    embedContent(request: protos.google.ai.generativelanguage.v1.IEmbedContentRequest, options: CallOptions, callback: Callback<protos.google.ai.generativelanguage.v1.IEmbedContentResponse, protos.google.ai.generativelanguage.v1.IEmbedContentRequest | null | undefined, {} | null | undefined>): void;
    embedContent(request: protos.google.ai.generativelanguage.v1.IEmbedContentRequest, callback: Callback<protos.google.ai.generativelanguage.v1.IEmbedContentResponse, protos.google.ai.generativelanguage.v1.IEmbedContentRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Generates multiple embeddings from the model given input text in a
     * synchronous call.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.model
     *   Required. The model's resource name. This serves as an ID for the Model to
     *   use.
     *
     *   This name should match a model name returned by the `ListModels` method.
     *
     *   Format: `models/{model}`
     * @param {number[]} request.requests
     *   Required. Embed requests for the batch. The model in each of these requests
     *   must match the model specified `BatchEmbedContentsRequest.model`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing {@link protos.google.ai.generativelanguage.v1.BatchEmbedContentsResponse|BatchEmbedContentsResponse}.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v1/generative_service.batch_embed_contents.js</caption>
     * region_tag:generativelanguage_v1_generated_GenerativeService_BatchEmbedContents_async
     */
    batchEmbedContents(request?: protos.google.ai.generativelanguage.v1.IBatchEmbedContentsRequest, options?: CallOptions): Promise<[
        protos.google.ai.generativelanguage.v1.IBatchEmbedContentsResponse,
        (protos.google.ai.generativelanguage.v1.IBatchEmbedContentsRequest | undefined),
        {} | undefined
    ]>;
    batchEmbedContents(request: protos.google.ai.generativelanguage.v1.IBatchEmbedContentsRequest, options: CallOptions, callback: Callback<protos.google.ai.generativelanguage.v1.IBatchEmbedContentsResponse, protos.google.ai.generativelanguage.v1.IBatchEmbedContentsRequest | null | undefined, {} | null | undefined>): void;
    batchEmbedContents(request: protos.google.ai.generativelanguage.v1.IBatchEmbedContentsRequest, callback: Callback<protos.google.ai.generativelanguage.v1.IBatchEmbedContentsResponse, protos.google.ai.generativelanguage.v1.IBatchEmbedContentsRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Runs a model's tokenizer on input content and returns the token count.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.model
     *   Required. The model's resource name. This serves as an ID for the Model to
     *   use.
     *
     *   This name should match a model name returned by the `ListModels` method.
     *
     *   Format: `models/{model}`
     * @param {number[]} [request.contents]
     *   Optional. The input given to the model as a prompt. This field is ignored
     *   when `generate_content_request` is set.
     * @param {google.ai.generativelanguage.v1.GenerateContentRequest} [request.generateContentRequest]
     *   Optional. The overall input given to the model. CountTokens will count
     *   prompt, function calling, etc.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing {@link protos.google.ai.generativelanguage.v1.CountTokensResponse|CountTokensResponse}.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v1/generative_service.count_tokens.js</caption>
     * region_tag:generativelanguage_v1_generated_GenerativeService_CountTokens_async
     */
    countTokens(request?: protos.google.ai.generativelanguage.v1.ICountTokensRequest, options?: CallOptions): Promise<[
        protos.google.ai.generativelanguage.v1.ICountTokensResponse,
        protos.google.ai.generativelanguage.v1.ICountTokensRequest | undefined,
        {} | undefined
    ]>;
    countTokens(request: protos.google.ai.generativelanguage.v1.ICountTokensRequest, options: CallOptions, callback: Callback<protos.google.ai.generativelanguage.v1.ICountTokensResponse, protos.google.ai.generativelanguage.v1.ICountTokensRequest | null | undefined, {} | null | undefined>): void;
    countTokens(request: protos.google.ai.generativelanguage.v1.ICountTokensRequest, callback: Callback<protos.google.ai.generativelanguage.v1.ICountTokensResponse, protos.google.ai.generativelanguage.v1.ICountTokensRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Generates a streamed response from the model given an input
     * `GenerateContentRequest`.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.model
     *   Required. The name of the `Model` to use for generating the completion.
     *
     *   Format: `name=models/{model}`.
     * @param {number[]} request.contents
     *   Required. The content of the current conversation with the model.
     *
     *   For single-turn queries, this is a single instance. For multi-turn queries,
     *   this is a repeated field that contains conversation history + latest
     *   request.
     * @param {number[]} [request.safetySettings]
     *   Optional. A list of unique `SafetySetting` instances for blocking unsafe
     *   content.
     *
     *   This will be enforced on the `GenerateContentRequest.contents` and
     *   `GenerateContentResponse.candidates`. There should not be more than one
     *   setting for each `SafetyCategory` type. The API will block any contents and
     *   responses that fail to meet the thresholds set by these settings. This list
     *   overrides the default settings for each `SafetyCategory` specified in the
     *   safety_settings. If there is no `SafetySetting` for a given
     *   `SafetyCategory` provided in the list, the API will use the default safety
     *   setting for that category. Harm categories HARM_CATEGORY_HATE_SPEECH,
     *   HARM_CATEGORY_SEXUALLY_EXPLICIT, HARM_CATEGORY_DANGEROUS_CONTENT,
     *   HARM_CATEGORY_HARASSMENT are supported.
     * @param {google.ai.generativelanguage.v1.GenerationConfig} [request.generationConfig]
     *   Optional. Configuration options for model generation and outputs.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits {@link protos.google.ai.generativelanguage.v1.GenerateContentResponse|GenerateContentResponse} on 'data' event.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#server-streaming | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v1/generative_service.stream_generate_content.js</caption>
     * region_tag:generativelanguage_v1_generated_GenerativeService_StreamGenerateContent_async
     */
    streamGenerateContent(request?: protos.google.ai.generativelanguage.v1.IGenerateContentRequest, options?: CallOptions): gax.CancellableStream;
    /**
     * Return a fully-qualified model resource name string.
     *
     * @param {string} model
     * @returns {string} Resource name string.
     */
    modelPath(model: string): string;
    /**
     * Parse the model from Model resource.
     *
     * @param {string} modelName
     *   A fully-qualified path representing Model resource.
     * @returns {string} A string representing the model.
     */
    matchModelFromModelName(modelName: string): string | number;
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close(): Promise<void>;
}
