// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_ai_generativelanguage_protos || ($protobuf.roots._google_ai_generativelanguage_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.ai = (function() {
    
            /**
             * Namespace ai.
             * @memberof google
             * @namespace
             */
            var ai = {};
    
            ai.generativelanguage = (function() {
    
                /**
                 * Namespace generativelanguage.
                 * @memberof google.ai
                 * @namespace
                 */
                var generativelanguage = {};
    
                generativelanguage.v1 = (function() {
    
                    /**
                     * Namespace v1.
                     * @memberof google.ai.generativelanguage
                     * @namespace
                     */
                    var v1 = {};
    
                    v1.CitationMetadata = (function() {
    
                        /**
                         * Properties of a CitationMetadata.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ICitationMetadata
                         * @property {Array.<google.ai.generativelanguage.v1.ICitationSource>|null} [citationSources] CitationMetadata citationSources
                         */
    
                        /**
                         * Constructs a new CitationMetadata.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a CitationMetadata.
                         * @implements ICitationMetadata
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ICitationMetadata=} [properties] Properties to set
                         */
                        function CitationMetadata(properties) {
                            this.citationSources = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CitationMetadata citationSources.
                         * @member {Array.<google.ai.generativelanguage.v1.ICitationSource>} citationSources
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @instance
                         */
                        CitationMetadata.prototype.citationSources = $util.emptyArray;
    
                        /**
                         * Creates a new CitationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICitationMetadata=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.CitationMetadata} CitationMetadata instance
                         */
                        CitationMetadata.create = function create(properties) {
                            return new CitationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CitationMetadata message. Does not implicitly {@link google.ai.generativelanguage.v1.CitationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICitationMetadata} message CitationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.citationSources != null && message.citationSources.length)
                                for (var i = 0; i < message.citationSources.length; ++i)
                                    $root.google.ai.generativelanguage.v1.CitationSource.encode(message.citationSources[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CitationMetadata message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.CitationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICitationMetadata} message CitationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CitationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.CitationMetadata} CitationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.CitationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.citationSources && message.citationSources.length))
                                            message.citationSources = [];
                                        message.citationSources.push($root.google.ai.generativelanguage.v1.CitationSource.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CitationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.CitationMetadata} CitationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CitationMetadata message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CitationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.citationSources != null && message.hasOwnProperty("citationSources")) {
                                if (!Array.isArray(message.citationSources))
                                    return "citationSources: array expected";
                                for (var i = 0; i < message.citationSources.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.CitationSource.verify(message.citationSources[i]);
                                    if (error)
                                        return "citationSources." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CitationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.CitationMetadata} CitationMetadata
                         */
                        CitationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.CitationMetadata)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.CitationMetadata();
                            if (object.citationSources) {
                                if (!Array.isArray(object.citationSources))
                                    throw TypeError(".google.ai.generativelanguage.v1.CitationMetadata.citationSources: array expected");
                                message.citationSources = [];
                                for (var i = 0; i < object.citationSources.length; ++i) {
                                    if (typeof object.citationSources[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.CitationMetadata.citationSources: object expected");
                                    message.citationSources[i] = $root.google.ai.generativelanguage.v1.CitationSource.fromObject(object.citationSources[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CitationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1.CitationMetadata} message CitationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CitationMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.citationSources = [];
                            if (message.citationSources && message.citationSources.length) {
                                object.citationSources = [];
                                for (var j = 0; j < message.citationSources.length; ++j)
                                    object.citationSources[j] = $root.google.ai.generativelanguage.v1.CitationSource.toObject(message.citationSources[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CitationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CitationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CitationMetadata
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.CitationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CitationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.CitationMetadata";
                        };
    
                        return CitationMetadata;
                    })();
    
                    v1.CitationSource = (function() {
    
                        /**
                         * Properties of a CitationSource.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ICitationSource
                         * @property {number|null} [startIndex] CitationSource startIndex
                         * @property {number|null} [endIndex] CitationSource endIndex
                         * @property {string|null} [uri] CitationSource uri
                         * @property {string|null} [license] CitationSource license
                         */
    
                        /**
                         * Constructs a new CitationSource.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a CitationSource.
                         * @implements ICitationSource
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ICitationSource=} [properties] Properties to set
                         */
                        function CitationSource(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CitationSource startIndex.
                         * @member {number|null|undefined} startIndex
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.startIndex = null;
    
                        /**
                         * CitationSource endIndex.
                         * @member {number|null|undefined} endIndex
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.endIndex = null;
    
                        /**
                         * CitationSource uri.
                         * @member {string|null|undefined} uri
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.uri = null;
    
                        /**
                         * CitationSource license.
                         * @member {string|null|undefined} license
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.license = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * CitationSource _startIndex.
                         * @member {"startIndex"|undefined} _startIndex
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_startIndex", {
                            get: $util.oneOfGetter($oneOfFields = ["startIndex"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CitationSource _endIndex.
                         * @member {"endIndex"|undefined} _endIndex
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_endIndex", {
                            get: $util.oneOfGetter($oneOfFields = ["endIndex"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CitationSource _uri.
                         * @member {"uri"|undefined} _uri
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_uri", {
                            get: $util.oneOfGetter($oneOfFields = ["uri"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CitationSource _license.
                         * @member {"license"|undefined} _license
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_license", {
                            get: $util.oneOfGetter($oneOfFields = ["license"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new CitationSource instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICitationSource=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.CitationSource} CitationSource instance
                         */
                        CitationSource.create = function create(properties) {
                            return new CitationSource(properties);
                        };
    
                        /**
                         * Encodes the specified CitationSource message. Does not implicitly {@link google.ai.generativelanguage.v1.CitationSource.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICitationSource} message CitationSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationSource.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.startIndex != null && Object.hasOwnProperty.call(message, "startIndex"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.startIndex);
                            if (message.endIndex != null && Object.hasOwnProperty.call(message, "endIndex"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.endIndex);
                            if (message.uri != null && Object.hasOwnProperty.call(message, "uri"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.uri);
                            if (message.license != null && Object.hasOwnProperty.call(message, "license"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.license);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CitationSource message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.CitationSource.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICitationSource} message CitationSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationSource.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CitationSource message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.CitationSource} CitationSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationSource.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.CitationSource();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.startIndex = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.endIndex = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.uri = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.license = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CitationSource message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.CitationSource} CitationSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationSource.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CitationSource message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CitationSource.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.startIndex != null && message.hasOwnProperty("startIndex")) {
                                properties._startIndex = 1;
                                if (!$util.isInteger(message.startIndex))
                                    return "startIndex: integer expected";
                            }
                            if (message.endIndex != null && message.hasOwnProperty("endIndex")) {
                                properties._endIndex = 1;
                                if (!$util.isInteger(message.endIndex))
                                    return "endIndex: integer expected";
                            }
                            if (message.uri != null && message.hasOwnProperty("uri")) {
                                properties._uri = 1;
                                if (!$util.isString(message.uri))
                                    return "uri: string expected";
                            }
                            if (message.license != null && message.hasOwnProperty("license")) {
                                properties._license = 1;
                                if (!$util.isString(message.license))
                                    return "license: string expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CitationSource message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.CitationSource} CitationSource
                         */
                        CitationSource.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.CitationSource)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.CitationSource();
                            if (object.startIndex != null)
                                message.startIndex = object.startIndex | 0;
                            if (object.endIndex != null)
                                message.endIndex = object.endIndex | 0;
                            if (object.uri != null)
                                message.uri = String(object.uri);
                            if (object.license != null)
                                message.license = String(object.license);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CitationSource message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1.CitationSource} message CitationSource
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CitationSource.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.startIndex != null && message.hasOwnProperty("startIndex")) {
                                object.startIndex = message.startIndex;
                                if (options.oneofs)
                                    object._startIndex = "startIndex";
                            }
                            if (message.endIndex != null && message.hasOwnProperty("endIndex")) {
                                object.endIndex = message.endIndex;
                                if (options.oneofs)
                                    object._endIndex = "endIndex";
                            }
                            if (message.uri != null && message.hasOwnProperty("uri")) {
                                object.uri = message.uri;
                                if (options.oneofs)
                                    object._uri = "uri";
                            }
                            if (message.license != null && message.hasOwnProperty("license")) {
                                object.license = message.license;
                                if (options.oneofs)
                                    object._license = "license";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CitationSource to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CitationSource.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CitationSource
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.CitationSource
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CitationSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.CitationSource";
                        };
    
                        return CitationSource;
                    })();
    
                    v1.Content = (function() {
    
                        /**
                         * Properties of a Content.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IContent
                         * @property {Array.<google.ai.generativelanguage.v1.IPart>|null} [parts] Content parts
                         * @property {string|null} [role] Content role
                         */
    
                        /**
                         * Constructs a new Content.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a Content.
                         * @implements IContent
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IContent=} [properties] Properties to set
                         */
                        function Content(properties) {
                            this.parts = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Content parts.
                         * @member {Array.<google.ai.generativelanguage.v1.IPart>} parts
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @instance
                         */
                        Content.prototype.parts = $util.emptyArray;
    
                        /**
                         * Content role.
                         * @member {string} role
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @instance
                         */
                        Content.prototype.role = "";
    
                        /**
                         * Creates a new Content instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1.IContent=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.Content} Content instance
                         */
                        Content.create = function create(properties) {
                            return new Content(properties);
                        };
    
                        /**
                         * Encodes the specified Content message. Does not implicitly {@link google.ai.generativelanguage.v1.Content.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1.IContent} message Content message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Content.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parts != null && message.parts.length)
                                for (var i = 0; i < message.parts.length; ++i)
                                    $root.google.ai.generativelanguage.v1.Part.encode(message.parts[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.role != null && Object.hasOwnProperty.call(message, "role"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.role);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Content message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.Content.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1.IContent} message Content message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Content.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Content message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.Content} Content
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Content.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.Content();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.parts && message.parts.length))
                                            message.parts = [];
                                        message.parts.push($root.google.ai.generativelanguage.v1.Part.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.role = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Content message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.Content} Content
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Content.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Content message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Content.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parts != null && message.hasOwnProperty("parts")) {
                                if (!Array.isArray(message.parts))
                                    return "parts: array expected";
                                for (var i = 0; i < message.parts.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.Part.verify(message.parts[i]);
                                    if (error)
                                        return "parts." + error;
                                }
                            }
                            if (message.role != null && message.hasOwnProperty("role"))
                                if (!$util.isString(message.role))
                                    return "role: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a Content message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.Content} Content
                         */
                        Content.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.Content)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.Content();
                            if (object.parts) {
                                if (!Array.isArray(object.parts))
                                    throw TypeError(".google.ai.generativelanguage.v1.Content.parts: array expected");
                                message.parts = [];
                                for (var i = 0; i < object.parts.length; ++i) {
                                    if (typeof object.parts[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.Content.parts: object expected");
                                    message.parts[i] = $root.google.ai.generativelanguage.v1.Part.fromObject(object.parts[i]);
                                }
                            }
                            if (object.role != null)
                                message.role = String(object.role);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Content message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1.Content} message Content
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Content.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.parts = [];
                            if (options.defaults)
                                object.role = "";
                            if (message.parts && message.parts.length) {
                                object.parts = [];
                                for (var j = 0; j < message.parts.length; ++j)
                                    object.parts[j] = $root.google.ai.generativelanguage.v1.Part.toObject(message.parts[j], options);
                            }
                            if (message.role != null && message.hasOwnProperty("role"))
                                object.role = message.role;
                            return object;
                        };
    
                        /**
                         * Converts this Content to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Content.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Content
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.Content
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Content.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.Content";
                        };
    
                        return Content;
                    })();
    
                    v1.Part = (function() {
    
                        /**
                         * Properties of a Part.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IPart
                         * @property {string|null} [text] Part text
                         * @property {google.ai.generativelanguage.v1.IBlob|null} [inlineData] Part inlineData
                         */
    
                        /**
                         * Constructs a new Part.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a Part.
                         * @implements IPart
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IPart=} [properties] Properties to set
                         */
                        function Part(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Part text.
                         * @member {string|null|undefined} text
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @instance
                         */
                        Part.prototype.text = null;
    
                        /**
                         * Part inlineData.
                         * @member {google.ai.generativelanguage.v1.IBlob|null|undefined} inlineData
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @instance
                         */
                        Part.prototype.inlineData = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Part data.
                         * @member {"text"|"inlineData"|undefined} data
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @instance
                         */
                        Object.defineProperty(Part.prototype, "data", {
                            get: $util.oneOfGetter($oneOfFields = ["text", "inlineData"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Part instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1.IPart=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.Part} Part instance
                         */
                        Part.create = function create(properties) {
                            return new Part(properties);
                        };
    
                        /**
                         * Encodes the specified Part message. Does not implicitly {@link google.ai.generativelanguage.v1.Part.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1.IPart} message Part message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Part.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.text);
                            if (message.inlineData != null && Object.hasOwnProperty.call(message, "inlineData"))
                                $root.google.ai.generativelanguage.v1.Blob.encode(message.inlineData, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Part message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.Part.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1.IPart} message Part message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Part.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Part message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.Part} Part
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Part.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.Part();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 2: {
                                        message.text = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.inlineData = $root.google.ai.generativelanguage.v1.Blob.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Part message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.Part} Part
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Part.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Part message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Part.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.text != null && message.hasOwnProperty("text")) {
                                properties.data = 1;
                                if (!$util.isString(message.text))
                                    return "text: string expected";
                            }
                            if (message.inlineData != null && message.hasOwnProperty("inlineData")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1.Blob.verify(message.inlineData);
                                    if (error)
                                        return "inlineData." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Part message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.Part} Part
                         */
                        Part.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.Part)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.Part();
                            if (object.text != null)
                                message.text = String(object.text);
                            if (object.inlineData != null) {
                                if (typeof object.inlineData !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.Part.inlineData: object expected");
                                message.inlineData = $root.google.ai.generativelanguage.v1.Blob.fromObject(object.inlineData);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Part message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1.Part} message Part
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Part.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.text != null && message.hasOwnProperty("text")) {
                                object.text = message.text;
                                if (options.oneofs)
                                    object.data = "text";
                            }
                            if (message.inlineData != null && message.hasOwnProperty("inlineData")) {
                                object.inlineData = $root.google.ai.generativelanguage.v1.Blob.toObject(message.inlineData, options);
                                if (options.oneofs)
                                    object.data = "inlineData";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Part to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Part.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Part
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.Part
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Part.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.Part";
                        };
    
                        return Part;
                    })();
    
                    v1.Blob = (function() {
    
                        /**
                         * Properties of a Blob.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IBlob
                         * @property {string|null} [mimeType] Blob mimeType
                         * @property {Uint8Array|null} [data] Blob data
                         */
    
                        /**
                         * Constructs a new Blob.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a Blob.
                         * @implements IBlob
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IBlob=} [properties] Properties to set
                         */
                        function Blob(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Blob mimeType.
                         * @member {string} mimeType
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @instance
                         */
                        Blob.prototype.mimeType = "";
    
                        /**
                         * Blob data.
                         * @member {Uint8Array} data
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @instance
                         */
                        Blob.prototype.data = $util.newBuffer([]);
    
                        /**
                         * Creates a new Blob instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBlob=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.Blob} Blob instance
                         */
                        Blob.create = function create(properties) {
                            return new Blob(properties);
                        };
    
                        /**
                         * Encodes the specified Blob message. Does not implicitly {@link google.ai.generativelanguage.v1.Blob.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBlob} message Blob message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Blob.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.mimeType != null && Object.hasOwnProperty.call(message, "mimeType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.mimeType);
                            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.data);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Blob message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.Blob.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBlob} message Blob message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Blob.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Blob message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.Blob} Blob
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Blob.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.Blob();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.mimeType = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.data = reader.bytes();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Blob message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.Blob} Blob
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Blob.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Blob message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Blob.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                if (!$util.isString(message.mimeType))
                                    return "mimeType: string expected";
                            if (message.data != null && message.hasOwnProperty("data"))
                                if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                                    return "data: buffer expected";
                            return null;
                        };
    
                        /**
                         * Creates a Blob message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.Blob} Blob
                         */
                        Blob.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.Blob)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.Blob();
                            if (object.mimeType != null)
                                message.mimeType = String(object.mimeType);
                            if (object.data != null)
                                if (typeof object.data === "string")
                                    $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                                else if (object.data.length >= 0)
                                    message.data = object.data;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Blob message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1.Blob} message Blob
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Blob.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.mimeType = "";
                                if (options.bytes === String)
                                    object.data = "";
                                else {
                                    object.data = [];
                                    if (options.bytes !== Array)
                                        object.data = $util.newBuffer(object.data);
                                }
                            }
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                object.mimeType = message.mimeType;
                            if (message.data != null && message.hasOwnProperty("data"))
                                object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                            return object;
                        };
    
                        /**
                         * Converts this Blob to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Blob.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Blob
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.Blob
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Blob.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.Blob";
                        };
    
                        return Blob;
                    })();
    
                    v1.GenerativeService = (function() {
    
                        /**
                         * Constructs a new GenerativeService service.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a GenerativeService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function GenerativeService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (GenerativeService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = GenerativeService;
    
                        /**
                         * Creates new GenerativeService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {GenerativeService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        GenerativeService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.GenerativeService|generateContent}.
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @typedef GenerateContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.GenerateContentResponse} [response] GenerateContentResponse
                         */
    
                        /**
                         * Calls GenerateContent.
                         * @function generateContent
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest} request GenerateContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.GenerativeService.GenerateContentCallback} callback Node-style callback called with the error, if any, and GenerateContentResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GenerativeService.prototype.generateContent = function generateContent(request, callback) {
                            return this.rpcCall(generateContent, $root.google.ai.generativelanguage.v1.GenerateContentRequest, $root.google.ai.generativelanguage.v1.GenerateContentResponse, request, callback);
                        }, "name", { value: "GenerateContent" });
    
                        /**
                         * Calls GenerateContent.
                         * @function generateContent
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest} request GenerateContentRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.GenerateContentResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.GenerativeService|streamGenerateContent}.
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @typedef StreamGenerateContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.GenerateContentResponse} [response] GenerateContentResponse
                         */
    
                        /**
                         * Calls StreamGenerateContent.
                         * @function streamGenerateContent
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest} request GenerateContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.GenerativeService.StreamGenerateContentCallback} callback Node-style callback called with the error, if any, and GenerateContentResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GenerativeService.prototype.streamGenerateContent = function streamGenerateContent(request, callback) {
                            return this.rpcCall(streamGenerateContent, $root.google.ai.generativelanguage.v1.GenerateContentRequest, $root.google.ai.generativelanguage.v1.GenerateContentResponse, request, callback);
                        }, "name", { value: "StreamGenerateContent" });
    
                        /**
                         * Calls StreamGenerateContent.
                         * @function streamGenerateContent
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest} request GenerateContentRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.GenerateContentResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.GenerativeService|embedContent}.
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @typedef EmbedContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.EmbedContentResponse} [response] EmbedContentResponse
                         */
    
                        /**
                         * Calls EmbedContent.
                         * @function embedContent
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IEmbedContentRequest} request EmbedContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.GenerativeService.EmbedContentCallback} callback Node-style callback called with the error, if any, and EmbedContentResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GenerativeService.prototype.embedContent = function embedContent(request, callback) {
                            return this.rpcCall(embedContent, $root.google.ai.generativelanguage.v1.EmbedContentRequest, $root.google.ai.generativelanguage.v1.EmbedContentResponse, request, callback);
                        }, "name", { value: "EmbedContent" });
    
                        /**
                         * Calls EmbedContent.
                         * @function embedContent
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IEmbedContentRequest} request EmbedContentRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.EmbedContentResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.GenerativeService|batchEmbedContents}.
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @typedef BatchEmbedContentsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.BatchEmbedContentsResponse} [response] BatchEmbedContentsResponse
                         */
    
                        /**
                         * Calls BatchEmbedContents.
                         * @function batchEmbedContents
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsRequest} request BatchEmbedContentsRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.GenerativeService.BatchEmbedContentsCallback} callback Node-style callback called with the error, if any, and BatchEmbedContentsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GenerativeService.prototype.batchEmbedContents = function batchEmbedContents(request, callback) {
                            return this.rpcCall(batchEmbedContents, $root.google.ai.generativelanguage.v1.BatchEmbedContentsRequest, $root.google.ai.generativelanguage.v1.BatchEmbedContentsResponse, request, callback);
                        }, "name", { value: "BatchEmbedContents" });
    
                        /**
                         * Calls BatchEmbedContents.
                         * @function batchEmbedContents
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsRequest} request BatchEmbedContentsRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.BatchEmbedContentsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.GenerativeService|countTokens}.
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @typedef CountTokensCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.CountTokensResponse} [response] CountTokensResponse
                         */
    
                        /**
                         * Calls CountTokens.
                         * @function countTokens
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.ICountTokensRequest} request CountTokensRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.GenerativeService.CountTokensCallback} callback Node-style callback called with the error, if any, and CountTokensResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GenerativeService.prototype.countTokens = function countTokens(request, callback) {
                            return this.rpcCall(countTokens, $root.google.ai.generativelanguage.v1.CountTokensRequest, $root.google.ai.generativelanguage.v1.CountTokensResponse, request, callback);
                        }, "name", { value: "CountTokens" });
    
                        /**
                         * Calls CountTokens.
                         * @function countTokens
                         * @memberof google.ai.generativelanguage.v1.GenerativeService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.ICountTokensRequest} request CountTokensRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.CountTokensResponse>} Promise
                         * @variation 2
                         */
    
                        return GenerativeService;
                    })();
    
                    /**
                     * TaskType enum.
                     * @name google.ai.generativelanguage.v1.TaskType
                     * @enum {number}
                     * @property {number} TASK_TYPE_UNSPECIFIED=0 TASK_TYPE_UNSPECIFIED value
                     * @property {number} RETRIEVAL_QUERY=1 RETRIEVAL_QUERY value
                     * @property {number} RETRIEVAL_DOCUMENT=2 RETRIEVAL_DOCUMENT value
                     * @property {number} SEMANTIC_SIMILARITY=3 SEMANTIC_SIMILARITY value
                     * @property {number} CLASSIFICATION=4 CLASSIFICATION value
                     * @property {number} CLUSTERING=5 CLUSTERING value
                     * @property {number} QUESTION_ANSWERING=6 QUESTION_ANSWERING value
                     * @property {number} FACT_VERIFICATION=7 FACT_VERIFICATION value
                     */
                    v1.TaskType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "TASK_TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "RETRIEVAL_QUERY"] = 1;
                        values[valuesById[2] = "RETRIEVAL_DOCUMENT"] = 2;
                        values[valuesById[3] = "SEMANTIC_SIMILARITY"] = 3;
                        values[valuesById[4] = "CLASSIFICATION"] = 4;
                        values[valuesById[5] = "CLUSTERING"] = 5;
                        values[valuesById[6] = "QUESTION_ANSWERING"] = 6;
                        values[valuesById[7] = "FACT_VERIFICATION"] = 7;
                        return values;
                    })();
    
                    v1.GenerateContentRequest = (function() {
    
                        /**
                         * Properties of a GenerateContentRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IGenerateContentRequest
                         * @property {string|null} [model] GenerateContentRequest model
                         * @property {Array.<google.ai.generativelanguage.v1.IContent>|null} [contents] GenerateContentRequest contents
                         * @property {Array.<google.ai.generativelanguage.v1.ISafetySetting>|null} [safetySettings] GenerateContentRequest safetySettings
                         * @property {google.ai.generativelanguage.v1.IGenerationConfig|null} [generationConfig] GenerateContentRequest generationConfig
                         */
    
                        /**
                         * Constructs a new GenerateContentRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a GenerateContentRequest.
                         * @implements IGenerateContentRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest=} [properties] Properties to set
                         */
                        function GenerateContentRequest(properties) {
                            this.contents = [];
                            this.safetySettings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GenerateContentRequest model.
                         * @member {string} model
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @instance
                         */
                        GenerateContentRequest.prototype.model = "";
    
                        /**
                         * GenerateContentRequest contents.
                         * @member {Array.<google.ai.generativelanguage.v1.IContent>} contents
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @instance
                         */
                        GenerateContentRequest.prototype.contents = $util.emptyArray;
    
                        /**
                         * GenerateContentRequest safetySettings.
                         * @member {Array.<google.ai.generativelanguage.v1.ISafetySetting>} safetySettings
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @instance
                         */
                        GenerateContentRequest.prototype.safetySettings = $util.emptyArray;
    
                        /**
                         * GenerateContentRequest generationConfig.
                         * @member {google.ai.generativelanguage.v1.IGenerationConfig|null|undefined} generationConfig
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @instance
                         */
                        GenerateContentRequest.prototype.generationConfig = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * GenerateContentRequest _generationConfig.
                         * @member {"generationConfig"|undefined} _generationConfig
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @instance
                         */
                        Object.defineProperty(GenerateContentRequest.prototype, "_generationConfig", {
                            get: $util.oneOfGetter($oneOfFields = ["generationConfig"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new GenerateContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.GenerateContentRequest} GenerateContentRequest instance
                         */
                        GenerateContentRequest.create = function create(properties) {
                            return new GenerateContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GenerateContentRequest message. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest} message GenerateContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.model);
                            if (message.contents != null && message.contents.length)
                                for (var i = 0; i < message.contents.length; ++i)
                                    $root.google.ai.generativelanguage.v1.Content.encode(message.contents[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.safetySettings != null && message.safetySettings.length)
                                for (var i = 0; i < message.safetySettings.length; ++i)
                                    $root.google.ai.generativelanguage.v1.SafetySetting.encode(message.safetySettings[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.generationConfig != null && Object.hasOwnProperty.call(message, "generationConfig"))
                                $root.google.ai.generativelanguage.v1.GenerationConfig.encode(message.generationConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GenerateContentRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerateContentRequest} message GenerateContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GenerateContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.GenerateContentRequest} GenerateContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.GenerateContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.contents && message.contents.length))
                                            message.contents = [];
                                        message.contents.push($root.google.ai.generativelanguage.v1.Content.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        if (!(message.safetySettings && message.safetySettings.length))
                                            message.safetySettings = [];
                                        message.safetySettings.push($root.google.ai.generativelanguage.v1.SafetySetting.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 4: {
                                        message.generationConfig = $root.google.ai.generativelanguage.v1.GenerationConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GenerateContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.GenerateContentRequest} GenerateContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GenerateContentRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GenerateContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.contents != null && message.hasOwnProperty("contents")) {
                                if (!Array.isArray(message.contents))
                                    return "contents: array expected";
                                for (var i = 0; i < message.contents.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.Content.verify(message.contents[i]);
                                    if (error)
                                        return "contents." + error;
                                }
                            }
                            if (message.safetySettings != null && message.hasOwnProperty("safetySettings")) {
                                if (!Array.isArray(message.safetySettings))
                                    return "safetySettings: array expected";
                                for (var i = 0; i < message.safetySettings.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.SafetySetting.verify(message.safetySettings[i]);
                                    if (error)
                                        return "safetySettings." + error;
                                }
                            }
                            if (message.generationConfig != null && message.hasOwnProperty("generationConfig")) {
                                properties._generationConfig = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1.GenerationConfig.verify(message.generationConfig);
                                    if (error)
                                        return "generationConfig." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GenerateContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.GenerateContentRequest} GenerateContentRequest
                         */
                        GenerateContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.GenerateContentRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.GenerateContentRequest();
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.contents) {
                                if (!Array.isArray(object.contents))
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerateContentRequest.contents: array expected");
                                message.contents = [];
                                for (var i = 0; i < object.contents.length; ++i) {
                                    if (typeof object.contents[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.GenerateContentRequest.contents: object expected");
                                    message.contents[i] = $root.google.ai.generativelanguage.v1.Content.fromObject(object.contents[i]);
                                }
                            }
                            if (object.safetySettings) {
                                if (!Array.isArray(object.safetySettings))
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerateContentRequest.safetySettings: array expected");
                                message.safetySettings = [];
                                for (var i = 0; i < object.safetySettings.length; ++i) {
                                    if (typeof object.safetySettings[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.GenerateContentRequest.safetySettings: object expected");
                                    message.safetySettings[i] = $root.google.ai.generativelanguage.v1.SafetySetting.fromObject(object.safetySettings[i]);
                                }
                            }
                            if (object.generationConfig != null) {
                                if (typeof object.generationConfig !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerateContentRequest.generationConfig: object expected");
                                message.generationConfig = $root.google.ai.generativelanguage.v1.GenerationConfig.fromObject(object.generationConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GenerateContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.GenerateContentRequest} message GenerateContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GenerateContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.contents = [];
                                object.safetySettings = [];
                            }
                            if (options.defaults)
                                object.model = "";
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.contents && message.contents.length) {
                                object.contents = [];
                                for (var j = 0; j < message.contents.length; ++j)
                                    object.contents[j] = $root.google.ai.generativelanguage.v1.Content.toObject(message.contents[j], options);
                            }
                            if (message.safetySettings && message.safetySettings.length) {
                                object.safetySettings = [];
                                for (var j = 0; j < message.safetySettings.length; ++j)
                                    object.safetySettings[j] = $root.google.ai.generativelanguage.v1.SafetySetting.toObject(message.safetySettings[j], options);
                            }
                            if (message.generationConfig != null && message.hasOwnProperty("generationConfig")) {
                                object.generationConfig = $root.google.ai.generativelanguage.v1.GenerationConfig.toObject(message.generationConfig, options);
                                if (options.oneofs)
                                    object._generationConfig = "generationConfig";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this GenerateContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GenerateContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GenerateContentRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.GenerateContentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GenerateContentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.GenerateContentRequest";
                        };
    
                        return GenerateContentRequest;
                    })();
    
                    v1.GenerationConfig = (function() {
    
                        /**
                         * Properties of a GenerationConfig.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IGenerationConfig
                         * @property {number|null} [candidateCount] GenerationConfig candidateCount
                         * @property {Array.<string>|null} [stopSequences] GenerationConfig stopSequences
                         * @property {number|null} [maxOutputTokens] GenerationConfig maxOutputTokens
                         * @property {number|null} [temperature] GenerationConfig temperature
                         * @property {number|null} [topP] GenerationConfig topP
                         * @property {number|null} [topK] GenerationConfig topK
                         */
    
                        /**
                         * Constructs a new GenerationConfig.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a GenerationConfig.
                         * @implements IGenerationConfig
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IGenerationConfig=} [properties] Properties to set
                         */
                        function GenerationConfig(properties) {
                            this.stopSequences = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GenerationConfig candidateCount.
                         * @member {number|null|undefined} candidateCount
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        GenerationConfig.prototype.candidateCount = null;
    
                        /**
                         * GenerationConfig stopSequences.
                         * @member {Array.<string>} stopSequences
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        GenerationConfig.prototype.stopSequences = $util.emptyArray;
    
                        /**
                         * GenerationConfig maxOutputTokens.
                         * @member {number|null|undefined} maxOutputTokens
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        GenerationConfig.prototype.maxOutputTokens = null;
    
                        /**
                         * GenerationConfig temperature.
                         * @member {number|null|undefined} temperature
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        GenerationConfig.prototype.temperature = null;
    
                        /**
                         * GenerationConfig topP.
                         * @member {number|null|undefined} topP
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        GenerationConfig.prototype.topP = null;
    
                        /**
                         * GenerationConfig topK.
                         * @member {number|null|undefined} topK
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        GenerationConfig.prototype.topK = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * GenerationConfig _candidateCount.
                         * @member {"candidateCount"|undefined} _candidateCount
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        Object.defineProperty(GenerationConfig.prototype, "_candidateCount", {
                            get: $util.oneOfGetter($oneOfFields = ["candidateCount"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerationConfig _maxOutputTokens.
                         * @member {"maxOutputTokens"|undefined} _maxOutputTokens
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        Object.defineProperty(GenerationConfig.prototype, "_maxOutputTokens", {
                            get: $util.oneOfGetter($oneOfFields = ["maxOutputTokens"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerationConfig _temperature.
                         * @member {"temperature"|undefined} _temperature
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        Object.defineProperty(GenerationConfig.prototype, "_temperature", {
                            get: $util.oneOfGetter($oneOfFields = ["temperature"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerationConfig _topP.
                         * @member {"topP"|undefined} _topP
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        Object.defineProperty(GenerationConfig.prototype, "_topP", {
                            get: $util.oneOfGetter($oneOfFields = ["topP"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerationConfig _topK.
                         * @member {"topK"|undefined} _topK
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         */
                        Object.defineProperty(GenerationConfig.prototype, "_topK", {
                            get: $util.oneOfGetter($oneOfFields = ["topK"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new GenerationConfig instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerationConfig=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.GenerationConfig} GenerationConfig instance
                         */
                        GenerationConfig.create = function create(properties) {
                            return new GenerationConfig(properties);
                        };
    
                        /**
                         * Encodes the specified GenerationConfig message. Does not implicitly {@link google.ai.generativelanguage.v1.GenerationConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerationConfig} message GenerationConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerationConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.candidateCount != null && Object.hasOwnProperty.call(message, "candidateCount"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.candidateCount);
                            if (message.stopSequences != null && message.stopSequences.length)
                                for (var i = 0; i < message.stopSequences.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.stopSequences[i]);
                            if (message.maxOutputTokens != null && Object.hasOwnProperty.call(message, "maxOutputTokens"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.maxOutputTokens);
                            if (message.temperature != null && Object.hasOwnProperty.call(message, "temperature"))
                                writer.uint32(/* id 5, wireType 5 =*/45).float(message.temperature);
                            if (message.topP != null && Object.hasOwnProperty.call(message, "topP"))
                                writer.uint32(/* id 6, wireType 5 =*/53).float(message.topP);
                            if (message.topK != null && Object.hasOwnProperty.call(message, "topK"))
                                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.topK);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GenerationConfig message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.GenerationConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerationConfig} message GenerationConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerationConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GenerationConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.GenerationConfig} GenerationConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerationConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.GenerationConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.candidateCount = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.stopSequences && message.stopSequences.length))
                                            message.stopSequences = [];
                                        message.stopSequences.push(reader.string());
                                        break;
                                    }
                                case 4: {
                                        message.maxOutputTokens = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.temperature = reader.float();
                                        break;
                                    }
                                case 6: {
                                        message.topP = reader.float();
                                        break;
                                    }
                                case 7: {
                                        message.topK = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GenerationConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.GenerationConfig} GenerationConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerationConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GenerationConfig message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GenerationConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.candidateCount != null && message.hasOwnProperty("candidateCount")) {
                                properties._candidateCount = 1;
                                if (!$util.isInteger(message.candidateCount))
                                    return "candidateCount: integer expected";
                            }
                            if (message.stopSequences != null && message.hasOwnProperty("stopSequences")) {
                                if (!Array.isArray(message.stopSequences))
                                    return "stopSequences: array expected";
                                for (var i = 0; i < message.stopSequences.length; ++i)
                                    if (!$util.isString(message.stopSequences[i]))
                                        return "stopSequences: string[] expected";
                            }
                            if (message.maxOutputTokens != null && message.hasOwnProperty("maxOutputTokens")) {
                                properties._maxOutputTokens = 1;
                                if (!$util.isInteger(message.maxOutputTokens))
                                    return "maxOutputTokens: integer expected";
                            }
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                properties._temperature = 1;
                                if (typeof message.temperature !== "number")
                                    return "temperature: number expected";
                            }
                            if (message.topP != null && message.hasOwnProperty("topP")) {
                                properties._topP = 1;
                                if (typeof message.topP !== "number")
                                    return "topP: number expected";
                            }
                            if (message.topK != null && message.hasOwnProperty("topK")) {
                                properties._topK = 1;
                                if (!$util.isInteger(message.topK))
                                    return "topK: integer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GenerationConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.GenerationConfig} GenerationConfig
                         */
                        GenerationConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.GenerationConfig)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.GenerationConfig();
                            if (object.candidateCount != null)
                                message.candidateCount = object.candidateCount | 0;
                            if (object.stopSequences) {
                                if (!Array.isArray(object.stopSequences))
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerationConfig.stopSequences: array expected");
                                message.stopSequences = [];
                                for (var i = 0; i < object.stopSequences.length; ++i)
                                    message.stopSequences[i] = String(object.stopSequences[i]);
                            }
                            if (object.maxOutputTokens != null)
                                message.maxOutputTokens = object.maxOutputTokens | 0;
                            if (object.temperature != null)
                                message.temperature = Number(object.temperature);
                            if (object.topP != null)
                                message.topP = Number(object.topP);
                            if (object.topK != null)
                                message.topK = object.topK | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GenerationConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1.GenerationConfig} message GenerationConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GenerationConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.stopSequences = [];
                            if (message.candidateCount != null && message.hasOwnProperty("candidateCount")) {
                                object.candidateCount = message.candidateCount;
                                if (options.oneofs)
                                    object._candidateCount = "candidateCount";
                            }
                            if (message.stopSequences && message.stopSequences.length) {
                                object.stopSequences = [];
                                for (var j = 0; j < message.stopSequences.length; ++j)
                                    object.stopSequences[j] = message.stopSequences[j];
                            }
                            if (message.maxOutputTokens != null && message.hasOwnProperty("maxOutputTokens")) {
                                object.maxOutputTokens = message.maxOutputTokens;
                                if (options.oneofs)
                                    object._maxOutputTokens = "maxOutputTokens";
                            }
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                object.temperature = options.json && !isFinite(message.temperature) ? String(message.temperature) : message.temperature;
                                if (options.oneofs)
                                    object._temperature = "temperature";
                            }
                            if (message.topP != null && message.hasOwnProperty("topP")) {
                                object.topP = options.json && !isFinite(message.topP) ? String(message.topP) : message.topP;
                                if (options.oneofs)
                                    object._topP = "topP";
                            }
                            if (message.topK != null && message.hasOwnProperty("topK")) {
                                object.topK = message.topK;
                                if (options.oneofs)
                                    object._topK = "topK";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this GenerationConfig to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GenerationConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GenerationConfig
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.GenerationConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GenerationConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.GenerationConfig";
                        };
    
                        return GenerationConfig;
                    })();
    
                    v1.GenerateContentResponse = (function() {
    
                        /**
                         * Properties of a GenerateContentResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IGenerateContentResponse
                         * @property {Array.<google.ai.generativelanguage.v1.ICandidate>|null} [candidates] GenerateContentResponse candidates
                         * @property {google.ai.generativelanguage.v1.GenerateContentResponse.IPromptFeedback|null} [promptFeedback] GenerateContentResponse promptFeedback
                         * @property {google.ai.generativelanguage.v1.GenerateContentResponse.IUsageMetadata|null} [usageMetadata] GenerateContentResponse usageMetadata
                         */
    
                        /**
                         * Constructs a new GenerateContentResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a GenerateContentResponse.
                         * @implements IGenerateContentResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IGenerateContentResponse=} [properties] Properties to set
                         */
                        function GenerateContentResponse(properties) {
                            this.candidates = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GenerateContentResponse candidates.
                         * @member {Array.<google.ai.generativelanguage.v1.ICandidate>} candidates
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @instance
                         */
                        GenerateContentResponse.prototype.candidates = $util.emptyArray;
    
                        /**
                         * GenerateContentResponse promptFeedback.
                         * @member {google.ai.generativelanguage.v1.GenerateContentResponse.IPromptFeedback|null|undefined} promptFeedback
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @instance
                         */
                        GenerateContentResponse.prototype.promptFeedback = null;
    
                        /**
                         * GenerateContentResponse usageMetadata.
                         * @member {google.ai.generativelanguage.v1.GenerateContentResponse.IUsageMetadata|null|undefined} usageMetadata
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @instance
                         */
                        GenerateContentResponse.prototype.usageMetadata = null;
    
                        /**
                         * Creates a new GenerateContentResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerateContentResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.GenerateContentResponse} GenerateContentResponse instance
                         */
                        GenerateContentResponse.create = function create(properties) {
                            return new GenerateContentResponse(properties);
                        };
    
                        /**
                         * Encodes the specified GenerateContentResponse message. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerateContentResponse} message GenerateContentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateContentResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.candidates != null && message.candidates.length)
                                for (var i = 0; i < message.candidates.length; ++i)
                                    $root.google.ai.generativelanguage.v1.Candidate.encode(message.candidates[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.promptFeedback != null && Object.hasOwnProperty.call(message, "promptFeedback"))
                                $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.encode(message.promptFeedback, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.usageMetadata != null && Object.hasOwnProperty.call(message, "usageMetadata"))
                                $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.encode(message.usageMetadata, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GenerateContentResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGenerateContentResponse} message GenerateContentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateContentResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GenerateContentResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.GenerateContentResponse} GenerateContentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateContentResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.GenerateContentResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.candidates && message.candidates.length))
                                            message.candidates = [];
                                        message.candidates.push($root.google.ai.generativelanguage.v1.Candidate.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.promptFeedback = $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.usageMetadata = $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GenerateContentResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.GenerateContentResponse} GenerateContentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateContentResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GenerateContentResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GenerateContentResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.candidates != null && message.hasOwnProperty("candidates")) {
                                if (!Array.isArray(message.candidates))
                                    return "candidates: array expected";
                                for (var i = 0; i < message.candidates.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.Candidate.verify(message.candidates[i]);
                                    if (error)
                                        return "candidates." + error;
                                }
                            }
                            if (message.promptFeedback != null && message.hasOwnProperty("promptFeedback")) {
                                var error = $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.verify(message.promptFeedback);
                                if (error)
                                    return "promptFeedback." + error;
                            }
                            if (message.usageMetadata != null && message.hasOwnProperty("usageMetadata")) {
                                var error = $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.verify(message.usageMetadata);
                                if (error)
                                    return "usageMetadata." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GenerateContentResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.GenerateContentResponse} GenerateContentResponse
                         */
                        GenerateContentResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.GenerateContentResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.GenerateContentResponse();
                            if (object.candidates) {
                                if (!Array.isArray(object.candidates))
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerateContentResponse.candidates: array expected");
                                message.candidates = [];
                                for (var i = 0; i < object.candidates.length; ++i) {
                                    if (typeof object.candidates[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.GenerateContentResponse.candidates: object expected");
                                    message.candidates[i] = $root.google.ai.generativelanguage.v1.Candidate.fromObject(object.candidates[i]);
                                }
                            }
                            if (object.promptFeedback != null) {
                                if (typeof object.promptFeedback !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerateContentResponse.promptFeedback: object expected");
                                message.promptFeedback = $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.fromObject(object.promptFeedback);
                            }
                            if (object.usageMetadata != null) {
                                if (typeof object.usageMetadata !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.GenerateContentResponse.usageMetadata: object expected");
                                message.usageMetadata = $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.fromObject(object.usageMetadata);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GenerateContentResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.GenerateContentResponse} message GenerateContentResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GenerateContentResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.candidates = [];
                            if (options.defaults) {
                                object.promptFeedback = null;
                                object.usageMetadata = null;
                            }
                            if (message.candidates && message.candidates.length) {
                                object.candidates = [];
                                for (var j = 0; j < message.candidates.length; ++j)
                                    object.candidates[j] = $root.google.ai.generativelanguage.v1.Candidate.toObject(message.candidates[j], options);
                            }
                            if (message.promptFeedback != null && message.hasOwnProperty("promptFeedback"))
                                object.promptFeedback = $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.toObject(message.promptFeedback, options);
                            if (message.usageMetadata != null && message.hasOwnProperty("usageMetadata"))
                                object.usageMetadata = $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.toObject(message.usageMetadata, options);
                            return object;
                        };
    
                        /**
                         * Converts this GenerateContentResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GenerateContentResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GenerateContentResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GenerateContentResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.GenerateContentResponse";
                        };
    
                        GenerateContentResponse.PromptFeedback = (function() {
    
                            /**
                             * Properties of a PromptFeedback.
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                             * @interface IPromptFeedback
                             * @property {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.BlockReason|null} [blockReason] PromptFeedback blockReason
                             * @property {Array.<google.ai.generativelanguage.v1.ISafetyRating>|null} [safetyRatings] PromptFeedback safetyRatings
                             */
    
                            /**
                             * Constructs a new PromptFeedback.
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                             * @classdesc Represents a PromptFeedback.
                             * @implements IPromptFeedback
                             * @constructor
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IPromptFeedback=} [properties] Properties to set
                             */
                            function PromptFeedback(properties) {
                                this.safetyRatings = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * PromptFeedback blockReason.
                             * @member {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.BlockReason} blockReason
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @instance
                             */
                            PromptFeedback.prototype.blockReason = 0;
    
                            /**
                             * PromptFeedback safetyRatings.
                             * @member {Array.<google.ai.generativelanguage.v1.ISafetyRating>} safetyRatings
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @instance
                             */
                            PromptFeedback.prototype.safetyRatings = $util.emptyArray;
    
                            /**
                             * Creates a new PromptFeedback instance using the specified properties.
                             * @function create
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IPromptFeedback=} [properties] Properties to set
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback} PromptFeedback instance
                             */
                            PromptFeedback.create = function create(properties) {
                                return new PromptFeedback(properties);
                            };
    
                            /**
                             * Encodes the specified PromptFeedback message. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.verify|verify} messages.
                             * @function encode
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IPromptFeedback} message PromptFeedback message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            PromptFeedback.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.blockReason != null && Object.hasOwnProperty.call(message, "blockReason"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.blockReason);
                                if (message.safetyRatings != null && message.safetyRatings.length)
                                    for (var i = 0; i < message.safetyRatings.length; ++i)
                                        $root.google.ai.generativelanguage.v1.SafetyRating.encode(message.safetyRatings[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified PromptFeedback message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IPromptFeedback} message PromptFeedback message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            PromptFeedback.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a PromptFeedback message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback} PromptFeedback
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            PromptFeedback.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.blockReason = reader.int32();
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.safetyRatings && message.safetyRatings.length))
                                                message.safetyRatings = [];
                                            message.safetyRatings.push($root.google.ai.generativelanguage.v1.SafetyRating.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a PromptFeedback message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback} PromptFeedback
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            PromptFeedback.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a PromptFeedback message.
                             * @function verify
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            PromptFeedback.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.blockReason != null && message.hasOwnProperty("blockReason"))
                                    switch (message.blockReason) {
                                    default:
                                        return "blockReason: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                        break;
                                    }
                                if (message.safetyRatings != null && message.hasOwnProperty("safetyRatings")) {
                                    if (!Array.isArray(message.safetyRatings))
                                        return "safetyRatings: array expected";
                                    for (var i = 0; i < message.safetyRatings.length; ++i) {
                                        var error = $root.google.ai.generativelanguage.v1.SafetyRating.verify(message.safetyRatings[i]);
                                        if (error)
                                            return "safetyRatings." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a PromptFeedback message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback} PromptFeedback
                             */
                            PromptFeedback.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback)
                                    return object;
                                var message = new $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback();
                                switch (object.blockReason) {
                                default:
                                    if (typeof object.blockReason === "number") {
                                        message.blockReason = object.blockReason;
                                        break;
                                    }
                                    break;
                                case "BLOCK_REASON_UNSPECIFIED":
                                case 0:
                                    message.blockReason = 0;
                                    break;
                                case "SAFETY":
                                case 1:
                                    message.blockReason = 1;
                                    break;
                                case "OTHER":
                                case 2:
                                    message.blockReason = 2;
                                    break;
                                }
                                if (object.safetyRatings) {
                                    if (!Array.isArray(object.safetyRatings))
                                        throw TypeError(".google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.safetyRatings: array expected");
                                    message.safetyRatings = [];
                                    for (var i = 0; i < object.safetyRatings.length; ++i) {
                                        if (typeof object.safetyRatings[i] !== "object")
                                            throw TypeError(".google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.safetyRatings: object expected");
                                        message.safetyRatings[i] = $root.google.ai.generativelanguage.v1.SafetyRating.fromObject(object.safetyRatings[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a PromptFeedback message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback} message PromptFeedback
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            PromptFeedback.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.safetyRatings = [];
                                if (options.defaults)
                                    object.blockReason = options.enums === String ? "BLOCK_REASON_UNSPECIFIED" : 0;
                                if (message.blockReason != null && message.hasOwnProperty("blockReason"))
                                    object.blockReason = options.enums === String ? $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.BlockReason[message.blockReason] === undefined ? message.blockReason : $root.google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.BlockReason[message.blockReason] : message.blockReason;
                                if (message.safetyRatings && message.safetyRatings.length) {
                                    object.safetyRatings = [];
                                    for (var j = 0; j < message.safetyRatings.length; ++j)
                                        object.safetyRatings[j] = $root.google.ai.generativelanguage.v1.SafetyRating.toObject(message.safetyRatings[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this PromptFeedback to JSON.
                             * @function toJSON
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            PromptFeedback.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for PromptFeedback
                             * @function getTypeUrl
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            PromptFeedback.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback";
                            };
    
                            /**
                             * BlockReason enum.
                             * @name google.ai.generativelanguage.v1.GenerateContentResponse.PromptFeedback.BlockReason
                             * @enum {number}
                             * @property {number} BLOCK_REASON_UNSPECIFIED=0 BLOCK_REASON_UNSPECIFIED value
                             * @property {number} SAFETY=1 SAFETY value
                             * @property {number} OTHER=2 OTHER value
                             */
                            PromptFeedback.BlockReason = (function() {
                                var valuesById = {}, values = Object.create(valuesById);
                                values[valuesById[0] = "BLOCK_REASON_UNSPECIFIED"] = 0;
                                values[valuesById[1] = "SAFETY"] = 1;
                                values[valuesById[2] = "OTHER"] = 2;
                                return values;
                            })();
    
                            return PromptFeedback;
                        })();
    
                        GenerateContentResponse.UsageMetadata = (function() {
    
                            /**
                             * Properties of a UsageMetadata.
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                             * @interface IUsageMetadata
                             * @property {number|null} [promptTokenCount] UsageMetadata promptTokenCount
                             * @property {number|null} [candidatesTokenCount] UsageMetadata candidatesTokenCount
                             * @property {number|null} [totalTokenCount] UsageMetadata totalTokenCount
                             */
    
                            /**
                             * Constructs a new UsageMetadata.
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse
                             * @classdesc Represents a UsageMetadata.
                             * @implements IUsageMetadata
                             * @constructor
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IUsageMetadata=} [properties] Properties to set
                             */
                            function UsageMetadata(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * UsageMetadata promptTokenCount.
                             * @member {number} promptTokenCount
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @instance
                             */
                            UsageMetadata.prototype.promptTokenCount = 0;
    
                            /**
                             * UsageMetadata candidatesTokenCount.
                             * @member {number} candidatesTokenCount
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @instance
                             */
                            UsageMetadata.prototype.candidatesTokenCount = 0;
    
                            /**
                             * UsageMetadata totalTokenCount.
                             * @member {number} totalTokenCount
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @instance
                             */
                            UsageMetadata.prototype.totalTokenCount = 0;
    
                            /**
                             * Creates a new UsageMetadata instance using the specified properties.
                             * @function create
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IUsageMetadata=} [properties] Properties to set
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata} UsageMetadata instance
                             */
                            UsageMetadata.create = function create(properties) {
                                return new UsageMetadata(properties);
                            };
    
                            /**
                             * Encodes the specified UsageMetadata message. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.verify|verify} messages.
                             * @function encode
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IUsageMetadata} message UsageMetadata message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UsageMetadata.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.promptTokenCount != null && Object.hasOwnProperty.call(message, "promptTokenCount"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.promptTokenCount);
                                if (message.candidatesTokenCount != null && Object.hasOwnProperty.call(message, "candidatesTokenCount"))
                                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.candidatesTokenCount);
                                if (message.totalTokenCount != null && Object.hasOwnProperty.call(message, "totalTokenCount"))
                                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.totalTokenCount);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified UsageMetadata message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.IUsageMetadata} message UsageMetadata message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UsageMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a UsageMetadata message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata} UsageMetadata
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UsageMetadata.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.promptTokenCount = reader.int32();
                                            break;
                                        }
                                    case 2: {
                                            message.candidatesTokenCount = reader.int32();
                                            break;
                                        }
                                    case 3: {
                                            message.totalTokenCount = reader.int32();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a UsageMetadata message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata} UsageMetadata
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UsageMetadata.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a UsageMetadata message.
                             * @function verify
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            UsageMetadata.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.promptTokenCount != null && message.hasOwnProperty("promptTokenCount"))
                                    if (!$util.isInteger(message.promptTokenCount))
                                        return "promptTokenCount: integer expected";
                                if (message.candidatesTokenCount != null && message.hasOwnProperty("candidatesTokenCount"))
                                    if (!$util.isInteger(message.candidatesTokenCount))
                                        return "candidatesTokenCount: integer expected";
                                if (message.totalTokenCount != null && message.hasOwnProperty("totalTokenCount"))
                                    if (!$util.isInteger(message.totalTokenCount))
                                        return "totalTokenCount: integer expected";
                                return null;
                            };
    
                            /**
                             * Creates a UsageMetadata message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata} UsageMetadata
                             */
                            UsageMetadata.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata)
                                    return object;
                                var message = new $root.google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata();
                                if (object.promptTokenCount != null)
                                    message.promptTokenCount = object.promptTokenCount | 0;
                                if (object.candidatesTokenCount != null)
                                    message.candidatesTokenCount = object.candidatesTokenCount | 0;
                                if (object.totalTokenCount != null)
                                    message.totalTokenCount = object.totalTokenCount | 0;
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a UsageMetadata message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata} message UsageMetadata
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            UsageMetadata.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.promptTokenCount = 0;
                                    object.candidatesTokenCount = 0;
                                    object.totalTokenCount = 0;
                                }
                                if (message.promptTokenCount != null && message.hasOwnProperty("promptTokenCount"))
                                    object.promptTokenCount = message.promptTokenCount;
                                if (message.candidatesTokenCount != null && message.hasOwnProperty("candidatesTokenCount"))
                                    object.candidatesTokenCount = message.candidatesTokenCount;
                                if (message.totalTokenCount != null && message.hasOwnProperty("totalTokenCount"))
                                    object.totalTokenCount = message.totalTokenCount;
                                return object;
                            };
    
                            /**
                             * Converts this UsageMetadata to JSON.
                             * @function toJSON
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            UsageMetadata.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for UsageMetadata
                             * @function getTypeUrl
                             * @memberof google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            UsageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.ai.generativelanguage.v1.GenerateContentResponse.UsageMetadata";
                            };
    
                            return UsageMetadata;
                        })();
    
                        return GenerateContentResponse;
                    })();
    
                    v1.Candidate = (function() {
    
                        /**
                         * Properties of a Candidate.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ICandidate
                         * @property {number|null} [index] Candidate index
                         * @property {google.ai.generativelanguage.v1.IContent|null} [content] Candidate content
                         * @property {google.ai.generativelanguage.v1.Candidate.FinishReason|null} [finishReason] Candidate finishReason
                         * @property {Array.<google.ai.generativelanguage.v1.ISafetyRating>|null} [safetyRatings] Candidate safetyRatings
                         * @property {google.ai.generativelanguage.v1.ICitationMetadata|null} [citationMetadata] Candidate citationMetadata
                         * @property {number|null} [tokenCount] Candidate tokenCount
                         */
    
                        /**
                         * Constructs a new Candidate.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a Candidate.
                         * @implements ICandidate
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ICandidate=} [properties] Properties to set
                         */
                        function Candidate(properties) {
                            this.safetyRatings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Candidate index.
                         * @member {number|null|undefined} index
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Candidate.prototype.index = null;
    
                        /**
                         * Candidate content.
                         * @member {google.ai.generativelanguage.v1.IContent|null|undefined} content
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Candidate.prototype.content = null;
    
                        /**
                         * Candidate finishReason.
                         * @member {google.ai.generativelanguage.v1.Candidate.FinishReason} finishReason
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Candidate.prototype.finishReason = 0;
    
                        /**
                         * Candidate safetyRatings.
                         * @member {Array.<google.ai.generativelanguage.v1.ISafetyRating>} safetyRatings
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Candidate.prototype.safetyRatings = $util.emptyArray;
    
                        /**
                         * Candidate citationMetadata.
                         * @member {google.ai.generativelanguage.v1.ICitationMetadata|null|undefined} citationMetadata
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Candidate.prototype.citationMetadata = null;
    
                        /**
                         * Candidate tokenCount.
                         * @member {number} tokenCount
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Candidate.prototype.tokenCount = 0;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Candidate _index.
                         * @member {"index"|undefined} _index
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         */
                        Object.defineProperty(Candidate.prototype, "_index", {
                            get: $util.oneOfGetter($oneOfFields = ["index"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Candidate instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICandidate=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.Candidate} Candidate instance
                         */
                        Candidate.create = function create(properties) {
                            return new Candidate(properties);
                        };
    
                        /**
                         * Encodes the specified Candidate message. Does not implicitly {@link google.ai.generativelanguage.v1.Candidate.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICandidate} message Candidate message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Candidate.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                $root.google.ai.generativelanguage.v1.Content.encode(message.content, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.finishReason != null && Object.hasOwnProperty.call(message, "finishReason"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.finishReason);
                            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.index);
                            if (message.safetyRatings != null && message.safetyRatings.length)
                                for (var i = 0; i < message.safetyRatings.length; ++i)
                                    $root.google.ai.generativelanguage.v1.SafetyRating.encode(message.safetyRatings[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.citationMetadata != null && Object.hasOwnProperty.call(message, "citationMetadata"))
                                $root.google.ai.generativelanguage.v1.CitationMetadata.encode(message.citationMetadata, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.tokenCount != null && Object.hasOwnProperty.call(message, "tokenCount"))
                                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.tokenCount);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Candidate message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.Candidate.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICandidate} message Candidate message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Candidate.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Candidate message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.Candidate} Candidate
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Candidate.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.Candidate();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3: {
                                        message.index = reader.int32();
                                        break;
                                    }
                                case 1: {
                                        message.content = $root.google.ai.generativelanguage.v1.Content.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.finishReason = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        if (!(message.safetyRatings && message.safetyRatings.length))
                                            message.safetyRatings = [];
                                        message.safetyRatings.push($root.google.ai.generativelanguage.v1.SafetyRating.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 6: {
                                        message.citationMetadata = $root.google.ai.generativelanguage.v1.CitationMetadata.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.tokenCount = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Candidate message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.Candidate} Candidate
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Candidate.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Candidate message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Candidate.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.index != null && message.hasOwnProperty("index")) {
                                properties._index = 1;
                                if (!$util.isInteger(message.index))
                                    return "index: integer expected";
                            }
                            if (message.content != null && message.hasOwnProperty("content")) {
                                var error = $root.google.ai.generativelanguage.v1.Content.verify(message.content);
                                if (error)
                                    return "content." + error;
                            }
                            if (message.finishReason != null && message.hasOwnProperty("finishReason"))
                                switch (message.finishReason) {
                                default:
                                    return "finishReason: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.safetyRatings != null && message.hasOwnProperty("safetyRatings")) {
                                if (!Array.isArray(message.safetyRatings))
                                    return "safetyRatings: array expected";
                                for (var i = 0; i < message.safetyRatings.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.SafetyRating.verify(message.safetyRatings[i]);
                                    if (error)
                                        return "safetyRatings." + error;
                                }
                            }
                            if (message.citationMetadata != null && message.hasOwnProperty("citationMetadata")) {
                                var error = $root.google.ai.generativelanguage.v1.CitationMetadata.verify(message.citationMetadata);
                                if (error)
                                    return "citationMetadata." + error;
                            }
                            if (message.tokenCount != null && message.hasOwnProperty("tokenCount"))
                                if (!$util.isInteger(message.tokenCount))
                                    return "tokenCount: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a Candidate message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.Candidate} Candidate
                         */
                        Candidate.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.Candidate)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.Candidate();
                            if (object.index != null)
                                message.index = object.index | 0;
                            if (object.content != null) {
                                if (typeof object.content !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.Candidate.content: object expected");
                                message.content = $root.google.ai.generativelanguage.v1.Content.fromObject(object.content);
                            }
                            switch (object.finishReason) {
                            default:
                                if (typeof object.finishReason === "number") {
                                    message.finishReason = object.finishReason;
                                    break;
                                }
                                break;
                            case "FINISH_REASON_UNSPECIFIED":
                            case 0:
                                message.finishReason = 0;
                                break;
                            case "STOP":
                            case 1:
                                message.finishReason = 1;
                                break;
                            case "MAX_TOKENS":
                            case 2:
                                message.finishReason = 2;
                                break;
                            case "SAFETY":
                            case 3:
                                message.finishReason = 3;
                                break;
                            case "RECITATION":
                            case 4:
                                message.finishReason = 4;
                                break;
                            case "OTHER":
                            case 5:
                                message.finishReason = 5;
                                break;
                            }
                            if (object.safetyRatings) {
                                if (!Array.isArray(object.safetyRatings))
                                    throw TypeError(".google.ai.generativelanguage.v1.Candidate.safetyRatings: array expected");
                                message.safetyRatings = [];
                                for (var i = 0; i < object.safetyRatings.length; ++i) {
                                    if (typeof object.safetyRatings[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.Candidate.safetyRatings: object expected");
                                    message.safetyRatings[i] = $root.google.ai.generativelanguage.v1.SafetyRating.fromObject(object.safetyRatings[i]);
                                }
                            }
                            if (object.citationMetadata != null) {
                                if (typeof object.citationMetadata !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.Candidate.citationMetadata: object expected");
                                message.citationMetadata = $root.google.ai.generativelanguage.v1.CitationMetadata.fromObject(object.citationMetadata);
                            }
                            if (object.tokenCount != null)
                                message.tokenCount = object.tokenCount | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Candidate message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {google.ai.generativelanguage.v1.Candidate} message Candidate
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Candidate.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.safetyRatings = [];
                            if (options.defaults) {
                                object.content = null;
                                object.finishReason = options.enums === String ? "FINISH_REASON_UNSPECIFIED" : 0;
                                object.citationMetadata = null;
                                object.tokenCount = 0;
                            }
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = $root.google.ai.generativelanguage.v1.Content.toObject(message.content, options);
                            if (message.finishReason != null && message.hasOwnProperty("finishReason"))
                                object.finishReason = options.enums === String ? $root.google.ai.generativelanguage.v1.Candidate.FinishReason[message.finishReason] === undefined ? message.finishReason : $root.google.ai.generativelanguage.v1.Candidate.FinishReason[message.finishReason] : message.finishReason;
                            if (message.index != null && message.hasOwnProperty("index")) {
                                object.index = message.index;
                                if (options.oneofs)
                                    object._index = "index";
                            }
                            if (message.safetyRatings && message.safetyRatings.length) {
                                object.safetyRatings = [];
                                for (var j = 0; j < message.safetyRatings.length; ++j)
                                    object.safetyRatings[j] = $root.google.ai.generativelanguage.v1.SafetyRating.toObject(message.safetyRatings[j], options);
                            }
                            if (message.citationMetadata != null && message.hasOwnProperty("citationMetadata"))
                                object.citationMetadata = $root.google.ai.generativelanguage.v1.CitationMetadata.toObject(message.citationMetadata, options);
                            if (message.tokenCount != null && message.hasOwnProperty("tokenCount"))
                                object.tokenCount = message.tokenCount;
                            return object;
                        };
    
                        /**
                         * Converts this Candidate to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Candidate.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Candidate
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.Candidate
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Candidate.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.Candidate";
                        };
    
                        /**
                         * FinishReason enum.
                         * @name google.ai.generativelanguage.v1.Candidate.FinishReason
                         * @enum {number}
                         * @property {number} FINISH_REASON_UNSPECIFIED=0 FINISH_REASON_UNSPECIFIED value
                         * @property {number} STOP=1 STOP value
                         * @property {number} MAX_TOKENS=2 MAX_TOKENS value
                         * @property {number} SAFETY=3 SAFETY value
                         * @property {number} RECITATION=4 RECITATION value
                         * @property {number} OTHER=5 OTHER value
                         */
                        Candidate.FinishReason = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "FINISH_REASON_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "STOP"] = 1;
                            values[valuesById[2] = "MAX_TOKENS"] = 2;
                            values[valuesById[3] = "SAFETY"] = 3;
                            values[valuesById[4] = "RECITATION"] = 4;
                            values[valuesById[5] = "OTHER"] = 5;
                            return values;
                        })();
    
                        return Candidate;
                    })();
    
                    v1.EmbedContentRequest = (function() {
    
                        /**
                         * Properties of an EmbedContentRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IEmbedContentRequest
                         * @property {string|null} [model] EmbedContentRequest model
                         * @property {google.ai.generativelanguage.v1.IContent|null} [content] EmbedContentRequest content
                         * @property {google.ai.generativelanguage.v1.TaskType|null} [taskType] EmbedContentRequest taskType
                         * @property {string|null} [title] EmbedContentRequest title
                         * @property {number|null} [outputDimensionality] EmbedContentRequest outputDimensionality
                         */
    
                        /**
                         * Constructs a new EmbedContentRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents an EmbedContentRequest.
                         * @implements IEmbedContentRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IEmbedContentRequest=} [properties] Properties to set
                         */
                        function EmbedContentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * EmbedContentRequest model.
                         * @member {string} model
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        EmbedContentRequest.prototype.model = "";
    
                        /**
                         * EmbedContentRequest content.
                         * @member {google.ai.generativelanguage.v1.IContent|null|undefined} content
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        EmbedContentRequest.prototype.content = null;
    
                        /**
                         * EmbedContentRequest taskType.
                         * @member {google.ai.generativelanguage.v1.TaskType|null|undefined} taskType
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        EmbedContentRequest.prototype.taskType = null;
    
                        /**
                         * EmbedContentRequest title.
                         * @member {string|null|undefined} title
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        EmbedContentRequest.prototype.title = null;
    
                        /**
                         * EmbedContentRequest outputDimensionality.
                         * @member {number|null|undefined} outputDimensionality
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        EmbedContentRequest.prototype.outputDimensionality = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * EmbedContentRequest _taskType.
                         * @member {"taskType"|undefined} _taskType
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        Object.defineProperty(EmbedContentRequest.prototype, "_taskType", {
                            get: $util.oneOfGetter($oneOfFields = ["taskType"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * EmbedContentRequest _title.
                         * @member {"title"|undefined} _title
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        Object.defineProperty(EmbedContentRequest.prototype, "_title", {
                            get: $util.oneOfGetter($oneOfFields = ["title"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * EmbedContentRequest _outputDimensionality.
                         * @member {"outputDimensionality"|undefined} _outputDimensionality
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         */
                        Object.defineProperty(EmbedContentRequest.prototype, "_outputDimensionality", {
                            get: $util.oneOfGetter($oneOfFields = ["outputDimensionality"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new EmbedContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IEmbedContentRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.EmbedContentRequest} EmbedContentRequest instance
                         */
                        EmbedContentRequest.create = function create(properties) {
                            return new EmbedContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified EmbedContentRequest message. Does not implicitly {@link google.ai.generativelanguage.v1.EmbedContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IEmbedContentRequest} message EmbedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EmbedContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.model);
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                $root.google.ai.generativelanguage.v1.Content.encode(message.content, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.taskType != null && Object.hasOwnProperty.call(message, "taskType"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.taskType);
                            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.title);
                            if (message.outputDimensionality != null && Object.hasOwnProperty.call(message, "outputDimensionality"))
                                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.outputDimensionality);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified EmbedContentRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.EmbedContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IEmbedContentRequest} message EmbedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EmbedContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an EmbedContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.EmbedContentRequest} EmbedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EmbedContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.EmbedContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.content = $root.google.ai.generativelanguage.v1.Content.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.taskType = reader.int32();
                                        break;
                                    }
                                case 4: {
                                        message.title = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.outputDimensionality = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an EmbedContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.EmbedContentRequest} EmbedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EmbedContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an EmbedContentRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EmbedContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.content != null && message.hasOwnProperty("content")) {
                                var error = $root.google.ai.generativelanguage.v1.Content.verify(message.content);
                                if (error)
                                    return "content." + error;
                            }
                            if (message.taskType != null && message.hasOwnProperty("taskType")) {
                                properties._taskType = 1;
                                switch (message.taskType) {
                                default:
                                    return "taskType: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                    break;
                                }
                            }
                            if (message.title != null && message.hasOwnProperty("title")) {
                                properties._title = 1;
                                if (!$util.isString(message.title))
                                    return "title: string expected";
                            }
                            if (message.outputDimensionality != null && message.hasOwnProperty("outputDimensionality")) {
                                properties._outputDimensionality = 1;
                                if (!$util.isInteger(message.outputDimensionality))
                                    return "outputDimensionality: integer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an EmbedContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.EmbedContentRequest} EmbedContentRequest
                         */
                        EmbedContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.EmbedContentRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.EmbedContentRequest();
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.content != null) {
                                if (typeof object.content !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.EmbedContentRequest.content: object expected");
                                message.content = $root.google.ai.generativelanguage.v1.Content.fromObject(object.content);
                            }
                            switch (object.taskType) {
                            default:
                                if (typeof object.taskType === "number") {
                                    message.taskType = object.taskType;
                                    break;
                                }
                                break;
                            case "TASK_TYPE_UNSPECIFIED":
                            case 0:
                                message.taskType = 0;
                                break;
                            case "RETRIEVAL_QUERY":
                            case 1:
                                message.taskType = 1;
                                break;
                            case "RETRIEVAL_DOCUMENT":
                            case 2:
                                message.taskType = 2;
                                break;
                            case "SEMANTIC_SIMILARITY":
                            case 3:
                                message.taskType = 3;
                                break;
                            case "CLASSIFICATION":
                            case 4:
                                message.taskType = 4;
                                break;
                            case "CLUSTERING":
                            case 5:
                                message.taskType = 5;
                                break;
                            case "QUESTION_ANSWERING":
                            case 6:
                                message.taskType = 6;
                                break;
                            case "FACT_VERIFICATION":
                            case 7:
                                message.taskType = 7;
                                break;
                            }
                            if (object.title != null)
                                message.title = String(object.title);
                            if (object.outputDimensionality != null)
                                message.outputDimensionality = object.outputDimensionality | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an EmbedContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.EmbedContentRequest} message EmbedContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EmbedContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.model = "";
                                object.content = null;
                            }
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = $root.google.ai.generativelanguage.v1.Content.toObject(message.content, options);
                            if (message.taskType != null && message.hasOwnProperty("taskType")) {
                                object.taskType = options.enums === String ? $root.google.ai.generativelanguage.v1.TaskType[message.taskType] === undefined ? message.taskType : $root.google.ai.generativelanguage.v1.TaskType[message.taskType] : message.taskType;
                                if (options.oneofs)
                                    object._taskType = "taskType";
                            }
                            if (message.title != null && message.hasOwnProperty("title")) {
                                object.title = message.title;
                                if (options.oneofs)
                                    object._title = "title";
                            }
                            if (message.outputDimensionality != null && message.hasOwnProperty("outputDimensionality")) {
                                object.outputDimensionality = message.outputDimensionality;
                                if (options.oneofs)
                                    object._outputDimensionality = "outputDimensionality";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this EmbedContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EmbedContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for EmbedContentRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.EmbedContentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        EmbedContentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.EmbedContentRequest";
                        };
    
                        return EmbedContentRequest;
                    })();
    
                    v1.ContentEmbedding = (function() {
    
                        /**
                         * Properties of a ContentEmbedding.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IContentEmbedding
                         * @property {Array.<number>|null} [values] ContentEmbedding values
                         */
    
                        /**
                         * Constructs a new ContentEmbedding.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a ContentEmbedding.
                         * @implements IContentEmbedding
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IContentEmbedding=} [properties] Properties to set
                         */
                        function ContentEmbedding(properties) {
                            this.values = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ContentEmbedding values.
                         * @member {Array.<number>} values
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @instance
                         */
                        ContentEmbedding.prototype.values = $util.emptyArray;
    
                        /**
                         * Creates a new ContentEmbedding instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {google.ai.generativelanguage.v1.IContentEmbedding=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.ContentEmbedding} ContentEmbedding instance
                         */
                        ContentEmbedding.create = function create(properties) {
                            return new ContentEmbedding(properties);
                        };
    
                        /**
                         * Encodes the specified ContentEmbedding message. Does not implicitly {@link google.ai.generativelanguage.v1.ContentEmbedding.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {google.ai.generativelanguage.v1.IContentEmbedding} message ContentEmbedding message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ContentEmbedding.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.values != null && message.values.length) {
                                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                                for (var i = 0; i < message.values.length; ++i)
                                    writer.float(message.values[i]);
                                writer.ldelim();
                            }
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ContentEmbedding message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.ContentEmbedding.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {google.ai.generativelanguage.v1.IContentEmbedding} message ContentEmbedding message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ContentEmbedding.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ContentEmbedding message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.ContentEmbedding} ContentEmbedding
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ContentEmbedding.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.ContentEmbedding();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.values && message.values.length))
                                            message.values = [];
                                        if ((tag & 7) === 2) {
                                            var end2 = reader.uint32() + reader.pos;
                                            while (reader.pos < end2)
                                                message.values.push(reader.float());
                                        } else
                                            message.values.push(reader.float());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ContentEmbedding message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.ContentEmbedding} ContentEmbedding
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ContentEmbedding.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ContentEmbedding message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ContentEmbedding.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.values != null && message.hasOwnProperty("values")) {
                                if (!Array.isArray(message.values))
                                    return "values: array expected";
                                for (var i = 0; i < message.values.length; ++i)
                                    if (typeof message.values[i] !== "number")
                                        return "values: number[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ContentEmbedding message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.ContentEmbedding} ContentEmbedding
                         */
                        ContentEmbedding.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.ContentEmbedding)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.ContentEmbedding();
                            if (object.values) {
                                if (!Array.isArray(object.values))
                                    throw TypeError(".google.ai.generativelanguage.v1.ContentEmbedding.values: array expected");
                                message.values = [];
                                for (var i = 0; i < object.values.length; ++i)
                                    message.values[i] = Number(object.values[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ContentEmbedding message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {google.ai.generativelanguage.v1.ContentEmbedding} message ContentEmbedding
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ContentEmbedding.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.values = [];
                            if (message.values && message.values.length) {
                                object.values = [];
                                for (var j = 0; j < message.values.length; ++j)
                                    object.values[j] = options.json && !isFinite(message.values[j]) ? String(message.values[j]) : message.values[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ContentEmbedding to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ContentEmbedding.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ContentEmbedding
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.ContentEmbedding
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ContentEmbedding.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.ContentEmbedding";
                        };
    
                        return ContentEmbedding;
                    })();
    
                    v1.EmbedContentResponse = (function() {
    
                        /**
                         * Properties of an EmbedContentResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IEmbedContentResponse
                         * @property {google.ai.generativelanguage.v1.IContentEmbedding|null} [embedding] EmbedContentResponse embedding
                         */
    
                        /**
                         * Constructs a new EmbedContentResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents an EmbedContentResponse.
                         * @implements IEmbedContentResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IEmbedContentResponse=} [properties] Properties to set
                         */
                        function EmbedContentResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * EmbedContentResponse embedding.
                         * @member {google.ai.generativelanguage.v1.IContentEmbedding|null|undefined} embedding
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @instance
                         */
                        EmbedContentResponse.prototype.embedding = null;
    
                        /**
                         * Creates a new EmbedContentResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IEmbedContentResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.EmbedContentResponse} EmbedContentResponse instance
                         */
                        EmbedContentResponse.create = function create(properties) {
                            return new EmbedContentResponse(properties);
                        };
    
                        /**
                         * Encodes the specified EmbedContentResponse message. Does not implicitly {@link google.ai.generativelanguage.v1.EmbedContentResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IEmbedContentResponse} message EmbedContentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EmbedContentResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.embedding != null && Object.hasOwnProperty.call(message, "embedding"))
                                $root.google.ai.generativelanguage.v1.ContentEmbedding.encode(message.embedding, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified EmbedContentResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.EmbedContentResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IEmbedContentResponse} message EmbedContentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EmbedContentResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an EmbedContentResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.EmbedContentResponse} EmbedContentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EmbedContentResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.EmbedContentResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.embedding = $root.google.ai.generativelanguage.v1.ContentEmbedding.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an EmbedContentResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.EmbedContentResponse} EmbedContentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EmbedContentResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an EmbedContentResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EmbedContentResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.embedding != null && message.hasOwnProperty("embedding")) {
                                var error = $root.google.ai.generativelanguage.v1.ContentEmbedding.verify(message.embedding);
                                if (error)
                                    return "embedding." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an EmbedContentResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.EmbedContentResponse} EmbedContentResponse
                         */
                        EmbedContentResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.EmbedContentResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.EmbedContentResponse();
                            if (object.embedding != null) {
                                if (typeof object.embedding !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.EmbedContentResponse.embedding: object expected");
                                message.embedding = $root.google.ai.generativelanguage.v1.ContentEmbedding.fromObject(object.embedding);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an EmbedContentResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.EmbedContentResponse} message EmbedContentResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EmbedContentResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.embedding = null;
                            if (message.embedding != null && message.hasOwnProperty("embedding"))
                                object.embedding = $root.google.ai.generativelanguage.v1.ContentEmbedding.toObject(message.embedding, options);
                            return object;
                        };
    
                        /**
                         * Converts this EmbedContentResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EmbedContentResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for EmbedContentResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.EmbedContentResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        EmbedContentResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.EmbedContentResponse";
                        };
    
                        return EmbedContentResponse;
                    })();
    
                    v1.BatchEmbedContentsRequest = (function() {
    
                        /**
                         * Properties of a BatchEmbedContentsRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IBatchEmbedContentsRequest
                         * @property {string|null} [model] BatchEmbedContentsRequest model
                         * @property {Array.<google.ai.generativelanguage.v1.IEmbedContentRequest>|null} [requests] BatchEmbedContentsRequest requests
                         */
    
                        /**
                         * Constructs a new BatchEmbedContentsRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a BatchEmbedContentsRequest.
                         * @implements IBatchEmbedContentsRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsRequest=} [properties] Properties to set
                         */
                        function BatchEmbedContentsRequest(properties) {
                            this.requests = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchEmbedContentsRequest model.
                         * @member {string} model
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @instance
                         */
                        BatchEmbedContentsRequest.prototype.model = "";
    
                        /**
                         * BatchEmbedContentsRequest requests.
                         * @member {Array.<google.ai.generativelanguage.v1.IEmbedContentRequest>} requests
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @instance
                         */
                        BatchEmbedContentsRequest.prototype.requests = $util.emptyArray;
    
                        /**
                         * Creates a new BatchEmbedContentsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsRequest} BatchEmbedContentsRequest instance
                         */
                        BatchEmbedContentsRequest.create = function create(properties) {
                            return new BatchEmbedContentsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified BatchEmbedContentsRequest message. Does not implicitly {@link google.ai.generativelanguage.v1.BatchEmbedContentsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsRequest} message BatchEmbedContentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchEmbedContentsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.model);
                            if (message.requests != null && message.requests.length)
                                for (var i = 0; i < message.requests.length; ++i)
                                    $root.google.ai.generativelanguage.v1.EmbedContentRequest.encode(message.requests[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchEmbedContentsRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.BatchEmbedContentsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsRequest} message BatchEmbedContentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchEmbedContentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchEmbedContentsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsRequest} BatchEmbedContentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchEmbedContentsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.BatchEmbedContentsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.requests && message.requests.length))
                                            message.requests = [];
                                        message.requests.push($root.google.ai.generativelanguage.v1.EmbedContentRequest.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchEmbedContentsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsRequest} BatchEmbedContentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchEmbedContentsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchEmbedContentsRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchEmbedContentsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.requests != null && message.hasOwnProperty("requests")) {
                                if (!Array.isArray(message.requests))
                                    return "requests: array expected";
                                for (var i = 0; i < message.requests.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.EmbedContentRequest.verify(message.requests[i]);
                                    if (error)
                                        return "requests." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchEmbedContentsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsRequest} BatchEmbedContentsRequest
                         */
                        BatchEmbedContentsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.BatchEmbedContentsRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.BatchEmbedContentsRequest();
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.requests) {
                                if (!Array.isArray(object.requests))
                                    throw TypeError(".google.ai.generativelanguage.v1.BatchEmbedContentsRequest.requests: array expected");
                                message.requests = [];
                                for (var i = 0; i < object.requests.length; ++i) {
                                    if (typeof object.requests[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.BatchEmbedContentsRequest.requests: object expected");
                                    message.requests[i] = $root.google.ai.generativelanguage.v1.EmbedContentRequest.fromObject(object.requests[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchEmbedContentsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.BatchEmbedContentsRequest} message BatchEmbedContentsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchEmbedContentsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.requests = [];
                            if (options.defaults)
                                object.model = "";
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.requests && message.requests.length) {
                                object.requests = [];
                                for (var j = 0; j < message.requests.length; ++j)
                                    object.requests[j] = $root.google.ai.generativelanguage.v1.EmbedContentRequest.toObject(message.requests[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchEmbedContentsRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchEmbedContentsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchEmbedContentsRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchEmbedContentsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.BatchEmbedContentsRequest";
                        };
    
                        return BatchEmbedContentsRequest;
                    })();
    
                    v1.BatchEmbedContentsResponse = (function() {
    
                        /**
                         * Properties of a BatchEmbedContentsResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IBatchEmbedContentsResponse
                         * @property {Array.<google.ai.generativelanguage.v1.IContentEmbedding>|null} [embeddings] BatchEmbedContentsResponse embeddings
                         */
    
                        /**
                         * Constructs a new BatchEmbedContentsResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a BatchEmbedContentsResponse.
                         * @implements IBatchEmbedContentsResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsResponse=} [properties] Properties to set
                         */
                        function BatchEmbedContentsResponse(properties) {
                            this.embeddings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchEmbedContentsResponse embeddings.
                         * @member {Array.<google.ai.generativelanguage.v1.IContentEmbedding>} embeddings
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @instance
                         */
                        BatchEmbedContentsResponse.prototype.embeddings = $util.emptyArray;
    
                        /**
                         * Creates a new BatchEmbedContentsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsResponse} BatchEmbedContentsResponse instance
                         */
                        BatchEmbedContentsResponse.create = function create(properties) {
                            return new BatchEmbedContentsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified BatchEmbedContentsResponse message. Does not implicitly {@link google.ai.generativelanguage.v1.BatchEmbedContentsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsResponse} message BatchEmbedContentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchEmbedContentsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.embeddings != null && message.embeddings.length)
                                for (var i = 0; i < message.embeddings.length; ++i)
                                    $root.google.ai.generativelanguage.v1.ContentEmbedding.encode(message.embeddings[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchEmbedContentsResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.BatchEmbedContentsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IBatchEmbedContentsResponse} message BatchEmbedContentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchEmbedContentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchEmbedContentsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsResponse} BatchEmbedContentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchEmbedContentsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.BatchEmbedContentsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.embeddings && message.embeddings.length))
                                            message.embeddings = [];
                                        message.embeddings.push($root.google.ai.generativelanguage.v1.ContentEmbedding.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchEmbedContentsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsResponse} BatchEmbedContentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchEmbedContentsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchEmbedContentsResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchEmbedContentsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.embeddings != null && message.hasOwnProperty("embeddings")) {
                                if (!Array.isArray(message.embeddings))
                                    return "embeddings: array expected";
                                for (var i = 0; i < message.embeddings.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.ContentEmbedding.verify(message.embeddings[i]);
                                    if (error)
                                        return "embeddings." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchEmbedContentsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.BatchEmbedContentsResponse} BatchEmbedContentsResponse
                         */
                        BatchEmbedContentsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.BatchEmbedContentsResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.BatchEmbedContentsResponse();
                            if (object.embeddings) {
                                if (!Array.isArray(object.embeddings))
                                    throw TypeError(".google.ai.generativelanguage.v1.BatchEmbedContentsResponse.embeddings: array expected");
                                message.embeddings = [];
                                for (var i = 0; i < object.embeddings.length; ++i) {
                                    if (typeof object.embeddings[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.BatchEmbedContentsResponse.embeddings: object expected");
                                    message.embeddings[i] = $root.google.ai.generativelanguage.v1.ContentEmbedding.fromObject(object.embeddings[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchEmbedContentsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.BatchEmbedContentsResponse} message BatchEmbedContentsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchEmbedContentsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.embeddings = [];
                            if (message.embeddings && message.embeddings.length) {
                                object.embeddings = [];
                                for (var j = 0; j < message.embeddings.length; ++j)
                                    object.embeddings[j] = $root.google.ai.generativelanguage.v1.ContentEmbedding.toObject(message.embeddings[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchEmbedContentsResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchEmbedContentsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchEmbedContentsResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.BatchEmbedContentsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchEmbedContentsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.BatchEmbedContentsResponse";
                        };
    
                        return BatchEmbedContentsResponse;
                    })();
    
                    v1.CountTokensRequest = (function() {
    
                        /**
                         * Properties of a CountTokensRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ICountTokensRequest
                         * @property {string|null} [model] CountTokensRequest model
                         * @property {Array.<google.ai.generativelanguage.v1.IContent>|null} [contents] CountTokensRequest contents
                         * @property {google.ai.generativelanguage.v1.IGenerateContentRequest|null} [generateContentRequest] CountTokensRequest generateContentRequest
                         */
    
                        /**
                         * Constructs a new CountTokensRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a CountTokensRequest.
                         * @implements ICountTokensRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ICountTokensRequest=} [properties] Properties to set
                         */
                        function CountTokensRequest(properties) {
                            this.contents = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CountTokensRequest model.
                         * @member {string} model
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @instance
                         */
                        CountTokensRequest.prototype.model = "";
    
                        /**
                         * CountTokensRequest contents.
                         * @member {Array.<google.ai.generativelanguage.v1.IContent>} contents
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @instance
                         */
                        CountTokensRequest.prototype.contents = $util.emptyArray;
    
                        /**
                         * CountTokensRequest generateContentRequest.
                         * @member {google.ai.generativelanguage.v1.IGenerateContentRequest|null|undefined} generateContentRequest
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @instance
                         */
                        CountTokensRequest.prototype.generateContentRequest = null;
    
                        /**
                         * Creates a new CountTokensRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICountTokensRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.CountTokensRequest} CountTokensRequest instance
                         */
                        CountTokensRequest.create = function create(properties) {
                            return new CountTokensRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CountTokensRequest message. Does not implicitly {@link google.ai.generativelanguage.v1.CountTokensRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICountTokensRequest} message CountTokensRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CountTokensRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.model);
                            if (message.contents != null && message.contents.length)
                                for (var i = 0; i < message.contents.length; ++i)
                                    $root.google.ai.generativelanguage.v1.Content.encode(message.contents[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.generateContentRequest != null && Object.hasOwnProperty.call(message, "generateContentRequest"))
                                $root.google.ai.generativelanguage.v1.GenerateContentRequest.encode(message.generateContentRequest, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CountTokensRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.CountTokensRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICountTokensRequest} message CountTokensRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CountTokensRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CountTokensRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.CountTokensRequest} CountTokensRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CountTokensRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.CountTokensRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.contents && message.contents.length))
                                            message.contents = [];
                                        message.contents.push($root.google.ai.generativelanguage.v1.Content.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.generateContentRequest = $root.google.ai.generativelanguage.v1.GenerateContentRequest.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CountTokensRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.CountTokensRequest} CountTokensRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CountTokensRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CountTokensRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CountTokensRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.contents != null && message.hasOwnProperty("contents")) {
                                if (!Array.isArray(message.contents))
                                    return "contents: array expected";
                                for (var i = 0; i < message.contents.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.Content.verify(message.contents[i]);
                                    if (error)
                                        return "contents." + error;
                                }
                            }
                            if (message.generateContentRequest != null && message.hasOwnProperty("generateContentRequest")) {
                                var error = $root.google.ai.generativelanguage.v1.GenerateContentRequest.verify(message.generateContentRequest);
                                if (error)
                                    return "generateContentRequest." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CountTokensRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.CountTokensRequest} CountTokensRequest
                         */
                        CountTokensRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.CountTokensRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.CountTokensRequest();
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.contents) {
                                if (!Array.isArray(object.contents))
                                    throw TypeError(".google.ai.generativelanguage.v1.CountTokensRequest.contents: array expected");
                                message.contents = [];
                                for (var i = 0; i < object.contents.length; ++i) {
                                    if (typeof object.contents[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.CountTokensRequest.contents: object expected");
                                    message.contents[i] = $root.google.ai.generativelanguage.v1.Content.fromObject(object.contents[i]);
                                }
                            }
                            if (object.generateContentRequest != null) {
                                if (typeof object.generateContentRequest !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1.CountTokensRequest.generateContentRequest: object expected");
                                message.generateContentRequest = $root.google.ai.generativelanguage.v1.GenerateContentRequest.fromObject(object.generateContentRequest);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CountTokensRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.CountTokensRequest} message CountTokensRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CountTokensRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.contents = [];
                            if (options.defaults) {
                                object.model = "";
                                object.generateContentRequest = null;
                            }
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.contents && message.contents.length) {
                                object.contents = [];
                                for (var j = 0; j < message.contents.length; ++j)
                                    object.contents[j] = $root.google.ai.generativelanguage.v1.Content.toObject(message.contents[j], options);
                            }
                            if (message.generateContentRequest != null && message.hasOwnProperty("generateContentRequest"))
                                object.generateContentRequest = $root.google.ai.generativelanguage.v1.GenerateContentRequest.toObject(message.generateContentRequest, options);
                            return object;
                        };
    
                        /**
                         * Converts this CountTokensRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CountTokensRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CountTokensRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.CountTokensRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CountTokensRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.CountTokensRequest";
                        };
    
                        return CountTokensRequest;
                    })();
    
                    v1.CountTokensResponse = (function() {
    
                        /**
                         * Properties of a CountTokensResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ICountTokensResponse
                         * @property {number|null} [totalTokens] CountTokensResponse totalTokens
                         */
    
                        /**
                         * Constructs a new CountTokensResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a CountTokensResponse.
                         * @implements ICountTokensResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ICountTokensResponse=} [properties] Properties to set
                         */
                        function CountTokensResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CountTokensResponse totalTokens.
                         * @member {number} totalTokens
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @instance
                         */
                        CountTokensResponse.prototype.totalTokens = 0;
    
                        /**
                         * Creates a new CountTokensResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICountTokensResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.CountTokensResponse} CountTokensResponse instance
                         */
                        CountTokensResponse.create = function create(properties) {
                            return new CountTokensResponse(properties);
                        };
    
                        /**
                         * Encodes the specified CountTokensResponse message. Does not implicitly {@link google.ai.generativelanguage.v1.CountTokensResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICountTokensResponse} message CountTokensResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CountTokensResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.totalTokens != null && Object.hasOwnProperty.call(message, "totalTokens"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.totalTokens);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CountTokensResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.CountTokensResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.ICountTokensResponse} message CountTokensResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CountTokensResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CountTokensResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.CountTokensResponse} CountTokensResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CountTokensResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.CountTokensResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.totalTokens = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CountTokensResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.CountTokensResponse} CountTokensResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CountTokensResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CountTokensResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CountTokensResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.totalTokens != null && message.hasOwnProperty("totalTokens"))
                                if (!$util.isInteger(message.totalTokens))
                                    return "totalTokens: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a CountTokensResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.CountTokensResponse} CountTokensResponse
                         */
                        CountTokensResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.CountTokensResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.CountTokensResponse();
                            if (object.totalTokens != null)
                                message.totalTokens = object.totalTokens | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CountTokensResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.CountTokensResponse} message CountTokensResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CountTokensResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.totalTokens = 0;
                            if (message.totalTokens != null && message.hasOwnProperty("totalTokens"))
                                object.totalTokens = message.totalTokens;
                            return object;
                        };
    
                        /**
                         * Converts this CountTokensResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CountTokensResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CountTokensResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.CountTokensResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CountTokensResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.CountTokensResponse";
                        };
    
                        return CountTokensResponse;
                    })();
    
                    /**
                     * HarmCategory enum.
                     * @name google.ai.generativelanguage.v1.HarmCategory
                     * @enum {number}
                     * @property {number} HARM_CATEGORY_UNSPECIFIED=0 HARM_CATEGORY_UNSPECIFIED value
                     * @property {number} HARM_CATEGORY_DEROGATORY=1 HARM_CATEGORY_DEROGATORY value
                     * @property {number} HARM_CATEGORY_TOXICITY=2 HARM_CATEGORY_TOXICITY value
                     * @property {number} HARM_CATEGORY_VIOLENCE=3 HARM_CATEGORY_VIOLENCE value
                     * @property {number} HARM_CATEGORY_SEXUAL=4 HARM_CATEGORY_SEXUAL value
                     * @property {number} HARM_CATEGORY_MEDICAL=5 HARM_CATEGORY_MEDICAL value
                     * @property {number} HARM_CATEGORY_DANGEROUS=6 HARM_CATEGORY_DANGEROUS value
                     * @property {number} HARM_CATEGORY_HARASSMENT=7 HARM_CATEGORY_HARASSMENT value
                     * @property {number} HARM_CATEGORY_HATE_SPEECH=8 HARM_CATEGORY_HATE_SPEECH value
                     * @property {number} HARM_CATEGORY_SEXUALLY_EXPLICIT=9 HARM_CATEGORY_SEXUALLY_EXPLICIT value
                     * @property {number} HARM_CATEGORY_DANGEROUS_CONTENT=10 HARM_CATEGORY_DANGEROUS_CONTENT value
                     */
                    v1.HarmCategory = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "HARM_CATEGORY_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "HARM_CATEGORY_DEROGATORY"] = 1;
                        values[valuesById[2] = "HARM_CATEGORY_TOXICITY"] = 2;
                        values[valuesById[3] = "HARM_CATEGORY_VIOLENCE"] = 3;
                        values[valuesById[4] = "HARM_CATEGORY_SEXUAL"] = 4;
                        values[valuesById[5] = "HARM_CATEGORY_MEDICAL"] = 5;
                        values[valuesById[6] = "HARM_CATEGORY_DANGEROUS"] = 6;
                        values[valuesById[7] = "HARM_CATEGORY_HARASSMENT"] = 7;
                        values[valuesById[8] = "HARM_CATEGORY_HATE_SPEECH"] = 8;
                        values[valuesById[9] = "HARM_CATEGORY_SEXUALLY_EXPLICIT"] = 9;
                        values[valuesById[10] = "HARM_CATEGORY_DANGEROUS_CONTENT"] = 10;
                        return values;
                    })();
    
                    v1.SafetyRating = (function() {
    
                        /**
                         * Properties of a SafetyRating.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ISafetyRating
                         * @property {google.ai.generativelanguage.v1.HarmCategory|null} [category] SafetyRating category
                         * @property {google.ai.generativelanguage.v1.SafetyRating.HarmProbability|null} [probability] SafetyRating probability
                         * @property {boolean|null} [blocked] SafetyRating blocked
                         */
    
                        /**
                         * Constructs a new SafetyRating.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a SafetyRating.
                         * @implements ISafetyRating
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ISafetyRating=} [properties] Properties to set
                         */
                        function SafetyRating(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SafetyRating category.
                         * @member {google.ai.generativelanguage.v1.HarmCategory} category
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @instance
                         */
                        SafetyRating.prototype.category = 0;
    
                        /**
                         * SafetyRating probability.
                         * @member {google.ai.generativelanguage.v1.SafetyRating.HarmProbability} probability
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @instance
                         */
                        SafetyRating.prototype.probability = 0;
    
                        /**
                         * SafetyRating blocked.
                         * @member {boolean} blocked
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @instance
                         */
                        SafetyRating.prototype.blocked = false;
    
                        /**
                         * Creates a new SafetyRating instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {google.ai.generativelanguage.v1.ISafetyRating=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.SafetyRating} SafetyRating instance
                         */
                        SafetyRating.create = function create(properties) {
                            return new SafetyRating(properties);
                        };
    
                        /**
                         * Encodes the specified SafetyRating message. Does not implicitly {@link google.ai.generativelanguage.v1.SafetyRating.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {google.ai.generativelanguage.v1.ISafetyRating} message SafetyRating message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SafetyRating.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.category != null && Object.hasOwnProperty.call(message, "category"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.category);
                            if (message.probability != null && Object.hasOwnProperty.call(message, "probability"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.probability);
                            if (message.blocked != null && Object.hasOwnProperty.call(message, "blocked"))
                                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.blocked);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SafetyRating message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.SafetyRating.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {google.ai.generativelanguage.v1.ISafetyRating} message SafetyRating message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SafetyRating.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SafetyRating message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.SafetyRating} SafetyRating
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SafetyRating.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.SafetyRating();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3: {
                                        message.category = reader.int32();
                                        break;
                                    }
                                case 4: {
                                        message.probability = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.blocked = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SafetyRating message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.SafetyRating} SafetyRating
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SafetyRating.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SafetyRating message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SafetyRating.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.category != null && message.hasOwnProperty("category"))
                                switch (message.category) {
                                default:
                                    return "category: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                case 8:
                                case 9:
                                case 10:
                                    break;
                                }
                            if (message.probability != null && message.hasOwnProperty("probability"))
                                switch (message.probability) {
                                default:
                                    return "probability: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                    break;
                                }
                            if (message.blocked != null && message.hasOwnProperty("blocked"))
                                if (typeof message.blocked !== "boolean")
                                    return "blocked: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a SafetyRating message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.SafetyRating} SafetyRating
                         */
                        SafetyRating.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.SafetyRating)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.SafetyRating();
                            switch (object.category) {
                            default:
                                if (typeof object.category === "number") {
                                    message.category = object.category;
                                    break;
                                }
                                break;
                            case "HARM_CATEGORY_UNSPECIFIED":
                            case 0:
                                message.category = 0;
                                break;
                            case "HARM_CATEGORY_DEROGATORY":
                            case 1:
                                message.category = 1;
                                break;
                            case "HARM_CATEGORY_TOXICITY":
                            case 2:
                                message.category = 2;
                                break;
                            case "HARM_CATEGORY_VIOLENCE":
                            case 3:
                                message.category = 3;
                                break;
                            case "HARM_CATEGORY_SEXUAL":
                            case 4:
                                message.category = 4;
                                break;
                            case "HARM_CATEGORY_MEDICAL":
                            case 5:
                                message.category = 5;
                                break;
                            case "HARM_CATEGORY_DANGEROUS":
                            case 6:
                                message.category = 6;
                                break;
                            case "HARM_CATEGORY_HARASSMENT":
                            case 7:
                                message.category = 7;
                                break;
                            case "HARM_CATEGORY_HATE_SPEECH":
                            case 8:
                                message.category = 8;
                                break;
                            case "HARM_CATEGORY_SEXUALLY_EXPLICIT":
                            case 9:
                                message.category = 9;
                                break;
                            case "HARM_CATEGORY_DANGEROUS_CONTENT":
                            case 10:
                                message.category = 10;
                                break;
                            }
                            switch (object.probability) {
                            default:
                                if (typeof object.probability === "number") {
                                    message.probability = object.probability;
                                    break;
                                }
                                break;
                            case "HARM_PROBABILITY_UNSPECIFIED":
                            case 0:
                                message.probability = 0;
                                break;
                            case "NEGLIGIBLE":
                            case 1:
                                message.probability = 1;
                                break;
                            case "LOW":
                            case 2:
                                message.probability = 2;
                                break;
                            case "MEDIUM":
                            case 3:
                                message.probability = 3;
                                break;
                            case "HIGH":
                            case 4:
                                message.probability = 4;
                                break;
                            }
                            if (object.blocked != null)
                                message.blocked = Boolean(object.blocked);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SafetyRating message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {google.ai.generativelanguage.v1.SafetyRating} message SafetyRating
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SafetyRating.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.category = options.enums === String ? "HARM_CATEGORY_UNSPECIFIED" : 0;
                                object.probability = options.enums === String ? "HARM_PROBABILITY_UNSPECIFIED" : 0;
                                object.blocked = false;
                            }
                            if (message.category != null && message.hasOwnProperty("category"))
                                object.category = options.enums === String ? $root.google.ai.generativelanguage.v1.HarmCategory[message.category] === undefined ? message.category : $root.google.ai.generativelanguage.v1.HarmCategory[message.category] : message.category;
                            if (message.probability != null && message.hasOwnProperty("probability"))
                                object.probability = options.enums === String ? $root.google.ai.generativelanguage.v1.SafetyRating.HarmProbability[message.probability] === undefined ? message.probability : $root.google.ai.generativelanguage.v1.SafetyRating.HarmProbability[message.probability] : message.probability;
                            if (message.blocked != null && message.hasOwnProperty("blocked"))
                                object.blocked = message.blocked;
                            return object;
                        };
    
                        /**
                         * Converts this SafetyRating to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SafetyRating.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SafetyRating
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.SafetyRating
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SafetyRating.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.SafetyRating";
                        };
    
                        /**
                         * HarmProbability enum.
                         * @name google.ai.generativelanguage.v1.SafetyRating.HarmProbability
                         * @enum {number}
                         * @property {number} HARM_PROBABILITY_UNSPECIFIED=0 HARM_PROBABILITY_UNSPECIFIED value
                         * @property {number} NEGLIGIBLE=1 NEGLIGIBLE value
                         * @property {number} LOW=2 LOW value
                         * @property {number} MEDIUM=3 MEDIUM value
                         * @property {number} HIGH=4 HIGH value
                         */
                        SafetyRating.HarmProbability = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "HARM_PROBABILITY_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "NEGLIGIBLE"] = 1;
                            values[valuesById[2] = "LOW"] = 2;
                            values[valuesById[3] = "MEDIUM"] = 3;
                            values[valuesById[4] = "HIGH"] = 4;
                            return values;
                        })();
    
                        return SafetyRating;
                    })();
    
                    v1.SafetySetting = (function() {
    
                        /**
                         * Properties of a SafetySetting.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface ISafetySetting
                         * @property {google.ai.generativelanguage.v1.HarmCategory|null} [category] SafetySetting category
                         * @property {google.ai.generativelanguage.v1.SafetySetting.HarmBlockThreshold|null} [threshold] SafetySetting threshold
                         */
    
                        /**
                         * Constructs a new SafetySetting.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a SafetySetting.
                         * @implements ISafetySetting
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.ISafetySetting=} [properties] Properties to set
                         */
                        function SafetySetting(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SafetySetting category.
                         * @member {google.ai.generativelanguage.v1.HarmCategory} category
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @instance
                         */
                        SafetySetting.prototype.category = 0;
    
                        /**
                         * SafetySetting threshold.
                         * @member {google.ai.generativelanguage.v1.SafetySetting.HarmBlockThreshold} threshold
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @instance
                         */
                        SafetySetting.prototype.threshold = 0;
    
                        /**
                         * Creates a new SafetySetting instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {google.ai.generativelanguage.v1.ISafetySetting=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.SafetySetting} SafetySetting instance
                         */
                        SafetySetting.create = function create(properties) {
                            return new SafetySetting(properties);
                        };
    
                        /**
                         * Encodes the specified SafetySetting message. Does not implicitly {@link google.ai.generativelanguage.v1.SafetySetting.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {google.ai.generativelanguage.v1.ISafetySetting} message SafetySetting message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SafetySetting.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.category != null && Object.hasOwnProperty.call(message, "category"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.category);
                            if (message.threshold != null && Object.hasOwnProperty.call(message, "threshold"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.threshold);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SafetySetting message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.SafetySetting.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {google.ai.generativelanguage.v1.ISafetySetting} message SafetySetting message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SafetySetting.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SafetySetting message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.SafetySetting} SafetySetting
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SafetySetting.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.SafetySetting();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3: {
                                        message.category = reader.int32();
                                        break;
                                    }
                                case 4: {
                                        message.threshold = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SafetySetting message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.SafetySetting} SafetySetting
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SafetySetting.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SafetySetting message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SafetySetting.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.category != null && message.hasOwnProperty("category"))
                                switch (message.category) {
                                default:
                                    return "category: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                case 8:
                                case 9:
                                case 10:
                                    break;
                                }
                            if (message.threshold != null && message.hasOwnProperty("threshold"))
                                switch (message.threshold) {
                                default:
                                    return "threshold: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a SafetySetting message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.SafetySetting} SafetySetting
                         */
                        SafetySetting.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.SafetySetting)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.SafetySetting();
                            switch (object.category) {
                            default:
                                if (typeof object.category === "number") {
                                    message.category = object.category;
                                    break;
                                }
                                break;
                            case "HARM_CATEGORY_UNSPECIFIED":
                            case 0:
                                message.category = 0;
                                break;
                            case "HARM_CATEGORY_DEROGATORY":
                            case 1:
                                message.category = 1;
                                break;
                            case "HARM_CATEGORY_TOXICITY":
                            case 2:
                                message.category = 2;
                                break;
                            case "HARM_CATEGORY_VIOLENCE":
                            case 3:
                                message.category = 3;
                                break;
                            case "HARM_CATEGORY_SEXUAL":
                            case 4:
                                message.category = 4;
                                break;
                            case "HARM_CATEGORY_MEDICAL":
                            case 5:
                                message.category = 5;
                                break;
                            case "HARM_CATEGORY_DANGEROUS":
                            case 6:
                                message.category = 6;
                                break;
                            case "HARM_CATEGORY_HARASSMENT":
                            case 7:
                                message.category = 7;
                                break;
                            case "HARM_CATEGORY_HATE_SPEECH":
                            case 8:
                                message.category = 8;
                                break;
                            case "HARM_CATEGORY_SEXUALLY_EXPLICIT":
                            case 9:
                                message.category = 9;
                                break;
                            case "HARM_CATEGORY_DANGEROUS_CONTENT":
                            case 10:
                                message.category = 10;
                                break;
                            }
                            switch (object.threshold) {
                            default:
                                if (typeof object.threshold === "number") {
                                    message.threshold = object.threshold;
                                    break;
                                }
                                break;
                            case "HARM_BLOCK_THRESHOLD_UNSPECIFIED":
                            case 0:
                                message.threshold = 0;
                                break;
                            case "BLOCK_LOW_AND_ABOVE":
                            case 1:
                                message.threshold = 1;
                                break;
                            case "BLOCK_MEDIUM_AND_ABOVE":
                            case 2:
                                message.threshold = 2;
                                break;
                            case "BLOCK_ONLY_HIGH":
                            case 3:
                                message.threshold = 3;
                                break;
                            case "BLOCK_NONE":
                            case 4:
                                message.threshold = 4;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SafetySetting message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {google.ai.generativelanguage.v1.SafetySetting} message SafetySetting
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SafetySetting.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.category = options.enums === String ? "HARM_CATEGORY_UNSPECIFIED" : 0;
                                object.threshold = options.enums === String ? "HARM_BLOCK_THRESHOLD_UNSPECIFIED" : 0;
                            }
                            if (message.category != null && message.hasOwnProperty("category"))
                                object.category = options.enums === String ? $root.google.ai.generativelanguage.v1.HarmCategory[message.category] === undefined ? message.category : $root.google.ai.generativelanguage.v1.HarmCategory[message.category] : message.category;
                            if (message.threshold != null && message.hasOwnProperty("threshold"))
                                object.threshold = options.enums === String ? $root.google.ai.generativelanguage.v1.SafetySetting.HarmBlockThreshold[message.threshold] === undefined ? message.threshold : $root.google.ai.generativelanguage.v1.SafetySetting.HarmBlockThreshold[message.threshold] : message.threshold;
                            return object;
                        };
    
                        /**
                         * Converts this SafetySetting to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SafetySetting.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SafetySetting
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.SafetySetting
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SafetySetting.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.SafetySetting";
                        };
    
                        /**
                         * HarmBlockThreshold enum.
                         * @name google.ai.generativelanguage.v1.SafetySetting.HarmBlockThreshold
                         * @enum {number}
                         * @property {number} HARM_BLOCK_THRESHOLD_UNSPECIFIED=0 HARM_BLOCK_THRESHOLD_UNSPECIFIED value
                         * @property {number} BLOCK_LOW_AND_ABOVE=1 BLOCK_LOW_AND_ABOVE value
                         * @property {number} BLOCK_MEDIUM_AND_ABOVE=2 BLOCK_MEDIUM_AND_ABOVE value
                         * @property {number} BLOCK_ONLY_HIGH=3 BLOCK_ONLY_HIGH value
                         * @property {number} BLOCK_NONE=4 BLOCK_NONE value
                         */
                        SafetySetting.HarmBlockThreshold = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "HARM_BLOCK_THRESHOLD_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "BLOCK_LOW_AND_ABOVE"] = 1;
                            values[valuesById[2] = "BLOCK_MEDIUM_AND_ABOVE"] = 2;
                            values[valuesById[3] = "BLOCK_ONLY_HIGH"] = 3;
                            values[valuesById[4] = "BLOCK_NONE"] = 4;
                            return values;
                        })();
    
                        return SafetySetting;
                    })();
    
                    v1.Model = (function() {
    
                        /**
                         * Properties of a Model.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IModel
                         * @property {string|null} [name] Model name
                         * @property {string|null} [baseModelId] Model baseModelId
                         * @property {string|null} [version] Model version
                         * @property {string|null} [displayName] Model displayName
                         * @property {string|null} [description] Model description
                         * @property {number|null} [inputTokenLimit] Model inputTokenLimit
                         * @property {number|null} [outputTokenLimit] Model outputTokenLimit
                         * @property {Array.<string>|null} [supportedGenerationMethods] Model supportedGenerationMethods
                         * @property {number|null} [temperature] Model temperature
                         * @property {number|null} [topP] Model topP
                         * @property {number|null} [topK] Model topK
                         */
    
                        /**
                         * Constructs a new Model.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a Model.
                         * @implements IModel
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IModel=} [properties] Properties to set
                         */
                        function Model(properties) {
                            this.supportedGenerationMethods = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Model name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.name = "";
    
                        /**
                         * Model baseModelId.
                         * @member {string} baseModelId
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.baseModelId = "";
    
                        /**
                         * Model version.
                         * @member {string} version
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.version = "";
    
                        /**
                         * Model displayName.
                         * @member {string} displayName
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.displayName = "";
    
                        /**
                         * Model description.
                         * @member {string} description
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.description = "";
    
                        /**
                         * Model inputTokenLimit.
                         * @member {number} inputTokenLimit
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.inputTokenLimit = 0;
    
                        /**
                         * Model outputTokenLimit.
                         * @member {number} outputTokenLimit
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.outputTokenLimit = 0;
    
                        /**
                         * Model supportedGenerationMethods.
                         * @member {Array.<string>} supportedGenerationMethods
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.supportedGenerationMethods = $util.emptyArray;
    
                        /**
                         * Model temperature.
                         * @member {number|null|undefined} temperature
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.temperature = null;
    
                        /**
                         * Model topP.
                         * @member {number|null|undefined} topP
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.topP = null;
    
                        /**
                         * Model topK.
                         * @member {number|null|undefined} topK
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Model.prototype.topK = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Model _temperature.
                         * @member {"temperature"|undefined} _temperature
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Object.defineProperty(Model.prototype, "_temperature", {
                            get: $util.oneOfGetter($oneOfFields = ["temperature"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Model _topP.
                         * @member {"topP"|undefined} _topP
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Object.defineProperty(Model.prototype, "_topP", {
                            get: $util.oneOfGetter($oneOfFields = ["topP"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Model _topK.
                         * @member {"topK"|undefined} _topK
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         */
                        Object.defineProperty(Model.prototype, "_topK", {
                            get: $util.oneOfGetter($oneOfFields = ["topK"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Model instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {google.ai.generativelanguage.v1.IModel=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.Model} Model instance
                         */
                        Model.create = function create(properties) {
                            return new Model(properties);
                        };
    
                        /**
                         * Encodes the specified Model message. Does not implicitly {@link google.ai.generativelanguage.v1.Model.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {google.ai.generativelanguage.v1.IModel} message Model message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Model.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.baseModelId != null && Object.hasOwnProperty.call(message, "baseModelId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.baseModelId);
                            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.version);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.displayName);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.description);
                            if (message.inputTokenLimit != null && Object.hasOwnProperty.call(message, "inputTokenLimit"))
                                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.inputTokenLimit);
                            if (message.outputTokenLimit != null && Object.hasOwnProperty.call(message, "outputTokenLimit"))
                                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.outputTokenLimit);
                            if (message.supportedGenerationMethods != null && message.supportedGenerationMethods.length)
                                for (var i = 0; i < message.supportedGenerationMethods.length; ++i)
                                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.supportedGenerationMethods[i]);
                            if (message.temperature != null && Object.hasOwnProperty.call(message, "temperature"))
                                writer.uint32(/* id 9, wireType 5 =*/77).float(message.temperature);
                            if (message.topP != null && Object.hasOwnProperty.call(message, "topP"))
                                writer.uint32(/* id 10, wireType 5 =*/85).float(message.topP);
                            if (message.topK != null && Object.hasOwnProperty.call(message, "topK"))
                                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.topK);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Model message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.Model.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {google.ai.generativelanguage.v1.IModel} message Model message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Model.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Model message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.Model} Model
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Model.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.Model();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.baseModelId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.version = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.inputTokenLimit = reader.int32();
                                        break;
                                    }
                                case 7: {
                                        message.outputTokenLimit = reader.int32();
                                        break;
                                    }
                                case 8: {
                                        if (!(message.supportedGenerationMethods && message.supportedGenerationMethods.length))
                                            message.supportedGenerationMethods = [];
                                        message.supportedGenerationMethods.push(reader.string());
                                        break;
                                    }
                                case 9: {
                                        message.temperature = reader.float();
                                        break;
                                    }
                                case 10: {
                                        message.topP = reader.float();
                                        break;
                                    }
                                case 11: {
                                        message.topK = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Model message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.Model} Model
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Model.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Model message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Model.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.baseModelId != null && message.hasOwnProperty("baseModelId"))
                                if (!$util.isString(message.baseModelId))
                                    return "baseModelId: string expected";
                            if (message.version != null && message.hasOwnProperty("version"))
                                if (!$util.isString(message.version))
                                    return "version: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.inputTokenLimit != null && message.hasOwnProperty("inputTokenLimit"))
                                if (!$util.isInteger(message.inputTokenLimit))
                                    return "inputTokenLimit: integer expected";
                            if (message.outputTokenLimit != null && message.hasOwnProperty("outputTokenLimit"))
                                if (!$util.isInteger(message.outputTokenLimit))
                                    return "outputTokenLimit: integer expected";
                            if (message.supportedGenerationMethods != null && message.hasOwnProperty("supportedGenerationMethods")) {
                                if (!Array.isArray(message.supportedGenerationMethods))
                                    return "supportedGenerationMethods: array expected";
                                for (var i = 0; i < message.supportedGenerationMethods.length; ++i)
                                    if (!$util.isString(message.supportedGenerationMethods[i]))
                                        return "supportedGenerationMethods: string[] expected";
                            }
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                properties._temperature = 1;
                                if (typeof message.temperature !== "number")
                                    return "temperature: number expected";
                            }
                            if (message.topP != null && message.hasOwnProperty("topP")) {
                                properties._topP = 1;
                                if (typeof message.topP !== "number")
                                    return "topP: number expected";
                            }
                            if (message.topK != null && message.hasOwnProperty("topK")) {
                                properties._topK = 1;
                                if (!$util.isInteger(message.topK))
                                    return "topK: integer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Model message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.Model} Model
                         */
                        Model.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.Model)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.Model();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.baseModelId != null)
                                message.baseModelId = String(object.baseModelId);
                            if (object.version != null)
                                message.version = String(object.version);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.inputTokenLimit != null)
                                message.inputTokenLimit = object.inputTokenLimit | 0;
                            if (object.outputTokenLimit != null)
                                message.outputTokenLimit = object.outputTokenLimit | 0;
                            if (object.supportedGenerationMethods) {
                                if (!Array.isArray(object.supportedGenerationMethods))
                                    throw TypeError(".google.ai.generativelanguage.v1.Model.supportedGenerationMethods: array expected");
                                message.supportedGenerationMethods = [];
                                for (var i = 0; i < object.supportedGenerationMethods.length; ++i)
                                    message.supportedGenerationMethods[i] = String(object.supportedGenerationMethods[i]);
                            }
                            if (object.temperature != null)
                                message.temperature = Number(object.temperature);
                            if (object.topP != null)
                                message.topP = Number(object.topP);
                            if (object.topK != null)
                                message.topK = object.topK | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Model message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {google.ai.generativelanguage.v1.Model} message Model
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Model.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.supportedGenerationMethods = [];
                            if (options.defaults) {
                                object.name = "";
                                object.baseModelId = "";
                                object.version = "";
                                object.displayName = "";
                                object.description = "";
                                object.inputTokenLimit = 0;
                                object.outputTokenLimit = 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.baseModelId != null && message.hasOwnProperty("baseModelId"))
                                object.baseModelId = message.baseModelId;
                            if (message.version != null && message.hasOwnProperty("version"))
                                object.version = message.version;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.inputTokenLimit != null && message.hasOwnProperty("inputTokenLimit"))
                                object.inputTokenLimit = message.inputTokenLimit;
                            if (message.outputTokenLimit != null && message.hasOwnProperty("outputTokenLimit"))
                                object.outputTokenLimit = message.outputTokenLimit;
                            if (message.supportedGenerationMethods && message.supportedGenerationMethods.length) {
                                object.supportedGenerationMethods = [];
                                for (var j = 0; j < message.supportedGenerationMethods.length; ++j)
                                    object.supportedGenerationMethods[j] = message.supportedGenerationMethods[j];
                            }
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                object.temperature = options.json && !isFinite(message.temperature) ? String(message.temperature) : message.temperature;
                                if (options.oneofs)
                                    object._temperature = "temperature";
                            }
                            if (message.topP != null && message.hasOwnProperty("topP")) {
                                object.topP = options.json && !isFinite(message.topP) ? String(message.topP) : message.topP;
                                if (options.oneofs)
                                    object._topP = "topP";
                            }
                            if (message.topK != null && message.hasOwnProperty("topK")) {
                                object.topK = message.topK;
                                if (options.oneofs)
                                    object._topK = "topK";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Model to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Model.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Model
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.Model
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Model.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.Model";
                        };
    
                        return Model;
                    })();
    
                    v1.ModelService = (function() {
    
                        /**
                         * Constructs a new ModelService service.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a ModelService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function ModelService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (ModelService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = ModelService;
    
                        /**
                         * Creates new ModelService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {ModelService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        ModelService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.ModelService|getModel}.
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @typedef GetModelCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.Model} [response] Model
                         */
    
                        /**
                         * Calls GetModel.
                         * @function getModel
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IGetModelRequest} request GetModelRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.ModelService.GetModelCallback} callback Node-style callback called with the error, if any, and Model
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ModelService.prototype.getModel = function getModel(request, callback) {
                            return this.rpcCall(getModel, $root.google.ai.generativelanguage.v1.GetModelRequest, $root.google.ai.generativelanguage.v1.Model, request, callback);
                        }, "name", { value: "GetModel" });
    
                        /**
                         * Calls GetModel.
                         * @function getModel
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IGetModelRequest} request GetModelRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.Model>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1.ModelService|listModels}.
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @typedef ListModelsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1.ListModelsResponse} [response] ListModelsResponse
                         */
    
                        /**
                         * Calls ListModels.
                         * @function listModels
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IListModelsRequest} request ListModelsRequest message or plain object
                         * @param {google.ai.generativelanguage.v1.ModelService.ListModelsCallback} callback Node-style callback called with the error, if any, and ListModelsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ModelService.prototype.listModels = function listModels(request, callback) {
                            return this.rpcCall(listModels, $root.google.ai.generativelanguage.v1.ListModelsRequest, $root.google.ai.generativelanguage.v1.ListModelsResponse, request, callback);
                        }, "name", { value: "ListModels" });
    
                        /**
                         * Calls ListModels.
                         * @function listModels
                         * @memberof google.ai.generativelanguage.v1.ModelService
                         * @instance
                         * @param {google.ai.generativelanguage.v1.IListModelsRequest} request ListModelsRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1.ListModelsResponse>} Promise
                         * @variation 2
                         */
    
                        return ModelService;
                    })();
    
                    v1.GetModelRequest = (function() {
    
                        /**
                         * Properties of a GetModelRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IGetModelRequest
                         * @property {string|null} [name] GetModelRequest name
                         */
    
                        /**
                         * Constructs a new GetModelRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a GetModelRequest.
                         * @implements IGetModelRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IGetModelRequest=} [properties] Properties to set
                         */
                        function GetModelRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetModelRequest name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @instance
                         */
                        GetModelRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetModelRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGetModelRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.GetModelRequest} GetModelRequest instance
                         */
                        GetModelRequest.create = function create(properties) {
                            return new GetModelRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetModelRequest message. Does not implicitly {@link google.ai.generativelanguage.v1.GetModelRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGetModelRequest} message GetModelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetModelRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetModelRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.GetModelRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IGetModelRequest} message GetModelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetModelRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetModelRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.GetModelRequest} GetModelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetModelRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.GetModelRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetModelRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.GetModelRequest} GetModelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetModelRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetModelRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetModelRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetModelRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.GetModelRequest} GetModelRequest
                         */
                        GetModelRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.GetModelRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.GetModelRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetModelRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.GetModelRequest} message GetModelRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetModelRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetModelRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetModelRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetModelRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.GetModelRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetModelRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.GetModelRequest";
                        };
    
                        return GetModelRequest;
                    })();
    
                    v1.ListModelsRequest = (function() {
    
                        /**
                         * Properties of a ListModelsRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IListModelsRequest
                         * @property {number|null} [pageSize] ListModelsRequest pageSize
                         * @property {string|null} [pageToken] ListModelsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListModelsRequest.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a ListModelsRequest.
                         * @implements IListModelsRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IListModelsRequest=} [properties] Properties to set
                         */
                        function ListModelsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListModelsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @instance
                         */
                        ListModelsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListModelsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @instance
                         */
                        ListModelsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListModelsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IListModelsRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.ListModelsRequest} ListModelsRequest instance
                         */
                        ListModelsRequest.create = function create(properties) {
                            return new ListModelsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListModelsRequest message. Does not implicitly {@link google.ai.generativelanguage.v1.ListModelsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IListModelsRequest} message ListModelsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListModelsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListModelsRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.ListModelsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.IListModelsRequest} message ListModelsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListModelsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListModelsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.ListModelsRequest} ListModelsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListModelsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.ListModelsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListModelsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.ListModelsRequest} ListModelsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListModelsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListModelsRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListModelsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListModelsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.ListModelsRequest} ListModelsRequest
                         */
                        ListModelsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.ListModelsRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.ListModelsRequest();
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListModelsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1.ListModelsRequest} message ListModelsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListModelsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListModelsRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListModelsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListModelsRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.ListModelsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListModelsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.ListModelsRequest";
                        };
    
                        return ListModelsRequest;
                    })();
    
                    v1.ListModelsResponse = (function() {
    
                        /**
                         * Properties of a ListModelsResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @interface IListModelsResponse
                         * @property {Array.<google.ai.generativelanguage.v1.IModel>|null} [models] ListModelsResponse models
                         * @property {string|null} [nextPageToken] ListModelsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListModelsResponse.
                         * @memberof google.ai.generativelanguage.v1
                         * @classdesc Represents a ListModelsResponse.
                         * @implements IListModelsResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1.IListModelsResponse=} [properties] Properties to set
                         */
                        function ListModelsResponse(properties) {
                            this.models = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListModelsResponse models.
                         * @member {Array.<google.ai.generativelanguage.v1.IModel>} models
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @instance
                         */
                        ListModelsResponse.prototype.models = $util.emptyArray;
    
                        /**
                         * ListModelsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @instance
                         */
                        ListModelsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListModelsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IListModelsResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1.ListModelsResponse} ListModelsResponse instance
                         */
                        ListModelsResponse.create = function create(properties) {
                            return new ListModelsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListModelsResponse message. Does not implicitly {@link google.ai.generativelanguage.v1.ListModelsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IListModelsResponse} message ListModelsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListModelsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.models != null && message.models.length)
                                for (var i = 0; i < message.models.length; ++i)
                                    $root.google.ai.generativelanguage.v1.Model.encode(message.models[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListModelsResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1.ListModelsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.IListModelsResponse} message ListModelsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListModelsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListModelsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1.ListModelsResponse} ListModelsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListModelsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1.ListModelsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.models && message.models.length))
                                            message.models = [];
                                        message.models.push($root.google.ai.generativelanguage.v1.Model.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListModelsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1.ListModelsResponse} ListModelsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListModelsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListModelsResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListModelsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.models != null && message.hasOwnProperty("models")) {
                                if (!Array.isArray(message.models))
                                    return "models: array expected";
                                for (var i = 0; i < message.models.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1.Model.verify(message.models[i]);
                                    if (error)
                                        return "models." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListModelsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1.ListModelsResponse} ListModelsResponse
                         */
                        ListModelsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1.ListModelsResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1.ListModelsResponse();
                            if (object.models) {
                                if (!Array.isArray(object.models))
                                    throw TypeError(".google.ai.generativelanguage.v1.ListModelsResponse.models: array expected");
                                message.models = [];
                                for (var i = 0; i < object.models.length; ++i) {
                                    if (typeof object.models[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1.ListModelsResponse.models: object expected");
                                    message.models[i] = $root.google.ai.generativelanguage.v1.Model.fromObject(object.models[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListModelsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1.ListModelsResponse} message ListModelsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListModelsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.models = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.models && message.models.length) {
                                object.models = [];
                                for (var j = 0; j < message.models.length; ++j)
                                    object.models[j] = $root.google.ai.generativelanguage.v1.Model.toObject(message.models[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListModelsResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListModelsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListModelsResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1.ListModelsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListModelsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1.ListModelsResponse";
                        };
    
                        return ListModelsResponse;
                    })();
    
                    return v1;
                })();
    
                generativelanguage.v1beta = (function() {
    
                    /**
                     * Namespace v1beta.
                     * @memberof google.ai.generativelanguage
                     * @namespace
                     */
                    var v1beta = {};
    
                    v1beta.CacheService = (function() {
    
                        /**
                         * Constructs a new CacheService service.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CacheService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function CacheService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (CacheService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = CacheService;
    
                        /**
                         * Creates new CacheService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {CacheService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        CacheService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.CacheService|listCachedContents}.
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @typedef ListCachedContentsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1beta.ListCachedContentsResponse} [response] ListCachedContentsResponse
                         */
    
                        /**
                         * Calls ListCachedContents.
                         * @function listCachedContents
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsRequest} request ListCachedContentsRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.CacheService.ListCachedContentsCallback} callback Node-style callback called with the error, if any, and ListCachedContentsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(CacheService.prototype.listCachedContents = function listCachedContents(request, callback) {
                            return this.rpcCall(listCachedContents, $root.google.ai.generativelanguage.v1beta.ListCachedContentsRequest, $root.google.ai.generativelanguage.v1beta.ListCachedContentsResponse, request, callback);
                        }, "name", { value: "ListCachedContents" });
    
                        /**
                         * Calls ListCachedContents.
                         * @function listCachedContents
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsRequest} request ListCachedContentsRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1beta.ListCachedContentsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.CacheService|createCachedContent}.
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @typedef CreateCachedContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1beta.CachedContent} [response] CachedContent
                         */
    
                        /**
                         * Calls CreateCachedContent.
                         * @function createCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.ICreateCachedContentRequest} request CreateCachedContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.CacheService.CreateCachedContentCallback} callback Node-style callback called with the error, if any, and CachedContent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(CacheService.prototype.createCachedContent = function createCachedContent(request, callback) {
                            return this.rpcCall(createCachedContent, $root.google.ai.generativelanguage.v1beta.CreateCachedContentRequest, $root.google.ai.generativelanguage.v1beta.CachedContent, request, callback);
                        }, "name", { value: "CreateCachedContent" });
    
                        /**
                         * Calls CreateCachedContent.
                         * @function createCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.ICreateCachedContentRequest} request CreateCachedContentRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1beta.CachedContent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.CacheService|getCachedContent}.
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @typedef GetCachedContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1beta.CachedContent} [response] CachedContent
                         */
    
                        /**
                         * Calls GetCachedContent.
                         * @function getCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IGetCachedContentRequest} request GetCachedContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.CacheService.GetCachedContentCallback} callback Node-style callback called with the error, if any, and CachedContent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(CacheService.prototype.getCachedContent = function getCachedContent(request, callback) {
                            return this.rpcCall(getCachedContent, $root.google.ai.generativelanguage.v1beta.GetCachedContentRequest, $root.google.ai.generativelanguage.v1beta.CachedContent, request, callback);
                        }, "name", { value: "GetCachedContent" });
    
                        /**
                         * Calls GetCachedContent.
                         * @function getCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IGetCachedContentRequest} request GetCachedContentRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1beta.CachedContent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.CacheService|updateCachedContent}.
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @typedef UpdateCachedContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1beta.CachedContent} [response] CachedContent
                         */
    
                        /**
                         * Calls UpdateCachedContent.
                         * @function updateCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IUpdateCachedContentRequest} request UpdateCachedContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.CacheService.UpdateCachedContentCallback} callback Node-style callback called with the error, if any, and CachedContent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(CacheService.prototype.updateCachedContent = function updateCachedContent(request, callback) {
                            return this.rpcCall(updateCachedContent, $root.google.ai.generativelanguage.v1beta.UpdateCachedContentRequest, $root.google.ai.generativelanguage.v1beta.CachedContent, request, callback);
                        }, "name", { value: "UpdateCachedContent" });
    
                        /**
                         * Calls UpdateCachedContent.
                         * @function updateCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IUpdateCachedContentRequest} request UpdateCachedContentRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1beta.CachedContent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.CacheService|deleteCachedContent}.
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @typedef DeleteCachedContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteCachedContent.
                         * @function deleteCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IDeleteCachedContentRequest} request DeleteCachedContentRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.CacheService.DeleteCachedContentCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(CacheService.prototype.deleteCachedContent = function deleteCachedContent(request, callback) {
                            return this.rpcCall(deleteCachedContent, $root.google.ai.generativelanguage.v1beta.DeleteCachedContentRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteCachedContent" });
    
                        /**
                         * Calls DeleteCachedContent.
                         * @function deleteCachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CacheService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IDeleteCachedContentRequest} request DeleteCachedContentRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        return CacheService;
                    })();
    
                    v1beta.ListCachedContentsRequest = (function() {
    
                        /**
                         * Properties of a ListCachedContentsRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IListCachedContentsRequest
                         * @property {number|null} [pageSize] ListCachedContentsRequest pageSize
                         * @property {string|null} [pageToken] ListCachedContentsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListCachedContentsRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a ListCachedContentsRequest.
                         * @implements IListCachedContentsRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsRequest=} [properties] Properties to set
                         */
                        function ListCachedContentsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListCachedContentsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @instance
                         */
                        ListCachedContentsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListCachedContentsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @instance
                         */
                        ListCachedContentsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListCachedContentsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsRequest} ListCachedContentsRequest instance
                         */
                        ListCachedContentsRequest.create = function create(properties) {
                            return new ListCachedContentsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListCachedContentsRequest message. Does not implicitly {@link google.ai.generativelanguage.v1beta.ListCachedContentsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsRequest} message ListCachedContentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListCachedContentsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListCachedContentsRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.ListCachedContentsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsRequest} message ListCachedContentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListCachedContentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListCachedContentsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsRequest} ListCachedContentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListCachedContentsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.ListCachedContentsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListCachedContentsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsRequest} ListCachedContentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListCachedContentsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListCachedContentsRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListCachedContentsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListCachedContentsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsRequest} ListCachedContentsRequest
                         */
                        ListCachedContentsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.ListCachedContentsRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.ListCachedContentsRequest();
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListCachedContentsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ListCachedContentsRequest} message ListCachedContentsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListCachedContentsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListCachedContentsRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListCachedContentsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListCachedContentsRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListCachedContentsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.ListCachedContentsRequest";
                        };
    
                        return ListCachedContentsRequest;
                    })();
    
                    v1beta.ListCachedContentsResponse = (function() {
    
                        /**
                         * Properties of a ListCachedContentsResponse.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IListCachedContentsResponse
                         * @property {Array.<google.ai.generativelanguage.v1beta.ICachedContent>|null} [cachedContents] ListCachedContentsResponse cachedContents
                         * @property {string|null} [nextPageToken] ListCachedContentsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListCachedContentsResponse.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a ListCachedContentsResponse.
                         * @implements IListCachedContentsResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsResponse=} [properties] Properties to set
                         */
                        function ListCachedContentsResponse(properties) {
                            this.cachedContents = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListCachedContentsResponse cachedContents.
                         * @member {Array.<google.ai.generativelanguage.v1beta.ICachedContent>} cachedContents
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @instance
                         */
                        ListCachedContentsResponse.prototype.cachedContents = $util.emptyArray;
    
                        /**
                         * ListCachedContentsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @instance
                         */
                        ListCachedContentsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListCachedContentsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsResponse} ListCachedContentsResponse instance
                         */
                        ListCachedContentsResponse.create = function create(properties) {
                            return new ListCachedContentsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListCachedContentsResponse message. Does not implicitly {@link google.ai.generativelanguage.v1beta.ListCachedContentsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsResponse} message ListCachedContentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListCachedContentsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.cachedContents != null && message.cachedContents.length)
                                for (var i = 0; i < message.cachedContents.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.CachedContent.encode(message.cachedContents[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListCachedContentsResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.ListCachedContentsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IListCachedContentsResponse} message ListCachedContentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListCachedContentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListCachedContentsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsResponse} ListCachedContentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListCachedContentsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.ListCachedContentsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.cachedContents && message.cachedContents.length))
                                            message.cachedContents = [];
                                        message.cachedContents.push($root.google.ai.generativelanguage.v1beta.CachedContent.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListCachedContentsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsResponse} ListCachedContentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListCachedContentsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListCachedContentsResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListCachedContentsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.cachedContents != null && message.hasOwnProperty("cachedContents")) {
                                if (!Array.isArray(message.cachedContents))
                                    return "cachedContents: array expected";
                                for (var i = 0; i < message.cachedContents.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.CachedContent.verify(message.cachedContents[i]);
                                    if (error)
                                        return "cachedContents." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListCachedContentsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.ListCachedContentsResponse} ListCachedContentsResponse
                         */
                        ListCachedContentsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.ListCachedContentsResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.ListCachedContentsResponse();
                            if (object.cachedContents) {
                                if (!Array.isArray(object.cachedContents))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.ListCachedContentsResponse.cachedContents: array expected");
                                message.cachedContents = [];
                                for (var i = 0; i < object.cachedContents.length; ++i) {
                                    if (typeof object.cachedContents[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.ListCachedContentsResponse.cachedContents: object expected");
                                    message.cachedContents[i] = $root.google.ai.generativelanguage.v1beta.CachedContent.fromObject(object.cachedContents[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListCachedContentsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ListCachedContentsResponse} message ListCachedContentsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListCachedContentsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.cachedContents = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.cachedContents && message.cachedContents.length) {
                                object.cachedContents = [];
                                for (var j = 0; j < message.cachedContents.length; ++j)
                                    object.cachedContents[j] = $root.google.ai.generativelanguage.v1beta.CachedContent.toObject(message.cachedContents[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListCachedContentsResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListCachedContentsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListCachedContentsResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.ListCachedContentsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListCachedContentsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.ListCachedContentsResponse";
                        };
    
                        return ListCachedContentsResponse;
                    })();
    
                    v1beta.CreateCachedContentRequest = (function() {
    
                        /**
                         * Properties of a CreateCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ICreateCachedContentRequest
                         * @property {google.ai.generativelanguage.v1beta.ICachedContent|null} [cachedContent] CreateCachedContentRequest cachedContent
                         */
    
                        /**
                         * Constructs a new CreateCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CreateCachedContentRequest.
                         * @implements ICreateCachedContentRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ICreateCachedContentRequest=} [properties] Properties to set
                         */
                        function CreateCachedContentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateCachedContentRequest cachedContent.
                         * @member {google.ai.generativelanguage.v1beta.ICachedContent|null|undefined} cachedContent
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @instance
                         */
                        CreateCachedContentRequest.prototype.cachedContent = null;
    
                        /**
                         * Creates a new CreateCachedContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICreateCachedContentRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.CreateCachedContentRequest} CreateCachedContentRequest instance
                         */
                        CreateCachedContentRequest.create = function create(properties) {
                            return new CreateCachedContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateCachedContentRequest message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CreateCachedContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICreateCachedContentRequest} message CreateCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateCachedContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.cachedContent != null && Object.hasOwnProperty.call(message, "cachedContent"))
                                $root.google.ai.generativelanguage.v1beta.CachedContent.encode(message.cachedContent, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateCachedContentRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CreateCachedContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICreateCachedContentRequest} message CreateCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateCachedContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateCachedContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.CreateCachedContentRequest} CreateCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateCachedContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CreateCachedContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.cachedContent = $root.google.ai.generativelanguage.v1beta.CachedContent.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateCachedContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.CreateCachedContentRequest} CreateCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateCachedContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateCachedContentRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateCachedContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.cachedContent != null && message.hasOwnProperty("cachedContent")) {
                                var error = $root.google.ai.generativelanguage.v1beta.CachedContent.verify(message.cachedContent);
                                if (error)
                                    return "cachedContent." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateCachedContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.CreateCachedContentRequest} CreateCachedContentRequest
                         */
                        CreateCachedContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.CreateCachedContentRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.CreateCachedContentRequest();
                            if (object.cachedContent != null) {
                                if (typeof object.cachedContent !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CreateCachedContentRequest.cachedContent: object expected");
                                message.cachedContent = $root.google.ai.generativelanguage.v1beta.CachedContent.fromObject(object.cachedContent);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateCachedContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.CreateCachedContentRequest} message CreateCachedContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateCachedContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.cachedContent = null;
                            if (message.cachedContent != null && message.hasOwnProperty("cachedContent"))
                                object.cachedContent = $root.google.ai.generativelanguage.v1beta.CachedContent.toObject(message.cachedContent, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateCachedContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateCachedContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateCachedContentRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.CreateCachedContentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateCachedContentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CreateCachedContentRequest";
                        };
    
                        return CreateCachedContentRequest;
                    })();
    
                    v1beta.GetCachedContentRequest = (function() {
    
                        /**
                         * Properties of a GetCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IGetCachedContentRequest
                         * @property {string|null} [name] GetCachedContentRequest name
                         */
    
                        /**
                         * Constructs a new GetCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a GetCachedContentRequest.
                         * @implements IGetCachedContentRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IGetCachedContentRequest=} [properties] Properties to set
                         */
                        function GetCachedContentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetCachedContentRequest name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @instance
                         */
                        GetCachedContentRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetCachedContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGetCachedContentRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.GetCachedContentRequest} GetCachedContentRequest instance
                         */
                        GetCachedContentRequest.create = function create(properties) {
                            return new GetCachedContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetCachedContentRequest message. Does not implicitly {@link google.ai.generativelanguage.v1beta.GetCachedContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGetCachedContentRequest} message GetCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetCachedContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetCachedContentRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.GetCachedContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGetCachedContentRequest} message GetCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetCachedContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetCachedContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.GetCachedContentRequest} GetCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetCachedContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.GetCachedContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetCachedContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.GetCachedContentRequest} GetCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetCachedContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetCachedContentRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetCachedContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetCachedContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.GetCachedContentRequest} GetCachedContentRequest
                         */
                        GetCachedContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.GetCachedContentRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.GetCachedContentRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetCachedContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.GetCachedContentRequest} message GetCachedContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetCachedContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetCachedContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetCachedContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetCachedContentRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.GetCachedContentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetCachedContentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.GetCachedContentRequest";
                        };
    
                        return GetCachedContentRequest;
                    })();
    
                    v1beta.UpdateCachedContentRequest = (function() {
    
                        /**
                         * Properties of an UpdateCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IUpdateCachedContentRequest
                         * @property {google.ai.generativelanguage.v1beta.ICachedContent|null} [cachedContent] UpdateCachedContentRequest cachedContent
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateCachedContentRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents an UpdateCachedContentRequest.
                         * @implements IUpdateCachedContentRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IUpdateCachedContentRequest=} [properties] Properties to set
                         */
                        function UpdateCachedContentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateCachedContentRequest cachedContent.
                         * @member {google.ai.generativelanguage.v1beta.ICachedContent|null|undefined} cachedContent
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @instance
                         */
                        UpdateCachedContentRequest.prototype.cachedContent = null;
    
                        /**
                         * UpdateCachedContentRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @instance
                         */
                        UpdateCachedContentRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateCachedContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IUpdateCachedContentRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.UpdateCachedContentRequest} UpdateCachedContentRequest instance
                         */
                        UpdateCachedContentRequest.create = function create(properties) {
                            return new UpdateCachedContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateCachedContentRequest message. Does not implicitly {@link google.ai.generativelanguage.v1beta.UpdateCachedContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IUpdateCachedContentRequest} message UpdateCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateCachedContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.cachedContent != null && Object.hasOwnProperty.call(message, "cachedContent"))
                                $root.google.ai.generativelanguage.v1beta.CachedContent.encode(message.cachedContent, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateCachedContentRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.UpdateCachedContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IUpdateCachedContentRequest} message UpdateCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateCachedContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateCachedContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.UpdateCachedContentRequest} UpdateCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateCachedContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.UpdateCachedContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.cachedContent = $root.google.ai.generativelanguage.v1beta.CachedContent.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateCachedContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.UpdateCachedContentRequest} UpdateCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateCachedContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateCachedContentRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateCachedContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.cachedContent != null && message.hasOwnProperty("cachedContent")) {
                                var error = $root.google.ai.generativelanguage.v1beta.CachedContent.verify(message.cachedContent);
                                if (error)
                                    return "cachedContent." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateCachedContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.UpdateCachedContentRequest} UpdateCachedContentRequest
                         */
                        UpdateCachedContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.UpdateCachedContentRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.UpdateCachedContentRequest();
                            if (object.cachedContent != null) {
                                if (typeof object.cachedContent !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.UpdateCachedContentRequest.cachedContent: object expected");
                                message.cachedContent = $root.google.ai.generativelanguage.v1beta.CachedContent.fromObject(object.cachedContent);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.UpdateCachedContentRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateCachedContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.UpdateCachedContentRequest} message UpdateCachedContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateCachedContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.cachedContent = null;
                                object.updateMask = null;
                            }
                            if (message.cachedContent != null && message.hasOwnProperty("cachedContent"))
                                object.cachedContent = $root.google.ai.generativelanguage.v1beta.CachedContent.toObject(message.cachedContent, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateCachedContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateCachedContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateCachedContentRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.UpdateCachedContentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateCachedContentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.UpdateCachedContentRequest";
                        };
    
                        return UpdateCachedContentRequest;
                    })();
    
                    v1beta.DeleteCachedContentRequest = (function() {
    
                        /**
                         * Properties of a DeleteCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IDeleteCachedContentRequest
                         * @property {string|null} [name] DeleteCachedContentRequest name
                         */
    
                        /**
                         * Constructs a new DeleteCachedContentRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a DeleteCachedContentRequest.
                         * @implements IDeleteCachedContentRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IDeleteCachedContentRequest=} [properties] Properties to set
                         */
                        function DeleteCachedContentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteCachedContentRequest name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @instance
                         */
                        DeleteCachedContentRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteCachedContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IDeleteCachedContentRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.DeleteCachedContentRequest} DeleteCachedContentRequest instance
                         */
                        DeleteCachedContentRequest.create = function create(properties) {
                            return new DeleteCachedContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteCachedContentRequest message. Does not implicitly {@link google.ai.generativelanguage.v1beta.DeleteCachedContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IDeleteCachedContentRequest} message DeleteCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteCachedContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteCachedContentRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.DeleteCachedContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IDeleteCachedContentRequest} message DeleteCachedContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteCachedContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteCachedContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.DeleteCachedContentRequest} DeleteCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteCachedContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.DeleteCachedContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteCachedContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.DeleteCachedContentRequest} DeleteCachedContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteCachedContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteCachedContentRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteCachedContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteCachedContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.DeleteCachedContentRequest} DeleteCachedContentRequest
                         */
                        DeleteCachedContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.DeleteCachedContentRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.DeleteCachedContentRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteCachedContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.DeleteCachedContentRequest} message DeleteCachedContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteCachedContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteCachedContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteCachedContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteCachedContentRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.DeleteCachedContentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteCachedContentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.DeleteCachedContentRequest";
                        };
    
                        return DeleteCachedContentRequest;
                    })();
    
                    v1beta.CachedContent = (function() {
    
                        /**
                         * Properties of a CachedContent.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ICachedContent
                         * @property {google.protobuf.ITimestamp|null} [expireTime] CachedContent expireTime
                         * @property {google.protobuf.IDuration|null} [ttl] CachedContent ttl
                         * @property {string|null} [name] CachedContent name
                         * @property {string|null} [displayName] CachedContent displayName
                         * @property {string|null} [model] CachedContent model
                         * @property {google.ai.generativelanguage.v1beta.IContent|null} [systemInstruction] CachedContent systemInstruction
                         * @property {Array.<google.ai.generativelanguage.v1beta.IContent>|null} [contents] CachedContent contents
                         * @property {Array.<google.ai.generativelanguage.v1beta.ITool>|null} [tools] CachedContent tools
                         * @property {google.ai.generativelanguage.v1beta.IToolConfig|null} [toolConfig] CachedContent toolConfig
                         * @property {google.protobuf.ITimestamp|null} [createTime] CachedContent createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] CachedContent updateTime
                         * @property {google.ai.generativelanguage.v1beta.CachedContent.IUsageMetadata|null} [usageMetadata] CachedContent usageMetadata
                         */
    
                        /**
                         * Constructs a new CachedContent.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CachedContent.
                         * @implements ICachedContent
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ICachedContent=} [properties] Properties to set
                         */
                        function CachedContent(properties) {
                            this.contents = [];
                            this.tools = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CachedContent expireTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} expireTime
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.expireTime = null;
    
                        /**
                         * CachedContent ttl.
                         * @member {google.protobuf.IDuration|null|undefined} ttl
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.ttl = null;
    
                        /**
                         * CachedContent name.
                         * @member {string|null|undefined} name
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.name = null;
    
                        /**
                         * CachedContent displayName.
                         * @member {string|null|undefined} displayName
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.displayName = null;
    
                        /**
                         * CachedContent model.
                         * @member {string|null|undefined} model
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.model = null;
    
                        /**
                         * CachedContent systemInstruction.
                         * @member {google.ai.generativelanguage.v1beta.IContent|null|undefined} systemInstruction
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.systemInstruction = null;
    
                        /**
                         * CachedContent contents.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IContent>} contents
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.contents = $util.emptyArray;
    
                        /**
                         * CachedContent tools.
                         * @member {Array.<google.ai.generativelanguage.v1beta.ITool>} tools
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.tools = $util.emptyArray;
    
                        /**
                         * CachedContent toolConfig.
                         * @member {google.ai.generativelanguage.v1beta.IToolConfig|null|undefined} toolConfig
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.toolConfig = null;
    
                        /**
                         * CachedContent createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.createTime = null;
    
                        /**
                         * CachedContent updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.updateTime = null;
    
                        /**
                         * CachedContent usageMetadata.
                         * @member {google.ai.generativelanguage.v1beta.CachedContent.IUsageMetadata|null|undefined} usageMetadata
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        CachedContent.prototype.usageMetadata = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * CachedContent expiration.
                         * @member {"expireTime"|"ttl"|undefined} expiration
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        Object.defineProperty(CachedContent.prototype, "expiration", {
                            get: $util.oneOfGetter($oneOfFields = ["expireTime", "ttl"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CachedContent _name.
                         * @member {"name"|undefined} _name
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        Object.defineProperty(CachedContent.prototype, "_name", {
                            get: $util.oneOfGetter($oneOfFields = ["name"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CachedContent _displayName.
                         * @member {"displayName"|undefined} _displayName
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        Object.defineProperty(CachedContent.prototype, "_displayName", {
                            get: $util.oneOfGetter($oneOfFields = ["displayName"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CachedContent _model.
                         * @member {"model"|undefined} _model
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        Object.defineProperty(CachedContent.prototype, "_model", {
                            get: $util.oneOfGetter($oneOfFields = ["model"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CachedContent _systemInstruction.
                         * @member {"systemInstruction"|undefined} _systemInstruction
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        Object.defineProperty(CachedContent.prototype, "_systemInstruction", {
                            get: $util.oneOfGetter($oneOfFields = ["systemInstruction"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CachedContent _toolConfig.
                         * @member {"toolConfig"|undefined} _toolConfig
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         */
                        Object.defineProperty(CachedContent.prototype, "_toolConfig", {
                            get: $util.oneOfGetter($oneOfFields = ["toolConfig"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new CachedContent instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICachedContent=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.CachedContent} CachedContent instance
                         */
                        CachedContent.create = function create(properties) {
                            return new CachedContent(properties);
                        };
    
                        /**
                         * Encodes the specified CachedContent message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CachedContent.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICachedContent} message CachedContent message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CachedContent.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.model);
                            if (message.systemInstruction != null && Object.hasOwnProperty.call(message, "systemInstruction"))
                                $root.google.ai.generativelanguage.v1beta.Content.encode(message.systemInstruction, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.contents != null && message.contents.length)
                                for (var i = 0; i < message.contents.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Content.encode(message.contents[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.tools != null && message.tools.length)
                                for (var i = 0; i < message.tools.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Tool.encode(message.tools[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.toolConfig != null && Object.hasOwnProperty.call(message, "toolConfig"))
                                $root.google.ai.generativelanguage.v1beta.ToolConfig.encode(message.toolConfig, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.expireTime != null && Object.hasOwnProperty.call(message, "expireTime"))
                                $root.google.protobuf.Timestamp.encode(message.expireTime, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.ttl != null && Object.hasOwnProperty.call(message, "ttl"))
                                $root.google.protobuf.Duration.encode(message.ttl, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 11, wireType 2 =*/90).string(message.displayName);
                            if (message.usageMetadata != null && Object.hasOwnProperty.call(message, "usageMetadata"))
                                $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.encode(message.usageMetadata, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CachedContent message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CachedContent.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICachedContent} message CachedContent message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CachedContent.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CachedContent message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.CachedContent} CachedContent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CachedContent.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CachedContent();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 9: {
                                        message.expireTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 10: {
                                        message.ttl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 11: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.systemInstruction = $root.google.ai.generativelanguage.v1beta.Content.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        if (!(message.contents && message.contents.length))
                                            message.contents = [];
                                        message.contents.push($root.google.ai.generativelanguage.v1beta.Content.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 5: {
                                        if (!(message.tools && message.tools.length))
                                            message.tools = [];
                                        message.tools.push($root.google.ai.generativelanguage.v1beta.Tool.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 6: {
                                        message.toolConfig = $root.google.ai.generativelanguage.v1beta.ToolConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 12: {
                                        message.usageMetadata = $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CachedContent message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.CachedContent} CachedContent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CachedContent.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CachedContent message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CachedContent.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                                properties.expiration = 1;
                                {
                                    var error = $root.google.protobuf.Timestamp.verify(message.expireTime);
                                    if (error)
                                        return "expireTime." + error;
                                }
                            }
                            if (message.ttl != null && message.hasOwnProperty("ttl")) {
                                if (properties.expiration === 1)
                                    return "expiration: multiple values";
                                properties.expiration = 1;
                                {
                                    var error = $root.google.protobuf.Duration.verify(message.ttl);
                                    if (error)
                                        return "ttl." + error;
                                }
                            }
                            if (message.name != null && message.hasOwnProperty("name")) {
                                properties._name = 1;
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            }
                            if (message.displayName != null && message.hasOwnProperty("displayName")) {
                                properties._displayName = 1;
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            }
                            if (message.model != null && message.hasOwnProperty("model")) {
                                properties._model = 1;
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            }
                            if (message.systemInstruction != null && message.hasOwnProperty("systemInstruction")) {
                                properties._systemInstruction = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.Content.verify(message.systemInstruction);
                                    if (error)
                                        return "systemInstruction." + error;
                                }
                            }
                            if (message.contents != null && message.hasOwnProperty("contents")) {
                                if (!Array.isArray(message.contents))
                                    return "contents: array expected";
                                for (var i = 0; i < message.contents.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Content.verify(message.contents[i]);
                                    if (error)
                                        return "contents." + error;
                                }
                            }
                            if (message.tools != null && message.hasOwnProperty("tools")) {
                                if (!Array.isArray(message.tools))
                                    return "tools: array expected";
                                for (var i = 0; i < message.tools.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Tool.verify(message.tools[i]);
                                    if (error)
                                        return "tools." + error;
                                }
                            }
                            if (message.toolConfig != null && message.hasOwnProperty("toolConfig")) {
                                properties._toolConfig = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.ToolConfig.verify(message.toolConfig);
                                    if (error)
                                        return "toolConfig." + error;
                                }
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.usageMetadata != null && message.hasOwnProperty("usageMetadata")) {
                                var error = $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.verify(message.usageMetadata);
                                if (error)
                                    return "usageMetadata." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CachedContent message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.CachedContent} CachedContent
                         */
                        CachedContent.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.CachedContent)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.CachedContent();
                            if (object.expireTime != null) {
                                if (typeof object.expireTime !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.expireTime: object expected");
                                message.expireTime = $root.google.protobuf.Timestamp.fromObject(object.expireTime);
                            }
                            if (object.ttl != null) {
                                if (typeof object.ttl !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.ttl: object expected");
                                message.ttl = $root.google.protobuf.Duration.fromObject(object.ttl);
                            }
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.systemInstruction != null) {
                                if (typeof object.systemInstruction !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.systemInstruction: object expected");
                                message.systemInstruction = $root.google.ai.generativelanguage.v1beta.Content.fromObject(object.systemInstruction);
                            }
                            if (object.contents) {
                                if (!Array.isArray(object.contents))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.contents: array expected");
                                message.contents = [];
                                for (var i = 0; i < object.contents.length; ++i) {
                                    if (typeof object.contents[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.contents: object expected");
                                    message.contents[i] = $root.google.ai.generativelanguage.v1beta.Content.fromObject(object.contents[i]);
                                }
                            }
                            if (object.tools) {
                                if (!Array.isArray(object.tools))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.tools: array expected");
                                message.tools = [];
                                for (var i = 0; i < object.tools.length; ++i) {
                                    if (typeof object.tools[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.tools: object expected");
                                    message.tools[i] = $root.google.ai.generativelanguage.v1beta.Tool.fromObject(object.tools[i]);
                                }
                            }
                            if (object.toolConfig != null) {
                                if (typeof object.toolConfig !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.toolConfig: object expected");
                                message.toolConfig = $root.google.ai.generativelanguage.v1beta.ToolConfig.fromObject(object.toolConfig);
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.usageMetadata != null) {
                                if (typeof object.usageMetadata !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CachedContent.usageMetadata: object expected");
                                message.usageMetadata = $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.fromObject(object.usageMetadata);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CachedContent message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.CachedContent} message CachedContent
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CachedContent.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.contents = [];
                                object.tools = [];
                            }
                            if (options.defaults) {
                                object.createTime = null;
                                object.updateTime = null;
                                object.usageMetadata = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name")) {
                                object.name = message.name;
                                if (options.oneofs)
                                    object._name = "name";
                            }
                            if (message.model != null && message.hasOwnProperty("model")) {
                                object.model = message.model;
                                if (options.oneofs)
                                    object._model = "model";
                            }
                            if (message.systemInstruction != null && message.hasOwnProperty("systemInstruction")) {
                                object.systemInstruction = $root.google.ai.generativelanguage.v1beta.Content.toObject(message.systemInstruction, options);
                                if (options.oneofs)
                                    object._systemInstruction = "systemInstruction";
                            }
                            if (message.contents && message.contents.length) {
                                object.contents = [];
                                for (var j = 0; j < message.contents.length; ++j)
                                    object.contents[j] = $root.google.ai.generativelanguage.v1beta.Content.toObject(message.contents[j], options);
                            }
                            if (message.tools && message.tools.length) {
                                object.tools = [];
                                for (var j = 0; j < message.tools.length; ++j)
                                    object.tools[j] = $root.google.ai.generativelanguage.v1beta.Tool.toObject(message.tools[j], options);
                            }
                            if (message.toolConfig != null && message.hasOwnProperty("toolConfig")) {
                                object.toolConfig = $root.google.ai.generativelanguage.v1beta.ToolConfig.toObject(message.toolConfig, options);
                                if (options.oneofs)
                                    object._toolConfig = "toolConfig";
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                                object.expireTime = $root.google.protobuf.Timestamp.toObject(message.expireTime, options);
                                if (options.oneofs)
                                    object.expiration = "expireTime";
                            }
                            if (message.ttl != null && message.hasOwnProperty("ttl")) {
                                object.ttl = $root.google.protobuf.Duration.toObject(message.ttl, options);
                                if (options.oneofs)
                                    object.expiration = "ttl";
                            }
                            if (message.displayName != null && message.hasOwnProperty("displayName")) {
                                object.displayName = message.displayName;
                                if (options.oneofs)
                                    object._displayName = "displayName";
                            }
                            if (message.usageMetadata != null && message.hasOwnProperty("usageMetadata"))
                                object.usageMetadata = $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.toObject(message.usageMetadata, options);
                            return object;
                        };
    
                        /**
                         * Converts this CachedContent to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CachedContent.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CachedContent
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.CachedContent
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CachedContent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CachedContent";
                        };
    
                        CachedContent.UsageMetadata = (function() {
    
                            /**
                             * Properties of a UsageMetadata.
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent
                             * @interface IUsageMetadata
                             * @property {number|null} [totalTokenCount] UsageMetadata totalTokenCount
                             */
    
                            /**
                             * Constructs a new UsageMetadata.
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent
                             * @classdesc Represents a UsageMetadata.
                             * @implements IUsageMetadata
                             * @constructor
                             * @param {google.ai.generativelanguage.v1beta.CachedContent.IUsageMetadata=} [properties] Properties to set
                             */
                            function UsageMetadata(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * UsageMetadata totalTokenCount.
                             * @member {number} totalTokenCount
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @instance
                             */
                            UsageMetadata.prototype.totalTokenCount = 0;
    
                            /**
                             * Creates a new UsageMetadata instance using the specified properties.
                             * @function create
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1beta.CachedContent.IUsageMetadata=} [properties] Properties to set
                             * @returns {google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata} UsageMetadata instance
                             */
                            UsageMetadata.create = function create(properties) {
                                return new UsageMetadata(properties);
                            };
    
                            /**
                             * Encodes the specified UsageMetadata message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.verify|verify} messages.
                             * @function encode
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1beta.CachedContent.IUsageMetadata} message UsageMetadata message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UsageMetadata.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.totalTokenCount != null && Object.hasOwnProperty.call(message, "totalTokenCount"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.totalTokenCount);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified UsageMetadata message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1beta.CachedContent.IUsageMetadata} message UsageMetadata message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            UsageMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a UsageMetadata message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata} UsageMetadata
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UsageMetadata.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.totalTokenCount = reader.int32();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a UsageMetadata message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata} UsageMetadata
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            UsageMetadata.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a UsageMetadata message.
                             * @function verify
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            UsageMetadata.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.totalTokenCount != null && message.hasOwnProperty("totalTokenCount"))
                                    if (!$util.isInteger(message.totalTokenCount))
                                        return "totalTokenCount: integer expected";
                                return null;
                            };
    
                            /**
                             * Creates a UsageMetadata message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata} UsageMetadata
                             */
                            UsageMetadata.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata)
                                    return object;
                                var message = new $root.google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata();
                                if (object.totalTokenCount != null)
                                    message.totalTokenCount = object.totalTokenCount | 0;
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a UsageMetadata message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata} message UsageMetadata
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            UsageMetadata.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.totalTokenCount = 0;
                                if (message.totalTokenCount != null && message.hasOwnProperty("totalTokenCount"))
                                    object.totalTokenCount = message.totalTokenCount;
                                return object;
                            };
    
                            /**
                             * Converts this UsageMetadata to JSON.
                             * @function toJSON
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            UsageMetadata.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for UsageMetadata
                             * @function getTypeUrl
                             * @memberof google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            UsageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CachedContent.UsageMetadata";
                            };
    
                            return UsageMetadata;
                        })();
    
                        return CachedContent;
                    })();
    
                    /**
                     * Type enum.
                     * @name google.ai.generativelanguage.v1beta.Type
                     * @enum {number}
                     * @property {number} TYPE_UNSPECIFIED=0 TYPE_UNSPECIFIED value
                     * @property {number} STRING=1 STRING value
                     * @property {number} NUMBER=2 NUMBER value
                     * @property {number} INTEGER=3 INTEGER value
                     * @property {number} BOOLEAN=4 BOOLEAN value
                     * @property {number} ARRAY=5 ARRAY value
                     * @property {number} OBJECT=6 OBJECT value
                     */
                    v1beta.Type = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "STRING"] = 1;
                        values[valuesById[2] = "NUMBER"] = 2;
                        values[valuesById[3] = "INTEGER"] = 3;
                        values[valuesById[4] = "BOOLEAN"] = 4;
                        values[valuesById[5] = "ARRAY"] = 5;
                        values[valuesById[6] = "OBJECT"] = 6;
                        return values;
                    })();
    
                    v1beta.Content = (function() {
    
                        /**
                         * Properties of a Content.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IContent
                         * @property {Array.<google.ai.generativelanguage.v1beta.IPart>|null} [parts] Content parts
                         * @property {string|null} [role] Content role
                         */
    
                        /**
                         * Constructs a new Content.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a Content.
                         * @implements IContent
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IContent=} [properties] Properties to set
                         */
                        function Content(properties) {
                            this.parts = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Content parts.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IPart>} parts
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @instance
                         */
                        Content.prototype.parts = $util.emptyArray;
    
                        /**
                         * Content role.
                         * @member {string} role
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @instance
                         */
                        Content.prototype.role = "";
    
                        /**
                         * Creates a new Content instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IContent=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.Content} Content instance
                         */
                        Content.create = function create(properties) {
                            return new Content(properties);
                        };
    
                        /**
                         * Encodes the specified Content message. Does not implicitly {@link google.ai.generativelanguage.v1beta.Content.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IContent} message Content message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Content.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parts != null && message.parts.length)
                                for (var i = 0; i < message.parts.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Part.encode(message.parts[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.role != null && Object.hasOwnProperty.call(message, "role"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.role);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Content message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.Content.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IContent} message Content message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Content.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Content message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.Content} Content
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Content.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.Content();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.parts && message.parts.length))
                                            message.parts = [];
                                        message.parts.push($root.google.ai.generativelanguage.v1beta.Part.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.role = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Content message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.Content} Content
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Content.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Content message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Content.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parts != null && message.hasOwnProperty("parts")) {
                                if (!Array.isArray(message.parts))
                                    return "parts: array expected";
                                for (var i = 0; i < message.parts.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Part.verify(message.parts[i]);
                                    if (error)
                                        return "parts." + error;
                                }
                            }
                            if (message.role != null && message.hasOwnProperty("role"))
                                if (!$util.isString(message.role))
                                    return "role: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a Content message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.Content} Content
                         */
                        Content.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.Content)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.Content();
                            if (object.parts) {
                                if (!Array.isArray(object.parts))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Content.parts: array expected");
                                message.parts = [];
                                for (var i = 0; i < object.parts.length; ++i) {
                                    if (typeof object.parts[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.Content.parts: object expected");
                                    message.parts[i] = $root.google.ai.generativelanguage.v1beta.Part.fromObject(object.parts[i]);
                                }
                            }
                            if (object.role != null)
                                message.role = String(object.role);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Content message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.Content} message Content
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Content.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.parts = [];
                            if (options.defaults)
                                object.role = "";
                            if (message.parts && message.parts.length) {
                                object.parts = [];
                                for (var j = 0; j < message.parts.length; ++j)
                                    object.parts[j] = $root.google.ai.generativelanguage.v1beta.Part.toObject(message.parts[j], options);
                            }
                            if (message.role != null && message.hasOwnProperty("role"))
                                object.role = message.role;
                            return object;
                        };
    
                        /**
                         * Converts this Content to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Content.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Content
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.Content
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Content.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.Content";
                        };
    
                        return Content;
                    })();
    
                    v1beta.Part = (function() {
    
                        /**
                         * Properties of a Part.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IPart
                         * @property {string|null} [text] Part text
                         * @property {google.ai.generativelanguage.v1beta.IBlob|null} [inlineData] Part inlineData
                         * @property {google.ai.generativelanguage.v1beta.IFunctionCall|null} [functionCall] Part functionCall
                         * @property {google.ai.generativelanguage.v1beta.IFunctionResponse|null} [functionResponse] Part functionResponse
                         * @property {google.ai.generativelanguage.v1beta.IFileData|null} [fileData] Part fileData
                         * @property {google.ai.generativelanguage.v1beta.IExecutableCode|null} [executableCode] Part executableCode
                         * @property {google.ai.generativelanguage.v1beta.ICodeExecutionResult|null} [codeExecutionResult] Part codeExecutionResult
                         */
    
                        /**
                         * Constructs a new Part.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a Part.
                         * @implements IPart
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IPart=} [properties] Properties to set
                         */
                        function Part(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Part text.
                         * @member {string|null|undefined} text
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.text = null;
    
                        /**
                         * Part inlineData.
                         * @member {google.ai.generativelanguage.v1beta.IBlob|null|undefined} inlineData
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.inlineData = null;
    
                        /**
                         * Part functionCall.
                         * @member {google.ai.generativelanguage.v1beta.IFunctionCall|null|undefined} functionCall
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.functionCall = null;
    
                        /**
                         * Part functionResponse.
                         * @member {google.ai.generativelanguage.v1beta.IFunctionResponse|null|undefined} functionResponse
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.functionResponse = null;
    
                        /**
                         * Part fileData.
                         * @member {google.ai.generativelanguage.v1beta.IFileData|null|undefined} fileData
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.fileData = null;
    
                        /**
                         * Part executableCode.
                         * @member {google.ai.generativelanguage.v1beta.IExecutableCode|null|undefined} executableCode
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.executableCode = null;
    
                        /**
                         * Part codeExecutionResult.
                         * @member {google.ai.generativelanguage.v1beta.ICodeExecutionResult|null|undefined} codeExecutionResult
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Part.prototype.codeExecutionResult = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Part data.
                         * @member {"text"|"inlineData"|"functionCall"|"functionResponse"|"fileData"|"executableCode"|"codeExecutionResult"|undefined} data
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         */
                        Object.defineProperty(Part.prototype, "data", {
                            get: $util.oneOfGetter($oneOfFields = ["text", "inlineData", "functionCall", "functionResponse", "fileData", "executableCode", "codeExecutionResult"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Part instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IPart=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.Part} Part instance
                         */
                        Part.create = function create(properties) {
                            return new Part(properties);
                        };
    
                        /**
                         * Encodes the specified Part message. Does not implicitly {@link google.ai.generativelanguage.v1beta.Part.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IPart} message Part message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Part.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.text);
                            if (message.inlineData != null && Object.hasOwnProperty.call(message, "inlineData"))
                                $root.google.ai.generativelanguage.v1beta.Blob.encode(message.inlineData, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.functionCall != null && Object.hasOwnProperty.call(message, "functionCall"))
                                $root.google.ai.generativelanguage.v1beta.FunctionCall.encode(message.functionCall, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.functionResponse != null && Object.hasOwnProperty.call(message, "functionResponse"))
                                $root.google.ai.generativelanguage.v1beta.FunctionResponse.encode(message.functionResponse, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.fileData != null && Object.hasOwnProperty.call(message, "fileData"))
                                $root.google.ai.generativelanguage.v1beta.FileData.encode(message.fileData, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.executableCode != null && Object.hasOwnProperty.call(message, "executableCode"))
                                $root.google.ai.generativelanguage.v1beta.ExecutableCode.encode(message.executableCode, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.codeExecutionResult != null && Object.hasOwnProperty.call(message, "codeExecutionResult"))
                                $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.encode(message.codeExecutionResult, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Part message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.Part.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IPart} message Part message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Part.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Part message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.Part} Part
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Part.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.Part();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 2: {
                                        message.text = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.inlineData = $root.google.ai.generativelanguage.v1beta.Blob.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.functionCall = $root.google.ai.generativelanguage.v1beta.FunctionCall.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        message.functionResponse = $root.google.ai.generativelanguage.v1beta.FunctionResponse.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.fileData = $root.google.ai.generativelanguage.v1beta.FileData.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.executableCode = $root.google.ai.generativelanguage.v1beta.ExecutableCode.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 10: {
                                        message.codeExecutionResult = $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Part message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.Part} Part
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Part.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Part message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Part.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.text != null && message.hasOwnProperty("text")) {
                                properties.data = 1;
                                if (!$util.isString(message.text))
                                    return "text: string expected";
                            }
                            if (message.inlineData != null && message.hasOwnProperty("inlineData")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.Blob.verify(message.inlineData);
                                    if (error)
                                        return "inlineData." + error;
                                }
                            }
                            if (message.functionCall != null && message.hasOwnProperty("functionCall")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.FunctionCall.verify(message.functionCall);
                                    if (error)
                                        return "functionCall." + error;
                                }
                            }
                            if (message.functionResponse != null && message.hasOwnProperty("functionResponse")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.FunctionResponse.verify(message.functionResponse);
                                    if (error)
                                        return "functionResponse." + error;
                                }
                            }
                            if (message.fileData != null && message.hasOwnProperty("fileData")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.FileData.verify(message.fileData);
                                    if (error)
                                        return "fileData." + error;
                                }
                            }
                            if (message.executableCode != null && message.hasOwnProperty("executableCode")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.ExecutableCode.verify(message.executableCode);
                                    if (error)
                                        return "executableCode." + error;
                                }
                            }
                            if (message.codeExecutionResult != null && message.hasOwnProperty("codeExecutionResult")) {
                                if (properties.data === 1)
                                    return "data: multiple values";
                                properties.data = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.verify(message.codeExecutionResult);
                                    if (error)
                                        return "codeExecutionResult." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Part message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.Part} Part
                         */
                        Part.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.Part)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.Part();
                            if (object.text != null)
                                message.text = String(object.text);
                            if (object.inlineData != null) {
                                if (typeof object.inlineData !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Part.inlineData: object expected");
                                message.inlineData = $root.google.ai.generativelanguage.v1beta.Blob.fromObject(object.inlineData);
                            }
                            if (object.functionCall != null) {
                                if (typeof object.functionCall !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Part.functionCall: object expected");
                                message.functionCall = $root.google.ai.generativelanguage.v1beta.FunctionCall.fromObject(object.functionCall);
                            }
                            if (object.functionResponse != null) {
                                if (typeof object.functionResponse !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Part.functionResponse: object expected");
                                message.functionResponse = $root.google.ai.generativelanguage.v1beta.FunctionResponse.fromObject(object.functionResponse);
                            }
                            if (object.fileData != null) {
                                if (typeof object.fileData !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Part.fileData: object expected");
                                message.fileData = $root.google.ai.generativelanguage.v1beta.FileData.fromObject(object.fileData);
                            }
                            if (object.executableCode != null) {
                                if (typeof object.executableCode !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Part.executableCode: object expected");
                                message.executableCode = $root.google.ai.generativelanguage.v1beta.ExecutableCode.fromObject(object.executableCode);
                            }
                            if (object.codeExecutionResult != null) {
                                if (typeof object.codeExecutionResult !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Part.codeExecutionResult: object expected");
                                message.codeExecutionResult = $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.fromObject(object.codeExecutionResult);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Part message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.Part} message Part
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Part.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.text != null && message.hasOwnProperty("text")) {
                                object.text = message.text;
                                if (options.oneofs)
                                    object.data = "text";
                            }
                            if (message.inlineData != null && message.hasOwnProperty("inlineData")) {
                                object.inlineData = $root.google.ai.generativelanguage.v1beta.Blob.toObject(message.inlineData, options);
                                if (options.oneofs)
                                    object.data = "inlineData";
                            }
                            if (message.functionCall != null && message.hasOwnProperty("functionCall")) {
                                object.functionCall = $root.google.ai.generativelanguage.v1beta.FunctionCall.toObject(message.functionCall, options);
                                if (options.oneofs)
                                    object.data = "functionCall";
                            }
                            if (message.functionResponse != null && message.hasOwnProperty("functionResponse")) {
                                object.functionResponse = $root.google.ai.generativelanguage.v1beta.FunctionResponse.toObject(message.functionResponse, options);
                                if (options.oneofs)
                                    object.data = "functionResponse";
                            }
                            if (message.fileData != null && message.hasOwnProperty("fileData")) {
                                object.fileData = $root.google.ai.generativelanguage.v1beta.FileData.toObject(message.fileData, options);
                                if (options.oneofs)
                                    object.data = "fileData";
                            }
                            if (message.executableCode != null && message.hasOwnProperty("executableCode")) {
                                object.executableCode = $root.google.ai.generativelanguage.v1beta.ExecutableCode.toObject(message.executableCode, options);
                                if (options.oneofs)
                                    object.data = "executableCode";
                            }
                            if (message.codeExecutionResult != null && message.hasOwnProperty("codeExecutionResult")) {
                                object.codeExecutionResult = $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.toObject(message.codeExecutionResult, options);
                                if (options.oneofs)
                                    object.data = "codeExecutionResult";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Part to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Part.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Part
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.Part
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Part.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.Part";
                        };
    
                        return Part;
                    })();
    
                    v1beta.Blob = (function() {
    
                        /**
                         * Properties of a Blob.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IBlob
                         * @property {string|null} [mimeType] Blob mimeType
                         * @property {Uint8Array|null} [data] Blob data
                         */
    
                        /**
                         * Constructs a new Blob.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a Blob.
                         * @implements IBlob
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IBlob=} [properties] Properties to set
                         */
                        function Blob(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Blob mimeType.
                         * @member {string} mimeType
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @instance
                         */
                        Blob.prototype.mimeType = "";
    
                        /**
                         * Blob data.
                         * @member {Uint8Array} data
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @instance
                         */
                        Blob.prototype.data = $util.newBuffer([]);
    
                        /**
                         * Creates a new Blob instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IBlob=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.Blob} Blob instance
                         */
                        Blob.create = function create(properties) {
                            return new Blob(properties);
                        };
    
                        /**
                         * Encodes the specified Blob message. Does not implicitly {@link google.ai.generativelanguage.v1beta.Blob.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IBlob} message Blob message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Blob.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.mimeType != null && Object.hasOwnProperty.call(message, "mimeType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.mimeType);
                            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.data);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Blob message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.Blob.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IBlob} message Blob message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Blob.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Blob message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.Blob} Blob
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Blob.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.Blob();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.mimeType = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.data = reader.bytes();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Blob message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.Blob} Blob
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Blob.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Blob message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Blob.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                if (!$util.isString(message.mimeType))
                                    return "mimeType: string expected";
                            if (message.data != null && message.hasOwnProperty("data"))
                                if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                                    return "data: buffer expected";
                            return null;
                        };
    
                        /**
                         * Creates a Blob message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.Blob} Blob
                         */
                        Blob.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.Blob)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.Blob();
                            if (object.mimeType != null)
                                message.mimeType = String(object.mimeType);
                            if (object.data != null)
                                if (typeof object.data === "string")
                                    $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                                else if (object.data.length >= 0)
                                    message.data = object.data;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Blob message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.Blob} message Blob
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Blob.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.mimeType = "";
                                if (options.bytes === String)
                                    object.data = "";
                                else {
                                    object.data = [];
                                    if (options.bytes !== Array)
                                        object.data = $util.newBuffer(object.data);
                                }
                            }
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                object.mimeType = message.mimeType;
                            if (message.data != null && message.hasOwnProperty("data"))
                                object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                            return object;
                        };
    
                        /**
                         * Converts this Blob to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Blob.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Blob
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.Blob
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Blob.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.Blob";
                        };
    
                        return Blob;
                    })();
    
                    v1beta.FileData = (function() {
    
                        /**
                         * Properties of a FileData.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IFileData
                         * @property {string|null} [mimeType] FileData mimeType
                         * @property {string|null} [fileUri] FileData fileUri
                         */
    
                        /**
                         * Constructs a new FileData.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a FileData.
                         * @implements IFileData
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IFileData=} [properties] Properties to set
                         */
                        function FileData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FileData mimeType.
                         * @member {string} mimeType
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @instance
                         */
                        FileData.prototype.mimeType = "";
    
                        /**
                         * FileData fileUri.
                         * @member {string} fileUri
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @instance
                         */
                        FileData.prototype.fileUri = "";
    
                        /**
                         * Creates a new FileData instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFileData=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.FileData} FileData instance
                         */
                        FileData.create = function create(properties) {
                            return new FileData(properties);
                        };
    
                        /**
                         * Encodes the specified FileData message. Does not implicitly {@link google.ai.generativelanguage.v1beta.FileData.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFileData} message FileData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FileData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.mimeType != null && Object.hasOwnProperty.call(message, "mimeType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.mimeType);
                            if (message.fileUri != null && Object.hasOwnProperty.call(message, "fileUri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.fileUri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FileData message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.FileData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFileData} message FileData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FileData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FileData message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.FileData} FileData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FileData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.FileData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.mimeType = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.fileUri = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FileData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.FileData} FileData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FileData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FileData message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FileData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                if (!$util.isString(message.mimeType))
                                    return "mimeType: string expected";
                            if (message.fileUri != null && message.hasOwnProperty("fileUri"))
                                if (!$util.isString(message.fileUri))
                                    return "fileUri: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a FileData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.FileData} FileData
                         */
                        FileData.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.FileData)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.FileData();
                            if (object.mimeType != null)
                                message.mimeType = String(object.mimeType);
                            if (object.fileUri != null)
                                message.fileUri = String(object.fileUri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FileData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.FileData} message FileData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FileData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.mimeType = "";
                                object.fileUri = "";
                            }
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                object.mimeType = message.mimeType;
                            if (message.fileUri != null && message.hasOwnProperty("fileUri"))
                                object.fileUri = message.fileUri;
                            return object;
                        };
    
                        /**
                         * Converts this FileData to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FileData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for FileData
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.FileData
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        FileData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.FileData";
                        };
    
                        return FileData;
                    })();
    
                    v1beta.ExecutableCode = (function() {
    
                        /**
                         * Properties of an ExecutableCode.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IExecutableCode
                         * @property {google.ai.generativelanguage.v1beta.ExecutableCode.Language|null} [language] ExecutableCode language
                         * @property {string|null} [code] ExecutableCode code
                         */
    
                        /**
                         * Constructs a new ExecutableCode.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents an ExecutableCode.
                         * @implements IExecutableCode
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IExecutableCode=} [properties] Properties to set
                         */
                        function ExecutableCode(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExecutableCode language.
                         * @member {google.ai.generativelanguage.v1beta.ExecutableCode.Language} language
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @instance
                         */
                        ExecutableCode.prototype.language = 0;
    
                        /**
                         * ExecutableCode code.
                         * @member {string} code
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @instance
                         */
                        ExecutableCode.prototype.code = "";
    
                        /**
                         * Creates a new ExecutableCode instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IExecutableCode=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.ExecutableCode} ExecutableCode instance
                         */
                        ExecutableCode.create = function create(properties) {
                            return new ExecutableCode(properties);
                        };
    
                        /**
                         * Encodes the specified ExecutableCode message. Does not implicitly {@link google.ai.generativelanguage.v1beta.ExecutableCode.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IExecutableCode} message ExecutableCode message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExecutableCode.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.language != null && Object.hasOwnProperty.call(message, "language"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.language);
                            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.code);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExecutableCode message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.ExecutableCode.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IExecutableCode} message ExecutableCode message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExecutableCode.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExecutableCode message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.ExecutableCode} ExecutableCode
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExecutableCode.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.ExecutableCode();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.language = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.code = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExecutableCode message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.ExecutableCode} ExecutableCode
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExecutableCode.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExecutableCode message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExecutableCode.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.language != null && message.hasOwnProperty("language"))
                                switch (message.language) {
                                default:
                                    return "language: enum value expected";
                                case 0:
                                case 1:
                                    break;
                                }
                            if (message.code != null && message.hasOwnProperty("code"))
                                if (!$util.isString(message.code))
                                    return "code: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ExecutableCode message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.ExecutableCode} ExecutableCode
                         */
                        ExecutableCode.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.ExecutableCode)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.ExecutableCode();
                            switch (object.language) {
                            default:
                                if (typeof object.language === "number") {
                                    message.language = object.language;
                                    break;
                                }
                                break;
                            case "LANGUAGE_UNSPECIFIED":
                            case 0:
                                message.language = 0;
                                break;
                            case "PYTHON":
                            case 1:
                                message.language = 1;
                                break;
                            }
                            if (object.code != null)
                                message.code = String(object.code);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExecutableCode message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ExecutableCode} message ExecutableCode
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExecutableCode.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.language = options.enums === String ? "LANGUAGE_UNSPECIFIED" : 0;
                                object.code = "";
                            }
                            if (message.language != null && message.hasOwnProperty("language"))
                                object.language = options.enums === String ? $root.google.ai.generativelanguage.v1beta.ExecutableCode.Language[message.language] === undefined ? message.language : $root.google.ai.generativelanguage.v1beta.ExecutableCode.Language[message.language] : message.language;
                            if (message.code != null && message.hasOwnProperty("code"))
                                object.code = message.code;
                            return object;
                        };
    
                        /**
                         * Converts this ExecutableCode to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExecutableCode.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ExecutableCode
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.ExecutableCode
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ExecutableCode.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.ExecutableCode";
                        };
    
                        /**
                         * Language enum.
                         * @name google.ai.generativelanguage.v1beta.ExecutableCode.Language
                         * @enum {number}
                         * @property {number} LANGUAGE_UNSPECIFIED=0 LANGUAGE_UNSPECIFIED value
                         * @property {number} PYTHON=1 PYTHON value
                         */
                        ExecutableCode.Language = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "LANGUAGE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "PYTHON"] = 1;
                            return values;
                        })();
    
                        return ExecutableCode;
                    })();
    
                    v1beta.CodeExecutionResult = (function() {
    
                        /**
                         * Properties of a CodeExecutionResult.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ICodeExecutionResult
                         * @property {google.ai.generativelanguage.v1beta.CodeExecutionResult.Outcome|null} [outcome] CodeExecutionResult outcome
                         * @property {string|null} [output] CodeExecutionResult output
                         */
    
                        /**
                         * Constructs a new CodeExecutionResult.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CodeExecutionResult.
                         * @implements ICodeExecutionResult
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecutionResult=} [properties] Properties to set
                         */
                        function CodeExecutionResult(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CodeExecutionResult outcome.
                         * @member {google.ai.generativelanguage.v1beta.CodeExecutionResult.Outcome} outcome
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @instance
                         */
                        CodeExecutionResult.prototype.outcome = 0;
    
                        /**
                         * CodeExecutionResult output.
                         * @member {string} output
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @instance
                         */
                        CodeExecutionResult.prototype.output = "";
    
                        /**
                         * Creates a new CodeExecutionResult instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecutionResult=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecutionResult} CodeExecutionResult instance
                         */
                        CodeExecutionResult.create = function create(properties) {
                            return new CodeExecutionResult(properties);
                        };
    
                        /**
                         * Encodes the specified CodeExecutionResult message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CodeExecutionResult.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecutionResult} message CodeExecutionResult message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CodeExecutionResult.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.outcome != null && Object.hasOwnProperty.call(message, "outcome"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.outcome);
                            if (message.output != null && Object.hasOwnProperty.call(message, "output"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.output);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CodeExecutionResult message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CodeExecutionResult.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecutionResult} message CodeExecutionResult message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CodeExecutionResult.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CodeExecutionResult message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecutionResult} CodeExecutionResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CodeExecutionResult.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CodeExecutionResult();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.outcome = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.output = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CodeExecutionResult message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecutionResult} CodeExecutionResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CodeExecutionResult.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CodeExecutionResult message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CodeExecutionResult.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.outcome != null && message.hasOwnProperty("outcome"))
                                switch (message.outcome) {
                                default:
                                    return "outcome: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.output != null && message.hasOwnProperty("output"))
                                if (!$util.isString(message.output))
                                    return "output: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CodeExecutionResult message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecutionResult} CodeExecutionResult
                         */
                        CodeExecutionResult.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.CodeExecutionResult)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.CodeExecutionResult();
                            switch (object.outcome) {
                            default:
                                if (typeof object.outcome === "number") {
                                    message.outcome = object.outcome;
                                    break;
                                }
                                break;
                            case "OUTCOME_UNSPECIFIED":
                            case 0:
                                message.outcome = 0;
                                break;
                            case "OUTCOME_OK":
                            case 1:
                                message.outcome = 1;
                                break;
                            case "OUTCOME_FAILED":
                            case 2:
                                message.outcome = 2;
                                break;
                            case "OUTCOME_DEADLINE_EXCEEDED":
                            case 3:
                                message.outcome = 3;
                                break;
                            }
                            if (object.output != null)
                                message.output = String(object.output);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CodeExecutionResult message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.CodeExecutionResult} message CodeExecutionResult
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CodeExecutionResult.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.outcome = options.enums === String ? "OUTCOME_UNSPECIFIED" : 0;
                                object.output = "";
                            }
                            if (message.outcome != null && message.hasOwnProperty("outcome"))
                                object.outcome = options.enums === String ? $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.Outcome[message.outcome] === undefined ? message.outcome : $root.google.ai.generativelanguage.v1beta.CodeExecutionResult.Outcome[message.outcome] : message.outcome;
                            if (message.output != null && message.hasOwnProperty("output"))
                                object.output = message.output;
                            return object;
                        };
    
                        /**
                         * Converts this CodeExecutionResult to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CodeExecutionResult.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CodeExecutionResult
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecutionResult
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CodeExecutionResult.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CodeExecutionResult";
                        };
    
                        /**
                         * Outcome enum.
                         * @name google.ai.generativelanguage.v1beta.CodeExecutionResult.Outcome
                         * @enum {number}
                         * @property {number} OUTCOME_UNSPECIFIED=0 OUTCOME_UNSPECIFIED value
                         * @property {number} OUTCOME_OK=1 OUTCOME_OK value
                         * @property {number} OUTCOME_FAILED=2 OUTCOME_FAILED value
                         * @property {number} OUTCOME_DEADLINE_EXCEEDED=3 OUTCOME_DEADLINE_EXCEEDED value
                         */
                        CodeExecutionResult.Outcome = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "OUTCOME_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "OUTCOME_OK"] = 1;
                            values[valuesById[2] = "OUTCOME_FAILED"] = 2;
                            values[valuesById[3] = "OUTCOME_DEADLINE_EXCEEDED"] = 3;
                            return values;
                        })();
    
                        return CodeExecutionResult;
                    })();
    
                    v1beta.Tool = (function() {
    
                        /**
                         * Properties of a Tool.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ITool
                         * @property {Array.<google.ai.generativelanguage.v1beta.IFunctionDeclaration>|null} [functionDeclarations] Tool functionDeclarations
                         * @property {google.ai.generativelanguage.v1beta.ICodeExecution|null} [codeExecution] Tool codeExecution
                         */
    
                        /**
                         * Constructs a new Tool.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a Tool.
                         * @implements ITool
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ITool=} [properties] Properties to set
                         */
                        function Tool(properties) {
                            this.functionDeclarations = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Tool functionDeclarations.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IFunctionDeclaration>} functionDeclarations
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @instance
                         */
                        Tool.prototype.functionDeclarations = $util.emptyArray;
    
                        /**
                         * Tool codeExecution.
                         * @member {google.ai.generativelanguage.v1beta.ICodeExecution|null|undefined} codeExecution
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @instance
                         */
                        Tool.prototype.codeExecution = null;
    
                        /**
                         * Creates a new Tool instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ITool=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.Tool} Tool instance
                         */
                        Tool.create = function create(properties) {
                            return new Tool(properties);
                        };
    
                        /**
                         * Encodes the specified Tool message. Does not implicitly {@link google.ai.generativelanguage.v1beta.Tool.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ITool} message Tool message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Tool.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.functionDeclarations != null && message.functionDeclarations.length)
                                for (var i = 0; i < message.functionDeclarations.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.FunctionDeclaration.encode(message.functionDeclarations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.codeExecution != null && Object.hasOwnProperty.call(message, "codeExecution"))
                                $root.google.ai.generativelanguage.v1beta.CodeExecution.encode(message.codeExecution, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Tool message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.Tool.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ITool} message Tool message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Tool.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Tool message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.Tool} Tool
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Tool.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.Tool();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.functionDeclarations && message.functionDeclarations.length))
                                            message.functionDeclarations = [];
                                        message.functionDeclarations.push($root.google.ai.generativelanguage.v1beta.FunctionDeclaration.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.codeExecution = $root.google.ai.generativelanguage.v1beta.CodeExecution.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Tool message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.Tool} Tool
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Tool.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Tool message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Tool.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.functionDeclarations != null && message.hasOwnProperty("functionDeclarations")) {
                                if (!Array.isArray(message.functionDeclarations))
                                    return "functionDeclarations: array expected";
                                for (var i = 0; i < message.functionDeclarations.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.FunctionDeclaration.verify(message.functionDeclarations[i]);
                                    if (error)
                                        return "functionDeclarations." + error;
                                }
                            }
                            if (message.codeExecution != null && message.hasOwnProperty("codeExecution")) {
                                var error = $root.google.ai.generativelanguage.v1beta.CodeExecution.verify(message.codeExecution);
                                if (error)
                                    return "codeExecution." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Tool message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.Tool} Tool
                         */
                        Tool.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.Tool)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.Tool();
                            if (object.functionDeclarations) {
                                if (!Array.isArray(object.functionDeclarations))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Tool.functionDeclarations: array expected");
                                message.functionDeclarations = [];
                                for (var i = 0; i < object.functionDeclarations.length; ++i) {
                                    if (typeof object.functionDeclarations[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.Tool.functionDeclarations: object expected");
                                    message.functionDeclarations[i] = $root.google.ai.generativelanguage.v1beta.FunctionDeclaration.fromObject(object.functionDeclarations[i]);
                                }
                            }
                            if (object.codeExecution != null) {
                                if (typeof object.codeExecution !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Tool.codeExecution: object expected");
                                message.codeExecution = $root.google.ai.generativelanguage.v1beta.CodeExecution.fromObject(object.codeExecution);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Tool message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.Tool} message Tool
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Tool.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.functionDeclarations = [];
                            if (options.defaults)
                                object.codeExecution = null;
                            if (message.functionDeclarations && message.functionDeclarations.length) {
                                object.functionDeclarations = [];
                                for (var j = 0; j < message.functionDeclarations.length; ++j)
                                    object.functionDeclarations[j] = $root.google.ai.generativelanguage.v1beta.FunctionDeclaration.toObject(message.functionDeclarations[j], options);
                            }
                            if (message.codeExecution != null && message.hasOwnProperty("codeExecution"))
                                object.codeExecution = $root.google.ai.generativelanguage.v1beta.CodeExecution.toObject(message.codeExecution, options);
                            return object;
                        };
    
                        /**
                         * Converts this Tool to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Tool.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Tool
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.Tool
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Tool.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.Tool";
                        };
    
                        return Tool;
                    })();
    
                    v1beta.CodeExecution = (function() {
    
                        /**
                         * Properties of a CodeExecution.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ICodeExecution
                         */
    
                        /**
                         * Constructs a new CodeExecution.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CodeExecution.
                         * @implements ICodeExecution
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecution=} [properties] Properties to set
                         */
                        function CodeExecution(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new CodeExecution instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecution=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecution} CodeExecution instance
                         */
                        CodeExecution.create = function create(properties) {
                            return new CodeExecution(properties);
                        };
    
                        /**
                         * Encodes the specified CodeExecution message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CodeExecution.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecution} message CodeExecution message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CodeExecution.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CodeExecution message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CodeExecution.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICodeExecution} message CodeExecution message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CodeExecution.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CodeExecution message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecution} CodeExecution
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CodeExecution.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CodeExecution();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CodeExecution message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecution} CodeExecution
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CodeExecution.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CodeExecution message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CodeExecution.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a CodeExecution message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.CodeExecution} CodeExecution
                         */
                        CodeExecution.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.CodeExecution)
                                return object;
                            return new $root.google.ai.generativelanguage.v1beta.CodeExecution();
                        };
    
                        /**
                         * Creates a plain object from a CodeExecution message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.CodeExecution} message CodeExecution
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CodeExecution.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this CodeExecution to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CodeExecution.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CodeExecution
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.CodeExecution
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CodeExecution.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CodeExecution";
                        };
    
                        return CodeExecution;
                    })();
    
                    v1beta.ToolConfig = (function() {
    
                        /**
                         * Properties of a ToolConfig.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IToolConfig
                         * @property {google.ai.generativelanguage.v1beta.IFunctionCallingConfig|null} [functionCallingConfig] ToolConfig functionCallingConfig
                         */
    
                        /**
                         * Constructs a new ToolConfig.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a ToolConfig.
                         * @implements IToolConfig
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IToolConfig=} [properties] Properties to set
                         */
                        function ToolConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ToolConfig functionCallingConfig.
                         * @member {google.ai.generativelanguage.v1beta.IFunctionCallingConfig|null|undefined} functionCallingConfig
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @instance
                         */
                        ToolConfig.prototype.functionCallingConfig = null;
    
                        /**
                         * Creates a new ToolConfig instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IToolConfig=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.ToolConfig} ToolConfig instance
                         */
                        ToolConfig.create = function create(properties) {
                            return new ToolConfig(properties);
                        };
    
                        /**
                         * Encodes the specified ToolConfig message. Does not implicitly {@link google.ai.generativelanguage.v1beta.ToolConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IToolConfig} message ToolConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ToolConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.functionCallingConfig != null && Object.hasOwnProperty.call(message, "functionCallingConfig"))
                                $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.encode(message.functionCallingConfig, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ToolConfig message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.ToolConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IToolConfig} message ToolConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ToolConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ToolConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.ToolConfig} ToolConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ToolConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.ToolConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.functionCallingConfig = $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ToolConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.ToolConfig} ToolConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ToolConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ToolConfig message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ToolConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.functionCallingConfig != null && message.hasOwnProperty("functionCallingConfig")) {
                                var error = $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.verify(message.functionCallingConfig);
                                if (error)
                                    return "functionCallingConfig." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ToolConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.ToolConfig} ToolConfig
                         */
                        ToolConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.ToolConfig)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.ToolConfig();
                            if (object.functionCallingConfig != null) {
                                if (typeof object.functionCallingConfig !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.ToolConfig.functionCallingConfig: object expected");
                                message.functionCallingConfig = $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.fromObject(object.functionCallingConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ToolConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ToolConfig} message ToolConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ToolConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.functionCallingConfig = null;
                            if (message.functionCallingConfig != null && message.hasOwnProperty("functionCallingConfig"))
                                object.functionCallingConfig = $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.toObject(message.functionCallingConfig, options);
                            return object;
                        };
    
                        /**
                         * Converts this ToolConfig to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ToolConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ToolConfig
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.ToolConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ToolConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.ToolConfig";
                        };
    
                        return ToolConfig;
                    })();
    
                    v1beta.FunctionCallingConfig = (function() {
    
                        /**
                         * Properties of a FunctionCallingConfig.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IFunctionCallingConfig
                         * @property {google.ai.generativelanguage.v1beta.FunctionCallingConfig.Mode|null} [mode] FunctionCallingConfig mode
                         * @property {Array.<string>|null} [allowedFunctionNames] FunctionCallingConfig allowedFunctionNames
                         */
    
                        /**
                         * Constructs a new FunctionCallingConfig.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a FunctionCallingConfig.
                         * @implements IFunctionCallingConfig
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCallingConfig=} [properties] Properties to set
                         */
                        function FunctionCallingConfig(properties) {
                            this.allowedFunctionNames = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FunctionCallingConfig mode.
                         * @member {google.ai.generativelanguage.v1beta.FunctionCallingConfig.Mode} mode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @instance
                         */
                        FunctionCallingConfig.prototype.mode = 0;
    
                        /**
                         * FunctionCallingConfig allowedFunctionNames.
                         * @member {Array.<string>} allowedFunctionNames
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @instance
                         */
                        FunctionCallingConfig.prototype.allowedFunctionNames = $util.emptyArray;
    
                        /**
                         * Creates a new FunctionCallingConfig instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCallingConfig=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCallingConfig} FunctionCallingConfig instance
                         */
                        FunctionCallingConfig.create = function create(properties) {
                            return new FunctionCallingConfig(properties);
                        };
    
                        /**
                         * Encodes the specified FunctionCallingConfig message. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionCallingConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCallingConfig} message FunctionCallingConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionCallingConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.mode != null && Object.hasOwnProperty.call(message, "mode"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.mode);
                            if (message.allowedFunctionNames != null && message.allowedFunctionNames.length)
                                for (var i = 0; i < message.allowedFunctionNames.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.allowedFunctionNames[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FunctionCallingConfig message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionCallingConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCallingConfig} message FunctionCallingConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionCallingConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FunctionCallingConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCallingConfig} FunctionCallingConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionCallingConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.mode = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.allowedFunctionNames && message.allowedFunctionNames.length))
                                            message.allowedFunctionNames = [];
                                        message.allowedFunctionNames.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FunctionCallingConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCallingConfig} FunctionCallingConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionCallingConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FunctionCallingConfig message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FunctionCallingConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.mode != null && message.hasOwnProperty("mode"))
                                switch (message.mode) {
                                default:
                                    return "mode: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.allowedFunctionNames != null && message.hasOwnProperty("allowedFunctionNames")) {
                                if (!Array.isArray(message.allowedFunctionNames))
                                    return "allowedFunctionNames: array expected";
                                for (var i = 0; i < message.allowedFunctionNames.length; ++i)
                                    if (!$util.isString(message.allowedFunctionNames[i]))
                                        return "allowedFunctionNames: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a FunctionCallingConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCallingConfig} FunctionCallingConfig
                         */
                        FunctionCallingConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig();
                            switch (object.mode) {
                            default:
                                if (typeof object.mode === "number") {
                                    message.mode = object.mode;
                                    break;
                                }
                                break;
                            case "MODE_UNSPECIFIED":
                            case 0:
                                message.mode = 0;
                                break;
                            case "AUTO":
                            case 1:
                                message.mode = 1;
                                break;
                            case "ANY":
                            case 2:
                                message.mode = 2;
                                break;
                            case "NONE":
                            case 3:
                                message.mode = 3;
                                break;
                            }
                            if (object.allowedFunctionNames) {
                                if (!Array.isArray(object.allowedFunctionNames))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.FunctionCallingConfig.allowedFunctionNames: array expected");
                                message.allowedFunctionNames = [];
                                for (var i = 0; i < object.allowedFunctionNames.length; ++i)
                                    message.allowedFunctionNames[i] = String(object.allowedFunctionNames[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FunctionCallingConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.FunctionCallingConfig} message FunctionCallingConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FunctionCallingConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.allowedFunctionNames = [];
                            if (options.defaults)
                                object.mode = options.enums === String ? "MODE_UNSPECIFIED" : 0;
                            if (message.mode != null && message.hasOwnProperty("mode"))
                                object.mode = options.enums === String ? $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.Mode[message.mode] === undefined ? message.mode : $root.google.ai.generativelanguage.v1beta.FunctionCallingConfig.Mode[message.mode] : message.mode;
                            if (message.allowedFunctionNames && message.allowedFunctionNames.length) {
                                object.allowedFunctionNames = [];
                                for (var j = 0; j < message.allowedFunctionNames.length; ++j)
                                    object.allowedFunctionNames[j] = message.allowedFunctionNames[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this FunctionCallingConfig to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FunctionCallingConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for FunctionCallingConfig
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCallingConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        FunctionCallingConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.FunctionCallingConfig";
                        };
    
                        /**
                         * Mode enum.
                         * @name google.ai.generativelanguage.v1beta.FunctionCallingConfig.Mode
                         * @enum {number}
                         * @property {number} MODE_UNSPECIFIED=0 MODE_UNSPECIFIED value
                         * @property {number} AUTO=1 AUTO value
                         * @property {number} ANY=2 ANY value
                         * @property {number} NONE=3 NONE value
                         */
                        FunctionCallingConfig.Mode = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "MODE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "AUTO"] = 1;
                            values[valuesById[2] = "ANY"] = 2;
                            values[valuesById[3] = "NONE"] = 3;
                            return values;
                        })();
    
                        return FunctionCallingConfig;
                    })();
    
                    v1beta.FunctionDeclaration = (function() {
    
                        /**
                         * Properties of a FunctionDeclaration.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IFunctionDeclaration
                         * @property {string|null} [name] FunctionDeclaration name
                         * @property {string|null} [description] FunctionDeclaration description
                         * @property {google.ai.generativelanguage.v1beta.ISchema|null} [parameters] FunctionDeclaration parameters
                         */
    
                        /**
                         * Constructs a new FunctionDeclaration.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a FunctionDeclaration.
                         * @implements IFunctionDeclaration
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IFunctionDeclaration=} [properties] Properties to set
                         */
                        function FunctionDeclaration(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FunctionDeclaration name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @instance
                         */
                        FunctionDeclaration.prototype.name = "";
    
                        /**
                         * FunctionDeclaration description.
                         * @member {string} description
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @instance
                         */
                        FunctionDeclaration.prototype.description = "";
    
                        /**
                         * FunctionDeclaration parameters.
                         * @member {google.ai.generativelanguage.v1beta.ISchema|null|undefined} parameters
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @instance
                         */
                        FunctionDeclaration.prototype.parameters = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * FunctionDeclaration _parameters.
                         * @member {"parameters"|undefined} _parameters
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @instance
                         */
                        Object.defineProperty(FunctionDeclaration.prototype, "_parameters", {
                            get: $util.oneOfGetter($oneOfFields = ["parameters"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new FunctionDeclaration instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionDeclaration=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.FunctionDeclaration} FunctionDeclaration instance
                         */
                        FunctionDeclaration.create = function create(properties) {
                            return new FunctionDeclaration(properties);
                        };
    
                        /**
                         * Encodes the specified FunctionDeclaration message. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionDeclaration.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionDeclaration} message FunctionDeclaration message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionDeclaration.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.description);
                            if (message.parameters != null && Object.hasOwnProperty.call(message, "parameters"))
                                $root.google.ai.generativelanguage.v1beta.Schema.encode(message.parameters, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FunctionDeclaration message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionDeclaration.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionDeclaration} message FunctionDeclaration message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionDeclaration.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FunctionDeclaration message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.FunctionDeclaration} FunctionDeclaration
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionDeclaration.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.FunctionDeclaration();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.parameters = $root.google.ai.generativelanguage.v1beta.Schema.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FunctionDeclaration message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.FunctionDeclaration} FunctionDeclaration
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionDeclaration.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FunctionDeclaration message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FunctionDeclaration.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.parameters != null && message.hasOwnProperty("parameters")) {
                                properties._parameters = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.Schema.verify(message.parameters);
                                    if (error)
                                        return "parameters." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a FunctionDeclaration message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.FunctionDeclaration} FunctionDeclaration
                         */
                        FunctionDeclaration.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.FunctionDeclaration)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.FunctionDeclaration();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.parameters != null) {
                                if (typeof object.parameters !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.FunctionDeclaration.parameters: object expected");
                                message.parameters = $root.google.ai.generativelanguage.v1beta.Schema.fromObject(object.parameters);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FunctionDeclaration message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.FunctionDeclaration} message FunctionDeclaration
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FunctionDeclaration.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.description = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.parameters != null && message.hasOwnProperty("parameters")) {
                                object.parameters = $root.google.ai.generativelanguage.v1beta.Schema.toObject(message.parameters, options);
                                if (options.oneofs)
                                    object._parameters = "parameters";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this FunctionDeclaration to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FunctionDeclaration.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for FunctionDeclaration
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.FunctionDeclaration
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        FunctionDeclaration.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.FunctionDeclaration";
                        };
    
                        return FunctionDeclaration;
                    })();
    
                    v1beta.FunctionCall = (function() {
    
                        /**
                         * Properties of a FunctionCall.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IFunctionCall
                         * @property {string|null} [name] FunctionCall name
                         * @property {google.protobuf.IStruct|null} [args] FunctionCall args
                         */
    
                        /**
                         * Constructs a new FunctionCall.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a FunctionCall.
                         * @implements IFunctionCall
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCall=} [properties] Properties to set
                         */
                        function FunctionCall(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FunctionCall name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @instance
                         */
                        FunctionCall.prototype.name = "";
    
                        /**
                         * FunctionCall args.
                         * @member {google.protobuf.IStruct|null|undefined} args
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @instance
                         */
                        FunctionCall.prototype.args = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * FunctionCall _args.
                         * @member {"args"|undefined} _args
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @instance
                         */
                        Object.defineProperty(FunctionCall.prototype, "_args", {
                            get: $util.oneOfGetter($oneOfFields = ["args"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new FunctionCall instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCall=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCall} FunctionCall instance
                         */
                        FunctionCall.create = function create(properties) {
                            return new FunctionCall(properties);
                        };
    
                        /**
                         * Encodes the specified FunctionCall message. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionCall.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCall} message FunctionCall message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionCall.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.args != null && Object.hasOwnProperty.call(message, "args"))
                                $root.google.protobuf.Struct.encode(message.args, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FunctionCall message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionCall.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionCall} message FunctionCall message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionCall.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FunctionCall message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCall} FunctionCall
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionCall.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.FunctionCall();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.args = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FunctionCall message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCall} FunctionCall
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionCall.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FunctionCall message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FunctionCall.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.args != null && message.hasOwnProperty("args")) {
                                properties._args = 1;
                                {
                                    var error = $root.google.protobuf.Struct.verify(message.args);
                                    if (error)
                                        return "args." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a FunctionCall message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.FunctionCall} FunctionCall
                         */
                        FunctionCall.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.FunctionCall)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.FunctionCall();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.args != null) {
                                if (typeof object.args !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.FunctionCall.args: object expected");
                                message.args = $root.google.protobuf.Struct.fromObject(object.args);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FunctionCall message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.FunctionCall} message FunctionCall
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FunctionCall.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.args != null && message.hasOwnProperty("args")) {
                                object.args = $root.google.protobuf.Struct.toObject(message.args, options);
                                if (options.oneofs)
                                    object._args = "args";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this FunctionCall to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FunctionCall.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for FunctionCall
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.FunctionCall
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        FunctionCall.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.FunctionCall";
                        };
    
                        return FunctionCall;
                    })();
    
                    v1beta.FunctionResponse = (function() {
    
                        /**
                         * Properties of a FunctionResponse.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IFunctionResponse
                         * @property {string|null} [name] FunctionResponse name
                         * @property {google.protobuf.IStruct|null} [response] FunctionResponse response
                         */
    
                        /**
                         * Constructs a new FunctionResponse.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a FunctionResponse.
                         * @implements IFunctionResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IFunctionResponse=} [properties] Properties to set
                         */
                        function FunctionResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FunctionResponse name.
                         * @member {string} name
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @instance
                         */
                        FunctionResponse.prototype.name = "";
    
                        /**
                         * FunctionResponse response.
                         * @member {google.protobuf.IStruct|null|undefined} response
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @instance
                         */
                        FunctionResponse.prototype.response = null;
    
                        /**
                         * Creates a new FunctionResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.FunctionResponse} FunctionResponse instance
                         */
                        FunctionResponse.create = function create(properties) {
                            return new FunctionResponse(properties);
                        };
    
                        /**
                         * Encodes the specified FunctionResponse message. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionResponse} message FunctionResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.response != null && Object.hasOwnProperty.call(message, "response"))
                                $root.google.protobuf.Struct.encode(message.response, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FunctionResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.FunctionResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IFunctionResponse} message FunctionResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FunctionResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FunctionResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.FunctionResponse} FunctionResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.FunctionResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.response = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FunctionResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.FunctionResponse} FunctionResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FunctionResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FunctionResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FunctionResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.response != null && message.hasOwnProperty("response")) {
                                var error = $root.google.protobuf.Struct.verify(message.response);
                                if (error)
                                    return "response." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a FunctionResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.FunctionResponse} FunctionResponse
                         */
                        FunctionResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.FunctionResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.FunctionResponse();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.response != null) {
                                if (typeof object.response !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.FunctionResponse.response: object expected");
                                message.response = $root.google.protobuf.Struct.fromObject(object.response);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FunctionResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.FunctionResponse} message FunctionResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FunctionResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.response = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.response != null && message.hasOwnProperty("response"))
                                object.response = $root.google.protobuf.Struct.toObject(message.response, options);
                            return object;
                        };
    
                        /**
                         * Converts this FunctionResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FunctionResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for FunctionResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.FunctionResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        FunctionResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.FunctionResponse";
                        };
    
                        return FunctionResponse;
                    })();
    
                    v1beta.Schema = (function() {
    
                        /**
                         * Properties of a Schema.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ISchema
                         * @property {google.ai.generativelanguage.v1beta.Type|null} [type] Schema type
                         * @property {string|null} [format] Schema format
                         * @property {string|null} [description] Schema description
                         * @property {boolean|null} [nullable] Schema nullable
                         * @property {Array.<string>|null} ["enum"] Schema enum
                         * @property {google.ai.generativelanguage.v1beta.ISchema|null} [items] Schema items
                         * @property {Object.<string,google.ai.generativelanguage.v1beta.ISchema>|null} [properties] Schema properties
                         * @property {Array.<string>|null} [required] Schema required
                         */
    
                        /**
                         * Constructs a new Schema.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a Schema.
                         * @implements ISchema
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ISchema=} [properties] Properties to set
                         */
                        function Schema(properties) {
                            this["enum"] = [];
                            this.properties = {};
                            this.required = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Schema type.
                         * @member {google.ai.generativelanguage.v1beta.Type} type
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.type = 0;
    
                        /**
                         * Schema format.
                         * @member {string} format
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.format = "";
    
                        /**
                         * Schema description.
                         * @member {string} description
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.description = "";
    
                        /**
                         * Schema nullable.
                         * @member {boolean} nullable
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.nullable = false;
    
                        /**
                         * Schema enum.
                         * @member {Array.<string>} enum
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype["enum"] = $util.emptyArray;
    
                        /**
                         * Schema items.
                         * @member {google.ai.generativelanguage.v1beta.ISchema|null|undefined} items
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.items = null;
    
                        /**
                         * Schema properties.
                         * @member {Object.<string,google.ai.generativelanguage.v1beta.ISchema>} properties
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.properties = $util.emptyObject;
    
                        /**
                         * Schema required.
                         * @member {Array.<string>} required
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Schema.prototype.required = $util.emptyArray;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Schema _items.
                         * @member {"items"|undefined} _items
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         */
                        Object.defineProperty(Schema.prototype, "_items", {
                            get: $util.oneOfGetter($oneOfFields = ["items"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Schema instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ISchema=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.Schema} Schema instance
                         */
                        Schema.create = function create(properties) {
                            return new Schema(properties);
                        };
    
                        /**
                         * Encodes the specified Schema message. Does not implicitly {@link google.ai.generativelanguage.v1beta.Schema.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ISchema} message Schema message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Schema.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
                            if (message.format != null && Object.hasOwnProperty.call(message, "format"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.format);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.nullable != null && Object.hasOwnProperty.call(message, "nullable"))
                                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.nullable);
                            if (message["enum"] != null && message["enum"].length)
                                for (var i = 0; i < message["enum"].length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).string(message["enum"][i]);
                            if (message.items != null && Object.hasOwnProperty.call(message, "items"))
                                $root.google.ai.generativelanguage.v1beta.Schema.encode(message.items, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.properties != null && Object.hasOwnProperty.call(message, "properties"))
                                for (var keys = Object.keys(message.properties), i = 0; i < keys.length; ++i) {
                                    writer.uint32(/* id 7, wireType 2 =*/58).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                                    $root.google.ai.generativelanguage.v1beta.Schema.encode(message.properties[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                                }
                            if (message.required != null && message.required.length)
                                for (var i = 0; i < message.required.length; ++i)
                                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.required[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Schema message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.Schema.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ISchema} message Schema message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Schema.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Schema message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.Schema} Schema
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Schema.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.Schema(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.type = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.format = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.nullable = reader.bool();
                                        break;
                                    }
                                case 5: {
                                        if (!(message["enum"] && message["enum"].length))
                                            message["enum"] = [];
                                        message["enum"].push(reader.string());
                                        break;
                                    }
                                case 6: {
                                        message.items = $root.google.ai.generativelanguage.v1beta.Schema.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        if (message.properties === $util.emptyObject)
                                            message.properties = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = null;
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = $root.google.ai.generativelanguage.v1beta.Schema.decode(reader, reader.uint32());
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.properties[key] = value;
                                        break;
                                    }
                                case 8: {
                                        if (!(message.required && message.required.length))
                                            message.required = [];
                                        message.required.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Schema message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.Schema} Schema
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Schema.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Schema message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Schema.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.type != null && message.hasOwnProperty("type"))
                                switch (message.type) {
                                default:
                                    return "type: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                    break;
                                }
                            if (message.format != null && message.hasOwnProperty("format"))
                                if (!$util.isString(message.format))
                                    return "format: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.nullable != null && message.hasOwnProperty("nullable"))
                                if (typeof message.nullable !== "boolean")
                                    return "nullable: boolean expected";
                            if (message["enum"] != null && message.hasOwnProperty("enum")) {
                                if (!Array.isArray(message["enum"]))
                                    return "enum: array expected";
                                for (var i = 0; i < message["enum"].length; ++i)
                                    if (!$util.isString(message["enum"][i]))
                                        return "enum: string[] expected";
                            }
                            if (message.items != null && message.hasOwnProperty("items")) {
                                properties._items = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.Schema.verify(message.items);
                                    if (error)
                                        return "items." + error;
                                }
                            }
                            if (message.properties != null && message.hasOwnProperty("properties")) {
                                if (!$util.isObject(message.properties))
                                    return "properties: object expected";
                                var key = Object.keys(message.properties);
                                for (var i = 0; i < key.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Schema.verify(message.properties[key[i]]);
                                    if (error)
                                        return "properties." + error;
                                }
                            }
                            if (message.required != null && message.hasOwnProperty("required")) {
                                if (!Array.isArray(message.required))
                                    return "required: array expected";
                                for (var i = 0; i < message.required.length; ++i)
                                    if (!$util.isString(message.required[i]))
                                        return "required: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Schema message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.Schema} Schema
                         */
                        Schema.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.Schema)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.Schema();
                            switch (object.type) {
                            default:
                                if (typeof object.type === "number") {
                                    message.type = object.type;
                                    break;
                                }
                                break;
                            case "TYPE_UNSPECIFIED":
                            case 0:
                                message.type = 0;
                                break;
                            case "STRING":
                            case 1:
                                message.type = 1;
                                break;
                            case "NUMBER":
                            case 2:
                                message.type = 2;
                                break;
                            case "INTEGER":
                            case 3:
                                message.type = 3;
                                break;
                            case "BOOLEAN":
                            case 4:
                                message.type = 4;
                                break;
                            case "ARRAY":
                            case 5:
                                message.type = 5;
                                break;
                            case "OBJECT":
                            case 6:
                                message.type = 6;
                                break;
                            }
                            if (object.format != null)
                                message.format = String(object.format);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.nullable != null)
                                message.nullable = Boolean(object.nullable);
                            if (object["enum"]) {
                                if (!Array.isArray(object["enum"]))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Schema.enum: array expected");
                                message["enum"] = [];
                                for (var i = 0; i < object["enum"].length; ++i)
                                    message["enum"][i] = String(object["enum"][i]);
                            }
                            if (object.items != null) {
                                if (typeof object.items !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Schema.items: object expected");
                                message.items = $root.google.ai.generativelanguage.v1beta.Schema.fromObject(object.items);
                            }
                            if (object.properties) {
                                if (typeof object.properties !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Schema.properties: object expected");
                                message.properties = {};
                                for (var keys = Object.keys(object.properties), i = 0; i < keys.length; ++i) {
                                    if (typeof object.properties[keys[i]] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.Schema.properties: object expected");
                                    message.properties[keys[i]] = $root.google.ai.generativelanguage.v1beta.Schema.fromObject(object.properties[keys[i]]);
                                }
                            }
                            if (object.required) {
                                if (!Array.isArray(object.required))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Schema.required: array expected");
                                message.required = [];
                                for (var i = 0; i < object.required.length; ++i)
                                    message.required[i] = String(object.required[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Schema message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.Schema} message Schema
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Schema.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object["enum"] = [];
                                object.required = [];
                            }
                            if (options.objects || options.defaults)
                                object.properties = {};
                            if (options.defaults) {
                                object.type = options.enums === String ? "TYPE_UNSPECIFIED" : 0;
                                object.format = "";
                                object.description = "";
                                object.nullable = false;
                            }
                            if (message.type != null && message.hasOwnProperty("type"))
                                object.type = options.enums === String ? $root.google.ai.generativelanguage.v1beta.Type[message.type] === undefined ? message.type : $root.google.ai.generativelanguage.v1beta.Type[message.type] : message.type;
                            if (message.format != null && message.hasOwnProperty("format"))
                                object.format = message.format;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.nullable != null && message.hasOwnProperty("nullable"))
                                object.nullable = message.nullable;
                            if (message["enum"] && message["enum"].length) {
                                object["enum"] = [];
                                for (var j = 0; j < message["enum"].length; ++j)
                                    object["enum"][j] = message["enum"][j];
                            }
                            if (message.items != null && message.hasOwnProperty("items")) {
                                object.items = $root.google.ai.generativelanguage.v1beta.Schema.toObject(message.items, options);
                                if (options.oneofs)
                                    object._items = "items";
                            }
                            var keys2;
                            if (message.properties && (keys2 = Object.keys(message.properties)).length) {
                                object.properties = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.properties[keys2[j]] = $root.google.ai.generativelanguage.v1beta.Schema.toObject(message.properties[keys2[j]], options);
                            }
                            if (message.required && message.required.length) {
                                object.required = [];
                                for (var j = 0; j < message.required.length; ++j)
                                    object.required[j] = message.required[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Schema to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Schema.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Schema
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.Schema
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Schema.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.Schema";
                        };
    
                        return Schema;
                    })();
    
                    v1beta.GroundingPassage = (function() {
    
                        /**
                         * Properties of a GroundingPassage.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IGroundingPassage
                         * @property {string|null} [id] GroundingPassage id
                         * @property {google.ai.generativelanguage.v1beta.IContent|null} [content] GroundingPassage content
                         */
    
                        /**
                         * Constructs a new GroundingPassage.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a GroundingPassage.
                         * @implements IGroundingPassage
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassage=} [properties] Properties to set
                         */
                        function GroundingPassage(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GroundingPassage id.
                         * @member {string} id
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @instance
                         */
                        GroundingPassage.prototype.id = "";
    
                        /**
                         * GroundingPassage content.
                         * @member {google.ai.generativelanguage.v1beta.IContent|null|undefined} content
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @instance
                         */
                        GroundingPassage.prototype.content = null;
    
                        /**
                         * Creates a new GroundingPassage instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassage=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassage} GroundingPassage instance
                         */
                        GroundingPassage.create = function create(properties) {
                            return new GroundingPassage(properties);
                        };
    
                        /**
                         * Encodes the specified GroundingPassage message. Does not implicitly {@link google.ai.generativelanguage.v1beta.GroundingPassage.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassage} message GroundingPassage message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GroundingPassage.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                $root.google.ai.generativelanguage.v1beta.Content.encode(message.content, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GroundingPassage message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.GroundingPassage.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassage} message GroundingPassage message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GroundingPassage.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GroundingPassage message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassage} GroundingPassage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GroundingPassage.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.GroundingPassage();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.id = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.content = $root.google.ai.generativelanguage.v1beta.Content.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GroundingPassage message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassage} GroundingPassage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GroundingPassage.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GroundingPassage message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GroundingPassage.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            if (message.content != null && message.hasOwnProperty("content")) {
                                var error = $root.google.ai.generativelanguage.v1beta.Content.verify(message.content);
                                if (error)
                                    return "content." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GroundingPassage message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassage} GroundingPassage
                         */
                        GroundingPassage.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.GroundingPassage)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.GroundingPassage();
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.content != null) {
                                if (typeof object.content !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.GroundingPassage.content: object expected");
                                message.content = $root.google.ai.generativelanguage.v1beta.Content.fromObject(object.content);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GroundingPassage message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.GroundingPassage} message GroundingPassage
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GroundingPassage.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.id = "";
                                object.content = null;
                            }
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = $root.google.ai.generativelanguage.v1beta.Content.toObject(message.content, options);
                            return object;
                        };
    
                        /**
                         * Converts this GroundingPassage to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GroundingPassage.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GroundingPassage
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassage
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GroundingPassage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.GroundingPassage";
                        };
    
                        return GroundingPassage;
                    })();
    
                    v1beta.GroundingPassages = (function() {
    
                        /**
                         * Properties of a GroundingPassages.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IGroundingPassages
                         * @property {Array.<google.ai.generativelanguage.v1beta.IGroundingPassage>|null} [passages] GroundingPassages passages
                         */
    
                        /**
                         * Constructs a new GroundingPassages.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a GroundingPassages.
                         * @implements IGroundingPassages
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassages=} [properties] Properties to set
                         */
                        function GroundingPassages(properties) {
                            this.passages = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GroundingPassages passages.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IGroundingPassage>} passages
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @instance
                         */
                        GroundingPassages.prototype.passages = $util.emptyArray;
    
                        /**
                         * Creates a new GroundingPassages instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassages=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassages} GroundingPassages instance
                         */
                        GroundingPassages.create = function create(properties) {
                            return new GroundingPassages(properties);
                        };
    
                        /**
                         * Encodes the specified GroundingPassages message. Does not implicitly {@link google.ai.generativelanguage.v1beta.GroundingPassages.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassages} message GroundingPassages message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GroundingPassages.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.passages != null && message.passages.length)
                                for (var i = 0; i < message.passages.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.GroundingPassage.encode(message.passages[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GroundingPassages message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.GroundingPassages.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGroundingPassages} message GroundingPassages message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GroundingPassages.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GroundingPassages message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassages} GroundingPassages
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GroundingPassages.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.GroundingPassages();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.passages && message.passages.length))
                                            message.passages = [];
                                        message.passages.push($root.google.ai.generativelanguage.v1beta.GroundingPassage.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GroundingPassages message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassages} GroundingPassages
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GroundingPassages.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GroundingPassages message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GroundingPassages.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.passages != null && message.hasOwnProperty("passages")) {
                                if (!Array.isArray(message.passages))
                                    return "passages: array expected";
                                for (var i = 0; i < message.passages.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.GroundingPassage.verify(message.passages[i]);
                                    if (error)
                                        return "passages." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GroundingPassages message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.GroundingPassages} GroundingPassages
                         */
                        GroundingPassages.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.GroundingPassages)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.GroundingPassages();
                            if (object.passages) {
                                if (!Array.isArray(object.passages))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.GroundingPassages.passages: array expected");
                                message.passages = [];
                                for (var i = 0; i < object.passages.length; ++i) {
                                    if (typeof object.passages[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.GroundingPassages.passages: object expected");
                                    message.passages[i] = $root.google.ai.generativelanguage.v1beta.GroundingPassage.fromObject(object.passages[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GroundingPassages message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.GroundingPassages} message GroundingPassages
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GroundingPassages.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.passages = [];
                            if (message.passages && message.passages.length) {
                                object.passages = [];
                                for (var j = 0; j < message.passages.length; ++j)
                                    object.passages[j] = $root.google.ai.generativelanguage.v1beta.GroundingPassage.toObject(message.passages[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this GroundingPassages to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GroundingPassages.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GroundingPassages
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.GroundingPassages
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GroundingPassages.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.GroundingPassages";
                        };
    
                        return GroundingPassages;
                    })();
    
                    v1beta.CitationMetadata = (function() {
    
                        /**
                         * Properties of a CitationMetadata.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ICitationMetadata
                         * @property {Array.<google.ai.generativelanguage.v1beta.ICitationSource>|null} [citationSources] CitationMetadata citationSources
                         */
    
                        /**
                         * Constructs a new CitationMetadata.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CitationMetadata.
                         * @implements ICitationMetadata
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ICitationMetadata=} [properties] Properties to set
                         */
                        function CitationMetadata(properties) {
                            this.citationSources = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CitationMetadata citationSources.
                         * @member {Array.<google.ai.generativelanguage.v1beta.ICitationSource>} citationSources
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @instance
                         */
                        CitationMetadata.prototype.citationSources = $util.emptyArray;
    
                        /**
                         * Creates a new CitationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICitationMetadata=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.CitationMetadata} CitationMetadata instance
                         */
                        CitationMetadata.create = function create(properties) {
                            return new CitationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CitationMetadata message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CitationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICitationMetadata} message CitationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.citationSources != null && message.citationSources.length)
                                for (var i = 0; i < message.citationSources.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.CitationSource.encode(message.citationSources[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CitationMetadata message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CitationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICitationMetadata} message CitationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CitationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.CitationMetadata} CitationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CitationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.citationSources && message.citationSources.length))
                                            message.citationSources = [];
                                        message.citationSources.push($root.google.ai.generativelanguage.v1beta.CitationSource.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CitationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.CitationMetadata} CitationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CitationMetadata message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CitationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.citationSources != null && message.hasOwnProperty("citationSources")) {
                                if (!Array.isArray(message.citationSources))
                                    return "citationSources: array expected";
                                for (var i = 0; i < message.citationSources.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.CitationSource.verify(message.citationSources[i]);
                                    if (error)
                                        return "citationSources." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CitationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.CitationMetadata} CitationMetadata
                         */
                        CitationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.CitationMetadata)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.CitationMetadata();
                            if (object.citationSources) {
                                if (!Array.isArray(object.citationSources))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.CitationMetadata.citationSources: array expected");
                                message.citationSources = [];
                                for (var i = 0; i < object.citationSources.length; ++i) {
                                    if (typeof object.citationSources[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.CitationMetadata.citationSources: object expected");
                                    message.citationSources[i] = $root.google.ai.generativelanguage.v1beta.CitationSource.fromObject(object.citationSources[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CitationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.CitationMetadata} message CitationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CitationMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.citationSources = [];
                            if (message.citationSources && message.citationSources.length) {
                                object.citationSources = [];
                                for (var j = 0; j < message.citationSources.length; ++j)
                                    object.citationSources[j] = $root.google.ai.generativelanguage.v1beta.CitationSource.toObject(message.citationSources[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CitationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CitationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CitationMetadata
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.CitationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CitationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CitationMetadata";
                        };
    
                        return CitationMetadata;
                    })();
    
                    v1beta.CitationSource = (function() {
    
                        /**
                         * Properties of a CitationSource.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface ICitationSource
                         * @property {number|null} [startIndex] CitationSource startIndex
                         * @property {number|null} [endIndex] CitationSource endIndex
                         * @property {string|null} [uri] CitationSource uri
                         * @property {string|null} [license] CitationSource license
                         */
    
                        /**
                         * Constructs a new CitationSource.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a CitationSource.
                         * @implements ICitationSource
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.ICitationSource=} [properties] Properties to set
                         */
                        function CitationSource(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CitationSource startIndex.
                         * @member {number|null|undefined} startIndex
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.startIndex = null;
    
                        /**
                         * CitationSource endIndex.
                         * @member {number|null|undefined} endIndex
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.endIndex = null;
    
                        /**
                         * CitationSource uri.
                         * @member {string|null|undefined} uri
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.uri = null;
    
                        /**
                         * CitationSource license.
                         * @member {string|null|undefined} license
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        CitationSource.prototype.license = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * CitationSource _startIndex.
                         * @member {"startIndex"|undefined} _startIndex
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_startIndex", {
                            get: $util.oneOfGetter($oneOfFields = ["startIndex"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CitationSource _endIndex.
                         * @member {"endIndex"|undefined} _endIndex
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_endIndex", {
                            get: $util.oneOfGetter($oneOfFields = ["endIndex"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CitationSource _uri.
                         * @member {"uri"|undefined} _uri
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_uri", {
                            get: $util.oneOfGetter($oneOfFields = ["uri"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * CitationSource _license.
                         * @member {"license"|undefined} _license
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         */
                        Object.defineProperty(CitationSource.prototype, "_license", {
                            get: $util.oneOfGetter($oneOfFields = ["license"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new CitationSource instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICitationSource=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.CitationSource} CitationSource instance
                         */
                        CitationSource.create = function create(properties) {
                            return new CitationSource(properties);
                        };
    
                        /**
                         * Encodes the specified CitationSource message. Does not implicitly {@link google.ai.generativelanguage.v1beta.CitationSource.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICitationSource} message CitationSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationSource.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.startIndex != null && Object.hasOwnProperty.call(message, "startIndex"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.startIndex);
                            if (message.endIndex != null && Object.hasOwnProperty.call(message, "endIndex"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.endIndex);
                            if (message.uri != null && Object.hasOwnProperty.call(message, "uri"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.uri);
                            if (message.license != null && Object.hasOwnProperty.call(message, "license"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.license);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CitationSource message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.CitationSource.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.ICitationSource} message CitationSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CitationSource.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CitationSource message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.CitationSource} CitationSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationSource.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.CitationSource();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.startIndex = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.endIndex = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.uri = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.license = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CitationSource message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.CitationSource} CitationSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CitationSource.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CitationSource message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CitationSource.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.startIndex != null && message.hasOwnProperty("startIndex")) {
                                properties._startIndex = 1;
                                if (!$util.isInteger(message.startIndex))
                                    return "startIndex: integer expected";
                            }
                            if (message.endIndex != null && message.hasOwnProperty("endIndex")) {
                                properties._endIndex = 1;
                                if (!$util.isInteger(message.endIndex))
                                    return "endIndex: integer expected";
                            }
                            if (message.uri != null && message.hasOwnProperty("uri")) {
                                properties._uri = 1;
                                if (!$util.isString(message.uri))
                                    return "uri: string expected";
                            }
                            if (message.license != null && message.hasOwnProperty("license")) {
                                properties._license = 1;
                                if (!$util.isString(message.license))
                                    return "license: string expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CitationSource message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.CitationSource} CitationSource
                         */
                        CitationSource.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.CitationSource)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.CitationSource();
                            if (object.startIndex != null)
                                message.startIndex = object.startIndex | 0;
                            if (object.endIndex != null)
                                message.endIndex = object.endIndex | 0;
                            if (object.uri != null)
                                message.uri = String(object.uri);
                            if (object.license != null)
                                message.license = String(object.license);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CitationSource message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.CitationSource} message CitationSource
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CitationSource.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.startIndex != null && message.hasOwnProperty("startIndex")) {
                                object.startIndex = message.startIndex;
                                if (options.oneofs)
                                    object._startIndex = "startIndex";
                            }
                            if (message.endIndex != null && message.hasOwnProperty("endIndex")) {
                                object.endIndex = message.endIndex;
                                if (options.oneofs)
                                    object._endIndex = "endIndex";
                            }
                            if (message.uri != null && message.hasOwnProperty("uri")) {
                                object.uri = message.uri;
                                if (options.oneofs)
                                    object._uri = "uri";
                            }
                            if (message.license != null && message.hasOwnProperty("license")) {
                                object.license = message.license;
                                if (options.oneofs)
                                    object._license = "license";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CitationSource to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CitationSource.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CitationSource
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.CitationSource
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CitationSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.CitationSource";
                        };
    
                        return CitationSource;
                    })();
    
                    v1beta.DiscussService = (function() {
    
                        /**
                         * Constructs a new DiscussService service.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a DiscussService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function DiscussService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (DiscussService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = DiscussService;
    
                        /**
                         * Creates new DiscussService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {DiscussService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        DiscussService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.DiscussService|generateMessage}.
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @typedef GenerateMessageCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1beta.GenerateMessageResponse} [response] GenerateMessageResponse
                         */
    
                        /**
                         * Calls GenerateMessage.
                         * @function generateMessage
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageRequest} request GenerateMessageRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.DiscussService.GenerateMessageCallback} callback Node-style callback called with the error, if any, and GenerateMessageResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(DiscussService.prototype.generateMessage = function generateMessage(request, callback) {
                            return this.rpcCall(generateMessage, $root.google.ai.generativelanguage.v1beta.GenerateMessageRequest, $root.google.ai.generativelanguage.v1beta.GenerateMessageResponse, request, callback);
                        }, "name", { value: "GenerateMessage" });
    
                        /**
                         * Calls GenerateMessage.
                         * @function generateMessage
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageRequest} request GenerateMessageRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1beta.GenerateMessageResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.ai.generativelanguage.v1beta.DiscussService|countMessageTokens}.
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @typedef CountMessageTokensCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.ai.generativelanguage.v1beta.CountMessageTokensResponse} [response] CountMessageTokensResponse
                         */
    
                        /**
                         * Calls CountMessageTokens.
                         * @function countMessageTokens
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.ICountMessageTokensRequest} request CountMessageTokensRequest message or plain object
                         * @param {google.ai.generativelanguage.v1beta.DiscussService.CountMessageTokensCallback} callback Node-style callback called with the error, if any, and CountMessageTokensResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(DiscussService.prototype.countMessageTokens = function countMessageTokens(request, callback) {
                            return this.rpcCall(countMessageTokens, $root.google.ai.generativelanguage.v1beta.CountMessageTokensRequest, $root.google.ai.generativelanguage.v1beta.CountMessageTokensResponse, request, callback);
                        }, "name", { value: "CountMessageTokens" });
    
                        /**
                         * Calls CountMessageTokens.
                         * @function countMessageTokens
                         * @memberof google.ai.generativelanguage.v1beta.DiscussService
                         * @instance
                         * @param {google.ai.generativelanguage.v1beta.ICountMessageTokensRequest} request CountMessageTokensRequest message or plain object
                         * @returns {Promise<google.ai.generativelanguage.v1beta.CountMessageTokensResponse>} Promise
                         * @variation 2
                         */
    
                        return DiscussService;
                    })();
    
                    v1beta.GenerateMessageRequest = (function() {
    
                        /**
                         * Properties of a GenerateMessageRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IGenerateMessageRequest
                         * @property {string|null} [model] GenerateMessageRequest model
                         * @property {google.ai.generativelanguage.v1beta.IMessagePrompt|null} [prompt] GenerateMessageRequest prompt
                         * @property {number|null} [temperature] GenerateMessageRequest temperature
                         * @property {number|null} [candidateCount] GenerateMessageRequest candidateCount
                         * @property {number|null} [topP] GenerateMessageRequest topP
                         * @property {number|null} [topK] GenerateMessageRequest topK
                         */
    
                        /**
                         * Constructs a new GenerateMessageRequest.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a GenerateMessageRequest.
                         * @implements IGenerateMessageRequest
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageRequest=} [properties] Properties to set
                         */
                        function GenerateMessageRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GenerateMessageRequest model.
                         * @member {string} model
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        GenerateMessageRequest.prototype.model = "";
    
                        /**
                         * GenerateMessageRequest prompt.
                         * @member {google.ai.generativelanguage.v1beta.IMessagePrompt|null|undefined} prompt
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        GenerateMessageRequest.prototype.prompt = null;
    
                        /**
                         * GenerateMessageRequest temperature.
                         * @member {number|null|undefined} temperature
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        GenerateMessageRequest.prototype.temperature = null;
    
                        /**
                         * GenerateMessageRequest candidateCount.
                         * @member {number|null|undefined} candidateCount
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        GenerateMessageRequest.prototype.candidateCount = null;
    
                        /**
                         * GenerateMessageRequest topP.
                         * @member {number|null|undefined} topP
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        GenerateMessageRequest.prototype.topP = null;
    
                        /**
                         * GenerateMessageRequest topK.
                         * @member {number|null|undefined} topK
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        GenerateMessageRequest.prototype.topK = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * GenerateMessageRequest _temperature.
                         * @member {"temperature"|undefined} _temperature
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        Object.defineProperty(GenerateMessageRequest.prototype, "_temperature", {
                            get: $util.oneOfGetter($oneOfFields = ["temperature"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerateMessageRequest _candidateCount.
                         * @member {"candidateCount"|undefined} _candidateCount
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        Object.defineProperty(GenerateMessageRequest.prototype, "_candidateCount", {
                            get: $util.oneOfGetter($oneOfFields = ["candidateCount"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerateMessageRequest _topP.
                         * @member {"topP"|undefined} _topP
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        Object.defineProperty(GenerateMessageRequest.prototype, "_topP", {
                            get: $util.oneOfGetter($oneOfFields = ["topP"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * GenerateMessageRequest _topK.
                         * @member {"topK"|undefined} _topK
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         */
                        Object.defineProperty(GenerateMessageRequest.prototype, "_topK", {
                            get: $util.oneOfGetter($oneOfFields = ["topK"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new GenerateMessageRequest instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageRequest=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageRequest} GenerateMessageRequest instance
                         */
                        GenerateMessageRequest.create = function create(properties) {
                            return new GenerateMessageRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GenerateMessageRequest message. Does not implicitly {@link google.ai.generativelanguage.v1beta.GenerateMessageRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageRequest} message GenerateMessageRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateMessageRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.model);
                            if (message.prompt != null && Object.hasOwnProperty.call(message, "prompt"))
                                $root.google.ai.generativelanguage.v1beta.MessagePrompt.encode(message.prompt, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.temperature != null && Object.hasOwnProperty.call(message, "temperature"))
                                writer.uint32(/* id 3, wireType 5 =*/29).float(message.temperature);
                            if (message.candidateCount != null && Object.hasOwnProperty.call(message, "candidateCount"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.candidateCount);
                            if (message.topP != null && Object.hasOwnProperty.call(message, "topP"))
                                writer.uint32(/* id 5, wireType 5 =*/45).float(message.topP);
                            if (message.topK != null && Object.hasOwnProperty.call(message, "topK"))
                                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.topK);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GenerateMessageRequest message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.GenerateMessageRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageRequest} message GenerateMessageRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateMessageRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GenerateMessageRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageRequest} GenerateMessageRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateMessageRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.GenerateMessageRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.prompt = $root.google.ai.generativelanguage.v1beta.MessagePrompt.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.temperature = reader.float();
                                        break;
                                    }
                                case 4: {
                                        message.candidateCount = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.topP = reader.float();
                                        break;
                                    }
                                case 6: {
                                        message.topK = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GenerateMessageRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageRequest} GenerateMessageRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateMessageRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GenerateMessageRequest message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GenerateMessageRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.prompt != null && message.hasOwnProperty("prompt")) {
                                var error = $root.google.ai.generativelanguage.v1beta.MessagePrompt.verify(message.prompt);
                                if (error)
                                    return "prompt." + error;
                            }
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                properties._temperature = 1;
                                if (typeof message.temperature !== "number")
                                    return "temperature: number expected";
                            }
                            if (message.candidateCount != null && message.hasOwnProperty("candidateCount")) {
                                properties._candidateCount = 1;
                                if (!$util.isInteger(message.candidateCount))
                                    return "candidateCount: integer expected";
                            }
                            if (message.topP != null && message.hasOwnProperty("topP")) {
                                properties._topP = 1;
                                if (typeof message.topP !== "number")
                                    return "topP: number expected";
                            }
                            if (message.topK != null && message.hasOwnProperty("topK")) {
                                properties._topK = 1;
                                if (!$util.isInteger(message.topK))
                                    return "topK: integer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GenerateMessageRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageRequest} GenerateMessageRequest
                         */
                        GenerateMessageRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.GenerateMessageRequest)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.GenerateMessageRequest();
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.prompt != null) {
                                if (typeof object.prompt !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageRequest.prompt: object expected");
                                message.prompt = $root.google.ai.generativelanguage.v1beta.MessagePrompt.fromObject(object.prompt);
                            }
                            if (object.temperature != null)
                                message.temperature = Number(object.temperature);
                            if (object.candidateCount != null)
                                message.candidateCount = object.candidateCount | 0;
                            if (object.topP != null)
                                message.topP = Number(object.topP);
                            if (object.topK != null)
                                message.topK = object.topK | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GenerateMessageRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.GenerateMessageRequest} message GenerateMessageRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GenerateMessageRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.model = "";
                                object.prompt = null;
                            }
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.prompt != null && message.hasOwnProperty("prompt"))
                                object.prompt = $root.google.ai.generativelanguage.v1beta.MessagePrompt.toObject(message.prompt, options);
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                object.temperature = options.json && !isFinite(message.temperature) ? String(message.temperature) : message.temperature;
                                if (options.oneofs)
                                    object._temperature = "temperature";
                            }
                            if (message.candidateCount != null && message.hasOwnProperty("candidateCount")) {
                                object.candidateCount = message.candidateCount;
                                if (options.oneofs)
                                    object._candidateCount = "candidateCount";
                            }
                            if (message.topP != null && message.hasOwnProperty("topP")) {
                                object.topP = options.json && !isFinite(message.topP) ? String(message.topP) : message.topP;
                                if (options.oneofs)
                                    object._topP = "topP";
                            }
                            if (message.topK != null && message.hasOwnProperty("topK")) {
                                object.topK = message.topK;
                                if (options.oneofs)
                                    object._topK = "topK";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this GenerateMessageRequest to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GenerateMessageRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GenerateMessageRequest
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GenerateMessageRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.GenerateMessageRequest";
                        };
    
                        return GenerateMessageRequest;
                    })();
    
                    v1beta.GenerateMessageResponse = (function() {
    
                        /**
                         * Properties of a GenerateMessageResponse.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IGenerateMessageResponse
                         * @property {Array.<google.ai.generativelanguage.v1beta.IMessage>|null} [candidates] GenerateMessageResponse candidates
                         * @property {Array.<google.ai.generativelanguage.v1beta.IMessage>|null} [messages] GenerateMessageResponse messages
                         * @property {Array.<google.ai.generativelanguage.v1beta.IContentFilter>|null} [filters] GenerateMessageResponse filters
                         */
    
                        /**
                         * Constructs a new GenerateMessageResponse.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a GenerateMessageResponse.
                         * @implements IGenerateMessageResponse
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageResponse=} [properties] Properties to set
                         */
                        function GenerateMessageResponse(properties) {
                            this.candidates = [];
                            this.messages = [];
                            this.filters = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GenerateMessageResponse candidates.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IMessage>} candidates
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @instance
                         */
                        GenerateMessageResponse.prototype.candidates = $util.emptyArray;
    
                        /**
                         * GenerateMessageResponse messages.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IMessage>} messages
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @instance
                         */
                        GenerateMessageResponse.prototype.messages = $util.emptyArray;
    
                        /**
                         * GenerateMessageResponse filters.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IContentFilter>} filters
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @instance
                         */
                        GenerateMessageResponse.prototype.filters = $util.emptyArray;
    
                        /**
                         * Creates a new GenerateMessageResponse instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageResponse=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageResponse} GenerateMessageResponse instance
                         */
                        GenerateMessageResponse.create = function create(properties) {
                            return new GenerateMessageResponse(properties);
                        };
    
                        /**
                         * Encodes the specified GenerateMessageResponse message. Does not implicitly {@link google.ai.generativelanguage.v1beta.GenerateMessageResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageResponse} message GenerateMessageResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateMessageResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.candidates != null && message.candidates.length)
                                for (var i = 0; i < message.candidates.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Message.encode(message.candidates[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.messages != null && message.messages.length)
                                for (var i = 0; i < message.messages.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Message.encode(message.messages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.filters != null && message.filters.length)
                                for (var i = 0; i < message.filters.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.ContentFilter.encode(message.filters[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GenerateMessageResponse message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.GenerateMessageResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IGenerateMessageResponse} message GenerateMessageResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GenerateMessageResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GenerateMessageResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageResponse} GenerateMessageResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateMessageResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.GenerateMessageResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.candidates && message.candidates.length))
                                            message.candidates = [];
                                        message.candidates.push($root.google.ai.generativelanguage.v1beta.Message.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        if (!(message.messages && message.messages.length))
                                            message.messages = [];
                                        message.messages.push($root.google.ai.generativelanguage.v1beta.Message.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        if (!(message.filters && message.filters.length))
                                            message.filters = [];
                                        message.filters.push($root.google.ai.generativelanguage.v1beta.ContentFilter.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GenerateMessageResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageResponse} GenerateMessageResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GenerateMessageResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GenerateMessageResponse message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GenerateMessageResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.candidates != null && message.hasOwnProperty("candidates")) {
                                if (!Array.isArray(message.candidates))
                                    return "candidates: array expected";
                                for (var i = 0; i < message.candidates.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Message.verify(message.candidates[i]);
                                    if (error)
                                        return "candidates." + error;
                                }
                            }
                            if (message.messages != null && message.hasOwnProperty("messages")) {
                                if (!Array.isArray(message.messages))
                                    return "messages: array expected";
                                for (var i = 0; i < message.messages.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Message.verify(message.messages[i]);
                                    if (error)
                                        return "messages." + error;
                                }
                            }
                            if (message.filters != null && message.hasOwnProperty("filters")) {
                                if (!Array.isArray(message.filters))
                                    return "filters: array expected";
                                for (var i = 0; i < message.filters.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.ContentFilter.verify(message.filters[i]);
                                    if (error)
                                        return "filters." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GenerateMessageResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.GenerateMessageResponse} GenerateMessageResponse
                         */
                        GenerateMessageResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.GenerateMessageResponse)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.GenerateMessageResponse();
                            if (object.candidates) {
                                if (!Array.isArray(object.candidates))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageResponse.candidates: array expected");
                                message.candidates = [];
                                for (var i = 0; i < object.candidates.length; ++i) {
                                    if (typeof object.candidates[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageResponse.candidates: object expected");
                                    message.candidates[i] = $root.google.ai.generativelanguage.v1beta.Message.fromObject(object.candidates[i]);
                                }
                            }
                            if (object.messages) {
                                if (!Array.isArray(object.messages))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageResponse.messages: array expected");
                                message.messages = [];
                                for (var i = 0; i < object.messages.length; ++i) {
                                    if (typeof object.messages[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageResponse.messages: object expected");
                                    message.messages[i] = $root.google.ai.generativelanguage.v1beta.Message.fromObject(object.messages[i]);
                                }
                            }
                            if (object.filters) {
                                if (!Array.isArray(object.filters))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageResponse.filters: array expected");
                                message.filters = [];
                                for (var i = 0; i < object.filters.length; ++i) {
                                    if (typeof object.filters[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.GenerateMessageResponse.filters: object expected");
                                    message.filters[i] = $root.google.ai.generativelanguage.v1beta.ContentFilter.fromObject(object.filters[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GenerateMessageResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.GenerateMessageResponse} message GenerateMessageResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GenerateMessageResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.candidates = [];
                                object.messages = [];
                                object.filters = [];
                            }
                            if (message.candidates && message.candidates.length) {
                                object.candidates = [];
                                for (var j = 0; j < message.candidates.length; ++j)
                                    object.candidates[j] = $root.google.ai.generativelanguage.v1beta.Message.toObject(message.candidates[j], options);
                            }
                            if (message.messages && message.messages.length) {
                                object.messages = [];
                                for (var j = 0; j < message.messages.length; ++j)
                                    object.messages[j] = $root.google.ai.generativelanguage.v1beta.Message.toObject(message.messages[j], options);
                            }
                            if (message.filters && message.filters.length) {
                                object.filters = [];
                                for (var j = 0; j < message.filters.length; ++j)
                                    object.filters[j] = $root.google.ai.generativelanguage.v1beta.ContentFilter.toObject(message.filters[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this GenerateMessageResponse to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GenerateMessageResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GenerateMessageResponse
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.GenerateMessageResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GenerateMessageResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.GenerateMessageResponse";
                        };
    
                        return GenerateMessageResponse;
                    })();
    
                    v1beta.Message = (function() {
    
                        /**
                         * Properties of a Message.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IMessage
                         * @property {string|null} [author] Message author
                         * @property {string|null} [content] Message content
                         * @property {google.ai.generativelanguage.v1beta.ICitationMetadata|null} [citationMetadata] Message citationMetadata
                         */
    
                        /**
                         * Constructs a new Message.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a Message.
                         * @implements IMessage
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IMessage=} [properties] Properties to set
                         */
                        function Message(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Message author.
                         * @member {string} author
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @instance
                         */
                        Message.prototype.author = "";
    
                        /**
                         * Message content.
                         * @member {string} content
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @instance
                         */
                        Message.prototype.content = "";
    
                        /**
                         * Message citationMetadata.
                         * @member {google.ai.generativelanguage.v1beta.ICitationMetadata|null|undefined} citationMetadata
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @instance
                         */
                        Message.prototype.citationMetadata = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Message _citationMetadata.
                         * @member {"citationMetadata"|undefined} _citationMetadata
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @instance
                         */
                        Object.defineProperty(Message.prototype, "_citationMetadata", {
                            get: $util.oneOfGetter($oneOfFields = ["citationMetadata"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Message instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IMessage=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.Message} Message instance
                         */
                        Message.create = function create(properties) {
                            return new Message(properties);
                        };
    
                        /**
                         * Encodes the specified Message message. Does not implicitly {@link google.ai.generativelanguage.v1beta.Message.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IMessage} message Message message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Message.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.author != null && Object.hasOwnProperty.call(message, "author"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.author);
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.content);
                            if (message.citationMetadata != null && Object.hasOwnProperty.call(message, "citationMetadata"))
                                $root.google.ai.generativelanguage.v1beta.CitationMetadata.encode(message.citationMetadata, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Message message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.Message.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IMessage} message Message message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Message.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Message message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.Message} Message
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Message.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.Message();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.author = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.content = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.citationMetadata = $root.google.ai.generativelanguage.v1beta.CitationMetadata.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Message message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.Message} Message
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Message.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Message message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Message.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.author != null && message.hasOwnProperty("author"))
                                if (!$util.isString(message.author))
                                    return "author: string expected";
                            if (message.content != null && message.hasOwnProperty("content"))
                                if (!$util.isString(message.content))
                                    return "content: string expected";
                            if (message.citationMetadata != null && message.hasOwnProperty("citationMetadata")) {
                                properties._citationMetadata = 1;
                                {
                                    var error = $root.google.ai.generativelanguage.v1beta.CitationMetadata.verify(message.citationMetadata);
                                    if (error)
                                        return "citationMetadata." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Message message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.Message} Message
                         */
                        Message.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.Message)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.Message();
                            if (object.author != null)
                                message.author = String(object.author);
                            if (object.content != null)
                                message.content = String(object.content);
                            if (object.citationMetadata != null) {
                                if (typeof object.citationMetadata !== "object")
                                    throw TypeError(".google.ai.generativelanguage.v1beta.Message.citationMetadata: object expected");
                                message.citationMetadata = $root.google.ai.generativelanguage.v1beta.CitationMetadata.fromObject(object.citationMetadata);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Message message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.Message} message Message
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Message.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.author = "";
                                object.content = "";
                            }
                            if (message.author != null && message.hasOwnProperty("author"))
                                object.author = message.author;
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = message.content;
                            if (message.citationMetadata != null && message.hasOwnProperty("citationMetadata")) {
                                object.citationMetadata = $root.google.ai.generativelanguage.v1beta.CitationMetadata.toObject(message.citationMetadata, options);
                                if (options.oneofs)
                                    object._citationMetadata = "citationMetadata";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Message to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Message.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Message
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.Message
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Message.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.ai.generativelanguage.v1beta.Message";
                        };
    
                        return Message;
                    })();
    
                    v1beta.MessagePrompt = (function() {
    
                        /**
                         * Properties of a MessagePrompt.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @interface IMessagePrompt
                         * @property {string|null} [context] MessagePrompt context
                         * @property {Array.<google.ai.generativelanguage.v1beta.IExample>|null} [examples] MessagePrompt examples
                         * @property {Array.<google.ai.generativelanguage.v1beta.IMessage>|null} [messages] MessagePrompt messages
                         */
    
                        /**
                         * Constructs a new MessagePrompt.
                         * @memberof google.ai.generativelanguage.v1beta
                         * @classdesc Represents a MessagePrompt.
                         * @implements IMessagePrompt
                         * @constructor
                         * @param {google.ai.generativelanguage.v1beta.IMessagePrompt=} [properties] Properties to set
                         */
                        function MessagePrompt(properties) {
                            this.examples = [];
                            this.messages = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * MessagePrompt context.
                         * @member {string} context
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @instance
                         */
                        MessagePrompt.prototype.context = "";
    
                        /**
                         * MessagePrompt examples.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IExample>} examples
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @instance
                         */
                        MessagePrompt.prototype.examples = $util.emptyArray;
    
                        /**
                         * MessagePrompt messages.
                         * @member {Array.<google.ai.generativelanguage.v1beta.IMessage>} messages
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @instance
                         */
                        MessagePrompt.prototype.messages = $util.emptyArray;
    
                        /**
                         * Creates a new MessagePrompt instance using the specified properties.
                         * @function create
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IMessagePrompt=} [properties] Properties to set
                         * @returns {google.ai.generativelanguage.v1beta.MessagePrompt} MessagePrompt instance
                         */
                        MessagePrompt.create = function create(properties) {
                            return new MessagePrompt(properties);
                        };
    
                        /**
                         * Encodes the specified MessagePrompt message. Does not implicitly {@link google.ai.generativelanguage.v1beta.MessagePrompt.verify|verify} messages.
                         * @function encode
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IMessagePrompt} message MessagePrompt message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MessagePrompt.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.context != null && Object.hasOwnProperty.call(message, "context"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.context);
                            if (message.examples != null && message.examples.length)
                                for (var i = 0; i < message.examples.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Example.encode(message.examples[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.messages != null && message.messages.length)
                                for (var i = 0; i < message.messages.length; ++i)
                                    $root.google.ai.generativelanguage.v1beta.Message.encode(message.messages[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified MessagePrompt message, length delimited. Does not implicitly {@link google.ai.generativelanguage.v1beta.MessagePrompt.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.IMessagePrompt} message MessagePrompt message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MessagePrompt.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a MessagePrompt message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.ai.generativelanguage.v1beta.MessagePrompt} MessagePrompt
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MessagePrompt.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.ai.generativelanguage.v1beta.MessagePrompt();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.context = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.examples && message.examples.length))
                                            message.examples = [];
                                        message.examples.push($root.google.ai.generativelanguage.v1beta.Example.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        if (!(message.messages && message.messages.length))
                                            message.messages = [];
                                        message.messages.push($root.google.ai.generativelanguage.v1beta.Message.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a MessagePrompt message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.ai.generativelanguage.v1beta.MessagePrompt} MessagePrompt
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MessagePrompt.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a MessagePrompt message.
                         * @function verify
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        MessagePrompt.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.context != null && message.hasOwnProperty("context"))
                                if (!$util.isString(message.context))
                                    return "context: string expected";
                            if (message.examples != null && message.hasOwnProperty("examples")) {
                                if (!Array.isArray(message.examples))
                                    return "examples: array expected";
                                for (var i = 0; i < message.examples.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Example.verify(message.examples[i]);
                                    if (error)
                                        return "examples." + error;
                                }
                            }
                            if (message.messages != null && message.hasOwnProperty("messages")) {
                                if (!Array.isArray(message.messages))
                                    return "messages: array expected";
                                for (var i = 0; i < message.messages.length; ++i) {
                                    var error = $root.google.ai.generativelanguage.v1beta.Message.verify(message.messages[i]);
                                    if (error)
                                        return "messages." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a MessagePrompt message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.ai.generativelanguage.v1beta.MessagePrompt} MessagePrompt
                         */
                        MessagePrompt.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.ai.generativelanguage.v1beta.MessagePrompt)
                                return object;
                            var message = new $root.google.ai.generativelanguage.v1beta.MessagePrompt();
                            if (object.context != null)
                                message.context = String(object.context);
                            if (object.examples) {
                                if (!Array.isArray(object.examples))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.MessagePrompt.examples: array expected");
                                message.examples = [];
                                for (var i = 0; i < object.examples.length; ++i) {
                                    if (typeof object.examples[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.MessagePrompt.examples: object expected");
                                    message.examples[i] = $root.google.ai.generativelanguage.v1beta.Example.fromObject(object.examples[i]);
                                }
                            }
                            if (object.messages) {
                                if (!Array.isArray(object.messages))
                                    throw TypeError(".google.ai.generativelanguage.v1beta.MessagePrompt.messages: array expected");
                                message.messages = [];
                                for (var i = 0; i < object.messages.length; ++i) {
                                    if (typeof object.messages[i] !== "object")
                                        throw TypeError(".google.ai.generativelanguage.v1beta.MessagePrompt.messages: object expected");
                                    message.messages[i] = $root.google.ai.generativelanguage.v1beta.Message.fromObject(object.messages[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a MessagePrompt message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {google.ai.generativelanguage.v1beta.MessagePrompt} message MessagePrompt
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        MessagePrompt.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.examples = [];
                                object.messages = [];
                            }
                            if (options.defaults)
                                object.context = "";
                            if (message.context != null && message.hasOwnProperty("context"))
                                object.context = message.context;
                            if (message.examples && message.examples.length) {
                                object.examples = [];
                                for (var j = 0; j < message.examples.length; ++j)
                                    object.examples[j] = $root.google.ai.generativelanguage.v1beta.Example.toObject(message.examples[j], options);
                            }
                            if (message.messages && message.messages.length) {
                                object.messages = [];
                                for (var j = 0; j < message.messages.length; ++j)
                                    object.messages[j] = $root.google.ai.generativelanguage.v1beta.Message.toObject(message.messages[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this MessagePrompt to JSON.
                         * @function toJSON
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        MessagePrompt.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for MessagePrompt
                         * @function getTypeUrl
                         * @memberof google.ai.generativelanguage.v1beta.MessagePrompt
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
             