import { RoleType } from "../../src/api/";

export const history: {
    role: string;
    role_type: RoleType;
    content: string;
    metadata?: { [key: string]: any };
}[] = [
    {
        role: "user",
        role_type: "user",
        content: "Hi there, I'm looking for a new pair of shoes. I'm not sure where to start.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "Hello! I'd be happy to help you find the perfect pair of shoes. To get started, could you tell me what brand you're interested in, or if you're open to any brand?",
    },
    {
        role: "user",
        role_type: "user",
        content: "I like Nike and Adidas, but I'm open to other brands too.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "That's great! It's important to find the right shoe for your needs. Could you tell me what you'll be using these shoes for mainly? For example, are they for running, basketball, or casual wear?",
    },
    {
        role: "user",
        role_type: "user",
        content: "I'll be using them for running.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "Fantastic! Now, could you please provide me with your shoe size and foot width? This information will help me narrow down the options for you.",
    },
    {
        role: "user",
        role_type: "user",
        content: "I wear a men's size 10, and I'm not sure about the foot width.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "Thank you. Based on your size, I'll make sure to suggest shoes with a wide range of sizes and widths available.",
    },
    {
        role: "user",
        role_type: "user",
        content: "I have a bit of a pronation issue. Do I need to consider that while choosing shoes?",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "Yes, pronation is essential when choosing running shoes. It refers to the way your foot rolls inward or outward when you walk or run. For pronation issues, stability or motion control shoes are usually recommended. I'll make sure to consider this in my suggestions.",
    },
    {
        role: "user",
        role_type: "user",
        content: "Great, I have a budget of around $120.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "Perfect! I'll make sure to find the best running shoes that fit your preferences, taking into account your brand preferences, running needs, size, and budget.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "I've found a few great options for you. The first one is the Brooks Ghost 14, which is known for its cushioning and support, ideal for runners with pronation issues. It's available in your size, and it's within your budget.",
        metadata: { bar: "foo" },
    },
    {
        role: "user",
        role_type: "user",
        content: "I've heard good things about Brooks, but I was kind of hoping to get a Nike or an Adidas shoe.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "I understand. In that case, I'd recommend the Adidas Ultraboost 21. It's a popular choice among runners for its comfort, energy return, and stability. Plus, it's on sale at $129.99 today, almost within your budget.",
    },
    {
        role: "user",
        role_type: "user",
        content: "They're nice looking. Yes, I think I'll go with those.",
    },
    {
        role: "assistant",
        role_type: "assistant",
        content:
            "Excellent choice! To complete the purchase, I'll need you to provide your credit card information in our secure payment form. This will allow us to process your order and ensure a smooth delivery.",
    },
];
