/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as Zep from "../../../index";
export declare namespace Document {
    interface Options {
        environment?: core.Supplier<environments.ZepEnvironment | string>;
        apiKey?: core.Supplier<string | undefined>;
        fetcher?: core.FetchFunction;
    }
    interface RequestOptions {
        timeoutInSeconds?: number;
        maxRetries?: number;
        abortSignal?: AbortSignal;
    }
}
export declare class Document {
    protected readonly _options: Document.Options;
    constructor(_options?: Document.Options);
    /**
     * Returns a list of all DocumentCollections.
     *
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.listCollections()
     */
    listCollections(requestOptions?: Document.RequestOptions): Promise<Zep.DocumentCollectionResponse[][]>;
    /**
     * Returns a DocumentCollection if it exists.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.getCollection("collectionName")
     */
    getCollection(collectionName: string, requestOptions?: Document.RequestOptions): Promise<Zep.DocumentCollectionResponse>;
    /**
     * If a collection with the same name already exists, an error will be returned.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Zep.CreateDocumentCollectionRequest} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.addCollection("collectionName")
     */
    addCollection(collectionName: string, request?: Zep.CreateDocumentCollectionRequest, requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * If a collection with the same name already exists, it will be overwritten.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.deleteCollection("collectionName")
     */
    deleteCollection(collectionName: string, requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Updates a DocumentCollection
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Zep.UpdateDocumentCollectionRequest} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.updateCollection("collectionName")
     */
    updateCollection(collectionName: string, request?: Zep.UpdateDocumentCollectionRequest, requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Creates Documents in a specified DocumentCollection and returns their UUIDs.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Zep.CreateDocumentRequest[]} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.addDocuments("collectionName", [{
     *             content: "content"
     *         }])
     */
    addDocuments(collectionName: string, request: Zep.CreateDocumentRequest[], requestOptions?: Document.RequestOptions): Promise<string[]>;
    /**
     * Deletes specified Documents from a DocumentCollection.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {string[]} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.batchDeleteDocuments("collectionName", ["string"])
     */
    batchDeleteDocuments(collectionName: string, request: string[], requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Returns Documents from a DocumentCollection specified by UUID or ID.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Zep.GetDocumentListRequest} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.batchGetDocuments("collectionName")
     */
    batchGetDocuments(collectionName: string, request?: Zep.GetDocumentListRequest, requestOptions?: Document.RequestOptions): Promise<Zep.DocumentResponse[]>;
    /**
     * Updates Documents in a specified DocumentCollection.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Zep.UpdateDocumentListRequest[]} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.batchUpdateDocuments("collectionName", [{
     *             uuid: "uuid"
     *         }])
     */
    batchUpdateDocuments(collectionName: string, request: Zep.UpdateDocumentListRequest[], requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Returns specified Document from a DocumentCollection.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {string} documentUuid - UUID of the Document to be updated
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.getsADocumentFromADocumentCollectionByUuid("collectionName", "documentUUID")
     */
    getsADocumentFromADocumentCollectionByUuid(collectionName: string, documentUuid: string, requestOptions?: Document.RequestOptions): Promise<Zep.DocumentResponse>;
    /**
     * Delete specified Document from a DocumentCollection.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {string} documentUuid - UUID of the Document to be deleted
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.deleteDocument("collectionName", "documentUUID")
     */
    deleteDocument(collectionName: string, documentUuid: string, requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Updates a Document in a DocumentCollection by UUID
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {string} documentUuid - UUID of the Document to be updated
     * @param {Zep.UpdateDocumentRequest} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.updatesADocument("collectionName", "documentUUID")
     */
    updatesADocument(collectionName: string, documentUuid: string, request?: Zep.UpdateDocumentRequest, requestOptions?: Document.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Searches over documents in a collection based on provided search criteria. One of text or metadata must be provided. Returns an empty list if no documents are found.
     *
     * @param {string} collectionName - Name of the Document Collection
     * @param {Zep.DocumentSearchPayload} request
     * @param {Document.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.UnauthorizedError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.document.search("collectionName")
     */
    search(collectionName: string, request?: Zep.DocumentSearchPayload, requestOptions?: Document.RequestOptions): Promise<Zep.DocumentSearchResultPage>;
    protected _getCustomAuthorizationHeaders(): Promise<{
        Authorization: string;
    }>;
}
