/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as Zep from "../../../index";
export declare namespace User {
    interface Options {
        environment?: core.Supplier<environments.ZepEnvironment | string>;
        apiKey?: core.Supplier<string | undefined>;
        fetcher?: core.FetchFunction;
    }
    interface RequestOptions {
        timeoutInSeconds?: number;
        maxRetries?: number;
        abortSignal?: AbortSignal;
    }
}
export declare class User {
    protected readonly _options: User.Options;
    constructor(_options?: User.Options);
    /**
     * Add a user.
     *
     * @param {Zep.CreateUserRequest} request
     * @param {User.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.user.add()
     */
    add(request?: Zep.CreateUserRequest, requestOptions?: User.RequestOptions): Promise<Zep.User>;
    /**
     * List all users with pagination.
     *
     * @param {Zep.UserListOrderedRequest} request
     * @param {User.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.user.listOrdered()
     */
    listOrdered(request?: Zep.UserListOrderedRequest, requestOptions?: User.RequestOptions): Promise<Zep.UserListResponse>;
    /**
     * Get a user.
     *
     * @param {string} userId - The user_id of the user to get.
     * @param {User.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.user.get("userId")
     */
    get(userId: string, requestOptions?: User.RequestOptions): Promise<Zep.User>;
    /**
     * delete user by id
     *
     * @param {string} userId - User ID
     * @param {User.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.user.delete("userId")
     */
    delete(userId: string, requestOptions?: User.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Update a user.
     *
     * @param {string} userId - User ID
     * @param {Zep.UpdateUserRequest} request
     * @param {User.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.user.update("userId")
     */
    update(userId: string, request?: Zep.UpdateUserRequest, requestOptions?: User.RequestOptions): Promise<Zep.User>;
    /**
     * list all sessions for a user by user id
     *
     * @param {string} userId - User ID
     * @param {User.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.user.getSessions("userId")
     */
    getSessions(userId: string, requestOptions?: User.RequestOptions): Promise<Zep.Session[]>;
    protected _getCustomAuthorizationHeaders(): Promise<{
        Authorization: string;
    }>;
}
