/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as Zep from "../../../index";
export declare namespace Memory {
    interface Options {
        environment?: core.Supplier<environments.ZepEnvironment | string>;
        apiKey?: core.Supplier<string | undefined>;
        fetcher?: core.FetchFunction;
    }
    interface RequestOptions {
        timeoutInSeconds?: number;
        maxRetries?: number;
        abortSignal?: AbortSignal;
    }
}
export declare class Memory {
    protected readonly _options: Memory.Options;
    constructor(_options?: Memory.Options);
    /**
     * get fact by uuid
     *
     * @param {string} factUuid - Fact UUID
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.getFact("factUUID")
     */
    getFact(factUuid: string, requestOptions?: Memory.RequestOptions): Promise<Zep.FactResponse>;
    /**
     * delete a fact
     *
     * @param {string} factUuid - Fact UUID
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.deleteFact("factUUID")
     */
    deleteFact(factUuid: string, requestOptions?: Memory.RequestOptions): Promise<string>;
    /**
     * Create New Session
     *
     * @param {Zep.CreateSessionRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.addSession({
     *         sessionId: "session_id"
     *     })
     */
    addSession(request: Zep.CreateSessionRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.Session>;
    /**
     * Get all sessions with optional page number, page size, order by field and order direction for pagination.
     *
     * @param {Zep.MemoryListSessionsRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.listSessions()
     */
    listSessions(request?: Zep.MemoryListSessionsRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.SessionListResponse>;
    /**
     * End multiple sessions by their IDs
     *
     * @param {Zep.EndSessionsRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.endSessions({
     *         sessionIds: ["session_ids"]
     *     })
     */
    endSessions(request: Zep.EndSessionsRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.EndSessionsResponse>;
    /**
     * Search sessions for the specified query.
     *
     * @param {Zep.SessionSearchQuery} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.searchSessions()
     */
    searchSessions(request?: Zep.SessionSearchQuery, requestOptions?: Memory.RequestOptions): Promise<Zep.SessionSearchResponse>;
    /**
     * get session by id
     *
     * @param {string} sessionId - Session ID
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.getSession("sessionId")
     */
    getSession(sessionId: string, requestOptions?: Memory.RequestOptions): Promise<Zep.Session>;
    /**
     * Update Session Metadata
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.UpdateSessionRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.ConflictError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.updateSession("sessionId", {
     *         metadata: {}
     *     })
     */
    updateSession(sessionId: string, request: Zep.UpdateSessionRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.Session>;
    /**
     * classify a session by session id
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.ClassifySessionRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.classifySession("sessionId", {
     *         classes: ["classes"],
     *         name: "name"
     *     })
     */
    classifySession(sessionId: string, request: Zep.ClassifySessionRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.ClassifySessionResponse>;
    /**
     * End a session by ID
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.EndSessionRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.endSession("sessionId")
     */
    endSession(sessionId: string, request?: Zep.EndSessionRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.EndSessionResponse>;
    /**
     * extract data from a session by session id
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.ExtractDataRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.BadRequestError}
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.extractData("sessionId", {
     *         lastN: 1,
     *         modelSchema: "model_schema"
     *     })
     */
    extractData(sessionId: string, request: Zep.ExtractDataRequest, requestOptions?: Memory.RequestOptions): Promise<Record<string, string>>;
    /**
     * get facts for a session
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.MemoryGetSessionFactsRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.getSessionFacts("sessionId")
     */
    getSessionFacts(sessionId: string, request?: Zep.MemoryGetSessionFactsRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.FactsResponse>;
    /**
     * Adds facts to a session
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.AddFactsRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.addSessionFacts("sessionId")
     */
    addSessionFacts(sessionId: string, request?: Zep.AddFactsRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Returns a memory (latest summary, list of messages and facts for models.MemoryTypePerpetual) for a given session
     *
     * @param {string} sessionId - The ID of the session for which to retrieve memory.
     * @param {Zep.MemoryGetRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.get("sessionId")
     */
    get(sessionId: string, request?: Zep.MemoryGetRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.Memory>;
    /**
     * Add memory to the specified session.
     *
     * @param {string} sessionId - The ID of the session to which memory should be added.
     * @param {Zep.AddMemoryRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.add("sessionId", {
     *         messages: [{}]
     *     })
     */
    add(sessionId: string, request: Zep.AddMemoryRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * delete memory messages by session id
     *
     * @param {string} sessionId - The ID of the session for which memory should be deleted.
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.delete("sessionId")
     */
    delete(sessionId: string, requestOptions?: Memory.RequestOptions): Promise<Zep.SuccessResponse>;
    /**
     * Lists messages for a session, specified by limit and cursor.
     *
     * @param {string} sessionId - Session ID
     * @param {Zep.MemoryGetSessionMessagesRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.getSessionMessages("sessionId")
     */
    getSessionMessages(sessionId: string, request?: Zep.MemoryGetSessionMessagesRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.MessageListResponse>;
    /**
     * Gets a specific message from a session
     *
     * @param {string} sessionId - The ID of the session.
     * @param {string} messageUuid - The UUID of the message.
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.getSessionMessage("sessionId", "messageUUID")
     */
    getSessionMessage(sessionId: string, messageUuid: string, requestOptions?: Memory.RequestOptions): Promise<Zep.Message>;
    /**
     * Updates the metadata of a message.
     *
     * @param {string} sessionId - The ID of the session.
     * @param {string} messageUuid - The UUID of the message.
     * @param {Zep.ModelsMessageMetadataUpdate} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.updateMessageMetadata("sessionId", "messageUUID", {
     *         metadata: {}
     *     })
     */
    updateMessageMetadata(sessionId: string, messageUuid: string, request: Zep.ModelsMessageMetadataUpdate, requestOptions?: Memory.RequestOptions): Promise<Zep.Message>;
    /**
     * Search memory for the specified session.
     *
     * @param {string} sessionId - The ID of the session for which memory should be searched.
     * @param {Zep.MemorySearchPayload} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.search("sessionId")
     */
    search(sessionId: string, request?: Zep.MemorySearchPayload, requestOptions?: Memory.RequestOptions): Promise<Zep.MemorySearchResult[]>;
    /**
     * Get session summaries by ID
     *
     * @param {string} sessionId - Session ID
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.getSummaries("sessionId")
     */
    getSummaries(sessionId: string, requestOptions?: Memory.RequestOptions): Promise<Zep.SummaryListResponse>;
    /**
     * Synthesize a question from the last N messages in the chat history.
     *
     * @param {string} sessionId - The ID of the session.
     * @param {Zep.MemorySynthesizeQuestionRequest} request
     * @param {Memory.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link Zep.NotFoundError}
     * @throws {@link Zep.InternalServerError}
     *
     * @example
     *     await zep.memory.synthesizeQuestion("sessionId")
     */
    synthesizeQuestion(sessionId: string, request?: Zep.MemorySynthesizeQuestionRequest, requestOptions?: Memory.RequestOptions): Promise<Zep.Question>;
    protected _getCustomAuthorizationHeaders(): Promise<{
        Authorization: string;
    }>;
}
