/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import { SecretSetParameters as SecretSetParametersMapper, SecretUpdateParameters as SecretUpdateParametersMapper, SecretRestoreParameters as SecretRestoreParametersMapper } from "../models/mappers";
export const contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const value = {
    parameterPath: "value",
    mapper: SecretSetParametersMapper
};
export const tags = {
    parameterPath: ["options", "tags"],
    mapper: SecretSetParametersMapper
};
export const contentType1 = {
    parameterPath: ["options", "contentType"],
    mapper: SecretSetParametersMapper
};
export const secretAttributes = {
    parameterPath: ["options", "secretAttributes"],
    mapper: SecretSetParametersMapper
};
export const vaultBaseUrl = {
    parameterPath: "vaultBaseUrl",
    mapper: {
        serializedName: "vaultBaseUrl",
        required: true,
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
export const secretName = {
    parameterPath: "secretName",
    mapper: {
        constraints: {
            Pattern: new RegExp("^[0-9a-zA-Z-]+$")
        },
        serializedName: "secret-name",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const apiVersion = {
    parameterPath: "apiVersion",
    mapper: {
        serializedName: "api-version",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const secretName1 = {
    parameterPath: "secretName",
    mapper: {
        serializedName: "secret-name",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const contentType2 = {
    parameterPath: ["options", "contentType"],
    mapper: SecretUpdateParametersMapper
};
export const secretAttributes1 = {
    parameterPath: ["options", "secretAttributes"],
    mapper: SecretUpdateParametersMapper
};
export const tags1 = {
    parameterPath: ["options", "tags"],
    mapper: SecretUpdateParametersMapper
};
export const secretVersion = {
    parameterPath: "secretVersion",
    mapper: {
        serializedName: "secret-version",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const maxresults = {
    parameterPath: ["options", "maxresults"],
    mapper: {
        constraints: {
            InclusiveMaximum: 25,
            InclusiveMinimum: 1
        },
        serializedName: "maxresults",
        type: {
            name: "Number"
        }
    }
};
export const secretBundleBackup = {
    parameterPath: "secretBundleBackup",
    mapper: SecretRestoreParametersMapper
};
export const nextLink = {
    parameterPath: "nextLink",
    mapper: {
        serializedName: "nextLink",
        required: true,
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
//# sourceMappingURL=parameters.js.map