/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import * as coreClient from "@azure/core-client";
import * as coreHttpCompat from "@azure/core-http-compat";
import * as coreRestPipeline from "@azure/core-rest-pipeline";
import * as Parameters from "./models/parameters";
import * as Mappers from "./models/mappers";
/** @internal */
export class KeyVaultClient extends coreHttpCompat.ExtendedServiceClient {
    /**
     * Initializes a new instance of the KeyVaultClient class.
     * @param apiVersion Api Version
     * @param options The parameter options
     */
    constructor(apiVersion, options) {
        var _a, _b;
        if (apiVersion === undefined) {
            throw new Error("'apiVersion' cannot be null");
        }
        // Initializing default values for options
        if (!options) {
            options = {};
        }
        const defaults = {
            requestContentType: "application/json; charset=utf-8"
        };
        const packageDetails = `azsdk-js-keyvault-secrets/4.8.0`;
        const userAgentPrefix = options.userAgentOptions && options.userAgentOptions.userAgentPrefix
            ? `${options.userAgentOptions.userAgentPrefix} ${packageDetails}`
            : `${packageDetails}`;
        const optionsWithDefaults = Object.assign(Object.assign(Object.assign({}, defaults), options), { userAgentOptions: {
                userAgentPrefix
            }, baseUri: (_b = (_a = options.endpoint) !== null && _a !== void 0 ? _a : options.baseUri) !== null && _b !== void 0 ? _b : "{vaultBaseUrl}" });
        super(optionsWithDefaults);
        if ((options === null || options === void 0 ? void 0 : options.pipeline) && options.pipeline.getOrderedPolicies().length > 0) {
            const pipelinePolicies = options.pipeline.getOrderedPolicies();
            const bearerTokenAuthenticationPolicyFound = pipelinePolicies.some((pipelinePolicy) => pipelinePolicy.name ===
                coreRestPipeline.bearerTokenAuthenticationPolicyName);
            if (!bearerTokenAuthenticationPolicyFound) {
                this.pipeline.removePolicy({
                    name: coreRestPipeline.bearerTokenAuthenticationPolicyName
                });
                this.pipeline.addPolicy(coreRestPipeline.bearerTokenAuthenticationPolicy({
                    scopes: `${optionsWithDefaults.baseUri}/.default`,
                    challengeCallbacks: {
                        authorizeRequestOnChallenge: coreClient.authorizeRequestOnClaimChallenge
                    }
                }));
            }
        }
        // Parameter assignments
        this.apiVersion = apiVersion;
    }
    /**
     *  The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure
     * Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the
     *                   purpose of running the service. The value provided should not include personally identifiable or
     *                   sensitive information.
     * @param value The value of the secret.
     * @param options The options parameters.
     */
    setSecret(vaultBaseUrl, secretName, value, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, value, options }, setSecretOperationSpec);
    }
    /**
     * The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param options The options parameters.
     */
    deleteSecret(vaultBaseUrl, secretName, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, options }, deleteSecretOperationSpec);
    }
    /**
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are
     * not specified in the request are left unchanged. The value of a secret itself cannot be changed.
     * This operation requires the secrets/set permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param options The options parameters.
     */
    updateSecret(vaultBaseUrl, secretName, secretVersion, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, secretVersion, options }, updateSecretOperationSpec);
    }
    /**
     * The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the
     *                      latest version of the secret is returned.
     * @param options The options parameters.
     */
    getSecret(vaultBaseUrl, secretName, secretVersion, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, secretVersion, options }, getSecretOperationSpec);
    }
    /**
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret
     * identifier and its attributes are provided in the response. Individual secret versions are not
     * listed in the response. This operation requires the secrets/list permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param options The options parameters.
     */
    getSecrets(vaultBaseUrl, options) {
        return this.sendOperationRequest({ vaultBaseUrl, options }, getSecretsOperationSpec);
    }
    /**
     * The full secret identifier and attributes are provided in the response. No values are returned for
     * the secrets. This operations requires the secrets/list permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param options The options parameters.
     */
    getSecretVersions(vaultBaseUrl, secretName, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, options }, getSecretVersionsOperationSpec);
    }
    /**
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param options The options parameters.
     */
    getDeletedSecrets(vaultBaseUrl, options) {
        return this.sendOperationRequest({ vaultBaseUrl, options }, getDeletedSecretsOperationSpec);
    }
    /**
     * The Get Deleted Secret operation returns the specified deleted secret along with its attributes.
     * This operation requires the secrets/get permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param options The options parameters.
     */
    getDeletedSecret(vaultBaseUrl, secretName, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, options }, getDeletedSecretOperationSpec);
    }
    /**
     * The purge deleted secret operation removes the secret permanently, without the possibility of
     * recovery. This operation can only be enabled on a soft-delete enabled vault. This operation requires
     * the secrets/purge permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param options The options parameters.
     */
    purgeDeletedSecret(vaultBaseUrl, secretName, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, options }, purgeDeletedSecretOperationSpec);
    }
    /**
     * Recovers the deleted secret in the specified vault. This operation can only be performed on a
     * soft-delete enabled vault. This operation requires the secrets/recover permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @param options The options parameters.
     */
    recoverDeletedSecret(vaultBaseUrl, secretName, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, options }, recoverDeletedSecretOperationSpec);
    }
    /**
     * Requests that a backup of the specified secret be downloaded to the client. All versions of the
     * secret will be downloaded. This operation requires the secrets/backup permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param options The options parameters.
     */
    backupSecret(vaultBaseUrl, secretName, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, options }, backupSecretOperationSpec);
    }
    /**
     * Restores a backed up secret, and all its versions, to a vault. This operation requires the
     * secrets/restore permission.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @param options The options parameters.
     */
    restoreSecret(vaultBaseUrl, secretBundleBackup, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretBundleBackup, options }, restoreSecretOperationSpec);
    }
    /**
     * GetSecretsNext
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param nextLink The nextLink from the previous successful call to the GetSecrets method.
     * @param options The options parameters.
     */
    getSecretsNext(vaultBaseUrl, nextLink, options) {
        return this.sendOperationRequest({ vaultBaseUrl, nextLink, options }, getSecretsNextOperationSpec);
    }
    /**
     * GetSecretVersionsNext
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param nextLink The nextLink from the previous successful call to the GetSecretVersions method.
     * @param options The options parameters.
     */
    getSecretVersionsNext(vaultBaseUrl, secretName, nextLink, options) {
        return this.sendOperationRequest({ vaultBaseUrl, secretName, nextLink, options }, getSecretVersionsNextOperationSpec);
    }
    /**
     * GetDeletedSecretsNext
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param nextLink The nextLink from the previous successful call to the GetDeletedSecrets method.
     * @param options The options parameters.
     */
    getDeletedSecretsNext(vaultBaseUrl, nextLink, options) {
        return this.sendOperationRequest({ vaultBaseUrl, nextLink, options }, getDeletedSecretsNextOperationSpec);
    }
}
// Operation Specifications
const serializer = coreClient.createSerializer(Mappers, /* isXml */ false);
const setSecretOperationSpec = {
    path: "/secrets/{secret-name}",
    httpMethod: "PUT",
    responses: {
        200: {
            bodyMapper: Mappers.SecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    requestBody: {
        parameterPath: {
            value: ["value"],
            tags: ["options", "tags"],
            contentType: ["options", "contentType"],
            secretAttributes: ["options", "secretAttributes"]
        },
        mapper: Object.assign(Object.assign({}, Mappers.SecretSetParameters), { required: true })
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName],
    headerParameters: [Parameters.contentType, Parameters.accept],
    mediaType: "json",
    serializer
};
const deleteSecretOperationSpec = {
    path: "/secrets/{secret-name}",
    httpMethod: "DELETE",
    responses: {
        200: {
            bodyMapper: Mappers.DeletedSecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName1],
    headerParameters: [Parameters.accept],
    serializer
};
const updateSecretOperationSpec = {
    path: "/secrets/{secret-name}/{secret-version}",
    httpMethod: "PATCH",
    responses: {
        200: {
            bodyMapper: Mappers.SecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    requestBody: {
        parameterPath: {
            contentType: ["options", "contentType"],
            secretAttributes: ["options", "secretAttributes"],
            tags: ["options", "tags"]
        },
        mapper: Object.assign(Object.assign({}, Mappers.SecretUpdateParameters), { required: true })
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [
        Parameters.vaultBaseUrl,
        Parameters.secretName1,
        Parameters.secretVersion
    ],
    headerParameters: [Parameters.contentType, Parameters.accept],
    mediaType: "json",
    serializer
};
const getSecretOperationSpec = {
    path: "/secrets/{secret-name}/{secret-version}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.SecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [
        Parameters.vaultBaseUrl,
        Parameters.secretName1,
        Parameters.secretVersion
    ],
    headerParameters: [Parameters.accept],
    serializer
};
const getSecretsOperationSpec = {
    path: "/secrets",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.SecretListResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion, Parameters.maxresults],
    urlParameters: [Parameters.vaultBaseUrl],
    headerParameters: [Parameters.accept],
    serializer
};
const getSecretVersionsOperationSpec = {
    path: "/secrets/{secret-name}/versions",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.SecretListResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion, Parameters.maxresults],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName1],
    headerParameters: [Parameters.accept],
    serializer
};
const getDeletedSecretsOperationSpec = {
    path: "/deletedsecrets",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.DeletedSecretListResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion, Parameters.maxresults],
    urlParameters: [Parameters.vaultBaseUrl],
    headerParameters: [Parameters.accept],
    serializer
};
const getDeletedSecretOperationSpec = {
    path: "/deletedsecrets/{secret-name}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.DeletedSecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName1],
    headerParameters: [Parameters.accept],
    serializer
};
const purgeDeletedSecretOperationSpec = {
    path: "/deletedsecrets/{secret-name}",
    httpMethod: "DELETE",
    responses: {
        204: {},
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName1],
    headerParameters: [Parameters.accept],
    serializer
};
const recoverDeletedSecretOperationSpec = {
    path: "/deletedsecrets/{secret-name}/recover",
    httpMethod: "POST",
    responses: {
        200: {
            bodyMapper: Mappers.SecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName1],
    headerParameters: [Parameters.accept],
    serializer
};
const backupSecretOperationSpec = {
    path: "/secrets/{secret-name}/backup",
    httpMethod: "POST",
    responses: {
        200: {
            bodyMapper: Mappers.BackupSecretResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.secretName1],
    headerParameters: [Parameters.accept],
    serializer
};
const restoreSecretOperationSpec = {
    path: "/secrets/restore",
    httpMethod: "POST",
    responses: {
        200: {
            bodyMapper: Mappers.SecretBundle
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    requestBody: {
        parameterPath: { secretBundleBackup: ["secretBundleBackup"] },
        mapper: Object.assign(Object.assign({}, Mappers.SecretRestoreParameters), { required: true })
    },
    queryParameters: [Parameters.apiVersion],
    urlParameters: [Parameters.vaultBaseUrl],
    headerParameters: [Parameters.contentType, Parameters.accept],
    mediaType: "json",
    serializer
};
const getSecretsNextOperationSpec = {
    path: "{nextLink}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.SecretListResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion, Parameters.maxresults],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.nextLink],
    headerParameters: [Parameters.accept],
    serializer
};
const getSecretVersionsNextOperationSpec = {
    path: "{nextLink}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.SecretListResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion, Parameters.maxresults],
    urlParameters: [
        Parameters.vaultBaseUrl,
        Parameters.secretName1,
        Parameters.nextLink
    ],
    headerParameters: [Parameters.accept],
    serializer
};
const getDeletedSecretsNextOperationSpec = {
    path: "{nextLink}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.DeletedSecretListResult
        },
        default: {
            bodyMapper: Mappers.KeyVaultError
        }
    },
    queryParameters: [Parameters.apiVersion, Parameters.maxresults],
    urlParameters: [Parameters.vaultBaseUrl, Parameters.nextLink],
    headerParameters: [Parameters.accept],
    serializer
};
//# sourceMappingURL=keyVaultClient.js.map