import {
  ActionSummary,
  AlgorithmSortBy,
  AlgorithmSummary,
  AppDetails,
  AppImageConfigDetails,
  AppImageConfigSortKey,
  AppSortKey,
  AppType,
  ArtifactSummary,
  AssociationEdgeType,
  AssociationSummary,
  AutoMLCandidate,
  AutoMLJobStatus,
  AutoMLJobStepMetadata,
  AutoMLJobSummary,
  AutoMLSortBy,
  AutoMLSortOrder,
  CacheHitResult,
  CallbackStepMetadata,
  CandidateSortBy,
  CandidateStatus,
  ClarifyCheckStepMetadata,
  ClusterEventResourceType,
  ClusterEventSummary,
  ClusterNodeSummary,
  FeatureStatus,
  ModelApprovalStatus,
  ModelPackageStatus,
  OutputParameter,
  SchedulerResourceStatus,
  Tag,
  UserContext,
} from "./models_0";
import {
  _InstanceType,
  ClusterSchedulerConfigSummary,
  ClusterSortBy,
  ClusterSummary,
  CodeRepositorySortBy,
  CodeRepositorySortOrder,
  CodeRepositorySummary,
  CompilationJobStatus,
  CompilationJobSummary,
  ComputeQuotaSummary,
  ConditionStepMetadata,
  ContextSummary,
  HubContentType,
  HyperParameterTrainingJobDefinition,
  HyperParameterTuningJobConfig,
  HyperParameterTuningJobStrategyType,
  HyperParameterTuningJobWarmStartConfig,
  InferenceExperimentSchedule,
  InferenceExperimentType,
  LabelingJobInputConfig,
  RecommendationJobType,
  ResourceLimits,
} from "./models_1";
import {
  CrossAccountFilterOption,
  ModelCardStatus,
  ModelLifeCycle,
  MonitoringType,
  OptimizationJobDeploymentInstanceType,
  PartnerAppType,
  SharingType,
  SpaceStorageSettings,
  StudioLifecycleConfigAppType,
  TrialComponentStatus,
} from "./models_2";
import {
  DeviceDeploymentSummary,
  DeviceFleetSummary,
  DeviceSummary,
  DomainDetails,
  EdgeDeploymentPlanSummary,
  EdgePackagingJobStatus,
  EdgePackagingJobSummary,
  EMRStepMetadata,
  EndpointConfigSortKey,
  EndpointConfigStepMetadata,
  EndpointConfigSummary,
  EndpointOutputConfiguration,
  EndpointSortKey,
  EndpointStatus,
  EndpointStepMetadata,
  EndpointSummary,
  EventSortBy,
  ExecutionStatus,
  ExperimentSummary,
  FailStepMetadata,
  FeatureGroupSortBy,
  FeatureGroupSortOrder,
  FeatureGroupStatus,
  FeatureGroupSummary,
  FlowDefinitionSummary,
  HubContentInfo,
  HubContentSortBy,
  HubContentSupportStatus,
  HubStatus,
  HyperParameterTrainingJobSummary,
  HyperParameterTuningJobCompletionDetails,
  HyperParameterTuningJobConsumedResources,
  HyperParameterTuningJobStatus,
  ImageStatus,
  ImageVersionStatus,
  InferenceComponentStatus,
  InferenceExperimentStatus,
  InferenceMetrics,
  IsTrackingServerActive,
  LabelCounters,
  LabelingJobOutput,
  LabelingJobStatus,
  ModelCardExportJobStatus,
  ModelConfiguration,
  ModelPackageGroupStatus,
  MonitoringExecutionSummary,
  NotebookInstanceStatus,
  ObjectiveStatusCounters,
  OfflineStoreStatusValue,
  OptimizationJobStatus,
  PartnerAppStatus,
  PipelineExecutionStatus,
  ProcessingJobStatus,
  ProjectStatus,
  RecommendationJobStatus,
  RecommendationMetrics,
  ReservedCapacityInstanceType,
  ReservedCapacitySummary,
  SageMakerResourceName,
  ScheduleStatus,
  SecondaryStatus,
  SpaceStatus,
  SubscribedWorkteam,
  TrackingServerStatus,
  TrainingJobStatus,
  TrainingJobStatusCounters,
  TrainingPlanStatus,
  TransformJobStatus,
  TrialComponentSource,
  TrialSource,
  UserProfileStatus,
  WarmPoolResourceStatus,
  WarmPoolStatus,
} from "./models_3";
export interface HubInfo {
  HubName: string | undefined;
  HubArn: string | undefined;
  HubDisplayName?: string | undefined;
  HubDescription?: string | undefined;
  HubSearchKeywords?: string[] | undefined;
  HubStatus: HubStatus | undefined;
  CreationTime: Date | undefined;
  LastModifiedTime: Date | undefined;
}
export declare const HubSortBy: {
  readonly ACCOUNT_ID_OWNER: "AccountIdOwner";
  readonly CREATION_TIME: "CreationTime";
  readonly HUB_NAME: "HubName";
  readonly HUB_STATUS: "HubStatus";
};
export type HubSortBy = (typeof HubSortBy)[keyof typeof HubSortBy];
export interface HumanTaskUiSummary {
  HumanTaskUiName: string | undefined;
  HumanTaskUiArn: string | undefined;
  CreationTime: Date | undefined;
}
export interface HyperParameterTuningJobSearchEntity {
  HyperParameterTuningJobName?: string | undefined;
  HyperParameterTuningJobArn?: string | undefined;
  HyperParameterTuningJobConfig?: HyperParameterTuningJobConfig | undefined;
  TrainingJobDefinition?: HyperParameterTrainingJobDefinition | undefined;
  TrainingJobDefinitions?: HyperParameterTrainingJobDefinition[] | undefined;
  HyperParameterTuningJobStatus?: HyperParameterTuningJobStatus | undefined;
  CreationTime?: Date | undefined;
  HyperParameterTuningEndTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  TrainingJobStatusCounters?: TrainingJobStatusCounters | undefined;
  ObjectiveStatusCounters?: ObjectiveStatusCounters | undefined;
  BestTrainingJob?: HyperParameterTrainingJobSummary | undefined;
  OverallBestTrainingJob?: HyperParameterTrainingJobSummary | undefined;
  WarmStartConfig?: HyperParameterTuningJobWarmStartConfig | undefined;
  FailureReason?: string | undefined;
  TuningJobCompletionDetails?:
    | HyperParameterTuningJobCompletionDetails
    | undefined;
  ConsumedResources?: HyperParameterTuningJobConsumedResources | undefined;
  Tags?: Tag[] | undefined;
}
export declare const HyperParameterTuningJobSortByOptions: {
  readonly CreationTime: "CreationTime";
  readonly Name: "Name";
  readonly Status: "Status";
};
export type HyperParameterTuningJobSortByOptions =
  (typeof HyperParameterTuningJobSortByOptions)[keyof typeof HyperParameterTuningJobSortByOptions];
export interface HyperParameterTuningJobSummary {
  HyperParameterTuningJobName: string | undefined;
  HyperParameterTuningJobArn: string | undefined;
  HyperParameterTuningJobStatus: HyperParameterTuningJobStatus | undefined;
  Strategy: HyperParameterTuningJobStrategyType | undefined;
  CreationTime: Date | undefined;
  HyperParameterTuningEndTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  TrainingJobStatusCounters: TrainingJobStatusCounters | undefined;
  ObjectiveStatusCounters: ObjectiveStatusCounters | undefined;
  ResourceLimits?: ResourceLimits | undefined;
}
export interface Image {
  CreationTime: Date | undefined;
  Description?: string | undefined;
  DisplayName?: string | undefined;
  FailureReason?: string | undefined;
  ImageArn: string | undefined;
  ImageName: string | undefined;
  ImageStatus: ImageStatus | undefined;
  LastModifiedTime: Date | undefined;
}
export declare const ImageSortBy: {
  readonly CREATION_TIME: "CREATION_TIME";
  readonly IMAGE_NAME: "IMAGE_NAME";
  readonly LAST_MODIFIED_TIME: "LAST_MODIFIED_TIME";
};
export type ImageSortBy = (typeof ImageSortBy)[keyof typeof ImageSortBy];
export declare const ImageSortOrder: {
  readonly ASCENDING: "ASCENDING";
  readonly DESCENDING: "DESCENDING";
};
export type ImageSortOrder =
  (typeof ImageSortOrder)[keyof typeof ImageSortOrder];
export interface ImageVersion {
  CreationTime: Date | undefined;
  FailureReason?: string | undefined;
  ImageArn: string | undefined;
  ImageVersionArn: string | undefined;
  ImageVersionStatus: ImageVersionStatus | undefined;
  LastModifiedTime: Date | undefined;
  Version: number | undefined;
}
export declare const ImageVersionSortBy: {
  readonly CREATION_TIME: "CREATION_TIME";
  readonly LAST_MODIFIED_TIME: "LAST_MODIFIED_TIME";
  readonly VERSION: "VERSION";
};
export type ImageVersionSortBy =
  (typeof ImageVersionSortBy)[keyof typeof ImageVersionSortBy];
export declare const ImageVersionSortOrder: {
  readonly ASCENDING: "ASCENDING";
  readonly DESCENDING: "DESCENDING";
};
export type ImageVersionSortOrder =
  (typeof ImageVersionSortOrder)[keyof typeof ImageVersionSortOrder];
export interface ImportHubContentRequest {
  HubContentName: string | undefined;
  HubContentVersion?: string | undefined;
  HubContentType: HubContentType | undefined;
  DocumentSchemaVersion: string | undefined;
  HubName: string | undefined;
  HubContentDisplayName?: string | undefined;
  HubContentDescription?: string | undefined;
  HubContentMarkdown?: string | undefined;
  HubContentDocument: string | undefined;
  SupportStatus?: HubContentSupportStatus | undefined;
  HubContentSearchKeywords?: string[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface ImportHubContentResponse {
  HubArn: string | undefined;
  HubContentArn: string | undefined;
}
export declare const InferenceComponentSortKey: {
  readonly CreationTime: "CreationTime";
  readonly Name: "Name";
  readonly Status: "Status";
};
export type InferenceComponentSortKey =
  (typeof InferenceComponentSortKey)[keyof typeof InferenceComponentSortKey];
export interface InferenceComponentSummary {
  CreationTime: Date | undefined;
  InferenceComponentArn: string | undefined;
  InferenceComponentName: string | undefined;
  EndpointArn: string | undefined;
  EndpointName: string | undefined;
  VariantName: string | undefined;
  InferenceComponentStatus?: InferenceComponentStatus | undefined;
  LastModifiedTime: Date | undefined;
}
export interface InferenceExperimentSummary {
  Name: string | undefined;
  Type: InferenceExperimentType | undefined;
  Schedule?: InferenceExperimentSchedule | undefined;
  Status: InferenceExperimentStatus | undefined;
  StatusReason?: string | undefined;
  Description?: string | undefined;
  CreationTime: Date | undefined;
  CompletionTime?: Date | undefined;
  LastModifiedTime: Date | undefined;
  RoleArn?: string | undefined;
}
export declare const InferenceExperimentStopDesiredState: {
  readonly CANCELLED: "Cancelled";
  readonly COMPLETED: "Completed";
};
export type InferenceExperimentStopDesiredState =
  (typeof InferenceExperimentStopDesiredState)[keyof typeof InferenceExperimentStopDesiredState];
export interface InferenceRecommendationsJob {
  JobName: string | undefined;
  JobDescription: string | undefined;
  JobType: RecommendationJobType | undefined;
  JobArn: string | undefined;
  Status: RecommendationJobStatus | undefined;
  CreationTime: Date | undefined;
  CompletionTime?: Date | undefined;
  RoleArn: string | undefined;
  LastModifiedTime: Date | undefined;
  FailureReason?: string | undefined;
  ModelName?: string | undefined;
  SamplePayloadUrl?: string | undefined;
  ModelPackageVersionArn?: string | undefined;
}
export interface RecommendationJobInferenceBenchmark {
  Metrics?: RecommendationMetrics | undefined;
  EndpointMetrics?: InferenceMetrics | undefined;
  EndpointConfiguration?: EndpointOutputConfiguration | undefined;
  ModelConfiguration: ModelConfiguration | undefined;
  FailureReason?: string | undefined;
  InvocationEndTime?: Date | undefined;
  InvocationStartTime?: Date | undefined;
}
export declare const RecommendationStepType: {
  readonly BENCHMARK: "BENCHMARK";
};
export type RecommendationStepType =
  (typeof RecommendationStepType)[keyof typeof RecommendationStepType];
export interface InferenceRecommendationsJobStep {
  StepType: RecommendationStepType | undefined;
  JobName: string | undefined;
  Status: RecommendationJobStatus | undefined;
  InferenceBenchmark?: RecommendationJobInferenceBenchmark | undefined;
}
export interface LabelCountersForWorkteam {
  HumanLabeled?: number | undefined;
  PendingHuman?: number | undefined;
  Total?: number | undefined;
}
export interface LabelingJobForWorkteamSummary {
  LabelingJobName?: string | undefined;
  JobReferenceCode: string | undefined;
  WorkRequesterAccountId: string | undefined;
  CreationTime: Date | undefined;
  LabelCounters?: LabelCountersForWorkteam | undefined;
  NumberOfHumanWorkersPerDataObject?: number | undefined;
}
export interface LabelingJobSummary {
  LabelingJobName: string | undefined;
  LabelingJobArn: string | undefined;
  CreationTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  LabelingJobStatus: LabelingJobStatus | undefined;
  LabelCounters: LabelCounters | undefined;
  WorkteamArn: string | undefined;
  PreHumanTaskLambdaArn?: string | undefined;
  AnnotationConsolidationLambdaArn?: string | undefined;
  FailureReason?: string | undefined;
  LabelingJobOutput?: LabelingJobOutput | undefined;
  InputConfig?: LabelingJobInputConfig | undefined;
}
export interface LambdaStepMetadata {
  Arn?: string | undefined;
  OutputParameters?: OutputParameter[] | undefined;
}
export interface LineageGroupSummary {
  LineageGroupArn?: string | undefined;
  LineageGroupName?: string | undefined;
  DisplayName?: string | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
}
export declare const LineageType: {
  readonly ACTION: "Action";
  readonly ARTIFACT: "Artifact";
  readonly CONTEXT: "Context";
  readonly TRIAL_COMPONENT: "TrialComponent";
};
export type LineageType = (typeof LineageType)[keyof typeof LineageType];
export declare const SortActionsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortActionsBy = (typeof SortActionsBy)[keyof typeof SortActionsBy];
export declare const SortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder];
export interface ListActionsRequest {
  SourceUri?: string | undefined;
  ActionType?: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortActionsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListActionsResponse {
  ActionSummaries?: ActionSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListAlgorithmsInput {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  SortBy?: AlgorithmSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListAlgorithmsOutput {
  AlgorithmSummaryList: AlgorithmSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListAliasesRequest {
  ImageName: string | undefined;
  Alias?: string | undefined;
  Version?: number | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListAliasesResponse {
  SageMakerImageVersionAliases?: string[] | undefined;
  NextToken?: string | undefined;
}
export interface ListAppImageConfigsRequest {
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  ModifiedTimeBefore?: Date | undefined;
  ModifiedTimeAfter?: Date | undefined;
  SortBy?: AppImageConfigSortKey | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListAppImageConfigsResponse {
  NextToken?: string | undefined;
  AppImageConfigs?: AppImageConfigDetails[] | undefined;
}
export interface ListAppsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortOrder?: SortOrder | undefined;
  SortBy?: AppSortKey | undefined;
  DomainIdEquals?: string | undefined;
  UserProfileNameEquals?: string | undefined;
  SpaceNameEquals?: string | undefined;
}
export interface ListAppsResponse {
  Apps?: AppDetails[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortArtifactsBy: {
  readonly CREATION_TIME: "CreationTime";
};
export type SortArtifactsBy =
  (typeof SortArtifactsBy)[keyof typeof SortArtifactsBy];
export interface ListArtifactsRequest {
  SourceUri?: string | undefined;
  ArtifactType?: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortArtifactsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListArtifactsResponse {
  ArtifactSummaries?: ArtifactSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortAssociationsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly DESTINATION_ARN: "DestinationArn";
  readonly DESTINATION_TYPE: "DestinationType";
  readonly SOURCE_ARN: "SourceArn";
  readonly SOURCE_TYPE: "SourceType";
};
export type SortAssociationsBy =
  (typeof SortAssociationsBy)[keyof typeof SortAssociationsBy];
export interface ListAssociationsRequest {
  SourceArn?: string | undefined;
  DestinationArn?: string | undefined;
  SourceType?: string | undefined;
  DestinationType?: string | undefined;
  AssociationType?: AssociationEdgeType | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortAssociationsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListAssociationsResponse {
  AssociationSummaries?: AssociationSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListAutoMLJobsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  StatusEquals?: AutoMLJobStatus | undefined;
  SortOrder?: AutoMLSortOrder | undefined;
  SortBy?: AutoMLSortBy | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListAutoMLJobsResponse {
  AutoMLJobSummaries: AutoMLJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListCandidatesForAutoMLJobRequest {
  AutoMLJobName: string | undefined;
  StatusEquals?: CandidateStatus | undefined;
  CandidateNameEquals?: string | undefined;
  SortOrder?: AutoMLSortOrder | undefined;
  SortBy?: CandidateSortBy | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListCandidatesForAutoMLJobResponse {
  Candidates: AutoMLCandidate[] | undefined;
  NextToken?: string | undefined;
}
export interface ListClusterEventsRequest {
  ClusterName: string | undefined;
  InstanceGroupName?: string | undefined;
  NodeId?: string | undefined;
  EventTimeAfter?: Date | undefined;
  EventTimeBefore?: Date | undefined;
  SortBy?: EventSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  ResourceType?: ClusterEventResourceType | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListClusterEventsResponse {
  NextToken?: string | undefined;
  Events?: ClusterEventSummary[] | undefined;
}
export interface ListClusterNodesRequest {
  ClusterName: string | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  InstanceGroupNameContains?: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: ClusterSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  IncludeNodeLogicalIds?: boolean | undefined;
}
export interface ListClusterNodesResponse {
  NextToken?: string | undefined;
  ClusterNodeSummaries: ClusterNodeSummary[] | undefined;
}
export interface ListClustersRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  SortBy?: ClusterSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  TrainingPlanArn?: string | undefined;
}
export interface ListClustersResponse {
  NextToken?: string | undefined;
  ClusterSummaries: ClusterSummary[] | undefined;
}
export declare const SortClusterSchedulerConfigBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type SortClusterSchedulerConfigBy =
  (typeof SortClusterSchedulerConfigBy)[keyof typeof SortClusterSchedulerConfigBy];
export interface ListClusterSchedulerConfigsRequest {
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  NameContains?: string | undefined;
  ClusterArn?: string | undefined;
  Status?: SchedulerResourceStatus | undefined;
  SortBy?: SortClusterSchedulerConfigBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListClusterSchedulerConfigsResponse {
  ClusterSchedulerConfigSummaries?: ClusterSchedulerConfigSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListCodeRepositoriesInput {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  SortBy?: CodeRepositorySortBy | undefined;
  SortOrder?: CodeRepositorySortOrder | undefined;
}
export interface ListCodeRepositoriesOutput {
  CodeRepositorySummaryList: CodeRepositorySummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListCompilationJobsSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type ListCompilationJobsSortBy =
  (typeof ListCompilationJobsSortBy)[keyof typeof ListCompilationJobsSortBy];
export interface ListCompilationJobsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  StatusEquals?: CompilationJobStatus | undefined;
  SortBy?: ListCompilationJobsSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListCompilationJobsResponse {
  CompilationJobSummaries: CompilationJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortQuotaBy: {
  readonly CLUSTER_ARN: "ClusterArn";
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type SortQuotaBy = (typeof SortQuotaBy)[keyof typeof SortQuotaBy];
export interface ListComputeQuotasRequest {
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  NameContains?: string | undefined;
  Status?: SchedulerResourceStatus | undefined;
  ClusterArn?: string | undefined;
  SortBy?: SortQuotaBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListComputeQuotasResponse {
  ComputeQuotaSummaries?: ComputeQuotaSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortContextsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortContextsBy =
  (typeof SortContextsBy)[keyof typeof SortContextsBy];
export interface ListContextsRequest {
  SourceUri?: string | undefined;
  ContextType?: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortContextsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListContextsResponse {
  ContextSummaries?: ContextSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const MonitoringJobDefinitionSortKey: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type MonitoringJobDefinitionSortKey =
  (typeof MonitoringJobDefinitionSortKey)[keyof typeof MonitoringJobDefinitionSortKey];
export interface ListDataQualityJobDefinitionsRequest {
  EndpointName?: string | undefined;
  SortBy?: MonitoringJobDefinitionSortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
}
export interface MonitoringJobDefinitionSummary {
  MonitoringJobDefinitionName: string | undefined;
  MonitoringJobDefinitionArn: string | undefined;
  CreationTime: Date | undefined;
  EndpointName: string | undefined;
}
export interface ListDataQualityJobDefinitionsResponse {
  JobDefinitionSummaries: MonitoringJobDefinitionSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListDeviceFleetsSortBy: {
  readonly CreationTime: "CREATION_TIME";
  readonly LastModifiedTime: "LAST_MODIFIED_TIME";
  readonly Name: "NAME";
};
export type ListDeviceFleetsSortBy =
  (typeof ListDeviceFleetsSortBy)[keyof typeof ListDeviceFleetsSortBy];
export interface ListDeviceFleetsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  SortBy?: ListDeviceFleetsSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListDeviceFleetsResponse {
  DeviceFleetSummaries: DeviceFleetSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListDevicesRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  LatestHeartbeatAfter?: Date | undefined;
  ModelName?: string | undefined;
  DeviceFleetName?: string | undefined;
}
export interface ListDevicesResponse {
  DeviceSummaries: DeviceSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListDomainsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListDomainsResponse {
  Domains?: DomainDetails[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListEdgeDeploymentPlansSortBy: {
  readonly CreationTime: "CREATION_TIME";
  readonly DeviceFleetName: "DEVICE_FLEET_NAME";
  readonly LastModifiedTime: "LAST_MODIFIED_TIME";
  readonly Name: "NAME";
};
export type ListEdgeDeploymentPlansSortBy =
  (typeof ListEdgeDeploymentPlansSortBy)[keyof typeof ListEdgeDeploymentPlansSortBy];
export interface ListEdgeDeploymentPlansRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  DeviceFleetNameContains?: string | undefined;
  SortBy?: ListEdgeDeploymentPlansSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListEdgeDeploymentPlansResponse {
  EdgeDeploymentPlanSummaries: EdgeDeploymentPlanSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListEdgePackagingJobsSortBy: {
  readonly CreationTime: "CREATION_TIME";
  readonly EdgePackagingJobStatus: "STATUS";
  readonly LastModifiedTime: "LAST_MODIFIED_TIME";
  readonly ModelName: "MODEL_NAME";
  readonly Name: "NAME";
};
export type ListEdgePackagingJobsSortBy =
  (typeof ListEdgePackagingJobsSortBy)[keyof typeof ListEdgePackagingJobsSortBy];
export interface ListEdgePackagingJobsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  ModelNameContains?: string | undefined;
  StatusEquals?: EdgePackagingJobStatus | undefined;
  SortBy?: ListEdgePackagingJobsSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListEdgePackagingJobsResponse {
  EdgePackagingJobSummaries: EdgePackagingJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const OrderKey: {
  readonly Ascending: "Ascending";
  readonly Descending: "Descending";
};
export type OrderKey = (typeof OrderKey)[keyof typeof OrderKey];
export interface ListEndpointConfigsInput {
  SortBy?: EndpointConfigSortKey | undefined;
  SortOrder?: OrderKey | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
}
export interface ListEndpointConfigsOutput {
  EndpointConfigs: EndpointConfigSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListEndpointsInput {
  SortBy?: EndpointSortKey | undefined;
  SortOrder?: OrderKey | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  StatusEquals?: EndpointStatus | undefined;
}
export interface ListEndpointsOutput {
  Endpoints: EndpointSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortExperimentsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortExperimentsBy =
  (typeof SortExperimentsBy)[keyof typeof SortExperimentsBy];
export interface ListExperimentsRequest {
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortExperimentsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListExperimentsResponse {
  ExperimentSummaries?: ExperimentSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListFeatureGroupsRequest {
  NameContains?: string | undefined;
  FeatureGroupStatusEquals?: FeatureGroupStatus | undefined;
  OfflineStoreStatusEquals?: OfflineStoreStatusValue | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  SortOrder?: FeatureGroupSortOrder | undefined;
  SortBy?: FeatureGroupSortBy | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListFeatureGroupsResponse {
  FeatureGroupSummaries: FeatureGroupSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListFlowDefinitionsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListFlowDefinitionsResponse {
  FlowDefinitionSummaries: FlowDefinitionSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListHubContentsRequest {
  HubName: string | undefined;
  HubContentType: HubContentType | undefined;
  NameContains?: string | undefined;
  MaxSchemaVersion?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  SortBy?: HubContentSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListHubContentsResponse {
  HubContentSummaries: HubContentInfo[] | undefined;
  NextToken?: string | undefined;
}
export interface ListHubContentVersionsRequest {
  HubName: string | undefined;
  HubContentType: HubContentType | undefined;
  HubContentName: string | undefined;
  MinVersion?: string | undefined;
  MaxSchemaVersion?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  SortBy?: HubContentSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListHubContentVersionsResponse {
  HubContentSummaries: HubContentInfo[] | undefined;
  NextToken?: string | undefined;
}
export interface ListHubsRequest {
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  SortBy?: HubSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListHubsResponse {
  HubSummaries: HubInfo[] | undefined;
  NextToken?: string | undefined;
}
export interface ListHumanTaskUisRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListHumanTaskUisResponse {
  HumanTaskUiSummaries: HumanTaskUiSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListHyperParameterTuningJobsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortBy?: HyperParameterTuningJobSortByOptions | undefined;
  SortOrder?: SortOrder | undefined;
  NameContains?: string | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  StatusEquals?: HyperParameterTuningJobStatus | undefined;
}
export interface ListHyperParameterTuningJobsResponse {
  HyperParameterTuningJobSummaries:
    | HyperParameterTuningJobSummary[]
    | undefined;
  NextToken?: string | undefined;
}
export interface ListImagesRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  SortBy?: ImageSortBy | undefined;
  SortOrder?: ImageSortOrder | undefined;
}
export interface ListImagesResponse {
  Images?: Image[] | undefined;
  NextToken?: string | undefined;
}
export interface ListImageVersionsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  ImageName: string | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: ImageVersionSortBy | undefined;
  SortOrder?: ImageVersionSortOrder | undefined;
}
export interface ListImageVersionsResponse {
  ImageVersions?: ImageVersion[] | undefined;
  NextToken?: string | undefined;
}
export interface ListInferenceComponentsInput {
  SortBy?: InferenceComponentSortKey | undefined;
  SortOrder?: OrderKey | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  StatusEquals?: InferenceComponentStatus | undefined;
  EndpointNameEquals?: string | undefined;
  VariantNameEquals?: string | undefined;
}
export interface ListInferenceComponentsOutput {
  InferenceComponents: InferenceComponentSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortInferenceExperimentsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type SortInferenceExperimentsBy =
  (typeof SortInferenceExperimentsBy)[keyof typeof SortInferenceExperimentsBy];
export interface ListInferenceExperimentsRequest {
  NameContains?: string | undefined;
  Type?: InferenceExperimentType | undefined;
  StatusEquals?: InferenceExperimentStatus | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  SortBy?: SortInferenceExperimentsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListInferenceExperimentsResponse {
  InferenceExperiments?: InferenceExperimentSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListInferenceRecommendationsJobsSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type ListInferenceRecommendationsJobsSortBy =
  (typeof ListInferenceRecommendationsJobsSortBy)[keyof typeof ListInferenceRecommendationsJobsSortBy];
export interface ListInferenceRecommendationsJobsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  StatusEquals?: RecommendationJobStatus | undefined;
  SortBy?: ListInferenceRecommendationsJobsSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  ModelNameEquals?: string | undefined;
  ModelPackageVersionArnEquals?: string | undefined;
}
export interface ListInferenceRecommendationsJobsResponse {
  InferenceRecommendationsJobs: InferenceRecommendationsJob[] | undefined;
  NextToken?: string | undefined;
}
export interface ListInferenceRecommendationsJobStepsRequest {
  JobName: string | undefined;
  Status?: RecommendationJobStatus | undefined;
  StepType?: RecommendationStepType | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListInferenceRecommendationsJobStepsResponse {
  Steps?: InferenceRecommendationsJobStep[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type SortBy = (typeof SortBy)[keyof typeof SortBy];
export interface ListLabelingJobsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  NameContains?: string | undefined;
  SortBy?: SortBy | undefined;
  SortOrder?: SortOrder | undefined;
  StatusEquals?: LabelingJobStatus | undefined;
}
export interface ListLabelingJobsResponse {
  LabelingJobSummaryList?: LabelingJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListLabelingJobsForWorkteamSortByOptions: {
  readonly CREATION_TIME: "CreationTime";
};
export type ListLabelingJobsForWorkteamSortByOptions =
  (typeof ListLabelingJobsForWorkteamSortByOptions)[keyof typeof ListLabelingJobsForWorkteamSortByOptions];
export interface ListLabelingJobsForWorkteamRequest {
  WorkteamArn: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  JobReferenceCodeContains?: string | undefined;
  SortBy?: ListLabelingJobsForWorkteamSortByOptions | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListLabelingJobsForWorkteamResponse {
  LabelingJobSummaryList: LabelingJobForWorkteamSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortLineageGroupsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortLineageGroupsBy =
  (typeof SortLineageGroupsBy)[keyof typeof SortLineageGroupsBy];
export interface ListLineageGroupsRequest {
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortLineageGroupsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListLineageGroupsResponse {
  LineageGroupSummaries?: LineageGroupSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortTrackingServerBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type SortTrackingServerBy =
  (typeof SortTrackingServerBy)[keyof typeof SortTrackingServerBy];
export interface ListMlflowTrackingServersRequest {
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  TrackingServerStatus?: TrackingServerStatus | undefined;
  MlflowVersion?: string | undefined;
  SortBy?: SortTrackingServerBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface TrackingServerSummary {
  TrackingServerArn?: string | undefined;
  TrackingServerName?: string | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  TrackingServerStatus?: TrackingServerStatus | undefined;
  IsActive?: IsTrackingServerActive | undefined;
  MlflowVersion?: string | undefined;
}
export interface ListMlflowTrackingServersResponse {
  TrackingServerSummaries?: TrackingServerSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListModelBiasJobDefinitionsRequest {
  EndpointName?: string | undefined;
  SortBy?: MonitoringJobDefinitionSortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
}
export interface ListModelBiasJobDefinitionsResponse {
  JobDefinitionSummaries: MonitoringJobDefinitionSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelCardExportJobSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type ModelCardExportJobSortBy =
  (typeof ModelCardExportJobSortBy)[keyof typeof ModelCardExportJobSortBy];
export declare const ModelCardExportJobSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type ModelCardExportJobSortOrder =
  (typeof ModelCardExportJobSortOrder)[keyof typeof ModelCardExportJobSortOrder];
export interface ListModelCardExportJobsRequest {
  ModelCardName: string | undefined;
  ModelCardVersion?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  ModelCardExportJobNameContains?: string | undefined;
  StatusEquals?: ModelCardExportJobStatus | undefined;
  SortBy?: ModelCardExportJobSortBy | undefined;
  SortOrder?: ModelCardExportJobSortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ModelCardExportJobSummary {
  ModelCardExportJobName: string | undefined;
  ModelCardExportJobArn: string | undefined;
  Status: ModelCardExportJobStatus | undefined;
  ModelCardName: string | undefined;
  ModelCardVersion: number | undefined;
  CreatedAt: Date | undefined;
  LastModifiedAt: Date | undefined;
}
export interface ListModelCardExportJobsResponse {
  ModelCardExportJobSummaries: ModelCardExportJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelCardSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type ModelCardSortBy =
  (typeof ModelCardSortBy)[keyof typeof ModelCardSortBy];
export declare const ModelCardSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type ModelCardSortOrder =
  (typeof ModelCardSortOrder)[keyof typeof ModelCardSortOrder];
export interface ListModelCardsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  ModelCardStatus?: ModelCardStatus | undefined;
  NextToken?: string | undefined;
  SortBy?: ModelCardSortBy | undefined;
  SortOrder?: ModelCardSortOrder | undefined;
}
export interface ModelCardSummary {
  ModelCardName: string | undefined;
  ModelCardArn: string | undefined;
  ModelCardStatus: ModelCardStatus | undefined;
  CreationTime: Date | undefined;
  LastModifiedTime?: Date | undefined;
}
export interface ListModelCardsResponse {
  ModelCardSummaries: ModelCardSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelCardVersionSortBy: {
  readonly VERSION: "Version";
};
export type ModelCardVersionSortBy =
  (typeof ModelCardVersionSortBy)[keyof typeof ModelCardVersionSortBy];
export interface ListModelCardVersionsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  ModelCardName: string | undefined;
  ModelCardStatus?: ModelCardStatus | undefined;
  NextToken?: string | undefined;
  SortBy?: ModelCardVersionSortBy | undefined;
  SortOrder?: ModelCardSortOrder | undefined;
}
export interface ModelCardVersionSummary {
  ModelCardName: string | undefined;
  ModelCardArn: string | undefined;
  ModelCardStatus: ModelCardStatus | undefined;
  ModelCardVersion: number | undefined;
  CreationTime: Date | undefined;
  LastModifiedTime?: Date | undefined;
}
export interface ListModelCardVersionsResponse {
  ModelCardVersionSummaryList: ModelCardVersionSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListModelExplainabilityJobDefinitionsRequest {
  EndpointName?: string | undefined;
  SortBy?: MonitoringJobDefinitionSortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
}
export interface ListModelExplainabilityJobDefinitionsResponse {
  JobDefinitionSummaries: MonitoringJobDefinitionSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelMetadataFilterType: {
  readonly DOMAIN: "Domain";
  readonly FRAMEWORK: "Framework";
  readonly FRAMEWORKVERSION: "FrameworkVersion";
  readonly TASK: "Task";
};
export type ModelMetadataFilterType =
  (typeof ModelMetadataFilterType)[keyof typeof ModelMetadataFilterType];
export interface ModelMetadataFilter {
  Name: ModelMetadataFilterType | undefined;
  Value: string | undefined;
}
export interface ModelMetadataSearchExpression {
  Filters?: ModelMetadataFilter[] | undefined;
}
export interface ListModelMetadataRequest {
  SearchExpression?: ModelMetadataSearchExpression | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ModelMetadataSummary {
  Domain: string | undefined;
  Framework: string | undefined;
  Task: string | undefined;
  Model: string | undefined;
  FrameworkVersion: string | undefined;
}
export interface ListModelMetadataResponse {
  ModelMetadataSummaries: ModelMetadataSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelPackageGroupSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type ModelPackageGroupSortBy =
  (typeof ModelPackageGroupSortBy)[keyof typeof ModelPackageGroupSortBy];
export interface ListModelPackageGroupsInput {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  SortBy?: ModelPackageGroupSortBy | undefined;
  SortOrder?: SortOrder | undefined;
  CrossAccountFilterOption?: CrossAccountFilterOption | undefined;
}
export interface ModelPackageGroupSummary {
  ModelPackageGroupName: string | undefined;
  ModelPackageGroupArn: string | undefined;
  ModelPackageGroupDescription?: string | undefined;
  CreationTime: Date | undefined;
  ModelPackageGroupStatus: ModelPackageGroupStatus | undefined;
}
export interface ListModelPackageGroupsOutput {
  ModelPackageGroupSummaryList: ModelPackageGroupSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelPackageType: {
  readonly BOTH: "Both";
  readonly UNVERSIONED: "Unversioned";
  readonly VERSIONED: "Versioned";
};
export type ModelPackageType =
  (typeof ModelPackageType)[keyof typeof ModelPackageType];
export declare const ModelPackageSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type ModelPackageSortBy =
  (typeof ModelPackageSortBy)[keyof typeof ModelPackageSortBy];
export interface ListModelPackagesInput {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  ModelApprovalStatus?: ModelApprovalStatus | undefined;
  ModelPackageGroupName?: string | undefined;
  ModelPackageType?: ModelPackageType | undefined;
  NextToken?: string | undefined;
  SortBy?: ModelPackageSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ModelPackageSummary {
  ModelPackageName?: string | undefined;
  ModelPackageGroupName?: string | undefined;
  ModelPackageVersion?: number | undefined;
  ModelPackageArn: string | undefined;
  ModelPackageDescription?: string | undefined;
  CreationTime: Date | undefined;
  ModelPackageStatus: ModelPackageStatus | undefined;
  ModelApprovalStatus?: ModelApprovalStatus | undefined;
  ModelLifeCycle?: ModelLifeCycle | undefined;
}
export interface ListModelPackagesOutput {
  ModelPackageSummaryList: ModelPackageSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListModelQualityJobDefinitionsRequest {
  EndpointName?: string | undefined;
  SortBy?: MonitoringJobDefinitionSortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
}
export interface ListModelQualityJobDefinitionsResponse {
  JobDefinitionSummaries: MonitoringJobDefinitionSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ModelSortKey: {
  readonly CreationTime: "CreationTime";
  readonly Name: "Name";
};
export type ModelSortKey = (typeof ModelSortKey)[keyof typeof ModelSortKey];
export interface ListModelsInput {
  SortBy?: ModelSortKey | undefined;
  SortOrder?: OrderKey | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
}
export interface ModelSummary {
  ModelName: string | undefined;
  ModelArn: string | undefined;
  CreationTime: Date | undefined;
}
export interface ListModelsOutput {
  Models: ModelSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const MonitoringAlertHistorySortKey: {
  readonly CreationTime: "CreationTime";
  readonly Status: "Status";
};
export type MonitoringAlertHistorySortKey =
  (typeof MonitoringAlertHistorySortKey)[keyof typeof MonitoringAlertHistorySortKey];
export declare const MonitoringAlertStatus: {
  readonly IN_ALERT: "InAlert";
  readonly OK: "OK";
};
export type MonitoringAlertStatus =
  (typeof MonitoringAlertStatus)[keyof typeof MonitoringAlertStatus];
export interface ListMonitoringAlertHistoryRequest {
  MonitoringScheduleName?: string | undefined;
  MonitoringAlertName?: string | undefined;
  SortBy?: MonitoringAlertHistorySortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  StatusEquals?: MonitoringAlertStatus | undefined;
}
export interface MonitoringAlertHistorySummary {
  MonitoringScheduleName: string | undefined;
  MonitoringAlertName: string | undefined;
  CreationTime: Date | undefined;
  AlertStatus: MonitoringAlertStatus | undefined;
}
export interface ListMonitoringAlertHistoryResponse {
  MonitoringAlertHistory?: MonitoringAlertHistorySummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListMonitoringAlertsRequest {
  MonitoringScheduleName: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ModelDashboardIndicatorAction {
  Enabled?: boolean | undefined;
}
export interface MonitoringAlertActions {
  ModelDashboardIndicator?: ModelDashboardIndicatorAction | undefined;
}
export interface MonitoringAlertSummary {
  MonitoringAlertName: string | undefined;
  CreationTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  AlertStatus: MonitoringAlertStatus | undefined;
  DatapointsToAlert: number | undefined;
  EvaluationPeriod: number | undefined;
  Actions: MonitoringAlertActions | undefined;
}
export interface ListMonitoringAlertsResponse {
  MonitoringAlertSummaries?: MonitoringAlertSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const MonitoringExecutionSortKey: {
  readonly CREATION_TIME: "CreationTime";
  readonly SCHEDULED_TIME: "ScheduledTime";
  readonly STATUS: "Status";
};
export type MonitoringExecutionSortKey =
  (typeof MonitoringExecutionSortKey)[keyof typeof MonitoringExecutionSortKey];
export interface ListMonitoringExecutionsRequest {
  MonitoringScheduleName?: string | undefined;
  EndpointName?: string | undefined;
  SortBy?: MonitoringExecutionSortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  ScheduledTimeBefore?: Date | undefined;
  ScheduledTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  StatusEquals?: ExecutionStatus | undefined;
  MonitoringJobDefinitionName?: string | undefined;
  MonitoringTypeEquals?: MonitoringType | undefined;
}
export interface ListMonitoringExecutionsResponse {
  MonitoringExecutionSummaries: MonitoringExecutionSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const MonitoringScheduleSortKey: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type MonitoringScheduleSortKey =
  (typeof MonitoringScheduleSortKey)[keyof typeof MonitoringScheduleSortKey];
export interface ListMonitoringSchedulesRequest {
  EndpointName?: string | undefined;
  SortBy?: MonitoringScheduleSortKey | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  StatusEquals?: ScheduleStatus | undefined;
  MonitoringJobDefinitionName?: string | undefined;
  MonitoringTypeEquals?: MonitoringType | undefined;
}
export interface MonitoringScheduleSummary {
  MonitoringScheduleName: string | undefined;
  MonitoringScheduleArn: string | undefined;
  CreationTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  MonitoringScheduleStatus: ScheduleStatus | undefined;
  EndpointName?: string | undefined;
  MonitoringJobDefinitionName?: string | undefined;
  MonitoringType?: MonitoringType | undefined;
}
export interface ListMonitoringSchedulesResponse {
  MonitoringScheduleSummaries: MonitoringScheduleSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const NotebookInstanceLifecycleConfigSortKey: {
  readonly CREATION_TIME: "CreationTime";
  readonly LAST_MODIFIED_TIME: "LastModifiedTime";
  readonly NAME: "Name";
};
export type NotebookInstanceLifecycleConfigSortKey =
  (typeof NotebookInstanceLifecycleConfigSortKey)[keyof typeof NotebookInstanceLifecycleConfigSortKey];
export declare const NotebookInstanceLifecycleConfigSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type NotebookInstanceLifecycleConfigSortOrder =
  (typeof NotebookInstanceLifecycleConfigSortOrder)[keyof typeof NotebookInstanceLifecycleConfigSortOrder];
export interface ListNotebookInstanceLifecycleConfigsInput {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortBy?: NotebookInstanceLifecycleConfigSortKey | undefined;
  SortOrder?: NotebookInstanceLifecycleConfigSortOrder | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
}
export interface NotebookInstanceLifecycleConfigSummary {
  NotebookInstanceLifecycleConfigName: string | undefined;
  NotebookInstanceLifecycleConfigArn: string | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
}
export interface ListNotebookInstanceLifecycleConfigsOutput {
  NextToken?: string | undefined;
  NotebookInstanceLifecycleConfigs?:
    | NotebookInstanceLifecycleConfigSummary[]
    | undefined;
}
export declare const NotebookInstanceSortKey: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type NotebookInstanceSortKey =
  (typeof NotebookInstanceSortKey)[keyof typeof NotebookInstanceSortKey];
export declare const NotebookInstanceSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type NotebookInstanceSortOrder =
  (typeof NotebookInstanceSortOrder)[keyof typeof NotebookInstanceSortOrder];
export interface ListNotebookInstancesInput {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortBy?: NotebookInstanceSortKey | undefined;
  SortOrder?: NotebookInstanceSortOrder | undefined;
  NameContains?: string | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  StatusEquals?: NotebookInstanceStatus | undefined;
  NotebookInstanceLifecycleConfigNameContains?: string | undefined;
  DefaultCodeRepositoryContains?: string | undefined;
  AdditionalCodeRepositoryEquals?: string | undefined;
}
export interface NotebookInstanceSummary {
  NotebookInstanceName: string | undefined;
  NotebookInstanceArn: string | undefined;
  NotebookInstanceStatus?: NotebookInstanceStatus | undefined;
  Url?: string | undefined;
  InstanceType?: _InstanceType | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  NotebookInstanceLifecycleConfigName?: string | undefined;
  DefaultCodeRepository?: string | undefined;
  AdditionalCodeRepositories?: string[] | undefined;
}
export interface ListNotebookInstancesOutput {
  NextToken?: string | undefined;
  NotebookInstances?: NotebookInstanceSummary[] | undefined;
}
export declare const ListOptimizationJobsSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
  readonly STATUS: "Status";
};
export type ListOptimizationJobsSortBy =
  (typeof ListOptimizationJobsSortBy)[keyof typeof ListOptimizationJobsSortBy];
export interface ListOptimizationJobsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  OptimizationContains?: string | undefined;
  NameContains?: string | undefined;
  StatusEquals?: OptimizationJobStatus | undefined;
  SortBy?: ListOptimizationJobsSortBy | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface OptimizationJobSummary {
  OptimizationJobName: string | undefined;
  OptimizationJobArn: string | undefined;
  CreationTime: Date | undefined;
  OptimizationJobStatus: OptimizationJobStatus | undefined;
  OptimizationStartTime?: Date | undefined;
  OptimizationEndTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  DeploymentInstanceType: OptimizationJobDeploymentInstanceType | undefined;
  OptimizationTypes: string[] | undefined;
}
export interface ListOptimizationJobsResponse {
  OptimizationJobSummaries: OptimizationJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListPartnerAppsRequest {
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface PartnerAppSummary {
  Arn?: string | undefined;
  Name?: string | undefined;
  Type?: PartnerAppType | undefined;
  Status?: PartnerAppStatus | undefined;
  CreationTime?: Date | undefined;
}
export interface ListPartnerAppsResponse {
  Summaries?: PartnerAppSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortPipelineExecutionsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly PIPELINE_EXECUTION_ARN: "PipelineExecutionArn";
};
export type SortPipelineExecutionsBy =
  (typeof SortPipelineExecutionsBy)[keyof typeof SortPipelineExecutionsBy];
export interface ListPipelineExecutionsRequest {
  PipelineName: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortPipelineExecutionsBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface PipelineExecutionSummary {
  PipelineExecutionArn?: string | undefined;
  StartTime?: Date | undefined;
  PipelineExecutionStatus?: PipelineExecutionStatus | undefined;
  PipelineExecutionDescription?: string | undefined;
  PipelineExecutionDisplayName?: string | undefined;
  PipelineExecutionFailureReason?: string | undefined;
}
export interface ListPipelineExecutionsResponse {
  PipelineExecutionSummaries?: PipelineExecutionSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListPipelineExecutionStepsRequest {
  PipelineExecutionArn?: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ModelStepMetadata {
  Arn?: string | undefined;
}
export interface ProcessingJobStepMetadata {
  Arn?: string | undefined;
}
export interface QualityCheckStepMetadata {
  CheckType?: string | undefined;
  BaselineUsedForDriftCheckStatistics?: string | undefined;
  BaselineUsedForDriftCheckConstraints?: string | undefined;
  CalculatedBaselineStatistics?: string | undefined;
  CalculatedBaselineConstraints?: string | undefined;
  ModelPackageGroupName?: string | undefined;
  ViolationReport?: string | undefined;
  CheckJobArn?: string | undefined;
  SkipCheck?: boolean | undefined;
  RegisterNewBaseline?: boolean | undefined;
}
export interface RegisterModelStepMetadata {
  Arn?: string | undefined;
}
export interface TrainingJobStepMetadata {
  Arn?: string | undefined;
}
export interface TransformJobStepMetadata {
  Arn?: string | undefined;
}
export interface TuningJobStepMetaData {
  Arn?: string | undefined;
}
export interface PipelineExecutionStepMetadata {
  TrainingJob?: TrainingJobStepMetadata | undefined;
  ProcessingJob?: ProcessingJobStepMetadata | undefined;
  TransformJob?: TransformJobStepMetadata | undefined;
  TuningJob?: TuningJobStepMetaData | undefined;
  Model?: ModelStepMetadata | undefined;
  RegisterModel?: RegisterModelStepMetadata | undefined;
  Condition?: ConditionStepMetadata | undefined;
  Callback?: CallbackStepMetadata | undefined;
  Lambda?: LambdaStepMetadata | undefined;
  EMR?: EMRStepMetadata | undefined;
  QualityCheck?: QualityCheckStepMetadata | undefined;
  ClarifyCheck?: ClarifyCheckStepMetadata | undefined;
  Fail?: FailStepMetadata | undefined;
  AutoMLJob?: AutoMLJobStepMetadata | undefined;
  Endpoint?: EndpointStepMetadata | undefined;
  EndpointConfig?: EndpointConfigStepMetadata | undefined;
}
export interface SelectiveExecutionResult {
  SourcePipelineExecutionArn?: string | undefined;
}
export declare const StepStatus: {
  readonly EXECUTING: "Executing";
  readonly FAILED: "Failed";
  readonly STARTING: "Starting";
  readonly STOPPED: "Stopped";
  readonly STOPPING: "Stopping";
  readonly SUCCEEDED: "Succeeded";
};
export type StepStatus = (typeof StepStatus)[keyof typeof StepStatus];
export interface PipelineExecutionStep {
  StepName?: string | undefined;
  StepDisplayName?: string | undefined;
  StepDescription?: string | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  StepStatus?: StepStatus | undefined;
  CacheHitResult?: CacheHitResult | undefined;
  FailureReason?: string | undefined;
  Metadata?: PipelineExecutionStepMetadata | undefined;
  AttemptCount?: number | undefined;
  SelectiveExecutionResult?: SelectiveExecutionResult | undefined;
}
export interface ListPipelineExecutionStepsResponse {
  PipelineExecutionSteps?: PipelineExecutionStep[] | undefined;
  NextToken?: string | undefined;
}
export interface ListPipelineParametersForExecutionRequest {
  PipelineExecutionArn: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface Parameter {
  Name: string | undefined;
  Value: string | undefined;
}
export interface ListPipelineParametersForExecutionResponse {
  PipelineParameters?: Parameter[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortPipelinesBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortPipelinesBy =
  (typeof SortPipelinesBy)[keyof typeof SortPipelinesBy];
export interface ListPipelinesRequest {
  PipelineNamePrefix?: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortPipelinesBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface PipelineSummary {
  PipelineArn?: string | undefined;
  PipelineName?: string | undefined;
  PipelineDisplayName?: string | undefined;
  PipelineDescription?: string | undefined;
  RoleArn?: string | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  LastExecutionTime?: Date | undefined;
}
export interface ListPipelinesResponse {
  PipelineSummaries?: PipelineSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListPipelineVersionsRequest {
  PipelineName: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface PipelineVersionSummary {
  PipelineArn?: string | undefined;
  PipelineVersionId?: number | undefined;
  CreationTime?: Date | undefined;
  PipelineVersionDescription?: string | undefined;
  PipelineVersionDisplayName?: string | undefined;
  LastExecutionPipelineExecutionArn?: string | undefined;
}
export interface ListPipelineVersionsResponse {
  PipelineVersionSummaries?: PipelineVersionSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListProcessingJobsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  StatusEquals?: ProcessingJobStatus | undefined;
  SortBy?: SortBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ProcessingJobSummary {
  ProcessingJobName: string | undefined;
  ProcessingJobArn: string | undefined;
  CreationTime: Date | undefined;
  ProcessingEndTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  ProcessingJobStatus: ProcessingJobStatus | undefined;
  FailureReason?: string | undefined;
  ExitMessage?: string | undefined;
}
export interface ListProcessingJobsResponse {
  ProcessingJobSummaries: ProcessingJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ProjectSortBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type ProjectSortBy = (typeof ProjectSortBy)[keyof typeof ProjectSortBy];
export declare const ProjectSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type ProjectSortOrder =
  (typeof ProjectSortOrder)[keyof typeof ProjectSortOrder];
export interface ListProjectsInput {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  MaxResults?: number | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  SortBy?: ProjectSortBy | undefined;
  SortOrder?: ProjectSortOrder | undefined;
}
export interface ProjectSummary {
  ProjectName: string | undefined;
  ProjectDescription?: string | undefined;
  ProjectArn: string | undefined;
  ProjectId: string | undefined;
  CreationTime: Date | undefined;
  ProjectStatus: ProjectStatus | undefined;
}
export interface ListProjectsOutput {
  ProjectSummaryList: ProjectSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const ResourceCatalogSortBy: {
  readonly CREATION_TIME: "CreationTime";
};
export type ResourceCatalogSortBy =
  (typeof ResourceCatalogSortBy)[keyof typeof ResourceCatalogSortBy];
export declare const ResourceCatalogSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type ResourceCatalogSortOrder =
  (typeof ResourceCatalogSortOrder)[keyof typeof ResourceCatalogSortOrder];
export interface ListResourceCatalogsRequest {
  NameContains?: string | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  SortOrder?: ResourceCatalogSortOrder | undefined;
  SortBy?: ResourceCatalogSortBy | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ResourceCatalog {
  ResourceCatalogArn: string | undefined;
  ResourceCatalogName: string | undefined;
  Description: string | undefined;
  CreationTime: Date | undefined;
}
export interface ListResourceCatalogsResponse {
  ResourceCatalogs?: ResourceCatalog[] | undefined;
  NextToken?: string | undefined;
}
export declare const SpaceSortKey: {
  readonly CreationTime: "CreationTime";
  readonly LastModifiedTime: "LastModifiedTime";
};
export type SpaceSortKey = (typeof SpaceSortKey)[keyof typeof SpaceSortKey];
export interface ListSpacesRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortOrder?: SortOrder | undefined;
  SortBy?: SpaceSortKey | undefined;
  DomainIdEquals?: string | undefined;
  SpaceNameContains?: string | undefined;
}
export interface OwnershipSettingsSummary {
  OwnerUserProfileName?: string | undefined;
}
export interface SpaceSettingsSummary {
  AppType?: AppType | undefined;
  RemoteAccess?: FeatureStatus | undefined;
  SpaceStorageSettings?: SpaceStorageSettings | undefined;
}
export interface SpaceSharingSettingsSummary {
  SharingType?: SharingType | undefined;
}
export interface SpaceDetails {
  DomainId?: string | undefined;
  SpaceName?: string | undefined;
  Status?: SpaceStatus | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  SpaceSettingsSummary?: SpaceSettingsSummary | undefined;
  SpaceSharingSettingsSummary?: SpaceSharingSettingsSummary | undefined;
  OwnershipSettingsSummary?: OwnershipSettingsSummary | undefined;
  SpaceDisplayName?: string | undefined;
}
export interface ListSpacesResponse {
  Spaces?: SpaceDetails[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStageDevicesRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  EdgeDeploymentPlanName: string | undefined;
  ExcludeDevicesDeployedInOtherStage?: boolean | undefined;
  StageName: string | undefined;
}
export interface ListStageDevicesResponse {
  DeviceDeploymentSummaries: DeviceDeploymentSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const StudioLifecycleConfigSortKey: {
  readonly CreationTime: "CreationTime";
  readonly LastModifiedTime: "LastModifiedTime";
  readonly Name: "Name";
};
export type StudioLifecycleConfigSortKey =
  (typeof StudioLifecycleConfigSortKey)[keyof typeof StudioLifecycleConfigSortKey];
export interface ListStudioLifecycleConfigsRequest {
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  NameContains?: string | undefined;
  AppTypeEquals?: StudioLifecycleConfigAppType | undefined;
  CreationTimeBefore?: Date | undefined;
  CreationTimeAfter?: Date | undefined;
  ModifiedTimeBefore?: Date | undefined;
  ModifiedTimeAfter?: Date | undefined;
  SortBy?: StudioLifecycleConfigSortKey | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface StudioLifecycleConfigDetails {
  StudioLifecycleConfigArn?: string | undefined;
  StudioLifecycleConfigName?: string | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  StudioLifecycleConfigAppType?: StudioLifecycleConfigAppType | undefined;
}
export interface ListStudioLifecycleConfigsResponse {
  NextToken?: string | undefined;
  StudioLifecycleConfigs?: StudioLifecycleConfigDetails[] | undefined;
}
export interface ListSubscribedWorkteamsRequest {
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListSubscribedWorkteamsResponse {
  SubscribedWorkteams: SubscribedWorkteam[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTagsInput {
  ResourceArn: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListTagsOutput {
  Tags?: Tag[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTrainingJobsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  StatusEquals?: TrainingJobStatus | undefined;
  SortBy?: SortBy | undefined;
  SortOrder?: SortOrder | undefined;
  WarmPoolStatusEquals?: WarmPoolResourceStatus | undefined;
  TrainingPlanArnEquals?: string | undefined;
}
export interface TrainingJobSummary {
  TrainingJobName: string | undefined;
  TrainingJobArn: string | undefined;
  CreationTime: Date | undefined;
  TrainingEndTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  TrainingJobStatus: TrainingJobStatus | undefined;
  SecondaryStatus?: SecondaryStatus | undefined;
  WarmPoolStatus?: WarmPoolStatus | undefined;
  TrainingPlanArn?: string | undefined;
}
export interface ListTrainingJobsResponse {
  TrainingJobSummaries: TrainingJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const TrainingJobSortByOptions: {
  readonly CreationTime: "CreationTime";
  readonly FinalObjectiveMetricValue: "FinalObjectiveMetricValue";
  readonly Name: "Name";
  readonly Status: "Status";
};
export type TrainingJobSortByOptions =
  (typeof TrainingJobSortByOptions)[keyof typeof TrainingJobSortByOptions];
export interface ListTrainingJobsForHyperParameterTuningJobRequest {
  HyperParameterTuningJobName: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  StatusEquals?: TrainingJobStatus | undefined;
  SortBy?: TrainingJobSortByOptions | undefined;
  SortOrder?: SortOrder | undefined;
}
export interface ListTrainingJobsForHyperParameterTuningJobResponse {
  TrainingJobSummaries: HyperParameterTrainingJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const TrainingPlanFilterName: {
  readonly STATUS: "Status";
};
export type TrainingPlanFilterName =
  (typeof TrainingPlanFilterName)[keyof typeof TrainingPlanFilterName];
export interface TrainingPlanFilter {
  Name: TrainingPlanFilterName | undefined;
  Value: string | undefined;
}
export declare const TrainingPlanSortBy: {
  readonly NAME: "TrainingPlanName";
  readonly START_TIME: "StartTime";
  readonly STATUS: "Status";
};
export type TrainingPlanSortBy =
  (typeof TrainingPlanSortBy)[keyof typeof TrainingPlanSortBy];
export declare const TrainingPlanSortOrder: {
  readonly ASCENDING: "Ascending";
  readonly DESCENDING: "Descending";
};
export type TrainingPlanSortOrder =
  (typeof TrainingPlanSortOrder)[keyof typeof TrainingPlanSortOrder];
export interface ListTrainingPlansRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  StartTimeAfter?: Date | undefined;
  StartTimeBefore?: Date | undefined;
  SortBy?: TrainingPlanSortBy | undefined;
  SortOrder?: TrainingPlanSortOrder | undefined;
  Filters?: TrainingPlanFilter[] | undefined;
}
export interface TrainingPlanSummary {
  TrainingPlanArn: string | undefined;
  TrainingPlanName: string | undefined;
  Status: TrainingPlanStatus | undefined;
  StatusMessage?: string | undefined;
  DurationHours?: number | undefined;
  DurationMinutes?: number | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  UpfrontFee?: string | undefined;
  CurrencyCode?: string | undefined;
  TotalInstanceCount?: number | undefined;
  AvailableInstanceCount?: number | undefined;
  InUseInstanceCount?: number | undefined;
  TotalUltraServerCount?: number | undefined;
  TargetResources?: SageMakerResourceName[] | undefined;
  ReservedCapacitySummaries?: ReservedCapacitySummary[] | undefined;
}
export interface ListTrainingPlansResponse {
  NextToken?: string | undefined;
  TrainingPlanSummaries: TrainingPlanSummary[] | undefined;
}
export interface ListTransformJobsRequest {
  CreationTimeAfter?: Date | undefined;
  CreationTimeBefore?: Date | undefined;
  LastModifiedTimeAfter?: Date | undefined;
  LastModifiedTimeBefore?: Date | undefined;
  NameContains?: string | undefined;
  StatusEquals?: TransformJobStatus | undefined;
  SortBy?: SortBy | undefined;
  SortOrder?: SortOrder | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface TransformJobSummary {
  TransformJobName: string | undefined;
  TransformJobArn: string | undefined;
  CreationTime: Date | undefined;
  TransformEndTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  TransformJobStatus: TransformJobStatus | undefined;
  FailureReason?: string | undefined;
}
export interface ListTransformJobsResponse {
  TransformJobSummaries: TransformJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortTrialComponentsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortTrialComponentsBy =
  (typeof SortTrialComponentsBy)[keyof typeof SortTrialComponentsBy];
export interface ListTrialComponentsRequest {
  ExperimentName?: string | undefined;
  TrialName?: string | undefined;
  SourceArn?: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortTrialComponentsBy | undefined;
  SortOrder?: SortOrder | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface TrialComponentSummary {
  TrialComponentName?: string | undefined;
  TrialComponentArn?: string | undefined;
  DisplayName?: string | undefined;
  TrialComponentSource?: TrialComponentSource | undefined;
  Status?: TrialComponentStatus | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  CreationTime?: Date | undefined;
  CreatedBy?: UserContext | undefined;
  LastModifiedTime?: Date | undefined;
  LastModifiedBy?: UserContext | undefined;
}
export interface ListTrialComponentsResponse {
  TrialComponentSummaries?: TrialComponentSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const SortTrialsBy: {
  readonly CREATION_TIME: "CreationTime";
  readonly NAME: "Name";
};
export type SortTrialsBy = (typeof SortTrialsBy)[keyof typeof SortTrialsBy];
export interface ListTrialsRequest {
  ExperimentName?: string | undefined;
  TrialComponentName?: string | undefined;
  CreatedAfter?: Date | undefined;
  CreatedBefore?: Date | undefined;
  SortBy?: SortTrialsBy | undefined;
  SortOrder?: SortOrder | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface TrialSummary {
  TrialArn?: string | undefined;
  TrialName?: string | undefined;
  DisplayName?: string | undefined;
  TrialSource?: TrialSource | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
}
export interface ListTrialsResponse {
  TrialSummaries?: TrialSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListUltraServersByReservedCapacityRequest {
  ReservedCapacityArn: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export declare const UltraServerHealthStatus: {
  readonly IMPAIRED: "Impaired";
  readonly INSUFFICIENT_DATA: "Insufficient-Data";
  readonly OK: "OK";
};
export type UltraServerHealthStatus =
  (typeof UltraServerHealthStatus)[keyof typeof UltraServerHealthStatus];
export interface UltraServer {
  UltraServerId: string | undefined;
  UltraServerType: string | undefined;
  AvailabilityZone: string | undefined;
  InstanceType: ReservedCapacityInstanceType | undefined;
  TotalInstanceCount: number | undefined;
  ConfiguredSpareInstanceCount?: number | undefined;
  AvailableInstanceCount?: number | undefined;
  InUseInstanceCount?: number | undefined;
  AvailableSpareInstanceCount?: number | undefined;
  UnhealthyInstanceCount?: number | undefined;
  HealthStatus?: UltraServerHealthStatus | undefined;
}
export interface ListUltraServersByReservedCapacityResponse {
  NextToken?: string | undefined;
  UltraServers: UltraServer[] | undefined;
}
export declare const UserProfileSortKey: {
  readonly CreationTime: "CreationTime";
  readonly LastModifiedTime: "LastModifiedTime";
};
export type UserProfileSortKey =
  (typeof UserProfileSortKey)[keyof typeof UserProfileSortKey];
export interface ListUserProfilesRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  SortOrder?: SortOrder | undefined;
  SortBy?: UserProfileSortKey | undefined;
  DomainIdEquals?: string | undefined;
  UserProfileNameContains?: string | undefined;
}
export interface UserProfileDetails {
  DomainId?: string | undefined;
  UserProfileName?: string | undefined;
  Status?: UserProfileStatus | undefined;
  CreationTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
}
export interface ListUserProfilesResponse {
  UserProfiles?: UserProfileDetails[] | undefined;
  NextToken?: string | undefined;
}
export declare const ListWorkforcesSortByOptions: {
  readonly CreateDate: "CreateDate";
  readonly Name: "Name";
};
export type ListWorkforcesSortByOptions =
  (typeof ListWorkforcesSortByOptions)[keyof typeof ListWorkforcesSortByOptions];
export interface ListWorkforcesRequest {
  SortBy?: ListWorkforcesSortByOptions | undefined;
  SortOrder?: SortOrder | undefined;
  NameContains?: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
