import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  AddAssociationCommandInput,
  AddAssociationCommandOutput,
} from "./commands/AddAssociationCommand";
import {
  AddTagsCommandInput,
  AddTagsCommandOutput,
} from "./commands/AddTagsCommand";
import {
  AssociateTrialComponentCommandInput,
  AssociateTrialComponentCommandOutput,
} from "./commands/AssociateTrialComponentCommand";
import {
  AttachClusterNodeVolumeCommandInput,
  AttachClusterNodeVolumeCommandOutput,
} from "./commands/AttachClusterNodeVolumeCommand";
import {
  BatchAddClusterNodesCommandInput,
  BatchAddClusterNodesCommandOutput,
} from "./commands/BatchAddClusterNodesCommand";
import {
  BatchDeleteClusterNodesCommandInput,
  BatchDeleteClusterNodesCommandOutput,
} from "./commands/BatchDeleteClusterNodesCommand";
import {
  BatchDescribeModelPackageCommandInput,
  BatchDescribeModelPackageCommandOutput,
} from "./commands/BatchDescribeModelPackageCommand";
import {
  CreateActionCommandInput,
  CreateActionCommandOutput,
} from "./commands/CreateActionCommand";
import {
  CreateAlgorithmCommandInput,
  CreateAlgorithmCommandOutput,
} from "./commands/CreateAlgorithmCommand";
import {
  CreateAppCommandInput,
  CreateAppCommandOutput,
} from "./commands/CreateAppCommand";
import {
  CreateAppImageConfigCommandInput,
  CreateAppImageConfigCommandOutput,
} from "./commands/CreateAppImageConfigCommand";
import {
  CreateArtifactCommandInput,
  CreateArtifactCommandOutput,
} from "./commands/CreateArtifactCommand";
import {
  CreateAutoMLJobCommandInput,
  CreateAutoMLJobCommandOutput,
} from "./commands/CreateAutoMLJobCommand";
import {
  CreateAutoMLJobV2CommandInput,
  CreateAutoMLJobV2CommandOutput,
} from "./commands/CreateAutoMLJobV2Command";
import {
  CreateClusterCommandInput,
  CreateClusterCommandOutput,
} from "./commands/CreateClusterCommand";
import {
  CreateClusterSchedulerConfigCommandInput,
  CreateClusterSchedulerConfigCommandOutput,
} from "./commands/CreateClusterSchedulerConfigCommand";
import {
  CreateCodeRepositoryCommandInput,
  CreateCodeRepositoryCommandOutput,
} from "./commands/CreateCodeRepositoryCommand";
import {
  CreateCompilationJobCommandInput,
  CreateCompilationJobCommandOutput,
} from "./commands/CreateCompilationJobCommand";
import {
  CreateComputeQuotaCommandInput,
  CreateComputeQuotaCommandOutput,
} from "./commands/CreateComputeQuotaCommand";
import {
  CreateContextCommandInput,
  CreateContextCommandOutput,
} from "./commands/CreateContextCommand";
import {
  CreateDataQualityJobDefinitionCommandInput,
  CreateDataQualityJobDefinitionCommandOutput,
} from "./commands/CreateDataQualityJobDefinitionCommand";
import {
  CreateDeviceFleetCommandInput,
  CreateDeviceFleetCommandOutput,
} from "./commands/CreateDeviceFleetCommand";
import {
  CreateDomainCommandInput,
  CreateDomainCommandOutput,
} from "./commands/CreateDomainCommand";
import {
  CreateEdgeDeploymentPlanCommandInput,
  CreateEdgeDeploymentPlanCommandOutput,
} from "./commands/CreateEdgeDeploymentPlanCommand";
import {
  CreateEdgeDeploymentStageCommandInput,
  CreateEdgeDeploymentStageCommandOutput,
} from "./commands/CreateEdgeDeploymentStageCommand";
import {
  CreateEdgePackagingJobCommandInput,
  CreateEdgePackagingJobCommandOutput,
} from "./commands/CreateEdgePackagingJobCommand";
import {
  CreateEndpointCommandInput,
  CreateEndpointCommandOutput,
} from "./commands/CreateEndpointCommand";
import {
  CreateEndpointConfigCommandInput,
  CreateEndpointConfigCommandOutput,
} from "./commands/CreateEndpointConfigCommand";
import {
  CreateExperimentCommandInput,
  CreateExperimentCommandOutput,
} from "./commands/CreateExperimentCommand";
import {
  CreateFeatureGroupCommandInput,
  CreateFeatureGroupCommandOutput,
} from "./commands/CreateFeatureGroupCommand";
import {
  CreateFlowDefinitionCommandInput,
  CreateFlowDefinitionCommandOutput,
} from "./commands/CreateFlowDefinitionCommand";
import {
  CreateHubCommandInput,
  CreateHubCommandOutput,
} from "./commands/CreateHubCommand";
import {
  CreateHubContentPresignedUrlsCommandInput,
  CreateHubContentPresignedUrlsCommandOutput,
} from "./commands/CreateHubContentPresignedUrlsCommand";
import {
  CreateHubContentReferenceCommandInput,
  CreateHubContentReferenceCommandOutput,
} from "./commands/CreateHubContentReferenceCommand";
import {
  CreateHumanTaskUiCommandInput,
  CreateHumanTaskUiCommandOutput,
} from "./commands/CreateHumanTaskUiCommand";
import {
  CreateHyperParameterTuningJobCommandInput,
  CreateHyperParameterTuningJobCommandOutput,
} from "./commands/CreateHyperParameterTuningJobCommand";
import {
  CreateImageCommandInput,
  CreateImageCommandOutput,
} from "./commands/CreateImageCommand";
import {
  CreateImageVersionCommandInput,
  CreateImageVersionCommandOutput,
} from "./commands/CreateImageVersionCommand";
import {
  CreateInferenceComponentCommandInput,
  CreateInferenceComponentCommandOutput,
} from "./commands/CreateInferenceComponentCommand";
import {
  CreateInferenceExperimentCommandInput,
  CreateInferenceExperimentCommandOutput,
} from "./commands/CreateInferenceExperimentCommand";
import {
  CreateInferenceRecommendationsJobCommandInput,
  CreateInferenceRecommendationsJobCommandOutput,
} from "./commands/CreateInferenceRecommendationsJobCommand";
import {
  CreateLabelingJobCommandInput,
  CreateLabelingJobCommandOutput,
} from "./commands/CreateLabelingJobCommand";
import {
  CreateMlflowTrackingServerCommandInput,
  CreateMlflowTrackingServerCommandOutput,
} from "./commands/CreateMlflowTrackingServerCommand";
import {
  CreateModelBiasJobDefinitionCommandInput,
  CreateModelBiasJobDefinitionCommandOutput,
} from "./commands/CreateModelBiasJobDefinitionCommand";
import {
  CreateModelCardCommandInput,
  CreateModelCardCommandOutput,
} from "./commands/CreateModelCardCommand";
import {
  CreateModelCardExportJobCommandInput,
  CreateModelCardExportJobCommandOutput,
} from "./commands/CreateModelCardExportJobCommand";
import {
  CreateModelCommandInput,
  CreateModelCommandOutput,
} from "./commands/CreateModelCommand";
import {
  CreateModelExplainabilityJobDefinitionCommandInput,
  CreateModelExplainabilityJobDefinitionCommandOutput,
} from "./commands/CreateModelExplainabilityJobDefinitionCommand";
import {
  CreateModelPackageCommandInput,
  CreateModelPackageCommandOutput,
} from "./commands/CreateModelPackageCommand";
import {
  CreateModelPackageGroupCommandInput,
  CreateModelPackageGroupCommandOutput,
} from "./commands/CreateModelPackageGroupCommand";
import {
  CreateModelQualityJobDefinitionCommandInput,
  CreateModelQualityJobDefinitionCommandOutput,
} from "./commands/CreateModelQualityJobDefinitionCommand";
import {
  CreateMonitoringScheduleCommandInput,
  CreateMonitoringScheduleCommandOutput,
} from "./commands/CreateMonitoringScheduleCommand";
import {
  CreateNotebookInstanceCommandInput,
  CreateNotebookInstanceCommandOutput,
} from "./commands/CreateNotebookInstanceCommand";
import {
  CreateNotebookInstanceLifecycleConfigCommandInput,
  CreateNotebookInstanceLifecycleConfigCommandOutput,
} from "./commands/CreateNotebookInstanceLifecycleConfigCommand";
import {
  CreateOptimizationJobCommandInput,
  CreateOptimizationJobCommandOutput,
} from "./commands/CreateOptimizationJobCommand";
import {
  CreatePartnerAppCommandInput,
  CreatePartnerAppCommandOutput,
} from "./commands/CreatePartnerAppCommand";
import {
  CreatePartnerAppPresignedUrlCommandInput,
  CreatePartnerAppPresignedUrlCommandOutput,
} from "./commands/CreatePartnerAppPresignedUrlCommand";
import {
  CreatePipelineCommandInput,
  CreatePipelineCommandOutput,
} from "./commands/CreatePipelineCommand";
import {
  CreatePresignedDomainUrlCommandInput,
  CreatePresignedDomainUrlCommandOutput,
} from "./commands/CreatePresignedDomainUrlCommand";
import {
  CreatePresignedMlflowTrackingServerUrlCommandInput,
  CreatePresignedMlflowTrackingServerUrlCommandOutput,
} from "./commands/CreatePresignedMlflowTrackingServerUrlCommand";
import {
  CreatePresignedNotebookInstanceUrlCommandInput,
  CreatePresignedNotebookInstanceUrlCommandOutput,
} from "./commands/CreatePresignedNotebookInstanceUrlCommand";
import {
  CreateProcessingJobCommandInput,
  CreateProcessingJobCommandOutput,
} from "./commands/CreateProcessingJobCommand";
import {
  CreateProjectCommandInput,
  CreateProjectCommandOutput,
} from "./commands/CreateProjectCommand";
import {
  CreateSpaceCommandInput,
  CreateSpaceCommandOutput,
} from "./commands/CreateSpaceCommand";
import {
  CreateStudioLifecycleConfigCommandInput,
  CreateStudioLifecycleConfigCommandOutput,
} from "./commands/CreateStudioLifecycleConfigCommand";
import {
  CreateTrainingJobCommandInput,
  CreateTrainingJobCommandOutput,
} from "./commands/CreateTrainingJobCommand";
import {
  CreateTrainingPlanCommandInput,
  CreateTrainingPlanCommandOutput,
} from "./commands/CreateTrainingPlanCommand";
import {
  CreateTransformJobCommandInput,
  CreateTransformJobCommandOutput,
} from "./commands/CreateTransformJobCommand";
import {
  CreateTrialCommandInput,
  CreateTrialCommandOutput,
} from "./commands/CreateTrialCommand";
import {
  CreateTrialComponentCommandInput,
  CreateTrialComponentCommandOutput,
} from "./commands/CreateTrialComponentCommand";
import {
  CreateUserProfileCommandInput,
  CreateUserProfileCommandOutput,
} from "./commands/CreateUserProfileCommand";
import {
  CreateWorkforceCommandInput,
  CreateWorkforceCommandOutput,
} from "./commands/CreateWorkforceCommand";
import {
  CreateWorkteamCommandInput,
  CreateWorkteamCommandOutput,
} from "./commands/CreateWorkteamCommand";
import {
  DeleteActionCommandInput,
  DeleteActionCommandOutput,
} from "./commands/DeleteActionCommand";
import {
  DeleteAlgorithmCommandInput,
  DeleteAlgorithmCommandOutput,
} from "./commands/DeleteAlgorithmCommand";
import {
  DeleteAppCommandInput,
  DeleteAppCommandOutput,
} from "./commands/DeleteAppCommand";
import {
  DeleteAppImageConfigCommandInput,
  DeleteAppImageConfigCommandOutput,
} from "./commands/DeleteAppImageConfigCommand";
import {
  DeleteArtifactCommandInput,
  DeleteArtifactCommandOutput,
} from "./commands/DeleteArtifactCommand";
import {
  DeleteAssociationCommandInput,
  DeleteAssociationCommandOutput,
} from "./commands/DeleteAssociationCommand";
import {
  DeleteClusterCommandInput,
  DeleteClusterCommandOutput,
} from "./commands/DeleteClusterCommand";
import {
  DeleteClusterSchedulerConfigCommandInput,
  DeleteClusterSchedulerConfigCommandOutput,
} from "./commands/DeleteClusterSchedulerConfigCommand";
import {
  DeleteCodeRepositoryCommandInput,
  DeleteCodeRepositoryCommandOutput,
} from "./commands/DeleteCodeRepositoryCommand";
import {
  DeleteCompilationJobCommandInput,
  DeleteCompilationJobCommandOutput,
} from "./commands/DeleteCompilationJobCommand";
import {
  DeleteComputeQuotaCommandInput,
  DeleteComputeQuotaCommandOutput,
} from "./commands/DeleteComputeQuotaCommand";
import {
  DeleteContextCommandInput,
  DeleteContextCommandOutput,
} from "./commands/DeleteContextCommand";
import {
  DeleteDataQualityJobDefinitionCommandInput,
  DeleteDataQualityJobDefinitionCommandOutput,
} from "./commands/DeleteDataQualityJobDefinitionCommand";
import {
  DeleteDeviceFleetCommandInput,
  DeleteDeviceFleetCommandOutput,
} from "./commands/DeleteDeviceFleetCommand";
import {
  DeleteDomainCommandInput,
  DeleteDomainCommandOutput,
} from "./commands/DeleteDomainCommand";
import {
  DeleteEdgeDeploymentPlanCommandInput,
  DeleteEdgeDeploymentPlanCommandOutput,
} from "./commands/DeleteEdgeDeploymentPlanCommand";
import {
  DeleteEdgeDeploymentStageCommandInput,
  DeleteEdgeDeploymentStageCommandOutput,
} from "./commands/DeleteEdgeDeploymentStageCommand";
import {
  DeleteEndpointCommandInput,
  DeleteEndpointCommandOutput,
} from "./commands/DeleteEndpointCommand";
import {
  DeleteEndpointConfigCommandInput,
  DeleteEndpointConfigCommandOutput,
} from "./commands/DeleteEndpointConfigCommand";
import {
  DeleteExperimentCommandInput,
  DeleteExperimentCommandOutput,
} from "./commands/DeleteExperimentCommand";
import {
  DeleteFeatureGroupCommandInput,
  DeleteFeatureGroupCommandOutput,
} from "./commands/DeleteFeatureGroupCommand";
import {
  DeleteFlowDefinitionCommandInput,
  DeleteFlowDefinitionCommandOutput,
} from "./commands/DeleteFlowDefinitionCommand";
import {
  DeleteHubCommandInput,
  DeleteHubCommandOutput,
} from "./commands/DeleteHubCommand";
import {
  DeleteHubContentCommandInput,
  DeleteHubContentCommandOutput,
} from "./commands/DeleteHubContentCommand";
import {
  DeleteHubContentReferenceCommandInput,
  DeleteHubContentReferenceCommandOutput,
} from "./commands/DeleteHubContentReferenceCommand";
import {
  DeleteHumanTaskUiCommandInput,
  DeleteHumanTaskUiCommandOutput,
} from "./commands/DeleteHumanTaskUiCommand";
import {
  DeleteHyperParameterTuningJobCommandInput,
  DeleteHyperParameterTuningJobCommandOutput,
} from "./commands/DeleteHyperParameterTuningJobCommand";
import {
  DeleteImageCommandInput,
  DeleteImageCommandOutput,
} from "./commands/DeleteImageCommand";
import {
  DeleteImageVersionCommandInput,
  DeleteImageVersionCommandOutput,
} from "./commands/DeleteImageVersionCommand";
import {
  DeleteInferenceComponentCommandInput,
  DeleteInferenceComponentCommandOutput,
} from "./commands/DeleteInferenceComponentCommand";
import {
  DeleteInferenceExperimentCommandInput,
  DeleteInferenceExperimentCommandOutput,
} from "./commands/DeleteInferenceExperimentCommand";
import {
  DeleteMlflowTrackingServerCommandInput,
  DeleteMlflowTrackingServerCommandOutput,
} from "./commands/DeleteMlflowTrackingServerCommand";
import {
  DeleteModelBiasJobDefinitionCommandInput,
  DeleteModelBiasJobDefinitionCommandOutput,
} from "./commands/DeleteModelBiasJobDefinitionCommand";
import {
  DeleteModelCardCommandInput,
  DeleteModelCardCommandOutput,
} from "./commands/DeleteModelCardCommand";
import {
  DeleteModelCommandInput,
  DeleteModelCommandOutput,
} from "./commands/DeleteModelCommand";
import {
  DeleteModelExplainabilityJobDefinitionCommandInput,
  DeleteModelExplainabilityJobDefinitionCommandOutput,
} from "./commands/DeleteModelExplainabilityJobDefinitionCommand";
import {
  DeleteModelPackageCommandInput,
  DeleteModelPackageCommandOutput,
} from "./commands/DeleteModelPackageCommand";
import {
  DeleteModelPackageGroupCommandInput,
  DeleteModelPackageGroupCommandOutput,
} from "./commands/DeleteModelPackageGroupCommand";
import {
  DeleteModelPackageGroupPolicyCommandInput,
  DeleteModelPackageGroupPolicyCommandOutput,
} from "./commands/DeleteModelPackageGroupPolicyCommand";
import {
  DeleteModelQualityJobDefinitionCommandInput,
  DeleteModelQualityJobDefinitionCommandOutput,
} from "./commands/DeleteModelQualityJobDefinitionCommand";
import {
  DeleteMonitoringScheduleCommandInput,
  DeleteMonitoringScheduleCommandOutput,
} from "./commands/DeleteMonitoringScheduleCommand";
import {
  DeleteNotebookInstanceCommandInput,
  DeleteNotebookInstanceCommandOutput,
} from "./commands/DeleteNotebookInstanceCommand";
import {
  DeleteNotebookInstanceLifecycleConfigCommandInput,
  DeleteNotebookInstanceLifecycleConfigCommandOutput,
} from "./commands/DeleteNotebookInstanceLifecycleConfigCommand";
import {
  DeleteOptimizationJobCommandInput,
  DeleteOptimizationJobCommandOutput,
} from "./commands/DeleteOptimizationJobCommand";
import {
  DeletePartnerAppCommandInput,
  DeletePartnerAppCommandOutput,
} from "./commands/DeletePartnerAppCommand";
import {
  DeletePipelineCommandInput,
  DeletePipelineCommandOutput,
} from "./commands/DeletePipelineCommand";
import {
  DeleteProjectCommandInput,
  DeleteProjectCommandOutput,
} from "./commands/DeleteProjectCommand";
import {
  DeleteSpaceCommandInput,
  DeleteSpaceCommandOutput,
} from "./commands/DeleteSpaceCommand";
import {
  DeleteStudioLifecycleConfigCommandInput,
  DeleteStudioLifecycleConfigCommandOutput,
} from "./commands/DeleteStudioLifecycleConfigCommand";
import {
  DeleteTagsCommandInput,
  DeleteTagsCommandOutput,
} from "./commands/DeleteTagsCommand";
import {
  DeleteTrialCommandInput,
  DeleteTrialCommandOutput,
} from "./commands/DeleteTrialCommand";
import {
  DeleteTrialComponentCommandInput,
  DeleteTrialComponentCommandOutput,
} from "./commands/DeleteTrialComponentCommand";
import {
  DeleteUserProfileCommandInput,
  DeleteUserProfileCommandOutput,
} from "./commands/DeleteUserProfileCommand";
import {
  DeleteWorkforceCommandInput,
  DeleteWorkforceCommandOutput,
} from "./commands/DeleteWorkforceCommand";
import {
  DeleteWorkteamCommandInput,
  DeleteWorkteamCommandOutput,
} from "./commands/DeleteWorkteamCommand";
import {
  DeregisterDevicesCommandInput,
  DeregisterDevicesCommandOutput,
} from "./commands/DeregisterDevicesCommand";
import {
  DescribeActionCommandInput,
  DescribeActionCommandOutput,
} from "./commands/DescribeActionCommand";
import {
  DescribeAlgorithmCommandInput,
  DescribeAlgorithmCommandOutput,
} from "./commands/DescribeAlgorithmCommand";
import {
  DescribeAppCommandInput,
  DescribeAppCommandOutput,
} from "./commands/DescribeAppCommand";
import {
  DescribeAppImageConfigCommandInput,
  DescribeAppImageConfigCommandOutput,
} from "./commands/DescribeAppImageConfigCommand";
import {
  DescribeArtifactCommandInput,
  DescribeArtifactCommandOutput,
} from "./commands/DescribeArtifactCommand";
import {
  DescribeAutoMLJobCommandInput,
  DescribeAutoMLJobCommandOutput,
} from "./commands/DescribeAutoMLJobCommand";
import {
  DescribeAutoMLJobV2CommandInput,
  DescribeAutoMLJobV2CommandOutput,
} from "./commands/DescribeAutoMLJobV2Command";
import {
  DescribeClusterCommandInput,
  DescribeClusterCommandOutput,
} from "./commands/DescribeClusterCommand";
import {
  DescribeClusterEventCommandInput,
  DescribeClusterEventCommandOutput,
} from "./commands/DescribeClusterEventCommand";
import {
  DescribeClusterNodeCommandInput,
  DescribeClusterNodeCommandOutput,
} from "./commands/DescribeClusterNodeCommand";
import {
  DescribeClusterSchedulerConfigCommandInput,
  DescribeClusterSchedulerConfigCommandOutput,
} from "./commands/DescribeClusterSchedulerConfigCommand";
import {
  DescribeCodeRepositoryCommandInput,
  DescribeCodeRepositoryCommandOutput,
} from "./commands/DescribeCodeRepositoryCommand";
import {
  DescribeCompilationJobCommandInput,
  DescribeCompilationJobCommandOutput,
} from "./commands/DescribeCompilationJobCommand";
import {
  DescribeComputeQuotaCommandInput,
  DescribeComputeQuotaCommandOutput,
} from "./commands/DescribeComputeQuotaCommand";
import {
  DescribeContextCommandInput,
  DescribeContextCommandOutput,
} from "./commands/DescribeContextCommand";
import {
  DescribeDataQualityJobDefinitionCommandInput,
  DescribeDataQualityJobDefinitionCommandOutput,
} from "./commands/DescribeDataQualityJobDefinitionCommand";
import {
  DescribeDeviceCommandInput,
  DescribeDeviceCommandOutput,
} from "./commands/DescribeDeviceCommand";
import {
  DescribeDeviceFleetCommandInput,
  DescribeDeviceFleetCommandOutput,
} from "./commands/DescribeDeviceFleetCommand";
import {
  DescribeDomainCommandInput,
  DescribeDomainCommandOutput,
} from "./commands/DescribeDomainCommand";
import {
  DescribeEdgeDeploymentPlanCommandInput,
  DescribeEdgeDeploymentPlanCommandOutput,
} from "./commands/DescribeEdgeDeploymentPlanCommand";
import {
  DescribeEdgePackagingJobCommandInput,
  DescribeEdgePackagingJobCommandOutput,
} from "./commands/DescribeEdgePackagingJobCommand";
import {
  DescribeEndpointCommandInput,
  DescribeEndpointCommandOutput,
} from "./commands/DescribeEndpointCommand";
import {
  DescribeEndpointConfigCommandInput,
  DescribeEndpointConfigCommandOutput,
} from "./commands/DescribeEndpointConfigCommand";
import {
  DescribeExperimentCommandInput,
  DescribeExperimentCommandOutput,
} from "./commands/DescribeExperimentCommand";
import {
  DescribeFeatureGroupCommandInput,
  DescribeFeatureGroupCommandOutput,
} from "./commands/DescribeFeatureGroupCommand";
import {
  DescribeFeatureMetadataCommandInput,
  DescribeFeatureMetadataCommandOutput,
} from "./commands/DescribeFeatureMetadataCommand";
import {
  DescribeFlowDefinitionCommandInput,
  DescribeFlowDefinitionCommandOutput,
} from "./commands/DescribeFlowDefinitionCommand";
import {
  DescribeHubCommandInput,
  DescribeHubCommandOutput,
} from "./commands/DescribeHubCommand";
import {
  DescribeHubContentCommandInput,
  DescribeHubContentCommandOutput,
} from "./commands/DescribeHubContentCommand";
import {
  DescribeHumanTaskUiCommandInput,
  DescribeHumanTaskUiCommandOutput,
} from "./commands/DescribeHumanTaskUiCommand";
import {
  DescribeHyperParameterTuningJobCommandInput,
  DescribeHyperParameterTuningJobCommandOutput,
} from "./commands/DescribeHyperParameterTuningJobCommand";
import {
  DescribeImageCommandInput,
  DescribeImageCommandOutput,
} from "./commands/DescribeImageCommand";
import {
  DescribeImageVersionCommandInput,
  DescribeImageVersionCommandOutput,
} from "./commands/DescribeImageVersionCommand";
import {
  DescribeInferenceComponentCommandInput,
  DescribeInferenceComponentCommandOutput,
} from "./commands/DescribeInferenceComponentCommand";
import {
  DescribeInferenceExperimentCommandInput,
  DescribeInferenceExperimentCommandOutput,
} from "./commands/DescribeInferenceExperimentCommand";
import {
  DescribeInferenceRecommendationsJobCommandInput,
  DescribeInferenceRecommendationsJobCommandOutput,
} from "./commands/DescribeInferenceRecommendationsJobCommand";
import {
  DescribeLabelingJobCommandInput,
  DescribeLabelingJobCommandOutput,
} from "./commands/DescribeLabelingJobCommand";
import {
  DescribeLineageGroupCommandInput,
  DescribeLineageGroupCommandOutput,
} from "./commands/DescribeLineageGroupCommand";
import {
  DescribeMlflowTrackingServerCommandInput,
  DescribeMlflowTrackingServerCommandOutput,
} from "./commands/DescribeMlflowTrackingServerCommand";
import {
  DescribeModelBiasJobDefinitionCommandInput,
  DescribeModelBiasJobDefinitionCommandOutput,
} from "./commands/DescribeModelBiasJobDefinitionCommand";
import {
  DescribeModelCardCommandInput,
  DescribeModelCardCommandOutput,
} from "./commands/DescribeModelCardCommand";
import {
  DescribeModelCardExportJobCommandInput,
  DescribeModelCardExportJobCommandOutput,
} from "./commands/DescribeModelCardExportJobCommand";
import {
  DescribeModelCommandInput,
  DescribeModelCommandOutput,
} from "./commands/DescribeModelCommand";
import {
  DescribeModelExplainabilityJobDefinitionCommandInput,
  DescribeModelExplainabilityJobDefinitionCommandOutput,
} from "./commands/DescribeModelExplainabilityJobDefinitionCommand";
import {
  DescribeModelPackageCommandInput,
  DescribeModelPackageCommandOutput,
} from "./commands/DescribeModelPackageCommand";
import {
  DescribeModelPackageGroupCommandInput,
  DescribeModelPackageGroupCommandOutput,
} from "./commands/DescribeModelPackageGroupCommand";
import {
  DescribeModelQualityJobDefinitionCommandInput,
  DescribeModelQualityJobDefinitionCommandOutput,
} from "./commands/DescribeModelQualityJobDefinitionCommand";
import {
  DescribeMonitoringScheduleCommandInput,
  DescribeMonitoringScheduleCommandOutput,
} from "./commands/DescribeMonitoringScheduleCommand";
import {
  DescribeNotebookInstanceCommandInput,
  DescribeNotebookInstanceCommandOutput,
} from "./commands/DescribeNotebookInstanceCommand";
import {
  DescribeNotebookInstanceLifecycleConfigCommandInput,
  DescribeNotebookInstanceLifecycleConfigCommandOutput,
} from "./commands/DescribeNotebookInstanceLifecycleConfigCommand";
import {
  DescribeOptimizationJobCommandInput,
  DescribeOptimizationJobCommandOutput,
} from "./commands/DescribeOptimizationJobCommand";
import {
  DescribePartnerAppCommandInput,
  DescribePartnerAppCommandOutput,
} from "./commands/DescribePartnerAppCommand";
import {
  DescribePipelineCommandInput,
  DescribePipelineCommandOutput,
} from "./commands/DescribePipelineCommand";
import {
  DescribePipelineDefinitionForExecutionCommandInput,
  DescribePipelineDefinitionForExecutionCommandOutput,
} from "./commands/DescribePipelineDefinitionForExecutionCommand";
import {
  DescribePipelineExecutionCommandInput,
  DescribePipelineExecutionCommandOutput,
} from "./commands/DescribePipelineExecutionCommand";
import {
  DescribeProcessingJobCommandInput,
  DescribeProcessingJobCommandOutput,
} from "./commands/DescribeProcessingJobCommand";
import {
  DescribeProjectCommandInput,
  DescribeProjectCommandOutput,
} from "./commands/DescribeProjectCommand";
import {
  DescribeReservedCapacityCommandInput,
  DescribeReservedCapacityCommandOutput,
} from "./commands/DescribeReservedCapacityCommand";
import {
  DescribeSpaceCommandInput,
  DescribeSpaceCommandOutput,
} from "./commands/DescribeSpaceCommand";
import {
  DescribeStudioLifecycleConfigCommandInput,
  DescribeStudioLifecycleConfigCommandOutput,
} from "./commands/DescribeStudioLifecycleConfigCommand";
import {
  DescribeSubscribedWorkteamCommandInput,
  DescribeSubscribedWorkteamCommandOutput,
} from "./commands/DescribeSubscribedWorkteamCommand";
import {
  DescribeTrainingJobCommandInput,
  DescribeTrainingJobCommandOutput,
} from "./commands/DescribeTrainingJobCommand";
import {
  DescribeTrainingPlanCommandInput,
  DescribeTrainingPlanCommandOutput,
} from "./commands/DescribeTrainingPlanCommand";
import {
  DescribeTransformJobCommandInput,
  DescribeTransformJobCommandOutput,
} from "./commands/DescribeTransformJobCommand";
import {
  DescribeTrialCommandInput,
  DescribeTrialCommandOutput,
} from "./commands/DescribeTrialCommand";
import {
  DescribeTrialComponentCommandInput,
  DescribeTrialComponentCommandOutput,
} from "./commands/DescribeTrialComponentCommand";
import {
  DescribeUserProfileCommandInput,
  DescribeUserProfileCommandOutput,
} from "./commands/DescribeUserProfileCommand";
import {
  DescribeWorkforceCommandInput,
  DescribeWorkforceCommandOutput,
} from "./commands/DescribeWorkforceCommand";
import {
  DescribeWorkteamCommandInput,
  DescribeWorkteamCommandOutput,
} from "./commands/DescribeWorkteamCommand";
import {
  DetachClusterNodeVolumeCommandInput,
  DetachClusterNodeVolumeCommandOutput,
} from "./commands/DetachClusterNodeVolumeCommand";
import {
  DisableSagemakerServicecatalogPortfolioCommandInput,
  DisableSagemakerServicecatalogPortfolioCommandOutput,
} from "./commands/DisableSagemakerServicecatalogPortfolioCommand";
import {
  DisassociateTrialComponentCommandInput,
  DisassociateTrialComponentCommandOutput,
} from "./commands/DisassociateTrialComponentCommand";
import {
  EnableSagemakerServicecatalogPortfolioCommandInput,
  EnableSagemakerServicecatalogPortfolioCommandOutput,
} from "./commands/EnableSagemakerServicecatalogPortfolioCommand";
import {
  GetDeviceFleetReportCommandInput,
  GetDeviceFleetReportCommandOutput,
} from "./commands/GetDeviceFleetReportCommand";
import {
  GetLineageGroupPolicyCommandInput,
  GetLineageGroupPolicyCommandOutput,
} from "./commands/GetLineageGroupPolicyCommand";
import {
  GetModelPackageGroupPolicyCommandInput,
  GetModelPackageGroupPolicyCommandOutput,
} from "./commands/GetModelPackageGroupPolicyCommand";
import {
  GetSagemakerServicecatalogPortfolioStatusCommandInput,
  GetSagemakerServicecatalogPortfolioStatusCommandOutput,
} from "./commands/GetSagemakerServicecatalogPortfolioStatusCommand";
import {
  GetScalingConfigurationRecommendationCommandInput,
  GetScalingConfigurationRecommendationCommandOutput,
} from "./commands/GetScalingConfigurationRecommendationCommand";
import {
  GetSearchSuggestionsCommandInput,
  GetSearchSuggestionsCommandOutput,
} from "./commands/GetSearchSuggestionsCommand";
import {
  ImportHubContentCommandInput,
  ImportHubContentCommandOutput,
} from "./commands/ImportHubContentCommand";
import {
  ListActionsCommandInput,
  ListActionsCommandOutput,
} from "./commands/ListActionsCommand";
import {
  ListAlgorithmsCommandInput,
  ListAlgorithmsCommandOutput,
} from "./commands/ListAlgorithmsCommand";
import {
  ListAliasesCommandInput,
  ListAliasesCommandOutput,
} from "./commands/ListAliasesCommand";
import {
  ListAppImageConfigsCommandInput,
  ListAppImageConfigsCommandOutput,
} from "./commands/ListAppImageConfigsCommand";
import {
  ListAppsCommandInput,
  ListAppsCommandOutput,
} from "./commands/ListAppsCommand";
import {
  ListArtifactsCommandInput,
  ListArtifactsCommandOutput,
} from "./commands/ListArtifactsCommand";
import {
  ListAssociationsCommandInput,
  ListAssociationsCommandOutput,
} from "./commands/ListAssociationsCommand";
import {
  ListAutoMLJobsCommandInput,
  ListAutoMLJobsCommandOutput,
} from "./commands/ListAutoMLJobsCommand";
import {
  ListCandidatesForAutoMLJobCommandInput,
  ListCandidatesForAutoMLJobCommandOutput,
} from "./commands/ListCandidatesForAutoMLJobCommand";
import {
  ListClusterEventsCommandInput,
  ListClusterEventsCommandOutput,
} from "./commands/ListClusterEventsCommand";
import {
  ListClusterNodesCommandInput,
  ListClusterNodesCommandOutput,
} from "./commands/ListClusterNodesCommand";
import {
  ListClusterSchedulerConfigsCommandInput,
  ListClusterSchedulerConfigsCommandOutput,
} from "./commands/ListClusterSchedulerConfigsCommand";
import {
  ListClustersCommandInput,
  ListClustersCommandOutput,
} from "./commands/ListClustersCommand";
import {
  ListCodeRepositoriesCommandInput,
  ListCodeRepositoriesCommandOutput,
} from "./commands/ListCodeRepositoriesCommand";
import {
  ListCompilationJobsCommandInput,
  ListCompilationJobsCommandOutput,
} from "./commands/ListCompilationJobsCommand";
import {
  ListComputeQuotasCommandInput,
  ListComputeQuotasCommandOutput,
} from "./commands/ListComputeQuotasCommand";
import {
  ListContextsCommandInput,
  ListContextsCommandOutput,
} from "./commands/ListContextsCommand";
import {
  ListDataQualityJobDefinitionsCommandInput,
  ListDataQualityJobDefinitionsCommandOutput,
} from "./commands/ListDataQualityJobDefinitionsCommand";
import {
  ListDeviceFleetsCommandInput,
  ListDeviceFleetsCommandOutput,
} from "./commands/ListDeviceFleetsCommand";
import {
  ListDevicesCommandInput,
  ListDevicesCommandOutput,
} from "./commands/ListDevicesCommand";
import {
  ListDomainsCommandInput,
  ListDomainsCommandOutput,
} from "./commands/ListDomainsCommand";
import {
  ListEdgeDeploymentPlansCommandInput,
  ListEdgeDeploymentPlansCommandOutput,
} from "./commands/ListEdgeDeploymentPlansCommand";
import {
  ListEdgePackagingJobsCommandInput,
  ListEdgePackagingJobsCommandOutput,
} from "./commands/ListEdgePackagingJobsCommand";
import {
  ListEndpointConfigsCommandInput,
  ListEndpointConfigsCommandOutput,
} from "./commands/ListEndpointConfigsCommand";
import {
  ListEndpointsCommandInput,
  ListEndpointsCommandOutput,
} from "./commands/ListEndpointsCommand";
import {
  ListExperimentsCommandInput,
  ListExperimentsCommandOutput,
} from "./commands/ListExperimentsCommand";
import {
  ListFeatureGroupsCommandInput,
  ListFeatureGroupsCommandOutput,
} from "./commands/ListFeatureGroupsCommand";
import {
  ListFlowDefinitionsCommandInput,
  ListFlowDefinitionsCommandOutput,
} from "./commands/ListFlowDefinitionsCommand";
import {
  ListHubContentsCommandInput,
  ListHubContentsCommandOutput,
} from "./commands/ListHubContentsCommand";
import {
  ListHubContentVersionsCommandInput,
  ListHubContentVersionsCommandOutput,
} from "./commands/ListHubContentVersionsCommand";
import {
  ListHubsCommandInput,
  ListHubsCommandOutput,
} from "./commands/ListHubsCommand";
import {
  ListHumanTaskUisCommandInput,
  ListHumanTaskUisCommandOutput,
} from "./commands/ListHumanTaskUisCommand";
import {
  ListHyperParameterTuningJobsCommandInput,
  ListHyperParameterTuningJobsCommandOutput,
} from "./commands/ListHyperParameterTuningJobsCommand";
import {
  ListImagesCommandInput,
  ListImagesCommandOutput,
} from "./commands/ListImagesCommand";
import {
  ListImageVersionsCommandInput,
  ListImageVersionsCommandOutput,
} from "./commands/ListImageVersionsCommand";
import {
  ListInferenceComponentsCommandInput,
  ListInferenceComponentsCommandOutput,
} from "./commands/ListInferenceComponentsCommand";
import {
  ListInferenceExperimentsCommandInput,
  ListInferenceExperimentsCommandOutput,
} from "./commands/ListInferenceExperimentsCommand";
import {
  ListInferenceRecommendationsJobsCommandInput,
  ListInferenceRecommendationsJobsCommandOutput,
} from "./commands/ListInferenceRecommendationsJobsCommand";
import {
  ListInferenceRecommendationsJobStepsCommandInput,
  ListInferenceRecommendationsJobStepsCommandOutput,
} from "./commands/ListInferenceRecommendationsJobStepsCommand";
import {
  ListLabelingJobsCommandInput,
  ListLabelingJobsCommandOutput,
} from "./commands/ListLabelingJobsCommand";
import {
  ListLabelingJobsForWorkteamCommandInput,
  ListLabelingJobsForWorkteamCommandOutput,
} from "./commands/ListLabelingJobsForWorkteamCommand";
import {
  ListLineageGroupsCommandInput,
  ListLineageGroupsCommandOutput,
} from "./commands/ListLineageGroupsCommand";
import {
  ListMlflowTrackingServersCommandInput,
  ListMlflowTrackingServersCommandOutput,
} from "./commands/ListMlflowTrackingServersCommand";
import {
  ListModelBiasJobDefinitionsCommandInput,
  ListModelBiasJobDefinitionsCommandOutput,
} from "./commands/ListModelBiasJobDefinitionsCommand";
import {
  ListModelCardExportJobsCommandInput,
  ListModelCardExportJobsCommandOutput,
} from "./commands/ListModelCardExportJobsCommand";
import {
  ListModelCardsCommandInput,
  ListModelCardsCommandOutput,
} from "./commands/ListModelCardsCommand";
import {
  ListModelCardVersionsCommandInput,
  ListModelCardVersionsCommandOutput,
} from "./commands/ListModelCardVersionsCommand";
import {
  ListModelExplainabilityJobDefinitionsCommandInput,
  ListModelExplainabilityJobDefinitionsCommandOutput,
} from "./commands/ListModelExplainabilityJobDefinitionsCommand";
import {
  ListModelMetadataCommandInput,
  ListModelMetadataCommandOutput,
} from "./commands/ListModelMetadataCommand";
import {
  ListModelPackageGroupsCommandInput,
  ListModelPackageGroupsCommandOutput,
} from "./commands/ListModelPackageGroupsCommand";
import {
  ListModelPackagesCommandInput,
  ListModelPackagesCommandOutput,
} from "./commands/ListModelPackagesCommand";
import {
  ListModelQualityJobDefinitionsCommandInput,
  ListModelQualityJobDefinitionsCommandOutput,
} from "./commands/ListModelQualityJobDefinitionsCommand";
import {
  ListModelsCommandInput,
  ListModelsCommandOutput,
} from "./commands/ListModelsCommand";
import {
  ListMonitoringAlertHistoryCommandInput,
  ListMonitoringAlertHistoryCommandOutput,
} from "./commands/ListMonitoringAlertHistoryCommand";
import {
  ListMonitoringAlertsCommandInput,
  ListMonitoringAlertsCommandOutput,
} from "./commands/ListMonitoringAlertsCommand";
import {
  ListMonitoringExecutionsCommandInput,
  ListMonitoringExecutionsCommandOutput,
} from "./commands/ListMonitoringExecutionsCommand";
import {
  ListMonitoringSchedulesCommandInput,
  ListMonitoringSchedulesCommandOutput,
} from "./commands/ListMonitoringSchedulesCommand";
import {
  ListNotebookInstanceLifecycleConfigsCommandInput,
  ListNotebookInstanceLifecycleConfigsCommandOutput,
} from "./commands/ListNotebookInstanceLifecycleConfigsCommand";
import {
  ListNotebookInstancesCommandInput,
  ListNotebookInstancesCommandOutput,
} from "./commands/ListNotebookInstancesCommand";
import {
  ListOptimizationJobsCommandInput,
  ListOptimizationJobsCommandOutput,
} from "./commands/ListOptimizationJobsCommand";
import {
  ListPartnerAppsCommandInput,
  ListPartnerAppsCommandOutput,
} from "./commands/ListPartnerAppsCommand";
import {
  ListPipelineExecutionsCommandInput,
  ListPipelineExecutionsCommandOutput,
} from "./commands/ListPipelineExecutionsCommand";
import {
  ListPipelineExecutionStepsCommandInput,
  ListPipelineExecutionStepsCommandOutput,
} from "./commands/ListPipelineExecutionStepsCommand";
import {
  ListPipelineParametersForExecutionCommandInput,
  ListPipelineParametersForExecutionCommandOutput,
} from "./commands/ListPipelineParametersForExecutionCommand";
import {
  ListPipelinesCommandInput,
  ListPipelinesCommandOutput,
} from "./commands/ListPipelinesCommand";
import {
  ListPipelineVersionsCommandInput,
  ListPipelineVersionsCommandOutput,
} from "./commands/ListPipelineVersionsCommand";
import {
  ListProcessingJobsCommandInput,
  ListProcessingJobsCommandOutput,
} from "./commands/ListProcessingJobsCommand";
import {
  ListProjectsCommandInput,
  ListProjectsCommandOutput,
} from "./commands/ListProjectsCommand";
import {
  ListResourceCatalogsCommandInput,
  ListResourceCatalogsCommandOutput,
} from "./commands/ListResourceCatalogsCommand";
import {
  ListSpacesCommandInput,
  ListSpacesCommandOutput,
} from "./commands/ListSpacesCommand";
import {
  ListStageDevicesCommandInput,
  ListStageDevicesCommandOutput,
} from "./commands/ListStageDevicesCommand";
import {
  ListStudioLifecycleConfigsCommandInput,
  ListStudioLifecycleConfigsCommandOutput,
} from "./commands/ListStudioLifecycleConfigsCommand";
import {
  ListSubscribedWorkteamsCommandInput,
  ListSubscribedWorkteamsCommandOutput,
} from "./commands/ListSubscribedWorkteamsCommand";
import {
  ListTagsCommandInput,
  ListTagsCommandOutput,
} from "./commands/ListTagsCommand";
import {
  ListTrainingJobsCommandInput,
  ListTrainingJobsCommandOutput,
} from "./commands/ListTrainingJobsCommand";
import {
  ListTrainingJobsForHyperParameterTuningJobCommandInput,
  ListTrainingJobsForHyperParameterTuningJobCommandOutput,
} from "./commands/ListTrainingJobsForHyperParameterTuningJobCommand";
import {
  ListTrainingPlansCommandInput,
  ListTrainingPlansCommandOutput,
} from "./commands/ListTrainingPlansCommand";
import {
  ListTransformJobsCommandInput,
  ListTransformJobsCommandOutput,
} from "./commands/ListTransformJobsCommand";
import {
  ListTrialComponentsCommandInput,
  ListTrialComponentsCommandOutput,
} from "./commands/ListTrialComponentsCommand";
import {
  ListTrialsCommandInput,
  ListTrialsCommandOutput,
} from "./commands/ListTrialsCommand";
import {
  ListUltraServersByReservedCapacityCommandInput,
  ListUltraServersByReservedCapacityCommandOutput,
} from "./commands/ListUltraServersByReservedCapacityCommand";
import {
  ListUserProfilesCommandInput,
  ListUserProfilesCommandOutput,
} from "./commands/ListUserProfilesCommand";
import {
  ListWorkforcesCommandInput,
  ListWorkforcesCommandOutput,
} from "./commands/ListWorkforcesCommand";
import {
  ListWorkteamsCommandInput,
  ListWorkteamsCommandOutput,
} from "./commands/ListWorkteamsCommand";
import {
  PutModelPackageGroupPolicyCommandInput,
  PutModelPackageGroupPolicyCommandOutput,
} from "./commands/PutModelPackageGroupPolicyCommand";
import {
  QueryLineageCommandInput,
  QueryLineageCommandOutput,
} from "./commands/QueryLineageCommand";
import {
  RegisterDevicesCommandInput,
  RegisterDevicesCommandOutput,
} from "./commands/RegisterDevicesCommand";
import {
  RenderUiTemplateCommandInput,
  RenderUiTemplateCommandOutput,
} from "./commands/RenderUiTemplateCommand";
import {
  RetryPipelineExecutionCommandInput,
  RetryPipelineExecutionCommandOutput,
} from "./commands/RetryPipelineExecutionCommand";
import {
  SearchCommandInput,
  SearchCommandOutput,
} from "./commands/SearchCommand";
import {
  SearchTrainingPlanOfferingsCommandInput,
  SearchTrainingPlanOfferingsCommandOutput,
} from "./commands/SearchTrainingPlanOfferingsCommand";
import {
  SendPipelineExecutionStepFailureCommandInput,
  SendPipelineExecutionStepFailureCommandOutput,
} from "./commands/SendPipelineExecutionStepFailureCommand";
import {
  SendPipelineExecutionStepSuccessCommandInput,
  SendPipelineExecutionStepSuccessCommandOutput,
} from "./commands/SendPipelineExecutionStepSuccessCommand";
import {
  StartEdgeDeploymentStageCommandInput,
  StartEdgeDeploymentStageCommandOutput,
} from "./commands/StartEdgeDeploymentStageCommand";
import {
  StartInferenceExperimentCommandInput,
  StartInferenceExperimentCommandOutput,
} from "./commands/StartInferenceExperimentCommand";
import {
  StartMlflowTrackingServerCommandInput,
  StartMlflowTrackingServerCommandOutput,
} from "./commands/StartMlflowTrackingServerCommand";
import {
  StartMonitoringScheduleCommandInput,
  StartMonitoringScheduleCommandOutput,
} from "./commands/StartMonitoringScheduleCommand";
import {
  StartNotebookInstanceCommandInput,
  StartNotebookInstanceCommandOutput,
} from "./commands/StartNotebookInstanceCommand";
import {
  StartPipelineExecutionCommandInput,
  StartPipelineExecutionCommandOutput,
} from "./commands/StartPipelineExecutionCommand";
import {
  StartSessionCommandInput,
  StartSessionCommandOutput,
} from "./commands/StartSessionCommand";
import {
  StopAutoMLJobCommandInput,
  StopAutoMLJobCommandOutput,
} from "./commands/StopAutoMLJobCommand";
import {
  StopCompilationJobCommandInput,
  StopCompilationJobCommandOutput,
} from "./commands/StopCompilationJobCommand";
import {
  StopEdgeDeploymentStageCommandInput,
  StopEdgeDeploymentStageCommandOutput,
} from "./commands/StopEdgeDeploymentStageCommand";
import {
  StopEdgePackagingJobCommandInput,
  StopEdgePackagingJobCommandOutput,
} from "./commands/StopEdgePackagingJobCommand";
import {
  StopHyperParameterTuningJobCommandInput,
  StopHyperParameterTuningJobCommandOutput,
} from "./commands/StopHyperParameterTuningJobCommand";
import {
  StopInferenceExperimentCommandInput,
  StopInferenceExperimentCommandOutput,
} from "./commands/StopInferenceExperimentCommand";
import {
  StopInferenceRecommendationsJobCommandInput,
  StopInferenceRecommendationsJobCommandOutput,
} from "./commands/StopInferenceRecommendationsJobCommand";
import {
  StopLabelingJobCommandInput,
  StopLabelingJobCommandOutput,
} from "./commands/StopLabelingJobCommand";
import {
  StopMlflowTrackingServerCommandInput,
  StopMlflowTrackingServerCommandOutput,
} from "./commands/StopMlflowTrackingServerCommand";
import {
  StopMonitoringScheduleCommandInput,
  StopMonitoringScheduleCommandOutput,
} from "./commands/StopMonitoringScheduleCommand";
import {
  StopNotebookInstanceCommandInput,
  StopNotebookInstanceCommandOutput,
} from "./commands/StopNotebookInstanceCommand";
import {
  StopOptimizationJobCommandInput,
  StopOptimizationJobCommandOutput,
} from "./commands/StopOptimizationJobCommand";
import {
  StopPipelineExecutionCommandInput,
  StopPipelineExecutionCommandOutput,
} from "./commands/StopPipelineExecutionCommand";
import {
  StopProcessingJobCommandInput,
  StopProcessingJobCommandOutput,
} from "./commands/StopProcessingJobCommand";
import {
  StopTrainingJobCommandInput,
  StopTrainingJobCommandOutput,
} from "./commands/StopTrainingJobCommand";
import {
  StopTransformJobCommandInput,
  StopTransformJobCommandOutput,
} from "./commands/StopTransformJobCommand";
import {
  UpdateActionCommandInput,
  UpdateActionCommandOutput,
} from "./commands/UpdateActionCommand";
import {
  UpdateAppImageConfigCommandInput,
  UpdateAppImageConfigCommandOutput,
} from "./commands/UpdateAppImageConfigCommand";
import {
  UpdateArtifactCommandInput,
  UpdateArtifactCommandOutput,
} from "./commands/UpdateArtifactCommand";
import {
  UpdateClusterCommandInput,
  UpdateClusterCommandOutput,
} from "./commands/UpdateClusterCommand";
import {
  UpdateClusterSchedulerConfigCommandInput,
  UpdateClusterSchedulerConfigCommandOutput,
} from "./commands/UpdateClusterSchedulerConfigCommand";
import {
  UpdateClusterSoftwareCommandInput,
  UpdateClusterSoftwareCommandOutput,
} from "./commands/UpdateClusterSoftwareCommand";
import {
  UpdateCodeRepositoryCommandInput,
  UpdateCodeRepositoryCommandOutput,
} from "./commands/UpdateCodeRepositoryCommand";
import {
  UpdateComputeQuotaCommandInput,
  UpdateComputeQuotaCommandOutput,
} from "./commands/UpdateComputeQuotaCommand";
import {
  UpdateContextCommandInput,
  UpdateContextCommandOutput,
} from "./commands/UpdateContextCommand";
import {
  UpdateDeviceFleetCommandInput,
  UpdateDeviceFleetCommandOutput,
} from "./commands/UpdateDeviceFleetCommand";
import {
  UpdateDevicesCommandInput,
  UpdateDevicesCommandOutput,
} from "./commands/UpdateDevicesCommand";
import {
  UpdateDomainCommandInput,
  UpdateDomainCommandOutput,
} from "./commands/UpdateDomainCommand";
import {
  UpdateEndpointCommandInput,
  UpdateEndpointCommandOutput,
} from "./commands/UpdateEndpointCommand";
import {
  UpdateEndpointWeightsAndCapacitiesCommandInput,
  UpdateEndpointWeightsAndCapacitiesCommandOutput,
} from "./commands/UpdateEndpointWeightsAndCapacitiesCommand";
import {
  UpdateExperimentCommandInput,
  UpdateExperimentCommandOutput,
} from "./commands/UpdateExperimentCommand";
import {
  UpdateFeatureGroupCommandInput,
  UpdateFeatureGroupCommandOutput,
} from "./commands/UpdateFeatureGroupCommand";
import {
  UpdateFeatureMetadataCommandInput,
  UpdateFeatureMetadataCommandOutput,
} from "./commands/UpdateFeatureMetadataCommand";
import {
  UpdateHubCommandInput,
  UpdateHubCommandOutput,
} from "./commands/UpdateHubCommand";
import {
  UpdateHubContentCommandInput,
  UpdateHubContentCommandOutput,
} from "./commands/UpdateHubContentCommand";
import {
  UpdateHubContentReferenceCommandInput,
  UpdateHubContentReferenceCommandOutput,
} from "./commands/UpdateHubContentReferenceCommand";
import {
  UpdateImageCommandInput,
  UpdateImageCommandOutput,
} from "./commands/UpdateImageCommand";
import {
  UpdateImageVersionCommandInput,
  UpdateImageVersionCommandOutput,
} from "./commands/UpdateImageVersionCommand";
import {
  UpdateInferenceComponentCommandInput,
  UpdateInferenceComponentCommandOutput,
} from "./commands/UpdateInferenceComponentCommand";
import {
  UpdateInferenceComponentRuntimeConfigCommandInput,
  UpdateInferenceComponentRuntimeConfigCommandOutput,
} from "./commands/UpdateInferenceComponentRuntimeConfigCommand";
import {
  UpdateInferenceExperimentCommandInput,
  UpdateInferenceExperimentCommandOutput,
} from "./commands/UpdateInferenceExperimentCommand";
import {
  UpdateMlflowTrackingServerCommandInput,
  UpdateMlflowTrackingServerCommandOutput,
} from "./commands/UpdateMlflowTrackingServerCommand";
import {
  UpdateModelCardCommandInput,
  UpdateModelCardCommandOutput,
} from "./commands/UpdateModelCardCommand";
import {
  UpdateModelPackageCommandInput,
  UpdateModelPackageCommandOutput,
} from "./commands/UpdateModelPackageCommand";
import {
  UpdateMonitoringAlertCommandInput,
  UpdateMonitoringAlertCommandOutput,
} from "./commands/UpdateMonitoringAlertCommand";
import {
  UpdateMonitoringScheduleCommandInput,
  UpdateMonitoringScheduleCommandOutput,
} from "./commands/UpdateMonitoringScheduleCommand";
import {
  UpdateNotebookInstanceCommandInput,
  UpdateNotebookInstanceCommandOutput,
} from "./commands/UpdateNotebookInstanceCommand";
import {
  UpdateNotebookInstanceLifecycleConfigCommandInput,
  UpdateNotebookInstanceLifecycleConfigCommandOutput,
} from "./commands/UpdateNotebookInstanceLifecycleConfigCommand";
import {
  UpdatePartnerAppCommandInput,
  UpdatePartnerAppCommandOutput,
} from "./commands/UpdatePartnerAppCommand";
import {
  UpdatePipelineCommandInput,
  UpdatePipelineCommandOutput,
} from "./commands/UpdatePipelineCommand";
import {
  UpdatePipelineExecutionCommandInput,
  UpdatePipelineExecutionCommandOutput,
} from "./commands/UpdatePipelineExecutionCommand";
import {
  UpdatePipelineVersionCommandInput,
  UpdatePipelineVersionCommandOutput,
} from "./commands/UpdatePipelineVersionCommand";
import {
  UpdateProjectCommandInput,
  UpdateProjectCommandOutput,
} from "./commands/UpdateProjectCommand";
import {
  UpdateSpaceCommandInput,
  UpdateSpaceCommandOutput,
} from "./commands/UpdateSpaceCommand";
import {
  UpdateTrainingJobCommandInput,
  UpdateTrainingJobCommandOutput,
} from "./commands/UpdateTrainingJobCommand";
import {
  UpdateTrialCommandInput,
  UpdateTrialCommandOutput,
} from "./commands/UpdateTrialCommand";
import {
  UpdateTrialComponentCommandInput,
  UpdateTrialComponentCommandOutput,
} from "./commands/UpdateTrialComponentCommand";
import {
  UpdateUserProfileCommandInput,
  UpdateUserProfileCommandOutput,
} from "./commands/UpdateUserProfileCommand";
import {
  UpdateWorkforceCommandInput,
  UpdateWorkforceCommandOutput,
} from "./commands/UpdateWorkforceCommand";
import {
  UpdateWorkteamCommandInput,
  UpdateWorkteamCommandOutput,
} from "./commands/UpdateWorkteamCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | AddAssociationCommandInput
  | AddTagsCommandInput
  | AssociateTrialComponentCommandInput
  | AttachClusterNodeVolumeCommandInput
  | BatchAddClusterNodesCommandInput
  | BatchDeleteClusterNodesCommandInput
  | BatchDescribeModelPackageCommandInput
  | CreateActionCommandInput
  | CreateAlgorithmCommandInput
  | CreateAppCommandInput
  | CreateAppImageConfigCommandInput
  | CreateArtifactCommandInput
  | CreateAutoMLJobCommandInput
  | CreateAutoMLJobV2CommandInput
  | CreateClusterCommandInput
  | CreateClusterSchedulerConfigCommandInput
  | CreateCodeRepositoryCommandInput
  | CreateCompilationJobCommandInput
  | CreateComputeQuotaCommandInput
  | CreateContextCommandInput
  | CreateDataQualityJobDefinitionCommandInput
  | CreateDeviceFleetCommandInput
  | CreateDomainCommandInput
  | CreateEdgeDeploymentPlanCommandInput
  | CreateEdgeDeploymentStageCommandInput
  | CreateEdgePackagingJobCommandInput
  | CreateEndpointCommandInput
  | CreateEndpointConfigCommandInput
  | CreateExperimentCommandInput
  | CreateFeatureGroupCommandInput
  | CreateFlowDefinitionCommandInput
  | CreateHubCommandInput
  | CreateHubContentPresignedUrlsCommandInput
  | CreateHubContentReferenceCommandInput
  | CreateHumanTaskUiCommandInput
  | CreateHyperParameterTuningJobCommandInput
  | CreateImageCommandInput
  | CreateImageVersionCommandInput
  | CreateInferenceComponentCommandInput
  | CreateInferenceExperimentCommandInput
  | CreateInferenceRecommendationsJobCommandInput
  | CreateLabelingJobCommandInput
  | CreateMlflowTrackingServerCommandInput
  | CreateModelBiasJobDefinitionCommandInput
  | CreateModelCardCommandInput
  | CreateModelCardExportJobCommandInput
  | CreateModelCommandInput
  | CreateModelExplainabilityJobDefinitionCommandInput
  | CreateModelPackageCommandInput
  | CreateModelPackageGroupCommandInput
  | CreateModelQualityJobDefinitionCommandInput
  | CreateMonitoringScheduleCommandInput
  | CreateNotebookInstanceCommandInput
  | CreateNotebookInstanceLifecycleConfigCommandInput
  | CreateOptimizationJobCommandInput
  | CreatePartnerAppCommandInput
  | CreatePartnerAppPresignedUrlCommandInput
  | CreatePipelineCommandInput
  | CreatePresignedDomainUrlCommandInput
  | CreatePresignedMlflowTrackingServerUrlCommandInput
  | CreatePresignedNotebookInstanceUrlCommandInput
  | CreateProcessingJobCommandInput
  | CreateProjectCommandInput
  | CreateSpaceCommandInput
  | CreateStudioLifecycleConfigCommandInput
  | CreateTrainingJobCommandInput
  | CreateTrainingPlanCommandInput
  | CreateTransformJobCommandInput
  | CreateTrialCommandInput
  | CreateTrialComponentCommandInput
  | CreateUserProfileCommandInput
  | CreateWorkforceCommandInput
  | CreateWorkteamCommandInput
  | DeleteActionCommandInput
  | DeleteAlgorithmCommandInput
  | DeleteAppCommandInput
  | DeleteAppImageConfigCommandInput
  | DeleteArtifactCommandInput
  | DeleteAssociationCommandInput
  | DeleteClusterCommandInput
  | DeleteClusterSchedulerConfigCommandInput
  | DeleteCodeRepositoryCommandInput
  | DeleteCompilationJobCommandInput
  | DeleteComputeQuotaCommandInput
  | DeleteContextCommandInput
  | DeleteDataQualityJobDefinitionCommandInput
  | DeleteDeviceFleetCommandInput
  | DeleteDomainCommandInput
  | DeleteEdgeDeploymentPlanCommandInput
  | DeleteEdgeDeploymentStageCommandInput
  | DeleteEndpointCommandInput
  | DeleteEndpointConfigCommandInput
  | DeleteExperimentCommandInput
  | DeleteFeatureGroupCommandInput
  | DeleteFlowDefinitionCommandInput
  | DeleteHubCommandInput
  | DeleteHubContentCommandInput
  | DeleteHubContentReferenceCommandInput
  | DeleteHumanTaskUiCommandInput
  | DeleteHyperParameterTuningJobCommandInput
  | DeleteImageCommandInput
  | DeleteImageVersionCommandInput
  | DeleteInferenceComponentCommandInput
  | DeleteInferenceExperimentCommandInput
  | DeleteMlflowTrackingServerCommandInput
  | DeleteModelBiasJobDefinitionCommandInput
  | DeleteModelCardCommandInput
  | DeleteModelCommandInput
  | DeleteModelExplainabilityJobDefinitionCommandInput
  | DeleteModelPackageCommandInput
  | DeleteModelPackageGroupCommandInput
  | DeleteModelPackageGroupPolicyCommandInput
  | DeleteModelQualityJobDefinitionCommandInput
  | DeleteMonitoringScheduleCommandInput
  | DeleteNotebookInstanceCommandInput
  | DeleteNotebookInstanceLifecycleConfigCommandInput
  | DeleteOptimizationJobCommandInput
  | DeletePartnerAppCommandInput
  | DeletePipelineCommandInput
  | DeleteProjectCommandInput
  | DeleteSpaceCommandInput
  | DeleteStudioLifecycleConfigCommandInput
  | DeleteTagsCommandInput
  | DeleteTrialCommandInput
  | DeleteTrialComponentCommandInput
  | DeleteUserProfileCommandInput
  | DeleteWorkforceCommandInput
  | DeleteWorkteamCommandInput
  | DeregisterDevicesCommandInput
  | DescribeActionCommandInput
  | DescribeAlgorithmCommandInput
  | DescribeAppCommandInput
  | DescribeAppImageConfigCommandInput
  | DescribeArtifactCommandInput
  | DescribeAutoMLJobCommandInput
  | DescribeAutoMLJobV2CommandInput
  | DescribeClusterCommandInput
  | DescribeClusterEventCommandInput
  | DescribeClusterNodeCommandInput
  | DescribeClusterSchedulerConfigCommandInput
  | DescribeCodeRepositoryCommandInput
  | DescribeCompilationJobCommandInput
  | DescribeComputeQuotaCommandInput
  | DescribeContextCommandInput
  | DescribeDataQualityJobDefinitionCommandInput
  | DescribeDeviceCommandInput
  | DescribeDeviceFleetCommandInput
  | DescribeDomainCommandInput
  | DescribeEdgeDeploymentPlanCommandInput
  | DescribeEdgePackagingJobCommandInput
  | DescribeEndpointCommandInput
  | DescribeEndpointConfigCommandInput
  | DescribeExperimentCommandInput
  | DescribeFeatureGroupCommandInput
  | DescribeFeatureMetadataCommandInput
  | DescribeFlowDefinitionCommandInput
  | DescribeHubCommandInput
  | DescribeHubContentCommandInput
  | DescribeHumanTaskUiCommandInput
  | DescribeHyperParameterTuningJobCommandInput
  | DescribeImageCommandInput
  | DescribeImageVersionCommandInput
  | DescribeInferenceComponentCommandInput
  | DescribeInferenceExperimentCommandInput
  | DescribeInferenceRecommendationsJobCommandInput
  | DescribeLabelingJobCommandInput
  | DescribeLineageGroupCommandInput
  | DescribeMlflowTrackingServerCommandInput
  | DescribeModelBiasJobDefinitionCommandInput
  | DescribeModelCardCommandInput
  | DescribeModelCardExportJobCommandInput
  | DescribeModelCommandInput
  | DescribeModelExplainabilityJobDefinitionCommandInput
  | DescribeModelPackageCommandInput
  | DescribeModelPackageGroupCommandInput
  | DescribeModelQualityJobDefinitionCommandInput
  | DescribeMonitoringScheduleCommandInput
  | DescribeNotebookInstanceCommandInput
  | DescribeNotebookInstanceLifecycleConfigCommandInput
  | DescribeOptimizationJobCommandInput
  | DescribePartnerAppCommandInput
  | DescribePipelineCommandInput
  | DescribePipelineDefinitionForExecutionCommandInput
  | DescribePipelineExecutionCommandInput
  | DescribeProcessingJobCommandInput
  | DescribeProjectCommandInput
  | DescribeReservedCapacityCommandInput
  | DescribeSpaceCommandInput
  | DescribeStudioLifecycleConfigCommandInput
  | DescribeSubscribedWorkteamCommandInput
  | DescribeTrainingJobCommandInput
  | DescribeTrainingPlanCommandInput
  | DescribeTransformJobCommandInput
  | DescribeTrialCommandInput
  | DescribeTrialComponentCommandInput
  | DescribeUserProfileCommandInput
  | DescribeWorkforceCommandInput
  | DescribeWorkteamCommandInput
  | DetachClusterNodeVolumeCommandInput
  | DisableSagemakerServicecatalogPortfolioCommandInput
  | DisassociateTrialComponentCommandInput
  | EnableSagemakerServicecatalogPortfolioCommandInput
  | GetDeviceFleetReportCommandInput
  | GetLineageGroupPolicyCommandInput
  | GetModelPackageGroupPolicyCommandInput
  | GetSagemakerServicecatalogPortfolioStatusCommandInput
  | GetScalingConfigurationRecommendationCommandInput
  | GetSearchSuggestionsCommandInput
  | ImportHubContentCommandInput
  | ListActionsCommandInput
  | ListAlgorithmsCommandInput
  | ListAliasesCommandInput
  | ListAppImageConfigsCommandInput
  | ListAppsCommandInput
  | ListArtifactsCommandInput
  | ListAssociationsCommandInput
  | ListAutoMLJobsCommandInput
  | ListCandidatesForAutoMLJobCommandInput
  | ListClusterEventsCommandInput
  | ListClusterNodesCommandInput
  | ListClusterSchedulerConfigsCommandInput
  | ListClustersCommandInput
  | ListCodeRepositoriesCommandInput
  | ListCompilationJobsCommandInput
  | ListComputeQuotasCommandInput
  | ListContextsCommandInput
  | ListDataQualityJobDefinitionsCommandInput
  | ListDeviceFleetsCommandInput
  | ListDevicesCommandInput
  | ListDomainsCommandInput
  | ListEdgeDeploymentPlansCommandInput
  | ListEdgePackagingJobsCommandInput
  | ListEndpointConfigsCommandInput
  | ListEndpointsCommandInput
  | ListExperimentsCommandInput
  | ListFeatureGroupsCommandInput
  | ListFlowDefinitionsCommandInput
  | ListHubContentVersionsCommandInput
  | ListHubContentsCommandInput
  | ListHubsCommandInput
  | ListHumanTaskUisCommandInput
  | ListHyperParameterTuningJobsCommandInput
  | ListImageVersionsCommandInput
  | ListImagesCommandInput
  | ListInferenceComponentsCommandInput
  | ListInferenceExperimentsCommandInput
  | ListInferenceRecommendationsJobStepsCommandInput
  | ListInferenceRecommendationsJobsCommandInput
  | ListLabelingJobsCommandInput
  | ListLabelingJobsForWorkteamCommandInput
  | ListLineageGroupsCommandInput
  | ListMlflowTrackingServersCommandInput
  | ListModelBiasJobDefinitionsCommandInput
  | ListModelCardExportJobsCommandInput
  | ListModelCardVersionsCommandInput
  | ListModelCardsCommandInput
  | ListModelExplainabilityJobDefinitionsCommandInput
  | ListModelMetadataCommandInput
  | ListModelPackageGroupsCommandInput
  | ListModelPackagesCommandInput
  | ListModelQualityJobDefinitionsCommandInput
  | ListModelsCommandInput
  | ListMonitoringAlertHistoryCommandInput
  | ListMonitoringAlertsCommandInput
  | ListMonitoringExecutionsCommandInput
  | ListMonitoringSchedulesCommandInput
  | ListNotebookInstanceLifecycleConfigsCommandInput
  | ListNotebookInstancesCommandInput
  | ListOptimizationJobsCommandInput
  | ListPartnerAppsCommandInput
  | ListPipelineExecutionStepsCommandInput
  | ListPipelineExecutionsCommandInput
  | ListPipelineParametersForExecutionCommandInput
  | ListPipelineVersionsCommandInput
  | ListPipelinesCommandInput
  | ListProcessingJobsCommandInput
  | ListProjectsCommandInput
  | ListResourceCatalogsCommandInput
  | ListSpacesCommandInput
  | ListStageDevicesCommandInput
  | ListStudioLifecycleConfigsCommandInput
  | ListSubscribedWorkteamsCommandInput
  | ListTagsCommandInput
  | ListTrainingJobsCommandInput
  | ListTrainingJobsForHyperParameterTuningJobCommandInput
  | ListTrainingPlansCommandInput
  | ListTransformJobsCommandInput
  | ListTrialComponentsCommandInput
  | ListTrialsCommandInput
  | ListUltraServersByReservedCapacityCommandInput
  | ListUserProfilesCommandInput
  | ListWorkforcesCommandInput
  | ListWorkteamsCommandInput
  | PutModelPackageGroupPolicyCommandInput
  | QueryLineageCommandInput
  | RegisterDevicesCommandInput
  | RenderUiTemplateCommandInput
  | RetryPipelineExecutionCommandInput
  | SearchCommandInput
  | SearchTrainingPlanOfferingsCommandInput
  | SendPipelineExecutionStepFailureCommandInput
  | SendPipelineExecutionStepSuccessCommandInput
  | StartEdgeDeploymentStageCommandInput
  | StartInferenceExperimentCommandInput
  | StartMlflowTrackingServerCommandInput
  | StartMonitoringScheduleCommandInput
  | StartNotebookInstanceCommandInput
  | StartPipelineExecutionCommandInput
  | StartSessionCommandInput
  | StopAutoMLJobCommandInput
  | StopCompilationJobCommandInput
  | StopEdgeDeploymentStageCommandInput
  | StopEdgePackagingJobCommandInput
  | StopHyperParameterTuningJobCommandInput
  | StopInferenceExperimentCommandInput
  | StopInferenceRecommendationsJobCommandInput
  | StopLabelingJobCommandInput
  | StopMlflowTrackingServerCommandInput
  | StopMonitoringScheduleCommandInput
  | StopNotebookInstanceCommandInput
  | StopOptimizationJobCommandInput
  | StopPipelineExecutionCommandInput
  | StopProcessingJobCommandInput
  | StopTrainingJobCommandInput
  | StopTransformJobCommandInput
  | UpdateActionCommandInput
  | UpdateAppImageConfigCommandInput
  | UpdateArtifactCommandInput
  | UpdateClusterCommandInput
  | UpdateClusterSchedulerConfigCommandInput
  | UpdateClusterSoftwareCommandInput
  | UpdateCodeRepositoryCommandInput
  | UpdateComputeQuotaCommandInput
  | UpdateContextCommandInput
  | UpdateDeviceFleetCommandInput
  | UpdateDevicesCommandInput
  | UpdateDomainCommandInput
  | UpdateEndpointCommandInput
  | UpdateEndpointWeightsAndCapacitiesCommandInput
  | UpdateExperimentCommandInput
  | UpdateFeatureGroupCommandInput
  | UpdateFeatureMetadataCommandInput
  | UpdateHubCommandInput
  | UpdateHubContentCommandInput
  | UpdateHubContentReferenceCommandInput
  | UpdateImageCommandInput
  | UpdateImageVersionCommandInput
  | UpdateInferenceComponentCommandInput
  | UpdateInferenceComponentRuntimeConfigCommandInput
  | UpdateInferenceExperimentCommandInput
  | UpdateMlflowTrackingServerCommandInput
  | UpdateModelCardCommandInput
  | UpdateModelPackageCommandInput
  | UpdateMonitoringAlertCommandInput
  | UpdateMonitoringScheduleCommandInput
  | UpdateNotebookInstanceCommandInput
  | UpdateNotebookInstanceLifecycleConfigCommandInput
  | UpdatePartnerAppCommandInput
  | UpdatePipelineCommandInput
  | UpdatePipelineExecutionCommandInput
  | UpdatePipelineVersionCommandInput
  | UpdateProjectCommandInput
  | UpdateSpaceCommandInput
  | UpdateTrainingJobCommandInput
  | UpdateTrialCommandInput
  | UpdateTrialComponentCommandInput
  | UpdateUserProfileCommandInput
  | UpdateWorkforceCommandInput
  | UpdateWorkteamCommandInput;
export type ServiceOutputTypes =
  | AddAssociationCommandOutput
  | AddTagsCommandOutput
  | AssociateTrialComponentCommandOutput
  | AttachClusterNodeVolumeCommandOutput
  | BatchAddClusterNodesCommandOutput
  | BatchDeleteClusterNodesCommandOutput
  | BatchDescribeModelPackageCommandOutput
  | CreateActionCommandOutput
  | CreateAlgorithmCommandOutput
  | CreateAppCommandOutput
  | CreateAppImageConfigCommandOutput
  | CreateArtifactCommandOutput
  | CreateAutoMLJobCommandOutput
  | CreateAutoMLJobV2CommandOutput
  | CreateClusterCommandOutput
  | CreateClusterSchedulerConfigCommandOutput
  | CreateCodeRepositoryCommandOutput
  | CreateCompilationJobCommandOutput
  | CreateComputeQuotaCommandOutput
  | CreateContextCommandOutput
  | CreateDataQualityJobDefinitionCommandOutput
  | CreateDeviceFleetCommandOutput
  | CreateDomainCommandOutput
  | CreateEdgeDeploymentPlanCommandOutput
  | CreateEdgeDeploymentStageCommandOutput
  | CreateEdgePackagingJobCommandOutput
  | CreateEndpointCommandOutput
  | CreateEndpointConfigCommandOutput
  | CreateExperimentCommandOutput
  | CreateFeatureGroupCommandOutput
  | CreateFlowDefinitionCommandOutput
  | CreateHubCommandOutput
  | CreateHubContentPresignedUrlsCommandOutput
  | CreateHubContentReferenceCommandOutput
  | CreateHumanTaskUiCommandOutput
  | CreateHyperParameterTuningJobCommandOutput
  | CreateImageCommandOutput
  | CreateImageVersionCommandOutput
  | CreateInferenceComponentCommandOutput
  | CreateInferenceExperimentCommandOutput
  | CreateInferenceRecommendationsJobCommandOutput
  | CreateLabelingJobCommandOutput
  | CreateMlflowTrackingServerCommandOutput
  | CreateModelBiasJobDefinitionCommandOutput
  | CreateModelCardCommandOutput
  | CreateModelCardExportJobCommandOutput
  | CreateModelCommandOutput
  | CreateModelExplainabilityJobDefinitionCommandOutput
  | CreateModelPackageCommandOutput
  | CreateModelPackageGroupCommandOutput
  | CreateModelQualityJobDefinitionCommandOutput
  | CreateMonitoringScheduleCommandOutput
  | CreateNotebookInstanceCommandOutput
  | CreateNotebookInstanceLifecycleConfigCommandOutput
  | CreateOptimizationJobCommandOutput
  | CreatePartnerAppCommandOutput
  | CreatePartnerAppPresignedUrlCommandOutput
  | CreatePipelineCommandOutput
  | CreatePresignedDomainUrlCommandOutput
  | CreatePresignedMlflowTrackingServerUrlCommandOutput
  | CreatePresignedNotebookInstanceUrlCommandOutput
  | CreateProcessingJobCommandOutput
  | CreateProjectCommandOutput
  | CreateSpaceCommandOutput
  | CreateStudioLifecycleConfigCommandOutput
  | CreateTrainingJobCommandOutput
  | CreateTrainingPlanCommandOutput
  | CreateTransformJobCommandOutput
  | CreateTrialCommandOutput
  | CreateTrialComponentCommandOutput
  | CreateUserProfileCommandOutput
  | CreateWorkforceCommandOutput
  | CreateWorkteamCommandOutput
  | DeleteActionCommandOutput
  | DeleteAlgorithmCommandOutput
  | DeleteAppCommandOutput
  | DeleteAppImageConfigCommandOutput
  | DeleteArtifactCommandOutput
  | DeleteAssociationCommandOutput
  | DeleteClusterCommandOutput
  | DeleteClusterSchedulerConfigCommandOutput
  | DeleteCodeRepositoryCommandOutput
  | DeleteCompilationJobCommandOutput
  | DeleteComputeQuotaCommandOutput
  | DeleteContextCommandOutput
  | DeleteDataQualityJobDefinitionCommandOutput
  | DeleteDeviceFleetCommandOutput
  | DeleteDomainCommandOutput
  | DeleteEdgeDeploymentPlanCommandOutput
  | DeleteEdgeDeploymentStageCommandOutput
  | DeleteEndpointCommandOutput
  | DeleteEndpointConfigCommandOutput
  | DeleteExperimentCommandOutput
  | DeleteFeatureGroupCommandOutput
  | DeleteFlowDefinitionCommandOutput
  | DeleteHubCommandOutput
  | DeleteHubContentCommandOutput
  | DeleteHubContentReferenceCommandOutput
  | DeleteHumanTaskUiCommandOutput
  | DeleteHyperParameterTuningJobCommandOutput
  | DeleteImageCommandOutput
  | DeleteImageVersionCommandOutput
  | DeleteInferenceComponentCommandOutput
  | DeleteInferenceExperimentCommandOutput
  | DeleteMlflowTrackingServerCommandOutput
  | DeleteModelBiasJobDefinitionCommandOutput
  | DeleteModelCardCommandOutput
  | DeleteModelCommandOutput
  | DeleteModelExplainabilityJobDefinitionCommandOutput
  | DeleteModelPackageCommandOutput
  | DeleteModelPackageGroupCommandOutput
  | DeleteModelPackageGroupPolicyCommandOutput
  | DeleteModelQualityJobDefinitionCommandOutput
  | DeleteMonitoringScheduleCommandOutput
  | DeleteNotebookInstanceCommandOutput
  | DeleteNotebookInstanceLifecycleConfigCommandOutput
  | DeleteOptimizationJobCommandOutput
  | DeletePartnerAppCommandOutput
  | DeletePipelineCommandOutput
  | DeleteProjectCommandOutput
  | DeleteSpaceCommandOutput
  | DeleteStudioLifecycleConfigCommandOutput
  | DeleteTagsCommandOutput
  | DeleteTrialCommandOutput
  | DeleteTrialComponentCommandOutput
  | DeleteUserProfileCommandOutput
  | DeleteWorkforceCommandOutput
  | DeleteWorkteamCommandOutput
  | DeregisterDevicesCommandOutput
  | DescribeActionCommandOutput
  | DescribeAlgorithmCommandOutput
  | DescribeAppCommandOutput
  | DescribeAppImageConfigCommandOutput
  | DescribeArtifactCommandOutput
  | DescribeAutoMLJobCommandOutput
  | DescribeAutoMLJobV2CommandOutput
  | DescribeClusterCommandOutput
  | DescribeClusterEventCommandOutput
  | DescribeClusterNodeCommandOutput
  | DescribeClusterSchedulerConfigCommandOutput
  | DescribeCodeRepositoryCommandOutput
  | DescribeCompilationJobCommandOutput
  | DescribeComputeQuotaCommandOutput
  | DescribeContextCommandOutput
  | DescribeDataQualityJobDefinitionCommandOutput
  | DescribeDeviceCommandOutput
  | DescribeDeviceFleetCommandOutput
  | DescribeDomainCommandOutput
  | DescribeEdgeDeploymentPlanCommandOutput
  | DescribeEdgePackagingJobCommandOutput
  | DescribeEndpointCommandOutput
  | DescribeEndpointConfigCommandOutput
  | DescribeExperimentCommandOutput
  | DescribeFeatureGroupCommandOutput
  | DescribeFeatureMetadataCommandOutput
  | DescribeFlowDefinitionCommandOutput
  | DescribeHubCommandOutput
  | DescribeHubContentCommandOutput
  | DescribeHumanTaskUiCommandOutput
  | DescribeHyperParameterTuningJobCommandOutput
  | DescribeImageCommandOutput
  | DescribeImageVersionCommandOutput
  | DescribeInferenceComponentCommandOutput
  | DescribeInferenceExperimentCommandOutput
  | DescribeInferenceRecommendationsJobCommandOutput
  | DescribeLabelingJobCommandOutput
  | DescribeLineageGroupCommandOutput
  | DescribeMlflowTrackingServerCommandOutput
  | DescribeModelBiasJobDefinitionCommandOutput
  | DescribeModelCardCommandOutput
  | DescribeModelCardExportJobCommandOutput
  | DescribeModelCommandOutput
  | DescribeModelExplainabilityJobDefinitionCommandOutput
  | DescribeModelPackageCommandOutput
  | DescribeModelPackageGroupCommandOutput
  | DescribeModelQualityJobDefinitionCommandOutput
  | DescribeMonitoringScheduleCommandOutput
  | DescribeNotebookInstanceCommandOutput
  | DescribeNotebookInstanceLifecycleConfigCommandOutput
  | DescribeOptimizationJobCommandOutput
  | DescribePartnerAppCommandOutput
  | DescribePipelineCommandOutput
  | DescribePipelineDefinitionForExecutionCommandOutput
  | DescribePipelineExecutionCommandOutput
  | DescribeProcessingJobCommandOutput
  | DescribeProjectCommandOutput
  | DescribeReservedCapacityCommandOutput
  | DescribeSpaceCommandOutput
  | DescribeStudioLifecycleConfigCommandOutput
  | DescribeSubscribedWorkteamCommandOutput
  | DescribeTrainingJobCommandOutput
  | DescribeTrainingPlanCommandOutput
  | DescribeTransformJobCommandOutput
  | DescribeTrialCommandOutput
  | DescribeTrialComponentCommandOutput
  | DescribeUserProfileCommandOutput
  | DescribeWorkforceCommandOutput
  | DescribeWorkteamCommandOutput
  | DetachClusterNodeVolumeCommandOutput
  | DisableSagemakerServicecatalogPortfolioCommandOutput
  | DisassociateTrialComponentCommandOutput
  | EnableSagemakerServicecatalogPortfolioCommandOutput
  | GetDeviceFleetReportCommandOutput
  | GetLineageGroupPolicyCommandOutput
  | GetModelPackageGroupPolicyCommandOutput
  | GetSagemakerServicecatalogPortfolioStatusCommandOutput
  | GetScalingConfigurationRecommendationCommandOutput
  | GetSearchSuggestionsCommandOutput
  | ImportHubContentCommandOutput
  | ListActionsCommandOutput
  | ListAlgorithmsCommandOutput
  | ListAliasesCommandOutput
  | ListAppImageConfigsCommandOutput
  | ListAppsCommandOutput
  | ListArtifactsCommandOutput
  | ListAssociationsCommandOutput
  | ListAutoMLJobsCommandOutput
  | ListCandidatesForAutoMLJobCommandOutput
  | ListClusterEventsCommandOutput
  | ListClusterNodesCommandOutput
  | ListClusterSchedulerConfigsCommandOutput
  | ListClustersCommandOutput
  | ListCodeRepositoriesCommandOutput
  | ListCompilationJobsCommandOutput
  | ListComputeQuotasCommandOutput
  | ListContextsCommandOutput
  | ListDataQualityJobDefinitionsCommandOutput
  | ListDeviceFleetsCommandOutput
  | ListDevicesCommandOutput
  | ListDomainsCommandOutput
  | ListEdgeDeploymentPlansCommandOutput
  | ListEdgePackagingJobsCommandOutput
  | ListEndpointConfigsCommandOutput
  | ListEndpointsCommandOutput
  | ListExperimentsCommandOutput
  | ListFeatureGroupsCommandOutput
  | ListFlowDefinitionsCommandOutput
  | ListHubContentVersionsCommandOutput
  | ListHubContentsCommandOutput
  | ListHubsCommandOutput
  | ListHumanTaskUisCommandOutput
  | ListHyperParameterTuningJobsCommandOutput
  | ListImageVersionsCommandOutput
  | ListImagesCommandOutput
  | ListInferenceComponentsCommandOutput
  | ListInferenceExperimentsCommandOutput
  | ListInferenceRecommendationsJobStepsCommandOutput
  | ListInferenceRecommendationsJobsCommandOutput
  | ListLabelingJobsCommandOutput
  | ListLabelingJobsForWorkteamCommandOutput
  | ListLineageGroupsCommandOutput
  | ListMlflowTrackingServersCommandOutput
  | ListModelBiasJobDefinitionsCommandOutput
  | ListModelCardExportJobsCommandOutput
  | ListModelCardVersionsCommandOutput
  | ListModelCardsCommandOutput
  | ListModelExplainabilityJobDefinitionsCommandOutput
  | ListModelMetadataCommandOutput
  | ListModelPackageGroupsCommandOutput
  | ListModelPackagesCommandOutput
  | ListModelQualityJobDefinitionsCommandOutput
  | ListModelsCommandOutput
  | ListMonitoringAlertHistoryCommandOutput
  | ListMonitoringAlertsCommandOutput
  | ListMonitoringExecutionsCommandOutput
  | ListMonitoringSchedulesCommandOutput
  | ListNotebookInstanceLifecycleConfigsCommandOutput
  | ListNotebookInstancesCommandOutput
  | ListOptimizationJobsCommandOutput
  | ListPartnerAppsCommandOutput
  | ListPipelineExecutionStepsCommandOutput
  | ListPipelineExecutionsCommandOutput
  | ListPipelineParametersForExecutionCommandOutput
  | ListPipelineVersionsCommandOutput
  | ListPipelinesCommandOutput
  | ListProcessingJobsCommandOutput
  | ListProjectsCommandOutput
  | ListResourceCatalogsCommandOutput
  | ListSpacesCommandOutput
  | ListStageDevicesCommandOutput
  | ListStudioLifecycleConfigsCommandOutput
  | ListSubscribedWorkteamsCommandOutput
  | ListTagsCommandOutput
  | ListTrainingJobsCommandOutput
  | ListTrainingJobsForHyperParameterTuningJobCommandOutput
  | ListTrainingPlansCommandOutput
  | ListTransformJobsCommandOutput
  | ListTrialComponentsCommandOutput
  | ListTrialsCommandOutput
  | ListUltraServersByReservedCapacityCommandOutput
  | ListUserProfilesCommandOutput
  | ListWorkforcesCommandOutput
  | ListWorkteamsCommandOutput
  | PutModelPackageGroupPolicyCommandOutput
  | QueryLineageCommandOutput
  | RegisterDevicesCommandOutput
  | RenderUiTemplateCommandOutput
  | RetryPipelineExecutionCommandOutput
  | SearchCommandOutput
  | SearchTrainingPlanOfferingsCommandOutput
  | SendPipelineExecutionStepFailureCommandOutput
  | SendPipelineExecutionStepSuccessCommandOutput
  | StartEdgeDeploymentStageCommandOutput
  | StartInferenceExperimentCommandOutput
  | StartMlflowTrackingServerCommandOutput
  | StartMonitoringScheduleCommandOutput
  | StartNotebookInstanceCommandOutput
  | StartPipelineExecutionCommandOutput
  | StartSessionCommandOutput
  | StopAutoMLJobCommandOutput
  | StopCompilationJobCommandOutput
  | StopEdgeDeploymentStageCommandOutput
  | StopEdgePackagingJobCommandOutput
  | StopHyperParameterTuningJobCommandOutput
  | StopInferenceExperimentCommandOutput
  | StopInferenceRecommendationsJobCommandOutput
  | StopLabelingJobCommandOutput
  | StopMlflowTrackingServerCommandOutput
  | StopMonitoringScheduleCommandOutput
  | StopNotebookInstanceCommandOutput
  | StopOptimizationJobCommandOutput
  | StopPipelineExecutionCommandOutput
  | StopProcessingJobCommandOutput
  | StopTrainingJobCommandOutput
  | StopTransformJobCommandOutput
  | UpdateActionCommandOutput
  | UpdateAppImageConfigCommandOutput
  | UpdateArtifactCommandOutput
  | UpdateClusterCommandOutput
  | UpdateClusterSchedulerConfigCommandOutput
  | UpdateClusterSoftwareCommandOutput
  | UpdateCodeRepositoryCommandOutput
  | UpdateComputeQuotaCommandOutput
  | UpdateContextCommandOutput
  | UpdateDeviceFleetCommandOutput
  | UpdateDevicesCommandOutput
  | UpdateDomainCommandOutput
  | UpdateEndpointCommandOutput
  | UpdateEndpointWeightsAndCapacitiesCommandOutput
  | UpdateExperimentCommandOutput
  | UpdateFeatureGroupCommandOutput
  | UpdateFeatureMetadataCommandOutput
  | UpdateHubCommandOutput
  | UpdateHubContentCommandOutput
  | UpdateHubContentReferenceCommandOutput
  | UpdateImageCommandOutput
  | UpdateImageVersionCommandOutput
  | UpdateInferenceComponentCommandOutput
  | UpdateInferenceComponentRuntimeConfigCommandOutput
  | UpdateInferenceExperimentCommandOutput
  | UpdateMlflowTrackingServerCommandOutput
  | UpdateModelCardCommandOutput
  | UpdateModelPackageCommandOutput
  | UpdateMonitoringAlertCommandOutput
  | UpdateMonitoringScheduleCommandOutput
  | UpdateNotebookInstanceCommandOutput
  | UpdateNotebookInstanceLifecycleConfigCommandOutput
  | UpdatePartnerAppCommandOutput
  | UpdatePipelineCommandOutput
  | UpdatePipelineExecutionCommandOutput
  | UpdatePipelineVersionCommandOutput
  | UpdateProjectCommandOutput
  | UpdateSpaceCommandOutput
  | UpdateTrainingJobCommandOutput
  | UpdateTrialCommandOutput
  | UpdateTrialComponentCommandOutput
  | UpdateUserProfileCommandOutput
  | UpdateWorkforceCommandOutput
  | UpdateWorkteamCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  profile?: string;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type SageMakerClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface SageMakerClientConfig extends SageMakerClientConfigType {}
export type SageMakerClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface SageMakerClientResolvedConfig
  extends SageMakerClientResolvedConfigType {}
export declare class SageMakerClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  SageMakerClientResolvedConfig
> {
  readonly config: SageMakerClientResolvedConfig;
  constructor(
    ...[configuration]: __CheckOptionalClientConfig<SageMakerClientConfig>
  );
  destroy(): void;
}
