import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListImagesCommand, se_ListImagesCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class ListImagesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("SageMaker", "ListImages", {})
    .n("SageMakerClient", "ListImagesCommand")
    .f(void 0, void 0)
    .ser(se_ListImagesCommand)
    .de(de_ListImagesCommand)
    .build() {
}
