import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import { BedrockAgentRuntimeClient } from "./BedrockAgentRuntimeClient";
import {
  CreateInvocationCommandInput,
  CreateInvocationCommandOutput,
} from "./commands/CreateInvocationCommand";
import {
  CreateSessionCommandInput,
  CreateSessionCommandOutput,
} from "./commands/CreateSessionCommand";
import {
  DeleteAgentMemoryCommandInput,
  DeleteAgentMemoryCommandOutput,
} from "./commands/DeleteAgentMemoryCommand";
import {
  DeleteSessionCommandInput,
  DeleteSessionCommandOutput,
} from "./commands/DeleteSessionCommand";
import {
  EndSessionCommandInput,
  EndSessionCommandOutput,
} from "./commands/EndSessionCommand";
import {
  GenerateQueryCommandInput,
  GenerateQueryCommandOutput,
} from "./commands/GenerateQueryCommand";
import {
  GetAgentMemoryCommandInput,
  GetAgentMemoryCommandOutput,
} from "./commands/GetAgentMemoryCommand";
import {
  GetExecutionFlowSnapshotCommandInput,
  GetExecutionFlowSnapshotCommandOutput,
} from "./commands/GetExecutionFlowSnapshotCommand";
import {
  GetFlowExecutionCommandInput,
  GetFlowExecutionCommandOutput,
} from "./commands/GetFlowExecutionCommand";
import {
  GetInvocationStepCommandInput,
  GetInvocationStepCommandOutput,
} from "./commands/GetInvocationStepCommand";
import {
  GetSessionCommandInput,
  GetSessionCommandOutput,
} from "./commands/GetSessionCommand";
import {
  InvokeAgentCommandInput,
  InvokeAgentCommandOutput,
} from "./commands/InvokeAgentCommand";
import {
  InvokeFlowCommandInput,
  InvokeFlowCommandOutput,
} from "./commands/InvokeFlowCommand";
import {
  InvokeInlineAgentCommandInput,
  InvokeInlineAgentCommandOutput,
} from "./commands/InvokeInlineAgentCommand";
import {
  ListFlowExecutionEventsCommandInput,
  ListFlowExecutionEventsCommandOutput,
} from "./commands/ListFlowExecutionEventsCommand";
import {
  ListFlowExecutionsCommandInput,
  ListFlowExecutionsCommandOutput,
} from "./commands/ListFlowExecutionsCommand";
import {
  ListInvocationsCommandInput,
  ListInvocationsCommandOutput,
} from "./commands/ListInvocationsCommand";
import {
  ListInvocationStepsCommandInput,
  ListInvocationStepsCommandOutput,
} from "./commands/ListInvocationStepsCommand";
import {
  ListSessionsCommandInput,
  ListSessionsCommandOutput,
} from "./commands/ListSessionsCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  OptimizePromptCommandInput,
  OptimizePromptCommandOutput,
} from "./commands/OptimizePromptCommand";
import {
  PutInvocationStepCommandInput,
  PutInvocationStepCommandOutput,
} from "./commands/PutInvocationStepCommand";
import {
  RerankCommandInput,
  RerankCommandOutput,
} from "./commands/RerankCommand";
import {
  RetrieveAndGenerateCommandInput,
  RetrieveAndGenerateCommandOutput,
} from "./commands/RetrieveAndGenerateCommand";
import {
  RetrieveAndGenerateStreamCommandInput,
  RetrieveAndGenerateStreamCommandOutput,
} from "./commands/RetrieveAndGenerateStreamCommand";
import {
  RetrieveCommandInput,
  RetrieveCommandOutput,
} from "./commands/RetrieveCommand";
import {
  StartFlowExecutionCommandInput,
  StartFlowExecutionCommandOutput,
} from "./commands/StartFlowExecutionCommand";
import {
  StopFlowExecutionCommandInput,
  StopFlowExecutionCommandOutput,
} from "./commands/StopFlowExecutionCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateSessionCommandInput,
  UpdateSessionCommandOutput,
} from "./commands/UpdateSessionCommand";
export interface BedrockAgentRuntime {
  createInvocation(
    args: CreateInvocationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateInvocationCommandOutput>;
  createInvocation(
    args: CreateInvocationCommandInput,
    cb: (err: any, data?: CreateInvocationCommandOutput) => void
  ): void;
  createInvocation(
    args: CreateInvocationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateInvocationCommandOutput) => void
  ): void;
  createSession(): Promise<CreateSessionCommandOutput>;
  createSession(
    args: CreateSessionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateSessionCommandOutput>;
  createSession(
    args: CreateSessionCommandInput,
    cb: (err: any, data?: CreateSessionCommandOutput) => void
  ): void;
  createSession(
    args: CreateSessionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateSessionCommandOutput) => void
  ): void;
  deleteAgentMemory(
    args: DeleteAgentMemoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteAgentMemoryCommandOutput>;
  deleteAgentMemory(
    args: DeleteAgentMemoryCommandInput,
    cb: (err: any, data?: DeleteAgentMemoryCommandOutput) => void
  ): void;
  deleteAgentMemory(
    args: DeleteAgentMemoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteAgentMemoryCommandOutput) => void
  ): void;
  deleteSession(
    args: DeleteSessionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteSessionCommandOutput>;
  deleteSession(
    args: DeleteSessionCommandInput,
    cb: (err: any, data?: DeleteSessionCommandOutput) => void
  ): void;
  deleteSession(
    args: DeleteSessionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteSessionCommandOutput) => void
  ): void;
  endSession(
    args: EndSessionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<EndSessionCommandOutput>;
  endSession(
    args: EndSessionCommandInput,
    cb: (err: any, data?: EndSessionCommandOutput) => void
  ): void;
  endSession(
    args: EndSessionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: EndSessionCommandOutput) => void
  ): void;
  generateQuery(
    args: GenerateQueryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GenerateQueryCommandOutput>;
  generateQuery(
    args: GenerateQueryCommandInput,
    cb: (err: any, data?: GenerateQueryCommandOutput) => void
  ): void;
  generateQuery(
    args: GenerateQueryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GenerateQueryCommandOutput) => void
  ): void;
  getAgentMemory(
    args: GetAgentMemoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetAgentMemoryCommandOutput>;
  getAgentMemory(
    args: GetAgentMemoryCommandInput,
    cb: (err: any, data?: GetAgentMemoryCommandOutput) => void
  ): void;
  getAgentMemory(
    args: GetAgentMemoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetAgentMemoryCommandOutput) => void
  ): void;
  getExecutionFlowSnapshot(
    args: GetExecutionFlowSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetExecutionFlowSnapshotCommandOutput>;
  getExecutionFlowSnapshot(
    args: GetExecutionFlowSnapshotCommandInput,
    cb: (err: any, data?: GetExecutionFlowSnapshotCommandOutput) => void
  ): void;
  getExecutionFlowSnapshot(
    args: GetExecutionFlowSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetExecutionFlowSnapshotCommandOutput) => void
  ): void;
  getFlowExecution(
    args: GetFlowExecutionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFlowExecutionCommandOutput>;
  getFlowExecution(
    args: GetFlowExecutionCommandInput,
    cb: (err: any, data?: GetFlowExecutionCommandOutput) => void
  ): void;
  getFlowExecution(
    args: GetFlowExecutionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFlowExecutionCommandOutput) => void
  ): void;
  getInvocationStep(
    args: GetInvocationStepCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetInvocationStepCommandOutput>;
  getInvocationStep(
    args: GetInvocationStepCommandInput,
    cb: (err: any, data?: GetInvocationStepCommandOutput) => void
  ): void;
  getInvocationStep(
    args: GetInvocationStepCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetInvocationStepCommandOutput) => void
  ): void;
  getSession(
    args: GetSessionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetSessionCommandOutput>;
  getSession(
    args: GetSessionCommandInput,
    cb: (err: any, data?: GetSessionCommandOutput) => void
  ): void;
  getSession(
    args: GetSessionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetSessionCommandOutput) => void
  ): void;
  invokeAgent(
    args: InvokeAgentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<InvokeAgentCommandOutput>;
  invokeAgent(
    args: InvokeAgentCommandInput,
    cb: (err: any, data?: InvokeAgentCommandOutput) => void
  ): void;
  invokeAgent(
    args: InvokeAgentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: InvokeAgentCommandOutput) => void
  ): void;
  invokeFlow(
    args: InvokeFlowCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<InvokeFlowCommandOutput>;
  invokeFlow(
    args: InvokeFlowCommandInput,
    cb: (err: any, data?: InvokeFlowCommandOutput) => void
  ): void;
  invokeFlow(
    args: InvokeFlowCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: InvokeFlowCommandOutput) => void
  ): void;
  invokeInlineAgent(
    args: InvokeInlineAgentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<InvokeInlineAgentCommandOutput>;
  invokeInlineAgent(
    args: InvokeInlineAgentCommandInput,
    cb: (err: any, data?: InvokeInlineAgentCommandOutput) => void
  ): void;
  invokeInlineAgent(
    args: InvokeInlineAgentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: InvokeInlineAgentCommandOutput) => void
  ): void;
  listFlowExecutionEvents(
    args: ListFlowExecutionEventsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFlowExecutionEventsCommandOutput>;
  listFlowExecutionEvents(
    args: ListFlowExecutionEventsCommandInput,
    cb: (err: any, data?: ListFlowExecutionEventsCommandOutput) => void
  ): void;
  listFlowExecutionEvents(
    args: ListFlowExecutionEventsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFlowExecutionEventsCommandOutput) => void
  ): void;
  listFlowExecutions(
    args: ListFlowExecutionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFlowExecutionsCommandOutput>;
  listFlowExecutions(
    args: ListFlowExecutionsCommandInput,
    cb: (err: any, data?: ListFlowExecutionsCommandOutput) => void
  ): void;
  listFlowExecutions(
    args: ListFlowExecutionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFlowExecutionsCommandOutput) => void
  ): void;
  listInvocations(
    args: ListInvocationsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListInvocationsCommandOutput>;
  listInvocations(
    args: ListInvocationsCommandInput,
    cb: (err: any, data?: ListInvocationsCommandOutput) => void
  ): void;
  listInvocations(
    args: ListInvocationsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListInvocationsCommandOutput) => void
  ): void;
  listInvocationSteps(
    args: ListInvocationStepsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListInvocationStepsCommandOutput>;
  listInvocationSteps(
    args: ListInvocationStepsCommandInput,
    cb: (err: any, data?: ListInvocationStepsCommandOutput) => void
  ): void;
  listInvocationSteps(
    args: ListInvocationStepsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListInvocationStepsCommandOutput) => void
  ): void;
  listSessions(): Promise<ListSessionsCommandOutput>;
  listSessions(
    args: ListSessionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListSessionsCommandOutput>;
  listSessions(
    args: ListSessionsCommandInput,
    cb: (err: any, data?: ListSessionsCommandOutput) => void
  ): void;
  listSessions(
    args: ListSessionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListSessionsCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  optimizePrompt(
    args: OptimizePromptCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<OptimizePromptCommandOutput>;
  optimizePrompt(
    args: OptimizePromptCommandInput,
    cb: (err: any, data?: OptimizePromptCommandOutput) => void
  ): void;
  optimizePrompt(
    args: OptimizePromptCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: OptimizePromptCommandOutput) => void
  ): void;
  putInvocationStep(
    args: PutInvocationStepCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PutInvocationStepCommandOutput>;
  putInvocationStep(
    args: PutInvocationStepCommandInput,
    cb: (err: any, data?: PutInvocationStepCommandOutput) => void
  ): void;
  putInvocationStep(
    args: PutInvocationStepCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PutInvocationStepCommandOutput) => void
  ): void;
  rerank(
    args: RerankCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RerankCommandOutput>;
  rerank(
    args: RerankCommandInput,
    cb: (err: any, data?: RerankCommandOutput) => void
  ): void;
  rerank(
    args: RerankCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RerankCommandOutput) => void
  ): void;
  retrieve(
    args: RetrieveCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RetrieveCommandOutput>;
  retrieve(
    args: RetrieveCommandInput,
    cb: (err: any, data?: RetrieveCommandOutput) => void
  ): void;
  retrieve(
    args: RetrieveCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RetrieveCommandOutput) => void
  ): void;
  retrieveAndGenerate(
    args: RetrieveAndGenerateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RetrieveAndGenerateCommandOutput>;
  retrieveAndGenerate(
    args: RetrieveAndGenerateCommandInput,
    cb: (err: any, data?: RetrieveAndGenerateCommandOutput) => void
  ): void;
  retrieveAndGenerate(
    args: RetrieveAndGenerateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RetrieveAndGenerateCommandOutput) => void
  ): void;
  retrieveAndGenerateStream(
    args: RetrieveAndGenerateStreamCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RetrieveAndGenerateStreamCommandOutput>;
  retrieveAndGenerateStream(
    args: RetrieveAndGenerateStreamCommandInput,
    cb: (err: any, data?: RetrieveAndGenerateStreamCommandOutput) => void
  ): void;
  retrieveAndGenerateStream(
    args: RetrieveAndGenerateStreamCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RetrieveAndGenerateStreamCommandOutput) => void
  ): void;
  startFlowExecution(
    args: StartFlowExecutionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartFlowExecutionCommandOutput>;
  startFlowExecution(
    args: StartFlowExecutionCommandInput,
    cb: (err: any, data?: StartFlowExecutionCommandOutput) => void
  ): void;
  startFlowExecution(
    args: StartFlowExecutionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartFlowExecutionCommandOutput) => void
  ): void;
  stopFlowExecution(
    args: StopFlowExecutionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopFlowExecutionCommandOutput>;
  stopFlowExecution(
    args: StopFlowExecutionCommandInput,
    cb: (err: any, data?: StopFlowExecutionCommandOutput) => void
  ): void;
  stopFlowExecution(
    args: StopFlowExecutionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopFlowExecutionCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TagResourceCommandOutput>;
  tagResource(
    args: TagResourceCommandInput,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UntagResourceCommandOutput>;
  untagResource(
    args: UntagResourceCommandInput,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  updateSession(
    args: UpdateSessionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateSessionCommandOutput>;
  updateSession(
    args: UpdateSessionCommandInput,
    cb: (err: any, data?: UpdateSessionCommandOutput) => void
  ): void;
  updateSession(
    args: UpdateSessionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateSessionCommandOutput) => void
  ): void;
}
export declare class BedrockAgentRuntime
  extends BedrockAgentRuntimeClient
  implements BedrockAgentRuntime {}
