import type { AuthenticatedRequest, Settings, CredentialsEntity, User, WorkflowEntity } from '@n8n/db';
import { CredentialsRepository, WorkflowRepository, SettingsRepository, UserRepository } from '@n8n/db';
import type { FindManyOptions, FindOneOptions, FindOptionsWhere } from '@n8n/typeorm';
import type { QueryDeepPartialEntity } from '@n8n/typeorm/query-builder/QueryPartialEntity';
import RudderStack, { type constructorOptions } from '@rudderstack/rudder-sdk-node';
import type { NextFunction, Response } from 'express';
import { AuthService } from '../auth/auth.service';
import type { Invitation } from '../interfaces';
import { UserService } from '../services/user.service';
export declare class HooksService {
    private readonly userService;
    private readonly authService;
    private readonly userRepository;
    private readonly settingsRepository;
    private readonly workflowRepository;
    private readonly credentialsRepository;
    private innerAuthMiddleware;
    constructor(userService: UserService, authService: AuthService, userRepository: UserRepository, settingsRepository: SettingsRepository, workflowRepository: WorkflowRepository, credentialsRepository: CredentialsRepository);
    inviteUsers(owner: User, attributes: Invitation[]): Promise<{
        usersInvited: import("../requests").UserRequest.InviteResponse[];
        usersCreated: string[];
    }>;
    issueCookie(res: Response, user: User): void;
    findOneUser(filter: FindOneOptions<User>): Promise<User | null>;
    saveUser(user: User): Promise<User>;
    updateSettings(filter: FindOptionsWhere<Settings>, set: QueryDeepPartialEntity<Settings>): Promise<import("@n8n/typeorm").UpdateResult>;
    workflowsCount(filter: FindManyOptions<WorkflowEntity>): Promise<number>;
    credentialsCount(filter: FindManyOptions<CredentialsEntity>): Promise<number>;
    settingsCount(filter: FindManyOptions<Settings>): Promise<number>;
    authMiddleware(req: AuthenticatedRequest, res: Response, next: NextFunction): Promise<void>;
    getRudderStackClient(key: string, options: constructorOptions): RudderStack;
    dbCollections(): {
        User: UserRepository;
        Settings: SettingsRepository;
        Credentials: CredentialsRepository;
        Workflow: WorkflowRepository;
    };
}
