"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnnotationTagService = void 0;
const db_1 = require("@n8n/db");
const di_1 = require("@n8n/di");
const generic_helpers_1 = require("../generic-helpers");
let AnnotationTagService = class AnnotationTagService {
    constructor(tagRepository) {
        this.tagRepository = tagRepository;
    }
    toEntity(attrs) {
        attrs.name = attrs.name.trim();
        return this.tagRepository.create(attrs);
    }
    async save(tag) {
        await (0, generic_helpers_1.validateEntity)(tag);
        return await this.tagRepository.save(tag, { transaction: false });
    }
    async delete(id) {
        return await this.tagRepository.delete(id);
    }
    async getAll(options) {
        if (options?.withUsageCount) {
            const allTags = await this.tagRepository.find({
                select: ['id', 'name', 'createdAt', 'updatedAt'],
                relations: ['annotationMappings'],
            });
            return allTags.map(({ annotationMappings, ...rest }) => {
                return {
                    ...rest,
                    usageCount: annotationMappings.length,
                };
            });
        }
        const allTags = (await this.tagRepository.find({
            select: ['id', 'name', 'createdAt', 'updatedAt'],
        }));
        return allTags;
    }
};
exports.AnnotationTagService = AnnotationTagService;
exports.AnnotationTagService = AnnotationTagService = __decorate([
    (0, di_1.Service)(),
    __metadata("design:paramtypes", [db_1.AnnotationTagRepository])
], AnnotationTagService);
//# sourceMappingURL=annotation-tag.service.ee.js.map