import { InstanceSettings } from 'n8n-core';
import { AbstractServer } from './abstract-server';
import { EventService } from './events/event.service';
import { LoadNodesAndCredentials } from './load-nodes-and-credentials';
import { PostHogClient } from './posthog';
import './controllers/active-workflows.controller';
import './controllers/annotation-tags.controller.ee';
import './controllers/auth.controller';
import './controllers/binary-data.controller';
import './controllers/ai.controller';
import './controllers/dynamic-node-parameters.controller';
import './controllers/invitation.controller';
import './controllers/me.controller';
import './controllers/node-types.controller';
import './controllers/oauth/oauth1-credential.controller';
import './controllers/oauth/oauth2-credential.controller';
import './controllers/orchestration.controller';
import './controllers/owner.controller';
import './controllers/password-reset.controller';
import './controllers/project.controller';
import './controllers/role.controller';
import './controllers/tags.controller';
import './controllers/translation.controller';
import './controllers/folder.controller';
import './controllers/users.controller';
import './controllers/user-settings.controller';
import './controllers/workflow-statistics.controller';
import './controllers/api-keys.controller';
import './credentials/credentials.controller';
import './eventbus/event-bus.controller';
import './events/events.controller';
import './executions/executions.controller';
import './license/license.controller';
import './evaluation.ee/test-runs.controller.ee';
import './workflows/workflow-history.ee/workflow-history.controller.ee';
import './workflows/workflows.controller';
import './webhooks/webhooks.controller';
export declare class Server extends AbstractServer {
    private readonly loadNodesAndCredentials;
    private readonly postHogClient;
    private readonly eventService;
    private readonly instanceSettings;
    private endpointPresetCredentials;
    private presetCredentialsLoaded;
    private frontendService?;
    constructor(loadNodesAndCredentials: LoadNodesAndCredentials, postHogClient: PostHogClient, eventService: EventService, instanceSettings: InstanceSettings);
    start(): Promise<void>;
    private registerAdditionalControllers;
    configure(): Promise<void>;
    protected setupPushServer(): void;
}
