import { Logger } from '@n8n/backend-common';
import { GlobalConfig } from '@n8n/config';
import type { DirectoryLoader, Types } from 'n8n-core';
import { ErrorReporter, InstanceSettings, PackageDirectoryLoader } from 'n8n-core';
import type { INodeTypeBaseDescription, INodeTypeDescription, LoadedClass, ICredentialType, INodeType, IVersionedNodeType, LoadedNodesAndCredentials } from 'n8n-workflow';
export declare class LoadNodesAndCredentials {
    private readonly logger;
    private readonly errorReporter;
    private readonly instanceSettings;
    private readonly globalConfig;
    private known;
    loaded: LoadedNodesAndCredentials;
    types: Types;
    loaders: Record<string, DirectoryLoader>;
    excludeNodes: {
        [n: number]: string;
        length: number;
        toString(): string;
        toLocaleString(): string;
        toLocaleString(locales: string | string[], options?: Intl.NumberFormatOptions & Intl.DateTimeFormatOptions): string;
        pop(): string | undefined;
        push(...items: string[]): number;
        concat(...items: ConcatArray<string>[]): string[];
        concat(...items: (string | ConcatArray<string>)[]): string[];
        join(separator?: string): string;
        reverse(): string[];
        shift(): string | undefined;
        slice(start?: number, end?: number): string[];
        sort(compareFn?: ((a: string, b: string) => number) | undefined): any;
        splice(start: number, deleteCount?: number): string[];
        splice(start: number, deleteCount: number, ...items: string[]): string[];
        unshift(...items: string[]): number;
        indexOf(searchElement: string, fromIndex?: number): number;
        lastIndexOf(searchElement: string, fromIndex?: number): number;
        every<S extends string>(predicate: (value: string, index: number, array: string[]) => value is S, thisArg?: any): this is S[];
        every(predicate: (value: string, index: number, array: string[]) => unknown, thisArg?: any): boolean;
        some(predicate: (value: string, index: number, array: string[]) => unknown, thisArg?: any): boolean;
        forEach(callbackfn: (value: string, index: number, array: string[]) => void, thisArg?: any): void;
        map<U>(callbackfn: (value: string, index: number, array: string[]) => U, thisArg?: any): U[];
        filter<S extends string>(predicate: (value: string, index: number, array: string[]) => value is S, thisArg?: any): S[];
        filter(predicate: (value: string, index: number, array: string[]) => unknown, thisArg?: any): string[];
        reduce(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string): string;
        reduce(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string, initialValue: string): string;
        reduce<U>(callbackfn: (previousValue: U, currentValue: string, currentIndex: number, array: string[]) => U, initialValue: U): U;
        reduceRight(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string): string;
        reduceRight(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string, initialValue: string): string;
        reduceRight<U>(callbackfn: (previousValue: U, currentValue: string, currentIndex: number, array: string[]) => U, initialValue: U): U;
        find<S extends string>(predicate: (value: string, index: number, obj: string[]) => value is S, thisArg?: any): S | undefined;
        find(predicate: (value: string, index: number, obj: string[]) => unknown, thisArg?: any): string | undefined;
        findIndex(predicate: (value: string, index: number, obj: string[]) => unknown, thisArg?: any): number;
        fill(value: string, start?: number, end?: number): any;
        copyWithin(target: number, start: number, end?: number): any;
        entries(): ArrayIterator<[number, string]>;
        keys(): ArrayIterator<number>;
        values(): ArrayIterator<string>;
        includes(searchElement: string, fromIndex?: number): boolean;
        flatMap<U, This = undefined>(callback: (this: This, value: string, index: number, array: string[]) => U | readonly U[], thisArg?: This | undefined): U[];
        flat<A, D extends number = 1>(this: A, depth?: D | undefined): FlatArray<A, D>[];
        [Symbol.iterator](): ArrayIterator<string>;
        readonly [Symbol.unscopables]: {
            [x: number]: boolean | undefined;
            length?: boolean | undefined;
            toString?: boolean | undefined;
            toLocaleString?: boolean | undefined;
            pop?: boolean | undefined;
            push?: boolean | undefined;
            concat?: boolean | undefined;
            join?: boolean | undefined;
            reverse?: boolean | undefined;
            shift?: boolean | undefined;
            slice?: boolean | undefined;
            sort?: boolean | undefined;
            splice?: boolean | undefined;
            unshift?: boolean | undefined;
            indexOf?: boolean | undefined;
            lastIndexOf?: boolean | undefined;
            every?: boolean | undefined;
            some?: boolean | undefined;
            forEach?: boolean | undefined;
            map?: boolean | undefined;
            filter?: boolean | undefined;
            reduce?: boolean | undefined;
            reduceRight?: boolean | undefined;
            find?: boolean | undefined;
            findIndex?: boolean | undefined;
            fill?: boolean | undefined;
            copyWithin?: boolean | undefined;
            entries?: boolean | undefined;
            keys?: boolean | undefined;
            values?: boolean | undefined;
            includes?: boolean | undefined;
            flatMap?: boolean | undefined;
            flat?: boolean | undefined;
            [Symbol.iterator]?: boolean | undefined;
            readonly [Symbol.unscopables]?: boolean | undefined;
            at?: boolean | undefined;
        };
        at(index: number): string | undefined;
    };
    includeNodes: {
        [n: number]: string;
        length: number;
        toString(): string;
        toLocaleString(): string;
        toLocaleString(locales: string | string[], options?: Intl.NumberFormatOptions & Intl.DateTimeFormatOptions): string;
        pop(): string | undefined;
        push(...items: string[]): number;
        concat(...items: ConcatArray<string>[]): string[];
        concat(...items: (string | ConcatArray<string>)[]): string[];
        join(separator?: string): string;
        reverse(): string[];
        shift(): string | undefined;
        slice(start?: number, end?: number): string[];
        sort(compareFn?: ((a: string, b: string) => number) | undefined): any;
        splice(start: number, deleteCount?: number): string[];
        splice(start: number, deleteCount: number, ...items: string[]): string[];
        unshift(...items: string[]): number;
        indexOf(searchElement: string, fromIndex?: number): number;
        lastIndexOf(searchElement: string, fromIndex?: number): number;
        every<S extends string>(predicate: (value: string, index: number, array: string[]) => value is S, thisArg?: any): this is S[];
        every(predicate: (value: string, index: number, array: string[]) => unknown, thisArg?: any): boolean;
        some(predicate: (value: string, index: number, array: string[]) => unknown, thisArg?: any): boolean;
        forEach(callbackfn: (value: string, index: number, array: string[]) => void, thisArg?: any): void;
        map<U>(callbackfn: (value: string, index: number, array: string[]) => U, thisArg?: any): U[];
        filter<S extends string>(predicate: (value: string, index: number, array: string[]) => value is S, thisArg?: any): S[];
        filter(predicate: (value: string, index: number, array: string[]) => unknown, thisArg?: any): string[];
        reduce(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string): string;
        reduce(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string, initialValue: string): string;
        reduce<U>(callbackfn: (previousValue: U, currentValue: string, currentIndex: number, array: string[]) => U, initialValue: U): U;
        reduceRight(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string): string;
        reduceRight(callbackfn: (previousValue: string, currentValue: string, currentIndex: number, array: string[]) => string, initialValue: string): string;
        reduceRight<U>(callbackfn: (previousValue: U, currentValue: string, currentIndex: number, array: string[]) => U, initialValue: U): U;
        find<S extends string>(predicate: (value: string, index: number, obj: string[]) => value is S, thisArg?: any): S | undefined;
        find(predicate: (value: string, index: number, obj: string[]) => unknown, thisArg?: any): string | undefined;
        findIndex(predicate: (value: string, index: number, obj: string[]) => unknown, thisArg?: any): number;
        fill(value: string, start?: number, end?: number): any;
        copyWithin(target: number, start: number, end?: number): any;
        entries(): ArrayIterator<[number, string]>;
        keys(): ArrayIterator<number>;
        values(): ArrayIterator<string>;
        includes(searchElement: string, fromIndex?: number): boolean;
        flatMap<U, This = undefined>(callback: (this: This, value: string, index: number, array: string[]) => U | readonly U[], thisArg?: This | undefined): U[];
        flat<A, D extends number = 1>(this: A, depth?: D | undefined): FlatArray<A, D>[];
        [Symbol.iterator](): ArrayIterator<string>;
        readonly [Symbol.unscopables]: {
            [x: number]: boolean | undefined;
            length?: boolean | undefined;
            toString?: boolean | undefined;
            toLocaleString?: boolean | undefined;
            pop?: boolean | undefined;
            push?: boolean | undefined;
            concat?: boolean | undefined;
            join?: boolean | undefined;
            reverse?: boolean | undefined;
            shift?: boolean | undefined;
            slice?: boolean | undefined;
            sort?: boolean | undefined;
            splice?: boolean | undefined;
            unshift?: boolean | undefined;
            indexOf?: boolean | undefined;
            lastIndexOf?: boolean | undefined;
            every?: boolean | undefined;
            some?: boolean | undefined;
            forEach?: boolean | undefined;
            map?: boolean | undefined;
            filter?: boolean | undefined;
            reduce?: boolean | undefined;
            reduceRight?: boolean | undefined;
            find?: boolean | undefined;
            findIndex?: boolean | undefined;
            fill?: boolean | undefined;
            copyWithin?: boolean | undefined;
            entries?: boolean | undefined;
            keys?: boolean | undefined;
            values?: boolean | undefined;
            includes?: boolean | undefined;
            flatMap?: boolean | undefined;
            flat?: boolean | undefined;
            [Symbol.iterator]?: boolean | undefined;
            readonly [Symbol.unscopables]?: boolean | undefined;
            at?: boolean | undefined;
        };
        at(index: number): string | undefined;
    };
    private postProcessors;
    constructor(logger: Logger, errorReporter: ErrorReporter, instanceSettings: InstanceSettings, globalConfig: GlobalConfig);
    init(): Promise<void>;
    addPostProcessor(fn: () => Promise<void>): void;
    isKnownNode(type: string): boolean;
    get loadedCredentials(): import("n8n-workflow").ICredentialTypeData;
    get loadedNodes(): import("n8n-workflow").INodeTypeData;
    get knownCredentials(): Record<string, import("n8n-workflow").CredentialLoadingDetails>;
    get knownNodes(): Record<string, import("n8n-workflow").LoadingDetails>;
    private loadNodesFromNodeModules;
    resolveIcon(packageName: string, url: string): string | undefined;
    resolveSchema({ node, version, resource, operation, }: {
        node: string;
        version: string;
        resource?: string;
        operation?: string;
    }): string | undefined;
    getCustomDirectories(): string[];
    private loadNodesFromCustomDirectories;
    loadPackage(packageName: string): Promise<PackageDirectoryLoader>;
    unloadPackage(packageName: string): Promise<void>;
    private supportsProxyAuth;
    private injectCustomApiCallOptions;
    private runDirectoryLoader;
    createAiTools(): void;
    postProcessLoaders(): Promise<void>;
    recognizesNode(fullNodeType: string): boolean;
    getNode(fullNodeType: string): LoadedClass<INodeType | IVersionedNodeType>;
    getCredential(credentialType: string): LoadedClass<ICredentialType>;
    convertNodeToAiTool<T extends object & {
        description: INodeTypeDescription | INodeTypeBaseDescription;
    }>(item: T): T;
    setupHotReload(): Promise<void>;
}
