import type { LdapConfig, ConnectionSecurity } from '@n8n/constants';
import type { AuthProviderSyncHistory } from '@n8n/db';
import { AuthIdentity, User } from '@n8n/db';
import type { Entry as LdapUser } from 'ldapts';
export declare const isLdapEnabled: () => boolean;
export declare const getLdapLoginLabel: () => string;
export declare const isLdapLoginEnabled: () => boolean;
export declare const validateLdapConfigurationSchema: (ldapConfig: LdapConfig) => {
    valid: boolean;
    message: string;
};
export declare const resolveEntryBinaryAttributes: (entry: LdapUser) => LdapUser;
export declare const resolveBinaryAttributes: (entries: LdapUser[]) => void;
export declare const createFilter: (filter: string, userFilter: string) => string;
export declare const escapeFilter: (filter: string) => string;
export declare const getAuthIdentityByLdapId: (idAttributeValue: string) => Promise<AuthIdentity | null>;
export declare const getUserByEmail: (email: string) => Promise<User | null>;
export declare const mapLdapAttributesToUser: (ldapUser: LdapUser, ldapConfig: LdapConfig) => [AuthIdentity["providerId"], Pick<User, "email" | "firstName" | "lastName">];
export declare const getLdapIds: () => Promise<string[]>;
export declare const getLdapUsers: () => Promise<User[]>;
export declare const mapLdapUserToDbUser: (ldapUser: LdapUser, ldapConfig: LdapConfig, toCreate?: boolean) => [string, User];
export declare const processUsers: (toCreateUsers: Array<[string, User]>, toUpdateUsers: Array<[string, User]>, toDisableUsers: string[]) => Promise<void>;
export declare const saveLdapSynchronization: (data: Omit<AuthProviderSyncHistory, "id" | "providerType">) => Promise<void>;
export declare const getLdapSynchronizations: (page: number, perPage: number) => Promise<AuthProviderSyncHistory[]>;
export declare const formatUrl: (url: string, port: number, security: ConnectionSecurity) => string;
export declare const getMappingAttributes: (ldapConfig: LdapConfig) => string[];
export declare const createLdapAuthIdentity: (user: User, ldapId: string) => Promise<AuthIdentity>;
export declare const createLdapUserOnLocalDb: (data: Partial<User>, ldapId: string) => Promise<User>;
export declare const updateLdapUserOnLocalDb: (identity: AuthIdentity, data: Partial<User>) => Promise<void>;
export declare const deleteAllLdapIdentities: () => Promise<import("@n8n/typeorm").DeleteResult>;
