import { GlobalConfig } from '@n8n/config';
import { CredentialsRepository, ProjectRelationRepository, SharedWorkflowRepository, WorkflowRepository } from '@n8n/db';
import { BinaryDataConfig, InstanceSettings } from 'n8n-core';
import { EventService } from '../../events/event.service';
import { License } from '../../license';
import { NodeTypes } from '../../node-types';
import { EventRelay } from './event-relay';
import { Telemetry } from '../../telemetry';
export declare class TelemetryEventRelay extends EventRelay {
    readonly eventService: EventService;
    private readonly telemetry;
    private readonly license;
    private readonly globalConfig;
    private readonly instanceSettings;
    private readonly binaryDataConfig;
    private readonly workflowRepository;
    private readonly nodeTypes;
    private readonly sharedWorkflowRepository;
    private readonly projectRelationRepository;
    private readonly credentialsRepository;
    constructor(eventService: EventService, telemetry: Telemetry, license: License, globalConfig: GlobalConfig, instanceSettings: InstanceSettings, binaryDataConfig: BinaryDataConfig, workflowRepository: WorkflowRepository, nodeTypes: NodeTypes, sharedWorkflowRepository: SharedWorkflowRepository, projectRelationRepository: ProjectRelationRepository, credentialsRepository: CredentialsRepository);
    init(): Promise<void>;
    private teamProjectUpdated;
    private teamProjectDeleted;
    private teamProjectCreated;
    private sourceControlSettingsUpdated;
    private sourceControlUserStartedPullUi;
    private sourceControlUserFinishedPullUi;
    private sourceControlUserPulledApi;
    private sourceControlUserStartedPushUi;
    private sourceControlUserFinishedPushUi;
    private licenseRenewalAttempted;
    private licenseCommunityPlusRegistered;
    private variableCreated;
    private externalSecretsProviderSettingsSaved;
    private publicApiInvoked;
    private publicApiKeyCreated;
    private publicApiKeyDeleted;
    private communityPackageInstalled;
    private communityPackageUpdated;
    private communityPackageDeleted;
    private credentialsCreated;
    private credentialsShared;
    private credentialsUpdated;
    private credentialsDeleted;
    private ldapGeneralSyncFinished;
    private ldapSettingsUpdated;
    private ldapLoginSyncFailed;
    private loginFailedDueToLdapDisabled;
    private workflowCreated;
    private workflowArchived;
    private workflowUnarchived;
    private workflowDeleted;
    private workflowSharingUpdated;
    private workflowSaved;
    private workflowPostExecute;
    private serverStarted;
    private sessionStarted;
    private instanceStopped;
    private instanceOwnerSetup;
    private firstProductionWorkflowSucceeded;
    private firstWorkflowDataLoaded;
    private userChangedRole;
    private userRetrievedUser;
    private userRetrievedAllUsers;
    private userRetrievedExecution;
    private userRetrievedAllExecutions;
    private userRetrievedWorkflow;
    private userRetrievedAllWorkflows;
    private userUpdated;
    private userDeleted;
    private userInvited;
    private userSignedUp;
    private userSubmittedPersonalizationSurvey;
    private emailFailed;
    private userTransactionalEmailSent;
    private userInviteEmailClick;
    private userPasswordResetEmailClick;
    private userPasswordResetRequestClick;
}
