import { Logger } from '@n8n/backend-common';
import type { INodeCredentials, MessageEventBusDestinationOptions } from 'n8n-workflow';
import { MessageEventBusDestinationTypeNames } from 'n8n-workflow';
import { License } from '../../license';
import type { AbstractEventMessage } from '../event-message-classes/abstract-event-message';
import type { MessageEventBus, MessageWithCallback } from '../message-event-bus/message-event-bus';
export declare abstract class MessageEventBusDestination implements MessageEventBusDestinationOptions {
    readonly id: string;
    readonly eventBusInstance: MessageEventBus;
    protected readonly logger: Logger;
    protected readonly license: License;
    __type: MessageEventBusDestinationTypeNames;
    label: string;
    enabled: boolean;
    subscribedEvents: string[];
    credentials: INodeCredentials;
    anonymizeAuditMessages: boolean;
    constructor(eventBusInstance: MessageEventBus, options: MessageEventBusDestinationOptions);
    startListening(): void;
    stopListening(): void;
    enable(): void;
    disable(): void;
    getId(): string;
    hasSubscribedToEvent(msg: AbstractEventMessage): boolean;
    saveToDb(): Promise<import("@n8n/typeorm").InsertResult>;
    deleteFromDb(): Promise<import("@n8n/typeorm").DeleteResult>;
    static deleteFromDb(id: string): Promise<import("@n8n/typeorm").DeleteResult>;
    serialize(): MessageEventBusDestinationOptions;
    abstract receiveFromEventBus(emitterPayload: MessageWithCallback): Promise<boolean>;
    toString(): string;
    close(): void | Promise<void>;
}
