import type { AxiosRequestConfig } from 'axios';
import type { MessageEventBusDestinationOptions, MessageEventBusDestinationWebhookParameterItem, MessageEventBusDestinationWebhookParameterOptions, MessageEventBusDestinationWebhookOptions } from 'n8n-workflow';
import { CredentialsHelper } from '../../credentials-helper';
import { MessageEventBusDestination } from './message-event-bus-destination.ee';
import type { MessageEventBus, MessageWithCallback } from '../message-event-bus/message-event-bus';
export declare const isMessageEventBusDestinationWebhookOptions: (candidate: unknown) => candidate is MessageEventBusDestinationWebhookOptions;
export declare class MessageEventBusDestinationWebhook extends MessageEventBusDestination implements MessageEventBusDestinationWebhookOptions {
    url: string;
    responseCodeMustMatch: boolean;
    expectedStatusCode: number;
    method: string;
    authentication: 'predefinedCredentialType' | 'genericCredentialType' | 'none';
    sendQuery: boolean;
    sendHeaders: boolean;
    genericAuthType: string;
    nodeCredentialType: string;
    specifyHeaders: string;
    specifyQuery: string;
    jsonQuery: string;
    jsonHeaders: string;
    headerParameters: MessageEventBusDestinationWebhookParameterItem;
    queryParameters: MessageEventBusDestinationWebhookParameterItem;
    options: MessageEventBusDestinationWebhookParameterOptions;
    sendPayload: boolean;
    credentialsHelper?: CredentialsHelper;
    axiosRequestOptions: AxiosRequestConfig;
    constructor(eventBusInstance: MessageEventBus, options: MessageEventBusDestinationWebhookOptions);
    matchDecryptedCredentialType(credentialType: string): Promise<import("n8n-workflow").ICredentialDataDecryptedObject | null | undefined>;
    generateAxiosOptions(): Promise<void>;
    serialize(): MessageEventBusDestinationWebhookOptions;
    static deserialize(eventBusInstance: MessageEventBus, data: MessageEventBusDestinationOptions): MessageEventBusDestinationWebhook | null;
    receiveFromEventBus(emitterPayload: MessageWithCallback): Promise<boolean>;
}
