import type { JsonObject } from 'n8n-workflow';
import { EventMessageTypeNames } from 'n8n-workflow';
import { AbstractEventMessage } from './abstract-event-message';
import type { AbstractEventMessageOptions } from './abstract-event-message-options';
import type { AbstractEventPayload } from './abstract-event-payload';
export interface EventPayloadQueue extends AbstractEventPayload {
    workflowId: string;
    jobId: string;
    executionId: string;
    hostId: string;
}
export interface EventMessageQueueOptions extends AbstractEventMessageOptions {
    payload?: EventPayloadQueue;
}
export declare class EventMessageQueue extends AbstractEventMessage {
    readonly __type = EventMessageTypeNames.runner;
    payload: EventPayloadQueue;
    constructor(options: EventMessageQueueOptions);
    setPayload(payload: EventPayloadQueue): this;
    deserialize(data: JsonObject): this;
}
