import type { SourceControlledFile } from '@n8n/api-types';
import { Logger } from '@n8n/backend-common';
import { FolderRepository, TagRepository, WorkflowTagMappingRepository, SharedCredentialsRepository, SharedWorkflowRepository, WorkflowRepository } from '@n8n/db';
import { InstanceSettings } from 'n8n-core';
import { SourceControlScopedService } from './source-control-scoped.service';
import type { ExportResult } from './types/export-result';
import type { SourceControlContext } from './types/source-control-context';
import { VariablesService } from '../variables/variables.service.ee';
export declare class SourceControlExportService {
    private readonly logger;
    private readonly variablesService;
    private readonly tagRepository;
    private readonly sharedCredentialsRepository;
    private readonly sharedWorkflowRepository;
    private readonly workflowRepository;
    private readonly workflowTagMappingRepository;
    private readonly folderRepository;
    private readonly sourceControlScopedService;
    private gitFolder;
    private workflowExportFolder;
    private credentialExportFolder;
    constructor(logger: Logger, variablesService: VariablesService, tagRepository: TagRepository, sharedCredentialsRepository: SharedCredentialsRepository, sharedWorkflowRepository: SharedWorkflowRepository, workflowRepository: WorkflowRepository, workflowTagMappingRepository: WorkflowTagMappingRepository, folderRepository: FolderRepository, sourceControlScopedService: SourceControlScopedService, instanceSettings: InstanceSettings);
    getWorkflowPath(workflowId: string): string;
    getCredentialsPath(credentialsId: string): string;
    deleteRepositoryFolder(): Promise<void>;
    rmFilesFromExportFolder(filesToBeDeleted: Set<string>): Set<string>;
    private writeExportableWorkflowsToExportFolder;
    exportWorkflowsToWorkFolder(candidates: SourceControlledFile[]): Promise<ExportResult>;
    exportVariablesToWorkFolder(): Promise<ExportResult>;
    exportFoldersToWorkFolder(context: SourceControlContext): Promise<ExportResult>;
    exportTagsToWorkFolder(context: SourceControlContext): Promise<ExportResult>;
    private replaceCredentialData;
    exportCredentialsToWorkFolder(candidates: SourceControlledFile[]): Promise<ExportResult>;
}
