import { Logger } from '@n8n/backend-common';
import type { InstalledPackages } from '@n8n/db';
import { InstalledPackagesRepository } from '@n8n/db';
import { InstanceSettings } from 'n8n-core';
import { type PublicInstalledPackage } from 'n8n-workflow';
import { License } from '../license';
import { LoadNodesAndCredentials } from '../load-nodes-and-credentials';
import { Publisher } from '../scaling/pubsub/publisher.service';
import { CommunityPackagesConfig } from './community-packages.config';
import type { CommunityPackages } from './community-packages.types';
export declare class CommunityPackagesService {
    private readonly instanceSettings;
    private readonly logger;
    private readonly installedPackageRepository;
    private readonly loadNodesAndCredentials;
    private readonly publisher;
    private readonly license;
    private readonly config;
    reinstallMissingPackages: boolean;
    missingPackages: string[];
    private readonly downloadFolder;
    private readonly packageJsonPath;
    constructor(instanceSettings: InstanceSettings, logger: Logger, installedPackageRepository: InstalledPackagesRepository, loadNodesAndCredentials: LoadNodesAndCredentials, publisher: Publisher, license: License, config: CommunityPackagesConfig);
    init(): Promise<void>;
    get hasMissingPackages(): boolean;
    findInstalledPackage(packageName: string): Promise<InstalledPackages | null>;
    isPackageInstalled(packageName: string): Promise<boolean>;
    getAllInstalledPackages(): Promise<InstalledPackages[]>;
    private removePackageFromDatabase;
    private persistInstalledPackage;
    parseNpmPackageName(rawString?: string): CommunityPackages.ParsedPackageName;
    executeNpmCommand(command: string, options?: {
        doNotHandleError?: boolean;
    }): Promise<string>;
    matchPackagesWithUpdates(packages: InstalledPackages[], updates?: CommunityPackages.AvailableUpdates): InstalledPackages[] | PublicInstalledPackage[];
    matchMissingPackages(installedPackages: PublicInstalledPackage[]): PublicInstalledPackage[];
    checkNpmPackageStatus(packageName: string): Promise<CommunityPackages.PackageStatusCheck | {
        status: string;
    }>;
    hasPackageLoaded(packageName: string): boolean;
    removePackageFromMissingList(packageName: string): void;
    ensurePackageJson(): Promise<void>;
    checkForMissingPackages(): Promise<void>;
    installPackage(packageName: string, version?: string, checksum?: string): Promise<InstalledPackages>;
    updatePackage(packageName: string, installedPackage: InstalledPackages, version?: string, checksum?: string): Promise<InstalledPackages>;
    removePackage(packageName: string, installedPackage: InstalledPackages): Promise<void>;
    private getNpmRegistry;
    private getNpmInstallArgs;
    private checkInstallPermissions;
    private installOrUpdatePackage;
    handleInstallEvent({ packageName, packageVersion, }: {
        packageName: string;
        packageVersion: string;
    }): Promise<void>;
    handleUninstallEvent({ packageName }: {
        packageName: string;
    }): Promise<void>;
    private installOrUpdateNpmPackage;
    private removeNpmPackage;
    private resolvePackageDirectory;
    private downloadPackage;
    private deletePackageDirectory;
    updatePackageJsonDependency(packageName: string, version: string): Promise<void>;
}
