import type { User } from '@n8n/db';
import type { IWorkflowBase } from 'n8n-workflow';
import { z } from 'zod';
import { BaseCommand } from './base-command';
import type { IExecutionResult, IResult, IWorkflowExecutionProgress } from '../types/commands.types';
declare const flagsSchema: z.ZodObject<{
    debug: z.ZodDefault<z.ZodBoolean>;
    ids: z.ZodOptional<z.ZodString>;
    concurrency: z.ZodDefault<z.ZodNumber>;
    output: z.ZodOptional<z.ZodString>;
    snapshot: z.ZodOptional<z.ZodString>;
    compare: z.ZodOptional<z.ZodString>;
    shallow: z.ZodOptional<z.ZodBoolean>;
    githubWorkflow: z.ZodOptional<z.ZodBoolean>;
    skipList: z.ZodOptional<z.ZodString>;
    retries: z.ZodDefault<z.ZodNumber>;
    shortOutput: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    debug: boolean;
    concurrency: number;
    retries: number;
    output?: string | undefined;
    ids?: string | undefined;
    snapshot?: string | undefined;
    compare?: string | undefined;
    shallow?: boolean | undefined;
    githubWorkflow?: boolean | undefined;
    skipList?: string | undefined;
    shortOutput?: boolean | undefined;
}, {
    debug?: boolean | undefined;
    concurrency?: number | undefined;
    output?: string | undefined;
    ids?: string | undefined;
    snapshot?: string | undefined;
    compare?: string | undefined;
    shallow?: boolean | undefined;
    githubWorkflow?: boolean | undefined;
    skipList?: string | undefined;
    retries?: number | undefined;
    shortOutput?: boolean | undefined;
}>;
export declare class ExecuteBatch extends BaseCommand<z.infer<typeof flagsSchema>> {
    static cancelled: boolean;
    static workflowExecutionsProgress: IWorkflowExecutionProgress[][];
    static shallow: boolean;
    static compare: string;
    static snapshot: string;
    static concurrency: number;
    static githubWorkflow: boolean;
    static debug: boolean;
    static executionTimeout: number;
    static instanceOwner: User;
    static aliases: string[];
    needsCommunityPackages: boolean;
    needsTaskRunner: boolean;
    stopProcess(skipExit?: boolean | number): Promise<void>;
    private formatJsonOutput;
    private shouldBeConsideredAsWarning;
    init(): Promise<void>;
    run(): Promise<void>;
    mergeResults(results: IResult, retryResults: IResult): void;
    private runTests;
    setOutput(key: string, value: any): void;
    updateStatus(): void;
    initializeLogs(): void;
    startThread(workflowData: IWorkflowBase): Promise<IExecutionResult>;
}
export {};
