import 'reflect-metadata';
import { Logger, ModuleRegistry, ModulesConfig } from '@n8n/backend-common';
import { GlobalConfig } from '@n8n/config';
import { DbConnection } from '@n8n/db';
import { InstanceSettings, ErrorReporter } from 'n8n-core';
import type { AbstractServer } from '../abstract-server';
import { ExternalHooks } from '../external-hooks';
import { License } from '../license';
import { NodeTypes } from '../node-types';
import { ShutdownService } from '../shutdown/shutdown.service';
export declare abstract class BaseCommand<F = never> {
    readonly flags: F;
    protected logger: Logger;
    protected dbConnection: DbConnection;
    protected errorReporter: ErrorReporter;
    protected externalHooks?: ExternalHooks;
    protected nodeTypes: NodeTypes;
    protected instanceSettings: InstanceSettings;
    protected server?: AbstractServer;
    protected shutdownService: ShutdownService;
    protected license: License;
    protected readonly globalConfig: GlobalConfig;
    protected readonly modulesConfig: ModulesConfig;
    protected readonly moduleRegistry: ModuleRegistry;
    protected gracefulShutdownTimeoutInS: number;
    protected needsCommunityPackages: boolean;
    protected needsTaskRunner: boolean;
    init(): Promise<void>;
    protected stopProcess(): Promise<void>;
    protected initCrashJournal(): Promise<void>;
    protected exitSuccessFully(): Promise<void>;
    protected exitWithCrash(message: string, error: unknown): Promise<void>;
    protected log(message: string): void;
    protected error(message: string): void;
    initObjectStoreService(): Promise<undefined>;
    initBinaryDataService(): Promise<void>;
    protected initDataDeduplicationService(): Promise<void>;
    initExternalHooks(): Promise<void>;
    initLicense(): Promise<void>;
    initWorkflowHistory(): void;
    cleanupTestRunner(): Promise<void>;
    finally(error: Error | undefined): Promise<void>;
    protected onTerminationSignal(signal: string): () => Promise<void>;
}
