import { Logger } from '@n8n/backend-common';
import { WorkflowsConfig } from '@n8n/config';
import type { WorkflowEntity, IWorkflowDb } from '@n8n/db';
import { WorkflowRepository } from '@n8n/db';
import { ActiveWorkflows, ErrorReporter, InstanceSettings, type IGetExecutePollFunctions, type IGetExecuteTriggerFunctions } from 'n8n-core';
import type { ExecutionError, IWorkflowBase, IWorkflowExecuteAdditionalData, WorkflowActivateMode, WorkflowExecuteMode, WorkflowId } from 'n8n-workflow';
import { Workflow } from 'n8n-workflow';
import { ActivationErrorsService } from './activation-errors.service';
import { ActiveExecutions } from './active-executions';
import { ExecutionService } from './executions/execution.service';
import { ExternalHooks } from './external-hooks';
import { NodeTypes } from './node-types';
import { Push } from './push';
import { Publisher } from './scaling/pubsub/publisher.service';
import { ActiveWorkflowsService } from './services/active-workflows.service';
import { WebhookService } from './webhooks/webhook.service';
import { WorkflowExecutionService } from './workflows/workflow-execution.service';
import { WorkflowStaticDataService } from './workflows/workflow-static-data.service';
export declare class ActiveWorkflowManager {
    private readonly logger;
    private readonly errorReporter;
    private readonly activeWorkflows;
    private readonly activeExecutions;
    private readonly externalHooks;
    private readonly nodeTypes;
    private readonly webhookService;
    private readonly workflowRepository;
    private readonly activationErrorsService;
    private readonly executionService;
    private readonly workflowStaticDataService;
    private readonly activeWorkflowsService;
    private readonly workflowExecutionService;
    private readonly instanceSettings;
    private readonly publisher;
    private readonly workflowsConfig;
    private readonly push;
    private queuedActivations;
    constructor(logger: Logger, errorReporter: ErrorReporter, activeWorkflows: ActiveWorkflows, activeExecutions: ActiveExecutions, externalHooks: ExternalHooks, nodeTypes: NodeTypes, webhookService: WebhookService, workflowRepository: WorkflowRepository, activationErrorsService: ActivationErrorsService, executionService: ExecutionService, workflowStaticDataService: WorkflowStaticDataService, activeWorkflowsService: ActiveWorkflowsService, workflowExecutionService: WorkflowExecutionService, instanceSettings: InstanceSettings, publisher: Publisher, workflowsConfig: WorkflowsConfig, push: Push);
    init(): Promise<void>;
    getAllWorkflowActivationErrors(): Promise<import("./services/cache/cache.types").Hash<string>>;
    removeAll(): Promise<void>;
    allActiveInMemory(): string[];
    isActive(workflowId: WorkflowId): Promise<boolean>;
    addWebhooks(workflow: Workflow, additionalData: IWorkflowExecuteAdditionalData, mode: WorkflowExecuteMode, activation: WorkflowActivateMode): Promise<boolean>;
    clearWebhooks(workflowId: WorkflowId): Promise<void>;
    getExecutePollFunctions(workflowData: IWorkflowDb, additionalData: IWorkflowExecuteAdditionalData, mode: WorkflowExecuteMode, activation: WorkflowActivateMode): IGetExecutePollFunctions;
    getExecuteTriggerFunctions(workflowData: IWorkflowDb, additionalData: IWorkflowExecuteAdditionalData, mode: WorkflowExecuteMode, activation: WorkflowActivateMode): IGetExecuteTriggerFunctions;
    executeErrorWorkflow(error: ExecutionError, workflowData: IWorkflowBase, mode: WorkflowExecuteMode): void;
    private isActivationInProgress;
    addActiveWorkflows(activationMode: 'init' | 'leadershipChange'): Promise<void>;
    private activateWorkflow;
    clearAllActivationErrors(): Promise<void>;
    addAllTriggerAndPollerBasedWorkflows(): Promise<void>;
    removeAllTriggerAndPollerBasedWorkflows(): Promise<void>;
    add(workflowId: WorkflowId, activationMode: WorkflowActivateMode, existingWorkflow?: WorkflowEntity, { shouldPublish }?: {
        shouldPublish: boolean;
    }): Promise<{
        webhooks: boolean;
        triggersAndPollers: boolean;
    }>;
    handleDisplayWorkflowActivation({ workflowId }: {
        workflowId: string;
    }): void;
    handleDisplayWorkflowDeactivation({ workflowId }: {
        workflowId: string;
    }): void;
    handleDisplayWorkflowActivationError({ workflowId, errorMessage, }: {
        workflowId: string;
        errorMessage: string;
    }): void;
    handleAddWebhooksTriggersAndPollers({ workflowId }: {
        workflowId: string;
    }): Promise<void>;
    checkIfWorkflowCanBeActivated(workflow: Workflow, ignoreNodeTypes?: string[]): boolean;
    private countTriggers;
    private addQueuedWorkflowActivation;
    private removeQueuedWorkflowActivation;
    removeAllQueuedWorkflowActivations(): void;
    remove(workflowId: WorkflowId): Promise<void>;
    handleRemoveTriggersAndPollers({ workflowId }: {
        workflowId: string;
    }): Promise<void>;
    removeWorkflowTriggersAndPollers(workflowId: WorkflowId): Promise<void>;
    addTriggersAndPollers(dbWorkflow: WorkflowEntity, workflow: Workflow, { activationMode, executionMode, additionalData, }: {
        activationMode: WorkflowActivateMode;
        executionMode: WorkflowExecuteMode;
        additionalData: IWorkflowExecuteAdditionalData;
    }): Promise<boolean>;
    removeActivationError(workflowId: WorkflowId): Promise<void>;
    shouldAddWebhooks(activationMode: WorkflowActivateMode): boolean;
    shouldAddTriggersAndPollers(): boolean;
}
